/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.UnsupportedEncodingException;
import php.java.bridge.Util;

public class Options {
    protected byte options = 0;
    private String encoding = null;
    private boolean base64Cache;
    private boolean base64CacheSet = false;
    private boolean contextCache;
    private boolean contextCacheSet = false;

    public String getEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        this.encoding = "UTF-8";
        return "UTF-8";
    }

    public byte[] getBytes(String string) {
        try {
            return string.getBytes(this.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Util.printStackTrace(unsupportedEncodingException);
            return string.getBytes();
        }
    }

    public boolean sendArraysAsValues() {
        return (this.options & 3) == 2;
    }

    public boolean preferValues() {
        return this.sendArraysAsValues();
    }

    protected void recycle() {
        this.encoding = null;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void updateOptions(byte by) {
        this.encoding = null;
        this.options = by;
    }

    public boolean base64Data() {
        if (!this.base64CacheSet) {
            int n = 3 & this.options;
            this.base64CacheSet = true;
            this.base64Cache = n == 3;
            return this.base64Cache;
        }
        return this.base64Cache;
    }

    public boolean passContext() {
        if (!this.contextCacheSet) {
            int n = 3 & this.options;
            this.contextCacheSet = true;
            this.contextCache = n != 3 && n != 0;
            return this.contextCache;
        }
        return this.contextCache;
    }
}

