/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import php.java.bridge.AppThreadPool;
import php.java.bridge.IDocHandler;
import php.java.bridge.IntegerComparator;
import php.java.bridge.JavaBridge;
import php.java.bridge.Parser;
import php.java.bridge.ParserString;
import php.java.bridge.ParserTag;
import php.java.bridge.PhpArray;
import php.java.bridge.PhpExactNumber;
import php.java.bridge.PhpParserString;
import php.java.bridge.Response;
import php.java.bridge.Util;

public final class Request
implements IDocHandler {
    private Parser parser;
    private JavaBridge defaultBridge;
    private JavaBridge bridge;
    protected static final IntegerComparator PHP_ARRAY_KEY_COMPARATOR = new IntegerComparator();
    protected static final PhpNull PHPNULL = new PhpNull();
    static final Object[] ZERO_ARGS = new Object[0];
    private SimpleContext contextCache;
    private Arg arg;
    public Response response = null;
    static final byte[] ZERO = new byte[]{0};
    static final Object ZERO_OBJECT = new Object();
    private static final String SUB_FAILED = "PHP callback execution failed.";

    protected Object getGlobalRef(int n) {
        Object object = this.bridge.globalRef.get(n);
        if (object == PHPNULL) {
            return null;
        }
        return object;
    }

    SimpleContext getContext() {
        if (this.contextCache != null) {
            return this.contextCache;
        }
        if (this.bridge.options.passContext()) {
            this.contextCache = new Context();
            return this.contextCache;
        }
        this.contextCache = new SimpleContext();
        return this.contextCache;
    }

    public Request(JavaBridge javaBridge) {
        this.bridge = javaBridge;
        this.parser = new Parser(javaBridge, this);
    }

    public boolean init(InputStream inputStream, OutputStream outputStream) throws IOException {
        switch (this.parser.initOptions(inputStream)) {
            case 1: {
                this.bridge.logDebug("PING - PONG - Closing Request");
                outputStream.write(ZERO, 0, 1);
                return false;
            }
            case 3: {
                this.bridge.logDebug("IO_ERROR - Closing Request");
                return false;
            }
            case 2: {
                this.bridge.logDebug("EOF - Closing Request");
                return false;
            }
        }
        return true;
    }

    private long getClassicPhpLong(ParserString[] parserStringArray) {
        return parserStringArray[0].getClassicLongValue();
    }

    private Object createClassicExact(ParserString[] parserStringArray) {
        return new Integer(parserStringArray[0].getClassicIntValue());
    }

    private long getPhpLong(ParserString[] parserStringArray) {
        long l = parserStringArray[0].getLongValue();
        if (parserStringArray[1].string[parserStringArray[1].off] != 79) {
            l *= -1L;
        }
        return l;
    }

    private Object createExact(ParserString[] parserStringArray) {
        int n = parserStringArray[0].getIntValue();
        if (parserStringArray[1].string[parserStringArray[1].off] != 79) {
            n *= -1;
        }
        return new Integer(n);
    }

    public boolean begin(ParserTag[] parserTagArray) {
        boolean bl = true;
        ParserString[] parserStringArray = parserTagArray[2].strings;
        byte by = parserTagArray[0].strings[0].string[0];
        switch (by) {
            case 71: 
            case 89: {
                this.arg.type = by;
                this.arg.predicate = parserStringArray[0].string[parserStringArray[0].off];
                int n = parserStringArray[1].getIntValue();
                this.arg.callObject = n == 0 ? this.bridge : this.getGlobalRef(n);
                this.arg.method = parserStringArray[2].getCachedStringValue();
                this.arg.id.parseID(parserStringArray[3]);
                break;
            }
            case 73: {
                this.arg.type = by;
                int n = parserStringArray[0].getIntValue();
                this.arg.callObject = n == 0 ? this.bridge : this.getGlobalRef(n);
                this.arg.method = parserStringArray[1].getCachedStringValue();
                this.arg.predicate = parserStringArray[2].string[parserStringArray[2].off];
                this.arg.id.parseID(parserStringArray[3]);
                break;
            }
            case 72: 
            case 75: {
                this.arg.type = by;
                this.arg.predicate = parserStringArray[0].string[parserStringArray[0].off];
                this.arg.callObject = parserStringArray[1].getCachedStringValue();
                this.arg.id.parseID(parserStringArray[2]);
                break;
            }
            case 67: {
                this.arg.type = by;
                this.arg.callObject = parserStringArray[0].getCachedStringValue();
                this.arg.predicate = parserStringArray[1].string[parserStringArray[1].off];
                this.arg.id.parseID(parserStringArray[2]);
                break;
            }
            case 70: {
                this.arg.type = by;
                this.arg.predicate = parserStringArray[0].string[parserStringArray[0].off];
                break;
            }
            case 82: {
                this.arg.type = by;
                this.arg.id.parseID(parserStringArray[0]);
                break;
            }
            case 88: {
                this.arg = new CompositeArg(this.arg);
                this.arg.composite = parserStringArray[0].string[parserStringArray[0].off];
                break;
            }
            case 80: {
                if (this.arg.composite == 72) {
                    if (parserStringArray[0].string[parserStringArray[0].off] == 83) {
                        this.arg.key = parserStringArray[1].getCachedStringValue();
                        break;
                    }
                    this.arg.key = new Integer(parserStringArray[1].getIntValue());
                    break;
                }
                this.arg.key = null;
                break;
            }
            case 85: {
                int n = parserStringArray[0].getIntValue();
                if (Util.logLevel > 4) {
                    Util.logDebug("unref: " + this.bridge.globalRef.get(n));
                }
                this.bridge.globalRef.remove(n);
                bl = false;
                break;
            }
            case 83: {
                if (parserTagArray[2].n <= 0) break;
                if (this.arg.composite != 72) {
                    this.arg.add(new PhpParserString(this.bridge, parserStringArray[0]));
                    break;
                }
                this.arg.add(parserStringArray[0].getStringValue());
                break;
            }
            case 66: {
                this.arg.add(new Boolean(parserStringArray[0].string[parserStringArray[0].off] == 84));
                break;
            }
            case 84: {
                this.arg.add(new Boolean(parserStringArray[0].string[parserStringArray[0].off] == 49));
                break;
            }
            case 76: {
                if (this.arg.composite != 72) {
                    this.arg.add(new PhpExactNumber(this.getPhpLong(parserStringArray)));
                    break;
                }
                this.arg.add(this.createExact(parserStringArray));
                break;
            }
            case 74: {
                if (this.arg.composite != 72) {
                    this.arg.add(new PhpExactNumber(this.getClassicPhpLong(parserStringArray)));
                    break;
                }
                this.arg.add(this.createClassicExact(parserStringArray));
                break;
            }
            case 68: {
                this.arg.add(new Double(parserStringArray[0].getDoubleValue()));
                break;
            }
            case 69: {
                if (0 == parserStringArray[0].length) {
                    this.arg.callObject = new Exception(parserStringArray[1].getStringValue());
                    break;
                }
                int n = parserStringArray[0].getIntValue();
                if (0 == n) {
                    this.arg.callObject = new Exception(parserStringArray[1].getStringValue());
                    break;
                }
                this.arg.callObject = this.getGlobalRef(n);
                break;
            }
            case 79: {
                if (0 == parserStringArray[0].length) {
                    this.arg.add(null);
                    break;
                }
                int n = parserStringArray[0].getIntValue();
                if (0 == n) {
                    this.arg.add(null);
                    break;
                }
                this.arg.add(this.getGlobalRef(n));
            }
        }
        return bl;
    }

    public void end(ParserString[] parserStringArray) {
        switch (parserStringArray[0].string[0]) {
            case 88: {
                this.arg = ((CompositeArg)this.arg).pop();
            }
        }
    }

    private void setIllegalStateException(String string) {
        IllegalStateException illegalStateException = new IllegalStateException(string);
        this.bridge.lastException = illegalStateException;
        this.response.setResultException(this.bridge.lastException, string);
    }

    private int handleRequest() throws IOException {
        short s = this.parser.parse(this.bridge.in);
        if (0 == s) {
            this.arg.id.setID(this.response);
            switch (this.arg.type) {
                case 73: {
                    try {
                        switch (this.arg.predicate) {
                            case 80: {
                                this.bridge.GetSetProp(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                                break;
                            }
                            case 73: {
                                this.bridge.Invoke(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                                break;
                            }
                            default: {
                                throw new IOException("Protocol error");
                            }
                        }
                        this.response.flush();
                    }
                    catch (AbortException abortException) {
                        this.bridge.printStackTrace(abortException);
                    }
                    break;
                }
                case 71: {
                    try {
                        switch (this.arg.predicate) {
                            case 50: {
                                this.response.setAsyncWriter();
                            }
                            case 49: {
                                this.bridge.GetSetProp(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                                break;
                            }
                            case 51: {
                                this.response.setAsyncNullWriter();
                                this.bridge.GetSetProp(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                                break;
                            }
                            default: {
                                throw new IOException("Protocol error");
                            }
                        }
                        this.response.flush();
                    }
                    catch (AbortException abortException) {
                        this.bridge.printStackTrace(abortException);
                    }
                    break;
                }
                case 89: {
                    try {
                        switch (this.arg.predicate) {
                            case 50: {
                                this.response.setAsyncWriter();
                            }
                            case 49: {
                                this.bridge.Invoke(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                                break;
                            }
                            case 51: {
                                this.response.setAsyncNullWriter();
                                this.bridge.Invoke(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                                break;
                            }
                            default: {
                                throw new IOException("Protocol error");
                            }
                        }
                        this.response.flush();
                    }
                    catch (AbortException abortException) {
                        this.bridge.printStackTrace(abortException);
                    }
                    break;
                }
                case 67: {
                    try {
                        switch (this.arg.predicate) {
                            case 67: {
                                this.bridge.CreateObject((String)this.arg.callObject, false, this.arg.getArgs(), this.response);
                                break;
                            }
                            case 73: {
                                this.bridge.CreateObject((String)this.arg.callObject, true, this.arg.getArgs(), this.response);
                                break;
                            }
                            default: {
                                throw new IOException("Protocol error");
                            }
                        }
                        this.response.flush();
                    }
                    catch (AbortException abortException) {
                        this.bridge.printStackTrace(abortException);
                    }
                    break;
                }
                case 72: {
                    try {
                        switch (this.arg.predicate) {
                            case 50: {
                                this.response.setAsyncWriter();
                            }
                            case 49: {
                                this.bridge.CreateObject((String)this.arg.callObject, false, this.arg.getArgs(), this.response);
                                break;
                            }
                            case 51: {
                                this.response.setAsyncNullWriter();
                                this.bridge.CreateObject((String)this.arg.callObject, false, this.arg.getArgs(), this.response);
                                break;
                            }
                            default: {
                                throw new IOException("Protocol error");
                            }
                        }
                        this.response.flush();
                    }
                    catch (AbortException abortException) {
                        this.bridge.printStackTrace(abortException);
                    }
                    break;
                }
                case 75: {
                    try {
                        switch (this.arg.predicate) {
                            case 50: {
                                this.response.setAsyncWriter();
                            }
                            case 49: {
                                this.bridge.CreateObject((String)this.arg.callObject, true, this.arg.getArgs(), this.response);
                                break;
                            }
                            case 51: {
                                this.response.setAsyncNullWriter();
                                this.bridge.CreateObject((String)this.arg.callObject, true, this.arg.getArgs(), this.response);
                                break;
                            }
                            default: {
                                throw new IOException("Protocol error");
                            }
                        }
                        this.response.flush();
                    }
                    catch (AbortException abortException) {
                        this.bridge.printStackTrace(abortException);
                    }
                    break;
                }
                case 70: {
                    if (this.arg.predicate == 65) {
                        this.bridge.recycle();
                        try {
                            ((AppThreadPool.Delegate)Thread.currentThread()).setPersistent();
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                        this.response.setFinish(true);
                    } else {
                        this.response.setFinish(false);
                    }
                    this.response.flush();
                    break;
                }
                case 82: {
                    this.setIllegalStateException(SUB_FAILED);
                    this.response.flush();
                }
            }
            this.arg.reset();
        }
        return s;
    }

    public void handleRequests() throws IOException {
        if (this.response == null) {
            this.response = this.bridge.createResponse();
        }
        this.arg = new SimpleArg();
        while (0 == this.handleRequest()) {
        }
    }

    protected Object[] handleSubRequests() throws AbortException, IOException, Throwable {
        Response response = this.response;
        Arg arg = this.arg;
        this.response = this.response.copyResponse();
        this.arg = new SimpleArg();
        while (0 == this.parser.parse(this.bridge.in)) {
            this.arg.id.setID(this.response);
            switch (this.arg.type) {
                case 73: {
                    switch (this.arg.predicate) {
                        case 80: {
                            this.bridge.GetSetProp(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                            break;
                        }
                        case 73: {
                            this.bridge.Invoke(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                            break;
                        }
                        default: {
                            throw new IOException("Protocol error");
                        }
                    }
                    this.response.flush();
                    break;
                }
                case 71: {
                    switch (this.arg.predicate) {
                        case 50: {
                            this.response.setAsyncWriter();
                        }
                        case 49: {
                            this.bridge.GetSetProp(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                            break;
                        }
                        case 51: {
                            this.response.setAsyncNullWriter();
                            this.bridge.GetSetProp(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                            break;
                        }
                        default: {
                            throw new IOException("Protocol error");
                        }
                    }
                    this.response.flush();
                    break;
                }
                case 89: {
                    switch (this.arg.predicate) {
                        case 50: {
                            this.response.setAsyncWriter();
                        }
                        case 49: {
                            this.bridge.Invoke(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                            break;
                        }
                        case 51: {
                            this.response.setAsyncNullWriter();
                            this.bridge.Invoke(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                            break;
                        }
                        default: {
                            throw new IOException("Protocol error");
                        }
                    }
                    this.response.flush();
                    break;
                }
                case 67: {
                    switch (this.arg.predicate) {
                        case 67: {
                            this.bridge.CreateObject((String)this.arg.callObject, false, this.arg.getArgs(), this.response);
                            break;
                        }
                        case 73: {
                            this.bridge.CreateObject((String)this.arg.callObject, true, this.arg.getArgs(), this.response);
                            break;
                        }
                        default: {
                            throw new IOException("Protocol error");
                        }
                    }
                    this.response.flush();
                    break;
                }
                case 72: {
                    switch (this.arg.predicate) {
                        case 50: {
                            this.response.setAsyncWriter();
                        }
                        case 49: {
                            this.bridge.CreateObject((String)this.arg.callObject, false, this.arg.getArgs(), this.response);
                            break;
                        }
                        case 51: {
                            this.response.setAsyncNullWriter();
                            this.bridge.CreateObject((String)this.arg.callObject, false, this.arg.getArgs(), this.response);
                            break;
                        }
                        default: {
                            throw new IOException("Protocol error");
                        }
                    }
                    this.response.flush();
                    break;
                }
                case 75: {
                    switch (this.arg.predicate) {
                        case 50: {
                            this.response.setAsyncWriter();
                        }
                        case 49: {
                            this.bridge.CreateObject((String)this.arg.callObject, true, this.arg.getArgs(), this.response);
                            break;
                        }
                        case 51: {
                            this.response.setAsyncNullWriter();
                            this.bridge.CreateObject((String)this.arg.callObject, true, this.arg.getArgs(), this.response);
                            break;
                        }
                        default: {
                            throw new IOException("Protocol error");
                        }
                    }
                    this.response.flush();
                    break;
                }
                case 70: {
                    if (this.arg.predicate == 65) {
                        this.bridge.recycle();
                        try {
                            ((AppThreadPool.Delegate)Thread.currentThread()).setPersistent();
                            this.response.setFinish(true);
                        }
                        catch (ClassCastException classCastException) {
                            this.response.setFinish(false);
                        }
                    } else {
                        this.response.setFinish(false);
                    }
                    this.response.flush();
                    this.response = response;
                    this.arg = arg;
                    throw new AbortException();
                }
                case 82: {
                    Arg arg2 = this.arg;
                    this.arg = arg;
                    this.response.reset();
                    this.response = response;
                    if (arg2.callObject != null) {
                        throw (Throwable)arg2.callObject;
                    }
                    return arg2.getArgs();
                }
            }
            this.arg.reset();
        }
        this.arg = arg;
        this.response = response;
        throw new AbortException();
    }

    public void reset() {
        this.parser.reset();
    }

    public void setBridge(JavaBridge javaBridge) {
        this.defaultBridge = this.bridge;
        javaBridge.in = this.bridge.in;
        javaBridge.out = this.bridge.out;
        this.bridge = javaBridge;
        this.bridge.request = this;
        this.response.setBridge(javaBridge);
        this.parser.setBridge(javaBridge);
        javaBridge.getClassLoader().switcheThreadContextClassLoader();
    }

    private void resetBridge() {
        if (this.defaultBridge != null) {
            this.bridge = this.defaultBridge;
            this.response.setBridge(this.bridge);
            this.parser.setBridge(this.bridge);
            this.defaultBridge = null;
        }
    }

    public void recycle() {
        this.reset();
        this.arg.reset();
        this.resetBridge();
        this.response.recycle();
    }

    public ParserString createParserString() {
        return new ParserString(this.bridge);
    }

    public static class AbortException
    extends RuntimeException {
        private static final long serialVersionUID = 7778150395848350732L;
    }

    private final class CompositeArg
    extends Arg {
        private PhpArray ht;
        private int count;
        private Arg parent;

        public CompositeArg(Arg arg) {
            this.ht = null;
            this.count = 0;
            this.parent = arg;
        }

        public void add(Object object) {
            if (this.ht == null) {
                this.ht = new PhpArray();
            }
            if (this.key != null) {
                this.ht.put(this.key, object);
            } else {
                this.ht.put(new Integer(this.count++), object);
            }
        }

        protected Arg pop() {
            if (this.ht == null) {
                this.ht = new PhpArray();
            }
            this.parent.add(this.ht);
            return this.parent;
        }

        public Object[] getArgs() {
            Request.this.bridge.logError("Protocol error: getArgs");
            return ZERO_ARGS;
        }

        public void reset() {
            Request.this.bridge.logError("Protocol error: reset");
        }
    }

    private final class SimpleArg
    extends Arg {
        private LinkedList list;

        private SimpleArg() {
        }

        public void add(Object object) {
            if (this.list == null) {
                this.list = new LinkedList();
            }
            this.list.add(object);
        }

        public Object[] getArgs() {
            return this.list == null ? ZERO_ARGS : this.list.toArray();
        }

        public void reset() {
            this.list = null;
            this.composite = 0;
            this.type = 0;
            this.callObject = null;
            this.method = null;
            this.key = null;
        }
    }

    private abstract class Arg {
        protected byte type;
        protected Object callObject;
        protected Throwable exception;
        protected String method;
        protected SimpleContext id;
        protected byte predicate;
        protected Object key;
        protected byte composite;
        protected int globalRefCID;

        private Arg() {
            this.id = Request.this.getContext();
        }

        public abstract void add(Object var1);

        public abstract Object[] getArgs();

        public abstract void reset();
    }

    private class Context
    extends SimpleContext {
        protected long id;

        private Context() {
        }

        public void parseID(ParserString parserString) {
            this.id = parserString.getLongValue();
        }

        public void setID(Response response) {
            response.setID(this.id);
        }
    }

    private class SimpleContext {
        private SimpleContext() {
        }

        public void parseID(ParserString parserString) {
        }

        public void setID(Response response) {
        }
    }

    protected static final class PhpNull {
        protected PhpNull() {
        }
    }
}

