/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import php.java.bridge.DynamicJavaBridgeClassLoader;
import php.java.bridge.JarLibraryPath;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;

public class SimpleJavaBridgeClassLoader {
    protected DynamicJavaBridgeClassLoader cl = null;
    protected ClassLoader scl = null;
    private static final Map map = Collections.synchronizedMap(new HashMap());
    private static final URL[] urlArray = SimpleJavaBridgeClassLoader.getUrlArray();
    protected JarLibraryPath cachedPath;

    public static final ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (classLoader == null) {
            classLoader = JavaBridge.class.getClassLoader();
        }
        return classLoader;
    }

    public static ClassLoader getDefaultClassLoader(ClassLoader classLoader) {
        ClassLoader classLoader2 = (ClassLoader)map.get(classLoader);
        if (classLoader2 != null) {
            return classLoader2;
        }
        try {
            URL[] uRLArray = urlArray;
            if (uRLArray != null && uRLArray.length > 0) {
                classLoader2 = new URLClassLoader(uRLArray, classLoader);
                map.put(classLoader, classLoader2);
            } else {
                classLoader2 = classLoader;
                map.put(classLoader, classLoader2);
            }
        }
        catch (Exception exception) {
            Util.printStackTrace(exception);
            classLoader2 = classLoader;
            map.put(classLoader, classLoader2);
        }
        return classLoader2;
    }

    private static URL[] getUrlArray() {
        URL[] uRLArray = null;
        try {
            uRLArray = SimpleJavaBridgeClassLoader.buildUrlArray();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return uRLArray;
    }

    private static URL[] buildUrlArray() throws MalformedURLException {
        File file;
        CharSequence charSequence;
        LinkedList<URL> linkedList = new LinkedList<URL>();
        for (int i = 0; i < Util.DEFAULT_EXT_DIRS.length; ++i) {
            charSequence = Util.DEFAULT_EXT_DIRS[i];
            file = new File((String)charSequence);
            DynamicJavaBridgeClassLoader.addJars(linkedList, file);
            linkedList.add(new URL("file", null, file.getAbsolutePath() + "/"));
        }
        String string = Util.JAVABRIDGE_BASE;
        if (string != null && string.length() > 0) {
            charSequence = new StringBuffer(string);
            file = new File(((StringBuffer)charSequence).toString());
            if (!string.endsWith(File.separator)) {
                ((StringBuffer)charSequence).append(File.separator);
            }
            if (Util.HOME_DIR == null || Util.HOME_DIR != null && !Util.HOME_DIR.equals(file)) {
                DynamicJavaBridgeClassLoader.addJars(linkedList, file);
            }
            ((StringBuffer)charSequence).append("lib");
            file = new File(((StringBuffer)charSequence).toString());
            DynamicJavaBridgeClassLoader.addJars(linkedList, file);
            linkedList.add(new URL("file", null, file.getAbsolutePath() + "/"));
        }
        return linkedList.toArray(new URL[linkedList.size()]);
    }

    private SimpleJavaBridgeClassLoader(DynamicJavaBridgeClassLoader dynamicJavaBridgeClassLoader, ClassLoader classLoader) {
        this.cl = dynamicJavaBridgeClassLoader;
        if (this.cl == null) {
            this.scl = classLoader;
        } else {
            this.cl.clear();
        }
    }

    public SimpleJavaBridgeClassLoader() {
        this.scl = SimpleJavaBridgeClassLoader.getDefaultClassLoader(SimpleJavaBridgeClassLoader.getContextClassLoader());
    }

    public SimpleJavaBridgeClassLoader(ClassLoader classLoader) {
        this(null, classLoader);
    }

    protected boolean checkCl() {
        return this.cl != null;
    }

    protected void setClassLoader(DynamicJavaBridgeClassLoader dynamicJavaBridgeClassLoader) {
        if (dynamicJavaBridgeClassLoader == null) {
            this.cachedPath = null;
            this.cl = null;
            return;
        }
        if (this.cl != null) {
            throw new IllegalStateException("cl");
        }
        this.cl = dynamicJavaBridgeClassLoader;
        if (this.cachedPath != null) {
            this.cl.updateJarLibraryPath(this.cachedPath);
        }
    }

    public void updateJarLibraryPath(String string, String string2, String string3, String string4) throws IOException {
        if (!this.checkCl()) {
            DynamicJavaBridgeClassLoader dynamicJavaBridgeClassLoader = DynamicJavaBridgeClassLoader.newInstance(this.scl);
            this.setClassLoader(dynamicJavaBridgeClassLoader);
            try {
                Thread.currentThread().setContextClassLoader(dynamicJavaBridgeClassLoader);
            }
            catch (SecurityException securityException) {
                Util.printStackTrace(securityException);
            }
        }
        this.cl.updateJarLibraryPath(string, string2, string3, string4);
    }

    public ClassLoader getClassLoader() {
        if (this.checkCl()) {
            return this.cl;
        }
        return this.scl;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.scl;
    }

    protected void doReset() {
        this.cl.reset();
        this.cl = this.cl.clearVMLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.cl);
        }
        catch (SecurityException securityException) {
            Util.printStackTrace(securityException);
        }
    }

    public void reset() {
        if (this.checkCl()) {
            this.doReset();
        }
    }

    public Class forName(String string) throws ClassNotFoundException {
        if (!this.checkCl()) {
            return Class.forName(string, false, this.scl);
        }
        return Class.forName(string, false, this.cl);
    }

    protected void doClear() {
        this.cl.clear();
    }

    public void clear() {
        if (this.checkCl()) {
            this.doClear();
        }
    }

    protected void recycle() {
        this.cl = null;
        this.cachedPath = null;
        try {
            Thread.currentThread().setContextClassLoader(this.scl);
        }
        catch (SecurityException securityException) {
            Util.printStackTrace(securityException);
        }
    }

    public void switcheThreadContextClassLoader() {
        throw new IllegalStateException("Use the JavaBridgeClassLoader instead");
    }
}

