/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import javax.swing.JOptionPane;
import php.java.bridge.ISocketFactory;
import php.java.bridge.JavaBridge;
import php.java.bridge.JavaBridgeRunner;
import php.java.bridge.LocalServerSocket;
import php.java.bridge.TCPServerSocket;
import php.java.bridge.Util;

public class Standalone {
    static ISocketFactory bind(int n, String string) throws IOException {
        ISocketFactory iSocketFactory = null;
        try {
            iSocketFactory = LocalServerSocket.create(n, string, 20);
        }
        catch (Throwable throwable) {
            try {
                boolean bl = System.getProperty("php.java.bridge.promiscuous", "false").toLowerCase().equals("true");
                iSocketFactory = TCPServerSocket.create(bl ? "INET:0" : "INET_LOCAL:0", 20);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        if (null == iSocketFactory) {
            iSocketFactory = TCPServerSocket.create(string, 20);
        }
        if (null == iSocketFactory) {
            throw new IOException("Could not create socket: " + string);
        }
        return iSocketFactory;
    }

    protected static void disclaimer() {
        System.err.println("Copyright (C) 2003, 2006 Jost Boekemeier and others.");
        System.err.println("This is free software; see the source for copying conditions.  There is NO");
        System.err.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
    }

    private static void monoUsage() {
        System.err.println("PHP/Mono+NET Bridge version " + Util.VERSION);
        Standalone.disclaimer();
        System.err.println("Usage: MonoBridge.exe [SOCKETNAME LOGLEVEL LOGFILE]");
        System.err.println("Example: MonoBridge.exe");
        System.err.println("Example: MonoBridge.exe INET_LOCAL:0 3 MonoBridge.log");
    }

    protected void javaUsage() {
        System.err.println("PHP/Java Bridge version " + Util.VERSION);
        Standalone.disclaimer();
        System.err.println("Usage: java -jar JavaBridge.jar [SOCKETNAME LOGLEVEL LOGFILE]");
        System.err.println("SOCKETNAME is one of LOCAL, INET_LOCAL, INET, SERVLET_LOCAL, SERVLET");
        System.err.println("Example: java -jar JavaBridge.jar");
        System.err.println("Example: LD_LIBRARY_PATH=/usr/lib/php/modules/ java -jar JavaBridge.jar LOCAL:/tmp/javabridge_native.socket 3 /var/log/php-java-bridge.log");
        System.err.println("Example: java -jar JavaBridge.jar SERVLET_LOCAL:8080 3 JavaBridge.log");
        System.err.println("Influential system properties: threads, ext_java_compatibility, php_exec, default_log_file, default_log_level, base.");
        System.err.println("Example: java -Djava.awt.headless=\"true\" -Dphp.java.bridge.threads=50 -Dphp.java.bridge.base=/usr/lib/php/modules -Dphp.java.bridge.php_exec=/usr/local/bin/php-cgi -Dphp.java.bridge.default_log_file= -Dphp.java.bridge.default_log_level=5 -jar JavaBridge.jar");
    }

    protected void usage() {
        if (Util.IS_MONO) {
            Standalone.monoUsage();
        } else {
            this.javaUsage();
        }
        System.exit(1);
    }

    protected void checkOption(String[] stringArray) {
        if ("--version".equals(stringArray[0])) {
            System.out.println(Util.VERSION);
            System.exit(0);
        }
        this.usage();
    }

    private static boolean testPort(int n) {
        try {
            ServerSocket serverSocket = new ServerSocket(n);
            serverSocket.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static int findFreePort(int n) {
        for (int i = n; i < n + 100; ++i) {
            if (!Standalone.testPort(i)) continue;
            return i;
        }
        return n;
    }

    protected void init(String[] stringArray) {
        String string = null;
        int n = -1;
        if (stringArray.length > 3) {
            this.checkOption(stringArray);
        }
        try {
            if (stringArray.length > 0 && (string = stringArray[0]).startsWith("-")) {
                this.checkOption(stringArray);
            }
            try {
                if (stringArray.length > 1) {
                    n = Integer.parseInt(stringArray[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.usage();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (stringArray.length == 0) {
                try {
                    int n2 = Standalone.findFreePort(9267);
                    int n3 = Standalone.findFreePort(8080);
                    Object object = JOptionPane.showInputDialog(null, "Start a socket listener on port", "Starting the PHP/Java Bridge ...", 3, null, new String[]{"LOCAL:/var/run/.php-java-bridge_socket", "INET_LOCAL:" + n2, "INET:" + n2, "SERVLET_LOCAL:" + n3, "SERVLET:" + n3}, "SERVLET_LOCAL:" + n3);
                    if (object == null) {
                        System.exit(0);
                    }
                    string = object.toString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Standalone.checkServlet(n, string, stringArray);
            ISocketFactory iSocketFactory = Standalone.bind(n, string);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('@');
            stringBuffer.append(iSocketFactory.getSocketName());
            stringBuffer.append('\n');
            if (stringArray.length > 1) {
                System.out.write(stringBuffer.toString().getBytes());
                System.out.close();
            }
            if ("true".equals(System.getProperty("php.java.bridge.test.startup"))) {
                System.exit(0);
            }
            JavaBridge.initLog(String.valueOf(iSocketFactory), n, stringArray);
            JavaBridge.init(iSocketFactory, n, stringArray);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static void checkServlet(int n, String string, String[] stringArray) throws InterruptedException, IOException {
        if (string == null) {
            return;
        }
        if (string.startsWith("SERVLET_LOCAL:")) {
            System.setProperty("php.java.bridge.promiscuous", "false");
        } else if (string.startsWith("SERVLET:")) {
            System.setProperty("php.java.bridge.promiscuous", "true");
        } else {
            return;
        }
        JavaBridge.initLog(string, n, stringArray);
        string = string.substring(string.indexOf(58) + 1);
        JavaBridgeRunner.main(new String[]{string});
    }

    private static final boolean checkGNUVM() {
        try {
            return "libgcj".equals(System.getProperty("gnu.classpath.vm.shortname"));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.loadLibrary("natcJavaBridge");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Process process;
            if (stringArray.length == 0 && new File("/usr/java/default/bin/java").exists() && Standalone.checkGNUVM() && System.getProperty("php.java.bridge.exec_sun_vm", "true").equals("true") && (process = Runtime.getRuntime().exec(new String[]{"/usr/java/default/bin/java", "-Dphp.java.bridge.exec_sun_vm=false", "-classpath", System.getProperty("java.class.path"), "php.java.bridge.Standalone"})) != null) {
                System.exit(process.waitFor());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            new Standalone().init(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(9);
        }
    }
}

