/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import php.java.bridge.ISocketFactory;
import php.java.bridge.Util;

class TCPServerSocket
implements ISocketFactory {
    private static final int TCP_PORT_BASE = 9267;
    private ServerSocket sock;
    private int port;
    boolean local;

    public static ISocketFactory create(String string, int n) throws IOException {
        int n2;
        boolean bl = false;
        if (string == null) {
            string = Util.TCP_SOCKETNAME;
        }
        if (string.startsWith("INET:")) {
            string = string.substring(5);
        }
        if (string.startsWith("INET_LOCAL:")) {
            bl = true;
            string = string.substring(11);
        } else if (string.startsWith("LOCAL:")) {
            return null;
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = Integer.parseInt(Util.TCP_SOCKETNAME);
        }
        TCPServerSocket tCPServerSocket = new TCPServerSocket(n2, n, bl);
        return tCPServerSocket;
    }

    private ServerSocket newServerSocket(int n, int n2) throws IOException {
        try {
            if (this.local) {
                return new ServerSocket(n, n2, InetAddress.getByName("127.0.0.1"));
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return new ServerSocket(n, n2);
    }

    private void findFreePort(int n, int n2) {
        for (int i = n; i < n + 100; ++i) {
            try {
                this.sock = this.newServerSocket(i, n2);
                this.port = i;
                return;
            }
            catch (IOException iOException) {
                continue;
            }
        }
    }

    private TCPServerSocket(int n, int n2, boolean bl) throws IOException {
        this.local = bl;
        if (n == 0) {
            this.findFreePort(9267, n2);
        } else {
            this.sock = this.newServerSocket(n, n2);
            this.port = n;
        }
    }

    public void close() throws IOException {
        this.sock.close();
    }

    public Socket accept() throws IOException {
        Socket socket = this.sock.accept();
        socket.setTcpNoDelay(true);
        return socket;
    }

    public String getSocketName() {
        return String.valueOf(this.port);
    }

    public String toString() {
        return (this.local ? "INET_LOCAL:" : "INET:") + this.getSocketName();
    }
}

