/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import php.java.bridge.ISession;
import php.java.bridge.JavaBridge;
import php.java.bridge.JavaBridgeClassLoader;
import php.java.bridge.SessionFactory;
import php.java.bridge.SimpleJavaBridgeClassLoader;
import php.java.bridge.Util;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.IContextFactoryVisitor;
import php.java.bridge.http.SimpleContextFactory;

public final class ContextFactory
extends SessionFactory
implements IContextFactory {
    public static final String EMPTY_CONTEXT_NAME = "";
    public static final ICredentials NO_CREDENTIALS = new ICredentials(){};
    private static final HashMap contexts;
    private static final HashMap liveContexts;
    private static final long ORPHANED_TIMEOUT = 5000L;
    private boolean invalid = false;
    private String id;
    private long timestamp = System.currentTimeMillis();
    private ICredentials contextServer = null;
    private IContextFactoryVisitor visitor;
    private static long counter;

    private static synchronized String addNext(String string, ContextFactory contextFactory) {
        ++counter;
        try {
            string = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Util.printStackTrace(unsupportedEncodingException);
        }
        String string2 = Long.toHexString(counter) + "@" + string;
        contexts.put(string2, contextFactory);
        return string2;
    }

    private static synchronized void remove(String string) {
        ContextFactory contextFactory = (ContextFactory)liveContexts.remove(string);
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: removed context: " + contextFactory.visitor + ", # of contexts: " + contexts.size());
        }
    }

    private static synchronized ContextFactory moveContext(String string) {
        Object v = liveContexts.get(string);
        if (v != null) {
            return (ContextFactory)v;
        }
        v = contexts.remove(string);
        if (v != null) {
            liveContexts.put(string, v);
            return (ContextFactory)v;
        }
        return null;
    }

    public ContextFactory(String string) {
        this.id = ContextFactory.addNext(string, this);
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: new context: " + this.id + " for web context" + string + ", # of contexts: " + contexts.size());
        }
    }

    public static IContextFactory addNew() {
        return new SimpleContextFactory(EMPTY_CONTEXT_NAME);
    }

    private void init(ICredentials iCredentials) {
        this.contextServer = iCredentials;
        this.invalid = false;
    }

    public static IContextFactory get(String string, ICredentials iCredentials) {
        if (iCredentials == null) {
            return ContextFactory.peek(string);
        }
        ContextFactory contextFactory = ContextFactory.moveContext(string);
        if (contextFactory == null) {
            return null;
        }
        if (contextFactory.contextServer == null) {
            contextFactory.init(iCredentials);
        }
        if (contextFactory.contextServer != iCredentials) {
            throw new SecurityException("Illegal access");
        }
        return contextFactory.visitor;
    }

    public static synchronized IContextFactory peek(String string) {
        if (liveContexts.get(string) != null) {
            throw new IllegalStateException(string);
        }
        ContextFactory contextFactory = (ContextFactory)contexts.get(string);
        return contextFactory == null ? null : contextFactory.visitor;
    }

    private void switchContext(ContextFactory contextFactory) {
        JavaBridge javaBridge = this.getBridge();
        JavaBridge javaBridge2 = contextFactory.checkBridge();
        if (javaBridge2 != null) {
            if (Util.logLevel > 4) {
                Util.logDebug("contextfactory: setting new bridge. visited: " + javaBridge.getFactory() + " <= visitor: " + javaBridge2.getFactory());
            }
        } else {
            throw new IllegalStateException("recycle empty context");
        }
        javaBridge.request.setBridge(javaBridge2);
        javaBridge = javaBridge2;
        contextFactory.visitor.removeOrphaned();
        this.accept(contextFactory.visitor);
        if (contextFactory.getClassLoader() != javaBridge.getClassLoader().getDefaultClassLoader()) {
            throw new IllegalStateException("class loader");
        }
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: " + this + " is swiching thread context, using classloader: " + System.identityHashCode(contextFactory.getClassLoader().getParent()));
        }
        this.invalid = false;
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: accepted visitor: " + contextFactory.visitor);
        }
    }

    public void recycle(String string) throws SecurityException {
        ContextFactory contextFactory = null;
        contextFactory = (ContextFactory)contexts.get(string);
        if (contextFactory == null || contextFactory == this) {
            return;
        }
        this.switchContext(contextFactory);
    }

    public synchronized void recycle() {
        if (Util.logLevel >= 4) {
            Util.logDebug("contextfactory: finish context called (recycle context factory) " + this.visitor);
        }
        super.recycle();
        this.visitor.recycle();
        this.invalid = true;
        if (this.bridge != null) {
            this.bridge.getClassLoader().switcheThreadContextClassLoader();
        }
        this.notify();
    }

    public synchronized void destroy() {
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: context destroyed (remove context factory): " + this.visitor);
        }
        ContextFactory.remove(this.getId());
        this.bridge = null;
        this.invalid = true;
        this.notify();
    }

    private boolean isInitialized() {
        return this.contextServer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void destroyOrphaned() {
        long l = System.currentTimeMillis();
        Iterator iterator = contexts.values().iterator();
        while (iterator.hasNext()) {
            ContextFactory contextFactory = (ContextFactory)iterator.next();
            if (contextFactory.timestamp + 5000L >= l) continue;
            ContextFactory contextFactory2 = contextFactory;
            synchronized (contextFactory2) {
                contextFactory.invalid = true;
                contextFactory.notify();
            }
            if (Util.logLevel > 4) {
                Util.logDebug("contextfactory: Orphaned context: " + contextFactory.visitor + " removed.");
            }
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void destroyAll() {
        ContextFactory.destroyOrphaned();
        Iterator iterator = contexts.values().iterator();
        while (iterator.hasNext()) {
            ContextFactory contextFactory;
            ContextFactory contextFactory2 = contextFactory = (ContextFactory)iterator.next();
            synchronized (contextFactory2) {
                contextFactory.invalid = true;
                contextFactory.notify();
            }
            iterator.remove();
        }
    }

    public synchronized void waitFor() throws InterruptedException {
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: servlet is waiting for ContextFactory " + this.visitor);
        }
        if (this.invalid) {
            throw new IllegalStateException("waitFor");
        }
        this.wait();
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: servlet done waiting for ContextFactory " + this.visitor);
        }
    }

    public synchronized void waitFor(long l) throws InterruptedException {
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: servlet is waiting for ContextFactory " + this.visitor + " for " + l + " ms");
        }
        if (this.invalid) {
            throw new IllegalStateException("waitFor");
        }
        this.wait(l);
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: servlet done waiting for ContextFactory " + this.visitor + " for " + l + " ms");
        }
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "Context# " + this.id + ", isInitialized: " + this.isInitialized() + ", isValid: " + !this.invalid;
    }

    public IContext getContext() {
        return this.visitor.getContext();
    }

    public void setContext(IContext iContext) {
        this.visitor.setContext(iContext);
    }

    private void setVisitor(IContextFactoryVisitor iContextFactoryVisitor) {
        this.visitor = iContextFactoryVisitor;
    }

    public void accept(IContextFactoryVisitor iContextFactoryVisitor) {
        iContextFactoryVisitor.visit(this);
        this.setVisitor(iContextFactoryVisitor);
    }

    public ISession getSimpleSession(String string, boolean bl, int n) {
        return super.getSession(string, bl, n);
    }

    public ISession getSession(String string, boolean bl, int n) {
        return this.visitor.getSession(string, bl, n);
    }

    public synchronized void removeOrphaned() {
        ContextFactory contextFactory = (ContextFactory)contexts.remove(this.id);
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: removed empty context: " + (contextFactory != null ? String.valueOf(contextFactory.visitor) : "<already handled>") + ", # of contexts: " + contexts.size() + ", # of live contexts: " + liveContexts.size());
        }
        this.invalid = true;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.visitor.setClassLoader(classLoader);
    }

    public SimpleJavaBridgeClassLoader getJavaBridgeClassLoader() {
        return new JavaBridgeClassLoader(this.getClassLoader());
    }

    public ClassLoader getClassLoader() {
        return this.visitor.getClassLoader();
    }

    static {
        ContextFactory.getTimer().addJob(new Runnable(){

            public void run() {
                ContextFactory.destroyOrphaned();
            }
        });
        contexts = new HashMap();
        liveContexts = new HashMap();
        counter = 0L;
    }

    public static interface ICredentials {
    }
}

