/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import php.java.bridge.JavaBridge;
import php.java.bridge.Request;
import php.java.bridge.SimpleJavaBridgeClassLoader;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannel;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.IContextFactory;

public class ContextRunner
implements Runnable {
    private IContextFactory ctx;
    private Request request;
    private InputStream in;
    private OutputStream out;
    private AbstractChannel channel;
    private ContextFactory.ICredentials contextServer;

    protected ContextRunner(ContextFactory.ICredentials iCredentials, AbstractChannel abstractChannel) {
        this.contextServer = iCredentials;
        this.channel = abstractChannel;
    }

    private int readLength() throws IOException {
        byte[] byArray = new byte[1];
        this.in.read(byArray);
        int n = 0xFF & byArray[0];
        if (n != 255) {
            throw new IllegalStateException("context length");
        }
        byArray = new byte[2];
        this.in.read(byArray);
        n = 0xFF & byArray[0] | 0xFF00 & byArray[1] << 8;
        return n;
    }

    private String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.in.read(byArray);
        return new String(byArray, "ASCII");
    }

    private String readName() throws IOException {
        return this.readString(this.readLength());
    }

    private void setIO(JavaBridge javaBridge, InputStream inputStream, OutputStream outputStream) {
        javaBridge.request.reset();
        javaBridge.in = inputStream;
        javaBridge.out = outputStream;
    }

    private boolean init() throws IOException {
        if (Util.logLevel > 4) {
            Util.logDebug("starting a new ContextRunner " + this);
        }
        this.out = this.channel.getOuptutStream();
        this.in = this.channel.getInputStream();
        int n = this.in.read();
        if (n != 127) {
            if (n == -1) {
                return false;
            }
            try {
                this.out.write(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException("Protocol violation");
        }
        String string = this.readName();
        this.ctx = ContextFactory.get(string, this.contextServer);
        if (this.ctx == null) {
            throw new IOException("No context available for: " + string + ".");
        }
        JavaBridge javaBridge = this.ctx.getBridge();
        if (Util.logLevel > 4) {
            Util.logDebug(this.ctx + " created new thread, using class loader: " + System.identityHashCode(this.ctx.getClassLoader().getParent()));
        }
        SimpleJavaBridgeClassLoader simpleJavaBridgeClassLoader = javaBridge.getClassLoader();
        simpleJavaBridgeClassLoader.switcheThreadContextClassLoader();
        this.setIO(javaBridge, this.in, this.out);
        this.request = javaBridge.request;
        return true;
    }

    public AbstractChannel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.init()) {
                this.request.handleRequests();
            }
        }
        catch (Exception exception) {
            Util.printStackTrace(exception);
        }
        finally {
            if (this.ctx != null) {
                this.ctx.destroy();
            }
            this.channel.shutdown();
        }
    }
}

