/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import php.java.bridge.AppThreadPool;
import php.java.bridge.ISocketFactory;
import php.java.bridge.Util;
import php.java.bridge.http.HttpRequest;
import php.java.bridge.http.HttpResponse;

public abstract class HttpServer
implements Runnable {
    public static final String PUT = "PUT";
    public static final String GET = "GET";
    public static final String POST = "POST";
    protected ISocketFactory socket;
    protected Thread httpServer;
    private AppThreadPool pool;
    protected static final byte[] ERROR = Util.toBytes("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL was not found on this server.</p><hr></body></html>");

    public abstract ISocketFactory bind(String var1) throws IOException;

    protected HttpServer() throws IOException {
        this(null);
    }

    protected HttpServer(String string) throws IOException {
        if (string == null) {
            string = "0";
        }
        if (!string.startsWith("INET")) {
            string = Util.JAVABRIDGE_PROMISCUOUS ? "INET:" : "INET_LOCAL:" + string;
        }
        this.socket = this.bind(string);
        try {
            this.pool = HttpServer.createThreadPool(Util.EXTENSION_NAME + "HttpServerThreadPool");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.httpServer = new Util.Thread(this, Util.EXTENSION_NAME + "HttpServer");
        this.httpServer.start();
    }

    private static AppThreadPool createThreadPool(String string) {
        AppThreadPool appThreadPool = null;
        int n = 20;
        try {
            n = Integer.parseInt(Util.THREAD_POOL_MAX_SIZE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n > 0) {
            appThreadPool = new AppThreadPool(string, n);
        }
        return appThreadPool;
    }

    protected boolean parseHeader(HttpRequest httpRequest) throws UnsupportedEncodingException, IOException {
        int n;
        byte[] byArray = new byte[8192];
        InputStream inputStream = httpRequest.getInputStream();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while ((n = inputStream.read(byArray, n2, byArray.length - n2)) != -1) {
            int n4 = n2 + n;
            while (!bl && n2 < n4) {
                switch (byArray[n2++]) {
                    case 10: {
                        if (n3 + 2 == n2 && byArray[n3] == 13) {
                            bl = true;
                            break;
                        }
                        httpRequest.addHeader(new String(byArray, n3, n2 - n3 - 2, "ASCII"));
                        n3 = n2;
                    }
                }
            }
            if (!bl) continue;
            httpRequest.pushBack(byArray, n2, n4 - n2);
            break;
        }
        return n2 != 0;
    }

    protected void doRun() throws IOException {
        while (true) {
            Socket socket;
            try {
                socket = this.socket.accept();
            }
            catch (IOException iOException) {
                return;
            }
            Util.logDebug("Socket connection accepted");
            if (this.pool == null) {
                Util.logDebug("Starting new HTTP server thread");
                new Util.Thread(new Runner(socket), Util.EXTENSION_NAME + "HttpServerRunner").start();
                continue;
            }
            Util.logDebug("Starting HTTP server thread from thread pool");
            this.pool.start(new Runner(socket));
        }
    }

    protected void doPost(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        httpResponse.setContentLength(ERROR.length);
        OutputStream outputStream = httpResponse.getOutputStream();
        outputStream.write(ERROR);
    }

    protected void doGet(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        this.doPost(httpRequest, httpResponse);
    }

    protected void doPut(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        this.doPost(httpRequest, httpResponse);
    }

    protected void service(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        String string = httpRequest.getHeader("Content-Length");
        if (string == null) {
            httpRequest.setContentLength(0);
        } else {
            httpRequest.setContentLength(Integer.parseInt(string));
        }
        String string2 = httpRequest.getMethod();
        if (string2 == PUT) {
            this.doPut(httpRequest, httpResponse);
        } else if (string2 == GET) {
            this.doGet(httpRequest, httpResponse);
        } else if (string2 == POST) {
            this.doPost(httpRequest, httpResponse);
        }
    }

    public void run() {
        try {
            this.doRun();
        }
        catch (IOException iOException) {
            Util.printStackTrace(iOException);
        }
    }

    public void destroy() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            Util.printStackTrace(iOException);
        }
    }

    public ISocketFactory getSocket() {
        return this.socket;
    }

    private class Runner
    implements Runnable {
        private Socket sock;
        private HttpRequest req;
        private HttpResponse res;

        public Runner(Socket socket) throws IOException {
            this.sock = socket;
            this.req = new HttpRequest(socket.getInputStream());
            this.res = new HttpResponse(socket.getOutputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (HttpServer.this.parseHeader(this.req)) {
                    HttpServer.this.service(this.req, this.res);
                }
            }
            catch (IOException iOException) {
                Util.printStackTrace(iOException);
            }
            finally {
                try {
                    this.req.close();
                }
                catch (IOException iOException) {}
                try {
                    this.res.close();
                }
                catch (IOException iOException) {}
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

