/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import php.java.bridge.ISession;
import php.java.bridge.JavaBridge;
import php.java.bridge.SimpleJavaBridgeClassLoader;
import php.java.bridge.Util;
import php.java.bridge.http.Context;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactoryVisitor;

public class SimpleContextFactory
implements IContextFactoryVisitor {
    protected ISession session;
    protected ContextFactory visited;
    protected IContext context;
    private ClassLoader loader;

    protected SimpleContextFactory(String string) {
        this.visited = new ContextFactory(string);
        this.visited.accept(this);
        this.setClassLoader(Util.getContextClassLoader());
    }

    public void recycle(String string) throws SecurityException {
        this.visited.recycle(string);
    }

    public void destroy() {
        this.visited.destroy();
        this.session = null;
    }

    public void waitFor() throws InterruptedException {
    }

    public void waitFor(long l) throws InterruptedException {
    }

    public String getId() {
        return this.visited.getId();
    }

    public String toString() {
        return "ContextFactory: " + this.visited + ", SimpleContextFactory: " + this.getClass() + ", current loader: " + this.loader;
    }

    protected IContext createContext() {
        return new Context();
    }

    public IContext getContext() {
        if (this.context == null) {
            this.setContext(this.createContext());
        }
        return this.context;
    }

    public JavaBridge getBridge() {
        return this.visited.getBridge();
    }

    public void visit(ContextFactory contextFactory) {
        this.visited = contextFactory;
    }

    public ISession getSession(String string, boolean bl, int n) {
        if (this.session != null) {
            return this.session;
        }
        this.session = this.visited.getSimpleSession(string, bl, n);
        return this.session;
    }

    public void setContext(IContext iContext) {
        this.context = iContext;
        this.context.setAttribute("php.java.bridge.JavaBridge", this.getBridge(), 100);
    }

    public void removeOrphaned() {
        this.visited.removeOrphaned();
    }

    public void recycle() {
        this.session = null;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public SimpleJavaBridgeClassLoader getJavaBridgeClassLoader() {
        return this.visited.getJavaBridgeClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("loader");
        }
        this.loader = classLoader;
    }
}

