/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import php.java.bridge.AppThreadPool;
import php.java.bridge.ISocketFactory;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.ContextRunner;
import php.java.bridge.http.PipeContextServer;

public class SocketContextServer
extends PipeContextServer
implements Runnable {
    private ISocketFactory socket = null;
    private static final String BIND_PORT = Util.JAVABRIDGE_PROMISCUOUS ? "INET:0" : "INET_LOCAL:0";
    private static final boolean socketServer = SocketContextServer.checkTestTunnel("php.java.bridge.no_socket_server");

    public SocketContextServer(AppThreadPool appThreadPool) {
        super(ContextFactory.NO_CREDENTIALS, appThreadPool, "");
        try {
            Object object;
            this.socket = JavaBridge.bind(BIND_PORT);
            try {
                object = System.getSecurityManager();
                if (object != null) {
                    ((SecurityManager)object).checkAccept("127.0.0.1", Integer.parseInt(this.socket.getSocketName()));
                }
            }
            catch (SecurityException securityException) {
                throw new Exception("Add the line: grant {permission java.net.SocketPermission \"*\", \"accept,resolve\";}; to your server.policy file or run this AS on an operating system which supports named pipes (e.g.: Unix, Linux, BSD, Mac OSX, ...).", securityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = new Util.Thread(this, "JavaBridgeSocketContextServer(" + this.socket.getSocketName() + ")");
            ((Thread)object).start();
        }
        catch (Throwable throwable) {
            Util.warn("Local communication channel not available. The PHP/Java bridge will be very slow.");
            Util.printStackTrace(throwable);
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.socket = null;
        }
    }

    private boolean accept() {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        Socket socket = null;
        try {
            try {
                socket = this.socket.accept();
            }
            catch (IOException iOException) {
                return false;
            }
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
            ContextRunner contextRunner = new ContextRunner(this.contextServer, new Channel(this.getChannelName(), inputStream, outputStream, socket));
            if (this.threadPool != null) {
                this.threadPool.start(contextRunner);
            } else {
                Util.Thread thread = new Util.Thread(contextRunner, "JavaBridgeContextRunner(" + this.contextName + ")");
                thread.start();
            }
        }
        catch (SecurityException securityException) {
            Channel.shutdown(socket);
            ContextFactory.destroyAll();
            Util.printStackTrace(securityException);
            return false;
        }
        catch (Throwable throwable) {
            Channel.shutdown(socket);
            Util.printStackTrace(throwable);
        }
        return true;
    }

    public void run() {
        while (this.socket != null) {
            if (this.accept()) continue;
            this.destroy();
        }
        Util.logDebug("SocketContextServer stopped, the local channel is not available anymore.");
    }

    public void destroy() {
        super.destroy();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                Util.printStackTrace(iOException);
            }
            this.socket = null;
        }
    }

    public boolean isAvailable() {
        return socketServer && this.socket != null;
    }

    public String getChannelName() {
        return this.socket.getSocketName();
    }

    public boolean start(AbstractChannelName abstractChannelName) {
        return this.isAvailable();
    }

    protected static class Channel
    extends PipeContextServer.Channel {
        protected Socket sock;

        public Channel(String string, InputStream inputStream, OutputStream outputStream, Socket socket) {
            super(string, inputStream, outputStream);
            this.sock = socket;
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public OutputStream getOuptutStream() {
            return this.out;
        }

        public Socket getSocket() {
            return this.sock;
        }

        protected static void shutdown(Socket socket) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void shutdown() {
            super.shutdown();
            Channel.shutdown(this.sock);
        }
    }
}

