<?php
  

if(!function_exists("mono_get_base")) {
  $version = phpversion();
  if ((version_compare("5.1.2", $version, ">"))) {
	$msg = "<br><strong>PHP $version too old.</strong><br>\nFor PHP versions < 5.1.4 install the mono.so or php_mono.dll from the php-mono-bridge-legacy download.<br>\nOr set the path to the PHP executable, see php_exec in the WEB-INF/web.xml";
	die($msg);
  }
  

  function mono_get_base() {
	$ar = get_required_files();
	$arLen = sizeof($ar);
	if($arLen>0) {
	  $thiz = $ar[$arLen-1];
	  return dirname($thiz);
	} else {
	  return "mono/";
	}
  }
  $MONO_BASE=mono_get_base();
  

  class mono_RuntimeException extends Exception {};
  

  class mono_IllegalStateException extends mono_RuntimeException {};
  

  class mono_IllegalArgumentException extends mono_RuntimeException {
	function __construct($ob) {
	  parent::__construct("illegal argument: ".gettype($ob));
	}
  };
  

  function mono_autoload_function($x) {
	$str=str_replace("_", ".", $x);
	$client=__monoproxy_Client_getClient();
	if(!($client->invokeMethod(0, "typeExists", array($str)))) return false;
	$instance = "class ${x} extends Mono {".
	  "static function type(\$sub=null){if(\$sub) \$sub='\$'.\$sub; return mono('${str}'.\"\$sub\");}".
	  'function __construct() {$args = func_get_args();'.
	  'array_unshift($args, '."'$str'".'); parent::__construct($args);}}';
	eval ("$instance");
	return true;
  }
  

  function mono_autoload($libs=null) {
	static $once = false;
	if($once) 
	  throw new mono_IllegalStateException("mono_autoload called more than once");
	$once = true;
	mono_require($libs);
	if(function_exists("spl_autoload_register")) {
	  spl_autoload_register("mono_autoload_function");
	} else {
	  function __autoload($x) {
		return mono_autoload_function($x);
	  }
	}
  }
  

  function Mono($name) { 
	static $classMap = array();
	if(array_key_exists($name, $classMap)) return $classMap[$name];
	return $classMap[$name]=new MonoClass($name);
  }
  

  function mono_get_closure() {return mono_closure_array(func_get_args());}
  

  function mono_get_values($arg) { return mono_values($arg); }
  

  function mono_get_session() {return mono_session_array(func_get_args());}
  

  function mono_get_context() {return mono_context(); }
  

  function mono_get_server_name() { return mono_server_name(); }
  

  function mono_set_encoding($enc) { return mono_set_file_encoding ($enc); }
  

  function mono_set_library_path($arg) { return mono_require($arg); }




function mono_defineHostFromInitialQuery($mono_base) {
  if($mono_base!="mono/") {
	$url = parse_url($mono_base);
	if(isset($url["scheme"]) && ($url["scheme"]=="http")) {
	  $host = $url["host"];
	  $port = $url["port"];
	  $path = $url["path"];
	  define ("MONO_HOSTS", "$host:$port");
	  $dir = dirname($path);
	  define ("MONO_SERVLET", "$dir/MonoBridge.phpmonobridge"); 
	  return true;
	}
  }
  return false;
}
define ("MONO_PEAR_VERSION", "4.3.2");
if (defined ("MONO_PARSE_INI_FILE") && MONO_PARSE_INI_FILE) {
  $ini=@parse_ini_file("mono.ini");
  if(array_key_exists("mono.hosts", $ini)) define("MONO_HOSTS", $ini["mono.hosts"]);
  if(array_key_exists("mono.servlet", $ini)) define("MONO_SERVLET", $ini["mono.servlet"]);
  if(array_key_exists("mono.log_level", $ini)) define("MONO_LOG_LEVEL", $ini["mono.log_level"]);
 }
if(!defined("MONO_HOSTS")) {
  if(!mono_defineHostFromInitialQuery($MONO_BASE)) {
	define("MONO_HOSTS", "127.0.0.1:8080"); 
	define("MONO_SERVLET", "On"); 
  }
 } else {
  if(!defined("MONO_SERVLET")) 
	define("MONO_SERVLET", "On"); 
 }
if(!defined("MONO_LOG_LEVEL"))
  define ("MONO_LOG_LEVEL", null); 
if(!defined("MONO_PIPE_DIR")) {
  if (file_exists ("/dev/shm")) define("MONO_PIPE_DIR", "/dev/shm" );
  elseif (file_exists ("/tmp")) define("MONO_PIPE_DIR", "/tmp" );
  else						  define ("MONO_PIPE_DIR", null);
}
if(!defined("MONO_DEBUG")) 
  define("MONO_DEBUG", false);
if(!defined("MONO_CACHE_ENABLED")) 
  define("MONO_CACHE_ENABLED", false);
  



class mono_SimpleFactory {
  public $client;
  function mono_SimpleFactory($client) {
	$this->client = $client;
  }
  function getProxy($result, $signature, $wrap) {
	if (false) { $signature = $signature; $wrap = $wrap; }
  	return $result;
  }
  function checkResult($result) {
  	if (false) $result = $result;
  }
}


class mono_ProxyFactory extends mono_SimpleFactory {
  function mono_ProxyFactory($client) {
	parent::mono_SimpleFactory($client);
  }
  function create($result, $signature) {
	return new mono_MonoProxy($result, $signature);
  }
  function createInternal($proxy) {
	return new mono_InternalMono($proxy);
  }
  function getProxy($result, $signature, $wrap) {
	$proxy = $this->create($result, $signature);
	if($wrap) $proxy = $this->createInternal($proxy);
	return $proxy;
  }
}


class mono_ArrayProxyFactory extends mono_ProxyFactory {
  function mono_ArrayProxyFactory($client) {
	parent::mono_ProxyFactory($client);
  }
  function create($result, $signature) {
	return new mono_ArrayProxy($result, $signature);
  }	
}


class mono_IteratorProxyFactory extends mono_ProxyFactory {
  function mono_IteratorProxyFactory($client) {
	parent::mono_ProxyFactory($client);
  }
  function create($result, $signature) {
	return new mono_IteratorProxy($result, $signature);
  }	
}


class mono_ExceptionProxyFactory extends mono_SimpleFactory {
  function mono_ExceptionProxyFactory($client) {
	parent::mono_SimpleFactory($client);
  }
  function create($result, $signature) {
	return new mono_ExceptionProxy($result, $signature);
  }
  function getProxy($result, $signature, $wrap) {
	$proxy = $this->create($result, $signature);
	if($wrap) $proxy = new mono_InternalException($proxy);
	return $proxy;
  }
}


class mono_ThrowExceptionProxyFactory extends mono_ExceptionProxyFactory {
  function mono_ThrowExceptionProxyFactory($client) {
	parent::mono_ExceptionProxyFactory($client);
  }
  function getProxy($result, $signature, $wrap) {
	if (false) $wrap = $wrap;
  	$proxy = $this->create($result, $signature);
	$proxy = new mono_InternalException($proxy);
	return $proxy;
  }
  function checkResult($result) {
	throw $result;
  }
}


class mono_CacheEntry {
  public $fmt, $signature, $factory, $mono;
  public $resultVoid;
  function mono_CacheEntry($fmt, $signature, $factory, $resultVoid) {
	$this->fmt = $fmt;
	$this->signature = $signature;
	$this->factory = $factory;
	$this->resultVoid = $resultVoid;
  }
}


class mono_Arg {
  public $client;
  public $exception; 				
  public $factory, $val;
  public $signature; 
  function mono_Arg($client) {
	$this->client = $client;
	$this->factory = $client->simpleFactory;
  }
  function linkResult(&$val) {
	$this->val = &$val;
  }
  function setResult($val) {
	$this->val = &$val;
  }
  function getResult($wrap) {
	$rc = $this->factory->getProxy($this->val, $this->signature, $wrap);
	$factory = $this->factory;
	$this->factory = $this->client->simpleFactory;
	$factory->checkResult($rc);
	return $rc;
  }
  function setFactory($factory) {
	$this->factory = $factory;
  }
  function setException($string) {
	$this->exception = $string;
  }
  function setVoidSignature() {
	$this->signature = "@N";
	$key = $this->client->currentCacheKey;
	$this->client->currentArgumentsFormat[6]="3";
	if(MONO_DEBUG) {
	  echo "ignore further results:";  echo "\n";
	}
	if(MONO_DEBUG) {
	  echo "updating cache $key, argformat: {$this->client->currentArgumentsFormat}, classType: {$this->signature}\n";
	}
	$cacheEntry = new mono_CacheEntry($this->client->currentArgumentsFormat, $this->signature, $this->factory, true);
	$this->client->methodCache[$key]=$cacheEntry;
  }
  function setSignature($signature) {
	$this->signature = $signature;
	$key = $this->client->currentCacheKey;
	if($key && $key[0]!='~') {			
	  if(MONO_DEBUG) {
		echo "updating cache $key, argformat: {$this->client->currentArgumentsFormat}, classType: {$this->signature}\n";
	  }
	  $cacheEntry = new mono_CacheEntry($this->client->currentArgumentsFormat, $this->signature, $this->factory, false);
	  $this->client->methodCache[$key]=$cacheEntry;
	}
  }
}


class mono_CompositeArg extends mono_Arg {
  public $parentArg;
  public $idx;						
  public $type;					
  public $counter;
  function mono_CompositeArg($client, $type) {
	parent::mono_Arg($client);
	$this->type = $type;
	$this->val = array();
	$this->counter = 0;
  }
  function setNextIndex() {
	$this->idx = $this->counter++;
  }
  function setIndex($val) {
	$this->idx = $val;
  }
  function linkResult(&$val) {
	$this->val[$this->idx]=&$val;
  }
  function setResult($val) {
	$this->val[$this->idx]=$this->factory->getProxy($val, $this->signature, true);
	$this->factory = $this->client->simpleFactory;
  }
}


class mono_ApplyArg extends mono_CompositeArg {
  public $m, $p, $v, $n; 			
  function mono_ApplyArg($client, $type, $m, $p, $v, $n) {
	parent::mono_CompositeArg($client, $type);
	$this->m = $m;
	$this->p = $p;
	$this->v = $v;
	$this->n = $n;
  }
}




class mono_Handler {
  public $client;
  function mono_Handler($client) {
	$this->client = $client;
  }
  function flush() {}
  function sendData() {
	$this->client->protocol->sendData();
  }
  function handleRequests() {
	$client = $this->client;
	do {
	  $tail_call = false;
	  $this->client->stack=array($this->client->arg=$this->client->simpleArg);
	  $client->idx = 0;
	  $client->parser->parse();
	  

	  if((count($client->stack)) > 1) {
		$arg = array_pop($client->stack);
		$client->apply($arg);
		$tail_call = 1;			
	  } else {
		$tail_call = 0;
	  }
	  $client->stack=null;
	} while($tail_call);
	return 1;
  }
}




class mono_AsyncHandler extends mono_Handler {
  public $arg;
  function mono_AsyncHandler($client) {
	$this->client = $client;
	$this->arg = $client->simpleArg;
  }
  function flush() {
	$this->client->protocol->sendData();
  }
  function sendData() {
	$this->client->protocol->sendAsyncData();
  }
  function handleRequests() {
	$this->arg->setFactory($this->client->proxyFactory);
	$this->arg->setResult(++$this->client->asyncCtx);
  }
}


class mono_Client 
 {
  public $RUNTIME;
  const RECV_SIZE=8192;
  const SEND_SIZE=8192;
  public $result, $exception;
  public $parser;
  public $simpleArg, $compositeArg;
  public $simpleFactory, 
	$proxyFactory, $iteratorProxyFacroty, 
	$arrayProxyFactory, $exceptionProxyFactory, $throwExceptionProxyFactory;
  public $arg;
  public $asyncCtx;
  public $globalRef;
  public $stack;
  public $methodCache = array(), $currentCacheKey, $currentArgumentsFormat;
  public $cachedMonoPrototype;
  public $sendBuffer, $preparedToSendBuffer;
  

  public $defaultHandler, $asyncHandler, $handler;
  function mono_Client() {
	$this->RUNTIME = array();
	if(MONO_PIPE_DIR && function_exists("posix_mkfifo")) 
	  $this->RUNTIME['PIPE_DIR']=MONO_PIPE_DIR;
	else
	  $this->RUNTIME['PIPE_DIR']=null;
	$this->parser = new mono_Parser($this);
	$this->protocol = new mono_Protocol($this);
	$this->simpleFactory = new mono_SimpleFactory($this);
	$this->proxyFactory = new mono_ProxyFactory($this);
	$this->arrayProxyFactory = new mono_ArrayProxyFactory($this);
	$this->iteratorProxyFactory = new mono_IteratorProxyFactory($this);
	$this->exceptionProxyFactory = new mono_ExceptionProxyFactory($this);
	$this->throwExceptionProxyFactory = new mono_ThrowExceptionProxyFactory($this);
	$this->cachedMonoPrototype=new mono_MonoProxyProxy($this);
	$this->simpleArg = new mono_Arg($this);
	$this->globalRef = new mono_GlobalRef($this);
	$this->asyncCtx = 0;
	

	$this->handler = $this->defaultHandler = new mono_Handler($this);
	$this->asyncHandler = new mono_AsyncHandler($this);
  }
  function __destruct() { 
	if(MONO_DEBUG) echo "the client destroyed\n";
	$this->protocol->flush();
	$this->protocol->keepAlive();
  }
  function read($size) {
	return $this->protocol->read($size);
  }
  function setDefaultHandler() {
	$this->handler->flush();
	$this->handler = $this->defaultHandler;
  }
  function setAsyncHandler() {
	$this->handler = $this->asyncHandler;
  }
  function isAsync() {
	return $this->handler === $this->asyncHandler;
  }
  function handleRequests() {
	if(!MONO_CACHE_ENABLED) { $this->handler->handleRequests(); return 1;}
	do {
	  $tail_call = false;
	  $this->stack=array($this->arg=$this->simpleArg);
	  $this->idx = 0;
	  $this->parser->parse();
	  

	  if((count($this->stack)) > 1) {
		$arg = array_pop($this->stack);
		$this->apply($arg);
		$tail_call = 1;			
	  } else {
		$tail_call = 0;
	  }
	  $this->stack=null;
	} while($tail_call);
	return 1;
  }
  function getWrappedResult($wrap) {
	return $this->simpleArg->getResult($wrap);
  }
  function getInternalResult() {
	return $this->getWrappedResult(false);
  }
  function getResult() {
	return $this->getWrappedResult(true);
  }
  function getProxyFactory($type) {
	switch($type[0]) {
	case 'E':
	  $factory = $this->exceptionProxyFactory;
	  break;
	case 'C':
	  $factory = $this->iteratorProxyFactory;
	  break;
	case 'A':
	  $factory = $this->arrayProxyFactory;
	  break;
	case 'O':
	  $factory = $this->proxyFactory;
	}
	return $factory;
  }
  function link(&$arg, &$newArg) {
	$arg->linkResult($newArg->val);
	$newArg->parentArg = $arg;
  }
  function getExact($str) {
	return hexdec($str);
  }
  function getInexact($str) {
	$val = null;
  	sscanf($str, "%e", $val);
	return $val;
  }
  function begin($name, $st) {
	$arg = $this->arg;
	switch($name[0]) {
	case 'A':						

	  $object = $this->globalRef->get($this->getExact($st['v']));
	  $newArg = new mono_ApplyArg($this, 'A',
								  $this->parser->getData($st['m']),
								  $this->parser->getData($st['p']),
								  $object,
								  $this->getExact($st['n']));
	  $this->link($arg, $newArg);
	  array_push($this->stack, $this->arg = $newArg);
	  break;
	case 'X': 
	  $newArg = new mono_CompositeArg($this, $st['t']);
	  $this->link($arg, $newArg);
	  array_push($this->stack, $this->arg = $newArg);
	  break;
	case 'P':
	  if($arg->type=='H') { 

		$s = $st['t'];
		if($s[0]=='N') { 

		  $arg->setIndex($this->getExact($st['v']));
		} else {
		  $arg->setIndex($this->parser->getData($st['v']));
		}
	  } else {					

		$arg->setNextIndex();
	  }
	  break;
	case 'S':
	  $arg->setResult($this->parser->getData($st['v']));
	  break;
	case 'B':
	  $s=$st['v'];
	  $arg->setResult($s[0]=='T');
	  break;
	case 'L':					
	  $sign = $st['p'];
	  $val = $this->getExact($st['v']);
	  if($sign[0]=='A') $val*=-1;
	  $arg->setResult($val);
	  break;
	case 'D':
	  $arg->setResult($this->getInexact($st['v']));
	  break;
	case 'V':
	  if(MONO_DEBUG) {echo "setresult VOID:"; echo "\n";}
	  

	case 'N':					
	  $arg->setVoidSignature();
	  $arg->setResult(null);
	  break;
	case 'F':
	  break;
	case 'O': 
	  $arg->setFactory($this->getProxyFactory($st['p']));
	  $arg->setResult($this->asyncCtx=$this->getExact($st['v']));
	  $arg->setSignature($st['m']);
	  if(MONO_DEBUG) {echo "setresult object:"; echo sprintf("%x", $this->asyncCtx); echo "\n";}
	  break;
	case 'E':
	  $arg->setFactory($this->throwExceptionProxyFactory);
	  $arg->setResult($this->asyncCtx=$this->getExact($st['v']));
	  if(MONO_DEBUG) {echo "setresult exception:"; echo sprintf("%x", $this->asyncCtx); echo "\n";}
	  $arg->setException($st['m']);
	  break;
	default: 
	  $this->parser->parserError();
	}
  }
  function end($name) {
	switch($name[0]) {
	case 'X':
	  $frame = array_pop($this->stack);
	  $this->arg = $frame->parentArg;
	  break;
	}
  }
  function createParserString() {
	return new mono_ParserString();
  }
  function writeArg($arg) {
	if(is_string($arg)) {
	  $this->protocol->writeString($arg);
	} else if(is_object($arg)) {
	  if (!$arg instanceof mono_MonoType) throw new mono_IllegalArgumentException($arg);
	  $this->protocol->writeObject($arg->__mono);
	  return $arg;
	} else if(is_null($arg)) {
	  $this->protocol->writeObject(null);
	} else if(is_bool($arg)) {
	  $this->protocol->writeBoolean($arg);
	} else if(is_integer($arg)) {
	  $this->protocol->writeLong($arg);
	} else if(is_float($arg)) {
	  $this->protocol->writeDouble($arg);
	} else if(is_array($arg)) {
	  $wrote_begin=false;
	  foreach($arg as $key=>$val) {
		if(is_string($key)) {
		  if(!$wrote_begin) {
			$wrote_begin=1;
			$this->protocol->writeCompositeBegin_h(); 		
		  }
		  $this->protocol->writePairBegin_s($key);
		  $this->writeArg($val);
		  $this->protocol->writePairEnd();
		} else {
		  if(!$wrote_begin) {
			$wrote_begin=1;
			$this->protocol->writeCompositeBegin_h();
		  }
		  $this->protocol->writePairBegin_n($key);
		  $this->writeArg($val);
		  $this->protocol->writePairEnd();
		}
	  }
	  if(!$wrote_begin) {
		$this->protocol->writeCompositeBegin_a();
	  }
	  $this->protocol->writeCompositeEnd();
	}
	return null;
  }
  function writeArgs($args) {
	$n = count($args);
	for($i=0; $i<$n; $i++) {
	  $this->writeArg($args[$i]);
	}
  }
  function createObject($name, $args) {
	$this->protocol->createObjectBegin($name);
	$this->writeArgs($args);
	$this->protocol->createObjectEnd();
	$val = $this->getInternalResult();
	return $val;
  }
  function referenceObject($name, $args) {
	$this->protocol->referenceBegin($name);
	$this->writeArgs($args);
	$this->protocol->referenceEnd();
	$val = $this->getInternalResult();
	return $val;
  }
  function getProperty($object, $property) {
	$this->protocol->propertyAccessBegin($object, $property);
	$this->protocol->propertyAccessEnd();
	return $this->getResult();
  }
  function setProperty($object, $property, $arg) {
	$this->protocol->propertyAccessBegin($object, $property);
	$this->writeArg($arg);
	$this->protocol->propertyAccessEnd();
	$this->getResult();
  }
  function invokeMethod($object, $method, $args) {
	$this->protocol->invokeBegin($object, $method);
	$this->writeArgs($args);
	$this->protocol->invokeEnd();
	$val = $this->getResult();
	return $val;
  }
  function unref($object) {
	$this->protocol->writeUnref($object);
  }
  function apply($arg) {
	$name = $arg->p;
	$object = $arg->v;
	$ob = $object ? array(&$object, $name) : $name;
	try {
  	$res = $arg->getResult(true);
	  if((!$object && !function_exists($name)) || ($object && !method_exists($object, $name))) throw new MonoException("mono.lang.NoSuchMethodException", "$name");
	  $res = call_user_func_array($ob, $res);
	  $this->protocol->resultBegin();
	  $this->writeArg($res);
	  $this->protocol->resultEnd();
	} catch (MonoException $e) {
	  $trace = $e->getTraceAsString();
	  $this->protocol->resultBegin();
	  $this->protocol->writeException($e->__mono, $trace);
	  $this->protocol->resultEnd();
	} catch(Exception $ex) {
	   die ($ex);
	}	  
  }
  function cast($object, $type) {
	switch($type[0]) {
	case 'S': case 's':
	  return $this->invokeMethod(0, "castToString", array($object));
	case 'B': case 'b':
	  return $this->invokeMethod(0, "castToBoolean", array($object));
	case 'L': case 'I': case 'l': case 'i':
	  return $this->invokeMethod(0, "castToExact", array($object));
	case 'D': case 'd': case 'F': case 'f':
	  return $this->invokeMethod(0, "castToInExact", array($object));
	case 'N': case 'n':
	  return null;
	case 'A': case 'a':
	  return $this->invokeMethod(0, "castToArray", array($object));
	case 'O': case 'o':			
	  return $object;
	default: 
	  throw new mono_RuntimeException("$type illegal");
	}
  }
  function getContext() {
	return $this->invokeMethod(0, "getContext", array());
  }
  function getSession($args) {
	return $this->invokeMethod(0, "getSession", $args);
  }
  function getServerName() {
	return $this->protocol->getServerName();
  }
}
  

  

class mono_GlobalRef {
  public $map;
  public $client;
  public $mapsMerged;
  function mono_GlobalRef($client) {
	$this->map = array();
	$this->client = $client;
	$this->mapsMerged = true;
  }
  

  function mergeMaps() {
	if(!$this->mapsMerged && array_key_exists($this->client->RUNTIME, "SESSION")) {
	  $map = $_SESSION["MONO_GLOBAL_REF"];
	  foreach($map as $key=>$val) {
		if(!array_key_exists($this->map, $key)) {
		  $this->map[$key]=$val;
		}
	  }
	  $_SESSION["MONO_GLOBAL_REF"]=$this->map;
	}
	$this->mapsMerged = true;
  }
  function add($object) {
	if(is_null($object)) return 0;
	if(!$this->mapsMerged) $this->mergeMaps();
	return array_push($this->map, $object);
  }
  function get($id) {
	if(!$id) return 0;
	if(!$this->mapsMerged) $this->mergeMaps();
	return $this->map[--$id];
  }
}
  



class mono_NativeParser {
  public $parser, $handler;
  public $level, $event;
  public $buf;
  function mono_NativeParser($handler) {
	$this->handler = $handler;
	$this->parser = xml_parser_create();
	xml_parser_set_option($this->parser, XML_OPTION_CASE_FOLDING, 0);
	xml_set_object($this->parser, $this);
	xml_set_element_handler($this->parser, "begin", "end");
	xml_parse($this->parser, "<F>");
	$this->level = 0;
  }
  function begin($parser, $name, $param) {
  	if (false) $parser = $parser;
	$this->event = true;
	switch($name) {
	case 'X': case 'A': $this->level+=1;
	}
	$this->handler->begin($name, $param);
  }
  function end($parser, $name) {
  	if (false) $parser = $parser;
	$this->handler->end($name);
	switch($name) {
	case 'X': case 'A': $this->level-=1;
	}
  }
  function getData($str) {
	return base64_decode($str);
  }
  function parse() {
	do {
	  $this->event = false;
	  $buf = $this->buf = $this->handler->read(mono_Client::RECV_SIZE); 
	  $len = strlen($buf);
	  if(!xml_parse($this->parser, $buf, $len==0)) {
		die(sprintf("protocol error: %s, %s at col %d. Check the back end log for details.",
					$buf,
					xml_error_string(xml_get_error_code($this->parser)),
					xml_get_current_column_number($this->parser)));
	  }
	} while(!$this->event || $this->level>0);
  }
  function parserError() {
	die(sprintf("protocol error: %s. Check the back end log for details.", $this->buf));
  }
}
  



class mono_Parser {
  public $ENABLE_NATIVE = true;
  public $DISABLE_SIMPLE= false;
  public $parser;
  function mono_Parser($handler) {
	if($this->ENABLE_NATIVE && function_exists("xml_parser_create")) {
	  $this->parser = new mono_NativeParser($handler);
	  $handler->RUNTIME["PARSER"]="NATIVE";
	} else {
	  if($this->DISABLE_SIMPLE) die("no parser");
	  $this->parser = new mono_SimpleParser($handler);
	  $handler->RUNTIME["PARSER"]="SIMPLE";
	}
  }
  function parse() {
	$this->parser->parse();
  }
  function getData($str) {
	return $this->parser->getData($str);
  }
  function parserError() {
	$this->parser->parserError();
  }
}
  



class mono_SocketChannel {
  public $peer, $protocol;
  function mono_SocketChannel($peer, $protocol) {
	$this->peer = $peer;
	$this->protocol = $protocol;
  }
  function fwrite($data) {
	fwrite($this->peer, $data);
  }
  function fread($size) {
	return fread($this->peer, $size);
  }
  function keepAlive() {
	fwrite($this->peer, "<F p=\"A\" />");
	fread($this->peer, 10); // <F p="A"/>
  }
}


class mono_EmptyPipeChannel {
  function open($handler) {
  	if (false) $handler = $handler;
	throw new mono_RuntimeException("protocol error: socket channel names must not start with a slash");
  }
  function getName() {
	return null;
  }
  function keepAlive() {}
}


class mono_PipeChannel extends mono_EmptyPipeChannel {
  public $peer, $peerr, $peerr_desc, $name;
  public $fifo, $fifor;
  public $iname, $oname;
  function mono_PipeChannel($name) {
	$this->name = $name;
	$this->iname = $this->name . ".i";
	$mask = umask(0);
	$this->fifor = posix_mkfifo($this->iname, 0666);
	$this->oname = $this->name . ".o";
	$this->fifo = posix_mkfifo($this->oname, 0666);
	umask($mask);
  }
  function open($handler) {
  	if (false) $handler = $handler;
	$this->peerr = fopen($this->iname, "r");
	$this->peerr_desc = array($this->peerr);
	stream_set_blocking($this->peerr, false);
	stream_set_timeout($this->peerr, -1);
	$this->peer = fopen($this->oname, "w");
	unlink($this->iname);
	unlink($this->oname);
	unlink($this->name);
	stream_set_timeout($this->peer, -1);
	return $this;
  }
  function fwrite($data) {
	fwrite($this->peer, $data);
  }
  function fread($size) {
	static $empty = NULL;
	stream_select($this->peerr_desc, $empty, $empty, 1677216);
	return fread($this->peerr, $size);
  }
  function getName() {
	return $this->name;
  }
}


class mono_SocketHandler {
  public $protocol, $channel;
  function mono_SocketHandler($protocol, $channel) {
	$this->protocol = $protocol;
	$this->channel = $channel;
  }
  function write($data) {
	$this->channel->fwrite($data);
  }
  function read($size) {
	return $this->channel->fread($size);
  }
  function redirect() {}
  function keepAlive() {
	$this->channel->keepAlive();
  }
}


class mono_HttpHandler extends mono_SocketHandler {
  public $headers;
  public $redirect;
  public $context, $ssl, $port; 
  public $host; 
  public $socket; 
  function createPipeChannel($host, $pipe_dir) {
	if(!is_null($pipe_dir) && ($host == "127.0.0.1" || (substr($host,0,9) == "localhost")))
	  return new mono_PipeChannel(tempnam($pipe_dir, ".php_mono_bridge"));
	return new mono_EmptyPipeChannel();
  }
  function close() {
	fclose($this->socket);
  }
  function open() {
  	$errno = null; $errstr = null;
  

	$socket = fsockopen("{$this->ssl}{$this->host}", $this->port, $errno, $errstr, 30);
	if (!$socket) throw new mono_RuntimeException("Could not connect to the J2EE server {$this->ssl}{$this->host}:{$this->port}. Please start it, for example with the command: \"mono -jar MonoBridge.jar SERVLET:8080 3 MonoBridge.log\" or, if the back end has been compiled to native code, with \"modules/mono SERVLET:8080 3 MonoBridge.log\". Error message: $errstr ($errno)\n");
	return $socket;
  }
  function mono_HttpHandler($protocol, $ssl, $host, $port) {
	$this->protocol = $protocol;
	$this->ssl = $ssl;
	$this->host = $host;
	$this->port = $port;
	$this->channel = $this->createPipeChannel($host, $protocol->client->RUNTIME['PIPE_DIR']);
	$this->socket = $this->open();
  }
  function getCookies() {
	$str="";
	$first=true;
	foreach($_COOKIE as $k => $v) {
	  $str .= ($first ? "Cookie: $k=$v":"; $k=$v");
	  $first=false;
	}
	if(!$first) $str .= "\r\n";
	return $str;
  }
  function getContextFromCgiEnvironment() {
	$ctx = (array_key_exists('HTTP_X_MONOBRIDGE_CONTEXT', $_SERVER)
			?$_SERVER['HTTP_X_MONOBRIDGE_CONTEXT']
			:(array_key_exists('X_MONOBRIDGE_CONTEXT', $_SERVER)
			  ?$_SERVER['X_MONOBRIDGE_CONTEXT']
			  :null));
	return $ctx;
  }
  function getChannelName() {
	$name = $this->channel->getName();
	return !is_null($name) ? sprintf("X_MONOBRIDGE_CHANNEL: %s\r\n", $name) : null;
  }
  function getContext() {
	$ctx = $this->getContextFromCgiEnvironment();
	$context = "";
	if($ctx) {
	  $context = sprintf("X_MONOBRIDGE_CONTEXT: %s\r\n", $ctx);
	}
	return $context;
  }
  function getWebAppInternal() {
	$context = $this->protocol->webContext;
	if(isset($context)) return $context;
	

	return (MONO_SERVLET == "User" &&
			array_key_exists('PHP_SELF', $_SERVER) &&
			array_key_exists('HTTP_HOST', $_SERVER))
	  ? $_SERVER['PHP_SELF']
	  : null;
  }
  function getWebApp() {
	$context = $this->getWebAppInternal();
	if(is_null($context)) $context = MONO_SERVLET;
	if(is_null($context) || $context[0]!="/") 
	  $context = "/MonoBridge/MonoBridge.phpmonobridge";
	return $context;
  }
  function write($data) {
	$compatibility = $this->protocol->client->RUNTIME["PARSER"]=="NATIVE"
	  ? chr(0103)
	  : $compatibility = chr(0100);
	$this->protocol->client->RUNTIME["COMPATIBILITY"]=$compatibility;
	if(is_int(MONO_LOG_LEVEL)) {
	  $compatibility |= 128 | (7 & MONO_LOG_LEVEL)<<2;
	}
	$this->headers = null;
	$socket = $this->socket;
	$len = 2 + strlen($data);
	$webapp = $this->getWebApp();
	$cookies = $this->getCookies();
	$channel = $this->getChannelName();
	$context = $this->getContext();
	$redirect = $this->redirect;
	$res = "PUT ";
	$res .= $webapp;
	$res .= " HTTP/1.0\r\n";
	$res .= "Host: localhost\r\n";
	$res .= "Content-Length: "; $res .= $len; $res .= "\r\n";
	$res .= $context;
	$res .= $cookies;
	$res .= $redirect;
	if(!is_null($channel)) $res .= $channel;
	$res .= "\r\n";
	$res .= "\177";
	$res .= $compatibility;
	$res .= $data;
	fwrite($socket, $res); fflush($socket);
  }
  function doSetCookie($key, $val, $path) {
	$path=trim($path);
	$webapp = $this->getWebAppInternal(); if(!$webapp) $path="/";
	setcookie($key, $val, 0, $path);
  }
  function parseHeaders() {
	$this->headers = array();
	while (($str = trim(fgets($this->socket, mono_Client::RECV_SIZE)))) {
	  if($str[0]=='X') {
		if(!strncasecmp("X_MONOBRIDGE_REDIRECT", $str, 21)) {
		  $this->headers["redirect"]=trim(substr($str, 22));
		} else if(!strncasecmp("X_MONOBRIDGE_CONTEXT", $str, 20)) {
		  $this->headers["context"]=trim(substr($str, 21));
		}
	  } else if($str[0]=='S') {	
		if(!strncasecmp("SET-COOKIE", $str, 10)) {
		  $str=substr($str, 12);
		  $ar = explode(";", $str);
		  $cookie = explode("=",$ar[0]);
		  $path = "";
		  if(isset($ar[1])) $p=explode("=", $ar[1]);
		  if(isset($p)) $path=$p[1];
		  $this->doSetCookie($cookie[0], $cookie[1], $path);
		}
	  } else if($str[0]=='C') { 
		if(!strncasecmp("CONTENT-LENGTH", $str, 14)) {
		  $this->headers["content_length"]=trim(substr($str, 15));
		}
	  }
	}
  }
  function read($size) {
  	if (false) $size = $size;
 	if(is_null($this->headers)) $this->parseHeaders();
	$data = fread($this->socket, $this->headers['content_length']);
	return $data;
  }
  function getChannel($channelName) {
  	$errstr = null; $errno = null;
	if($channelName[0]=='/') return $this->channel->open($this);
	$peer = pfsockopen($this->host, $channelName, $errno, $errstr, 30);
	if (!$peer) throw new mono_RuntimeException("Could not connect to the context server {$this->host}:{$channelName}. Error message: $errstr ($errno)\n");
	stream_set_timeout($peer, -1);
	return new mono_SocketChannel($peer, $this->protocol);
  }
  function redirect() {
	if(!isset($this->headers["redirect"])) { 
	  throw new mono_RuntimeException("no Pipe- or SocketContextServer available.");
	}
	if(!isset($this->protocol->socketHandler)) {
	  $hostVec = mono_Protocol::getHost();
	  $this->host = $hostVec[0];
	  $channelName = $this->headers["redirect"];
	  $context = $this->headers["context"];
	  $len = strlen($context);
	  $len0 = chr(0xFF);
	  $len1 = chr($len&0xFF); $len>>=8;
	  $len2 = chr($len&0xFF);
	  $this->protocol->socketHandler=new mono_SocketHandler($this->protocol, $this->getChannel($channelName));
	  $this->protocol->write("\177${len0}${len1}${len2}${context}");
	  $this->context = sprintf("X_MONOBRIDGE_CONTEXT: %s\r\n", $context);
	}
	$this->close();
	$this->protocol->handler = $this->protocol->socketHandler;
  }
}


class mono_Protocol {
  public $client;
  public $webContext;
  public $serverName;
  function getOverrideHosts() {
	  if(array_key_exists('X_MONOBRIDGE_OVERRIDE_HOSTS', $_ENV)) {
		  $override = $_ENV['X_MONOBRIDGE_OVERRIDE_HOSTS'];
		  if(!is_null($override) && $override!='/') return $override;
	  }
	  return 
		(array_key_exists('HTTP_X_MONOBRIDGE_OVERRIDE_HOSTS_REDIRECT', $_SERVER)
		 ?$_SERVER['HTTP_X_MONOBRIDGE_OVERRIDE_HOSTS_REDIRECT']
		 :(array_key_exists('X_MONOBRIDGE_OVERRIDE_HOSTS_REDIRECT', $_SERVER)
		   ?$_SERVER['X_MONOBRIDGE_OVERRIDE_HOSTS_REDIRECT']
		   :null));
  }
  static function getHost() {
	static $host;
	if(!isset($host)) {
	  $hosts = explode(";", MONO_HOSTS);
	  $host = explode(":", $hosts[0]); 
	}
	return $host;
  }
  function createHttpHandler() {
	$hostVec = mono_Protocol::getHost();
	$host = $hostVec[0];
	$port = $hostVec[1];
	$overrideHosts = $this->getOverrideHosts();
	$ssl = "";
	if($overrideHosts) {
	 $s=$overrideHosts;
	 if((strlen($s)>2) && ($s[1]==':')) {
	   if($s[0]=='s')
		 $ssl="ssl://";
	   $s = substr($s, 2);
	 }
	 $webCtx = strpos($s, "//");
	 if($webCtx)
	   $host = substr($s, 0, $webCtx);
	 else
	   $host = $s;
	 $idx = strpos($host, ':');
	 if($idx) {
	   if($webCtx)
		 $port = substr($host, $idx+1, $webCtx);
	   else
		 $port = substr($host, $idx+1);
	   $host = substr($host, 0, $idx);
	 } else {
	   $port = "8080";
	 }
	 if($webCtx) $webCtx = substr($s, $webCtx+1);
	  $this->webContext = $webCtx;
	}
	$this->serverName = "$host:$port";
	return new mono_HttpHandler($this, $ssl, $host, $port);
  }
  

  function createSimpleHandler($channelName) {
	if(!is_string($channelName)) {
	  $errno = null; $errstr = null;
	  $peer = pfsockopen("127.0.0.1", $channelName, $errno, $errstr, 30);
	} else {
	  $type = $channelName[0];
	  if($type=='@' || $type=='/') {		 
		if($type=='@') $channelName[0]="\0"; 
		$peer = pfsockopen("unix://${channelName}", null, $errno, $errstr, 30);
	  }
	  else {					
		list($host, $channelName) = explode(":", $channelName);
		$peer = pfsockopen($host, $channelName, $errno, $errstr, 30);
	  }
	}
	if (!$peer) throw new mono_RuntimeException("Could not connect to the context server $channelName. Error message: $errstr ($errno)\n");
	stream_set_timeout($peer, -1);
	$handler = new mono_SocketHandler($this, new mono_SocketChannel($peer, $this));
	$compatibility = $this->client->RUNTIME["PARSER"]=="NATIVE"
	  ? chr(0103)
	  : $compatibility = chr(0100);
	$this->client->RUNTIME["COMPATIBILITY"]=$compatibility;
	if(is_int(MONO_LOG_LEVEL)) {
	  $compatibility |= 128 | (7 & MONO_LOG_LEVEL)<<2;
	}
	$this->write("\177$compatibility");
	$this->serverName = "127.0.0.1:$channelName";
	return $handler;
  }
  function createHandler() {
	if(!array_key_exists('X_MONOBRIDGE_OVERRIDE_HOSTS_REDIRECT', $_SERVER)
	 && function_exists("mono_get_default_channel") &&
	  ($defaultChannel=mono_get_default_channel())) {
	  return $this->createSimpleHandler($defaultChannel);
	} else {
	  return $this->createHttpHandler();
	}
  }
  function mono_Protocol ($client) {
	$this->client = $client;
	$this->handler = $this->createHandler();
  }
  function redirect() {
	$this->handler->redirect();
  }
  function read($size) {
	return $this->handler->read($size);
  }
  function sendData() {
	$this->handler->write($this->client->sendBuffer);
	$this->client->sendBuffer=null;
  }
  function sendAsyncData() {
	if(strlen($this->client->sendBuffer)>=mono_client::SEND_SIZE*3/4) {
	  $this->handler->write($this->client->sendBuffer);
	  $this->client->sendBuffer=null;
	}
  }
  function flush() {
	if(MONO_DEBUG) {
	  echo "sending::: "; echo $this->client->sendBuffer; echo "\n";
	}
	if(MONO_CACHE_ENABLED) 
	  $this->sendData();
	else
	  $this->client->handler->sendData();
  }
  function keepAlive() {
	$this->handler->keepAlive();
  }
  function handle() {
	$this->client->handleRequests();
  }
  function write($data) {
	$this->client->sendBuffer.=$data;
  }
  function finish() {
	$this->flush();
	$this->handle();
	$this->redirect();
  }
  function referenceBegin($name) {
	$this->client->sendBuffer.=$this->client->preparedToSendBuffer;
	if(MONO_DEBUG) {
	  echo "flushed preparedToSendBuffer: ".$this->client->preparedToSendBuffer."\n";
	}
	$this->client->preparedToSendBuffer=null;
	$signature=sprintf("<H p=\"1\" v=\"%s\">", $name);
	$this->write($signature);
	$signature[6]="2";
	$this->client->currentArgumentsFormat = $signature;
  }
  function referenceEnd() {
	$this->client->currentArgumentsFormat.=$format="</H>";
	$this->write($format);
	$this->finish();
	$this->client->currentCacheKey=null;
  }
  function createObjectBegin($name) {
	$this->client->sendBuffer.=$this->client->preparedToSendBuffer;
	if(MONO_DEBUG) {
	  echo "flushed preparedToSendBuffer: ".$this->client->preparedToSendBuffer."\n";
	}
	$this->client->preparedToSendBuffer=null;
	$signature=sprintf("<K p=\"1\" v=\"%s\">", $name);
	$this->write($signature);
	$signature[6]="2";
	$this->client->currentArgumentsFormat = $signature;
  }
  function createObjectEnd() {
	$this->client->currentArgumentsFormat.=$format="</K>";
	$this->write($format);
	$this->finish();
	$this->client->currentCacheKey=null;
  }
  function propertyAccessBegin($object, $method) {
	$this->client->sendBuffer.=$this->client->preparedToSendBuffer;
	if(MONO_DEBUG) {
	  echo "flushed preparedToSendBuffer: ".$this->client->preparedToSendBuffer."\n";
	}
	$this->client->preparedToSendBuffer=null;
	$this->write(sprintf("<G p=\"1\" v=\"%x\" m=\"%s\">", $object, $method));
	$this->client->currentArgumentsFormat="<G p=\"2\" v=\"%x\" m=\"${method}\">";
  }
  function propertyAccessEnd() {
	$this->client->currentArgumentsFormat.=$format="</G>";
	$this->write($format);
	$this->finish();
	$this->client->currentCacheKey=null;
  }
  function invokeBegin($object, $method) {
	$this->client->sendBuffer.=$this->client->preparedToSendBuffer;
	if(MONO_DEBUG) {
	  echo "flushed preparedToSendBuffer: ".$this->client->preparedToSendBuffer."\n";
	}
	$this->client->preparedToSendBuffer=null;
	$this->write(sprintf("<Y p=\"1\" v=\"%x\" m=\"%s\">", $object, $method));
	$this->client->currentArgumentsFormat="<Y p=\"2\" v=\"%x\" m=\"${method}\">";
  }
  function invokeEnd() {
	$this->client->currentArgumentsFormat.=$format="</Y>";
	$this->write($format);
	$this->finish();
	$this->client->currentCacheKey=null;
  }
  function resultBegin() {
	$this->client->sendBuffer.=$this->client->preparedToSendBuffer;
	if(MONO_DEBUG) {
	  echo "flushed preparedToSendBuffer: ".$this->client->preparedToSendBuffer."\n";
	}
	$this->client->preparedToSendBuffer=null;
	$this->write("<R>");
  }
  function resultEnd() {
	$this->write("</R>");
	$this->flush();
  }
  function writeString($name) {
	$this->client->currentArgumentsFormat.=$format="<S v=\"%s\"/>";
	$this->write(sprintf($format, htmlspecialchars($name, ENT_COMPAT)));
  }
  function writeBoolean($boolean) {
	$this->client->currentArgumentsFormat.=$format="<T v=\"%s\"/>";
	$this->write(sprintf($format, $boolean));
  }
  function writeLong($l) {
	$this->client->currentArgumentsFormat.="<J v=\"%d\"/>";
	if($l<0) {
	  $this->write(sprintf("<L v=\"%x\" p=\"A\"/>",-$l));
	} else {
	  $this->write(sprintf("<L v=\"%x\" p=\"O\"/>",$l));
	}
  }
  function writeULong($l) {
	$this->client->currentArgumentsFormat.=$format="<L v=\"%x\" p=\"O\"/>";
	$this->write(sprintf($format,$l));
  }
  function writeDouble($d) {
	$this->client->currentArgumentsFormat.=$format="<D v=\"%.14e\"/>";
	$this->write(sprintf($format, $d));
  }
  function writeObject($object) {
	$this->client->currentArgumentsFormat.=$format="<O v=\"%x\"/>";
	$this->write(sprintf($format, $object));
  }
  

  function writeException($object, $str) {
	$this->write(sprintf("<E v=\"%x\" m=\"%s\"/>",$object, htmlspecialchars($str, ENT_COMPAT)));
  }
  function writeCompositeBegin_a() {
	$this->write("<X t=\"A\">");
  }
  function writeCompositeBegin_h() {
	$this->write("<X t=\"H\">");
  }
  function writeCompositeEnd() {
	$this->write("</X>");
  }
  function writePairBegin_s($key) {
	$this->write(sprintf("<P t=\"S\" v=\"%s\">", htmlspecialchars($key, ENT_COMPAT)));
  }
  function writePairBegin_n($key) {
	$this->write(sprintf("<P t=\"N\" v=\"%x\">",$key));
  }
  function writePairBegin() {
	$this->write("<P>");
  }
  function writePairEnd() {
	$this->write("</P>");
  }
  function writeUnref($object) {
	$this->client->sendBuffer.=$this->client->preparedToSendBuffer;
	$this->client->preparedToSendBuffer=null;
	$this->write(sprintf("<U v=\"%x\"/>", $object));
  }
  function getServerName() {
	return $this->serverName;
  }
}
  



class mono_ParserString {
  public $string, $off, $length;
  function toString() {
	return $this->getString();
  }
  function getString() {
	return substr($this->string, $this->off, $this->length);
  }
}


class mono_ParserTag {
  public $n, $strings;
  function mono_ParserTag() {
	$this->strings = array();
	$this->n = 0;
  }
}


class mono_SimpleParser {
  public $SLEN=256; 
  public $handler;
  public $tag, $buf, $len, $s;
  public $type;
  function mono_SimpleParser($handler) {
	$this->handler = $handler;
	$this->tag = array(new mono_ParserTag(), new mono_ParserTag(), new mono_ParserTag());
	$this->len = $this->SLEN;
	$this->s = str_repeat(" ", $this->SLEN);
	$this->type = $this->VOJD;
  }
  public $BEGIN=0, $KEY=1, $VAL=2, $ENTITY=3, $VOJD=5, $END=6; 
  public $level=0, $eor=0; public $in_dquote, $eot=false;
  public $pos=0, $c=0, $i=0, $i0=0, $e;
  function RESET() {
	$this->type=$this->VOJD;
	$this->level=0;
	$this->eor=0;
	$this->in_dquote=false;
	$this->i=0;
	$this->i0=0;
  }
  function APPEND($c) {
	if($this->i>=$this->len-1) {
	  $this->s=str_repeat($this->s,2);
	  $this->len*=2;
	} 
	$this->s[$this->i++]=$c; 
  }
  function CALL_BEGIN() {
	$pt=&$this->tag[1]->strings;
	$st=&$this->tag[2]->strings;
	$t=&$this->tag[0]->strings[0];
	$name=$t->string[$t->off];
	$n = $this->tag[2]->n;
	$ar = array();
	for($i=0; $i<$n; $i++) {
	  $ar[$pt[$i]->getString()] = $st[$i]->getString();
	}
	$this->handler->begin($name, $ar);
  }
  function CALL_END() {
	$t=&$this->tag[0]->strings[0];
	$name=$t->string[$t->off];
	$this->handler->end($name);
  }
  function PUSH($t) { 
	$str = &$this->tag[$t]->strings;
	$n = &$this->tag[$t]->n;
	$this->s[$this->i]='|';
	if(!isset($str[$n])){$h=$this->handler; $str[$n]=$h->createParserString();}
	$str[$n]->string=&$this->s;
	$str[$n]->off=$this->i0;
	$str[$n]->length=$this->i-$this->i0;
	++$this->tag[$t]->n;
	$this->APPEND('|');
	$this->i0=$this->i;
  }
  function parse() {
	while($this->eor==0) {
	  if($this->c>=$this->pos) { 
		$this->buf=$this->handler->read(mono_Client::RECV_SIZE); 
		if(is_null($this->buf) || strlen($this->buf) == 0) die("protocol error. Check the back end log for details.");
		$this->pos=strlen($this->buf);
		if($this->pos==0) break;
		$this->c=0; 
	  }
	  switch(($ch=$this->buf[$this->c])) 
		{

		case '<': if($this->in_dquote) {$this->APPEND($ch); break;}
		  $this->level+=1;
		  $this->type=$this->BEGIN;
		  break;
		case '\t': case '\f': case '\n': case '\r': case ' ': if($this->in_dquote) {$this->APPEND($ch); break;}
		  if($this->type==$this->BEGIN) {
			$this->PUSH($this->type); 
			$this->type = $this->KEY; 
		  }
		  break;
		case '=': if($this->in_dquote) {$this->APPEND($ch); break;}
		  $this->PUSH($this->type);
		  $this->type=$this->VAL;
		  break;
		case '/': if($this->in_dquote) {$this->APPEND($ch); break;}
		  if($this->type==$this->BEGIN) { $this->type=$this->END; $this->level-=1; }
		  $this->level-=1;
		  $this->eot=true; 
		  break;
		case '>': if($this->in_dquote) {$this->APPEND($ch); break;}
		  if($this->type==$this->END){
			$this->PUSH($this->BEGIN);
			$this->CALL_END();
		  } else {
			if($this->type==$this->VAL) $this->PUSH($this->type);
			$this->CALL_BEGIN();
		  }
		  $this->tag[0]->n=$this->tag[1]->n=$this->tag[2]->n=0; $this->i0=$this->i=0;	  		

		  $this->type=$this->VOJD;
		  if($this->level==0) $this->eor=1; 
		  break;
		case ';':
		  if($this->type==$this->ENTITY) {
			switch ($this->s[$this->e+1]) {
			case 'l': $this->s[$this->e]='<'; $this->i=$this->e+1; break; 

			case 'g': $this->s[$this->e]='>'; $this->i=$this->e+1; break; 

			case 'a': $this->s[$this->e]=($this->s[$this->e+2]=='m'?'&':'\''); $this->i=$this->e+1; break; 

			case 'q': $this->s[$this->e]='"'; $this->i=$this->e+1; break; 

			default: $this->APPEND($ch);
			}
			$this->type=$this->VAL; 
		  } else {
			$this->APPEND($ch);
		  }
		  break;
		case '&': 
		  $this->type = $this->ENTITY;
		  $this->e=$this->i;
		  $this->APPEND($ch);
		  break;
		case '"':
		  $this->in_dquote = !$this->in_dquote;
		  if(!$this->in_dquote && $this->type==$this->VAL) {
			$this->PUSH($this->type);
			$this->type = $this->KEY;
		  }
		  break;
		default:
		  $this->APPEND($ch);
		} 

	  $this->c+=1;
	}
   	$this->RESET();
  }
  function getData($str) {
	return $str;
  }
  function parserError() {
	die(sprintf("protocol error: %s. Check the back end log for details.", $this->s));
  }
}
  



interface mono_MonoType {};


function __monoproxy_Client_getClient() {
  static $client;
  if(!isset($client)) {
	$client=new mono_Client();
  }
  return $client;
}


function mono_last_exception_get() {
  $client=__monoproxy_Client_getClient();
  return $client->getProperty(0, "lastException");
}


function mono_last_exception_clear() {
  $client=__monoproxy_Client_getClient();
  $client->setProperty(0, "lastException", null);
}


function mono_values_internal($object) {
  if(!$object instanceof mono_MonoType) return $object;
  $client=__monoproxy_Client_getClient();
  return $client->invokeMethod(0, "getValues", array($object));
}


function mono_values($object) {
  return mono_values_internal($object);
}


function mono_reset() {
  $client=__monoproxy_Client_getClient();
  user_error("Your script has called the privileged procedure \"mono_reset()\" which resets the mono back-end to its initial state. Therefore all mono caches are gone.");
  return $client->invokeMethod(0, "reset", array());
}


function mono_inspect_internal($object) {
  if(!$object instanceof mono_MonoType) throw new mono_IllegalArgumentException($object);
  $client=__monoproxy_Client_getClient();
  return $client->invokeMethod(0, "inspect", array($object));
}


function mono_inspect($object) {
  return mono_inspect_internal($object);
}


function mono_set_file_encoding($enc) {
  $client=__monoproxy_Client_getClient();
  return $client->invokeMethod(0, "setFileEncoding", array($enc));
}


function mono_instanceof_internal($ob, $clazz) {
  if(!$ob instanceof mono_MonoType) throw new mono_IllegalArgumentException($ob);
  if(!$clazz instanceof mono_MonoType) throw new mono_IllegalArgumentException($clazz);
  $client=__monoproxy_Client_getClient();
  return $client->invokeMethod(0, "instanceOf", array($ob, $clazz));
}


function mono_instanceof($ob, $clazz) {
  return mono_instanceof_internal($ob, $clazz);
}


function mono_cast_internal($object, $type) { 
	if(!$object instanceof mono_MonoType) throw new mono_IllegalArgumentException($object);
	return $object->__cast($type); 
}


function mono_cast($object, $type) { 
  return mono_cast_internal($object, $type);
}


function mono_require($arg) {
  $client=__monoproxy_Client_getClient();
  return $client->invokeMethod(0, "updateJarLibraryPath", 
							   array($arg, ini_get("extension_dir"), getcwd(), ini_get("include_path")));
}


function mono_session_array($args) {
  $client=__monoproxy_Client_getClient();
  if(!isset($args[0])) $args[0]=null;
  if(!isset($args[1])) $args[1]=false;
  if(!isset($args[2])) {
	$session_max_lifetime=(int)ini_get("session.gc_maxlifetime");
	if(!isset($session_max_lifetime)) $session_max_lifetime=1440;
	$args[2] = $session_max_lifetime;
  }
  if(function_exists("session_start")) {
	@session_start();
	$client->RUNTIME['SESSION']=true;
  }
  return $client->getSession($args);
}


function mono_session() {
  return mono_session_array(func_get_args());
}


function mono_server_name() {
  $client=__monoproxy_Client_getClient();
  return $client->getServerName();
}


function mono_context() {
  $client=__monoproxy_Client_getClient();
  return $client->getContext();
}


function mono_closure_array($args) {
  if(isset($args[2]) && ((!($args[2] instanceof mono_MonoType))&&!is_array($args[2])))
	throw new mono_IllegalArgumentException($args[2]);
  $client=__monoproxy_Client_getClient();
  $args[0] = isset($args[0]) ? $client->globalRef->add($args[0]) : 0;
  

  $client->protocol->invokeBegin(0, "makeClosure", "5", "6");
  $n = count($args);
  $client->protocol->writeULong($args[0]); // proper PHP "long" -> Mono 64 bit value conversion
  for($i=1; $i<$n; $i++) {
	$client->writeArg($args[$i]);
  }
  $client->protocol->invokeEnd();
  $val = $client->getResult();
  return $val;
}


function mono_closure() {
  return mono_closure_array(func_get_args());
}


function mono_begin_document() {
  if(MONO_CACHE_ENABLED) return false;
  $client = __monoproxy_Client_getClient();
  if($client->isAsync()) 
	throw new mono_RuntimeException("begin_document not allowed while in stream mode");
  $rc = $client->invokeMethod(0, "beginDocument", array());
  $client->setAsyncHandler();
  return $rc;
}


function mono_end_document() {
  if(MONO_CACHE_ENABLED) return false;
  $client = __monoproxy_Client_getClient();
  if(!$client->isAsync()) 
	throw new mono_RuntimeException("end_document not allowed when not in stream mode");
  $client->setDefaultHandler();
  return $client->invokeMethod(0, "endDocument", array());
}


class mono_MonoProxy implements mono_MonoType {
  public $__serialID, $__mono;
  public $__signature;
  public $__client;
  function mono_MonoProxy($mono, $signature){ 
	$this->__mono=$mono;
	$this->__signature=$signature;
	$this->__client = __monoproxy_Client_getClient();
  }
  function __cast($type) {
	return $this->__client->cast($this, $type);
  }
  function __sleep() {
	$lifetime = (int)ini_get("session.gc_maxlifetime");
	if(!isset($lifetime)) $lifetime = 1440;
	$args = array($this, $lifetime);
	$this->__serialID = $this->__client->invokeMethod(0, "serialize", $args);
	if(MONO_DEBUG) echo "proxy sleep called for $this->__mono, $this->__signature\n";
	return array("__serialID");
  }
  function __wakeup() {
	$lifetime = (int)ini_get("session.gc_maxlifetime");
	if(!isset($lifetime)) $lifetime = 1440;
	$args = array($this->__serialID, $lifetime);
	if(MONO_DEBUG) echo "proxy wakeup called for $this->__mono, $this->__signature\n";
	$this->__client = __monoproxy_Client_getClient();
	$this->__mono = $this->__client->invokeMethod(0, "deserialize", $args);
  }
  function __destruct() { 
	if(isset($this->__client)) 
	  $this->__client->unref($this->__mono);
  }
  function __get($key) { 
	return $this->__client->getProperty($this->__mono, $key);
  }
  function __set($key, $val) {
	$this->__client->setProperty($this->__mono, $key, $val);
  }
  function __call($method, $args) { 
	return $this->__client->invokeMethod($this->__mono, $method, $args);
  }
  function __toString() {
	return $this->__client->invokeMethod(0,"ObjectToString",array($this));
  }
}


class mono_objectIterator implements Iterator {
  public $proxy;
  public $__mono, $client;
  public $phpMap; 
  public $hasNext;
  function mono_ObjectIterator($monoProxy) {
	$this->proxy = $monoProxy;
	$this->client = __monoproxy_Client_getClient();
  }
  function rewind() {
	$proxy = array($this->proxy);
	$this->phpMap = 
	  $phpMap = $this->client->invokeMethod(0, "getPhpMap", $proxy);
	$this->__mono = $phpMap->__mono;
  }
  function valid() {
	if(isset($this->hasNext)) return $this->hasNext;
	return $this->hasNext =
	  $this->client->invokeMethod($this->__mono, "hasMore", array());
  }
  function next() {
	return $this->hasNext = 
	  $this->client->invokeMethod($this->__mono, "moveForward", array());
  }
  function key() {
	return 
	  $this->client->invokeMethod($this->__mono, "currentKey", array());
  }
  function current() {
	return 
	  $this->client->invokeMethod($this->__mono, "currentData", array());
  }
}


class mono_IteratorProxy extends mono_MonoProxy implements IteratorAggregate {
  function mono_IteratorProxy($mono, $signature) {
	parent::mono_MonoProxy($mono, $signature);
  }
  function getIterator() {
	return new mono_ObjectIterator($this);
  }
}


class mono_ArrayProxy extends mono_IteratorProxy implements ArrayAccess {
  function mono_ArrayProxy($mono, $signature) {
	parent::mono_MonoProxy($mono, $signature);
  }
  function offsetExists($idx) {
	$ar = array($this, $idx);
	return $this->__client->invokeMethod(0,"offsetExists", $ar);
  }  
  function offsetGet($idx) {
	$ar = array($this, $idx);
	return $this->__client->invokeMethod(0,"offsetGet", $ar);
  }
  function offsetSet($idx, $val) {
	$ar = array($this, $idx, $val);
	return $this->__client->invokeMethod(0,"offsetSet", $ar);
  }
  function offsetUnset($idx) {
	$ar = array($this, $idx);
	return $this->__client->invokeMethod(0,"offsetUnset", $ar);
  }
}


class mono_ExceptionProxy extends mono_MonoProxy {
  function mono_ExceptionProxy($mono, $signature){ 
	parent::mono_MonoProxy($mono, $signature);
  }
  function __toExceptionString($trace) {
	$args = array($this, $trace);
	return $this->__client->invokeMethod(0,"ObjectToString",$args);
  }
}


abstract class mono_AbstractMono implements IteratorAggregate,ArrayAccess,mono_MonoType {
  public $__delegate;
  public $__serialID;
  public $__factory;
  public $__mono, $__signature;
  function __createDelegate() {
	$proxy = $this->__delegate = 
	  $this->__factory->create($this->__mono, $this->__signature);
	$this->__mono = $proxy->__mono;
	$this->__signature = $proxy->__signature;
  }
  function __cast($type) {
	if(!isset($this->__delegate)) $this->__createDelegate();
	return $this->__delegate->__cast($type);
  }
  function __sleep() {
	if(!isset($this->__delegate)) $this->__createDelegate();
	$this->__delegate->__sleep();
	$this->__serialID = $this->__delegate->__serialID;
	return array("__delegate");
  }
  function __wakeup() {
	if(!isset($this->__delegate)) $this->__createDelegate();
	$this->__delegate->__wakeup();
	$this->__mono = $this->__delegate->__mono;
	$this->__client = $this->__delegate->__client;
  }
  function __get($key) { 
 	if(!isset($this->__delegate)) $this->__createDelegate();
	return $this->__delegate->__get($key);
  }
  function __set($key, $val) {
 	if(!isset($this->__delegate)) $this->__createDelegate();
	$this->__delegate->__set($key, $val);
  }
  function __call($method, $args) { 
	if(!isset($this->__delegate)) $this->__createDelegate();
	return $this->__delegate->__call($method, $args);
  }
  function __toString() {
	if(!isset($this->__delegate)) $this->__createDelegate();
	return $this->__delegate->__toString();
  }
  function getIterator() {
	if(!isset($this->__delegate)) $this->__createDelegate();
	if(func_num_args()==0) return $this->__delegate->getIterator();
	$args = func_get_args(); return $this->__call("getIterator", $args);
  }
  function offsetExists($idx) {
	if(!isset($this->__delegate)) $this->__createDelegate();
	if(func_num_args()==1) return $this->__delegate->offsetExists($idx);
	$args = func_get_args(); return $this->__call("offsetExists", $args);
  }
  function offsetGet($idx) {
	if(!isset($this->__delegate)) $this->__createDelegate();
	if(func_num_args()==1) return $this->__delegate->offsetGet($idx);
	$args = func_get_args(); return $this->__call("offsetGet", $args);
  }
  function offsetSet($idx, $val) {
	if(!isset($this->__delegate)) $this->__createDelegate();
	if(func_num_args()==2) return $this->__delegate->offsetSet($idx, $val);
	$args = func_get_args(); return $this->__call("offsetSet", $args);
  }
  function offsetUnset($idx) {
	if(!isset($this->__delegate)) $this->__createDelegate();
	if(func_num_args()==1) return $this->__delegate->offsetUnset($idx);
	$args = func_get_args(); return $this->__call("offsetUnset", $args);
  }
}


class Mono extends mono_AbstractMono {
  public $__client;
  

  function Mono() {
	$client = $this->__client = __monoproxy_Client_getClient();
	$args = func_get_args();
	$name = array_shift($args);
	if(is_array($name)) {$args = $name; $name = array_shift($args);}
$name="cli.".$name;
	$sig="&{$this->__signature}@{$name}";
	$len = count($args);
	$args2 = array();
	for($i=0; $i<$len; $i++) {
	  switch(gettype($val = $args[$i])) {
	  case 'boolean': array_push($args2, $val); $sig.='@b'; break; 
	  case 'integer': array_push($args2, $val); $sig.='@i'; break; 
	  case 'double': array_push($args2, $val); $sig.='@d'; break; 
	  case 'string': array_push($args2, htmlspecialchars($val, ENT_COMPAT)); $sig.='@s'; break; 
	  case 'array':$sig="~INVALID"; break; 
	  case 'object':
		if($val instanceof mono_MonoType) {
		  array_push($args2, $val->__mono);
		  $sig.="@o{$val->__signature}"; 
		}
		else {
		  $sig="~INVALID";
		}
		break;
	  case 'resource': array_push($args2, $val); $sig.='@r'; break; 
	  case 'NULL': array_push($args2, $val); $sig.='@N'; break; 
	  case 'unknown type': array_push($args2, $val); $sig.='@u'; break;
	  default: throw new mono_IllegalArgumentException($val);
	  }
	}
	if(MONO_CACHE_ENABLED && array_key_exists($sig, $client->methodCache)) {
	  if(MONO_DEBUG) { echo "cache hit for new Mono: $sig\n"; }
	  $cacheEntry = &$client->methodCache[$sig];
	  $client->sendBuffer.= $client->preparedToSendBuffer;
	  $client->preparedToSendBuffer=vsprintf($cacheEntry->fmt, $args2);
	  if(MONO_DEBUG) {
		print_r($args2);
		echo "set prepared to send buffer: $client->preparedToSendBuffer, $cacheEntry->fmt, for key: $sig\n";
	  }
 	  $this->__mono = ++$client->asyncCtx;
	  if(MONO_DEBUG) {echo "setresult from new Mono cache: object:"; echo sprintf("%x", $client->asyncCtx); echo "\n";}
	  $this->__factory = $cacheEntry->factory;
  	  $this->__signature = $cacheEntry->signature;
	} else {
	  if(MONO_DEBUG) { echo "cache miss for new Mono: $sig\n"; }
	  $client->currentCacheKey = $sig;
	  $delegate = $this->__delegate = $client->createObject($name, $args);
	  $this->__mono = $delegate->__mono;
	  $this->__signature = $delegate->__signature;
	}
  }
  function __destruct() {
	if(!isset($this->__client)) return;
	$client = $this->__client;
	$preparedToSendBuffer = &$client->preparedToSendBuffer;
	$asyncCtx = &$client->asyncCtx;
	if($preparedToSendBuffer && ($asyncCtx==$this->__mono)) {
	  $preparedToSendBuffer[6]="3";
	  if(MONO_DEBUG) {
		echo "cancel result proxy creation:"; echo $this->__mono; echo " {$client->preparedToSendBuffer}"; echo "\n";
	  }
	  $client->sendBuffer.=$preparedToSendBuffer;
	  $preparedToSendBuffer = null;
	  --$asyncCtx;
	} else {
	  if(!$this->__delegate) { 
		if(MONO_DEBUG) {
		  echo "unref mono:"; echo $this->__mono; echo "\n";
		}
		$client->unref($this->__mono);
	  }
	}	
  }
  

  function __call($method, $args) { 
	$client = $this->__client;
	$sig="@{$this->__signature}@$method";
	$len = count($args);
	$args2=array($this->__mono);
	for($i=0; $i<$len; $i++) {
	  switch(gettype($val = $args[$i])) {
	  case 'boolean': array_push($args2, $val); $sig.='@b'; break; 
	  case 'integer': array_push($args2, $val); $sig.='@i'; break; 
	  case 'double': array_push($args2, $val); $sig.='@d'; break; 
	  case 'string': array_push($args2, htmlspecialchars($val, ENT_COMPAT)); $sig.='@s'; break; 
	  case 'array':$sig="~INVALID"; break; 
	  case 'object':
		if($val instanceof mono_MonoType) {
		  array_push($args2, $val->__mono);
		  $sig.="@o{$val->__signature}"; 
		}
		else {
		  $sig="~INVALID";
		}
		break;
	  case 'resource': array_push($args2, $val); $sig.='@r'; break; 
	  case 'NULL': array_push($args2, $val); $sig.='@N'; break; 
	  case 'unknown type': array_push($args2, $val); $sig.='@u'; break; 
	  default: throw new mono_IllegalArgumentException($val);
	  }
	}
	if(MONO_CACHE_ENABLED && array_key_exists($sig, $client->methodCache)) {
	  if(MONO_DEBUG) { echo "cache hit for __call: $sig\n"; }
	  $cacheEntry = &$client->methodCache[$sig];
	  $client->sendBuffer.=$client->preparedToSendBuffer;
	  $client->preparedToSendBuffer=vsprintf($cacheEntry->fmt, $args2);
	  if(MONO_DEBUG) {
		print_r($args2);
		echo "set prepared to send buffer: {$client->preparedToSendBuffer}, {$cacheEntry->fmt}\n";
	  }
	  if($cacheEntry->resultVoid) {
		return null;
	  } else {
		$result = clone($client->cachedMonoPrototype);
		$result->__factory = $cacheEntry->factory;
		$result->__mono = ++$client->asyncCtx;
		if(MONO_DEBUG) {echo "setresult from __call cache: object:"; echo sprintf("%x", $client->asyncCtx); echo "\n";}
		$result->__signature = $cacheEntry->signature;
		return $result;
	  }
	} else {
	  if(MONO_DEBUG) { echo "cache miss for __call: $sig\n"; }
	  $client->currentCacheKey = $sig;
	  $retval = parent::__call($method, $args);
	  return $retval;
	}
  }
}


class mono_InternalMono extends Mono {
  function mono_InternalMono($proxy) {
	$this->__delegate = $proxy;
	$this->__mono = $proxy->__mono;
	$this->__signature = $proxy->__signature;
	$this->__client = $proxy->__client;
  }
}


class mono_class extends Mono {
  function mono_class() {
	$this->__client = __monoproxy_Client_getClient();
	$args = func_get_args();
	$name = array_shift($args);
	if(is_array($name)) { $args = $name; $name = array_shift($args); }
$name="cli.".$name;
	$delegate = $this->__delegate = $this->__client->referenceObject($name, $args);
	$this->__mono = $delegate->__mono;
	$this->__signature = $delegate->__signature;
  }
}


class MonoClass extends mono_class{}


class mono_exception extends Exception implements mono_MonoType {
  public $__serialID, $__mono, $__client;
  public $__delegate;
  public $__signature;
  

  function mono_exception() {
	$this->__client = __monoproxy_Client_getClient();
	$args = func_get_args();
	$name = array_shift($args);
	if(is_array($name)) { $args = $name; $name = array_shift($args); }
$name="cli.".$name;
	$delegate = $this->__delegate = $this->__client->createObject($name, $args);
	$this->__mono = $delegate->__mono;
	$this->__signature = $delegate->__signature;
  }
  

  function __cast($type) {
	return $this->__delegate->__cast($type);
  }
  

  function __sleep() {
	$rc = $this->__delegate->__sleep();
	$this->__serialID = $this->__delegate->__serialID;
	return $rc;
  }
  

  function __wakeup() {
	$this->__delegate->__wakeup();
	$this->__mono = $this->__delegate->__mono;
	$this->__client = $this->__delegate->__client;
  }
  

  function __get($key) { 
	return $this->__delegate->__get($key);
  }
  

  function __set($key, $val) {
	$this->__delegate->__set($key, $val);
  }
  

  function __call($method, $args) { 
	return $this->__delegate->__call($method, $args);
  }
  

  function __toString() {
	return $this->__delegate->__toExceptionString($this->getTraceAsString());
  }
}


class MonoException extends mono_exception {}


class mono_InternalException extends MonoException {
  function mono_InternalException($proxy) {
	$this->__delegate = $proxy;
	$this->__mono = $proxy->__mono;
	$this->__signature = $proxy->__signature;
	$this->__client = $proxy->__client;
  }
}


class mono_MonoProxyProxy extends Mono {
  function mono_MonoProxyProxy($client) {
	$this->__client = $client;
  }
}
}
?>
