<?php
// 将 tmd_tpl 包含进来
require './tmd_tpl.php'; // 请改为你的tmd_tpl所在路径

// 实例化 tmd_tpl
$TPL = new tmd_tpl();

// 下面是配置 tmd_tpl

// 指定模板目录，以斜杠结尾
$TPL->tpl_dir = './tpl/';

// 指定模板文件扩展名
// 建议以php为后缀，因为这样在Dreamweaver中php代码有高亮效果。
// 另外在Chrome浏览器中可以直接打开进行预览，用IE打开会提示下载。
$TPL->tpl_ext = '.tpl.php';

// 指定编译后模板的保存目录
$TPL->cache_dir = './tpl_c/';

// 设置编译后文件的有效期，单位：秒
$TPL->cache_time = 0; // 0是每次都重新编译，-1是永不过期，

// 自定义正则替换
$TPL->my_rep = array(
	'~(\.\./)+static/~' => '/proj-1/static/',
                          // ↑如果项目的访问地址是 http://localhost/proj-1/

    // 自定义替换这里有很多技巧，入门期先不写出来
);

// 普通赋值
$TPL->assign('site_name', '王道中强流');
$TPL->assign('site_intro', '我是一个PHP程序员，tmd_tpl的作者。');

// 支持数组
$blog = array(
    'title' => '去TMD的Smarty',
    
    'content' => '在讲解tmd_tpl的使用方法之前，我要先讲讲为什么要重新发明这个轮子。
那我们要从这世界上所谓的PHP模板引擎都为大家做了哪些贡献说起。
在PHP界谈模板引擎，必不可免的要拿Smarty开刀，
这个无比傻帽的却又带有一点点官方色彩的模板引擎，
如果没有我这样人富有正义感又富有创新精神的热血青年站出来，
不知道它还要继续毒害多少那些处于花季而又对PHP充满美丽幻想的少年。',
    
    // 目前只支持到二维数组，一般来说二维已经足够了
    'info' => array(
        'addtime' => '2012.3.11',
        'author' => '王忠强',
        'weibo' => 'http://t.qq.com/teeband',
    ),
);

$TPL->assign('blog', $blog);

// 模板中将演示循环输出这个数组
$links = array(
    '五月天中文网' => 'http://www.mayday.net.cn/',
    '福州996' => 'http://www.fz996.com/',
    '挺棒的' => 'http://www.teeband.cn/',
    '大部落' => 'http://www.dabulo.com',
    '伤不起' => 'http://www.3buqi.com/',
    '嘿！' => 'http://www.hei123.net/',
);
$TPL->assign('links', $links);

$TPL->display('index');