<?php
class db_mysql {
	var $link;
	var $istest;

	function init($istest) {
		$this->istest = $istest;
	}

	function connect($dbhost, $dbuser, $dbpw, $dbname = '') {
		if(!$this->link = @mysql_connect($dbhost, $dbuser, $dbpw)) {
			if($this->istest) {
				$this->halt('Cannot_connect_to_MySQL_server');
			} else {
				$this->halt('Can not connect to MySQL server');
			}
		}

		if($this->version() > '4.1') {
			mysql_query("SET NAMES binary", $this->link);

			if($this->version() > '5.0.1') {
				mysql_query("SET sql_mode=''", $this->link);
			}
		}

		if($dbname) {
			if(!mysql_select_db($dbname, $this->link)) {
				$this->halt('Cannot_find_dbname');
			}
		}

	}

	function select_db($dbname) {
		return mysql_select_db($dbname, $this->link);
	}

	function fetch_array($query, $result_type = MYSQL_ASSOC) {
		return mysql_fetch_array($query, $result_type);
	}

	function query($sql, $type = '') {
		global $debug, $discuz_starttime, $sqldebug, $sqlspenttimes;

		$func = $type == 'UNBUFFERED' && @function_exists('mysql_unbuffered_query') ?
			'mysql_unbuffered_query' : 'mysql_query';
		if(!($query = $func($sql, $this->link)) && $type != 'SILENT') {
			if($this->istest) {
				$this->halt('Cannot_find_table_or_pre_error');
			} else {
				$this->halt('MySQL Query Error', $sql);
			}
		}
		return $query;
	}

	function affected_rows() {
		return mysql_affected_rows($this->link);
	}

	function error() {
		return (($this->link) ? mysql_error($this->link) : mysql_error());
	}

	function errno() {
		return intval(($this->link) ? mysql_errno($this->link) : mysql_errno());
	}

	function result($query, $row = 0) {
		$query = @mysql_result($query, $row);
		return $query;
	}

	function result_first($sql) {
		return $this->result($this->query($sql), 0);
	}
	function num_rows($query) {
		$query = mysql_num_rows($query);
		return $query;
	}

	function num_fields($query) {
		return mysql_num_fields($query);
	}

	function free_result($query) {
		return mysql_free_result($query);
	}

	function insert_id() {
		return ($id = mysql_insert_id($this->link)) >= 0 ? $id : $this->result($this->query("SELECT last_insert_id()"), 0);
	}

	function fetch_row($query) {
		$query = mysql_fetch_row($query);
		return $query;
	}

	function fetch_fields($query) {
		return mysql_fetch_field($query);
	}

	function version() {
		return mysql_get_server_info($this->link);
	}

	function close() {
		return mysql_close($this->link);
	}

	function halt($message = '', $sql = '') {
		$error_dbtype = 'mysql';
		$is_test = $this->istest;
		require_once XCONVERT_ROOT.'./source/class/db_error.inc.php';
	}
}

class db_access {
	var $link;
	var $istest = 0;
	function init($istest){
		$this->istest = $istest;
	}
	function connect($databasepath,$dbusername,$dbpassword) {
		global $language;
		$this->link = new com("adodb.connection");
		if(!file_exists($databasepath)) {
			$this->halt($language['db_cannotfindacfile'].$databasepath.$language['db_checkfilepath']);
		}
		@$this->link->open("DRIVER={Microsoft Access Driver (*.mdb)};dbq=$databasepath;uid=$dbusername;pwd=$dbpassword");
		if($this->link->state == 0) {
			@$this->link->Open("Provider=Microsoft.Jet.OLEDB.4.0; Data Source=$access_mdb");
			if($dbc->state == 0) {
				if($istest == 1){
					$this->halt("Cannot_connect_access_server");
				}
				$this->halt($language['db_accesserr']);
			}
		}
		return $this->link;
	}

	function tableexist($tablename) {
		$rsSchema = $this->link->openSchema(20);
		$exist = 0;
		while(!$rsSchema->EOF) {
			if($rsSchema->fields['TABLE_TYPE']->value == 'TABLE') {
				if(strtolower($rsSchema->fields['TABLE_NAME']->value) == strtolower($tablename)) {
					$exist = 1;
				}
			}
			$rsSchema->movenext();
		}
		$rsSchema->close();
		return $exist;
	}

	function adodbclose() {
		$this->close();
		$this->release();
	}

	function execute($sql) {
		if(!$query = $this->link->execute($sql)) {
			$this->halt('ACCESS ERROR', $sql);
		}
		return $query;
	}

	function halt($message = '', $sql = '') {
		$error_dbtype = 'access';
		$is_test = $this->istest;
		require_once XCONVERT_ROOT.'./source/class/db_error.inc.php';
	}

}

class db_mssql{
	var $link;
	var $istest = 0;
	function init($istest){
		$this->istest = $istest;
	}
	function connect($dbhost, $dbuser, $dbpw, $dbname = '') {
		if(!function_exists('mssql_connect')) {
			$this->halt('db_phpmssql');
		}
		if(!$this->link = @mssql_connect($dbhost, $dbuser, $dbpw)) {
			$this->halt('db_conmssql');
		}

		if($dbname) {
			@!mssql_select_db($dbname, $this->link) ? $this->halt('source_cannot_find_dbname') : '';
		}

	}

	function select_db($dbname) {
		mssql_query("SET TEXTSIZE 1024000");
		return mssql_select_db($dbname, $this->link);
	}

	function query($sql) {
		if(!$query = mssql_query($sql)) {
			$this->halt('MSSQL ERROR', $sql);
		}
		return $query;
	}
	
	function fetch_array($query, $result_type = MYSQL_ASSOC) {
		return mssql_fetch_array($query, $result_type);
	}
	
	function fetch_assoc($query) {
		return mssql_fetch_assoc($query);
	}
	
	function result($query, $row = 0, $field) {
		return @mssql_result($query, $row, $field);
	}
	
	function halt($message = '', $sql = '') {
		$error_dbtype = 'mssql';
		$is_test = $this->istest;
		require_once XCONVERT_ROOT.'./source/class/db_error.inc.php';
	}
}

class db_oracle{
	var $link;
	var $istest = 0;
	function init($istest){
		$this->istest = $istest;
	}
	function connect($dbhost, $dbuser, $dbpw, $dbname = '') {	
		if(!function_exists('ocilogon')) {
			$this->halt('db_phpoci');
		}
		if(!$this->link = ocilogon($dbuser, $dbpw, $dbname)) {
			$this->halt('db_conoci');
		}

	}

	function query($sql) {
		$stmt = ociparse($this->link, $sql);
		ociexecute($stmt);
		if(!$stmt) {
			$this->halt('Oracle ERROR', $sql);
		}
		return $stmt;
	}
	
	function fetch_array($stmt, $result_type = OCI_ASSOC) {
		OCIFetchInto($stmt, $row, $result_type);
		return $row;
	}
	
	function result($stmt, $field) {
		return @ociresult($stmt, $field);
	}
	
	function halt($message = '', $sql = '') {
		$error_dbtype = 'mssql';
		$is_test = $this->istest;
		require_once XCONVERT_ROOT.'./source/class/db_error.inc.php';
	}
}
?>
