﻿/*
 * 主站登录导航条
 * 2014-09-17 JQuery版
 * 不存在Jquery会自动加载http://image.39.net/jquery/jquery-1.7.2.min.js
 * 不存在Passport会自动加载http://my.39.net/js/Passport.js
 * 登录退出完成后会调用一下NavCallback，如果需要登陆后Reload页面，请实现这个callback
 * NavLogin2()这个方法可以定制登录UI，但是需要自己处理callback
 *
 * 使用标准：
 * 登录前div id = NavLoginDiv
 * 登录后div id = NavLoginUserDiv
 * 登录弹窗div id = NavPopDiv //首页是NavPopDiv 其他子站点是drop_login，两个一起关闭
 * 登录出错提示div id = NavLoginError
 * 用户名input id = NavUserName
 * 密码input id = NavPassword
 * 登陆后昵称 id = NavNickName
 *
 * 登陆后消息链接 id = NavMyMessage
 * 登陆后Ask我的问答链接 id = NavMyAsk
 * 登陆后我的博客链接 id = NavBlog
 *
 * 欧锦华
 */
var NavPid = null;
var NavUserName = null;
var NavCallback = null;

if (typeof jQuery == 'undefined') {
    document.write(unescape("%3Cscript src='http://image.39.net/jquery/jquery-1.7.2.min.js' type='text/javascript'%3E%3C/script%3E"));
}

if (typeof Passport == 'undefined') {
    document.write(unescape("%3Cscript src='http://my.39.net/js/Passport.js' type='text/javascript'%3E%3C/script%3E"));
}

function NavSetupUserDataBase() {
    if (document.getElementById("NavNickName") != null) {
        document.getElementById("NavNickName").innerHTML = NavUserName;
        document.getElementById("NavNickName").setAttribute("title", NavUserName);
    }
    if (document.getElementById("NavMyAsk") != null) {
        document.getElementById("NavMyAsk").setAttribute("href", "http://my.39.net/UserCenter/default.aspx?menu=myquestions");
    }
    if (document.getElementById("NavBlog") != null) {
        document.getElementById("NavBlog").setAttribute("href", "http://blog.39.net/" + NavUserName);
    }
    if (document.getElementById("NavMyMessage") != null) {
        document.getElementById("NavMyMessage").innerHTML = "短消息";
        document.getElementById("NavMyMessage").setAttribute("href", "http://my.39.net/UserCenter/default.aspx?menu=inbox");
    }
}

function NavShow(id, num) {
    if (num == 1) {
        if (document.getElementById(id) != null)
            document.getElementById(id).style.display = "block";
    }
    else {
        if (document.getElementById(id) != null)
            document.getElementById(id).style.display = "none";
    }
}

function NavShowLoginBox(num) {
    if (document.getElementById("drop_login") != null) {
        NavShow("drop_login", num);
    }
    if (document.getElementById("NavPopDiv") != null) {
        NavShow("NavPopDiv", num);
    }
}

function NavLoginCheck() {
    if (NavIsLogin()) {

        NavPid = NavGetCookie("pid");
        NavUserName = NavGetCookie("username");

        NavSetupUserDataBase();

        NavShow("NavLoginDiv", 0);
        NavShow("NavLoginUserDiv", 1);
    }
    else {
        NavShow("NavLoginDiv", 1);
        NavShow("NavLoginUserDiv", 0);
    }
}

function NavIsLogin() {
    var pid = NavGetCookie("pid");
    var verify = NavGetCookie("verify");
    if (pid > 0 && verify > 0) {
        return true;
    }
    return false;
}

function NavShowError(txt) {
    var html = "";
    if (txt != "") {
        html = "<span>" + txt + "</span>";
    }
    if (document.getElementById("NavLoginError") != null) {
        document.getElementById("NavLoginError").innerHTML = html;
    } else {
        if (txt != "")
            alert(txt);
    }
}

function NavLoginCallback(cbtype, data) {
    if (cbtype == "check") {
        NavShowError(data.Info);
    } else if (cbtype == "login") {
        if (data.Success) {
            NavShowError("");
            NavLoginCheck();
            NavShowLoginBox(0);
        } else {
            NavShowError(data.Info);
            if (data.Data) {
                if (data.Data == "needSafeCode") {                    
                    window.location.href = "http://my.39.net?ref=" + window.location.href;
                }
            }
        }
        if (NavCallback != null) {
            NavCallback(cbtype, data);
        }
    } else if (cbtype == "logout") {
        NavLoginCheck();
        if (NavCallback != null) {
            NavCallback(cbtype, data);
        }
    } else if (cbtype == "error") {
        alert("服务器错误:" + data.Info);
    } else if (cbtype == "qq") {
    } else if (cbtype == "weibo") {
    } else if (cbtype == "skip") {
    }
}

function NavLogin(AppID) {
    if (AppID != null)
        Passport.SetOptions({ AppId: AppID });

    var userName = document.getElementById("NavUserName").value;
    var password = document.getElementById("NavPassword").value;

    userName = (userName == "用户名/邮箱/手机号") ? "" : userName;

    Passport.Login(userName, password, NavLoginCallback);
}

function NavLogin2(userName, password, AppID, callback) {
    if (AppID != null)
        Passport.SetOptions({ AppId: AppID });

    Passport.Login(userName, password, callback);
}

function NavLogout(AppID) {
    if (AppID != null)
        Passport.SetOptions({ AppId: AppID });

    Passport.Logout(NavLoginCallback);
}

function NavSetCookie(name, value, timeOut) {
    var exp = new Date();
    exp.setTime(exp.getTime() + timeOut * 60 * 1000);
    document.cookie = name + "=" + escape(value) + ";expires=" + exp.toGMTString() + ";path=/;domain=39.net";
}
function NavGetCookie(name) {
    var arr = document.cookie.match(new RegExp("(^| )" + name + "=([^;]*)(;|$)"));
    if (arr != null) return unescape(arr[2]); return null;
}
function NavDelCookie(name) {
    var exp = new Date();
    exp.setTime(exp.getTime() - 1);
    var cval = getCookie(name);
    if (cval != null) document.cookie = name + "=" + cval + ";expires=" + exp.toGMTString() + ";path=/;domain=39.net";
}

NavLoginCheck();

