﻿/*
create by hailiangli
create on 2013-10-18
desc: 265 union page
*/
var isIE = $.browser.isIE;

(function (_, $) {
    var _ctrip;
    _['union265'] = _Ctrip = {
        //应用启动
        appRun: function () {
            var _this = this;
            $.ready(function () {
                _this._pageInit();
                _this._xhrPars();
                _this._xhr();
                _this._events();
            });
        }

		, _config: {
		    ajaxURI: 'http://openapi.ctrip.com/logicsvr/AjaxServerNew.ashx',
		    aid: '15138',
		    sid: '456620',
            ouid: '',
		    secretKey: '50D756E4-BE7C-43D3-BD54-869CD5AEA4AA',
		    appid: ''
		}

		, Data: {}
		, Timer: {}
		, StaticData: {
		    'shanghai': [
				[{ city: '北京', py: 'beijing' }, { city: '杭州', py: 'hangzhou' }, { city: '南京', py: 'nanjing' }, { city: '苏州', py: 'suzhou' }, { city: '济南', py: 'jinan'}],
				[{ city: '无锡', py: 'wuxi' }, { city: '常州', py: 'changzhou' }, { city: '合肥', py: 'hefei' }, { city: '天津', py: 'tianjin' }, { city: '徐州', py: 'xuzhou'}],
				[{ city: '青岛', py: 'qingdao' }, { city: '宁波', py: 'ningbo' }, { city: '镇江', py: 'zhenjiang' }, { city: '曲阜', py: 'qufu' }, { city: '蚌埠', py: 'bengbu'}]
			],
		    'beijing': [
				[{ city: '上海', py: 'shanghai' }, { city: '太原', py: 'taiyuan' }, { city: '合肥', py: 'hefei' }, { city: '南京', py: 'nanjing' }, { city: '天津', py: 'tianjin'}],
				[{ city: '苏州', py: 'suzhou' }, { city: '西安', py: 'xian' }, { city: '杭州', py: 'hangzhou' }, { city: '徐州', py: 'xuzhou' }, { city: '青岛', py: 'qingdao'}],
				[{ city: '武汉', py: 'wuhan' }, { city: '广州', py: 'guangzhou' }, { city: '无锡', py: 'wuxi' }, { city: '长沙', py: 'changsha' }, { city: '石家庄', py: 'shijiazhuang2'}]
			],
		    'guangzhou': [
				[{ city: '武汉', py: 'wuhan' }, { city: '衡阳', py: 'hengyang' }, { city: '石家庄', py: 'shijiazhuang2' }, { city: '长沙', py: 'changsha' }, { city: '韶关', py: 'shaoguan'}],
				[{ city: '衡山', py: 'hengshan' }, { city: '北京', py: 'beijing' }, { city: '岳阳', py: 'yueyang' }, { city: '洛阳', py: 'luoyang' }, { city: '深圳', py: 'shenzhen'}],
				[{ city: '郴州', py: 'chenzhou' }, { city: '驻马店', py: 'zhumadian' }, { city: '郑州', py: 'zhengzhou' }, { city: '西安', py: 'xian' }, { city: '虎门', py: 'humen'}]
			],
		    'wuhan': [
				[{ city: '广州', py: 'guangzhou' }, { city: '虎门', py: 'humen' }, { city: '青岛', py: 'qingdao' }, { city: '深圳', py: 'shenzhen' }, { city: '太原', py: 'taiyuan'}],
				[{ city: '岳阳', py: 'yueyang' }, { city: '北京', py: 'beijing' }, { city: '杭州', py: 'hangzhou' }, { city: '株洲', py: 'zhuzhou' }, { city: '长沙', py: 'changsha'}],
				[{ city: '济南', py: 'jinan' }, { city: '宁波', py: 'ningbo' }, { city: '西安', py: 'xian' }, { city: '石家庄', py: 'shijiazhuang2' }, { city: '南京', py: 'nanjing'}]
			],
		    'hangzhou': [
				[{ city: '上海', py: 'shanghai' }, { city: '合肥', py: 'hefei' }, { city: '武汉', py: 'wuhan' }, { city: '北京', py: 'beijing' }, { city: '宁波', py: 'ningbo'}],
				[{ city: '曲阜', py: 'qufu' }, { city: '南京', py: 'nanjing' }, { city: '徐州', py: 'xuzhou' }, { city: '枣庄', py: 'zaozhuang' }, { city: '济南', py: 'jinan'}],
				[{ city: '温州', py: 'wenzhou' }, { city: '嘉兴', py: 'jiaxing' }, { city: '天津', py: 'tianjin' }, { city: '无锡', py: 'wuxi' }, { city: '镇江', py: 'zhenjiang'}]
			],
		    'xian': [
				[{ city: '北京', py: 'beijing' }, { city: '长沙', py: 'changsha' }, { city: '韶关', py: 'shaoguan' }, { city: '郑州', py: 'zhengzhou' }, { city: '深圳', py: 'shenzhen'}],
				[{ city: '渭南', py: 'weinan' }, { city: '武汉', py: 'wuhan' }, { city: '三门峡', py: 'sanmenxia2' }, { city: '虎门', py: 'humen' }, { city: '洛阳', py: 'luoyang'}],
				[{ city: '邯郸', py: 'handan' }, { city: '灵宝', py: 'lingbao' }, { city: '广州', py: 'guangzhou' }, { city: '驻马店', py: 'zhumadian' }, { city: '岳阳', py: 'yueyang'}]
			],
		    'nanjing': [
				[{ city: '上海', py: 'shanghai' }, { city: '济南', py: 'jinan' }, { city: '长沙', py: 'changsha' }, { city: '北京', py: 'beijing' }, { city: '青岛', py: 'qingdao'}],
				[{ city: '昆山', py: 'kunshan' }, { city: '杭州', py: 'hangzhou' }, { city: '无锡', py: 'wuxi' }, { city: '曲阜', py: 'qufu' }, { city: '苏州', py: 'suzhou'}],
				[{ city: '宁波', py: 'ningbo' }, { city: '蚌埠', py: 'bengbu' }, { city: '徐州', py: 'xuzhou' }, { city: '常州', py: 'changzhou' }, { city: '温州', py: 'wenzhou'}]
			]
		}

        //初始化页面
        , _pageInit: function () {
            this.validate = $(document).regMod('validate', '1.1');

            var paras = Ctrip.pages.parameters(true);
            if ( paras.allianceid ) this._config.aid = paras.allianceid;
            if ( paras.sid ) this._config.sid = paras.sid;
            if ( paras.ouid ) this._config.ouid = paras.ouid;

            this.validates.hotel();
            this.validates.flight();
            this.validates.travel();
            this.validates.train();
            this.validates.ticket();
            this.validates.phone();

            //图片预加载 定义
            this.imgload = {
                Journal: new UI.ImgLoad($('.raiders_list')[0], 'http://webresource.ctrip.com/ResUnionOnline/R9/WebApp/265/images/load_186_105.gif', ''),
                vacation: new UI.ImgLoad($('#area_vacationList')[0], 'http://webresource.ctrip.com/ResUnionOnline/R9/WebApp/265/images/load_266_258.gif', ''),
                group: new UI.ImgLoad($('.tuan_list')[0], 'http://webresource.ctrip.com/ResUnionOnline/R9/WebApp/265/images/load_186_105.gif', ''),
                hotel: new UI.ImgLoad($('#area_hotelList')[0], 'http://webresource.ctrip.com/ResUnionOnline/R9/WebApp/265/images/load_85_85.gif', '')
            }
        }

        //绑定事件
        , _events: function () {
            $('#s_tab>li').bind('click', this.handles.tabClick);
            $('#tabs_hotel>a').bind('click', this.handles.tab_hotelClick);
            $('#btn_vacationMoreCity').bind('click', this.handles.vacationMoreCity);
            $('#pkgStartCity_Picker a').bind('click', this.handles.vacationMoreCitySelected);
            $('#btn_vacationTabType a').bind('click', this.handles.btn_vacationTabTypeClick);
            $('#btn_lowprice').bind('click', function () { $('#mod_flight').css('display', ''); $('#mod_train').css('display', 'none'); });
            $('#btn_hotTrain').bind('click', function () { $('#mod_flight').css('display', 'none'); $('#mod_train').css('display', ''); });
            $('#btn_flight_moreCity').bind('click', this.handles.flightMoreCity);
            $('#btn_train_moreCity').bind('click', this.handles.trainMoreCity);
            $('#mask_flight_moreCity a').bind('click', this.handles.flight_MoreCitySelect);
            $('#mask_train_moreCity a').bind('click', this.handles.train_MoreCitySelect);
            $('#area_tabs_group a').bind('click', this.handles.groupTabs_Changed);
            $('.tuan_keyword a').bind('click', this.handles.groupSubTab_Changed);
            $('.nearby_htl a').bind('click', this.handles.nearlyClick);
            $('#area_links_travel a').bind('click', this.handles.travel_links_click);
            $('#area_links_ticket a').bind('click', this.handles.ticket_links_click);
            $('#area_links_wireless a').bind('click', this.handles.wireless_links_click);
            $('.fandt_side a').bind('click', this.handles.f_t_mod_links_click);
            $(document).bind('click', this.handles.documentClick);
            //国际酒店没有接口，暂时强行跳转到国际酒店首页
            $('#hotelSwitch_for').bind('click', function () {
                union265.Public.jump('http://hotels.ctrip.com/international/');
            });
        }

        //数据请求
		, _xhr: function () {
		    this.XHR.getShareList();
		    this.XHR.getHotelList();
		    this.XHR.getLowPrice();
		    this.XHR.getGroupList();
		    this.XHR.getVacation();
		    this.XHR.getTrainList('shanghai', '上海');
		}

        //根据城市三字码,返回城市中文名称
		, getCityNameByCityCode: function (cityCode) {
		    var reg = new RegExp('@[^|]*\\|([^|]*)\\|' + cityCode + '\\|');
            var _res = FLIGHT_CITYS_LOCAL.match(reg);
		    var cityName = _res && _res[1];
		    return cityName || "[看详情]";
		}

		, removeCityCode: function (city) {
		    return city.replace(/\([a-zA-z]+\)/, '');
		}

        //攻略社区,生成页码
		, journalPage: function (index) {
		    var pageDiv = $('.raiders_num'), lis = [];
		    for (var i = 1, len = union265.Data.journal.length; i <= len; i++) {
		        lis.push('<a href="javascript:void(0);" onclick="union265.Public.journalPageChange(this);" class="' + (i == index ? 'raiders_current' : '') + '">' + i + '</a>');
		    }
		    pageDiv.html(lis.join(''));
		}

		, groupPage: function (index) {
		    var pageDiv = $('.tuan_num'), lis = [];
		    for (var i = 1, len = union265.Data.group.length; i <= len; i++) {
		        lis.push('<a href="javascript:void(0);" onclick="union265.Public.groupPageChange(this);" class="' + (i == index ? 'current' : '') + '">' + i + '</a>');
		    }
		    pageDiv.html(lis.join(''));
		}

        //攻略社区,记录轮播
		, journalAutoPlay: function () {
		    var t = this;
		    clearInterval(this.Timer.journal);
		    this.Timer.journal = setInterval(function () {
		        var currentIndex = 0, index;
		        $('.raiders_num a').each(function (it) {
		            if (it.hasClass('raiders_current')) {
		                currentIndex = Number(it.html());
		                index = currentIndex + 1 > t.Data.journal.length ? 1 : currentIndex + 1;
		            }
		        });
		        $('.raiders_list').html($.tmpl.render($('#tmpl_JournalItem').html(), { data: t.Data.journal[index - 1] }));
		        t.imgload.Journal.load();
		        t.journalPage(index);
		    }, 10000);
		}

		, groupAutoPlay: function () {
		    var t = this;
		    clearInterval(this.Timer.group);
		    this.Timer.group = setInterval(function () {
		        var currentIndex = 0, index;
		        $('.tuan_num a').each(function (it) {
		            if (it.hasClass('current')) {
		                currentIndex = Number(it.html());
		                index = currentIndex + 1 > t.Data.group.length ? 1 : currentIndex + 1;
		            }
		        });
		        $('.tuan_list').html($.tmpl.render($('#tmpl_groupItem').html(), { data: t.Data.group[index - 1] }));
		        t.imgload.group.load();
		        t.groupPage(index);
		    }, 5000);
		}
    }

    /******************************************  Handle(s) ********************************************/
    _Ctrip.handles = {
        t: _Ctrip
		, documentClick: function (e) {
		    var e = e || window.event;
		    var tag = e.target || e.srcElement;
		    //渡假更多城市
		    if (tag != document.getElementById('btn_vacationMoreCity')
					&& !document.getElementById('pkgStartCity_Picker').contains(tag)) {
		        $('#pkgStartCity_Picker').css('display', 'none');
		    }
		    //机票更多城市
		    if (tag != document.getElementById('btn_flight_moreCity')
					&& !document.getElementById('mask_flight_moreCity').contains(tag)) {
		        $('#mask_flight_moreCity').css('display', 'none');
		    }
		    //火车票更多城市
		    if (tag != document.getElementById('btn_train_moreCity')
					&& !document.getElementById('mask_train_moreCity').contains(tag)) {
		        $('#mask_train_moreCity').css('display', 'none');
		    }
		}
		, nearlyClick: function () {
		    union265.Public.jump('http://hotels.ctrip.com/');
		}
        //点击选项卡时
        , tabClick: function () {
            $('#s_tab>li').removeClass('s_tab_current').removeClass('s_tab_nocurrent').addClass('s_tab_nocurrent');
            this.className = 's_tab_current';
            $('div.s_content').css('display', 'none')[this.getAttribute('data-index')].style.display = '';
        }
		, tab_hotelClick: function () {
		    if (!union265.xhr_hotel.loading && !$(this).hasClass('more')) {
		        $('#tabs_hotel>a').removeClass('current');
		        this.className = 'current';
		        $('#area_hotelFlagCity').html(this.innerHTML);
		        union265.xhr_hotel.cityID = this.getAttribute('data-id');
		        union265.xhr_hotel.cityName = this.innerHTML;
		        union265.XHR.getHotelList();
		    }
		}
		, vacationMoreCity: function () {
		    var tag = $('#pkgStartCity_Picker');
		    tag[0].style.display = tag[0].style.display == 'none' ? '' : 'none';
		}
		, flightMoreCity: function () {
		    var tag = $('#mask_flight_moreCity');
		    tag[0].style.display = tag[0].style.display == 'none' ? '' : 'none';
		}
		, trainMoreCity: function () {
		    var tag = $('#mask_train_moreCity');
		    tag[0].style.display = tag[0].style.display == 'none' ? '' : 'none';
		}
		, vacationMoreCitySelected: function () {
		    var btn = document.getElementById('btn_vacationMoreCity');
		    btn.innerHTML = this.innerHTML + '出发';
		    $('#pkgStartCity_Picker').css('display', 'none');
		    union265.xhr_vacation.startCity = this.getAttribute('data-id');
		    union265.xhr_vacation.TabType = "PERIPHERY";
		    union265.XHR.getVacation();
		}
		, flight_MoreCitySelect: function () {
		    var btn = document.getElementById('btn_flight_moreCity');
		    btn.innerHTML = this.innerHTML + '出发';
		    $('#mask_flight_moreCity').css('display', 'none');
		    union265.xhr_lowprice.dCity = this.getAttribute('data-code');
		    union265.XHR.getLowPrice();
		}
		, train_MoreCitySelect: function () {
		    document.getElementById('btn_train_moreCity').innerHTML = this.innerHTML + '出发';
		    union265.XHR.getTrainList(this.getAttribute('data-id'), this.innerHTML);
		    $('#mask_train_moreCity').css('display', 'none');
		}
		, btn_vacationTabTypeClick: function () {
		    if (!union265.xhr_vacation.loading) {
		        $('#btn_vacationTabType a').removeClass('current');
		        this.className = 'current';
		        union265.xhr_vacation.TabType = this.getAttribute('data-type');
		        union265.XHR.getVacation();
		    }
		}
		, groupTabs_Changed: function () {
		    if (!union265.xhr_group.loading && !$(this).hasClass('more')) {
		        $('#area_tabs_group a').removeClass('current');
		        this.className = 'current';
		        union265.xhr_group.City = this.innerHTML;
		        union265.XHR.getGroupList();
		    }
		}
		, groupSubTab_Changed: function () {
		    if (!union265.xhr_group.loading) {
		        $('.tuan_keyword a').removeClass('current');
		        this.className = 'current';
		        union265.xhr_group.ProductType = this.getAttribute('data-type');
		        union265.XHR.getGroupList();
		    }
		}
		, travel_links_click: function () {
		    var url = this.getAttribute('_src');
		    if (url == 'http://www.tujia.com/') {
		        window.open(url);
		    } else {
		        union265.Public.jump(url);
		    }
		}
        , wireless_links_click: function () {
            var url = this.getAttribute('_src');
            union265.Public.jump(url);
        }
		, ticket_links_click: function () {
		    union265.Public.jump(this.getAttribute('_src'));
		}
        , f_t_mod_links_click: function () {
            union265.Public.jump(this.getAttribute('_src'));
        }
        , btnDesHotelSearch: function () {
            if (this.verifies.hotel('des')) {
                var _uri = 'http://u.ctrip.com/union/CtripRedirect.aspx?TypeID=10&';
                var star = $('#sel_decHotel_Star').value();
                star = star == '0' ? '' : star;

                var _uri = ['http://u.ctrip.com/union/CtripRedirect.aspx?TypeID=10'];
                _uri.push('&CityName=' + encodeURI(encodeURI($('#txt_desHotel').value())));
                _uri.push('&CheckInDate=' + $('#txt_desHotelCkIn').value());
                _uri.push('&CheckOutDate=' + $('#txt_desHotelCkOt').value());
                _uri.push('&Starts=' + star);
                _uri.push('&Room=&MinPirce=&MaxPirce=');
                _uri.push('&HotelName=');
                _uri.push('&KeyWord=' + encodeURI(encodeURI($('#txt_desHotelKeyWorld').value())));
                _uri.push('&sid=' + this._config.sid);
                _uri.push('&allianceid=' + this._config.aid);
                _uri.push('&ouid=' + this._config.ouid);
                window.open(_uri.join(''));
            }
        }
        , btnForHotelSearch: function () {
            if (this.verifies.hotel('for')) {
                //alert('跳国际酒店');
            }
        }
        , btnDecFlightSearch: function () {
            if (this.verifies.flight('dec')) {
                var _uri = ['http://u.ctrip.com/union/CtripRedirect.aspx?TypeID=20&FlightWay=' + ($('*[name=flightway_dec]')[0].checked ? '0' : '1')];
                _uri.push('&StartCity=' + encodeURI(encodeURI($('#txt_decFlight_deptCity').value())));
                _uri.push('&DestCity=' + encodeURI(encodeURI($('#txt_decFlight_arriveCity').value())));
                _uri.push('&DepartDate=' + $('#txt_decFlight_deptDate').value());
                _uri.push('&ReturnDate=' + $('#txt_decFlight_arriveDate').value());
                _uri.push('&sid=' + this._config.sid);
                _uri.push('&allianceid=' + this._config.aid);
                _uri.push('&ouid=' + this._config.ouid);
                window.open(_uri.join(''));
            }

        }
        , btnForFlightSearch: function () {
            if (this.verifies.flight('for')) {
                var _uri = ['http://u.ctrip.com/union/CtripRedirect.aspx?TypeID=21&FlightWay=' + ($('*[name=flightway_for]')[0].checked ? '0' : '1')];
                _uri.push('&StartCity=' + encodeURI(encodeURI(this.removeCityCode($('#txt_forFlight_deptCity').value()))));
                _uri.push('&DestCity=' + encodeURI(encodeURI(this.removeCityCode($('#txt_forFlight_arriveCity').value()))));
                _uri.push('&DepartDate=' + $('#txt_forFlight_deptDate').value());
                _uri.push('&ReturnDate=' + $('#txt_forFlight_arriveDate').value());
                _uri.push('&sid=' + this._config.sid);
                _uri.push('&allianceid=' + this._config.aid);
                _uri.push('&ouid=' + this._config.ouid);
                window.open(_uri.join(''));
            }
        }
		, btnTravelSearch: function () {
		    if (this.verifies.travel()) {
		        var _uri = ['http://u.ctrip.com/union/CtripRedirect.aspx?TypeID=30'];
		        _uri.push('&StartCity=' + encodeURI(encodeURI($('#txt_travelDeptCity').value())));
		        _uri.push('&SearchValue=' + encodeURI(encodeURI($('#pkgdestCity').value())));
		        _uri.push('&Channel=1&CurrentTab=126');
		        _uri.push('&sid=' + this._config.sid);
		        _uri.push('&allianceid=' + this._config.aid);
                _uri.push('&ouid=' + this._config.ouid);
		        window.open(_uri.join(''));
		    }
		}
		, btnTrainSearch: function () {
		    if (this.verifies.train()) {
		        var _uri = [];
		        var startDate = $('#txt_train_deptDate').value();
		        var startCity = $('#hid_train_deptCity').value().trim();
		        var endCity = $('#hid_train_arriveCity').value().trim();
		        var type = $('*[name=traintype]')[0].checked ? 's' : 'd';
		        if (type === 's') {
		            _uri.push('http://u.ctrip.com/union/CtripRedirect.aspx?TypeID=90');
		            _uri.push('&StartDate=' + startDate);
		            _uri.push('&StartCity=' + startCity);
		            _uri.push('&DestCity=' + endCity);

		        } else {
		            _uri.push('http://u.ctrip.com/union/CtripRedirect.aspx?TypeID=92');
		            _uri.push('&StartDate=' + startDate);
		            _uri.push('&StartCity=' + startCity);
		            _uri.push('&StartCityCn=' + encodeURI(encodeURI($('#txt_train_deptCity').value())));
		            _uri.push('&DestCity=' + endCity);
		            _uri.push('&DestCityCn=' + encodeURI(encodeURI($('#txt_train_arriveCity').value())));
		           // _uri.push('&ReturnDate=' + $('#txt_train_arriveDate').value());
		        }

		        _uri.push('&sid=' + this._config.sid);
		        _uri.push('&allianceid=' + this._config.aid);
                _uri.push('&Ouid=' + this._config.ouid);

		        window.open(_uri.join(''));
		    }
		}
		, btnTicketSearch: function () {
		    if (this.verifies.ticket()) {
		        var st = encodeURI(encodeURI($('#txt_ticket_name').value()));
		        var _uri = ['http://u.ctrip.com/union/CtripRedirect.aspx?TypeID=30&Channel=1&CurrentTab=16'];
		        _uri.push('&StartCity=' + st);
		        _uri.push('&SearchValue=' + st);
		        _uri.push('&sid=' + this._config.sid);
		        _uri.push('&allianceid=' + this._config.aid);
                _uri.push('&ouid=' + this._config.ouid);
		        window.open(_uri.join(''));
		    }
		}
		, btnAppSendSMS: function () {
		    if (this.verifies.phone()) {
		        alert('发送短信');
		    }
		}
    }

    /******************************************  address template *************************************/
    _Ctrip.address = {
        addressMessageConfig: {
            cityname: {
                suggestionB: '支持中文/拼音/简拼输入',
                suggestion: "<strong>热门城市</strong>（可直接选择城市或输入城市全拼/简拼）"
            },
            addressTab: "省市",
            hotelPos: {
                suggestion: "可直接选择地理位置或输入位置关键词",
                titles: {
                    "zone": "商业区",
                    "location": "行政区",
                    "metro": "地铁线"
                },
                showAMap: true,
                isShowAmap: true,
                AMapTitle: '查看商业区地图',
                all: '全部',
                subCity: '下辖市/县：'
            }
        },
        defaultSuggestionInit: function (obj) {
            var spans = obj.find('.tab_box li');
            var uls = obj.find('div.city_item');
            if (!spans.length) { return; }
            function switchTab() {
                var _this = this;
                spans.each(function (span, i) {
                    if (span[0] == _this) {
                        span.addClass('selected');
                        uls[i].style.display = '';
                    } else {
                        span.removeClass('selected');
                        uls[i].style.display = 'none';
                    }
                });
            }
            var w = 30;
            for (var i = 0, n = spans.length; i < n; i++) { w += spans[i].offsetWidth; }
            var t = obj.find('div').first();
            if (t[0]) { if (w > 278) { t.css('width', '378px'); } }
            spans.bind('mousedown', switchTab);
            switchTab.apply(spans[0]);
        },
        addIframeStyle: function (a) {
            var doc = a[0].ownerDocument,
			stylesheet = doc.createElement('link');

            stylesheet.type = "text/css";
            stylesheet.rel = 'stylesheet';
            stylesheet.href = 'http://webresource.c-ctrip.com/styles/common/c_address.css';
            doc.getElementsByTagName('head')[0].appendChild(stylesheet);
        },
        getTmpl: function (flag, noSuggestion) {
            var t = this;
            return {
                suggestion: !noSuggestion ? '<div class="city_select_lhsl">' +
                                '<a class="close" style="display:none;" href="javascript:;">×</a>' +
                                '<p class="title">' + this.addressMessageConfig.cityname.suggestionB + '</p>' +
                                '<ul class="tab_box">{{enum(key) data}}<li><b></b><span>${key}</span></li>{{/enum}}</ul>' +
                                '{{enum(key,arr) data}}' +
                                '<div class="city_item">' +
                                    '{{each arr}}<a href="javascript:void(0);" title="${display}" data="${data}">${display}</a>{{/each}}' +
                                '</div>' +
                                '{{/enum}}' +
                            '</div>' : '',
                suggestionIpad: '<div class="city_select_lhsl">' +
                                '<a class="close" href="javascript:;">×</a>' +
                                '<p class="title">' + this.addressMessageConfig.cityname.suggestion + '</p>' +
                                '<ul class="tab_box">{{enum(key) data}}<li><b></b><span>${key}</span></li>{{/enum}}</ul>' +
                                '{{enum(key,arr) data}}' +
                                '<div class="city_item">' +
                                    '{{each arr}}<a href="javascript:void(0);" data="${data}">${display}</a>{{/each}}' +
                                '</div>' +
                                '{{/enum}}' +
                            '</div>',
                filter: '<div class="city_prompting_lhsl">' +
                            '{{if !hasResult}}<p class="not_found">{{tmpl message.noFilterResult}}</p>{{/if}}' +
                            '<div class="city_list">' +
                                '{{each (i,item) list}}' +
                                    '{{if cQuery.type(item)=="string"}}' +
                                        '<label>${item}</label>' +
                                    '{{else}}' +
                                        '<a class="city_item" href="javascript:;" data="${data}">' +
			                                '<span class="num">' + (flag ? '' : '${data.split("|")[8]}家酒店') + '</span>' +
			                                '<p class="city">${right.replace(val, "<span class=\'b\'>"+val+"</span>")}</p>' +
			                                ' <p class="province">${data.split("|")[9]}</p>' +
		                                '</a>' +
                                    '{{/if}}' +
                                '{{/each}}' +
                            '</div>' +
                            '{{if page.max>1}}' +
                                '<div class="c_page_mini" style="display: block;">' +
                                    '{{if page.current>0}}' +
                                        '<a href="javascript:void(0);" page="${page.current-1}">&lt;-</a>' +
                                    '{{/if}}' +
                                    '{{if page.current<2}}' +
                                        '{{loop(index) Math.min(5,page.max+1)}}' +
                                            '<a href="javascript:void(0);"{{if page.current==index}} class="address_current"{{/if}} page="${index}">${index+1}</a>' +
                                        '{{/loop}}' +
                                    '{{else page.current>page.max-2}}' +
                                        '{{loop(index) Math.max(0,page.max-4),page.max+1}}' +
                                            '<a href="javascript:void(0);"{{if page.current==index}} class="address_current"{{/if}} page="${index}">${index+1}</a>' +
                                        '{{/loop}}' +
                                    '{{else}}' +
                                        '{{loop(index) Math.max(0,page.current-2),Math.min(page.current+3,page.max+1)}}' +
                                            '<a href="javascript:void(0);"{{if page.current==index}} class="address_current"{{/if}} page="${index}">${index+1}</a>' +
                                        '{{/loop}}' +
                                    '{{/if}}' +
                                    '{{if page.current<page.max}}' +
                                        '<a href="javascript:void(0);" page="${page.current+1}">-&gt;</a>' +
                                    '{{/if}}' +
                                ' </div>' +
                            '{{/if}}' +
                        '</div>',
                filterPageSize: 7,
                suggestionInit: function (a) {
                    t.defaultSuggestionInit(a);
                    //add css for suggest START
                    isIE && t.addIframeStyle(a);
                    //bind close event to close btn
                    a.find('.close').bind('mousedown', function () { city[0].blur(); })
                } .bind(this)
            }
        }
    }

    /******************************************  Validate(s) ******************************************/
    _Ctrip.validates = {
        t: _Ctrip
        //酒店面版
        , hotel: function () {
            var _this = _Ctrip;
            //tabs
            $('#hotelSwitch>a').bind('click', function () {
                $('#hotelSwitch>a').removeClass('current');
                this.className = 'current';
                $('#hotelSwitch_dec, #hotelSwitch_for').css('display', 'none');
                $('#' + this.getAttribute('data-type')).css('display', '');
            });
            //mod(s) 
            $('#txt_desHotel').regMod('notice', '1.0', { name: "txt_desHotel", tips: "汉字/拼音", selClass: "notice_inputSel" });
            $('#txt_desHotelCkIn').regMod('notice', '1.0', { name: "desHotelCkIn", tips: "yyyy-mm-dd", selClass: "notice_inputSel" });
            $('#txt_desHotelCkOt').regMod('notice', '1.0', { name: "desHotelCkOt", tips: "yyyy-mm-dd", selClass: "notice_inputSel" });
            $('#txt_desHotelKeyWorld').regMod('notice', '1.0', { name: "desHotelKeyWorld", tips: "（选填）酒店名/地标/商圈", selClass: "notice_inputSel" });
            $('#txt_forHotel').regMod('notice', '1.0', { name: "txt_desHotel", tips: "中文/英文/拼音", selClass: "notice_inputSel" });
            $('#txt_forHotelCkIn').regMod('notice', '1.0', { name: "desHotelCkIn", tips: "yyyy-mm-dd", selClass: "notice_inputSel" });
            $('#txt_forHotelCkOt').regMod('notice', '1.0', { name: "desHotelCkOt", tips: "yyyy-mm-dd", selClass: "notice_inputSel" });
            $('#txt_forHotelName').regMod('notice', '1.0', { name: "desHotelKeyWorld", tips: "（选填）中文/英文", selClass: "notice_inputSel" });

            //-入住城市选择器
            $('#txt_desHotel').regMod("address", "1.0", {
                name: "cityname",
                jsonpSource: "http://webresource.c-ctrip.com/code/cquery/resource/address/hotel/online/city_20130427_gb2312.js?v=" + $('#_releaseNo_').value(),
                isFocusNext: true,
                isAutoCorrect: !0,
                isIframe: isIE,
                relate: { id: $("#hid_desHotel") },
                message: { noFilterResult: '找不到：${val}' },
                sort: ['^0$', '^1$', '0+'],
                sortFunction: function (a, b) { return b.data.split('|')[8] - a.data.split('|')[8] },
                template: _this.address.getTmpl()
            });

            $('#txt_forHotel').regMod("address", "1.0", {
                name: "cityname",
                jsonpSource: "http://webresource.ctrip.com/code/cquery/resource/address/hotelintl/online/city_gb2312.js?v=" + $('#_releaseNo_').value(),
                isFocusNext: true,
                isAutoCorrect: !0,
                isIframe: isIE,
                relate: { id: $("#hid_forHotel") },
                message: { noFilterResult: '找不到：${val}' },
                sort: ['^0$', '^1$', '0+'],
                sortFunction: function (a, b) { return b.data.split('|')[8] - a.data.split('|')[8] },
                template: _this.address.getTmpl(1)
            });

            //calendar
            $('#txt_desHotelCkIn').regMod('calendar', '6.0', {
                options: { showWeek: true, nextEl: '#txt_desHotelCkOt' },
                listeners: { onChange: function (input, value) { $('#txt_desHotelCkOt').data('minDate', value); } }
            });
            $('#txt_desHotelCkOt').regMod('calendar', '6.0', { options: { showWeek: true, reference: '#txt_desHotelCkIn'} });

            $('#txt_forHotelCkIn').regMod('calendar', '6.0', {
                options: { showWeek: true, nextEl: '#txt_forHotelCkOt' },
                listeners: { onChange: function (input, value) { $('#txt_forHotelCkOt').data('minDate', value); } }
            });
            $('#txt_forHotelCkOt').regMod('calendar', '6.0', { options: { showWeek: true, reference: '#txt_forHotelCkIn'} });

            //提交查询
            $('#btn_desHotelSearch').bind('click', this.t.handles.btnDesHotelSearch.bind(this.t));
            $('#btn_forHotelSearch').bind('click', this.t.handles.btnForHotelSearch.bind(this.t));
        }

        //机票面版
        , flight: function () {
            var t = this.t;
            //tabs
            $('#flightSwitch>a').bind('click', function () {
                $('#flightSwitch>a').removeClass('current');
                this.className = 'current';
                $('#flightSwitch_des, #flightSwitch_for').css('display', 'none');
                $('#' + this.getAttribute('data-type')).css('display', '');
            });

            //notice
            $('#txt_decFlight_deptCity').regMod('notice', '1.0', { name: "deptCity", tips: "汉字/拼音", selClass: "notice_inputSel" });
            $('#txt_decFlight_deptDate').regMod('notice', '1.0', { name: "deptDate", tips: "yyyy-mm-dd", selClass: "notice_inputSel" });
            $('#txt_decFlight_arriveCity').regMod('notice', '1.0', { name: "arriveCity", tips: "汉字/拼音", selClass: "notice_inputSel" });
            $('#txt_decFlight_arriveDate').regMod('notice', '1.0', { name: "arriveDate", tips: "yyyy-mm-dd", selClass: "notice_inputSel" });
            $('#txt_forFlight_deptCity').regMod('notice', '1.0', { name: "fdeptCity", tips: "中文/拼音/英文", selClass: "notice_inputSel" });
            $('#txt_forFlight_deptDate').regMod('notice', '1.0', { name: "fdeptDate", tips: "yyyy-mm-dd", selClass: "notice_inputSel" });
            $('#txt_forFlight_arriveCity').regMod('notice', '1.0', { name: "farriveCity", tips: "中文/拼音/英文", selClass: "notice_inputSel" });
            $('#txt_forFlight_arriveDate').regMod('notice', '1.0', { name: "farriveDate", tips: "yyyy-mm-dd", selClass: "notice_inputSel" });

            //events
            var flightway_dec = $('*[name=flightway_dec]');
            var flightway_for = $('*[name=flightway_for]');
            var flightway_dec_date = $('#txt_decFlight_arriveDate')[0].parentNode;
            var flightway_for_date = $('#txt_forFlight_arriveDate')[0].parentNode;
            flightway_dec.bind('click', function () {
                if (flightway_dec[1].checked) $(flightway_dec_date).removeClass('s_disable');
                else $(flightway_dec_date).addClass('s_disable');
            });
            flightway_for.bind('click', function () {
                if (flightway_for[1].checked) $(flightway_for_date).removeClass('s_disable');
                else $(flightway_for_date).addClass('s_disable');
            });
            $('#btn_swap_dec').bind('click', function () {
                var dept = $('#txt_decFlight_deptCity'),
                    arri = $('#txt_decFlight_arriveCity'),
                    hdept = $('#hid_decFlight_deptCity'),
                    harri = $('#hid_decFlight_arriveCity'),
                    tmp = {
                        txt: arri.value(),
                        val: harri.value()
                    }
                arri.value(dept.value());
                harri.value(hdept.value());
                dept.value(tmp.txt);
                hdept.value(tmp.val);
            });
            $('#btn_swap_for').bind('click', function () {
                var dept = $('#txt_forFlight_deptCity'),
                    arri = $('#txt_forFlight_arriveCity'),
                    tmp = arri.value();
                arri.value(dept.value());
                dept.value(tmp);
            });
            $('#btn_decFlightSearch').bind('click', this.t.handles.btnDecFlightSearch.bind(this.t));
            $('#btn_forFlightSearch').bind('click', this.t.handles.btnForFlightSearch.bind(this.t));
            //address
            $('#txt_decFlight_deptCity').regMod("address", "1.0", {
                name: "cityname",
                jsonpSource: "http://webresource.ctrip.com/ResUnionOnline/R9/address/flight_Domestic_" + cQuery.config('charset') + ".js?v=" + $('#_releaseNo_').value(),
                isFocusNext: true,
                isAutoCorrect: !0,
                isIframe: isIE,
                charset: 'gb2312',
                relate: { code: $("#hid_decFlight_deptCity") },
                message: { noFilterResult: '找不到：${val}' },
                sort: ['^0$', '^1$', '0+'],
                sortFunction: function (a, b) { return b.data.split('|')[8] - a.data.split('|')[8] },
                template: t.address.getTmpl(1)
            });
            $('#txt_decFlight_arriveCity').regMod("address", "1.0", {
                name: "cityname",
                jsonpSource: "http://webresource.ctrip.com/ResUnionOnline/R9/address/flight_Domestic_" + cQuery.config('charset') + ".js?v=" + $('#_releaseNo_').value(),
                isFocusNext: true,
                isAutoCorrect: !0,
                charset: 'gb2312',
                isIframe: isIE,
                relate: { code: $("#hid_decFlight_arriveCity") },
                message: { noFilterResult: '找不到：${val}' },
                sort: ['^0$', '^1$', '0+'],
                sortFunction: function (a, b) { return b.data.split('|')[8] - a.data.split('|')[8] },
                template: t.address.getTmpl(1)
            }); //flightintl_start_gb2312.js
            $('#txt_forFlight_deptCity').regMod("address", "1.0", {
                name: "cityname",
                jsonpSource:
                    "http://webresource.ctrip.com/ResUnionOnline/R9/address/flightintl_start_gb2312.js?v=" + new Date().getTime(),
                //"http://u.dev.sh.ctriptravel.com/web265/address/flightintl_start_gb2312.js",
                isFocusNext: true,
                isAutoCorrect: !0,
                isIframe: isIE,
                relate: { code: $("#hid_forFlight_deptCity") },
                message: { noFilterResult: '找不到：${val}' },
                sort: ['^0$', '^1$', '0+'],
                sortFunction: function (a, b) { return b.data.split('|')[8] - a.data.split('|')[8] },
                template: t.address.getTmpl(1)
            });
            $('#txt_forFlight_arriveCity').regMod("address", "1.0", {
                name: "cityname",
                jsonpSource:
                    "http://webresource.ctrip.com/ResUnionOnline/R9/address/flightintl_start_gb2312.js?v=" + new Date().getTime(),
                //"http://u.dev.sh.ctriptravel.com/web265/address/flightintl_start_gb2312.js",
                isFocusNext: true,
                isAutoCorrect: !0,
                isIframe: isIE,
                relate: { code: $("#hid_forFlight_arriveCity") },
                message: { noFilterResult: '找不到：${val}' },
                sort: ['^0$', '^1$', '0+'],
                sortFunction: function (a, b) { return b.data.split('|')[8] - a.data.split('|')[8] },
                template: t.address.getTmpl(1)
            });
            //calendar
            $('#txt_decFlight_deptDate').regMod('calendar', '6.0', {
                options: { showWeek: true, nextEl: '#txt_decFlight_arriveDate' },
                listeners: { onChange: function (input, value) { $('#txt_decFlight_arriveDate').data('minDate', value); } }
            });
            $('#txt_decFlight_arriveDate').regMod('calendar', '6.0', {
                options: { showWeek: true, reference: '#txt_decFlight_deptDate' },
                listeners: {
                    onChange: function () {
                        $(flightway_dec_date).removeClass('s_disable');
                        flightway_dec[1].checked = true;
                    }
                }
            });
            $('#txt_forFlight_deptDate').regMod('calendar', '6.0', {
                options: { showWeek: true, nextEl: '#txt_forFlight_arriveDate' },
                listeners: { onChange: function (input, value) { $('#txt_forFlight_arriveDate').data('minDate', value); } }
            });
            $('#txt_forFlight_arriveDate').regMod('calendar', '6.0', {
                options: { showWeek: true, reference: '#txt_forFlight_deptDate' },
                listeners: {
                    onChange: function () {
                        $(flightway_for_date).removeClass('s_disable');
                        flightway_for[1].checked = true;
                    }
                }
            });
        }

        //旅游面版
        , travel: function () {
            var t = this.t;
            UI.travelCityPicker.init('txt_travelDeptCity');
            $('#pkgdestCity').regMod('notice', '1.0', { name: "pkgdestCity", tips: "中文/拼音", selClass: "notice_inputSel" });
            $('#btn_travelSearch').bind('click', this.t.handles.btnTravelSearch.bind(this.t));
            $('#pkgdestCity').regMod("address", "1.0", {
                name: "pkgdestCity",
                jsonpSource: "http://webresource.ctrip.com/ResUnionOnline/R9/address/vacations_" + cQuery.config('charset') + ".js?v=" + $('#_releaseNo_').value(),
                isFocusNext: true,
                isAutoCorrect: !0,
                charset: 'gb2312',
                isIframe: isIE,
                relate: { name_py: $("#hid_pkgdestCity") },
                message: { noFilterResult: '找不到：${val}' },
                sort: ['^0$', '^1$', '0+'],
                sortFunction: function (a, b) { return b.data.split('|')[8] - a.data.split('|')[8] },
                template: t.address.getTmpl(1, 1)
            });
        }

        //火车票面版
        , train: function () {
            var t = this.t;

            var traintype = $('*[name=traintype]');
         //   var container = $($('#txt_train_arriveDate')[0].parentNode);

            $('#txt_train_deptCity').regMod('notice', '1.0', { name: "train_deptCity", tips: "中文/拼音/首字母", selClass: "notice_inputSel" });
            $('#txt_train_deptDate').regMod('notice', '1.0', { name: "train_deptDate", tips: "yyyy-mm-dd", selClass: "notice_inputSel" });
            $('#txt_train_arriveCity').regMod('notice', '1.0', { name: "train_arriveCity", tips: "中文/拼音/首字母", selClass: "notice_inputSel" });
         //   $('#txt_train_arriveDate').regMod('notice', '1.0', { name: "train_arriveDate", tips: "yyyy-mm-dd", selClass: "notice_inputSel" });

            $('#txt_train_deptCity').regMod("address", "1.0", {
                name: "txt_train_deptCity",
                jsonpSource: "http://webresource.ctrip.com/code/cquery/resource/address/train/station_gb2312.js?v=" + $('#_releaseNo_').value(),
                isFocusNext: true,
                isAutoCorrect: !0,
                isIframe: isIE,
                relate: { name_py: $("#hid_train_deptCity") },
                message: { noFilterResult: '找不到：${val}' },
                sort: ['^0$', '^1$', '0+'],
                sortFunction: function (a, b) { return b.data.split('|')[8] - a.data.split('|')[8] },
                template: t.address.getTmpl(1)
            });
            $('#txt_train_arriveCity').regMod("address", "1.0", {
                name: "txt_train_arriveCity",
                jsonpSource: "http://webresource.ctrip.com/code/cquery/resource/address/train/station_gb2312.js?v=" + $('#_releaseNo_').value(),
                isFocusNext: true,
                isAutoCorrect: !0,
                isIframe: isIE,
                relate: { name_py: $("#hid_train_arriveCity") },
                message: { noFilterResult: '找不到：${val}' },
                sort: ['^0$', '^1$', '0+'],
                sortFunction: function (a, b) { return b.data.split('|')[8] - a.data.split('|')[8] },
                template: t.address.getTmpl(1)
            });

            $('#txt_train_deptDate').regMod('calendar', '6.0', {
                options: { showWeek: true },
             //   listeners: { onChange: function (input, value) { $('#txt_train_arriveDate').data('minDate', value); } }
            });
           /* $('#txt_train_arriveDate').regMod('calendar', '6.0', {
                options: { showWeek: true, reference: '#txt_train_deptDate' },
                listeners: {
                    onChange: function () {
                        container.removeClass('s_disable');
                        traintype[1].checked = true;
                    }
                }
            });

            traintype.bind('click', function () {
                if (traintype[1].checked) container.removeClass('s_disable');
                else $(container).addClass('s_disable');
            });    */

            $('#btn_swap_train').bind('click', function () {
                var dept = $('#txt_train_deptCity'),
                    hdept = $('#hid_train_deptCity'),
					arri = $('#txt_train_arriveCity'),
                    harri = $('#hid_train_arriveCity'),
					tmp = {
					    txt: dept.value(),
					    val: hdept.value()
					}
                dept.value(arri.value());
                hdept.value(harri.value());
                arri.value(tmp.txt);
                harri.value(tmp.val);
            });

            $('#btn_trainSearch').bind('click', this.t.handles.btnTrainSearch.bind(this.t));
        }

        //门票面版
        , ticket: function () {
            var t = this.t;
            $('#txt_ticket_name').regMod('notice', '1.0', { name: "pkgdestCity", tips: "景点名/城市名", selClass: "notice_inputSel" });
            $('#btn_ticketSearch').bind('click', this.t.handles.btnTicketSearch.bind(this.t));

            $('#txt_ticket_name').regMod("address", "1.0", {
                name: "txt_ticket_name",
                jsonpSource: "http://webresource.ctrip.com/ResUnionOnline/R9/address/vacations_" + cQuery.config('charset') + ".js?v=" + $('#_releaseNo_').value(),
                isFocusNext: true,
                isAutoCorrect: !0,
                charset: 'gb2312',
                isIframe: isIE,
                relate: { name_py: $("#hid_ticket_name") },
                message: { noFilterResult: '找不到：${val}' },
                sort: ['^0$', '^1$', '0+'],
                sortFunction: function (a, b) { return b.data.split('|')[8] - a.data.split('|')[8] },
                template: t.address.getTmpl(1, 1)
            });
        }

        //手机面版
        , phone: function () {
            var t = this.t;
            $('#btn_appSendSMS').bind('click', this.t.handles.btnAppSendSMS.bind(this.t));
        }
    }

    /******************************************  verify(s) ********************************************/
    _Ctrip.verifies = {
        t: _Ctrip
        , hotel: function (type) {
            var _this = this.t, res = true, f = false, t = type === 'des';
            var hotelCity = t ? $('#txt_desHotel') : $('#txt_forHotel');
            var ckin = t ? $('#txt_desHotelCkIn') : $('#txt_forHotelCkIn');
            var ckot = t ? $('#txt_desHotelCkOt') : $('#txt_forHotelCkOt');

            if (hotelCity.value().trim().length == 0) showError(hotelCity, '请选择入往城市');
            if (!f && ckin.value().trim().length == 0) showError(ckin, '请选择入住日期');
            else if (!f && !ckin.value().isDate()) showError(ckin, '入住日期格式不正确');
            if (!f && ckot.value().trim().length == 0) showError(ckot, '请选择离店日期');
            else if (!f && !ckot.value().isDate()) showError(ckot, '离店日期格式不正确');
            if (!f && ckin.value().isEffectiveDate().diff(ckot.value().isEffectiveDate(), !1) >= 0) showError(ckot, '退房日期不能小于等于入住日期');
            if (!f && Math.abs(ckin.value().isEffectiveDate().diff(ckot.value().isEffectiveDate(), !1)) > 28) showError(ckot, '您的入住时间超过28天,请分订单预订');

            function showError(obj, errorMsg) {
                res = false; f = true;
                _this.validate.method("show", {
                    $obj: obj
					, data: errorMsg
					, removeErrorClass: true
                });
            }

            return res;
        }
        , flight: function (type) {
            var _this = this.t, res = true, f = false, t = type == 'dec';
            var way = t ? $('*[name=flightway_dec]')[0].checked ? 's' : 'd' : $('*[name=flightway_for]')[0].checked ? 's' : 'd';
            var deptCity = t ? $('#txt_decFlight_deptCity') : $('#txt_forFlight_deptCity');
            var arriCity = t ? $('#txt_decFlight_arriveCity') : $('#txt_forFlight_arriveCity');
            var deptDate = t ? $('#txt_decFlight_deptDate') : $('#txt_forFlight_deptDate');
            var arriDate = t ? $('#txt_decFlight_arriveDate') : $('#txt_forFlight_arriveDate');

            if (deptCity.value().trim().length == 0) showError(deptCity, '请选择出发城市');
            if (!f && arriCity.value().trim().length == 0) showError(arriCity, '请选择到达城市');
            if (!f && deptDate.value().trim().length == 0) showError(deptDate, '请选择出发日期');
            if (!f && !deptDate.value().isDate()) showError(deptDate, '出发日期格式不正确');
            if (way == 'd') {
                if (!f && arriDate.value().trim().length == 0) showError(arriDate, '请选择返程日期');
                if (!f && !arriDate.value().isDate()) showError(arriDate, '返程日期格式不正确');
                if (!f && arriDate.value().isEffectiveDate().diff(deptDate.value().isEffectiveDate(), !1) < 0) showError(arriDate, '返程日期不能早于出发日期');
            }

            function showError(obj, errorMsg) {
                res = false; f = true;
                _this.validate.method("show", {
                    $obj: obj
					, data: errorMsg
					, removeErrorClass: true
                });
            }

            return res;
        }
		, train: function () {
		    var res = true, trainType = $('*[name=traintype]')[0].checked ? 's' : 'd', f = false, _this = this.t;

		    var deptCity = $('#txt_train_deptCity'),
				arriCity = $('#txt_train_arriveCity'),
				deptDate = $('#txt_train_deptDate');
			//	arriDate = $('#txt_train_arriveDate');

		    if (deptCity.value().trim().length == 0) showError(deptCity, '请输入出发城市');
		    if (!f && arriCity.value().trim().length == 0) showError(arriCity, '请输入到达城市');
		    if (!f && deptDate.value().trim().length == 0) showError(deptDate, '请输入出发日期');
		    if (!f && !deptDate.value().isDate()) showError(deptDate, '出发日期格式不正确');
		  /*  if (trainType == 'd') {
		        if (!f && arriDate.value().trim().length == 0) showError(arriDate, '请输入返程日期');
		        if (!f && !arriDate.value().isDate()) showError(arriDate, '返程日期格式不正确');
		    }    */

		    function showError(obj, errorMsg) {
		        res = false; f = true;
		        _this.validate.method("show", {
		            $obj: obj
					, data: errorMsg
					, removeErrorClass: true
		        });
		    }

		    return res;
		}
		, travel: function () {
		    var _this = this.t, res = true;
		    var target = $('#pkgdestCity');
		    if (target.value().trim().length == 0) {
		        _this.validate.method("show", {
		            $obj: target
					, data: '请输入目的地'
					, removeErrorClass: true
		        });
		        res = false;
		    }

		    return res;
		}
		, ticket: function () {
		    var res = true, _this = this.t;
		    var target = $('#txt_ticket_name');
		    if (target.value().trim().length == 0) {
		        _this.validate.method("show", {
		            $obj: target
					, data: '请输入目的地'
					, removeErrorClass: true
		        });
		        res = false;
		    }
		    return res;
		}
		, phone: function () {
		    var res = true, f = false, _this = this.t;
		    var reg = /^((\(\d{3}\))|(\d{3}\-))?1(3|4|5|8)\d{9}$/;
		    var txt_app_mobile = $('#txt_app_mobile');
		    if (txt_app_mobile.value().trim().length == 0) showError(txt_app_mobile, '请输入手机号码');
		    if (!f && !reg.test(txt_app_mobile.value())) showError(txt_app_mobile, '您输入的手机号码不正确');

		    function showError(obj, errorMsg) {
		        res = false; f = true;
		        _this.validate.method("show", {
		            $obj: obj
					, data: errorMsg
					, removeErrorClass: true
		        });
		    }
		    return res;
		}
    }

    /******************************************  XHR Param(s) ********************************************/
    _Ctrip._xhrPars = function () {
        //hotel
        this.xhr_hotel = new Ctrip.Entitys.HotelSearchKWParameters();
        this.xhr_hotel.host = this._config.ajaxURI;
        this.xhr_hotel.method = Ctrip.config.method.JSONP;
        this.xhr_hotel.userId = "";
        this.xhr_hotel.allianceId = '1'; //this._config.aid;
        this.xhr_hotel.sid = '1'; //this._config.sid;
        this.xhr_hotel.secretKey = this._config.secretKey;
        this.xhr_hotel.cityID = '1';
        this.xhr_hotel.cityName = '北京';
        this.xhr_hotel.checkInDate = new Date().next(1);
        this.xhr_hotel.checkOutDate = new Date().next(2);
        this.xhr_hotel.pageSize = 9;
        this.xhr_hotel.pageNumber = 1;
        this.xhr_hotel.hotelFacility = { on: false, data: [] };

        //vacation
        this.xhr_vacation = new Ctrip.Entitys.VacationListParameters();
        this.xhr_vacation.host = this._config.ajaxURI;
        this.xhr_vacation.method = Ctrip.config.method.JSONP;
        this.xhr_vacation.userId = "";
        this.xhr_vacation.allianceId = '1'; //this._config.aid;
        this.xhr_vacation.sid = '1'; //this._config.sid;
        this.xhr_vacation.secretKey = this._config.secretKey;
        this.xhr_vacation.TopN = 7;
        this.xhr_vacation.startCity = '2';
        this.xhr_vacation.TabType = 'PERIPHERY';

        //lowPrice
        this.xhr_lowprice = new Ctrip.Entitys.FlightLowPriceSearchParameters();
        this.xhr_lowprice.host = this._config.ajaxURI;
        this.xhr_lowprice.method = Ctrip.config.method.JSONP;
        this.xhr_lowprice.userId = "";
        this.xhr_lowprice.allianceId = '1'; //this._config.aid;
        this.xhr_lowprice.sid = '1'; //this._config.sid;
        this.xhr_lowprice.secretKey = this._config.secretKey;
        this.xhr_lowprice.dCity = 'SHA';
        this.xhr_lowprice.aCity = '';
        this.xhr_lowprice.byDCity = true;
        this.xhr_lowprice.startDate = new Date().next(0);
        this.xhr_lowprice.endDate = new Date().next(45);

        //Journal
        this.xhr_journal = new Ctrip.Entitys.JournalListParameters();
        this.xhr_journal.host = this._config.ajaxURI;
        this.xhr_journal.method = Ctrip.config.method.JSONP;
        this.xhr_journal.userId = "";
        this.xhr_journal.allianceId = '1'; //this._config.aid;
        this.xhr_journal.sid = '1'; //this._config.sid;
        this.xhr_journal.secretKey = this._config.secretKey;
        this.xhr_journal.count = '8';

        //group
        this.xhr_group = new Ctrip.Entitys.GroupSearchParameters();
        this.xhr_group.host = this._config.ajaxURI;
        this.xhr_group.method = Ctrip.config.method.JSONP;
        this.xhr_group.userId = "";
        this.xhr_group.allianceId = '1'; //this._config.aid;
        this.xhr_group.sid = '1'; //this._config.sid;
        this.xhr_group.secretKey = this._config.secretKey;
        this.xhr_group.currentPage = 1;
        this.xhr_group.pageSize = 24;
        this.xhr_group.ProductType = '6';
        this.xhr_group.SortType = 0;
        this.xhr_group.City = '北京';
    }

    /******************************************  XHR(s) ********************************************/
    _Ctrip.XHR = {
        t: _Ctrip
		, getHotelList: function () {
		    var _t = this.t;
		    this.t.xhr_hotel.loading = true;
		    $('#area_hotelList').html('<div class="onloading"></div>');
		    new Ctrip.XHR.HotelSearchKW(this.t.xhr_hotel)
			.then(function (data) {
			    if (data.IsSucceed && data.TotalItems > 0) {
			        data.HotelDataList.each(function (it) {
			            it.jumpURI = 'http://u.ctrip.com/union/CtripRedirect.aspx?TypeID=60&CheckInDate='
							+ _t.xhr_hotel.checkInDate + '&CheckOutDate='
							+ _t.xhr_hotel.checkOutDate + '&sid='
							+ _t._config.sid + '&allianceid='
							+ _t._config.aid + '&ouid=' + _t._config.ouid + '&HotelID=' + it.HotelID;
			        });
			        $('#area_hotelList').html($.tmpl.render($('#tmpl_hotelItem').html(), data));
			        _t.imgload.hotel.load();
			    } else {
			        $('#area_hotelList').html('<div class="noresults" style="display:block;"><b></b><h2>很抱歉，暂时无法找到符合您要求的酒店。</h2><p>您可以试试更改搜索条件重新搜索。</p></div>');
			    }
			    _t.xhr_hotel.loading = false;
			});
		}
		, getVacation: function () {
		    var _t = this.t;
		    this.t.xhr_vacation.loading = true;
		    $('#area_vacationSubTab').html('');
		    $('#area_vacationList').html('<div class="onloading"></div>');
		    new Ctrip.XHR.VacationList(this.t.xhr_vacation)
			.then(function (data) {
			    _t.xhr_vacation.loading = false;
			    if (data.TabTypeList && data.TabTypeList.length > 0) {
			        _t.Data.vacation = data;
			        //sub tabs
			        var subTab = [];
			        data.TabTypeList[0].AllDestTabList.each(function (item, index) {
			            subTab.push('<a ' + (!index ? 'class="current"' : '') + ' data-index="' + index + '" href="javascript:void(0);" onclick="union265.Public.subTabClick(this,\'' + index + '\');">' + item.Name + '</a>');
			        });
			        //btn more
			        var more_url = '';
			        switch (_t.xhr_vacation.TabType) {
			            case 'PERIPHERY':
			                more_url = 'http://vacations.ctrip.com/around/';
			                break;
			            case 'DOMESTIC':
			                more_url = 'http://vacations.ctrip.com/domestic/';
			                break;
			            case 'ABROADINDEX':
			                more_url = 'http://vacations.ctrip.com/international/';
			                break;
			            case 'TRAFFIC':
			                more_url = 'http://vacations.ctrip.com/tickets/';
			                break;
			            case 'CRUISE':
			                more_url = 'http://vacations.ctrip.com/cruise/';
			                break;
			        }
			        subTab.push('<a class="more" onclick="union265.Public.vacationClick(this);" href="javascript:void(0);" _src="' + more_url + '">更多 &gt;</a>');
			        $('#area_vacationSubTab').html(subTab.join(''));

			        $('#area_vacationList').html($.tmpl.render($('#tmpl_vacationItem').html(), data.TabTypeList[0].CityRecommendList[0]));
			        _t.imgload.vacation.load();
			    } else {
			        $('#area_vacationList').html('<div class="noresults" style="display:block;"><b></b><h2>很抱歉，暂时无法找到符合您要求的产品。</h2><p>您可以试试更改搜索条件重新搜索。</p></div>');
			    }
			});
		}
		, getLowPrice: function () {
		    var _t = this.t;
		    var _d = [], c = 0, index = 1, _obj = [];
		    this.t.xhr_lowprice.loading = true;
		    $('#area_lowPriceList').html('<div class="onloading"></div>');
		    new Ctrip.XHR.FlightLowPriceSearch(this.t.xhr_lowprice)
			.then(function (data) {
			    if (data.IsSucceed && data.FlightsLowestPricesList && data.FlightsLowestPricesList.length > 0) {
			        for (var i = 0, len = data.FlightsLowestPricesList.length; i < len; i++) {
			            var list = data.FlightsLowestPricesList[i];
			            var item = null;

			            //找到最低价
			            list.each(function (it) {
			                it.LowestPrice = Number(it.LowestPrice) ? Number(it.LowestPrice) : 0;
			                if (!item) item = it; //还没赋值，把第一个赋值给它
			                else {
			                    if (Number(item.LowestPrice) == 0) item = it; //如果已经赋值 并 价格为0,则不用比较把这个赋值给它
			                    else if (Number(it.LowestPrice) > 0 && Number(item.LowestPrice) > it.LowestPrice) item = it; //否则, 把价格更低(不能是0)的赋值给它
			                }
			            });

			            if (Number(item.LowestPrice) > 0 && c < 9) {
			                var _a = item.DepartDate.split('T')[0].split('-');
			                var _tmp = {
			                    deptDate: _a[1] + '-' + _a[2],
			                    deptCity: _t.getCityNameByCityCode(item.DepartCity),
			                    arriCity: _t.getCityNameByCityCode(item.ArrvieCity),
			                    price: item.LowestPrice,
			                    jumpURI: 'http://flights.ctrip.com/booking/' + item.DepartCity + '-' + item.ArrvieCity + '-day-1.html?DDate1=' + item.DepartDate.split('T')[0] + '#ctm_ref= chp_flt_1_p'
			                }

			                _obj.push(_tmp);
			                if (_obj.length == 3) { _d.push(_obj); _obj = []; }
			                c++;
			            }
			        }
			        $('#area_lowPriceList').html($.tmpl.render($('#tmpl_lowpriceItem').html(), { data: _d }));
			    } else $('#area_lowPriceList').html('<div class="noresults" style="display:block;"><b></b><h2>很抱歉，暂时无法找到近期低价机票。</h2><p>您可以试试点击<a href="javascript:void(0);" onclick="union265.XHR.getLowPrice();">重新搜索</a>。</p></div>');
			    _t.xhr_lowprice.loading = false;
			});
		}
		, getGroupList: function () {
		    var _t = this.t;
		    var _d = [], index = 1, _obj = [];
		    this.t.xhr_group.loading = true;
		    clearInterval(this.t.Timer.group);
		    $('.tuan_list').html('<div class="onloading" style="height:182px;"></div>');
		    $('.tuan_num').html('');
		    new Ctrip.XHR.GroupSearch(this.t.xhr_group)
			.then(function (data) {
			    if (data.IsSucceed && data.GroupDataList.length > 0) {
			        for (var i = 0, len = data.GroupDataList.length; i < len; i++) {
			            var it = data.GroupDataList[i];
			            var _tmp = {
			                img: it.Pictures,
			                id: it.ProductId,
			                name: it.Name,
			                minPrice: it.NowPrice,
			                productPrice: it.ProductPrice,
			                saled: it.SaledItemCount,
			                jumpURI: 'http://tuan.ctrip.com/group/' + it.ProductId + '.html'
			            }
			            _obj.push(_tmp);
			            if (_obj.length == 4) { _d.push(_obj); _obj = []; }
			        }
			        _t.Data.group = _d;
			        $('.tuan_list').html($.tmpl.render($('#tmpl_groupItem').html(), { data: _d[0] }));
			        _t.imgload.group.load();
			        _t.groupPage(1);
			        _t.groupAutoPlay();
			    } else $('.tuan_list').html('<div class="noresults" style="display:block;"><b></b><h2>很抱歉，暂时无法找到符合您要求的产品。</h2><p>您可以试试更改搜索条件重新搜索。</p></div>');
			    _t.xhr_group.loading = false;
			});
		}
		, getShareList: function () {
		    var _t = this.t;
		    var _d = [], index = 1, _obj = [];
		    this.t.xhr_journal.loading = true;
		    clearInterval(this.t.Timer.journal);
		    $('.raiders_list').html('<div class="onloading"></div>');
		    new Ctrip.XHR.JournalList(this.t.xhr_journal)
			.then(function (data) {
			    if (data.Result && data.Result.length > 0) {
			        for (var i = 0, len = data.Result.length; i < len; i++) {
			            var item = data.Result[i];
			            var _tmp = {
			                brief: item.Brief,
			                nickName: item.Nickname,
			                title: item.Title,
			                userid: item.UserId,
			                imageUrl: item.CoverImageUrl || item.CoverImageBaseUrl,
			                url: item.Url
			            }

			            _obj.push(_tmp);
			            if (_obj.length == 2) { _d.push(_obj); _obj = []; }
			        }
			        _t.Data.journal = _d;
			        $('.raiders_list').html($.tmpl.render($('#tmpl_JournalItem').html(), { data: _d[0] }));
			        _t.imgload.Journal.load();
			        _t.journalPage(1);
			        _t.journalAutoPlay();
			    } else $('.raiders_list').html('<div class="noresults" style="display:block; background-color:#EFF4FA"><b></b><h2>很抱歉，查无结果。</h2><p>您可以试试<a href="javascript:void(0);" onclick="union265.XHR.getShareList();">重新搜索</a>。</p></div>');
			    _t.xhr_journal.loading = false;
			});
		}
		, getTrainList: function (cityPY, cityName) {
		    var _t = this.t;
		    var data = union265.StaticData[cityPY];
		    data.dCity = cityName;
		    data.dCityPY = cityPY;
		    $('#area_trainList').html($.tmpl.render($('#tmpl_trainItem').html(), { data: data }));
		}
    }

    /******************************************  Public ********************************************/
    _Ctrip.Public = {
        subTabClick: function (tag, index) {
            $('#area_vacationSubTab a').removeClass('current');
            tag.className = 'current';
            $('#area_vacationList').html($.tmpl.render($('#tmpl_vacationItem').html(), union265.Data.vacation.TabTypeList[0].CityRecommendList[index]));
            union265.imgload.vacation.load();
        },
        journalPageChange: function (tag) {
            if (!$(tag).hasClass('raiders_current')) {
                $('.raiders_num a').removeClass('raiders_current');
                tag.className = 'raiders_current';
                var index = tag.innerHTML;
                $('.raiders_list').html($.tmpl.render($('#tmpl_JournalItem').html(), { data: union265.Data.journal[Number(index) - 1] }));
                union265.imgload.Journal.load();
                union265.journalAutoPlay();
            }
        },
        groupPageChange: function (tag) {
            if (!$(tag).hasClass('current')) {
                $('.tuan_num a').removeClass('current');
                tag.className = 'current';
                var index = tag.innerHTML;
                $('.tuan_list').html($.tmpl.render($('#tmpl_groupItem').html(), { data: union265.Data.group[Number(index) - 1] }));
                union265.imgload.group.load();
                union265.groupAutoPlay();
            }
        },
        jump: function (url) {
            var url = 'http://u.ctrip.com/union/CtripRedirect.aspx?TypeID=2&Allianceid=' + union265._config.aid + '&sid=' + union265._config.sid + '&OUID=' + union265._config.ouid + '&app=&jumpUrl=' + escape(url);
            window.open(url);
        },
        trainClick: function (d, a) {
            var uri = 'http://trains.ctrip.com/TrainBooking/' + d + '-' + a + '/gaotie/';
            union265.Public.jump(uri);
        },
        vacationClick: function (t) {
            union265.Public.jump(t.getAttribute('_src'));
        }
    }

})(window, cQuery);

//旅游模块 出发地
(function (_, $) {
    _['UI'] = {
        travelCityPicker: {
            init: function ($obj) {
                this._tag = $('#' + $obj);
                this._div = $('#divVacationStartCity');
                this.events();
            }
            , events: function () {
                this._tag.bind('focus', this.tagFocus.bind(this));
                $(document).bind('click', this.documentClick.bind(this));
                this._div.find('a').bind('click', this.selectedItem);
            }
            , tagFocus: function () {
                var offset = this._tag.offset();
                this._div.css({ 'top': (offset.top + offset.height) + 'px', 'left': offset.left + 'px', 'display': '' });
            }
            , documentClick: function (e) {
                var e = e || window.event;
                var tag = e.srcElement || e.target;
                if (tag != document.getElementById('txt_travelDeptCity') && !document.getElementById('divVacationStartCity').contains(tag)) {
                    document.getElementById('divVacationStartCity').style.display = 'none';
                }
            }
            , selectedItem: function () {
                var code = this.title;
                var id = this.getAttribute('data-id');
                $('#hid_travelDeptCity').value(id);
                $('#txt_travelDeptCity').value(this.innerHTML);
                $('#divVacationStartCity').css('display', 'none');
            }
        }
    }
})(window, cQuery);

/*
* @ 插件名称: 图片预加载器
* @ 开发员: hailiangli
* @ 开始日期: 2013-11-20
* @ 最后修改: 2013-11-20
* @ 功能: 指定元素内部的所有图片 添加预加载效果
* ---------------------------------------------
* @ var newObj = ImgLoad(target, loadImg, errorImg)
* @ target: 图片的容器 [id/对象]
* @ loadImg: 图片加载中的效果图片[uri]
* @ errorImg: 图片加载失败时的效果图片[uri]
* ---------------------------------------------
* newObj.aways = true;   作用: 即使图片已经在缓存中了,还是使用渐出效果
* ImgLoad.setInterval(1000);   静态成员, 设置渐出动画的每帧的间隔时间(毫秒) 注: 全局生效
*/
; (function (_, undefined) {
    //私有方法
    var _pm = {
        isIE: null, //是否为ie浏览器
        interval: 20, //动画的间隔时间(毫秒)
        _init: function () { //初始化私有方法
            this.asynBrowser();
        },
        asynBrowser: function () {//获取当前浏览器类型
            this.isIE = /msie/.test(window.navigator.userAgent.toLowerCase())
        },
        opacity: {
            demon_ie: function (img) { //ie的渐出效果
                var tmp = img.style.filter;
                var _self = arguments.callee;
                tmp = tmp.match(/^alpha\(opacity=(\d+)\)$/);
                img.src = img.getAttribute('__src');
                var val = tmp.length > 1 ? Number(tmp[1]) : 100;
                if (val >= 100) {
                    img.style.filter = 'alpha(opacity=100)';
                } else {
                    img.style.filter = 'alpha(opacity=' + (val + 10) + ')';
                    setTimeout(function () { _self(img); }, _pm.interval);
                }
            },
            great_w3c: function (img) { //w3c标准的渐出效果
                var _self = arguments.callee;
                img.src = img.getAttribute('__src');
                var val = Number(img.style.opacity);
                if (val >= 1) {
                    img.style.opacity = '1';
                } else {
                    img.style.opacity = (val + 0.1).toFixed(1);
                    setTimeout(function () { _self(img); }, _pm.interval);
                }
            },
            init_great_w3c: function (img) { //始图片完全透明
                img.style.opacity = '0';
            },
            init_demon_ie: function (img) {  //同上**
                img.style.filter = 'alpha(opacity=0)';
            }
        }
    }

    //构造函数
    var _imgload = function (target, loadImg, errorImg) {
        /*---------private member(s)---------*/
        this._tag = (typeof target).toString().toUpperCase() === 'STRING'
						? document.getElementById(target)
						: target;
        this._imgs;
        this._loadImg = loadImg || 'http://pic.c-ctrip.com/common/bg_loading.gif'; //
        this._errorImg = errorImg || '';

        /*---------public member(s)---------*/
        this.aways = false;

        /*---------asyn what can run---------*/
        this._tag != undefined && this._init();
        return this;
    }

    //添加函数内部成员
    _imgload.prototype = {
        _init: function () {
            _pm._init();
        }
		, _load: function (obj) {
		    var _this = this;
		    obj.src = this._loadImg || '';
		    var img = new Image();
		    img.src = obj.getAttribute('__src');
		    if (img.complete) {
		        if (this.aways) _this._imgComplete.call(_this, obj);
		        else obj.src = img.src;
		    } else {
		        img.onload = function () { _this._imgComplete.call(_this, obj); img.onload = null; }
		        img.onerror = function () { _this._imgError.call(_this, obj); img.onerror = null; }
		    }
		}
		, _imgComplete: function (img) {
		    var type = _pm.isIE ? 'demon_ie' : 'great_w3c';
		    _pm.opacity['init_' + type](img);
		    _pm.opacity[type](img);
		}
		, _imgError: function (img) {
		    img.onerror = null;
		    img.src = this._errorImg || '';
		}
		, load: function () {
		    if (this._tag && this._tag != undefined) {
		        this._imgs = this._tag.getElementsByTagName('img');
		        for (var i = 0, len = this._imgs.length; i < len; i++) {
		            var item = this._imgs[i];
		            item && item.getAttribute('__src') && this._load(item);
		        }
		    }
		}
        //obj end;
    }

    //静态成员
    _imgload.setInterval = function (interval) {
        _pm.interval = interval;
    }

    _['ImgLoad'] = _imgload;
})(window.UI || {})
