(function(){
    var Suggestion = function(config){
        this.ele = config.ele; //suggestion填加元素
        this.isfocus = 0;
        this.suggestionUrl = config.suggestionUrl;
        var id = config.ele.attr['id'];
        window._sugCache = [];
        window._sugCache[id] = {};
    };
    Suggestion.prototype = {
        /*初始化类*/
        init : function(){
            this._create();
            this._bindEvent();
        },
        /*
        * 绑定事件
        * */
        _bindEvent : function(){
            var _this = this,
                input = $('input[type=text]',this.ele),
                defaultTxt = input.attr('data-value'),
                inputTip = $('.input_tip',this.ele);
            //form表单
            input.focus(function(){
                if($.trim($(this).val())==defaultTxt){
                    $(this).val('');
                }
            }).blur(function(){
                if($.trim($(this).val())==''){
                    $(this).val(defaultTxt);
                }
            });
            input.keyup(function(event){
                var keyCode = event.keyCode,
                    txt = $.trim($(this).val());
                //回车
                if(keyCode==13 && _this.isfocus==1 ){
                    if( $('.focus',inputTip).length > 0){
                        $(this).val($('.focus',inputTip).text());
                    }
                    _this.isfocus = 0;
                    _this.hide();
                    return;
                }
                if( keyCode==37 || keyCode==39 ){
                    return;
                }
                if( keyCode!=38 && keyCode!=40){
                    if( txt=='' || keyCode==27 ){
                        _this.hide();
                    }else{
                        _this._getJsonp(txt);
                    }
                }
            }).keydown(function(event){
                var keyCode = event.keyCode,index,that = this,
                    inputli = $('li',inputTip),
                    lengthLi = inputli.length,
                    currentIndex = $('.focus',inputTip).index(),
                    callback = function(index){
                        $('.focus',inputTip).removeClass('focus');
                        $($('li',inputTip)[index]).addClass('focus');
                        $(that).val($($('li',inputTip)[index]).text());
                    };
                //上箭头
                if(keyCode==38){
                    index = currentIndex-1;
                    if(index<=-1){ index = lengthLi-1;   }
                    callback(index);
                }
                //下箭头
                if(keyCode==40){
                    index = currentIndex+1;
                    if(index>=lengthLi){ index = 0;   }
                    callback(index);
                }
            }).focus(function(){
                var txt = $(this).val();
                if(txt!='' && $('li',inputTip).length >0 ){
                    _this.show();
                }
            });
            //鼠标移到suggestion，底部改变颜色
            _this.ele.delegate('li','mouseover',function(){
                $(this).addClass('focus');
            }).delegate('li','mouseout',function(){
                $(this).removeClass('focus');
            }).delegate('li','click',function(){
                $('#sug_group_id').val($(this).attr('data-index'));
                input.val($(this).text());
                _this.ele.submit();
                _this.hide();
            });
            //鼠标点击非suggestion区域，suggestion消失
            $('body').bind('click',function(event){
                var event = event || window.event,
                    target =  event.target || event.srcElement;
                if( $(target).parents('#'+_this.ele[0].id).length ==0 && ( _this.ele.css('display')!='none') ){
                    _this.hide();
                }
            });
            //点击搜索按钮表单提交
            $('.h-select-submit',_this.ele).click(function(e){
                e.preventDefault();
                if(_this.ele[0].id=='hxForm'){
                    window.getStatistics({'data':'a=sbu&k='+$('input[type=text]',_this.ele).val()});
                }
                _this.ele.submit();
                _this.hide();
            });
            _this.ele.submit(function(){
                _this.isfocus = 1;
                var temp = _this.ele;
                //户型加入统计代码
                //alert(temp.id);
                if(_this.ele[0].id=='hxForm'){
                    window.getStatistics({'data':'a=su&k='+$('input[type=text]',_this.ele).val()});
                }
            });
        },
        /*
        *su创建gDom结构
        * */
        _create : function(){
            var div = document.createElement('div');
            div.className = 'input_tip';
            $('input[type=text]',this.ele).parent().append(div);
        },
        /*
        * 使用jsonp的方式请求数据
        * */
        _getJsonp : function(query){
            if(typeof this.suggestionUrl=='undefined'){
                return;
            }
            var id = this.ele.attr['id'];
            if(typeof window._sugCache[id][query]!=='undefined' && window._sugCache[id][query].length >0 ){
                this._request(window._sugCache[id][query]);
                return;
            }
            //var suggestionUrl = '/common/modules/dmc/suggestion/check.php?jsonp=y&type=lp&q_word='+encodeURI(query),
            var suggestionUrl = this.suggestionUrl+'='+encodeURI(query),
                date = new Date(),
                time = date.getTime();
            window['jsonp'] = this._request;
            $.getScript(suggestionUrl+'&t='+time+'&callback=jsonp');
        },
        /*
        * 回调函数
        * */
        _request : function(response){
            var txt,t,word,m = 0,value = [],html = '<ul>';
            if( response.length > 0 ){
                txt = $('#hxForm input[type=text]').val();
                for(var i in response){
                    html += '<li data-index="'+i+'"><span>'+response[i].type_name+'</span><em>'+response[i].district+'</em></li>';
                }
                $('#hxForm .input_tip').html(html).show();
                $($('#hxForm .input_tip li')[m-1]).addClass('last');
            }else if(Object.prototype.toString.call(response) == '[object Object]'){
                txt = $('#hSearchForm input[type=text]').val();
                var inArray = function(sArray,str){
                    var length = sArray.length;
                    if( length == 0 ){
                        return false;
                    }
                    for(var i= 0;i < length;i++){
                        if(str == sArray[i]){
                            return true;
                        }
                    }
                };
                for(var i in response){
                    if(m==10){
                        break;
                    }
                    if((response[i]).search(txt)>-1){
                        value.push(i);
                        html += '<li data-index="'+i+'"><span>'+response[i]+'</span><em></em></li>';
                        m++;
                    }
                }
                for(var i in response){
                    if(m==10){
                        break;
                    }
                    if(!inArray(value,i)){
                        html += '<li data-index="'+i+'"><span>'+response[i]+'</span><em></em></li>';
                        m++;
                    }
                }
                html += '</ul>';
                $('#hSearchForm .input_tip').html(html).show();
                $($('#hSearchForm .input_tip li')[m-1]).addClass('last');
            }else{
                $('.input_tip').html('').hide();
            }
        },
        /*
        * 显示
        * */
        show : function(){
            $('.input_tip',this.ele).show();
        },
        /*
        * 隐藏
        * */
        hide : function(){
            $('.input_tip',this.ele).hide();
        },
        _clear:function(){

        }
    }
    $(document).ready(function(){
        var suggestion1 = new Suggestion({'ele':$('#hxForm'),'suggestionUrl':'/common/newhouse/hx_search/suggestion.php?kw'});
        suggestion1.init();
        var suggestion2 = new Suggestion({'ele':$('#hSearchForm'),'suggestionUrl':'/common/modules/dmc/suggestion/check.php?jsonp=y&type=lp&q_word'});
        suggestion2.init();
    });
})();