/**
* @namespace cQuery.mod
* @class validate
* @fileOverview 校验提示
* @author 魏晓军
* @email weixj@ctrip.com
* @version 1.1
* @date 2012-03-27
* @example
*/
window.__bfi = window.__bfi || [];
; (function ($) {
    var cls = {
        name: 'validate',
        version: '1.1',
        init: function () { },
        uninit: function () { },
        module: validate
    };
	function is_equal_document(tar,flo){
		var doc1=$(tar)[0].ownerDocument;
		var doc2=$(flo)[0].ownerDocument;
		if(doc1==doc2){
			return true;
		}
		return false;
	}
    function validate(obj, opt) {
        this.init(obj, opt);
    }
    $.extend(validate.prototype, {
        init: function () {
            var record = {
                uid: 0,
                group: ""
            };
            var iframeManger = {};
            // iframeManger[group] = {//group类型的对象
            // iframe:tipIfm,//group对应的iframe
            // loaded:false,//group对应的iframe是否加载完
            // elems:{//调用iframe的所有元素
            // uid:[{},{}]//同一元素调用iframe的对象
            // },
            // fun:[],
            // }

            //默认属性
            var defaults = {
				isScroll:true,
                zIndex: 999,
                animate: false,
                errorClass: "f_error",
                removeErrorClass: false,
                hideEvent: null,
                isFocus: false,
                iframe: false,
				srollHeight:0,
				srollWidth:0,
                /**显示后调用*/
                show: function () { },
				endshow:function(o){	
					var elem = o.elem;
					var opt = o.opt;
					var pos=$(elem).offset();
					var width = opt.srollWidth||$(elem)[0].offsetWidth;
					var height = opt.srollHeight||$(elem)[0].offsetHeight;
					if(opt.isScroll)window.scrollTo(pos.left-width-5,pos.top-height-5);
				},
                /**隐藏后调用*/
                hide: function () { },
                /**位置*/
                position: "rm_lm",
                templs: {
                    tipTempl: '<div id=${tipId} class="${tip}"  group=${group} style="min-width:${minWidth}px; width:${maxWidth}px;_width:${minWidth}px; width:auto !important;max-width:${maxWidth}px;overflow:hidden;display:block;z-index:99;margin:0;padding:0;left:0px;top:0px;overflow:hidden;position:absolute;"><div class="${box} ${boxType} ${boxArrow}" id=${boxId}><b class="${arrow}" id=${arrowId}></b><div class="${loading}" id=${loadingId}>${loadingImg}</div><div class=${content} id=${contentId}></div></div>'
                },
                css: {
                    //最大宽度
                    maxWidth: "260",
                    //最小宽度
                    minWidth: "50"
                },
                group: "group",
                classNames: {
                    //浮动层最外层的类
                    tip: 'tuna_jmpinfo',
                    //浮动层的类
                    box: 'base_jmp',
                    //浮动层类型的类
                    boxType: 'jmp_alert',
                    boxArrow: 'base_jmp_t',
                    //浮动层箭头的类
                    arrow: 'tri_t',
                    //浮动层加载时的类
                    loading: 'jmp_loading',
                    //浮动层内容的类
                    tipContent: 'jmp_content'
                },
                ids: {
                    boxId: "boxId",
                    arrowId: "arrowId",
                    loadingId: "loadingId",
                    contentId: "contentId"
                },
                temp: '<div class="jmp_bd">${txt}</div>',
                /**提示内容*/
                data: "提示信息!",
                showArrow: true,
                /**样式*/
                styles: ".tuna_jmpinfo {margin: 20px;color: #333;font: 12px/2 Arial,Tahoma,simsun;-webkit-text-size-adjust: none;}.tuna_jmpinfo ul,li{list-style: none;}.tuna_jmpinfo a{color: #00c;cursor: pointer;text-decoration: none;}.tuna_jmpinfo a: hover{color: #f00;text-decoration: underline;}.tuna_jmpinfo .font16{font-size: 16px;}.tuna_jmpinfo .jmp_hd{height:30px; padding-left:10px; background:url(http://pic.c-ctrip.com/common/un_base_btn.png) repeat-x 0 -390px; font-size:12px; line-height:30px; color:#333;} .tuna_jmpinfo .jmp_hd h3{font-size: 12px;} .tuna_jmpinfo .jmp_bd{padding: 2px 3px;}  .tuna_jmpinfo .jmp_alert{border: 1px solid #ffb533; background: #fff5d1;} .tuna_jmpinfo .base_jmp b{position: absolute; width: 16px; height: 16px; background-image: url(http://pic.c-ctrip.com/common/un_jmp_tri.png); background-repeat: no-repeat; overflow: hidden;} .tuna_jmpinfo .base_jmp_t{margin-top: 8px;} .tuna_jmpinfo .base_jmp_r{margin-right: 8px;} .tuna_jmpinfo .base_jmp_b{margin-bottom: 7px;} .tuna_jmpinfo .base_jmp_l{margin-left: 8px;} .tuna_jmpinfo .base_jmp_t b{margin-top: -7px;} .tuna_jmpinfo .base_jmp_r b{margin-top: 10px; right: 0;} .tuna_jmpinfo .base_jmp_b b{bottom: -8px;} .tuna_jmpinfo .base_jmp_l b{margin-top: 10px; left: 9px;}  .tuna_jmpinfo .jmp_title .tri_b{background-position: -32px -32px;} .tuna_jmpinfo .jmp_alert .tri_t{background-position: -16px 0;} .tuna_jmpinfo .jmp_alert .tri_r{background-position: -16px -16px;} .tuna_jmpinfo .jmp_alert .tri_b{background-position: -16px -32px;} .tuna_jmpinfo .jmp_alert .tri_l{background-position: -16px -48px;} .tuna_jmpinfo .jmp_table .tri_t{background-position: -32px 0;}.f_error {background-color: #FFF7D9 !important; border-color: #D80000 #E50000 #E50000 #D80000 !important; border-style: solid; border-width: 1px;}"
            }
			//body{margin: 0;padding: 0} .tuna_jmpinfo form,h1,h2,h3,h4,ul,ol,li,dl,dd,dt,p,hr,input{margin: 0;padding: 0}
            var lastTime = 0;
            function _debug(message) {
                var now = (new Date).getTime();
                var delta = now - lastTime;
                lastTime = now;
                if (false) {
                    if (message) {
                        _log(delta + ': ' + message);
                    } else {
                        _log(delta + ': ' + 'Called ' + arguments.callee.caller.name);
                    }
                }
            }
            function _log(message) {
                if (window.console !== undefined) {
                    console.log(message);
                }
            }
            //静态方法
            function isExit(opt) {
                _debug()
                if (!opt) {
                    throw new ('传入的值不能为空！');
                }
                if (!opt.$obj) {
                    throw new ('传入的值中不存$obj属性！');
                }
                var ret = $.isCDom(opt.$obj);
                if (!ret) {
                    throw new ('传入的值中：$obj属性不是cDom对象！');
                }
                var empty = $.copy(defaults);
                var opt = $.extend(empty, opt)
                return opt;
            }

            function creatIframe(group, callback) {
				
                _debug()
                var fn = callback || function () { };
                var g;
                if (g = iframeManger[group]) {
                    var iframe = g.iframe;
                    var fun = g.fun;

                    var ret = fun.indexOf(fn);

                    if (ret == -1) {
                        fun.push(fn)
                    }
                    if (g.loaded) {
                        for (var i = 0, n = fun.length; i < n; i++) {
                            var fn = fun[i];
                            fn(iframe);
                        }
                        fun.length = 0; //清空事件
                    } else {
                        setTimeout(arguments.callee, 200);
                    }
                } else {
					var _iframeObject=$(document.createElement('iframe'));
					_iframeObject[0].src = "about:blank";
					_iframeObject[0].id = "ifr_" + group;
					//tipIfm.allowTransparency = "true"
					_iframeObject[0].frameBorder = "no";
					_iframeObject[0].border = "0";
					_iframeObject[0].marginWidth = "0";
					_iframeObject[0].marginHeight = "0";
					_iframeObject[0].backgroundColor = "transparent";
					_iframeObject[0].scrolling = "no";
					_iframeObject[0].setAttribute("group", group)
					_iframeObject[0].style.cssText = "position:absolute;allowTransparency='true';left:-9999px;top: -9999px;background-color:transparent;";
					_iframeObject.prependTo(document.body);
					
				_iframeObject.html('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="content-type" content="text/html; charset=utf-8" /><title>validate</title><style></style></head><body></div></body></html>',function(){
							iframeManger[group] = {
								iframe: _iframeObject[0],
								loaded: false,
								elems: {},
								fun: []
							}
							iframeManger[group]["loaded"] = true;
							fn(_iframeObject[0])
					});
						
					
                    /*
					var tipIfm = document.createElement('iframe');
                    tipIfm.src = "about:blank";
                    tipIfm.id = "ifr_" + group;
                    //tipIfm.allowTransparency = "true"
                    tipIfm.frameBorder = "no";
                    tipIfm.border = "0";
                    tipIfm.marginWidth = "0";
                    tipIfm.marginHeight = "0";
                    tipIfm.backgroundColor = "transparent";
                    tipIfm.scrolling = "no";
                    tipIfm.setAttribute("group", group)
                    tipIfm.style.cssText = "position:absolute;allowTransparency='true';left:-9999px;top: -9999px;background-color:transparent;";
                    
                    iframeManger[group] = {
                        iframe: tipIfm,
                        loaded: false,
                        elems: {},
                        fun: []
                    }
                    if (tipIfm.attachEvent) {
                        tipIfm.attachEvent("onload", function () {
                            iframeManger[group]["loaded"] = true;
                            fn(tipIfm)
                        });
                    }
                    else {
                        tipIfm.onload = function () {
                            iframeManger[group]["loaded"] = true;
                            fn(tipIfm)
                        };
                    }
					document.body.appendChild(tipIfm);
					*/
                }
            }
            //添加样式
            function creatStyle(iframe, doc, styles,elem) {
                _debug()
                if (!iframe.styles) {
                    if ($.browser.isIE) {
						
                        var styleSheet = doc.createStyleSheet();
                        styleSheet.cssText = styles;
						if(elem.ownerDocument!==doc){
							var styleSheet = elem.ownerDocument.createStyleSheet();
							styleSheet.cssText = '.f_error {background-color: #FFF7D9 !important; border-color: #D80000 #E50000 #E50000 #D80000 !important; border-style: solid; border-width: 1px;}';
						}
                    } else {
                        var sty = doc.createElement('style');
                        sty.type = "text/css";
                        sty.textContent = styles;
                        doc.getElementsByTagName('head')[0].appendChild(sty)
							
						if(elem.ownerDocument!==doc){
							var sty = elem.ownerDocument.createElement('style');
							sty.type = "text/css";
							sty.textContent = '.f_error {background-color: #FFF7D9 !important; border-color: #D80000 #E50000 #E50000 #D80000 !important; border-style: solid; border-width: 1px;}';
							elem.ownerDocument.getElementsByTagName('head')[0].appendChild(sty)
						}
                    }
                    iframe.styles = true;
                } else {
                    return;
                }
            }
            //获取当前obj
            function getCurr() {
                var elems = iframeManger[record.group].elems[record.uid];
                return elems[elems.length - 1];
            }
            function init() {
                _debug()
                creatContainer();
                hideGroup();
                creatContent();
                getPos();
                show()
            }
            function creatContainer() {
                _debug()
                var o = getCurr();
                var options = o.opt;
                var classNames = options.classNames;
                var ids = options.ids
                var css = options.css;
                var group = o.group;
                var $obj = options.$obj;
                var uid = o.uid;
                if ($("#" + uid, o.doc).length == 0) {
                    var div = o.doc.createElement("div");
                    div.innerHTML = $.tmpl.render(options.templs.tipTempl, {
                        tipId: uid,
                        boxId: ids.boxId,
                        arrowId: ids.arrowId,
                        loadingId: ids.loadingId,
                        contentId: ids.contentId,
                        group: group,
                        tip: classNames.tip,
                        box: classNames.box,
                        boxType: classNames.boxType,
                        boxArrow: classNames.boxArrow,
                        arrow: classNames.arrow,
                        maxWidth: css.maxWidth,
                        minWidth: css.minWidth,
                        minHeight: css.minHeight,
                        content: classNames.tipContent
                    });
                    o.doc.body.appendChild(div.firstChild);
                    //currObj.$tip[0].target = elem;
                }
                o.$tip = $("#" + uid, o.doc);
                o.$box = $("#" + ids.boxId, o.$tip[0]);
                o.$arrow = $("#" + ids.arrowId, o.$tip[0]);
                o.$loading = $("#" + ids.loadingId, o.$tip[0]);
                o.$content = $("#" + ids.contentId, o.$tip[0]);
                o.$tip[0].style.zIndex = options.zIndex;
            }
            function creatContent() {
                _debug()
                var o = getCurr();
                var html = $.tmpl.render(o.opt.temp, {
                    "txt": o.opt.data
                });
                o.$content.html(html)
            }
            function getPos() {
                _debug()
                var o = getCurr();
                var pos = o.opt.position.split("_")
                var targ = {};
                var tip = {};

                targ.arrow = [pos[0].substring(0, 1), pos[0].substring(1, 2)];
                tip.arrow = [pos[1].substring(0, 1), pos[1].substring(1, 2)];
                //调整类
                ; (function (k) {
                    o.$box[0].className =
					o.$box[0].className.replace(/[trblc]$/, k);
                    if (o.opt.showArrow) {
                        if (k == "c") {
                            o.$arrow[0].style.display = "none";
                        } else {
                            o.$arrow[0].style.display = "block";
                            o.$arrow[0].className =
							o.$arrow[0].className.replace(/[trblc]$/, k);
                        }
                    } else {
                        o.$arrow[0].style.display = "none";
                    }
                })(tip.arrow[0]);

                tip.pos = {
                    width: parseInt(o.$tip[0].offsetWidth, 10),
                    height: parseInt(o.$tip[0].offsetHeight, 10)
                }
				var ret = is_equal_document(o.opt.$obj,o.$box)
				if(ret){
					targ.pos = o.opt.$obj.offset()
				}else{
					targ.pos = o.opt.$obj.offsetA()
				}
                


                var targ_left = targ.pos.left;
                var targ_top = targ.pos.top;
                var targ_width = targ.pos.width;
                var targ_height = targ.pos.height;
                var tip_width = tip.pos.width;
                var tip_height = tip.pos.height;
                //tip
                var tipDot = {
                    tl: {
                        left: targ_left,
                        top: targ_top,
                        offsetX: -8,
                        offsetY: 0
                    },
                    tm: {
                        left: targ_left - tip_width / 2,
                        top: targ_top,
                        offsetX: 0,
                        offsetY: 0
                    },
                    tr: {
                        left: targ_left - tip_width,
                        top: targ_top,
                        offsetX: 8,
                        offsetY: 0
                    },
                    bl: {
                        left: targ_left,
                        top: targ_top - tip_height,
                        offsetX: -5,
                        offsetY: 0
                    },
                    bm: {
                        left: targ_left - tip_width / 2,
                        top: targ_top - tip_height,
                        offsetX: 0,
                        offsetY: 0
                    },
                    br: {
                        left: targ_left - tip_width,
                        top: targ_top - tip_height,
                        offsetX: 4,
                        offsetY: 0
                    },
                    lt: {
                        left: targ_left,
                        top: targ_top,
                        offsetX: 0,
                        offsetY: -8
                    },
                    lm: {
                        left: targ_left,
                        top: targ_top - tip_height / 2,
                        offsetX: 0,
                        offsetY: 0
                    },
                    lb: {
                        left: targ_left,
                        top: targ_top - tip_height,
                        offsetX: 0,
                        offsetY: 4
                    },
                    rt: {
                        left: targ_left - tip_width,
                        top: targ_top,
                        offsetX: 0,
                        offsetY: -8
                    },
                    rm: {
                        left: targ_left - tip_width,
                        top: targ_top - tip_height / 2,
                        offsetX: 0,
                        offsetY: 0
                    },
                    rb: {
                        left: targ_left - tip_width,
                        top: targ_top - tip_height,
                        offsetX: 0,
                        offsetY: 4
                    },
                    center: {
                        left: targ_left - tip_width / 2,
                        top: targ_top - tip_height / 2,
                        offsetX: -4,
                        offsetY: 0
                    }
                }
                var targDot = {
                    "bl": [0, targ_height, "bottom", "Left"],
                    "bm": [targ_width / 2, targ_height, "bottom", "Middle"],
                    "br": [targ_width, targ_height, "bottom", "Right"],
                    "tl": [0, 0, "top", "Left"],
                    "tm": [targ_width / 2, 0, "top", "Middle"],
                    "tr": [targ_width, 0, "top", "Right"],
                    "lt": [0, 0, "left", "Top"],
                    "lm": [0, targ_height / 2, "left", "Middle"],
                    "lb": [0, targ_height, "left", "Bottom"],
                    "rt": [targ_width, 0, "right", "Top"],
                    "rm": [targ_width, targ_height / 2, "right", "Middle"],
                    "rb": [targ_width, targ_height, "right", "Bottom"],
                    "center": [targ_width / 2, targ_height / 2, "center", "center"]
                };
                var tp = tipDot[pos[1]];
                var tg = targDot[pos[0]];
                var left = tp.left + tg[0];
                var top = tp.top + tg[1];
                var arrow = tip.arrow;
                var offsetX = tp.offsetX;
                var offsetY = tp.offsetY;
                var ret = {
                    left: left,
                    top: top,
                    arrow: arrow,
                    width: tip.pos.width,
                    height: tip.pos.height,
                    offsetX: offsetX,
                    offsetY: offsetY
                }
                o.dot = ret;
                calculateArrow();
            }
            function calculateArrow() {
                _debug()
                var o = getCurr();

                var k = o.dot.arrow; ;
                o.$box.css({
                    "MozBorderRadius": "0",
                    "borderRadius": "0"
                });
                o.$tip.css({
                    "webkitBoxShadow": "0",
                    "MozBoxShadow": "0",
                    "boxShadow": "0"
                });
                o.$arrow.css({
                    left: "",
                    right: "",
                    bottom: "",
                    top: "",
                    marginTop: ""
                });
                var w = o.dot.width;
                var h = o.dot.height;
                if (k[0] == "t") {
                    o.$arrow[0].style["marginTop"] = "-7px";
                    if (k[1] == "l") {
                        o.$arrow[0].style.left = "0";
                        getRadiu({
                            leftTop: 0
                        })

                    } else if (k[1] == "m") {
                        o.$arrow[0].style.left = (w / 2 - 8) + "px";
                        getRadiu();
                    } else if (k[1] == "r") {
                        o.$arrow[0].style.left = (w - 16) + "px";
                        getRadiu({
                            rightTop: 0,
                            x: -10
                        })
                    }
                } else if (k[0] == "r") {
                    o.$arrow[0].style.right = "-7px";
                    if (k[1] == "t") {
                        o.$arrow[0].style["marginTop"] = "0px";
                        getRadiu({
                            rightTop: 0,
                            x: -10
                        })
                    } else if (k[1] == "m") {
                        o.$arrow[0].style["marginTop"] = (h / 2 - 8) + "px";
                        getRadiu({
                            x: -10
                        })

                    } else if (k[1] == "b") {
                        o.$arrow[0].style["marginTop"] = (h - 16) + "px";
                        getRadiu({
                            rightBottom: 0,
                            x: -10,
                            y: -10
                        })
                    }
                } else if (k[0] == "b") {
                    if (k[1] == "l") {
                        o.$arrow[0].style.right = (w - 16) + "px";
                        getRadiu({
                            leftBottom: 0,
                            y: -10
                        })

                    } else if (k[1] == "m") {
                        o.$arrow[0].style.right = (w / 2 - 8) + "px";
                        getRadiu({
                            y: -10

                        })

                    } else if (k[1] == "r") {
                        o.$arrow[0].style.right = "0px";
                        getRadiu({
                            rightBottom: 0,
                            x: -10,
                            y: -10
                        })
                    }
                } else if (k[0] == "l") {
                    o.$arrow[0].style.left = "2px";
                    if (k[1] == "t") {
                        o.$arrow[0].style["marginTop"] = "0px";
                        getRadiu({
                            leftTop: 0
                        })
                    } else if (k[1] == "m") {
                        o.$arrow[0].style["marginTop"] = (h / 2 - 8) + "px";
                        getRadiu()
                    } else if (k[1] == "b") {
                        o.$arrow[0].style["marginTop"] = (h - 16) + "px";
                        getRadiu({
                            leftBottom: 0,
                            y: -10
                        })
                    }
                }
                //圆角:右上角、右下角、左下角、左上角
                //box-shadow:Apx Bpx Cpx #xxxxxx;
                //Apx代表阴影的x轴方向，
                //Bpx代表阴影的y轴方向，
                //Cpx代表投影长度，
                //#xxxxxx代表颜色值。
                function getRadiu(opt) {
                    var defaults = {
                        leftTop: 5,
                        rightTop: 5,
                        rightBottom: 5,
                        leftBottom: 5,
                        x: 3,
                        y: 3
                    }
                    var opts = $.extend({}, defaults, opt || {});
                    var radiu =
					opts["leftTop"] + "px " + opts["rightTop"] + "px " + opts["rightBottom"] + "px " + opts["leftBottom"] + "px";
                    //当箭头隐藏是4个脚都为圆角
                    if (!o.opt.showArrow) {
                        var radiu =
						defaults["leftTop"] + "px " + defaults["rightTop"] + "px " + defaults["rightBottom"] + "px " + defaults["leftBottom"] + "px";
                    } else {
                        var radiu =
						opts["leftTop"] + "px " + opts["rightTop"] + "px " + opts["rightBottom"] + "px " + opts["leftBottom"] + "px";
                    }
                    var shadow =
					opts["x"] + "px " + opts["y"] + "px 3px #888";

                    o.$box.css({
                        "MozBorderRadius": radiu,
                        "borderRadius": "" + radiu
                    });
                    o.$tip.css({
                        "MozBorderRadius": radiu,
                        "borderRadius": "" + radiu
                        // "webkitBoxShadow":shadow,
                        // "MozBoxShadow":shadow,
                        // "boxShadow":shadow
                    });

                }

            }
            function _hide(obj) {
                if (obj.$tip[0].style.left != "-9999px") {
                    obj.$tip.css({
                        left: "-9999px",
                        top: "-9999px"
                    });
                    obj.show = false;
                    obj.opt.hide(obj.elem)
                    if (obj.opt.errorClass && obj.opt.removeErrorClass) {
                        $(obj.elem).removeClass(obj.opt.errorClass);
                    }
                }
                if (obj.iframe != obj.doc) {
                    var ifr = obj.iframe;
                    if (ifr.style.left != "-9999px") {
                        $(ifr).css({
                            left: "-9999px",
                            top: "-9999px",
                            width: "auto",
                            height: "auto"
                        });
                    }
                }
            }
            function hide(agr) {
                var type = 0;
                if (!agr) {
                    type = 1;
                } else if (typeof (agr) == "string") {
                    type = 2;
                } else if ($.isCDom(agr)) {
                    type = 3;
                } else {
                    throw new ('hide::没有找到合适的类型');
                    return;
                }
                for (var f in iframeManger) {
                    var g = iframeManger[f];
                    var e = g.elems;
                    var flag = false;
                    if (type == 3) {
                        if (!e[agr.uid()]) {
                            continue;
                        } else {
                            e = {
                                temp: e[agr.uid()]
                            }
                        }
                    }
                    for (var u in e) {
                        var obj = e[u];
                        for (var i = 0, n = obj.length; i < n; i++) {
                            if (type == 1 || type == 3) {
                                if (obj[i].show) {
                                    _hide(obj[i]);
                                }
                            } else if (type == 2) {
                                if (obj[i].hideID == agr
									&& obj[i].show) {
                                    _hide(obj[i]);
                                    flag = true;
                                    break;
                                }
                            }
                        }
                        if (flag) break;
                    }
                }
            }
            function animate(elem, css, duration, callback) {
                clearInterval(elem._timer)

                var tween = function (x) {
                    return (x /= 0.5) < 1 ? (0.5 * Math.pow(x, 2)) : (-0.5 * ((x -= 2) * x - 2))
                };
                function ontween(pos) {
                    var obj, val, form, to, name, unit,
						i = 0, len = css.length;

                    for (; i < len; i++) {
                        obj = css[i];
                        from = obj[0];
                        to = obj[1];
                        name = obj[2];
                        unit = obj[3];
                        val = from + (to - from) * tween(pos);

                        if (name == "opacity") {
                            elem.style[name] = val;
                            elem.style.filter = 'alpha(opacity=' + (val * 100) + ')';
                        } else {
                            elem.style[name] = val + unit;
                        }
                    };
                };

                function onend(pos) {
                    ontween(pos);
                    callback.call(elem);
                };
                var fx = function (ontween, onend, duration) {
                    var pos, runTime, startTime = +new Date;
                    elem._timer = setInterval(function () {
                        runTime = +new Date - startTime;
                        pos = runTime / duration;
                        if (pos >= 1) {
                            clearInterval(elem._timer);
                            onend(pos);
                        } else {
                            ontween(pos);
                        };
                    }, 13);
                };
                fx(ontween, onend, duration);
            };
            function fade(el, i) {
                el.style.opacity = i;
                el.style.filter = 'alpha(opacity=' + (i * 100) + ')';
            }
            function show() {
                _debug()
                var o = getCurr();
                var dot = o.dot;
                var width = dot.width;
                var height = dot.height;
                if (o.opt.showArrow) {
                    var top = dot.top + dot.offsetY;
                    var left = dot.left + dot.offsetX; ;
                } else {
                    var top = dot.top;
                    var left = dot.left;
                }
                width = Math.floor(width);
                height = Math.floor(height);
                if (o.opt.errorClass) {
                    $(o.elem).addClass(o.opt.errorClass);
                }
                if (o.opt.animate) {
                    fade(o.$tip[0], 0);
                    animate(o.$tip[0], [
							[0, 1, 'opacity', '']
						], 680, function () { }
					);
                }
                if (o.iframe == o.doc) {
                    o.$tip.css({
                        "top": (top) + "px",
                        "left": (left) + "px"
                    });
                } else {
                    o.$tip.css({
                        left: "0px",
                        top: "0px"
                    });
                    $(o.iframe).css({
                        "top": (top) + "px",
                        "left": (left) + "px",
                        "width": (width) + "px",
                        "height": (height) + "px"
                    })
                }

                o.show = true;
                o.opt.show(o);
                if (o.opt.isFocus) {
                    $(o.elem)[0].focus();
                }
                if (o.opt.hideEvent) {
                    $(o.elem).unbind(o.opt.hideEvent, hideMsg);
                    $(o.elem).bind(o.opt.hideEvent, hideMsg);
                } else {
                    $(o.elem.ownerDocument).unbind('mousedown', hideMsg);
                    $(o.elem.ownerDocument).bind('mousedown', hideMsg);
                }
				o.opt.endshow(o);
            }
            function hideGroup() {
                _debug()
                var o = getCurr();
                var group = o.group;
                var g = iframeManger[group];
                if (g) {
                    var e = g.elems;
                    for (var u in e) {
                        var obj = e[u];
                        for (var i = 0, n = obj.length; i < n; i++) {
                            if (obj[i].show) _hide(obj[i]);
                        }
                    }
                }
            }
            function hideMsg() {
                hide();
                $(this).unbind('mousedown', hideMsg);
            }
            function getGroup(iframe) {
                var pre = "no"
                if (iframe) {
                    var pre = "outer";
                }else if ($.browser.isIE6) {
                    var pre = "inner";
                }
				
                return pre;
            }
            function setOptions(args) {
                var iframe = args.iframe || document;
                var win = window;
                var doc = document;
                var opt = args.opt;
                var styles = opt.styles
                if (args.iframe) {
                    win = args.iframe.contentWindow || args.iframe.window;
                    doc = win.document;
                    args.iframe.style.zIndex = opt.zIndex;
                }
                
                var elem = opt.$obj[0];
				creatStyle(iframe, doc, styles,elem);
                var uid = $.uid(elem);
                record["uid"] = uid;
                var group = record["group"];

                //如果不是外加iframe的初始化iframeManger[group]
                if (!args.iframe && !iframeManger[group]) {
                    iframeManger[group] = {
                        iframe: iframe,
                        loaded: true,
                        elems: {},
                        fun: []
                    }
                }
                var elems = iframeManger[group].elems;
                if (!elems[uid]) elems[uid] = [];
                elems[uid].push({
                    iframe: iframe,
                    win: win,
                    doc: doc,
                    opt: opt,
                    group: group,
                    uid: uid,
                    hideID: opt.hideID,
                    elem: elem,
                    show: false,
                    dot: { left: null, top: null, arrow: null, width: null, height: null, offsetX: null, offsetY: null
                    },
                    $tip: null,
                    $box: null,
                    $arrow: null,
                    $loading: null,
                    $content: null
                })
                init();
            }
            this.show = function (opt) {

                _debug()
                var opt = isExit(opt);
                if (!opt) {
                    return this;
                } else {
                    var pre = getGroup(opt.iframe);
                    var group = pre + "_" + opt.group;
                    record["group"] = group;
                    if (pre != "no") {
                        creatIframe(group, function (iframe) {
                            setOptions({
                                iframe: iframe,
                                opt: opt
                            });
                        })
                    } else {
                        setOptions({
                            iframe: null,
                            opt: opt
                        });
                    }

                    /* userblock
                     * ====================================================
                    */
                    if( opt['$obj'] && opt['$obj'].length ){
                        for (var i = 0; i < opt['$obj'].length; i++) {
                            var item = opt['$obj'][i], cnt = 'validateCount', count = $(item).data(cnt)
                            !count ? $(item).data(cnt, 1) : $(item).data(cnt, count+1)
                            window.__bfi.push(['_trackUserBlock', {
                                'dom': (item.id&&('id:'+item.id))||(item.name&&('name:'+item.name))||'',
                                'value': item.value||'',
                                'type': (item.tagName?'dom:'+item.tagName.toLowerCase():'')+(item.type?':'+item.type:''),
                                'form': item.form?((item.form.id&&('id:'+item.form.id))||(item.form.name&&('name:'+item.form.name))):'',
                                'message': opt.data||'',
                                'count': $(item).data(cnt)
                            }])
                        }
                    }
                    /* end userblock
                     * ====================================================
                    */

                    return this;
                }
            }
            /**
            *隐藏
            */
            this.hide = function (elem) {
                _debug()
                hide(elem);
            }
        }
    })
    $.mod.reg(cls)
})(cQuery);
/***************************************************************/