/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlSourceBuilder
extends BaseBuilder {
    private static final Set<String> parameterProperties = new HashSet<String>(Arrays.asList("javaType", "jdbcType", "mode", "numericScale", "resultMap", "typeHandler", "jdbcTypeName"));

    public SqlSourceBuilder(Configuration configuration) {
        super(configuration);
    }

    public SqlSource parse(String originalSql, Class<?> parameterType) {
        ParameterMappingTokenHandler handler = new ParameterMappingTokenHandler(this.configuration, parameterType);
        GenericTokenParser parser = new GenericTokenParser("#{", "}", handler);
        String sql = parser.parse(originalSql);
        return new StaticSqlSource(this.configuration, sql, handler.getParameterMappings());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterMappingTokenHandler
    extends BaseBuilder
    implements TokenHandler {
        private List<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        private Class<?> parameterType;

        public ParameterMappingTokenHandler(Configuration configuration, Class<?> parameterType) {
            super(configuration);
            this.parameterType = parameterType;
        }

        public List<ParameterMapping> getParameterMappings() {
            return this.parameterMappings;
        }

        @Override
        public String handleToken(String content) {
            this.parameterMappings.add(this.buildParameterMapping(content));
            return "?";
        }

        private ParameterMapping buildParameterMapping(String content) {
            Map<String, String> propertiesMap = this.parseParameterMapping(content);
            String property = propertiesMap.get("property");
            String jdbcType = propertiesMap.get("jdbcType");
            MetaClass metaClass = MetaClass.forClass(this.parameterType);
            Class<Object> propertyType = this.typeHandlerRegistry.hasTypeHandler(this.parameterType) ? this.parameterType : (JdbcType.CURSOR.name().equals(jdbcType) ? ResultSet.class : (metaClass.hasGetter(property) ? metaClass.getGetterType(property) : Object.class));
            ParameterMapping.Builder builder = new ParameterMapping.Builder(this.configuration, property, propertyType);
            if (jdbcType != null) {
                builder.jdbcType(this.resolveJdbcType(jdbcType));
            }
            Class<?> javaType = null;
            String typeHandlerAlias = null;
            for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if ("javaType".equals(name)) {
                    javaType = this.resolveClass(value);
                    builder.javaType(javaType);
                    continue;
                }
                if ("jdbcType".equals(name)) {
                    builder.jdbcType(this.resolveJdbcType(value));
                    continue;
                }
                if ("mode".equals(name)) {
                    builder.mode(this.resolveParameterMode(value));
                    continue;
                }
                if ("numericScale".equals(name)) {
                    builder.numericScale(Integer.valueOf(value));
                    continue;
                }
                if ("resultMap".equals(name)) {
                    builder.resultMapId(value);
                    continue;
                }
                if ("typeHandler".equals(name)) {
                    typeHandlerAlias = value;
                    continue;
                }
                if (!"jdbcTypeName".equals(name)) continue;
                builder.jdbcTypeName(value);
            }
            if (typeHandlerAlias != null) {
                builder.typeHandler(this.resolveTypeHandler(javaType, typeHandlerAlias));
            }
            return builder.build();
        }

        private Map<String, String> parseParameterMapping(String content) {
            HashMap<String, String> map = new HashMap<String, String>();
            StringTokenizer parameterMappingParts = new StringTokenizer(content, ", \n\r\t");
            String propertyWithJdbcType = parameterMappingParts.nextToken();
            String property = this.extractPropertyName(propertyWithJdbcType);
            map.put("property", property);
            String jdbcType = this.extractJdbcType(propertyWithJdbcType);
            if (jdbcType != null) {
                map.put("jdbcType", jdbcType);
            }
            while (parameterMappingParts.hasMoreTokens()) {
                String attribute = parameterMappingParts.nextToken();
                StringTokenizer attributeParts = new StringTokenizer(attribute, "=");
                if (attributeParts.countTokens() == 2) {
                    String name = attributeParts.nextToken();
                    String value = attributeParts.nextToken();
                    if (parameterProperties.contains(name)) {
                        map.put(name, value);
                        continue;
                    }
                    throw new BuilderException("An invalid property '" + name + "' was found in mapping #{" + content + "}.  Valid properties are " + parameterProperties);
                }
                throw new BuilderException("Improper inline parameter map format.  Should be: #{propName,attr1=val1,attr2=val2}");
            }
            return map;
        }

        private String extractPropertyName(String property) {
            StringTokenizer simpleJdbcTypeParser;
            if (property.contains(":") && (simpleJdbcTypeParser = new StringTokenizer(property, ": ")).countTokens() == 2) {
                return simpleJdbcTypeParser.nextToken();
            }
            return property;
        }

        private String extractJdbcType(String property) {
            StringTokenizer simpleJdbcTypeParser;
            if (property.contains(":") && (simpleJdbcTypeParser = new StringTokenizer(property, ": ")).countTokens() == 2) {
                simpleJdbcTypeParser.nextToken();
                return simpleJdbcTypeParser.nextToken();
            }
            return null;
        }
    }
}

