/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.IncompleteElementException;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.builder.xml.dynamic.ChooseSqlNode;
import org.apache.ibatis.builder.xml.dynamic.DynamicSqlSource;
import org.apache.ibatis.builder.xml.dynamic.ForEachSqlNode;
import org.apache.ibatis.builder.xml.dynamic.IfSqlNode;
import org.apache.ibatis.builder.xml.dynamic.MixedSqlNode;
import org.apache.ibatis.builder.xml.dynamic.SetSqlNode;
import org.apache.ibatis.builder.xml.dynamic.SqlNode;
import org.apache.ibatis.builder.xml.dynamic.TextSqlNode;
import org.apache.ibatis.builder.xml.dynamic.TrimSqlNode;
import org.apache.ibatis.builder.xml.dynamic.WhereSqlNode;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.session.Configuration;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStatementBuilder
extends BaseBuilder {
    private MapperBuilderAssistant builderAssistant;
    private XNode context;
    private String requiredDatabaseId;
    private Map<String, NodeHandler> nodeHandlers = new HashMap<String, NodeHandler>(){
        private static final long serialVersionUID = 7123056019193266281L;
        {
            this.put("include", new IncludeNodeHandler());
            this.put("trim", new TrimHandler());
            this.put("where", new WhereHandler());
            this.put("set", new SetHandler());
            this.put("foreach", new ForEachHandler());
            this.put("if", new IfHandler());
            this.put("choose", new ChooseHandler());
            this.put("when", new IfHandler());
            this.put("otherwise", new OtherwiseHandler());
            this.put("selectKey", new SelectKeyHandler());
        }
    };

    public XMLStatementBuilder(Configuration configuration, MapperBuilderAssistant builderAssistant, XNode context) {
        this(configuration, builderAssistant, context, null);
    }

    public XMLStatementBuilder(Configuration configuration, MapperBuilderAssistant builderAssistant, XNode context, String databaseId) {
        super(configuration);
        this.builderAssistant = builderAssistant;
        this.context = context;
        this.requiredDatabaseId = databaseId;
    }

    public void parseStatementNode() {
        String databaseId;
        String id = this.context.getStringAttribute("id");
        if (!this.databaseIdMatchesCurrent(id, databaseId = this.context.getStringAttribute("databaseId"))) {
            return;
        }
        Integer fetchSize = this.context.getIntAttribute("fetchSize", null);
        Integer timeout = this.context.getIntAttribute("timeout", null);
        String parameterMap = this.context.getStringAttribute("parameterMap");
        String parameterType = this.context.getStringAttribute("parameterType");
        Class<?> parameterTypeClass = this.resolveClass(parameterType);
        String resultMap = this.context.getStringAttribute("resultMap");
        String resultType = this.context.getStringAttribute("resultType");
        Class<?> resultTypeClass = this.resolveClass(resultType);
        String resultSetType = this.context.getStringAttribute("resultSetType");
        StatementType statementType = StatementType.valueOf(this.context.getStringAttribute("statementType", StatementType.PREPARED.toString()));
        ResultSetType resultSetTypeEnum = this.resolveResultSetType(resultSetType);
        List<SqlNode> contents = this.parseDynamicTags(this.context);
        this.parseSelectKey(this.context);
        MixedSqlNode rootSqlNode = new MixedSqlNode(contents);
        DynamicSqlSource sqlSource = new DynamicSqlSource(this.configuration, rootSqlNode);
        String nodeName = this.context.getNode().getNodeName();
        SqlCommandType sqlCommandType = SqlCommandType.valueOf(nodeName.toUpperCase(Locale.ENGLISH));
        boolean isSelect = sqlCommandType == SqlCommandType.SELECT;
        boolean flushCache = this.context.getBooleanAttribute("flushCache", !isSelect);
        boolean useCache = this.context.getBooleanAttribute("useCache", isSelect);
        String keyProperty = this.context.getStringAttribute("keyProperty");
        String keyColumn = this.context.getStringAttribute("keyColumn");
        String keyStatementId = id + "!selectKey";
        keyStatementId = this.builderAssistant.applyCurrentNamespace(keyStatementId, true);
        KeyGenerator keyGenerator = this.configuration.hasKeyGenerator(keyStatementId) ? this.configuration.getKeyGenerator(keyStatementId) : (this.context.getBooleanAttribute("useGeneratedKeys", this.configuration.isUseGeneratedKeys() && SqlCommandType.INSERT.equals((Object)sqlCommandType)) != false ? new Jdbc3KeyGenerator() : new NoKeyGenerator());
        this.builderAssistant.addMappedStatement(id, sqlSource, statementType, sqlCommandType, fetchSize, timeout, parameterMap, parameterTypeClass, resultMap, resultTypeClass, resultSetTypeEnum, flushCache, useCache, keyGenerator, keyProperty, keyColumn, databaseId);
    }

    private boolean databaseIdMatchesCurrent(String id, String databaseId) {
        if (this.requiredDatabaseId != null) {
            if (!this.requiredDatabaseId.equals(databaseId)) {
                return false;
            }
        } else {
            MappedStatement previous;
            if (databaseId != null) {
                return false;
            }
            if (this.configuration.hasStatement(id = this.builderAssistant.applyCurrentNamespace(id, false), false) && (previous = this.configuration.getMappedStatement(id)).getDatabaseId() != null) {
                return false;
            }
        }
        return true;
    }

    private List<SqlNode> parseDynamicTags(XNode node) {
        ArrayList<SqlNode> contents = new ArrayList<SqlNode>();
        NodeList children = node.getNode().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XNode child = node.newXNode(children.item(i));
            String nodeName = child.getNode().getNodeName();
            if (child.getNode().getNodeType() == 4 || child.getNode().getNodeType() == 3) {
                String data = child.getStringBody("");
                contents.add(new TextSqlNode(data));
                continue;
            }
            if ("selectKey".equals(nodeName)) continue;
            NodeHandler handler = this.nodeHandlers.get(nodeName);
            if (handler == null) {
                throw new BuilderException("Unknown element <" + nodeName + "> in SQL statement.");
            }
            handler.handleNode(child, contents);
        }
        return contents;
    }

    private void parseSelectKey(XNode node) {
        NodeList children = node.getNode().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XNode child = node.newXNode(children.item(i));
            String nodeName = child.getNode().getNodeName();
            if (!"selectKey".equals(nodeName)) continue;
            NodeHandler handler = this.nodeHandlers.get(nodeName);
            handler.handleNode(child, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChooseHandler
    implements NodeHandler {
        private ChooseHandler() {
        }

        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            ArrayList<SqlNode> whenSqlNodes = new ArrayList<SqlNode>();
            ArrayList<SqlNode> otherwiseSqlNodes = new ArrayList<SqlNode>();
            this.handleWhenOtherwiseNodes(nodeToHandle, whenSqlNodes, otherwiseSqlNodes);
            SqlNode defaultSqlNode = this.getDefaultSqlNode(otherwiseSqlNodes);
            ChooseSqlNode chooseSqlNode = new ChooseSqlNode(whenSqlNodes, defaultSqlNode);
            targetContents.add(chooseSqlNode);
        }

        private void handleWhenOtherwiseNodes(XNode chooseSqlNode, List<SqlNode> ifSqlNodes, List<SqlNode> defaultSqlNodes) {
            List<XNode> children = chooseSqlNode.getChildren();
            for (XNode child : children) {
                String nodeName = child.getNode().getNodeName();
                NodeHandler handler = (NodeHandler)XMLStatementBuilder.this.nodeHandlers.get(nodeName);
                if (handler instanceof IfHandler) {
                    handler.handleNode(child, ifSqlNodes);
                    continue;
                }
                if (!(handler instanceof OtherwiseHandler)) continue;
                handler.handleNode(child, defaultSqlNodes);
            }
        }

        private SqlNode getDefaultSqlNode(List<SqlNode> defaultSqlNodes) {
            SqlNode defaultSqlNode = null;
            if (defaultSqlNodes.size() == 1) {
                defaultSqlNode = defaultSqlNodes.get(0);
            } else if (defaultSqlNodes.size() > 1) {
                throw new BuilderException("Too many default (otherwise) elements in choose statement.");
            }
            return defaultSqlNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OtherwiseHandler
    implements NodeHandler {
        private OtherwiseHandler() {
        }

        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            List contents = XMLStatementBuilder.this.parseDynamicTags(nodeToHandle);
            MixedSqlNode mixedSqlNode = new MixedSqlNode(contents);
            targetContents.add(mixedSqlNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IfHandler
    implements NodeHandler {
        private IfHandler() {
        }

        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            List contents = XMLStatementBuilder.this.parseDynamicTags(nodeToHandle);
            MixedSqlNode mixedSqlNode = new MixedSqlNode(contents);
            String test = nodeToHandle.getStringAttribute("test");
            IfSqlNode ifSqlNode = new IfSqlNode(mixedSqlNode, test);
            targetContents.add(ifSqlNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ForEachHandler
    implements NodeHandler {
        private ForEachHandler() {
        }

        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            List contents = XMLStatementBuilder.this.parseDynamicTags(nodeToHandle);
            MixedSqlNode mixedSqlNode = new MixedSqlNode(contents);
            String collection = nodeToHandle.getStringAttribute("collection");
            String item = nodeToHandle.getStringAttribute("item");
            String index = nodeToHandle.getStringAttribute("index");
            String open = nodeToHandle.getStringAttribute("open");
            String close = nodeToHandle.getStringAttribute("close");
            String separator = nodeToHandle.getStringAttribute("separator");
            ForEachSqlNode forEachSqlNode = new ForEachSqlNode(XMLStatementBuilder.this.configuration, mixedSqlNode, collection, index, item, open, close, separator);
            targetContents.add(forEachSqlNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetHandler
    implements NodeHandler {
        private SetHandler() {
        }

        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            List contents = XMLStatementBuilder.this.parseDynamicTags(nodeToHandle);
            MixedSqlNode mixedSqlNode = new MixedSqlNode(contents);
            SetSqlNode set = new SetSqlNode(XMLStatementBuilder.this.configuration, mixedSqlNode);
            targetContents.add(set);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WhereHandler
    implements NodeHandler {
        private WhereHandler() {
        }

        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            List contents = XMLStatementBuilder.this.parseDynamicTags(nodeToHandle);
            MixedSqlNode mixedSqlNode = new MixedSqlNode(contents);
            WhereSqlNode where = new WhereSqlNode(XMLStatementBuilder.this.configuration, mixedSqlNode);
            targetContents.add(where);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TrimHandler
    implements NodeHandler {
        private TrimHandler() {
        }

        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            List contents = XMLStatementBuilder.this.parseDynamicTags(nodeToHandle);
            MixedSqlNode mixedSqlNode = new MixedSqlNode(contents);
            String prefix = nodeToHandle.getStringAttribute("prefix");
            String prefixOverrides = nodeToHandle.getStringAttribute("prefixOverrides");
            String suffix = nodeToHandle.getStringAttribute("suffix");
            String suffixOverrides = nodeToHandle.getStringAttribute("suffixOverrides");
            TrimSqlNode trim = new TrimSqlNode(XMLStatementBuilder.this.configuration, mixedSqlNode, prefix, prefixOverrides, suffix, suffixOverrides);
            targetContents.add(trim);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IncludeNodeHandler
    implements NodeHandler {
        private IncludeNodeHandler() {
        }

        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            String refid = nodeToHandle.getStringAttribute("refid");
            refid = XMLStatementBuilder.this.builderAssistant.applyCurrentNamespace(refid, true);
            try {
                XNode includeNode = XMLStatementBuilder.this.configuration.getSqlFragments().get(refid);
                if (includeNode == null) {
                    String nsrefid = XMLStatementBuilder.this.builderAssistant.applyCurrentNamespace(refid, true);
                    includeNode = XMLStatementBuilder.this.configuration.getSqlFragments().get(nsrefid);
                    if (includeNode == null) {
                        throw new IncompleteElementException("Could not find SQL statement to include with refid '" + refid + "'");
                    }
                }
                MixedSqlNode mixedSqlNode = new MixedSqlNode(this.contents(includeNode));
                targetContents.add(mixedSqlNode);
            }
            catch (IllegalArgumentException e) {
                throw new IncompleteElementException("Could not find SQL statement to include with refid '" + refid + "'", e);
            }
        }

        private List<SqlNode> contents(XNode includeNode) {
            return XMLStatementBuilder.this.parseDynamicTags(includeNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectKeyHandler
    implements NodeHandler {
        private SelectKeyHandler() {
        }

        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            XNode parent = nodeToHandle.getParent();
            String id = parent.getStringAttribute("id") + "!selectKey";
            String resultType = nodeToHandle.getStringAttribute("resultType");
            Class resultTypeClass = XMLStatementBuilder.this.resolveClass(resultType);
            StatementType statementType = StatementType.valueOf(nodeToHandle.getStringAttribute("statementType", StatementType.PREPARED.toString()));
            String keyProperty = nodeToHandle.getStringAttribute("keyProperty");
            String parameterType = parent.getStringAttribute("parameterType");
            String databaseId = parent.getStringAttribute("databaseId");
            boolean executeBefore = "BEFORE".equals(nodeToHandle.getStringAttribute("order", "AFTER"));
            Class parameterTypeClass = XMLStatementBuilder.this.resolveClass(parameterType);
            boolean useCache = false;
            NoKeyGenerator keyGenerator = new NoKeyGenerator();
            Integer fetchSize = null;
            Integer timeout = null;
            boolean flushCache = false;
            String parameterMap = null;
            String resultMap = null;
            ResultSetType resultSetTypeEnum = null;
            List contents = XMLStatementBuilder.this.parseDynamicTags(nodeToHandle);
            MixedSqlNode rootSqlNode = new MixedSqlNode(contents);
            DynamicSqlSource sqlSource = new DynamicSqlSource(XMLStatementBuilder.this.configuration, rootSqlNode);
            SqlCommandType sqlCommandType = SqlCommandType.SELECT;
            XMLStatementBuilder.this.builderAssistant.addMappedStatement(id, sqlSource, statementType, sqlCommandType, fetchSize, timeout, parameterMap, parameterTypeClass, resultMap, resultTypeClass, resultSetTypeEnum, flushCache, useCache, keyGenerator, keyProperty, null, databaseId);
            id = XMLStatementBuilder.this.builderAssistant.applyCurrentNamespace(id, false);
            MappedStatement keyStatement = XMLStatementBuilder.this.configuration.getMappedStatement(id, false);
            XMLStatementBuilder.this.configuration.addKeyGenerator(id, new SelectKeyGenerator(keyStatement, executeBefore));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface NodeHandler {
        public void handleNode(XNode var1, List<SqlNode> var2);
    }
}

