﻿if(typeof scope == undefined){
    scope = {};
}
scope.chromeApp = $('#searchEngines').is(':visible');
/*省市*/
$(function($){
window.PROVINCES = {"provinces":[{"name":"北京"},{"name":"天津"},{"name":"河北","cities":["石家庄","唐山","秦皇岛","邯郸","邢台","保定","张家口","承德","沧州","廊坊","衡水"]},{"name":"山西","cities":["太原","大同","阳泉","长治","晋城","朔州","晋中","运城","忻州","临汾","吕梁"]},{"name":"内蒙","cities":["呼和浩特","包头","乌海","赤峰","通辽","鄂尔多斯","呼伦贝尔","巴彦淖尔","乌兰察布","兴安","锡林郭勒","阿拉善"]},{"name":"辽宁","cities":["沈阳","大连","鞍山","抚顺","本溪","丹东","锦州","营口","阜新","辽阳","盘锦","铁岭","朝阳","葫芦岛"]},{"name":"吉林","cities":["长春","吉林","四平","辽源","通化","白山","松原","白城","延边朝鲜族自治州"]},{"name":"黑龙江","cities":["哈尔滨","齐齐哈尔","鸡西","鹤岗","双鸭山","大庆","伊春","佳木斯","七台河","牡丹江","黑河","绥化","大兴安岭"]},{"name":"上海"},{"name":"江苏","cities":["南京","无锡","徐州","常州","苏州","南通","连云港","淮安","盐城","扬州","镇江","泰州","宿迁"]},{"name":"浙江","cities":["杭州","宁波","温州","嘉兴","湖州","绍兴","金华","衢州","舟山","台州","丽水"]},{"name":"安徽","cities":["合肥","芜湖","蚌埠","淮南","马鞍山","淮北","铜陵","安庆","黄山","滁州","阜阳","宿州","巢湖","六安","亳州","池州","宣城"]},{"name":"福建","cities":["福州","厦门","莆田","三明","泉州","漳州","南平","龙岩","宁德"]},{"name":"江西","cities":["南昌","景德镇","萍乡","九江","新余","鹰潭","赣州","吉安","宜春","抚州","上饶"]},{"name":"山东","cities":["济南","青岛","淄博","枣庄","东营","烟台","潍坊","济宁","泰安","威海","日照","莱芜","临沂","德州","聊城","滨州","菏泽"]},{"name":"河南","cities":["郑州","开封","洛阳","平顶山","安阳","鹤壁","新乡","焦作","濮阳","许昌","漯河","三门峡","南阳","商丘","信阳","周口","驻马店"]},{"name":"湖北","cities":["武汉","黄石","十堰","宜昌","襄樊","鄂州","荆门","孝感","荆州","黄冈","咸宁","随州","恩施","仙桃","潜江","天门","神农架"]},{"name":"湖南","cities":["长沙","株洲","湘潭","衡阳","邵阳","岳阳","常德","张家界","益阳","郴州","永州","怀化","娄底","湘西"]},{"name":"广东","cities":["广州","韶关","深圳","珠海","汕头","佛山","江门","湛江","茂名","肇庆","惠州","梅州","汕尾","河源","阳江","清远","东莞","中山","潮州","揭阳","云浮"]},{"name":"广西","cities":["南宁","柳州","桂林","梧州","北海","防城港","钦州","贵港","玉林","百色","贺州","河池","来宾","崇左"]},{"name":"海南","cities":["海口","三亚","五指山","琼海","儋州","文昌","万宁","东方","定安","屯昌","澄迈","临高","白沙","昌江","乐东","陵水","保亭","琼中","西沙群岛","南沙群岛","其它岛屿"]},{"name":"重庆"},{"name":"四川","cities":["成都","自贡","攀枝花","泸州","德阳","绵阳","广元","遂宁","内江","乐山","南充","眉山","宜宾","广安","达州","雅安","巴中","资阳","阿坝","甘孜","凉山"]},{"name":"贵州","cities":["贵阳","六盘水","遵义","安顺","铜仁地区","黔西南","毕节","黔东南","黔南"]},{"name":"云南","cities":["昆明","曲靖","玉溪","保山","昭通","丽江","普洱","临沧","楚雄","红河","文山","西双版纳","大理","德宏","怒江","迪庆"]},{"name":"西藏","cities":["拉萨","昌都","山南","日喀则","那曲","阿里","林芝"]},{"name":"陕西","cities":["西安","铜川","宝鸡","咸阳","渭南","延安","汉中","榆林","安康","商洛"]},{"name":"甘肃","cities":["兰州","嘉峪关","金昌","白银","天水","武威","张掖","平凉","酒泉","庆阳","定西","陇南","临夏","甘南"]},{"name":"青海","cities":["西宁","海东","海北","黄南","海南","果洛","玉树","海西"]},{"name":"宁夏","cities":["银川","石嘴山","吴忠","固原","中卫"]},{"name":"新疆","cities":["乌鲁木齐","克拉玛依","吐鲁番","哈密","昌吉","博尔塔拉","巴音郭楞","阿克苏","克孜勒苏","喀什","和田","伊犁","塔城","阿勒泰","其它"]},{"name":"台湾","cities":["台北","台中","台南","高雄","基隆","新竹","嘉义","宜兰","桃园","彰化","苗栗","云林","屏东","彭湖","花莲"]},{"name":"香港"},{"name":"澳门"}]};
});
/*cookie操作*/
var cookieDo = {
    year : 30*24*60*60*1000,
    setCookie : function(c_name,value, domain, path, expiredays) {
        var exdate=new Date();exdate = new Date(exdate.getTime()+expiredays);
        document.cookie=c_name+ "=" + value +
                ((domain==null) ? "" : ";domain="+domain) +
                ((path==null) ? "" : ";path="+path) +
                ((expiredays==null) ? "" : ";expires="+exdate.toGMTString());
    },
    getCookie : function(c_name) {
        if (document.cookie.length>0) {
            c_start=document.cookie.indexOf(c_name + "=");
            if (c_start!=-1) {
                c_start=c_start + c_name.length+1;
                c_end=document.cookie.indexOf(";",c_start);
                if (c_end==-1) c_end=document.cookie.length;
                return unescape(document.cookie.substring(c_start,c_end));
            }
        }
        return "";
    }
};
/*导航tab切换 配置文件*/
$(function () {
    // 搜索的tabs
    window.DATAS = [
        {
            'chName': '网页',
            'name': 'web',
            'se': [
                {'name': 'youdao', 'state': 0},
                {'name': 'google', 'state': 1},
                {'name': 'baidu', 'state': 0}
            ]
        },
        {
            'chName': '图片',
            'name': 'image',
            'se': [
                {'name': 'youdao', 'state': 0},
                {'name': 'google', 'state': 0},
                {'name': 'baidu', 'state': 1}
            ]
        },
        {
            'chName': '视频',
            'name': 'video',
            'se': [
                {'name': 'youdao', 'state': 0},
                {'name': 'baidu', 'state': 1}
            ]
        },
        {
            'chName': '音乐',
            'name': 'music',
            'se': [
                {'name': 'google', 'state': 0},
                {'name': 'baidu', 'state': 1}
            ]
        },
        {
            'chName': '购物',
            'name': 'gouwu',
            'se': [
                {'name': 'baidu', 'state': 1},
                {'name': 'google', 'state': 0}
            ]
        },
        {
            'chName': '新闻',
            'name': 'news',
            'se': [
                {'name': 'youdao', 'state': 0},
                {'name': 'google', 'state': 0},
                {'name': 'baidu', 'state': 1}
            ]
        },
        {
            'chName': '词典',
            'name': 'dict',
            'se': [
                {'name': 'youdao', 'state': 1}
            ]
        },
        
        {
            'chName': '翻译',
            'name': 'fanyi',
            'se': [
                {'name': 'youdao', 'state': 1}
            ]
        },
        {
            'chName': '更多\u00bb',
            'url': 'http://www.baidu.com/more/'
        }
    ];
    // 搜索引擎的JSON数据
    window.SE = {
        'youdao': {
            'name': '有道',
            'fullname': '有道搜索',
            'logo': 'images/youdao.jpg',
            'vs': {
                'web': {
                    'logoLink': 'http://www.youdao.com/',
                    'param': 'q',
                    'searchLink': 'http://www.youdao.com/search'
                },
                'image': {
					'logoLink': 'http://image.youdao.com/',
                    'param': 'q',
                    'searchLink': 'http://image.youdao.com/search'
				},
                'news': {
					'logoLink': 'http://news.youdao.com/',
                    'param': 'q',
                    'searchLink': 'http://news.youdao.com/search'
				},
                'gouwu': {
					'logoLink': 'http://gouwu.youdao.com/',
                    'param': 'q',
                    'searchLink': 'http://gouwu.youdao.com/search'
				},
                'dict': {
					'logoLink': 'http://dict.youdao.com/',
                    'param': 'q',
                    'searchLink': 'http://dict.youdao.com/search'
				},
                'video': {
					'logoLink': 'http://video.youdao.com/',
                    'param': 'q',
                    'searchLink': 'http://video.youdao.com/search'
				},
                'fanyi' : {
                    'logoLink': 'http://fanyi.youdao.com/',
                    'param': 'i',
                    'searchLink': 'http://fanyi.youdao.com/translate'
                }
            }
        },
        'google': {
            'name': '谷歌',
            'fullname': '搜狗搜索',
            'logo': 'images/sogou.jpg',
            'vs': {
                'web': {
                    'logoLink': 'http://www.sogou.com/index.php?pid=sogou-netb-987797582-20141020',
                    'param': 'query',
                    'searchLink': 'http://www.sogou.com/sogou'
                },
                'image': {
					'logoLink': 'http://www.google.com.hk',
                    'param': 'q',
                    'searchLink': 'http://www.google.com.hk/search?prmd=imvns'
				},
                'news': {
					'logoLink': 'http://news.google.com.hk/',
                    'param': 'q',
                    'searchLink': 'http://news.google.com.hk/news/search'
				},
                'gouwu': {
					'logoLink': 'http://www.google.cn/shopping',
                    'param': 'q',
                    'searchLink': 'http://www.google.cn/products'
				},
                'music': {
					'logoLink': 'http://music.google.cn',
                    'param': 'q',
                    'searchLink': 'http://www.google.cn/music/search'
				}
			}
        },
        'baidu' : {
			'name': '百度',
            'fullname': '百度搜索',
            'logo': 'images/baidu.jpg',
            'vs': {
                'web': {
                    'logoLink': 'http://www.baidu.com/',
                    'param': 'wd',
                    'searchLink': 'http://www.baidu.com/s'
                },
                'image': {
					'logoLink': 'http://image.baidu.com/',
                    'param': 'word',
                    'searchLink': 'http://image.baidu.com/i'
				},
                'news': {
					'logoLink': 'http://news.baidu.com/',
                    'param': 'word',
                    'searchLink': 'http://news.baidu.com/ns'
				},
                'music': {
					'logoLink': 'http://music.baidu.com/',
                    'param': 'key',
                    'searchLink': 'http://music.baidu.com/search'
				},
                'gouwu': {
					'logoLink': 'http://gouwu.baidu.com/',
                    'param': 'wd',
                    'searchLink': 'http://gouwu.baidu.com/s'
				},
                'video': {
					'logoLink': 'http://video.baidu.com/',
                    'param': 'word',
                    'searchLink': 'http://video.baidu.com/v'
				}
            }
		}
    };
});

// 邮箱登陆
$(function($) {
    var cur_url = document.location.href;
    var MailConfig = [
        {val:0},
        {action:"https://reg.163.com/logins.jsp",params:{url:"http://account.youdao.com/login?back_url="+encodeURIComponent(cur_url)+"&success=1",username:"#{u}",password:"#{p}",savelogin:"true"}},
        {action:"https://reg.163.com/logins.jsp",params:{savelogin:"true",domain:"126.com",username:"#{u}@126.com",password:"#{p}",url:"http://account.youdao.com/login?back_url="+encodeURIComponent(cur_url)+"&success=1"}},
        {action:"https://reg.163.com/logins.jsp",params:{savelogin:"true",domain:"yeah.net",username:"#{u}@yeah.net",password:"#{p}",url:"http://account.youdao.com/login?back_url="+encodeURIComponent(cur_url)+"&success=1"}},
        {action:"https://edit.bjs.yahoo.com/config/login",params:{login:"#{u}@yahoo.com.cn",passwd:"#{p}",domainss:"yahoo",".intl":"cn",".src":"ym"}},
        {action:"https://edit.bjs.yahoo.com/config/login",params:{login:"#{u}@yahoo.cn",passwd:"#{p}",domainss:"yahoocn",".intl":"cn",".done":"http://mail.cn.yahoo.com/inset.html"}},
        {action:"http://passport.sohu.com/login.jsp",params:{loginid:"#{u}@sohu.com",passwd:"#{p}",fl:"1",vr:"1|1",appid:"1000",ru:"http://login.mail.sohu.com/servlet/LoginServlet",ct:"1173080990",sg:"5082635c77272088ae7241ccdf7cf062"}},
        {action:"http://mail.sina.com.cn/cgi-bin/login.cgi",params:{u:"#{u}",psw:"#{p}"}},
        {action:"http://passport.renren.com/PLogin.do",params:{email:"#{u}",password:"#{p}",origURL:"http://www.renren.com/Home.do",domain:"renren.com"}},
        {action:"https://passport.baidu.com/?login&ie=utf8&",params:{u:"http://passport.baidu.com/center?ie=utf8&",username:"#{u}",password:"#{p}"}},
        {action:"http://passport.tianya.cn:80/login",params:{vwriter:"#{u}",vpassword:"#{p}"}},
        {action:"http://passport.51.com/login.5p",params:{passport_51_user:"#{u}",passport_51_password:"#{p}",gourl:"http%3A%2F%2Fmy.51.com%2Fwebim%2Findex.php"}},
        {val:0},
        {action:"http://gmail.google.com",type:"link"},
        {action:"http://mail.qq.com",type:"link"},
        {action:"http://www.hotmail.com",type:"link"},
        {action:"http://mail.139.com",type:"link"},
        {action:"http://www.kaixin001.com",type:"link"},
        {action:"http://qzone.qq.com/index.html",type:"link"},
        {action:"http://web2.qq.com",type:"link"},
        {action:"https://www.alipay.com/user/login.htm",type:"link"}
    ];

    var selectIndex = ($('#mailtype').get(0) && $('#mailtype').get(0).selectedIndex); // selector index
    var mailInfo = MailConfig[selectIndex]; // current mail infomation
    // type = link
    $('#mailtype').change(function(e) {
        selectIndex = $('#mailtype').get(0).selectedIndex;
        mailInfo = MailConfig[selectIndex];
        if (mailInfo.type == "link") {
            window.open(mailInfo.action);
            resetEmailForm();
        }

    });

    $('#emailLogin').click(function(e) {
        // predication
        var username = $.trim($('#nav_username').val());
        var password = $.trim($('#nav_password').val());
        if (mailInfo.val == 0) {
            alert("请选择邮箱！");
            e.preventDefault();
            return;
        }
        if (username == "") {
            alert("用户名不能为空!");
            e.preventDefault();
            return;
        }
        if (password == "") {
            alert("密码不能为空!");
            e.preventDefault();
            return;
        } else if (password.length < 6) {
            alert("请把密码长度不能小于6!");
            e.preventDefault();
            return;
        }
        var loginInfo = {u:username, p:password};
        // change form
        var params = mailInfo.params;
        if (params) {
            // change form
            $('#loginForm').remove();
            var form = $("<form id='loginForm' name='loginForm'></form>");
            form.attr('method','post')
            form.attr('action', mailInfo.action);
            // insert input
            $.each(params, function(key, val) {
                $('<input>').attr({
                    type: 'hidden',
                    name: key,
                    value: format(val, loginInfo)
                }).appendTo(form);
            });
            // submit
            form.appendTo("body")
            form.css('display','none')
            form.submit();
            resetEmailForm();
        }
        e.preventDefault();
    });
    function format(param, loginInfo) {
        return param.replace("#{p}", loginInfo.p).replace("#{u}", loginInfo.u);
    }
    function resetEmailForm() {
        $('#nav_username').val("");
        $('#nav_password').val("");
        $('#mailtype').val(-1);
    }
});
// 搜索部分的逻辑 - 数据部分见 sejson.js 文件
$(function($){
    var DATAS = window.DATAS || {};
    var SE = window.SE || {};

    var $wrap = $('#searchWrap');
    var $logo = $('#logos a');
    var $tabs = $wrap.find('ul.cnav-list');
    var $form = $wrap.find('form');
    var $input = $('#query');
    var $submitBtn = $wrap.find('input.s-btn');
    var $ses = $('#searchEngines');

    if ($wrap.length === 0 || $logo.length === 0 || $ses.length === 0
            || $tabs.length === 0 || $form.length === 0
            || $input.length === 0 || $submitBtn.length === 0) {
        return false;
    }

    // ---------------------------------------------------------------
    // 初始化tabs
    var _tab;
    var _tabHA = [];
    var tabCur;
    var siteCur;
    if(scope.chromeApp){
        tabCur = cookieDo.getCookie("tabIndex") || 0;
        siteCur = cookieDo.getCookie("data-site") || '';
        if(siteCur){
            for(var i=0;i<DATAS[tabCur].se.length;i++){
                if( DATAS[tabCur].se[i].name == siteCur ){
                    DATAS[tabCur].se[i].state = 1;
                    if(i!=0)
                        DATAS[tabCur].se[0].state = 0;
                }
            }
        }
    }else{
        tabCur = 0;
    }
    for (var i = 0, len = DATAS.length; i < len; i++) {
        _tabHA.push(createSingleTab(
                DATAS[i],
                i,
                (i == tabCur ? true : false)
                ));
    }
    $tabs.html(_tabHA.join(''));

    // ---------------------------------------------------------------
    // 初始化搜索引擎选项
    // @param tab  see window.DATAS[0]
    function initSearchEngines(tab) {
        var defSE,vs;
        if(tab['chName'] === '音乐' && !($ses.is(':visible'))){
            tab['se'][0].state = 0;
            tab['se'][1].state = 1;
        }

        // 更新 搜索引擎列表
        var _searr = tab['se'];
        var _se = null;
        var _sesHA = [];
        var _site = '';
        var tabCur;
        var siteCur;
        if(scope.chromeApp){
            //tabCur = cookieDo.getCookie("tabIndex") || 0;
            siteCur = cookieDo.getCookie("data-site") || '';
            if(siteCur){
                _searr[0].state = 1;
                for(var i=0;i<_searr.length;i++){
                    var name =  _searr[i].name;
                    if(i!=0)
                         _searr[i].state = 0;
                    if( name == siteCur ){
                        _searr[i].state = 1;
                        if(i!=0)
                            _searr[0].state = 0;
                    }
                }
            }
        }else{
            //tabCur = 0;
        }
        
        defSE = _getDefaultSE(tab['se']);
        vs = tab['name'];

        updateSEExtends(defSE, vs);
        
        for (var i = 0, len = _searr.length; i < len; i++) {
            _site = _searr[i]['name'];
            _se = SE[_site];
            _sesHA.push(createSingleRadio(
                    _site,
                    SE[_site]['name'],
                    vs,
                    (_searr[i]['state'] === 1 ? true : false)
                    ));
        }
        $ses.html(_sesHA.join(''));
    }

    // ---------------------------------------------------------------
    // 根据所选搜索引擎，更新对应的['logo', 'form', 'input']
    // @param se 搜索引擎对象
    // @param vs 对应搜索引擎的垂搜名
    function updateSEExtends(se, vs) {

        // 更新 logo
        $logo.attr('href', se['vs'][vs]['logoLink']);
        $logo.find('img').attr('src', se['logo']);

        // 更新 from 表单
        $form.attr('action', se['vs'][vs]['searchLink']);
        
        // 更新 input name
        sug.term = $input.attr('value');  //防止触发suggest的onpropertychange事件
        $input.attr('name', se['vs'][vs]['param']);

        // 更新 提交按钮 名称
        $submitBtn.val(se['fullname']);
    }

    // ---------------------------------------------------------------
    // 根据给定的搜索引擎列表，返回默认的搜索引擎对象
    // 如果队列中未指定默认搜索引擎，则默认为第一个
    // @param seArr Search Engines Array
    //        例如：[
    //                  {'name': 'youdao', 'state': 1},
    //                  {'name': 'google', 'state': 0},
    //                  {'name': 'baidu', 'state': 0}
    //              ]
    function _getDefaultSE (seArr) {
        var se = null, temp;
        for (var i = seArr.length - 1; i >= 0; i--) {
            temp = seArr[i];
            if (temp['state'] === 1) {
                se = SE[temp['name']];
                break;
            }
        }
        if (!se) {
            se = SE[seArr[0]['name']];
        }
        return se;
    }

    // ---------------------------------------------------------------
    // 生成单个搜索引擎选项。如：['有道', '谷歌', '百度']
    // @param seKey 对应搜索引擎的key，如：youdao | google | baidu 等
    // @param seName 搜索引擎中文名称
    // @param vs  对应搜索引擎的垂搜名称
    // @param isDefault 是否默认项 
    function createSingleRadio(seKey, seName, vs, isDefault) {
        var result =
                '<label>' +
                        '<input hidefocus="true" type="radio" name="opt-se" data-vs="' + vs + '" ' +
                        (isDefault ? 'checked' : '') + ' ' +
                        'data-site="' + seKey + '" />' +
                        '<span>' + seName + '</span>' +
                        '</label>';
        return result;
    }

    // ---------------------------------------------------------------
    // 生成单个 tab。如：['网页', '图片', '视频' ...]
    function createSingleTab(obj, idx, isDefault) {
        //console.log(obj, idx, isDefault);
        var result;
        if(obj['chName'] === '更多>>'){
             result =
                    '<li class="' + (isDefault ? 'current' : '') + '" ' +
                            'data-index="' + idx + '" data-vs="' + obj['name'] + '">' +
                            '<a href="' + (obj['url'] ? obj['url'] : 'javascript:void(0);') + '" target="_blank" onclick=ctlog("searchbox.more","more","$!m_testType");>' + obj['chName'] + '</a>' +
                            '</li>';
        }else{
            result =
                    '<li class="' + (isDefault ? 'current' : '') + '" ' +
                            'data-index="' + idx + '" data-vs="' + obj['name'] + '">' +
                            '<a href="' + (obj['url'] ? obj['url'] : 'javascript:void(0);') + '">' + obj['chName'] + '</a>' +
                            '</li>';
        }
        if (isDefault) {
            initSearchEngines(obj);
        }
        return result;
    }

    // ---------------------------------------------------------------
    // 更新某个 tab 下的默认搜索引擎
    // @param vs 垂搜名称
    // @param site 搜索引擎名称
    function updateDefaultSE (vs, site) {
        var tab = null;
        var ses = null;
        for (var i = 0, len = DATAS.length; i < len; i++) {
            tab = DATAS[i];
            if (tab['name'] !== vs) {
                continue;
            }
            ses = tab['se'];
            for (var j = 0, jlen = ses.length; j < jlen; j++) {
                if (ses[j]['name'] === site) {
                    ses[j]['state'] = 1;
                } else {
                    ses[j]['state'] = 0;
                }
            }
        }
    }

    // ---------------------------------------------------------------
    // -- 以下为DOM事件处理
    // ---------------------------------------------------------------

    // ---------------------------------------------------------------
    // 选择搜索引擎 - 点击'radio'的处理
    $ses.delegate('input', 'click', function (evt) {
        var target = $(this);
        var site = target.data('site');
        var vs = target.data('vs');
        if(scope.chromeApp){
            cookieDo.setCookie("data-site",target.attr("data-site"),location.hostname,"/",cookieDo.year);
        }
        updateSEExtends(SE[site], vs);
        updateDefaultSE(vs, site);
    });

    // ---------------------------------------------------------------
    // 切换垂搜 tab
    $tabs.delegate('li', 'click', function (evt) {
        var target = $(this);
        var index = target.data('index');
        var vs = target.data('vs');

        // 点击当前 tab，直接返回
        if (target.hasClass('current')) {
            return false;
        }

        // 切换选中状态
        if (target.attr("data-index") != '8'){
            $tabs.find('li').removeClass('current');
            target.addClass('current');
            if(scope.chromeApp){
                cookieDo.setCookie("tabIndex",target.attr("data-index"),location.hostname,"/",cookieDo.year);
            }
        }
        //tbm用来控制谷歌图片搜索
        if (target.attr("data-index") != '0') {
            $("#tbm").val("isch");
        }else{
            $("#tbm").val("");
        }
        // 切换输入
        initSearchEngines(DATAS[index]);
    });
    function setHomePage(obj) {
        var url = location.href;
        try {
            obj.style.behavior = 'url(#default#homepage)';
            obj.setHomePage(url);
        } catch(e) {
                if (window.netscape) {
                    try { 
                        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
                    }catch (e)  {
                        alert("抱歉！您的浏览器不支持直接设为首页。请在浏览器地址栏输入“about:config”并回车然后将[signed.applets.codebase_principal_support]设置为“true”，点击“加入收藏”后忽略安全提示，即可设置成功。");
                    }
                    var prefs = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch);
                    prefs.setCharPref('browser.startup.homepage',url);
                }else{
                    alert("您的浏览器不支持此功能，请手动设置。");
                }
        }
    }
    $("#setHomePage").bind("click",function(){setHomePage(this);})
});

/*未阅读邮件数字*/
$(function($){
    var domain = "";
    if(typeof(scope) == 'undefined'){
        return;
    }
    if(scope && scope.username){
        domain = scope.username.match(/\w*@(.*)$/)[1];
    }else{
        return;
    }
    window.userdefinedcallback = function (unreadNum,mails,uname){
        if($("a.email").length){
            $("a.email").text(unreadNum);
        }
    };
    var url = "http://msg.mail." + domain + "/cgi/mc?funcid=getusrnewmsgcnt&fid=0&template=newmsgres_setcookie.htm&callback=userdefinedcallback&username=" + scope.username;
    function getUnread(){
        $.ajax({
             url : url,
             type : "get",
             dataType : "jsonp"
        });
    }
    getUnread();
    setInterval(getUnread,1000*60*3);   /*每隔3分钟请求未阅读数*/
});
/*更新头部时间*/
$(function($){
    $("p.date").attr("curdate",new Date().getTime());
    var preDate;
    var nextDate;
    var days = ['周日','周一','周二','周三','周四','周五','周六'];
    function renderTime(){
        preDate = $("p.date").attr("curDate");
        preDate = parseInt(preDate) + 1000*60;
        nextDate = new Date(preDate);
        $("p.date span").eq(0).text((nextDate.getMonth() +1 )+"月"+nextDate.getDate()+"日");
        $("p.date span").eq(1).text(days[nextDate.getDay()]);
        $("p.date span").eq(2).text(nextDate.getHours() + ":" + nextDate.getMinutes());
        $("p.date").attr("curDate",nextDate.getTime());
    }
    renderTime();
    setInterval(renderTime,1000*60);    /*每隔一分钟重新渲染时间*/
});
/*chrome Tip*/
$(function($){
    $("#topTip span").bind("click",function(){
         $("#topTip").css("display","none");     
    });
});
/*用户名下拉列表*/
$(function($){
    var timeid;
    $(".username").bind("click",function(){
         $("#user163List").toggle();
    });
    $(".username").bind("mouseover",function(){
        if(timeid){
             clearTimeout(timeid);
        }
    });
    $(".username").bind("mouseout",function(){
        timeid = setTimeout(function(){$("#user163List").hide();},300);
    });
    $("#user163List").bind("mouseover",function(){
        if(timeid){
            clearTimeout(timeid);
        }
        $("#user163List").show(); 
    });
    $("#user163List").bind("mouseout",function(){
        timeid = setTimeout(function(){$("#user163List").hide();},300);
    });
});

/*手机充值*/
$(function($){
    var mobileInput = $("form.fm-mobile input.txt");
    var firstValue = "";
    var mobileCost = {};
    mobileInput.focus(function(){
        var value = $(this).val();
        if(value == "输入手机号"){
              $(this).val("");
        }
    });
    mobileInput.blur(function(){
        var value = $(this).val();
        if(!$.trim(value)){
              $(this).val("输入手机号");
        }
    });
});