var define, requireModule, require, requirejs;

(function() {
  var registry = {}, seen = {}, state = {};
  var FAILED = false;

  define = function(name, deps, callback) {
    registry[name] = {
      deps: deps,
      callback: callback
    };
  };

  function reify(deps, name, seen) {
    var length = deps.length;
    var reified = new Array(length);
    var dep;
    var exports;

    for (var i = 0, l = length; i < l; i++) {
      dep = deps[i];
      if (dep === 'exports') {
        exports = reified[i] = seen;
      } else {
        reified[i] = require(resolve(dep, name));
      }
    }

    return {
      deps: reified,
      exports: exports
    };
  }

  requirejs = require = requireModule = function(name) {
    if (state[name] !== FAILED &&
        seen.hasOwnProperty(name)) {
      return seen[name];
    }

    if (!registry[name]) {
      throw new Error('Could not find module ' + name);
    }

    var mod = registry[name];
    var reified;
    var module;
    var loaded = false;

    seen[name] = { }; // placeholder for run-time cycles

    try {
      reified = reify(mod.deps, name, seen[name]);
      module = mod.callback.apply(this, reified.deps);
      loaded = true;
    } finally {
      if (!loaded) {
        state[name] = FAILED;
      }
    }

    return reified.exports ? seen[name] : (seen[name] = module);
  };

  function resolve(child, name) {
    if (child.charAt(0) !== '.') { return child; }

    var parts = child.split('/');
    var nameParts = name.split('/');
    var parentBase;

    if (nameParts.length === 1) {
      parentBase = nameParts;
    } else {
      parentBase = nameParts.slice(0, -1);
    }

    for (var i = 0, l = parts.length; i < l; i++) {
      var part = parts[i];

      if (part === '..') { parentBase.pop(); }
      else if (part === '.') { continue; }
      else { parentBase.push(part); }
    }

    return parentBase.join('/');
  }

  requirejs.entries = requirejs._eak_seen = registry;
  requirejs.clear = function(){
    requirejs.entries = requirejs._eak_seen = registry = {};
    seen = state = {};
  };
})();

/*!
 * jQuery JavaScript Library v1.11.0
 * http://jquery.com/
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 *
 * Copyright 2005, 2014 jQuery Foundation, Inc. and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2014-01-23T21:02Z
 */

(function( global, factory ) {

	if ( typeof module === "object" && typeof module.exports === "object" ) {
		// For CommonJS and CommonJS-like environments where a proper window is present,
		// execute the factory and get jQuery
		// For environments that do not inherently posses a window with a document
		// (such as Node.js), expose a jQuery-making factory as module.exports
		// This accentuates the need for the creation of a real window
		// e.g. var jQuery = require("jquery")(window);
		// See ticket #14549 for more info
		module.exports = global.document ?
			factory( global, true ) :
			function( w ) {
				if ( !w.document ) {
					throw new Error( "jQuery requires a window with a document" );
				}
				return factory( w );
			};
	} else {
		factory( global );
	}

// Pass this if window is not defined yet
}(typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Can't do this because several apps including ASP.NET trace
// the stack via arguments.caller.callee and Firefox dies if
// you try to trace through "use strict" call chains. (#13335)
// Support: Firefox 18+
//

var deletedIds = [];

var slice = deletedIds.slice;

var concat = deletedIds.concat;

var push = deletedIds.push;

var indexOf = deletedIds.indexOf;

var class2type = {};

var toString = class2type.toString;

var hasOwn = class2type.hasOwnProperty;

var trim = "".trim;

var support = {};



var
	version = "1.11.0",

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {
		// The jQuery object is actually just the init constructor 'enhanced'
		// Need init if jQuery is called (just allow error to be thrown if not included)
		return new jQuery.fn.init( selector, context );
	},

	// Make sure we trim BOM and NBSP (here's looking at you, Safari 5.0 and IE)
	rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,

	// Matches dashed string for camelizing
	rmsPrefix = /^-ms-/,
	rdashAlpha = /-([\da-z])/gi,

	// Used by jQuery.camelCase as callback to replace()
	fcamelCase = function( all, letter ) {
		return letter.toUpperCase();
	};

jQuery.fn = jQuery.prototype = {
	// The current version of jQuery being used
	jquery: version,

	constructor: jQuery,

	// Start with an empty selector
	selector: "",

	// The default length of a jQuery object is 0
	length: 0,

	toArray: function() {
		return slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {
		return num != null ?

			// Return a 'clean' array
			( num < 0 ? this[ num + this.length ] : this[ num ] ) :

			// Return just the object
			slice.call( this );
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;
		ret.context = this.context;

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	// (You can seed the arguments with an array of args, but this is
	// only used internally.)
	each: function( callback, args ) {
		return jQuery.each( this, callback, args );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map(this, function( elem, i ) {
			return callback.call( elem, i, elem );
		}));
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ) );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	eq: function( i ) {
		var len = this.length,
			j = +i + ( i < 0 ? len : 0 );
		return this.pushStack( j >= 0 && j < len ? [ this[j] ] : [] );
	},

	end: function() {
		return this.prevObject || this.constructor(null);
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: deletedIds.sort,
	splice: deletedIds.splice
};

jQuery.extend = jQuery.fn.extend = function() {
	var src, copyIsArray, copy, name, options, clone,
		target = arguments[0] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;

		// skip the boolean and the target
		target = arguments[ i ] || {};
		i++;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !jQuery.isFunction(target) ) {
		target = {};
	}

	// extend jQuery itself if only one argument is passed
	if ( i === length ) {
		target = this;
		i--;
	}

	for ( ; i < length; i++ ) {
		// Only deal with non-null/undefined values
		if ( (options = arguments[ i ]) != null ) {
			// Extend the base object
			for ( name in options ) {
				src = target[ name ];
				copy = options[ name ];

				// Prevent never-ending loop
				if ( target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject(copy) || (copyIsArray = jQuery.isArray(copy)) ) ) {
					if ( copyIsArray ) {
						copyIsArray = false;
						clone = src && jQuery.isArray(src) ? src : [];

					} else {
						clone = src && jQuery.isPlainObject(src) ? src : {};
					}

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend({
	// Unique for each copy of jQuery on the page
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

	// Assume jQuery is ready without the ready module
	isReady: true,

	error: function( msg ) {
		throw new Error( msg );
	},

	noop: function() {},

	// See test/unit/core.js for details concerning isFunction.
	// Since version 1.3, DOM methods and functions like alert
	// aren't supported. They return false on IE (#2968).
	isFunction: function( obj ) {
		return jQuery.type(obj) === "function";
	},

	isArray: Array.isArray || function( obj ) {
		return jQuery.type(obj) === "array";
	},

	isWindow: function( obj ) {
		/* jshint eqeqeq: false */
		return obj != null && obj == obj.window;
	},

	isNumeric: function( obj ) {
		// parseFloat NaNs numeric-cast false positives (null|true|false|"")
		// ...but misinterprets leading-number strings, particularly hex literals ("0x...")
		// subtraction forces infinities to NaN
		return obj - parseFloat( obj ) >= 0;
	},

	isEmptyObject: function( obj ) {
		var name;
		for ( name in obj ) {
			return false;
		}
		return true;
	},

	isPlainObject: function( obj ) {
		var key;

		// Must be an Object.
		// Because of IE, we also have to check the presence of the constructor property.
		// Make sure that DOM nodes and window objects don't pass through, as well
		if ( !obj || jQuery.type(obj) !== "object" || obj.nodeType || jQuery.isWindow( obj ) ) {
			return false;
		}

		try {
			// Not own constructor property must be Object
			if ( obj.constructor &&
				!hasOwn.call(obj, "constructor") &&
				!hasOwn.call(obj.constructor.prototype, "isPrototypeOf") ) {
				return false;
			}
		} catch ( e ) {
			// IE8,9 Will throw exceptions on certain host objects #9897
			return false;
		}

		// Support: IE<9
		// Handle iteration over inherited properties before own properties.
		if ( support.ownLast ) {
			for ( key in obj ) {
				return hasOwn.call( obj, key );
			}
		}

		// Own properties are enumerated firstly, so to speed up,
		// if last one is own, then all properties are own.
		for ( key in obj ) {}

		return key === undefined || hasOwn.call( obj, key );
	},

	type: function( obj ) {
		if ( obj == null ) {
			return obj + "";
		}
		return typeof obj === "object" || typeof obj === "function" ?
			class2type[ toString.call(obj) ] || "object" :
			typeof obj;
	},

	// Evaluates a script in a global context
	// Workarounds based on findings by Jim Driscoll
	// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context
	globalEval: function( data ) {
		if ( data && jQuery.trim( data ) ) {
			// We use execScript on Internet Explorer
			// We use an anonymous function so that context is window
			// rather than jQuery in Firefox
			( window.execScript || function( data ) {
				window[ "eval" ].call( window, data );
			} )( data );
		}
	},

	// Convert dashed to camelCase; used by the css and data modules
	// Microsoft forgot to hump their vendor prefix (#9572)
	camelCase: function( string ) {
		return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
	},

	nodeName: function( elem, name ) {
		return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
	},

	// args is for internal usage only
	each: function( obj, callback, args ) {
		var value,
			i = 0,
			length = obj.length,
			isArray = isArraylike( obj );

		if ( args ) {
			if ( isArray ) {
				for ( ; i < length; i++ ) {
					value = callback.apply( obj[ i ], args );

					if ( value === false ) {
						break;
					}
				}
			} else {
				for ( i in obj ) {
					value = callback.apply( obj[ i ], args );

					if ( value === false ) {
						break;
					}
				}
			}

		// A special, fast, case for the most common use of each
		} else {
			if ( isArray ) {
				for ( ; i < length; i++ ) {
					value = callback.call( obj[ i ], i, obj[ i ] );

					if ( value === false ) {
						break;
					}
				}
			} else {
				for ( i in obj ) {
					value = callback.call( obj[ i ], i, obj[ i ] );

					if ( value === false ) {
						break;
					}
				}
			}
		}

		return obj;
	},

	// Use native String.trim function wherever possible
	trim: trim && !trim.call("\uFEFF\xA0") ?
		function( text ) {
			return text == null ?
				"" :
				trim.call( text );
		} :

		// Otherwise use our own trimming functionality
		function( text ) {
			return text == null ?
				"" :
				( text + "" ).replace( rtrim, "" );
		},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var ret = results || [];

		if ( arr != null ) {
			if ( isArraylike( Object(arr) ) ) {
				jQuery.merge( ret,
					typeof arr === "string" ?
					[ arr ] : arr
				);
			} else {
				push.call( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		var len;

		if ( arr ) {
			if ( indexOf ) {
				return indexOf.call( arr, elem, i );
			}

			len = arr.length;
			i = i ? i < 0 ? Math.max( 0, len + i ) : i : 0;

			for ( ; i < len; i++ ) {
				// Skip accessing in sparse arrays
				if ( i in arr && arr[ i ] === elem ) {
					return i;
				}
			}
		}

		return -1;
	},

	merge: function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		while ( j < len ) {
			first[ i++ ] = second[ j++ ];
		}

		// Support: IE<9
		// Workaround casting of .length to NaN on otherwise arraylike objects (e.g., NodeLists)
		if ( len !== len ) {
			while ( second[j] !== undefined ) {
				first[ i++ ] = second[ j++ ];
			}
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, invert ) {
		var callbackInverse,
			matches = [],
			i = 0,
			length = elems.length,
			callbackExpect = !invert;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			callbackInverse = !callback( elems[ i ], i );
			if ( callbackInverse !== callbackExpect ) {
				matches.push( elems[ i ] );
			}
		}

		return matches;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var value,
			i = 0,
			length = elems.length,
			isArray = isArraylike( elems ),
			ret = [];

		// Go through the array, translating each of the items to their new values
		if ( isArray ) {
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}

		// Go through every key on the object,
		} else {
			for ( i in elems ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}
		}

		// Flatten any nested arrays
		return concat.apply( [], ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// Bind a function to a context, optionally partially applying any
	// arguments.
	proxy: function( fn, context ) {
		var args, proxy, tmp;

		if ( typeof context === "string" ) {
			tmp = fn[ context ];
			context = fn;
			fn = tmp;
		}

		// Quick check to determine if target is callable, in the spec
		// this throws a TypeError, but we will just return undefined.
		if ( !jQuery.isFunction( fn ) ) {
			return undefined;
		}

		// Simulated bind
		args = slice.call( arguments, 2 );
		proxy = function() {
			return fn.apply( context || this, args.concat( slice.call( arguments ) ) );
		};

		// Set the guid of unique handler to the same of original handler, so it can be removed
		proxy.guid = fn.guid = fn.guid || jQuery.guid++;

		return proxy;
	},

	now: function() {
		return +( new Date() );
	},

	// jQuery.support is not used in Core but other projects attach their
	// properties to it so it needs to exist.
	support: support
});

// Populate the class2type map
jQuery.each("Boolean Number String Function Array Date RegExp Object Error".split(" "), function(i, name) {
	class2type[ "[object " + name + "]" ] = name.toLowerCase();
});

function isArraylike( obj ) {
	var length = obj.length,
		type = jQuery.type( obj );

	if ( type === "function" || jQuery.isWindow( obj ) ) {
		return false;
	}

	if ( obj.nodeType === 1 && length ) {
		return true;
	}

	return type === "array" || length === 0 ||
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;
}
var Sizzle =
/*!
 * Sizzle CSS Selector Engine v1.10.16
 * http://sizzlejs.com/
 *
 * Copyright 2013 jQuery Foundation, Inc. and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2014-01-13
 */
(function( window ) {

var i,
	support,
	Expr,
	getText,
	isXML,
	compile,
	outermostContext,
	sortInput,
	hasDuplicate,

	// Local document vars
	setDocument,
	document,
	docElem,
	documentIsHTML,
	rbuggyQSA,
	rbuggyMatches,
	matches,
	contains,

	// Instance-specific data
	expando = "sizzle" + -(new Date()),
	preferredDoc = window.document,
	dirruns = 0,
	done = 0,
	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
		}
		return 0;
	},

	// General-purpose constants
	strundefined = typeof undefined,
	MAX_NEGATIVE = 1 << 31,

	// Instance methods
	hasOwn = ({}).hasOwnProperty,
	arr = [],
	pop = arr.pop,
	push_native = arr.push,
	push = arr.push,
	slice = arr.slice,
	// Use a stripped-down indexOf if we can't use a native one
	indexOf = arr.indexOf || function( elem ) {
		var i = 0,
			len = this.length;
		for ( ; i < len; i++ ) {
			if ( this[i] === elem ) {
				return i;
			}
		}
		return -1;
	},

	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",

	// Regular expressions

	// Whitespace characters http://www.w3.org/TR/css3-selectors/#whitespace
	whitespace = "[\\x20\\t\\r\\n\\f]",
	// http://www.w3.org/TR/css3-syntax/#characters
	characterEncoding = "(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+",

	// Loosely modeled on CSS identifier characters
	// An unquoted value should be a CSS identifier http://www.w3.org/TR/css3-selectors/#attribute-selectors
	// Proper syntax: http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
	identifier = characterEncoding.replace( "w", "w#" ),

	// Acceptable operators http://www.w3.org/TR/selectors/#attribute-selectors
	attributes = "\\[" + whitespace + "*(" + characterEncoding + ")" + whitespace +
		"*(?:([*^$|!~]?=)" + whitespace + "*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|(" + identifier + ")|)|)" + whitespace + "*\\]",

	// Prefer arguments quoted,
	//   then not containing pseudos/brackets,
	//   then attribute selectors/non-parenthetical expressions,
	//   then anything else
	// These preferences are here to reduce the number of selectors
	//   needing tokenize in the PSEUDO preFilter
	pseudos = ":(" + characterEncoding + ")(?:\\(((['\"])((?:\\\\.|[^\\\\])*?)\\3|((?:\\\\.|[^\\\\()[\\]]|" + attributes.replace( 3, 8 ) + ")*)|.*)\\)|)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*" ),

	rattributeQuotes = new RegExp( "=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g" ),

	rpseudo = new RegExp( pseudos ),
	ridentifier = new RegExp( "^" + identifier + "$" ),

	matchExpr = {
		"ID": new RegExp( "^#(" + characterEncoding + ")" ),
		"CLASS": new RegExp( "^\\.(" + characterEncoding + ")" ),
		"TAG": new RegExp( "^(" + characterEncoding.replace( "w", "w*" ) + ")" ),
		"ATTR": new RegExp( "^" + attributes ),
		"PSEUDO": new RegExp( "^" + pseudos ),
		"CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace +
			"*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace +
			"*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		"bool": new RegExp( "^(?:" + booleans + ")$", "i" ),
		// For use in libraries implementing .is()
		// We use this for POS matching in `select`
		"needsContext": new RegExp( "^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" +
			whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
	},

	rinputs = /^(?:input|select|textarea|button)$/i,
	rheader = /^h\d$/i,

	rnative = /^[^{]+\{\s*\[native \w/,

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

	rsibling = /[+~]/,
	rescape = /'|\\/g,

	// CSS escapes http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
	runescape = new RegExp( "\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)", "ig" ),
	funescape = function( _, escaped, escapedWhitespace ) {
		var high = "0x" + escaped - 0x10000;
		// NaN means non-codepoint
		// Support: Firefox
		// Workaround erroneous numeric interpretation of +"0x"
		return high !== high || escapedWhitespace ?
			escaped :
			high < 0 ?
				// BMP codepoint
				String.fromCharCode( high + 0x10000 ) :
				// Supplemental Plane codepoint (surrogate pair)
				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
	};

// Optimize for push.apply( _, NodeList )
try {
	push.apply(
		(arr = slice.call( preferredDoc.childNodes )),
		preferredDoc.childNodes
	);
	// Support: Android<4.0
	// Detect silently failing push.apply
	arr[ preferredDoc.childNodes.length ].nodeType;
} catch ( e ) {
	push = { apply: arr.length ?

		// Leverage slice if possible
		function( target, els ) {
			push_native.apply( target, slice.call(els) );
		} :

		// Support: IE<9
		// Otherwise append directly
		function( target, els ) {
			var j = target.length,
				i = 0;
			// Can't trust NodeList.length
			while ( (target[j++] = els[i++]) ) {}
			target.length = j - 1;
		}
	};
}

function Sizzle( selector, context, results, seed ) {
	var match, elem, m, nodeType,
		// QSA vars
		i, groups, old, nid, newContext, newSelector;

	if ( ( context ? context.ownerDocument || context : preferredDoc ) !== document ) {
		setDocument( context );
	}

	context = context || document;
	results = results || [];

	if ( !selector || typeof selector !== "string" ) {
		return results;
	}

	if ( (nodeType = context.nodeType) !== 1 && nodeType !== 9 ) {
		return [];
	}

	if ( documentIsHTML && !seed ) {

		// Shortcuts
		if ( (match = rquickExpr.exec( selector )) ) {
			// Speed-up: Sizzle("#ID")
			if ( (m = match[1]) ) {
				if ( nodeType === 9 ) {
					elem = context.getElementById( m );
					// Check parentNode to catch when Blackberry 4.6 returns
					// nodes that are no longer in the document (jQuery #6963)
					if ( elem && elem.parentNode ) {
						// Handle the case where IE, Opera, and Webkit return items
						// by name instead of ID
						if ( elem.id === m ) {
							results.push( elem );
							return results;
						}
					} else {
						return results;
					}
				} else {
					// Context is not a document
					if ( context.ownerDocument && (elem = context.ownerDocument.getElementById( m )) &&
						contains( context, elem ) && elem.id === m ) {
						results.push( elem );
						return results;
					}
				}

			// Speed-up: Sizzle("TAG")
			} else if ( match[2] ) {
				push.apply( results, context.getElementsByTagName( selector ) );
				return results;

			// Speed-up: Sizzle(".CLASS")
			} else if ( (m = match[3]) && support.getElementsByClassName && context.getElementsByClassName ) {
				push.apply( results, context.getElementsByClassName( m ) );
				return results;
			}
		}

		// QSA path
		if ( support.qsa && (!rbuggyQSA || !rbuggyQSA.test( selector )) ) {
			nid = old = expando;
			newContext = context;
			newSelector = nodeType === 9 && selector;

			// qSA works strangely on Element-rooted queries
			// We can work around this by specifying an extra ID on the root
			// and working up from there (Thanks to Andrew Dupont for the technique)
			// IE 8 doesn't work on object elements
			if ( nodeType === 1 && context.nodeName.toLowerCase() !== "object" ) {
				groups = tokenize( selector );

				if ( (old = context.getAttribute("id")) ) {
					nid = old.replace( rescape, "\\$&" );
				} else {
					context.setAttribute( "id", nid );
				}
				nid = "[id='" + nid + "'] ";

				i = groups.length;
				while ( i-- ) {
					groups[i] = nid + toSelector( groups[i] );
				}
				newContext = rsibling.test( selector ) && testContext( context.parentNode ) || context;
				newSelector = groups.join(",");
			}

			if ( newSelector ) {
				try {
					push.apply( results,
						newContext.querySelectorAll( newSelector )
					);
					return results;
				} catch(qsaError) {
				} finally {
					if ( !old ) {
						context.removeAttribute("id");
					}
				}
			}
		}
	}

	// All others
	return select( selector.replace( rtrim, "$1" ), context, results, seed );
}

/**
 * Create key-value caches of limited size
 * @returns {Function(string, Object)} Returns the Object data after storing it on itself with
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
 *	deleting the oldest entry
 */
function createCache() {
	var keys = [];

	function cache( key, value ) {
		// Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
		if ( keys.push( key + " " ) > Expr.cacheLength ) {
			// Only keep the most recent entries
			delete cache[ keys.shift() ];
		}
		return (cache[ key + " " ] = value);
	}
	return cache;
}

/**
 * Mark a function for special use by Sizzle
 * @param {Function} fn The function to mark
 */
function markFunction( fn ) {
	fn[ expando ] = true;
	return fn;
}

/**
 * Support testing using an element
 * @param {Function} fn Passed the created div and expects a boolean result
 */
function assert( fn ) {
	var div = document.createElement("div");

	try {
		return !!fn( div );
	} catch (e) {
		return false;
	} finally {
		// Remove from its parent by default
		if ( div.parentNode ) {
			div.parentNode.removeChild( div );
		}
		// release memory in IE
		div = null;
	}
}

/**
 * Adds the same handler for all of the specified attrs
 * @param {String} attrs Pipe-separated list of attributes
 * @param {Function} handler The method that will be applied
 */
function addHandle( attrs, handler ) {
	var arr = attrs.split("|"),
		i = attrs.length;

	while ( i-- ) {
		Expr.attrHandle[ arr[i] ] = handler;
	}
}

/**
 * Checks document order of two siblings
 * @param {Element} a
 * @param {Element} b
 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
 */
function siblingCheck( a, b ) {
	var cur = b && a,
		diff = cur && a.nodeType === 1 && b.nodeType === 1 &&
			( ~b.sourceIndex || MAX_NEGATIVE ) -
			( ~a.sourceIndex || MAX_NEGATIVE );

	// Use IE sourceIndex if available on both nodes
	if ( diff ) {
		return diff;
	}

	// Check if b follows a
	if ( cur ) {
		while ( (cur = cur.nextSibling) ) {
			if ( cur === b ) {
				return -1;
			}
		}
	}

	return a ? 1 : -1;
}

/**
 * Returns a function to use in pseudos for input types
 * @param {String} type
 */
function createInputPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return name === "input" && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for buttons
 * @param {String} type
 */
function createButtonPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return (name === "input" || name === "button") && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for positionals
 * @param {Function} fn
 */
function createPositionalPseudo( fn ) {
	return markFunction(function( argument ) {
		argument = +argument;
		return markFunction(function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ (j = matchIndexes[i]) ] ) {
					seed[j] = !(matches[j] = seed[j]);
				}
			}
		});
	});
}

/**
 * Checks a node for validity as a Sizzle context
 * @param {Element|Object=} context
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
 */
function testContext( context ) {
	return context && typeof context.getElementsByTagName !== strundefined && context;
}

// Expose support vars for convenience
support = Sizzle.support = {};

/**
 * Detects XML nodes
 * @param {Element|Object} elem An element or a document
 * @returns {Boolean} True iff elem is a non-HTML XML node
 */
isXML = Sizzle.isXML = function( elem ) {
	// documentElement is verified for cases where it doesn't yet exist
	// (such as loading iframes in IE - #4833)
	var documentElement = elem && (elem.ownerDocument || elem).documentElement;
	return documentElement ? documentElement.nodeName !== "HTML" : false;
};

/**
 * Sets document-related variables once based on the current document
 * @param {Element|Object} [doc] An element or document object to use to set the document
 * @returns {Object} Returns the current document
 */
setDocument = Sizzle.setDocument = function( node ) {
	var hasCompare,
		doc = node ? node.ownerDocument || node : preferredDoc,
		parent = doc.defaultView;

	// If no document and documentElement is available, return
	if ( doc === document || doc.nodeType !== 9 || !doc.documentElement ) {
		return document;
	}

	// Set our document
	document = doc;
	docElem = doc.documentElement;

	// Support tests
	documentIsHTML = !isXML( doc );

	// Support: IE>8
	// If iframe document is assigned to "document" variable and if iframe has been reloaded,
	// IE will throw "permission denied" error when accessing "document" variable, see jQuery #13936
	// IE6-8 do not support the defaultView property so parent will be undefined
	if ( parent && parent !== parent.top ) {
		// IE11 does not have attachEvent, so all must suffer
		if ( parent.addEventListener ) {
			parent.addEventListener( "unload", function() {
				setDocument();
			}, false );
		} else if ( parent.attachEvent ) {
			parent.attachEvent( "onunload", function() {
				setDocument();
			});
		}
	}

	/* Attributes
	---------------------------------------------------------------------- */

	// Support: IE<8
	// Verify that getAttribute really returns attributes and not properties (excepting IE8 booleans)
	support.attributes = assert(function( div ) {
		div.className = "i";
		return !div.getAttribute("className");
	});

	/* getElement(s)By*
	---------------------------------------------------------------------- */

	// Check if getElementsByTagName("*") returns only elements
	support.getElementsByTagName = assert(function( div ) {
		div.appendChild( doc.createComment("") );
		return !div.getElementsByTagName("*").length;
	});

	// Check if getElementsByClassName can be trusted
	support.getElementsByClassName = rnative.test( doc.getElementsByClassName ) && assert(function( div ) {
		div.innerHTML = "<div class='a'></div><div class='a i'></div>";

		// Support: Safari<4
		// Catch class over-caching
		div.firstChild.className = "i";
		// Support: Opera<10
		// Catch gEBCN failure to find non-leading classes
		return div.getElementsByClassName("i").length === 2;
	});

	// Support: IE<10
	// Check if getElementById returns elements by name
	// The broken getElementById methods don't pick up programatically-set names,
	// so use a roundabout getElementsByName test
	support.getById = assert(function( div ) {
		docElem.appendChild( div ).id = expando;
		return !doc.getElementsByName || !doc.getElementsByName( expando ).length;
	});

	// ID find and filter
	if ( support.getById ) {
		Expr.find["ID"] = function( id, context ) {
			if ( typeof context.getElementById !== strundefined && documentIsHTML ) {
				var m = context.getElementById( id );
				// Check parentNode to catch when Blackberry 4.6 returns
				// nodes that are no longer in the document #6963
				return m && m.parentNode ? [m] : [];
			}
		};
		Expr.filter["ID"] = function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				return elem.getAttribute("id") === attrId;
			};
		};
	} else {
		// Support: IE6/7
		// getElementById is not reliable as a find shortcut
		delete Expr.find["ID"];

		Expr.filter["ID"] =  function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				var node = typeof elem.getAttributeNode !== strundefined && elem.getAttributeNode("id");
				return node && node.value === attrId;
			};
		};
	}

	// Tag
	Expr.find["TAG"] = support.getElementsByTagName ?
		function( tag, context ) {
			if ( typeof context.getElementsByTagName !== strundefined ) {
				return context.getElementsByTagName( tag );
			}
		} :
		function( tag, context ) {
			var elem,
				tmp = [],
				i = 0,
				results = context.getElementsByTagName( tag );

			// Filter out possible comments
			if ( tag === "*" ) {
				while ( (elem = results[i++]) ) {
					if ( elem.nodeType === 1 ) {
						tmp.push( elem );
					}
				}

				return tmp;
			}
			return results;
		};

	// Class
	Expr.find["CLASS"] = support.getElementsByClassName && function( className, context ) {
		if ( typeof context.getElementsByClassName !== strundefined && documentIsHTML ) {
			return context.getElementsByClassName( className );
		}
	};

	/* QSA/matchesSelector
	---------------------------------------------------------------------- */

	// QSA and matchesSelector support

	// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
	rbuggyMatches = [];

	// qSa(:focus) reports false when true (Chrome 21)
	// We allow this because of a bug in IE8/9 that throws an error
	// whenever `document.activeElement` is accessed on an iframe
	// So, we allow :focus to pass through QSA all the time to avoid the IE error
	// See http://bugs.jquery.com/ticket/13378
	rbuggyQSA = [];

	if ( (support.qsa = rnative.test( doc.querySelectorAll )) ) {
		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert(function( div ) {
			// Select is set to empty string on purpose
			// This is to test IE's treatment of not explicitly
			// setting a boolean content attribute,
			// since its presence should be enough
			// http://bugs.jquery.com/ticket/12359
			div.innerHTML = "<select t=''><option selected=''></option></select>";

			// Support: IE8, Opera 10-12
			// Nothing should be selected when empty strings follow ^= or $= or *=
			if ( div.querySelectorAll("[t^='']").length ) {
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );
			}

			// Support: IE8
			// Boolean attributes and "value" are not treated correctly
			if ( !div.querySelectorAll("[selected]").length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
			}

			// Webkit/Opera - :checked should return selected option elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			// IE8 throws error here and will not see later tests
			if ( !div.querySelectorAll(":checked").length ) {
				rbuggyQSA.push(":checked");
			}
		});

		assert(function( div ) {
			// Support: Windows 8 Native Apps
			// The type and name attributes are restricted during .innerHTML assignment
			var input = doc.createElement("input");
			input.setAttribute( "type", "hidden" );
			div.appendChild( input ).setAttribute( "name", "D" );

			// Support: IE8
			// Enforce case-sensitivity of name attribute
			if ( div.querySelectorAll("[name=d]").length ) {
				rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );
			}

			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
			// IE8 throws error here and will not see later tests
			if ( !div.querySelectorAll(":enabled").length ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Opera 10-11 does not throw on post-comma invalid pseudos
			div.querySelectorAll("*,:x");
			rbuggyQSA.push(",.*:");
		});
	}

	if ( (support.matchesSelector = rnative.test( (matches = docElem.webkitMatchesSelector ||
		docElem.mozMatchesSelector ||
		docElem.oMatchesSelector ||
		docElem.msMatchesSelector) )) ) {

		assert(function( div ) {
			// Check to see if it's possible to do matchesSelector
			// on a disconnected node (IE 9)
			support.disconnectedMatch = matches.call( div, "div" );

			// This should fail with an exception
			// Gecko does not error, returns false instead
			matches.call( div, "[s!='']:x" );
			rbuggyMatches.push( "!=", pseudos );
		});
	}

	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join("|") );
	rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join("|") );

	/* Contains
	---------------------------------------------------------------------- */
	hasCompare = rnative.test( docElem.compareDocumentPosition );

	// Element contains another
	// Purposefully does not implement inclusive descendent
	// As in, an element does not contain itself
	contains = hasCompare || rnative.test( docElem.contains ) ?
		function( a, b ) {
			var adown = a.nodeType === 9 ? a.documentElement : a,
				bup = b && b.parentNode;
			return a === bup || !!( bup && bup.nodeType === 1 && (
				adown.contains ?
					adown.contains( bup ) :
					a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
			));
		} :
		function( a, b ) {
			if ( b ) {
				while ( (b = b.parentNode) ) {
					if ( b === a ) {
						return true;
					}
				}
			}
			return false;
		};

	/* Sorting
	---------------------------------------------------------------------- */

	// Document order sorting
	sortOrder = hasCompare ?
	function( a, b ) {

		// Flag for duplicate removal
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		// Sort on method existence if only one input has compareDocumentPosition
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
		if ( compare ) {
			return compare;
		}

		// Calculate position if both inputs belong to the same document
		compare = ( a.ownerDocument || a ) === ( b.ownerDocument || b ) ?
			a.compareDocumentPosition( b ) :

			// Otherwise we know they are disconnected
			1;

		// Disconnected nodes
		if ( compare & 1 ||
			(!support.sortDetached && b.compareDocumentPosition( a ) === compare) ) {

			// Choose the first element that is related to our preferred document
			if ( a === doc || a.ownerDocument === preferredDoc && contains(preferredDoc, a) ) {
				return -1;
			}
			if ( b === doc || b.ownerDocument === preferredDoc && contains(preferredDoc, b) ) {
				return 1;
			}

			// Maintain original order
			return sortInput ?
				( indexOf.call( sortInput, a ) - indexOf.call( sortInput, b ) ) :
				0;
		}

		return compare & 4 ? -1 : 1;
	} :
	function( a, b ) {
		// Exit early if the nodes are identical
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		var cur,
			i = 0,
			aup = a.parentNode,
			bup = b.parentNode,
			ap = [ a ],
			bp = [ b ];

		// Parentless nodes are either documents or disconnected
		if ( !aup || !bup ) {
			return a === doc ? -1 :
				b === doc ? 1 :
				aup ? -1 :
				bup ? 1 :
				sortInput ?
				( indexOf.call( sortInput, a ) - indexOf.call( sortInput, b ) ) :
				0;

		// If the nodes are siblings, we can do a quick check
		} else if ( aup === bup ) {
			return siblingCheck( a, b );
		}

		// Otherwise we need full lists of their ancestors for comparison
		cur = a;
		while ( (cur = cur.parentNode) ) {
			ap.unshift( cur );
		}
		cur = b;
		while ( (cur = cur.parentNode) ) {
			bp.unshift( cur );
		}

		// Walk down the tree looking for a discrepancy
		while ( ap[i] === bp[i] ) {
			i++;
		}

		return i ?
			// Do a sibling check if the nodes have a common ancestor
			siblingCheck( ap[i], bp[i] ) :

			// Otherwise nodes in our document sort first
			ap[i] === preferredDoc ? -1 :
			bp[i] === preferredDoc ? 1 :
			0;
	};

	return doc;
};

Sizzle.matches = function( expr, elements ) {
	return Sizzle( expr, null, null, elements );
};

Sizzle.matchesSelector = function( elem, expr ) {
	// Set document vars if needed
	if ( ( elem.ownerDocument || elem ) !== document ) {
		setDocument( elem );
	}

	// Make sure that attribute selectors are quoted
	expr = expr.replace( rattributeQuotes, "='$1']" );

	if ( support.matchesSelector && documentIsHTML &&
		( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&
		( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {

		try {
			var ret = matches.call( elem, expr );

			// IE 9's matchesSelector returns false on disconnected nodes
			if ( ret || support.disconnectedMatch ||
					// As well, disconnected nodes are said to be in a document
					// fragment in IE 9
					elem.document && elem.document.nodeType !== 11 ) {
				return ret;
			}
		} catch(e) {}
	}

	return Sizzle( expr, document, null, [elem] ).length > 0;
};

Sizzle.contains = function( context, elem ) {
	// Set document vars if needed
	if ( ( context.ownerDocument || context ) !== document ) {
		setDocument( context );
	}
	return contains( context, elem );
};

Sizzle.attr = function( elem, name ) {
	// Set document vars if needed
	if ( ( elem.ownerDocument || elem ) !== document ) {
		setDocument( elem );
	}

	var fn = Expr.attrHandle[ name.toLowerCase() ],
		// Don't get fooled by Object.prototype properties (jQuery #13807)
		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
			fn( elem, name, !documentIsHTML ) :
			undefined;

	return val !== undefined ?
		val :
		support.attributes || !documentIsHTML ?
			elem.getAttribute( name ) :
			(val = elem.getAttributeNode(name)) && val.specified ?
				val.value :
				null;
};

Sizzle.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

/**
 * Document sorting and removing duplicates
 * @param {ArrayLike} results
 */
Sizzle.uniqueSort = function( results ) {
	var elem,
		duplicates = [],
		j = 0,
		i = 0;

	// Unless we *know* we can detect duplicates, assume their presence
	hasDuplicate = !support.detectDuplicates;
	sortInput = !support.sortStable && results.slice( 0 );
	results.sort( sortOrder );

	if ( hasDuplicate ) {
		while ( (elem = results[i++]) ) {
			if ( elem === results[ i ] ) {
				j = duplicates.push( i );
			}
		}
		while ( j-- ) {
			results.splice( duplicates[ j ], 1 );
		}
	}

	// Clear input after sorting to release objects
	// See https://github.com/jquery/sizzle/pull/225
	sortInput = null;

	return results;
};

/**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */
getText = Sizzle.getText = function( elem ) {
	var node,
		ret = "",
		i = 0,
		nodeType = elem.nodeType;

	if ( !nodeType ) {
		// If no nodeType, this is expected to be an array
		while ( (node = elem[i++]) ) {
			// Do not traverse comment nodes
			ret += getText( node );
		}
	} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {
		// Use textContent for elements
		// innerText usage removed for consistency of new lines (jQuery #11153)
		if ( typeof elem.textContent === "string" ) {
			return elem.textContent;
		} else {
			// Traverse its children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				ret += getText( elem );
			}
		}
	} else if ( nodeType === 3 || nodeType === 4 ) {
		return elem.nodeValue;
	}
	// Do not include comment or processing instruction nodes

	return ret;
};

Expr = Sizzle.selectors = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	attrHandle: {},

	find: {},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		"ATTR": function( match ) {
			match[1] = match[1].replace( runescape, funescape );

			// Move the given value to match[3] whether quoted or unquoted
			match[3] = ( match[4] || match[5] || "" ).replace( runescape, funescape );

			if ( match[2] === "~=" ) {
				match[3] = " " + match[3] + " ";
			}

			return match.slice( 0, 4 );
		},

		"CHILD": function( match ) {
			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
			match[1] = match[1].toLowerCase();

			if ( match[1].slice( 0, 3 ) === "nth" ) {
				// nth-* requires argument
				if ( !match[3] ) {
					Sizzle.error( match[0] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[4] = +( match[4] ? match[5] + (match[6] || 1) : 2 * ( match[3] === "even" || match[3] === "odd" ) );
				match[5] = +( ( match[7] + match[8] ) || match[3] === "odd" );

			// other types prohibit arguments
			} else if ( match[3] ) {
				Sizzle.error( match[0] );
			}

			return match;
		},

		"PSEUDO": function( match ) {
			var excess,
				unquoted = !match[5] && match[2];

			if ( matchExpr["CHILD"].test( match[0] ) ) {
				return null;
			}

			// Accept quoted arguments as-is
			if ( match[3] && match[4] !== undefined ) {
				match[2] = match[4];

			// Strip excess characters from unquoted arguments
			} else if ( unquoted && rpseudo.test( unquoted ) &&
				// Get excess from tokenize (recursively)
				(excess = tokenize( unquoted, true )) &&
				// advance to the next closing parenthesis
				(excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length) ) {

				// excess is a negative index
				match[0] = match[0].slice( 0, excess );
				match[2] = unquoted.slice( 0, excess );
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {

		"TAG": function( nodeNameSelector ) {
			var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
			return nodeNameSelector === "*" ?
				function() { return true; } :
				function( elem ) {
					return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
				};
		},

		"CLASS": function( className ) {
			var pattern = classCache[ className + " " ];

			return pattern ||
				(pattern = new RegExp( "(^|" + whitespace + ")" + className + "(" + whitespace + "|$)" )) &&
				classCache( className, function( elem ) {
					return pattern.test( typeof elem.className === "string" && elem.className || typeof elem.getAttribute !== strundefined && elem.getAttribute("class") || "" );
				});
		},

		"ATTR": function( name, operator, check ) {
			return function( elem ) {
				var result = Sizzle.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				return operator === "=" ? result === check :
					operator === "!=" ? result !== check :
					operator === "^=" ? check && result.indexOf( check ) === 0 :
					operator === "*=" ? check && result.indexOf( check ) > -1 :
					operator === "$=" ? check && result.slice( -check.length ) === check :
					operator === "~=" ? ( " " + result + " " ).indexOf( check ) > -1 :
					operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :
					false;
			};
		},

		"CHILD": function( type, what, argument, first, last ) {
			var simple = type.slice( 0, 3 ) !== "nth",
				forward = type.slice( -4 ) !== "last",
				ofType = what === "of-type";

			return first === 1 && last === 0 ?

				// Shortcut for :nth-*(n)
				function( elem ) {
					return !!elem.parentNode;
				} :

				function( elem, context, xml ) {
					var cache, outerCache, node, diff, nodeIndex, start,
						dir = simple !== forward ? "nextSibling" : "previousSibling",
						parent = elem.parentNode,
						name = ofType && elem.nodeName.toLowerCase(),
						useCache = !xml && !ofType;

					if ( parent ) {

						// :(first|last|only)-(child|of-type)
						if ( simple ) {
							while ( dir ) {
								node = elem;
								while ( (node = node[ dir ]) ) {
									if ( ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1 ) {
										return false;
									}
								}
								// Reverse direction for :only-* (if we haven't yet done so)
								start = dir = type === "only" && !start && "nextSibling";
							}
							return true;
						}

						start = [ forward ? parent.firstChild : parent.lastChild ];

						// non-xml :nth-child(...) stores cache data on `parent`
						if ( forward && useCache ) {
							// Seek `elem` from a previously-cached index
							outerCache = parent[ expando ] || (parent[ expando ] = {});
							cache = outerCache[ type ] || [];
							nodeIndex = cache[0] === dirruns && cache[1];
							diff = cache[0] === dirruns && cache[2];
							node = nodeIndex && parent.childNodes[ nodeIndex ];

							while ( (node = ++nodeIndex && node && node[ dir ] ||

								// Fallback to seeking `elem` from the start
								(diff = nodeIndex = 0) || start.pop()) ) {

								// When found, cache indexes on `parent` and break
								if ( node.nodeType === 1 && ++diff && node === elem ) {
									outerCache[ type ] = [ dirruns, nodeIndex, diff ];
									break;
								}
							}

						// Use previously-cached element index if available
						} else if ( useCache && (cache = (elem[ expando ] || (elem[ expando ] = {}))[ type ]) && cache[0] === dirruns ) {
							diff = cache[1];

						// xml :nth-child(...) or :nth-last-child(...) or :nth(-last)?-of-type(...)
						} else {
							// Use the same loop as above to seek `elem` from the start
							while ( (node = ++nodeIndex && node && node[ dir ] ||
								(diff = nodeIndex = 0) || start.pop()) ) {

								if ( ( ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1 ) && ++diff ) {
									// Cache the index of each encountered element
									if ( useCache ) {
										(node[ expando ] || (node[ expando ] = {}))[ type ] = [ dirruns, diff ];
									}

									if ( node === elem ) {
										break;
									}
								}
							}
						}

						// Incorporate the offset, then check against cycle size
						diff -= last;
						return diff === first || ( diff % first === 0 && diff / first >= 0 );
					}
				};
		},

		"PSEUDO": function( pseudo, argument ) {
			// pseudo-class names are case-insensitive
			// http://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					Sizzle.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as Sizzle does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction(function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf.call( seed, matched[i] );
							seed[ idx ] = !( matches[ idx ] = matched[i] );
						}
					}) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {
		// Potentially complex pseudos
		"not": markFunction(function( selector ) {
			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrim, "$1" ) );

			return matcher[ expando ] ?
				markFunction(function( seed, matches, context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( (elem = unmatched[i]) ) {
							seed[i] = !(matches[i] = elem);
						}
					}
				}) :
				function( elem, context, xml ) {
					input[0] = elem;
					matcher( input, null, xml, results );
					return !results.pop();
				};
		}),

		"has": markFunction(function( selector ) {
			return function( elem ) {
				return Sizzle( selector, elem ).length > 0;
			};
		}),

		"contains": markFunction(function( text ) {
			return function( elem ) {
				return ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;
			};
		}),

		// "Whether an element is represented by a :lang() selector
		// is based solely on the element's language value
		// being equal to the identifier C,
		// or beginning with the identifier C immediately followed by "-".
		// The matching of C against the element's language value is performed case-insensitively.
		// The identifier C does not have to be a valid language name."
		// http://www.w3.org/TR/selectors/#lang-pseudo
		"lang": markFunction( function( lang ) {
			// lang value must be a valid identifier
			if ( !ridentifier.test(lang || "") ) {
				Sizzle.error( "unsupported lang: " + lang );
			}
			lang = lang.replace( runescape, funescape ).toLowerCase();
			return function( elem ) {
				var elemLang;
				do {
					if ( (elemLang = documentIsHTML ?
						elem.lang :
						elem.getAttribute("xml:lang") || elem.getAttribute("lang")) ) {

						elemLang = elemLang.toLowerCase();
						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
					}
				} while ( (elem = elem.parentNode) && elem.nodeType === 1 );
				return false;
			};
		}),

		// Miscellaneous
		"target": function( elem ) {
			var hash = window.location && window.location.hash;
			return hash && hash.slice( 1 ) === elem.id;
		},

		"root": function( elem ) {
			return elem === docElem;
		},

		"focus": function( elem ) {
			return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
		},

		// Boolean properties
		"enabled": function( elem ) {
			return elem.disabled === false;
		},

		"disabled": function( elem ) {
			return elem.disabled === true;
		},

		"checked": function( elem ) {
			// In CSS3, :checked should return both checked and selected elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			var nodeName = elem.nodeName.toLowerCase();
			return (nodeName === "input" && !!elem.checked) || (nodeName === "option" && !!elem.selected);
		},

		"selected": function( elem ) {
			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		// Contents
		"empty": function( elem ) {
			// http://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
			//   but not by others (comment: 8; processing instruction: 7; etc.)
			// nodeType < 6 works because attributes (2) do not appear as children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				if ( elem.nodeType < 6 ) {
					return false;
				}
			}
			return true;
		},

		"parent": function( elem ) {
			return !Expr.pseudos["empty"]( elem );
		},

		// Element/input types
		"header": function( elem ) {
			return rheader.test( elem.nodeName );
		},

		"input": function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		"button": function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && elem.type === "button" || name === "button";
		},

		"text": function( elem ) {
			var attr;
			return elem.nodeName.toLowerCase() === "input" &&
				elem.type === "text" &&

				// Support: IE<8
				// New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
				( (attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text" );
		},

		// Position-in-collection
		"first": createPositionalPseudo(function() {
			return [ 0 ];
		}),

		"last": createPositionalPseudo(function( matchIndexes, length ) {
			return [ length - 1 ];
		}),

		"eq": createPositionalPseudo(function( matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		}),

		"even": createPositionalPseudo(function( matchIndexes, length ) {
			var i = 0;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"odd": createPositionalPseudo(function( matchIndexes, length ) {
			var i = 1;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"lt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"gt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		})
	}
};

Expr.pseudos["nth"] = Expr.pseudos["eq"];

// Add button/input type pseudos
for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
	Expr.pseudos[ i ] = createInputPseudo( i );
}
for ( i in { submit: true, reset: true } ) {
	Expr.pseudos[ i ] = createButtonPseudo( i );
}

// Easy API for creating new setFilters
function setFilters() {}
setFilters.prototype = Expr.filters = Expr.pseudos;
Expr.setFilters = new setFilters();

function tokenize( selector, parseOnly ) {
	var matched, match, tokens, type,
		soFar, groups, preFilters,
		cached = tokenCache[ selector + " " ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || (match = rcomma.exec( soFar )) ) {
			if ( match ) {
				// Don't consume trailing commas as valid
				soFar = soFar.slice( match[0].length ) || soFar;
			}
			groups.push( (tokens = []) );
		}

		matched = false;

		// Combinators
		if ( (match = rcombinators.exec( soFar )) ) {
			matched = match.shift();
			tokens.push({
				value: matched,
				// Cast descendant combinators to space
				type: match[0].replace( rtrim, " " )
			});
			soFar = soFar.slice( matched.length );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||
				(match = preFilters[ type ]( match ))) ) {
				matched = match.shift();
				tokens.push({
					value: matched,
					type: type,
					matches: match
				});
				soFar = soFar.slice( matched.length );
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	return parseOnly ?
		soFar.length :
		soFar ?
			Sizzle.error( selector ) :
			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
}

function toSelector( tokens ) {
	var i = 0,
		len = tokens.length,
		selector = "";
	for ( ; i < len; i++ ) {
		selector += tokens[i].value;
	}
	return selector;
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		checkNonElements = base && dir === "parentNode",
		doneName = done++;

	return combinator.first ?
		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( (elem = elem[ dir ]) ) {
				if ( elem.nodeType === 1 || checkNonElements ) {
					return matcher( elem, context, xml );
				}
			}
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			var oldCache, outerCache,
				newCache = [ dirruns, doneName ];

			// We can't set arbitrary data on XML nodes, so they don't benefit from dir caching
			if ( xml ) {
				while ( (elem = elem[ dir ]) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						if ( matcher( elem, context, xml ) ) {
							return true;
						}
					}
				}
			} else {
				while ( (elem = elem[ dir ]) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						outerCache = elem[ expando ] || (elem[ expando ] = {});
						if ( (oldCache = outerCache[ dir ]) &&
							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

							// Assign to newCache so results back-propagate to previous elements
							return (newCache[ 2 ] = oldCache[ 2 ]);
						} else {
							// Reuse newcache so results back-propagate to previous elements
							outerCache[ dir ] = newCache;

							// A match means we're done; a fail means we have to keep checking
							if ( (newCache[ 2 ] = matcher( elem, context, xml )) ) {
								return true;
							}
						}
					}
				}
			}
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[i]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[0];
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( (elem = unmatched[i]) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction(function( seed, results, context, xml ) {
		var temp, i, elem,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed || multipleContexts( selector || "*", context.nodeType ? [ context ] : context, [] ),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems,

			matcherOut = matcher ?
				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results :
				matcherIn;

		// Find primary matches
		if ( matcher ) {
			matcher( matcherIn, matcherOut, context, xml );
		}

		// Apply postFilter
		if ( postFilter ) {
			temp = condense( matcherOut, postMap );
			postFilter( temp, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = temp.length;
			while ( i-- ) {
				if ( (elem = temp[i]) ) {
					matcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);
				}
			}
		}

		if ( seed ) {
			if ( postFinder || preFilter ) {
				if ( postFinder ) {
					// Get the final matcherOut by condensing this intermediate into postFinder contexts
					temp = [];
					i = matcherOut.length;
					while ( i-- ) {
						if ( (elem = matcherOut[i]) ) {
							// Restore matcherIn since elem is not yet a final match
							temp.push( (matcherIn[i] = elem) );
						}
					}
					postFinder( null, (matcherOut = []), temp, xml );
				}

				// Move matched elements from seed to results to keep them synchronized
				i = matcherOut.length;
				while ( i-- ) {
					if ( (elem = matcherOut[i]) &&
						(temp = postFinder ? indexOf.call( seed, elem ) : preMap[i]) > -1 ) {

						seed[temp] = !(results[temp] = elem);
					}
				}
			}

		// Add elements to results, through postFinder if defined
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	});
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[0].type ],
		implicitRelative = leadingRelative || Expr.relative[" "],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf.call( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {
			return ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
				(checkContext = context).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );
		} ];

	for ( ; i < len; i++ ) {
		if ( (matcher = Expr.relative[ tokens[i].type ]) ) {
			matchers = [ addCombinator(elementMatcher( matchers ), matcher) ];
		} else {
			matcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {
				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[j].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && toSelector(
						// If the preceding token was a descendant combinator, insert an implicit any-element `*`
						tokens.slice( 0, i - 1 ).concat({ value: tokens[ i - 2 ].type === " " ? "*" : "" })
					).replace( rtrim, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( (tokens = tokens.slice( j )) ),
					j < len && toSelector( tokens )
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, outermost ) {
			var elem, j, matcher,
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				setMatched = [],
				contextBackup = outermostContext,
				// We must always have either seed elements or outermost context
				elems = seed || byElement && Expr.find["TAG"]( "*", outermost ),
				// Use integer dirruns iff this is the outermost matcher
				dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.random() || 0.1),
				len = elems.length;

			if ( outermost ) {
				outermostContext = context !== document && context;
			}

			// Add elements passing elementMatchers directly to results
			// Keep `i` a string if there are no elements so `matchedCount` will be "00" below
			// Support: IE<9, Safari
			// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
			for ( ; i !== len && (elem = elems[i]) != null; i++ ) {
				if ( byElement && elem ) {
					j = 0;
					while ( (matcher = elementMatchers[j++]) ) {
						if ( matcher( elem, context, xml ) ) {
							results.push( elem );
							break;
						}
					}
					if ( outermost ) {
						dirruns = dirrunsUnique;
					}
				}

				// Track unmatched elements for set filters
				if ( bySet ) {
					// They will have gone through all possible matchers
					if ( (elem = !matcher && elem) ) {
						matchedCount--;
					}

					// Lengthen the array for every element, matched or not
					if ( seed ) {
						unmatched.push( elem );
					}
				}
			}

			// Apply set filters to unmatched elements
			matchedCount += i;
			if ( bySet && i !== matchedCount ) {
				j = 0;
				while ( (matcher = setMatchers[j++]) ) {
					matcher( unmatched, setMatched, context, xml );
				}

				if ( seed ) {
					// Reintegrate element matches to eliminate the need for sorting
					if ( matchedCount > 0 ) {
						while ( i-- ) {
							if ( !(unmatched[i] || setMatched[i]) ) {
								setMatched[i] = pop.call( results );
							}
						}
					}

					// Discard index placeholder values to get only actual matches
					setMatched = condense( setMatched );
				}

				// Add matches to results
				push.apply( results, setMatched );

				// Seedless set matches succeeding multiple successful matchers stipulate sorting
				if ( outermost && !seed && setMatched.length > 0 &&
					( matchedCount + setMatchers.length ) > 1 ) {

					Sizzle.uniqueSort( results );
				}
			}

			// Override manipulation of globals by nested matchers
			if ( outermost ) {
				dirruns = dirrunsUnique;
				outermostContext = contextBackup;
			}

			return unmatched;
		};

	return bySet ?
		markFunction( superMatcher ) :
		superMatcher;
}

compile = Sizzle.compile = function( selector, group /* Internal Use Only */ ) {
	var i,
		setMatchers = [],
		elementMatchers = [],
		cached = compilerCache[ selector + " " ];

	if ( !cached ) {
		// Generate a function of recursive functions that can be used to check each element
		if ( !group ) {
			group = tokenize( selector );
		}
		i = group.length;
		while ( i-- ) {
			cached = matcherFromTokens( group[i] );
			if ( cached[ expando ] ) {
				setMatchers.push( cached );
			} else {
				elementMatchers.push( cached );
			}
		}

		// Cache the compiled function
		cached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );
	}
	return cached;
};

function multipleContexts( selector, contexts, results ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		Sizzle( selector, contexts[i], results );
	}
	return results;
}

function select( selector, context, results, seed ) {
	var i, tokens, token, type, find,
		match = tokenize( selector );

	if ( !seed ) {
		// Try to minimize operations if there is only one group
		if ( match.length === 1 ) {

			// Take a shortcut and set the context if the root selector is an ID
			tokens = match[0] = match[0].slice( 0 );
			if ( tokens.length > 2 && (token = tokens[0]).type === "ID" &&
					support.getById && context.nodeType === 9 && documentIsHTML &&
					Expr.relative[ tokens[1].type ] ) {

				context = ( Expr.find["ID"]( token.matches[0].replace(runescape, funescape), context ) || [] )[0];
				if ( !context ) {
					return results;
				}
				selector = selector.slice( tokens.shift().value.length );
			}

			// Fetch a seed set for right-to-left matching
			i = matchExpr["needsContext"].test( selector ) ? 0 : tokens.length;
			while ( i-- ) {
				token = tokens[i];

				// Abort if we hit a combinator
				if ( Expr.relative[ (type = token.type) ] ) {
					break;
				}
				if ( (find = Expr.find[ type ]) ) {
					// Search, expanding context for leading sibling combinators
					if ( (seed = find(
						token.matches[0].replace( runescape, funescape ),
						rsibling.test( tokens[0].type ) && testContext( context.parentNode ) || context
					)) ) {

						// If seed is empty or no tokens remain, we can return early
						tokens.splice( i, 1 );
						selector = seed.length && toSelector( tokens );
						if ( !selector ) {
							push.apply( results, seed );
							return results;
						}

						break;
					}
				}
			}
		}
	}

	// Compile and execute a filtering function
	// Provide `match` to avoid retokenization if we modified the selector above
	compile( selector, match )(
		seed,
		context,
		!documentIsHTML,
		results,
		rsibling.test( selector ) && testContext( context.parentNode ) || context
	);
	return results;
}

// One-time assignments

// Sort stability
support.sortStable = expando.split("").sort( sortOrder ).join("") === expando;

// Support: Chrome<14
// Always assume duplicates if they aren't passed to the comparison function
support.detectDuplicates = !!hasDuplicate;

// Initialize against the default document
setDocument();

// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
// Detached nodes confoundingly follow *each other*
support.sortDetached = assert(function( div1 ) {
	// Should return 1, but returns 4 (following)
	return div1.compareDocumentPosition( document.createElement("div") ) & 1;
});

// Support: IE<8
// Prevent attribute/property "interpolation"
// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
if ( !assert(function( div ) {
	div.innerHTML = "<a href='#'></a>";
	return div.firstChild.getAttribute("href") === "#" ;
}) ) {
	addHandle( "type|href|height|width", function( elem, name, isXML ) {
		if ( !isXML ) {
			return elem.getAttribute( name, name.toLowerCase() === "type" ? 1 : 2 );
		}
	});
}

// Support: IE<9
// Use defaultValue in place of getAttribute("value")
if ( !support.attributes || !assert(function( div ) {
	div.innerHTML = "<input/>";
	div.firstChild.setAttribute( "value", "" );
	return div.firstChild.getAttribute( "value" ) === "";
}) ) {
	addHandle( "value", function( elem, name, isXML ) {
		if ( !isXML && elem.nodeName.toLowerCase() === "input" ) {
			return elem.defaultValue;
		}
	});
}

// Support: IE<9
// Use getAttributeNode to fetch booleans when getAttribute lies
if ( !assert(function( div ) {
	return div.getAttribute("disabled") == null;
}) ) {
	addHandle( booleans, function( elem, name, isXML ) {
		var val;
		if ( !isXML ) {
			return elem[ name ] === true ? name.toLowerCase() :
					(val = elem.getAttributeNode( name )) && val.specified ?
					val.value :
				null;
		}
	});
}

return Sizzle;

})( window );



jQuery.find = Sizzle;
jQuery.expr = Sizzle.selectors;
jQuery.expr[":"] = jQuery.expr.pseudos;
jQuery.unique = Sizzle.uniqueSort;
jQuery.text = Sizzle.getText;
jQuery.isXMLDoc = Sizzle.isXML;
jQuery.contains = Sizzle.contains;



var rneedsContext = jQuery.expr.match.needsContext;

var rsingleTag = (/^<(\w+)\s*\/?>(?:<\/\1>|)$/);



var risSimple = /^.[^:#\[\.,]*$/;

// Implement the identical functionality for filter and not
function winnow( elements, qualifier, not ) {
	if ( jQuery.isFunction( qualifier ) ) {
		return jQuery.grep( elements, function( elem, i ) {
			/* jshint -W018 */
			return !!qualifier.call( elem, i, elem ) !== not;
		});

	}

	if ( qualifier.nodeType ) {
		return jQuery.grep( elements, function( elem ) {
			return ( elem === qualifier ) !== not;
		});

	}

	if ( typeof qualifier === "string" ) {
		if ( risSimple.test( qualifier ) ) {
			return jQuery.filter( qualifier, elements, not );
		}

		qualifier = jQuery.filter( qualifier, elements );
	}

	return jQuery.grep( elements, function( elem ) {
		return ( jQuery.inArray( elem, qualifier ) >= 0 ) !== not;
	});
}

jQuery.filter = function( expr, elems, not ) {
	var elem = elems[ 0 ];

	if ( not ) {
		expr = ":not(" + expr + ")";
	}

	return elems.length === 1 && elem.nodeType === 1 ?
		jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [] :
		jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {
			return elem.nodeType === 1;
		}));
};

jQuery.fn.extend({
	find: function( selector ) {
		var i,
			ret = [],
			self = this,
			len = self.length;

		if ( typeof selector !== "string" ) {
			return this.pushStack( jQuery( selector ).filter(function() {
				for ( i = 0; i < len; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			}) );
		}

		for ( i = 0; i < len; i++ ) {
			jQuery.find( selector, self[ i ], ret );
		}

		// Needed because $( selector, context ) becomes $( context ).find( selector )
		ret = this.pushStack( len > 1 ? jQuery.unique( ret ) : ret );
		ret.selector = this.selector ? this.selector + " " + selector : selector;
		return ret;
	},
	filter: function( selector ) {
		return this.pushStack( winnow(this, selector || [], false) );
	},
	not: function( selector ) {
		return this.pushStack( winnow(this, selector || [], true) );
	},
	is: function( selector ) {
		return !!winnow(
			this,

			// If this is a positional/relative selector, check membership in the returned set
			// so $("p:first").is("p:last") won't return true for a doc with two "p".
			typeof selector === "string" && rneedsContext.test( selector ) ?
				jQuery( selector ) :
				selector || [],
			false
		).length;
	}
});


// Initialize a jQuery object


// A central reference to the root jQuery(document)
var rootjQuery,

	// Use the correct document accordingly with window argument (sandbox)
	document = window.document,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	// Strict HTML recognition (#11290: must start with <)
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/,

	init = jQuery.fn.init = function( selector, context ) {
		var match, elem;

		// HANDLE: $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector.charAt(0) === "<" && selector.charAt( selector.length - 1 ) === ">" && selector.length >= 3 ) {
				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && (match[1] || !context) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[1] ) {
					context = context instanceof jQuery ? context[0] : context;

					// scripts is true for back-compat
					// Intentionally let the error be thrown if parseHTML is not present
					jQuery.merge( this, jQuery.parseHTML(
						match[1],
						context && context.nodeType ? context.ownerDocument || context : document,
						true
					) );

					// HANDLE: $(html, props)
					if ( rsingleTag.test( match[1] ) && jQuery.isPlainObject( context ) ) {
						for ( match in context ) {
							// Properties of context are called as methods if possible
							if ( jQuery.isFunction( this[ match ] ) ) {
								this[ match ]( context[ match ] );

							// ...and otherwise set as attributes
							} else {
								this.attr( match, context[ match ] );
							}
						}
					}

					return this;

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[2] );

					// Check parentNode to catch when Blackberry 4.6 returns
					// nodes that are no longer in the document #6963
					if ( elem && elem.parentNode ) {
						// Handle the case where IE and Opera return items
						// by name instead of ID
						if ( elem.id !== match[2] ) {
							return rootjQuery.find( selector );
						}

						// Otherwise, we inject the element directly into the jQuery object
						this.length = 1;
						this[0] = elem;
					}

					this.context = document;
					this.selector = selector;
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || rootjQuery ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(DOMElement)
		} else if ( selector.nodeType ) {
			this.context = this[0] = selector;
			this.length = 1;
			return this;

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( jQuery.isFunction( selector ) ) {
			return typeof rootjQuery.ready !== "undefined" ?
				rootjQuery.ready( selector ) :
				// Execute immediately if ready is not present
				selector( jQuery );
		}

		if ( selector.selector !== undefined ) {
			this.selector = selector.selector;
			this.context = selector.context;
		}

		return jQuery.makeArray( selector, this );
	};

// Give the init function the jQuery prototype for later instantiation
init.prototype = jQuery.fn;

// Initialize central reference
rootjQuery = jQuery( document );


var rparentsprev = /^(?:parents|prev(?:Until|All))/,
	// methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.extend({
	dir: function( elem, dir, until ) {
		var matched = [],
			cur = elem[ dir ];

		while ( cur && cur.nodeType !== 9 && (until === undefined || cur.nodeType !== 1 || !jQuery( cur ).is( until )) ) {
			if ( cur.nodeType === 1 ) {
				matched.push( cur );
			}
			cur = cur[dir];
		}
		return matched;
	},

	sibling: function( n, elem ) {
		var r = [];

		for ( ; n; n = n.nextSibling ) {
			if ( n.nodeType === 1 && n !== elem ) {
				r.push( n );
			}
		}

		return r;
	}
});

jQuery.fn.extend({
	has: function( target ) {
		var i,
			targets = jQuery( target, this ),
			len = targets.length;

		return this.filter(function() {
			for ( i = 0; i < len; i++ ) {
				if ( jQuery.contains( this, targets[i] ) ) {
					return true;
				}
			}
		});
	},

	closest: function( selectors, context ) {
		var cur,
			i = 0,
			l = this.length,
			matched = [],
			pos = rneedsContext.test( selectors ) || typeof selectors !== "string" ?
				jQuery( selectors, context || this.context ) :
				0;

		for ( ; i < l; i++ ) {
			for ( cur = this[i]; cur && cur !== context; cur = cur.parentNode ) {
				// Always skip document fragments
				if ( cur.nodeType < 11 && (pos ?
					pos.index(cur) > -1 :

					// Don't pass non-elements to Sizzle
					cur.nodeType === 1 &&
						jQuery.find.matchesSelector(cur, selectors)) ) {

					matched.push( cur );
					break;
				}
			}
		}

		return this.pushStack( matched.length > 1 ? jQuery.unique( matched ) : matched );
	},

	// Determine the position of an element within
	// the matched set of elements
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[0] && this[0].parentNode ) ? this.first().prevAll().length : -1;
		}

		// index in selector
		if ( typeof elem === "string" ) {
			return jQuery.inArray( this[0], jQuery( elem ) );
		}

		// Locate the position of the desired element
		return jQuery.inArray(
			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[0] : elem, this );
	},

	add: function( selector, context ) {
		return this.pushStack(
			jQuery.unique(
				jQuery.merge( this.get(), jQuery( selector, context ) )
			)
		);
	},

	addBack: function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter(selector)
		);
	}
});

function sibling( cur, dir ) {
	do {
		cur = cur[ dir ];
	} while ( cur && cur.nodeType !== 1 );

	return cur;
}

jQuery.each({
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return jQuery.dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, i, until ) {
		return jQuery.dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return sibling( elem, "nextSibling" );
	},
	prev: function( elem ) {
		return sibling( elem, "previousSibling" );
	},
	nextAll: function( elem ) {
		return jQuery.dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return jQuery.dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, i, until ) {
		return jQuery.dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, i, until ) {
		return jQuery.dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return jQuery.sibling( ( elem.parentNode || {} ).firstChild, elem );
	},
	children: function( elem ) {
		return jQuery.sibling( elem.firstChild );
	},
	contents: function( elem ) {
		return jQuery.nodeName( elem, "iframe" ) ?
			elem.contentDocument || elem.contentWindow.document :
			jQuery.merge( [], elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var ret = jQuery.map( this, fn, until );

		if ( name.slice( -5 ) !== "Until" ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			ret = jQuery.filter( selector, ret );
		}

		if ( this.length > 1 ) {
			// Remove duplicates
			if ( !guaranteedUnique[ name ] ) {
				ret = jQuery.unique( ret );
			}

			// Reverse order for parents* and prev-derivatives
			if ( rparentsprev.test( name ) ) {
				ret = ret.reverse();
			}
		}

		return this.pushStack( ret );
	};
});
var rnotwhite = (/\S+/g);



// String to Object options format cache
var optionsCache = {};

// Convert String-formatted options into Object-formatted ones and store in cache
function createOptions( options ) {
	var object = optionsCache[ options ] = {};
	jQuery.each( options.match( rnotwhite ) || [], function( _, flag ) {
		object[ flag ] = true;
	});
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		( optionsCache[ options ] || createOptions( options ) ) :
		jQuery.extend( {}, options );

	var // Flag to know if list is currently firing
		firing,
		// Last fire value (for non-forgettable lists)
		memory,
		// Flag to know if list was already fired
		fired,
		// End of the loop when firing
		firingLength,
		// Index of currently firing callback (modified by remove if needed)
		firingIndex,
		// First callback to fire (used internally by add and fireWith)
		firingStart,
		// Actual callback list
		list = [],
		// Stack of fire calls for repeatable lists
		stack = !options.once && [],
		// Fire callbacks
		fire = function( data ) {
			memory = options.memory && data;
			fired = true;
			firingIndex = firingStart || 0;
			firingStart = 0;
			firingLength = list.length;
			firing = true;
			for ( ; list && firingIndex < firingLength; firingIndex++ ) {
				if ( list[ firingIndex ].apply( data[ 0 ], data[ 1 ] ) === false && options.stopOnFalse ) {
					memory = false; // To prevent further calls using add
					break;
				}
			}
			firing = false;
			if ( list ) {
				if ( stack ) {
					if ( stack.length ) {
						fire( stack.shift() );
					}
				} else if ( memory ) {
					list = [];
				} else {
					self.disable();
				}
			}
		},
		// Actual Callbacks object
		self = {
			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {
					// First, we save the current length
					var start = list.length;
					(function add( args ) {
						jQuery.each( args, function( _, arg ) {
							var type = jQuery.type( arg );
							if ( type === "function" ) {
								if ( !options.unique || !self.has( arg ) ) {
									list.push( arg );
								}
							} else if ( arg && arg.length && type !== "string" ) {
								// Inspect recursively
								add( arg );
							}
						});
					})( arguments );
					// Do we need to add the callbacks to the
					// current firing batch?
					if ( firing ) {
						firingLength = list.length;
					// With memory, if we're not firing then
					// we should call right away
					} else if ( memory ) {
						firingStart = start;
						fire( memory );
					}
				}
				return this;
			},
			// Remove a callback from the list
			remove: function() {
				if ( list ) {
					jQuery.each( arguments, function( _, arg ) {
						var index;
						while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
							list.splice( index, 1 );
							// Handle firing indexes
							if ( firing ) {
								if ( index <= firingLength ) {
									firingLength--;
								}
								if ( index <= firingIndex ) {
									firingIndex--;
								}
							}
						}
					});
				}
				return this;
			},
			// Check if a given callback is in the list.
			// If no argument is given, return whether or not list has callbacks attached.
			has: function( fn ) {
				return fn ? jQuery.inArray( fn, list ) > -1 : !!( list && list.length );
			},
			// Remove all callbacks from the list
			empty: function() {
				list = [];
				firingLength = 0;
				return this;
			},
			// Have the list do nothing anymore
			disable: function() {
				list = stack = memory = undefined;
				return this;
			},
			// Is it disabled?
			disabled: function() {
				return !list;
			},
			// Lock the list in its current state
			lock: function() {
				stack = undefined;
				if ( !memory ) {
					self.disable();
				}
				return this;
			},
			// Is it locked?
			locked: function() {
				return !stack;
			},
			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				if ( list && ( !fired || stack ) ) {
					args = args || [];
					args = [ context, args.slice ? args.slice() : args ];
					if ( firing ) {
						stack.push( args );
					} else {
						fire( args );
					}
				}
				return this;
			},
			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},
			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};


jQuery.extend({

	Deferred: function( func ) {
		var tuples = [
				// action, add listener, listener list, final state
				[ "resolve", "done", jQuery.Callbacks("once memory"), "resolved" ],
				[ "reject", "fail", jQuery.Callbacks("once memory"), "rejected" ],
				[ "notify", "progress", jQuery.Callbacks("memory") ]
			],
			state = "pending",
			promise = {
				state: function() {
					return state;
				},
				always: function() {
					deferred.done( arguments ).fail( arguments );
					return this;
				},
				then: function( /* fnDone, fnFail, fnProgress */ ) {
					var fns = arguments;
					return jQuery.Deferred(function( newDefer ) {
						jQuery.each( tuples, function( i, tuple ) {
							var fn = jQuery.isFunction( fns[ i ] ) && fns[ i ];
							// deferred[ done | fail | progress ] for forwarding actions to newDefer
							deferred[ tuple[1] ](function() {
								var returned = fn && fn.apply( this, arguments );
								if ( returned && jQuery.isFunction( returned.promise ) ) {
									returned.promise()
										.done( newDefer.resolve )
										.fail( newDefer.reject )
										.progress( newDefer.notify );
								} else {
									newDefer[ tuple[ 0 ] + "With" ]( this === promise ? newDefer.promise() : this, fn ? [ returned ] : arguments );
								}
							});
						});
						fns = null;
					}).promise();
				},
				// Get a promise for this deferred
				// If obj is provided, the promise aspect is added to the object
				promise: function( obj ) {
					return obj != null ? jQuery.extend( obj, promise ) : promise;
				}
			},
			deferred = {};

		// Keep pipe for back-compat
		promise.pipe = promise.then;

		// Add list-specific methods
		jQuery.each( tuples, function( i, tuple ) {
			var list = tuple[ 2 ],
				stateString = tuple[ 3 ];

			// promise[ done | fail | progress ] = list.add
			promise[ tuple[1] ] = list.add;

			// Handle state
			if ( stateString ) {
				list.add(function() {
					// state = [ resolved | rejected ]
					state = stateString;

				// [ reject_list | resolve_list ].disable; progress_list.lock
				}, tuples[ i ^ 1 ][ 2 ].disable, tuples[ 2 ][ 2 ].lock );
			}

			// deferred[ resolve | reject | notify ]
			deferred[ tuple[0] ] = function() {
				deferred[ tuple[0] + "With" ]( this === deferred ? promise : this, arguments );
				return this;
			};
			deferred[ tuple[0] + "With" ] = list.fireWith;
		});

		// Make the deferred a promise
		promise.promise( deferred );

		// Call given func if any
		if ( func ) {
			func.call( deferred, deferred );
		}

		// All done!
		return deferred;
	},

	// Deferred helper
	when: function( subordinate /* , ..., subordinateN */ ) {
		var i = 0,
			resolveValues = slice.call( arguments ),
			length = resolveValues.length,

			// the count of uncompleted subordinates
			remaining = length !== 1 || ( subordinate && jQuery.isFunction( subordinate.promise ) ) ? length : 0,

			// the master Deferred. If resolveValues consist of only a single Deferred, just use that.
			deferred = remaining === 1 ? subordinate : jQuery.Deferred(),

			// Update function for both resolve and progress values
			updateFunc = function( i, contexts, values ) {
				return function( value ) {
					contexts[ i ] = this;
					values[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;
					if ( values === progressValues ) {
						deferred.notifyWith( contexts, values );

					} else if ( !(--remaining) ) {
						deferred.resolveWith( contexts, values );
					}
				};
			},

			progressValues, progressContexts, resolveContexts;

		// add listeners to Deferred subordinates; treat others as resolved
		if ( length > 1 ) {
			progressValues = new Array( length );
			progressContexts = new Array( length );
			resolveContexts = new Array( length );
			for ( ; i < length; i++ ) {
				if ( resolveValues[ i ] && jQuery.isFunction( resolveValues[ i ].promise ) ) {
					resolveValues[ i ].promise()
						.done( updateFunc( i, resolveContexts, resolveValues ) )
						.fail( deferred.reject )
						.progress( updateFunc( i, progressContexts, progressValues ) );
				} else {
					--remaining;
				}
			}
		}

		// if we're not waiting on anything, resolve the master
		if ( !remaining ) {
			deferred.resolveWith( resolveContexts, resolveValues );
		}

		return deferred.promise();
	}
});


// The deferred used on DOM ready
var readyList;

jQuery.fn.ready = function( fn ) {
	// Add the callback
	jQuery.ready.promise().done( fn );

	return this;
};

jQuery.extend({
	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See #6781
	readyWait: 1,

	// Hold (or release) the ready event
	holdReady: function( hold ) {
		if ( hold ) {
			jQuery.readyWait++;
		} else {
			jQuery.ready( true );
		}
	},

	// Handle when the DOM is ready
	ready: function( wait ) {

		// Abort if there are pending holds or we're already ready
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
			return;
		}

		// Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).
		if ( !document.body ) {
			return setTimeout( jQuery.ready );
		}

		// Remember that the DOM is ready
		jQuery.isReady = true;

		// If a normal DOM Ready event fired, decrement, and wait if need be
		if ( wait !== true && --jQuery.readyWait > 0 ) {
			return;
		}

		// If there are functions bound, to execute
		readyList.resolveWith( document, [ jQuery ] );

		// Trigger any bound ready events
		if ( jQuery.fn.trigger ) {
			jQuery( document ).trigger("ready").off("ready");
		}
	}
});

/**
 * Clean-up method for dom ready events
 */
function detach() {
	if ( document.addEventListener ) {
		document.removeEventListener( "DOMContentLoaded", completed, false );
		window.removeEventListener( "load", completed, false );

	} else {
		document.detachEvent( "onreadystatechange", completed );
		window.detachEvent( "onload", completed );
	}
}

/**
 * The ready event handler and self cleanup method
 */
function completed() {
	// readyState === "complete" is good enough for us to call the dom ready in oldIE
	if ( document.addEventListener || event.type === "load" || document.readyState === "complete" ) {
		detach();
		jQuery.ready();
	}
}

jQuery.ready.promise = function( obj ) {
	if ( !readyList ) {

		readyList = jQuery.Deferred();

		// Catch cases where $(document).ready() is called after the browser event has already occurred.
		// we once tried to use readyState "interactive" here, but it caused issues like the one
		// discovered by ChrisS here: http://bugs.jquery.com/ticket/12282#comment:15
		if ( document.readyState === "complete" ) {
			// Handle it asynchronously to allow scripts the opportunity to delay ready
			setTimeout( jQuery.ready );

		// Standards-based browsers support DOMContentLoaded
		} else if ( document.addEventListener ) {
			// Use the handy event callback
			document.addEventListener( "DOMContentLoaded", completed, false );

			// A fallback to window.onload, that will always work
			window.addEventListener( "load", completed, false );

		// If IE event model is used
		} else {
			// Ensure firing before onload, maybe late but safe also for iframes
			document.attachEvent( "onreadystatechange", completed );

			// A fallback to window.onload, that will always work
			window.attachEvent( "onload", completed );

			// If IE and not a frame
			// continually check to see if the document is ready
			var top = false;

			try {
				top = window.frameElement == null && document.documentElement;
			} catch(e) {}

			if ( top && top.doScroll ) {
				(function doScrollCheck() {
					if ( !jQuery.isReady ) {

						try {
							// Use the trick by Diego Perini
							// http://javascript.nwbox.com/IEContentLoaded/
							top.doScroll("left");
						} catch(e) {
							return setTimeout( doScrollCheck, 50 );
						}

						// detach all dom ready events
						detach();

						// and execute any waiting functions
						jQuery.ready();
					}
				})();
			}
		}
	}
	return readyList.promise( obj );
};


var strundefined = typeof undefined;



// Support: IE<9
// Iteration over object's inherited properties before its own
var i;
for ( i in jQuery( support ) ) {
	break;
}
support.ownLast = i !== "0";

// Note: most support tests are defined in their respective modules.
// false until the test is run
support.inlineBlockNeedsLayout = false;

jQuery(function() {
	// We need to execute this one support test ASAP because we need to know
	// if body.style.zoom needs to be set.

	var container, div,
		body = document.getElementsByTagName("body")[0];

	if ( !body ) {
		// Return for frameset docs that don't have a body
		return;
	}

	// Setup
	container = document.createElement( "div" );
	container.style.cssText = "border:0;width:0;height:0;position:absolute;top:0;left:-9999px;margin-top:1px";

	div = document.createElement( "div" );
	body.appendChild( container ).appendChild( div );

	if ( typeof div.style.zoom !== strundefined ) {
		// Support: IE<8
		// Check if natively block-level elements act like inline-block
		// elements when setting their display to 'inline' and giving
		// them layout
		div.style.cssText = "border:0;margin:0;width:1px;padding:1px;display:inline;zoom:1";

		if ( (support.inlineBlockNeedsLayout = ( div.offsetWidth === 3 )) ) {
			// Prevent IE 6 from affecting layout for positioned elements #11048
			// Prevent IE from shrinking the body in IE 7 mode #12869
			// Support: IE<8
			body.style.zoom = 1;
		}
	}

	body.removeChild( container );

	// Null elements to avoid leaks in IE
	container = div = null;
});




(function() {
	var div = document.createElement( "div" );

	// Execute the test only if not already executed in another module.
	if (support.deleteExpando == null) {
		// Support: IE<9
		support.deleteExpando = true;
		try {
			delete div.test;
		} catch( e ) {
			support.deleteExpando = false;
		}
	}

	// Null elements to avoid leaks in IE.
	div = null;
})();


/**
 * Determines whether an object can have data
 */
jQuery.acceptData = function( elem ) {
	var noData = jQuery.noData[ (elem.nodeName + " ").toLowerCase() ],
		nodeType = +elem.nodeType || 1;

	// Do not set data on non-element DOM nodes because it will not be cleared (#8335).
	return nodeType !== 1 && nodeType !== 9 ?
		false :

		// Nodes accept data unless otherwise specified; rejection can be conditional
		!noData || noData !== true && elem.getAttribute("classid") === noData;
};


var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
	rmultiDash = /([A-Z])/g;

function dataAttr( elem, key, data ) {
	// If nothing was found internally, try to fetch any
	// data from the HTML5 data-* attribute
	if ( data === undefined && elem.nodeType === 1 ) {

		var name = "data-" + key.replace( rmultiDash, "-$1" ).toLowerCase();

		data = elem.getAttribute( name );

		if ( typeof data === "string" ) {
			try {
				data = data === "true" ? true :
					data === "false" ? false :
					data === "null" ? null :
					// Only convert to a number if it doesn't change the string
					+data + "" === data ? +data :
					rbrace.test( data ) ? jQuery.parseJSON( data ) :
					data;
			} catch( e ) {}

			// Make sure we set the data so it isn't changed later
			jQuery.data( elem, key, data );

		} else {
			data = undefined;
		}
	}

	return data;
}

// checks a cache object for emptiness
function isEmptyDataObject( obj ) {
	var name;
	for ( name in obj ) {

		// if the public data object is empty, the private is still empty
		if ( name === "data" && jQuery.isEmptyObject( obj[name] ) ) {
			continue;
		}
		if ( name !== "toJSON" ) {
			return false;
		}
	}

	return true;
}

function internalData( elem, name, data, pvt /* Internal Use Only */ ) {
	if ( !jQuery.acceptData( elem ) ) {
		return;
	}

	var ret, thisCache,
		internalKey = jQuery.expando,

		// We have to handle DOM nodes and JS objects differently because IE6-7
		// can't GC object references properly across the DOM-JS boundary
		isNode = elem.nodeType,

		// Only DOM nodes need the global jQuery cache; JS object data is
		// attached directly to the object so GC can occur automatically
		cache = isNode ? jQuery.cache : elem,

		// Only defining an ID for JS objects if its cache already exists allows
		// the code to shortcut on the same path as a DOM node with no cache
		id = isNode ? elem[ internalKey ] : elem[ internalKey ] && internalKey;

	// Avoid doing any more work than we need to when trying to get data on an
	// object that has no data at all
	if ( (!id || !cache[id] || (!pvt && !cache[id].data)) && data === undefined && typeof name === "string" ) {
		return;
	}

	if ( !id ) {
		// Only DOM nodes need a new unique ID for each element since their data
		// ends up in the global cache
		if ( isNode ) {
			id = elem[ internalKey ] = deletedIds.pop() || jQuery.guid++;
		} else {
			id = internalKey;
		}
	}

	if ( !cache[ id ] ) {
		// Avoid exposing jQuery metadata on plain JS objects when the object
		// is serialized using JSON.stringify
		cache[ id ] = isNode ? {} : { toJSON: jQuery.noop };
	}

	// An object can be passed to jQuery.data instead of a key/value pair; this gets
	// shallow copied over onto the existing cache
	if ( typeof name === "object" || typeof name === "function" ) {
		if ( pvt ) {
			cache[ id ] = jQuery.extend( cache[ id ], name );
		} else {
			cache[ id ].data = jQuery.extend( cache[ id ].data, name );
		}
	}

	thisCache = cache[ id ];

	// jQuery data() is stored in a separate object inside the object's internal data
	// cache in order to avoid key collisions between internal data and user-defined
	// data.
	if ( !pvt ) {
		if ( !thisCache.data ) {
			thisCache.data = {};
		}

		thisCache = thisCache.data;
	}

	if ( data !== undefined ) {
		thisCache[ jQuery.camelCase( name ) ] = data;
	}

	// Check for both converted-to-camel and non-converted data property names
	// If a data property was specified
	if ( typeof name === "string" ) {

		// First Try to find as-is property data
		ret = thisCache[ name ];

		// Test for null|undefined property data
		if ( ret == null ) {

			// Try to find the camelCased property
			ret = thisCache[ jQuery.camelCase( name ) ];
		}
	} else {
		ret = thisCache;
	}

	return ret;
}

function internalRemoveData( elem, name, pvt ) {
	if ( !jQuery.acceptData( elem ) ) {
		return;
	}

	var thisCache, i,
		isNode = elem.nodeType,

		// See jQuery.data for more information
		cache = isNode ? jQuery.cache : elem,
		id = isNode ? elem[ jQuery.expando ] : jQuery.expando;

	// If there is already no cache entry for this object, there is no
	// purpose in continuing
	if ( !cache[ id ] ) {
		return;
	}

	if ( name ) {

		thisCache = pvt ? cache[ id ] : cache[ id ].data;

		if ( thisCache ) {

			// Support array or space separated string names for data keys
			if ( !jQuery.isArray( name ) ) {

				// try the string as a key before any manipulation
				if ( name in thisCache ) {
					name = [ name ];
				} else {

					// split the camel cased version by spaces unless a key with the spaces exists
					name = jQuery.camelCase( name );
					if ( name in thisCache ) {
						name = [ name ];
					} else {
						name = name.split(" ");
					}
				}
			} else {
				// If "name" is an array of keys...
				// When data is initially created, via ("key", "val") signature,
				// keys will be converted to camelCase.
				// Since there is no way to tell _how_ a key was added, remove
				// both plain key and camelCase key. #12786
				// This will only penalize the array argument path.
				name = name.concat( jQuery.map( name, jQuery.camelCase ) );
			}

			i = name.length;
			while ( i-- ) {
				delete thisCache[ name[i] ];
			}

			// If there is no data left in the cache, we want to continue
			// and let the cache object itself get destroyed
			if ( pvt ? !isEmptyDataObject(thisCache) : !jQuery.isEmptyObject(thisCache) ) {
				return;
			}
		}
	}

	// See jQuery.data for more information
	if ( !pvt ) {
		delete cache[ id ].data;

		// Don't destroy the parent cache unless the internal data object
		// had been the only thing left in it
		if ( !isEmptyDataObject( cache[ id ] ) ) {
			return;
		}
	}

	// Destroy the cache
	if ( isNode ) {
		jQuery.cleanData( [ elem ], true );

	// Use delete when supported for expandos or `cache` is not a window per isWindow (#10080)
	/* jshint eqeqeq: false */
	} else if ( support.deleteExpando || cache != cache.window ) {
		/* jshint eqeqeq: true */
		delete cache[ id ];

	// When all else fails, null
	} else {
		cache[ id ] = null;
	}
}

jQuery.extend({
	cache: {},

	// The following elements (space-suffixed to avoid Object.prototype collisions)
	// throw uncatchable exceptions if you attempt to set expando properties
	noData: {
		"applet ": true,
		"embed ": true,
		// ...but Flash objects (which have this classid) *can* handle expandos
		"object ": "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"
	},

	hasData: function( elem ) {
		elem = elem.nodeType ? jQuery.cache[ elem[jQuery.expando] ] : elem[ jQuery.expando ];
		return !!elem && !isEmptyDataObject( elem );
	},

	data: function( elem, name, data ) {
		return internalData( elem, name, data );
	},

	removeData: function( elem, name ) {
		return internalRemoveData( elem, name );
	},

	// For internal use only.
	_data: function( elem, name, data ) {
		return internalData( elem, name, data, true );
	},

	_removeData: function( elem, name ) {
		return internalRemoveData( elem, name, true );
	}
});

jQuery.fn.extend({
	data: function( key, value ) {
		var i, name, data,
			elem = this[0],
			attrs = elem && elem.attributes;

		// Special expections of .data basically thwart jQuery.access,
		// so implement the relevant behavior ourselves

		// Gets all values
		if ( key === undefined ) {
			if ( this.length ) {
				data = jQuery.data( elem );

				if ( elem.nodeType === 1 && !jQuery._data( elem, "parsedAttrs" ) ) {
					i = attrs.length;
					while ( i-- ) {
						name = attrs[i].name;

						if ( name.indexOf("data-") === 0 ) {
							name = jQuery.camelCase( name.slice(5) );

							dataAttr( elem, name, data[ name ] );
						}
					}
					jQuery._data( elem, "parsedAttrs", true );
				}
			}

			return data;
		}

		// Sets multiple values
		if ( typeof key === "object" ) {
			return this.each(function() {
				jQuery.data( this, key );
			});
		}

		return arguments.length > 1 ?

			// Sets one value
			this.each(function() {
				jQuery.data( this, key, value );
			}) :

			// Gets one value
			// Try to fetch any internally stored data first
			elem ? dataAttr( elem, key, jQuery.data( elem, key ) ) : undefined;
	},

	removeData: function( key ) {
		return this.each(function() {
			jQuery.removeData( this, key );
		});
	}
});


jQuery.extend({
	queue: function( elem, type, data ) {
		var queue;

		if ( elem ) {
			type = ( type || "fx" ) + "queue";
			queue = jQuery._data( elem, type );

			// Speed up dequeue by getting out quickly if this is just a lookup
			if ( data ) {
				if ( !queue || jQuery.isArray(data) ) {
					queue = jQuery._data( elem, type, jQuery.makeArray(data) );
				} else {
					queue.push( data );
				}
			}
			return queue || [];
		}
	},

	dequeue: function( elem, type ) {
		type = type || "fx";

		var queue = jQuery.queue( elem, type ),
			startLength = queue.length,
			fn = queue.shift(),
			hooks = jQuery._queueHooks( elem, type ),
			next = function() {
				jQuery.dequeue( elem, type );
			};

		// If the fx queue is dequeued, always remove the progress sentinel
		if ( fn === "inprogress" ) {
			fn = queue.shift();
			startLength--;
		}

		if ( fn ) {

			// Add a progress sentinel to prevent the fx queue from being
			// automatically dequeued
			if ( type === "fx" ) {
				queue.unshift( "inprogress" );
			}

			// clear up the last queue stop function
			delete hooks.stop;
			fn.call( elem, next, hooks );
		}

		if ( !startLength && hooks ) {
			hooks.empty.fire();
		}
	},

	// not intended for public consumption - generates a queueHooks object, or returns the current one
	_queueHooks: function( elem, type ) {
		var key = type + "queueHooks";
		return jQuery._data( elem, key ) || jQuery._data( elem, key, {
			empty: jQuery.Callbacks("once memory").add(function() {
				jQuery._removeData( elem, type + "queue" );
				jQuery._removeData( elem, key );
			})
		});
	}
});

jQuery.fn.extend({
	queue: function( type, data ) {
		var setter = 2;

		if ( typeof type !== "string" ) {
			data = type;
			type = "fx";
			setter--;
		}

		if ( arguments.length < setter ) {
			return jQuery.queue( this[0], type );
		}

		return data === undefined ?
			this :
			this.each(function() {
				var queue = jQuery.queue( this, type, data );

				// ensure a hooks for this queue
				jQuery._queueHooks( this, type );

				if ( type === "fx" && queue[0] !== "inprogress" ) {
					jQuery.dequeue( this, type );
				}
			});
	},
	dequeue: function( type ) {
		return this.each(function() {
			jQuery.dequeue( this, type );
		});
	},
	clearQueue: function( type ) {
		return this.queue( type || "fx", [] );
	},
	// Get a promise resolved when queues of a certain type
	// are emptied (fx is the type by default)
	promise: function( type, obj ) {
		var tmp,
			count = 1,
			defer = jQuery.Deferred(),
			elements = this,
			i = this.length,
			resolve = function() {
				if ( !( --count ) ) {
					defer.resolveWith( elements, [ elements ] );
				}
			};

		if ( typeof type !== "string" ) {
			obj = type;
			type = undefined;
		}
		type = type || "fx";

		while ( i-- ) {
			tmp = jQuery._data( elements[ i ], type + "queueHooks" );
			if ( tmp && tmp.empty ) {
				count++;
				tmp.empty.add( resolve );
			}
		}
		resolve();
		return defer.promise( obj );
	}
});
var pnum = (/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/).source;

var cssExpand = [ "Top", "Right", "Bottom", "Left" ];

var isHidden = function( elem, el ) {
		// isHidden might be called from jQuery#filter function;
		// in that case, element will be second argument
		elem = el || elem;
		return jQuery.css( elem, "display" ) === "none" || !jQuery.contains( elem.ownerDocument, elem );
	};



// Multifunctional method to get and set values of a collection
// The value/s can optionally be executed if it's a function
var access = jQuery.access = function( elems, fn, key, value, chainable, emptyGet, raw ) {
	var i = 0,
		length = elems.length,
		bulk = key == null;

	// Sets many values
	if ( jQuery.type( key ) === "object" ) {
		chainable = true;
		for ( i in key ) {
			jQuery.access( elems, fn, i, key[i], true, emptyGet, raw );
		}

	// Sets one value
	} else if ( value !== undefined ) {
		chainable = true;

		if ( !jQuery.isFunction( value ) ) {
			raw = true;
		}

		if ( bulk ) {
			// Bulk operations run against the entire set
			if ( raw ) {
				fn.call( elems, value );
				fn = null;

			// ...except when executing function values
			} else {
				bulk = fn;
				fn = function( elem, key, value ) {
					return bulk.call( jQuery( elem ), value );
				};
			}
		}

		if ( fn ) {
			for ( ; i < length; i++ ) {
				fn( elems[i], key, raw ? value : value.call( elems[i], i, fn( elems[i], key ) ) );
			}
		}
	}

	return chainable ?
		elems :

		// Gets
		bulk ?
			fn.call( elems ) :
			length ? fn( elems[0], key ) : emptyGet;
};
var rcheckableType = (/^(?:checkbox|radio)$/i);



(function() {
	var fragment = document.createDocumentFragment(),
		div = document.createElement("div"),
		input = document.createElement("input");

	// Setup
	div.setAttribute( "className", "t" );
	div.innerHTML = "  <link/><table></table><a href='/a'>a</a>";

	// IE strips leading whitespace when .innerHTML is used
	support.leadingWhitespace = div.firstChild.nodeType === 3;

	// Make sure that tbody elements aren't automatically inserted
	// IE will insert them into empty tables
	support.tbody = !div.getElementsByTagName( "tbody" ).length;

	// Make sure that link elements get serialized correctly by innerHTML
	// This requires a wrapper element in IE
	support.htmlSerialize = !!div.getElementsByTagName( "link" ).length;

	// Makes sure cloning an html5 element does not cause problems
	// Where outerHTML is undefined, this still works
	support.html5Clone =
		document.createElement( "nav" ).cloneNode( true ).outerHTML !== "<:nav></:nav>";

	// Check if a disconnected checkbox will retain its checked
	// value of true after appended to the DOM (IE6/7)
	input.type = "checkbox";
	input.checked = true;
	fragment.appendChild( input );
	support.appendChecked = input.checked;

	// Make sure textarea (and checkbox) defaultValue is properly cloned
	// Support: IE6-IE11+
	div.innerHTML = "<textarea>x</textarea>";
	support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;

	// #11217 - WebKit loses check when the name is after the checked attribute
	fragment.appendChild( div );
	div.innerHTML = "<input type='radio' checked='checked' name='t'/>";

	// Support: Safari 5.1, iOS 5.1, Android 4.x, Android 2.3
	// old WebKit doesn't clone checked state correctly in fragments
	support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;

	// Support: IE<9
	// Opera does not clone events (and typeof div.attachEvent === undefined).
	// IE9-10 clones events bound via attachEvent, but they don't trigger with .click()
	support.noCloneEvent = true;
	if ( div.attachEvent ) {
		div.attachEvent( "onclick", function() {
			support.noCloneEvent = false;
		});

		div.cloneNode( true ).click();
	}

	// Execute the test only if not already executed in another module.
	if (support.deleteExpando == null) {
		// Support: IE<9
		support.deleteExpando = true;
		try {
			delete div.test;
		} catch( e ) {
			support.deleteExpando = false;
		}
	}

	// Null elements to avoid leaks in IE.
	fragment = div = input = null;
})();


(function() {
	var i, eventName,
		div = document.createElement( "div" );

	// Support: IE<9 (lack submit/change bubble), Firefox 23+ (lack focusin event)
	for ( i in { submit: true, change: true, focusin: true }) {
		eventName = "on" + i;

		if ( !(support[ i + "Bubbles" ] = eventName in window) ) {
			// Beware of CSP restrictions (https://developer.mozilla.org/en/Security/CSP)
			div.setAttribute( eventName, "t" );
			support[ i + "Bubbles" ] = div.attributes[ eventName ].expando === false;
		}
	}

	// Null elements to avoid leaks in IE.
	div = null;
})();


var rformElems = /^(?:input|select|textarea)$/i,
	rkeyEvent = /^key/,
	rmouseEvent = /^(?:mouse|contextmenu)|click/,
	rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
	rtypenamespace = /^([^.]*)(?:\.(.+)|)$/;

function returnTrue() {
	return true;
}

function returnFalse() {
	return false;
}

function safeActiveElement() {
	try {
		return document.activeElement;
	} catch ( err ) { }
}

/*
 * Helper functions for managing events -- not part of the public interface.
 * Props to Dean Edwards' addEvent library for many of the ideas.
 */
jQuery.event = {

	global: {},

	add: function( elem, types, handler, data, selector ) {
		var tmp, events, t, handleObjIn,
			special, eventHandle, handleObj,
			handlers, type, namespaces, origType,
			elemData = jQuery._data( elem );

		// Don't attach events to noData or text/comment nodes (but allow plain objects)
		if ( !elemData ) {
			return;
		}

		// Caller can pass in an object of custom data in lieu of the handler
		if ( handler.handler ) {
			handleObjIn = handler;
			handler = handleObjIn.handler;
			selector = handleObjIn.selector;
		}

		// Make sure that the handler has a unique ID, used to find/remove it later
		if ( !handler.guid ) {
			handler.guid = jQuery.guid++;
		}

		// Init the element's event structure and main handler, if this is the first
		if ( !(events = elemData.events) ) {
			events = elemData.events = {};
		}
		if ( !(eventHandle = elemData.handle) ) {
			eventHandle = elemData.handle = function( e ) {
				// Discard the second event of a jQuery.event.trigger() and
				// when an event is called after a page has unloaded
				return typeof jQuery !== strundefined && (!e || jQuery.event.triggered !== e.type) ?
					jQuery.event.dispatch.apply( eventHandle.elem, arguments ) :
					undefined;
			};
			// Add elem as a property of the handle fn to prevent a memory leak with IE non-native events
			eventHandle.elem = elem;
		}

		// Handle multiple events separated by a space
		types = ( types || "" ).match( rnotwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[t] ) || [];
			type = origType = tmp[1];
			namespaces = ( tmp[2] || "" ).split( "." ).sort();

			// There *must* be a type, no attaching namespace-only handlers
			if ( !type ) {
				continue;
			}

			// If event changes its type, use the special event handlers for the changed type
			special = jQuery.event.special[ type ] || {};

			// If selector defined, determine special event api type, otherwise given type
			type = ( selector ? special.delegateType : special.bindType ) || type;

			// Update special based on newly reset type
			special = jQuery.event.special[ type ] || {};

			// handleObj is passed to all event handlers
			handleObj = jQuery.extend({
				type: type,
				origType: origType,
				data: data,
				handler: handler,
				guid: handler.guid,
				selector: selector,
				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
				namespace: namespaces.join(".")
			}, handleObjIn );

			// Init the event handler queue if we're the first
			if ( !(handlers = events[ type ]) ) {
				handlers = events[ type ] = [];
				handlers.delegateCount = 0;

				// Only use addEventListener/attachEvent if the special events handler returns false
				if ( !special.setup || special.setup.call( elem, data, namespaces, eventHandle ) === false ) {
					// Bind the global event handler to the element
					if ( elem.addEventListener ) {
						elem.addEventListener( type, eventHandle, false );

					} else if ( elem.attachEvent ) {
						elem.attachEvent( "on" + type, eventHandle );
					}
				}
			}

			if ( special.add ) {
				special.add.call( elem, handleObj );

				if ( !handleObj.handler.guid ) {
					handleObj.handler.guid = handler.guid;
				}
			}

			// Add to the element's handler list, delegates in front
			if ( selector ) {
				handlers.splice( handlers.delegateCount++, 0, handleObj );
			} else {
				handlers.push( handleObj );
			}

			// Keep track of which events have ever been used, for event optimization
			jQuery.event.global[ type ] = true;
		}

		// Nullify elem to prevent memory leaks in IE
		elem = null;
	},

	// Detach an event or set of events from an element
	remove: function( elem, types, handler, selector, mappedTypes ) {
		var j, handleObj, tmp,
			origCount, t, events,
			special, handlers, type,
			namespaces, origType,
			elemData = jQuery.hasData( elem ) && jQuery._data( elem );

		if ( !elemData || !(events = elemData.events) ) {
			return;
		}

		// Once for each type.namespace in types; type may be omitted
		types = ( types || "" ).match( rnotwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[t] ) || [];
			type = origType = tmp[1];
			namespaces = ( tmp[2] || "" ).split( "." ).sort();

			// Unbind all events (on this namespace, if provided) for the element
			if ( !type ) {
				for ( type in events ) {
					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
				}
				continue;
			}

			special = jQuery.event.special[ type ] || {};
			type = ( selector ? special.delegateType : special.bindType ) || type;
			handlers = events[ type ] || [];
			tmp = tmp[2] && new RegExp( "(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)" );

			// Remove matching events
			origCount = j = handlers.length;
			while ( j-- ) {
				handleObj = handlers[ j ];

				if ( ( mappedTypes || origType === handleObj.origType ) &&
					( !handler || handler.guid === handleObj.guid ) &&
					( !tmp || tmp.test( handleObj.namespace ) ) &&
					( !selector || selector === handleObj.selector || selector === "**" && handleObj.selector ) ) {
					handlers.splice( j, 1 );

					if ( handleObj.selector ) {
						handlers.delegateCount--;
					}
					if ( special.remove ) {
						special.remove.call( elem, handleObj );
					}
				}
			}

			// Remove generic event handler if we removed something and no more handlers exist
			// (avoids potential for endless recursion during removal of special event handlers)
			if ( origCount && !handlers.length ) {
				if ( !special.teardown || special.teardown.call( elem, namespaces, elemData.handle ) === false ) {
					jQuery.removeEvent( elem, type, elemData.handle );
				}

				delete events[ type ];
			}
		}

		// Remove the expando if it's no longer used
		if ( jQuery.isEmptyObject( events ) ) {
			delete elemData.handle;

			// removeData also checks for emptiness and clears the expando if empty
			// so use it instead of delete
			jQuery._removeData( elem, "events" );
		}
	},

	trigger: function( event, data, elem, onlyHandlers ) {
		var handle, ontype, cur,
			bubbleType, special, tmp, i,
			eventPath = [ elem || document ],
			type = hasOwn.call( event, "type" ) ? event.type : event,
			namespaces = hasOwn.call( event, "namespace" ) ? event.namespace.split(".") : [];

		cur = tmp = elem = elem || document;

		// Don't do events on text and comment nodes
		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
			return;
		}

		// focus/blur morphs to focusin/out; ensure we're not firing them right now
		if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {
			return;
		}

		if ( type.indexOf(".") >= 0 ) {
			// Namespaced trigger; create a regexp to match event type in handle()
			namespaces = type.split(".");
			type = namespaces.shift();
			namespaces.sort();
		}
		ontype = type.indexOf(":") < 0 && "on" + type;

		// Caller can pass in a jQuery.Event object, Object, or just an event type string
		event = event[ jQuery.expando ] ?
			event :
			new jQuery.Event( type, typeof event === "object" && event );

		// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
		event.isTrigger = onlyHandlers ? 2 : 3;
		event.namespace = namespaces.join(".");
		event.namespace_re = event.namespace ?
			new RegExp( "(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)" ) :
			null;

		// Clean up the event in case it is being reused
		event.result = undefined;
		if ( !event.target ) {
			event.target = elem;
		}

		// Clone any incoming data and prepend the event, creating the handler arg list
		data = data == null ?
			[ event ] :
			jQuery.makeArray( data, [ event ] );

		// Allow special events to draw outside the lines
		special = jQuery.event.special[ type ] || {};
		if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {
			return;
		}

		// Determine event propagation path in advance, per W3C events spec (#9951)
		// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
		if ( !onlyHandlers && !special.noBubble && !jQuery.isWindow( elem ) ) {

			bubbleType = special.delegateType || type;
			if ( !rfocusMorph.test( bubbleType + type ) ) {
				cur = cur.parentNode;
			}
			for ( ; cur; cur = cur.parentNode ) {
				eventPath.push( cur );
				tmp = cur;
			}

			// Only add window if we got to document (e.g., not plain obj or detached DOM)
			if ( tmp === (elem.ownerDocument || document) ) {
				eventPath.push( tmp.defaultView || tmp.parentWindow || window );
			}
		}

		// Fire handlers on the event path
		i = 0;
		while ( (cur = eventPath[i++]) && !event.isPropagationStopped() ) {

			event.type = i > 1 ?
				bubbleType :
				special.bindType || type;

			// jQuery handler
			handle = ( jQuery._data( cur, "events" ) || {} )[ event.type ] && jQuery._data( cur, "handle" );
			if ( handle ) {
				handle.apply( cur, data );
			}

			// Native handler
			handle = ontype && cur[ ontype ];
			if ( handle && handle.apply && jQuery.acceptData( cur ) ) {
				event.result = handle.apply( cur, data );
				if ( event.result === false ) {
					event.preventDefault();
				}
			}
		}
		event.type = type;

		// If nobody prevented the default action, do it now
		if ( !onlyHandlers && !event.isDefaultPrevented() ) {

			if ( (!special._default || special._default.apply( eventPath.pop(), data ) === false) &&
				jQuery.acceptData( elem ) ) {

				// Call a native DOM method on the target with the same name name as the event.
				// Can't use an .isFunction() check here because IE6/7 fails that test.
				// Don't do default actions on window, that's where global variables be (#6170)
				if ( ontype && elem[ type ] && !jQuery.isWindow( elem ) ) {

					// Don't re-trigger an onFOO event when we call its FOO() method
					tmp = elem[ ontype ];

					if ( tmp ) {
						elem[ ontype ] = null;
					}

					// Prevent re-triggering of the same event, since we already bubbled it above
					jQuery.event.triggered = type;
					try {
						elem[ type ]();
					} catch ( e ) {
						// IE<9 dies on focus/blur to hidden element (#1486,#12518)
						// only reproducible on winXP IE8 native, not IE9 in IE8 mode
					}
					jQuery.event.triggered = undefined;

					if ( tmp ) {
						elem[ ontype ] = tmp;
					}
				}
			}
		}

		return event.result;
	},

	dispatch: function( event ) {

		// Make a writable jQuery.Event from the native event object
		event = jQuery.event.fix( event );

		var i, ret, handleObj, matched, j,
			handlerQueue = [],
			args = slice.call( arguments ),
			handlers = ( jQuery._data( this, "events" ) || {} )[ event.type ] || [],
			special = jQuery.event.special[ event.type ] || {};

		// Use the fix-ed jQuery.Event rather than the (read-only) native event
		args[0] = event;
		event.delegateTarget = this;

		// Call the preDispatch hook for the mapped type, and let it bail if desired
		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
			return;
		}

		// Determine handlers
		handlerQueue = jQuery.event.handlers.call( this, event, handlers );

		// Run delegates first; they may want to stop propagation beneath us
		i = 0;
		while ( (matched = handlerQueue[ i++ ]) && !event.isPropagationStopped() ) {
			event.currentTarget = matched.elem;

			j = 0;
			while ( (handleObj = matched.handlers[ j++ ]) && !event.isImmediatePropagationStopped() ) {

				// Triggered event must either 1) have no namespace, or
				// 2) have namespace(s) a subset or equal to those in the bound event (both can have no namespace).
				if ( !event.namespace_re || event.namespace_re.test( handleObj.namespace ) ) {

					event.handleObj = handleObj;
					event.data = handleObj.data;

					ret = ( (jQuery.event.special[ handleObj.origType ] || {}).handle || handleObj.handler )
							.apply( matched.elem, args );

					if ( ret !== undefined ) {
						if ( (event.result = ret) === false ) {
							event.preventDefault();
							event.stopPropagation();
						}
					}
				}
			}
		}

		// Call the postDispatch hook for the mapped type
		if ( special.postDispatch ) {
			special.postDispatch.call( this, event );
		}

		return event.result;
	},

	handlers: function( event, handlers ) {
		var sel, handleObj, matches, i,
			handlerQueue = [],
			delegateCount = handlers.delegateCount,
			cur = event.target;

		// Find delegate handlers
		// Black-hole SVG <use> instance trees (#13180)
		// Avoid non-left-click bubbling in Firefox (#3861)
		if ( delegateCount && cur.nodeType && (!event.button || event.type !== "click") ) {

			/* jshint eqeqeq: false */
			for ( ; cur != this; cur = cur.parentNode || this ) {
				/* jshint eqeqeq: true */

				// Don't check non-elements (#13208)
				// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
				if ( cur.nodeType === 1 && (cur.disabled !== true || event.type !== "click") ) {
					matches = [];
					for ( i = 0; i < delegateCount; i++ ) {
						handleObj = handlers[ i ];

						// Don't conflict with Object.prototype properties (#13203)
						sel = handleObj.selector + " ";

						if ( matches[ sel ] === undefined ) {
							matches[ sel ] = handleObj.needsContext ?
								jQuery( sel, this ).index( cur ) >= 0 :
								jQuery.find( sel, this, null, [ cur ] ).length;
						}
						if ( matches[ sel ] ) {
							matches.push( handleObj );
						}
					}
					if ( matches.length ) {
						handlerQueue.push({ elem: cur, handlers: matches });
					}
				}
			}
		}

		// Add the remaining (directly-bound) handlers
		if ( delegateCount < handlers.length ) {
			handlerQueue.push({ elem: this, handlers: handlers.slice( delegateCount ) });
		}

		return handlerQueue;
	},

	fix: function( event ) {
		if ( event[ jQuery.expando ] ) {
			return event;
		}

		// Create a writable copy of the event object and normalize some properties
		var i, prop, copy,
			type = event.type,
			originalEvent = event,
			fixHook = this.fixHooks[ type ];

		if ( !fixHook ) {
			this.fixHooks[ type ] = fixHook =
				rmouseEvent.test( type ) ? this.mouseHooks :
				rkeyEvent.test( type ) ? this.keyHooks :
				{};
		}
		copy = fixHook.props ? this.props.concat( fixHook.props ) : this.props;

		event = new jQuery.Event( originalEvent );

		i = copy.length;
		while ( i-- ) {
			prop = copy[ i ];
			event[ prop ] = originalEvent[ prop ];
		}

		// Support: IE<9
		// Fix target property (#1925)
		if ( !event.target ) {
			event.target = originalEvent.srcElement || document;
		}

		// Support: Chrome 23+, Safari?
		// Target should not be a text node (#504, #13143)
		if ( event.target.nodeType === 3 ) {
			event.target = event.target.parentNode;
		}

		// Support: IE<9
		// For mouse/key events, metaKey==false if it's undefined (#3368, #11328)
		event.metaKey = !!event.metaKey;

		return fixHook.filter ? fixHook.filter( event, originalEvent ) : event;
	},

	// Includes some event props shared by KeyEvent and MouseEvent
	props: "altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),

	fixHooks: {},

	keyHooks: {
		props: "char charCode key keyCode".split(" "),
		filter: function( event, original ) {

			// Add which for key events
			if ( event.which == null ) {
				event.which = original.charCode != null ? original.charCode : original.keyCode;
			}

			return event;
		}
	},

	mouseHooks: {
		props: "button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),
		filter: function( event, original ) {
			var body, eventDoc, doc,
				button = original.button,
				fromElement = original.fromElement;

			// Calculate pageX/Y if missing and clientX/Y available
			if ( event.pageX == null && original.clientX != null ) {
				eventDoc = event.target.ownerDocument || document;
				doc = eventDoc.documentElement;
				body = eventDoc.body;

				event.pageX = original.clientX + ( doc && doc.scrollLeft || body && body.scrollLeft || 0 ) - ( doc && doc.clientLeft || body && body.clientLeft || 0 );
				event.pageY = original.clientY + ( doc && doc.scrollTop  || body && body.scrollTop  || 0 ) - ( doc && doc.clientTop  || body && body.clientTop  || 0 );
			}

			// Add relatedTarget, if necessary
			if ( !event.relatedTarget && fromElement ) {
				event.relatedTarget = fromElement === event.target ? original.toElement : fromElement;
			}

			// Add which for click: 1 === left; 2 === middle; 3 === right
			// Note: button is not normalized, so don't use it
			if ( !event.which && button !== undefined ) {
				event.which = ( button & 1 ? 1 : ( button & 2 ? 3 : ( button & 4 ? 2 : 0 ) ) );
			}

			return event;
		}
	},

	special: {
		load: {
			// Prevent triggered image.load events from bubbling to window.load
			noBubble: true
		},
		focus: {
			// Fire native event if possible so blur/focus sequence is correct
			trigger: function() {
				if ( this !== safeActiveElement() && this.focus ) {
					try {
						this.focus();
						return false;
					} catch ( e ) {
						// Support: IE<9
						// If we error on focus to hidden element (#1486, #12518),
						// let .trigger() run the handlers
					}
				}
			},
			delegateType: "focusin"
		},
		blur: {
			trigger: function() {
				if ( this === safeActiveElement() && this.blur ) {
					this.blur();
					return false;
				}
			},
			delegateType: "focusout"
		},
		click: {
			// For checkbox, fire native event so checked state will be right
			trigger: function() {
				if ( jQuery.nodeName( this, "input" ) && this.type === "checkbox" && this.click ) {
					this.click();
					return false;
				}
			},

			// For cross-browser consistency, don't fire native .click() on links
			_default: function( event ) {
				return jQuery.nodeName( event.target, "a" );
			}
		},

		beforeunload: {
			postDispatch: function( event ) {

				// Even when returnValue equals to undefined Firefox will still show alert
				if ( event.result !== undefined ) {
					event.originalEvent.returnValue = event.result;
				}
			}
		}
	},

	simulate: function( type, elem, event, bubble ) {
		// Piggyback on a donor event to simulate a different one.
		// Fake originalEvent to avoid donor's stopPropagation, but if the
		// simulated event prevents default then we do the same on the donor.
		var e = jQuery.extend(
			new jQuery.Event(),
			event,
			{
				type: type,
				isSimulated: true,
				originalEvent: {}
			}
		);
		if ( bubble ) {
			jQuery.event.trigger( e, null, elem );
		} else {
			jQuery.event.dispatch.call( elem, e );
		}
		if ( e.isDefaultPrevented() ) {
			event.preventDefault();
		}
	}
};

jQuery.removeEvent = document.removeEventListener ?
	function( elem, type, handle ) {
		if ( elem.removeEventListener ) {
			elem.removeEventListener( type, handle, false );
		}
	} :
	function( elem, type, handle ) {
		var name = "on" + type;

		if ( elem.detachEvent ) {

			// #8545, #7054, preventing memory leaks for custom events in IE6-8
			// detachEvent needed property on element, by name of that event, to properly expose it to GC
			if ( typeof elem[ name ] === strundefined ) {
				elem[ name ] = null;
			}

			elem.detachEvent( name, handle );
		}
	};

jQuery.Event = function( src, props ) {
	// Allow instantiation without the 'new' keyword
	if ( !(this instanceof jQuery.Event) ) {
		return new jQuery.Event( src, props );
	}

	// Event object
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Events bubbling up the document may have been marked as prevented
		// by a handler lower down the tree; reflect the correct value.
		this.isDefaultPrevented = src.defaultPrevented ||
				src.defaultPrevented === undefined && (
				// Support: IE < 9
				src.returnValue === false ||
				// Support: Android < 4.0
				src.getPreventDefault && src.getPreventDefault() ) ?
			returnTrue :
			returnFalse;

	// Event type
	} else {
		this.type = src;
	}

	// Put explicitly provided properties onto the event object
	if ( props ) {
		jQuery.extend( this, props );
	}

	// Create a timestamp if incoming event doesn't have one
	this.timeStamp = src && src.timeStamp || jQuery.now();

	// Mark it as fixed
	this[ jQuery.expando ] = true;
};

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
jQuery.Event.prototype = {
	isDefaultPrevented: returnFalse,
	isPropagationStopped: returnFalse,
	isImmediatePropagationStopped: returnFalse,

	preventDefault: function() {
		var e = this.originalEvent;

		this.isDefaultPrevented = returnTrue;
		if ( !e ) {
			return;
		}

		// If preventDefault exists, run it on the original event
		if ( e.preventDefault ) {
			e.preventDefault();

		// Support: IE
		// Otherwise set the returnValue property of the original event to false
		} else {
			e.returnValue = false;
		}
	},
	stopPropagation: function() {
		var e = this.originalEvent;

		this.isPropagationStopped = returnTrue;
		if ( !e ) {
			return;
		}
		// If stopPropagation exists, run it on the original event
		if ( e.stopPropagation ) {
			e.stopPropagation();
		}

		// Support: IE
		// Set the cancelBubble property of the original event to true
		e.cancelBubble = true;
	},
	stopImmediatePropagation: function() {
		this.isImmediatePropagationStopped = returnTrue;
		this.stopPropagation();
	}
};

// Create mouseenter/leave events using mouseover/out and event-time checks
jQuery.each({
	mouseenter: "mouseover",
	mouseleave: "mouseout"
}, function( orig, fix ) {
	jQuery.event.special[ orig ] = {
		delegateType: fix,
		bindType: fix,

		handle: function( event ) {
			var ret,
				target = this,
				related = event.relatedTarget,
				handleObj = event.handleObj;

			// For mousenter/leave call the handler if related is outside the target.
			// NB: No relatedTarget if the mouse left/entered the browser window
			if ( !related || (related !== target && !jQuery.contains( target, related )) ) {
				event.type = handleObj.origType;
				ret = handleObj.handler.apply( this, arguments );
				event.type = fix;
			}
			return ret;
		}
	};
});

// IE submit delegation
if ( !support.submitBubbles ) {

	jQuery.event.special.submit = {
		setup: function() {
			// Only need this for delegated form submit events
			if ( jQuery.nodeName( this, "form" ) ) {
				return false;
			}

			// Lazy-add a submit handler when a descendant form may potentially be submitted
			jQuery.event.add( this, "click._submit keypress._submit", function( e ) {
				// Node name check avoids a VML-related crash in IE (#9807)
				var elem = e.target,
					form = jQuery.nodeName( elem, "input" ) || jQuery.nodeName( elem, "button" ) ? elem.form : undefined;
				if ( form && !jQuery._data( form, "submitBubbles" ) ) {
					jQuery.event.add( form, "submit._submit", function( event ) {
						event._submit_bubble = true;
					});
					jQuery._data( form, "submitBubbles", true );
				}
			});
			// return undefined since we don't need an event listener
		},

		postDispatch: function( event ) {
			// If form was submitted by the user, bubble the event up the tree
			if ( event._submit_bubble ) {
				delete event._submit_bubble;
				if ( this.parentNode && !event.isTrigger ) {
					jQuery.event.simulate( "submit", this.parentNode, event, true );
				}
			}
		},

		teardown: function() {
			// Only need this for delegated form submit events
			if ( jQuery.nodeName( this, "form" ) ) {
				return false;
			}

			// Remove delegated handlers; cleanData eventually reaps submit handlers attached above
			jQuery.event.remove( this, "._submit" );
		}
	};
}

// IE change delegation and checkbox/radio fix
if ( !support.changeBubbles ) {

	jQuery.event.special.change = {

		setup: function() {

			if ( rformElems.test( this.nodeName ) ) {
				// IE doesn't fire change on a check/radio until blur; trigger it on click
				// after a propertychange. Eat the blur-change in special.change.handle.
				// This still fires onchange a second time for check/radio after blur.
				if ( this.type === "checkbox" || this.type === "radio" ) {
					jQuery.event.add( this, "propertychange._change", function( event ) {
						if ( event.originalEvent.propertyName === "checked" ) {
							this._just_changed = true;
						}
					});
					jQuery.event.add( this, "click._change", function( event ) {
						if ( this._just_changed && !event.isTrigger ) {
							this._just_changed = false;
						}
						// Allow triggered, simulated change events (#11500)
						jQuery.event.simulate( "change", this, event, true );
					});
				}
				return false;
			}
			// Delegated event; lazy-add a change handler on descendant inputs
			jQuery.event.add( this, "beforeactivate._change", function( e ) {
				var elem = e.target;

				if ( rformElems.test( elem.nodeName ) && !jQuery._data( elem, "changeBubbles" ) ) {
					jQuery.event.add( elem, "change._change", function( event ) {
						if ( this.parentNode && !event.isSimulated && !event.isTrigger ) {
							jQuery.event.simulate( "change", this.parentNode, event, true );
						}
					});
					jQuery._data( elem, "changeBubbles", true );
				}
			});
		},

		handle: function( event ) {
			var elem = event.target;

			// Swallow native change events from checkbox/radio, we already triggered them above
			if ( this !== elem || event.isSimulated || event.isTrigger || (elem.type !== "radio" && elem.type !== "checkbox") ) {
				return event.handleObj.handler.apply( this, arguments );
			}
		},

		teardown: function() {
			jQuery.event.remove( this, "._change" );

			return !rformElems.test( this.nodeName );
		}
	};
}

// Create "bubbling" focus and blur events
if ( !support.focusinBubbles ) {
	jQuery.each({ focus: "focusin", blur: "focusout" }, function( orig, fix ) {

		// Attach a single capturing handler on the document while someone wants focusin/focusout
		var handler = function( event ) {
				jQuery.event.simulate( fix, event.target, jQuery.event.fix( event ), true );
			};

		jQuery.event.special[ fix ] = {
			setup: function() {
				var doc = this.ownerDocument || this,
					attaches = jQuery._data( doc, fix );

				if ( !attaches ) {
					doc.addEventListener( orig, handler, true );
				}
				jQuery._data( doc, fix, ( attaches || 0 ) + 1 );
			},
			teardown: function() {
				var doc = this.ownerDocument || this,
					attaches = jQuery._data( doc, fix ) - 1;

				if ( !attaches ) {
					doc.removeEventListener( orig, handler, true );
					jQuery._removeData( doc, fix );
				} else {
					jQuery._data( doc, fix, attaches );
				}
			}
		};
	});
}

jQuery.fn.extend({

	on: function( types, selector, data, fn, /*INTERNAL*/ one ) {
		var type, origFn;

		// Types can be a map of types/handlers
		if ( typeof types === "object" ) {
			// ( types-Object, selector, data )
			if ( typeof selector !== "string" ) {
				// ( types-Object, data )
				data = data || selector;
				selector = undefined;
			}
			for ( type in types ) {
				this.on( type, selector, data, types[ type ], one );
			}
			return this;
		}

		if ( data == null && fn == null ) {
			// ( types, fn )
			fn = selector;
			data = selector = undefined;
		} else if ( fn == null ) {
			if ( typeof selector === "string" ) {
				// ( types, selector, fn )
				fn = data;
				data = undefined;
			} else {
				// ( types, data, fn )
				fn = data;
				data = selector;
				selector = undefined;
			}
		}
		if ( fn === false ) {
			fn = returnFalse;
		} else if ( !fn ) {
			return this;
		}

		if ( one === 1 ) {
			origFn = fn;
			fn = function( event ) {
				// Can use an empty set, since event contains the info
				jQuery().off( event );
				return origFn.apply( this, arguments );
			};
			// Use same guid so caller can remove using origFn
			fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
		}
		return this.each( function() {
			jQuery.event.add( this, types, fn, data, selector );
		});
	},
	one: function( types, selector, data, fn ) {
		return this.on( types, selector, data, fn, 1 );
	},
	off: function( types, selector, fn ) {
		var handleObj, type;
		if ( types && types.preventDefault && types.handleObj ) {
			// ( event )  dispatched jQuery.Event
			handleObj = types.handleObj;
			jQuery( types.delegateTarget ).off(
				handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType,
				handleObj.selector,
				handleObj.handler
			);
			return this;
		}
		if ( typeof types === "object" ) {
			// ( types-object [, selector] )
			for ( type in types ) {
				this.off( type, selector, types[ type ] );
			}
			return this;
		}
		if ( selector === false || typeof selector === "function" ) {
			// ( types [, fn] )
			fn = selector;
			selector = undefined;
		}
		if ( fn === false ) {
			fn = returnFalse;
		}
		return this.each(function() {
			jQuery.event.remove( this, types, fn, selector );
		});
	},

	trigger: function( type, data ) {
		return this.each(function() {
			jQuery.event.trigger( type, data, this );
		});
	},
	triggerHandler: function( type, data ) {
		var elem = this[0];
		if ( elem ) {
			return jQuery.event.trigger( type, data, elem, true );
		}
	}
});


function createSafeFragment( document ) {
	var list = nodeNames.split( "|" ),
		safeFrag = document.createDocumentFragment();

	if ( safeFrag.createElement ) {
		while ( list.length ) {
			safeFrag.createElement(
				list.pop()
			);
		}
	}
	return safeFrag;
}

var nodeNames = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|" +
		"header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",
	rinlinejQuery = / jQuery\d+="(?:null|\d+)"/g,
	rnoshimcache = new RegExp("<(?:" + nodeNames + ")[\\s/>]", "i"),
	rleadingWhitespace = /^\s+/,
	rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,
	rtagName = /<([\w:]+)/,
	rtbody = /<tbody/i,
	rhtml = /<|&#?\w+;/,
	rnoInnerhtml = /<(?:script|style|link)/i,
	// checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
	rscriptType = /^$|\/(?:java|ecma)script/i,
	rscriptTypeMasked = /^true\/(.*)/,
	rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g,

	// We have to close these tags to support XHTML (#13200)
	wrapMap = {
		option: [ 1, "<select multiple='multiple'>", "</select>" ],
		legend: [ 1, "<fieldset>", "</fieldset>" ],
		area: [ 1, "<map>", "</map>" ],
		param: [ 1, "<object>", "</object>" ],
		thead: [ 1, "<table>", "</table>" ],
		tr: [ 2, "<table><tbody>", "</tbody></table>" ],
		col: [ 2, "<table><tbody></tbody><colgroup>", "</colgroup></table>" ],
		td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],

		// IE6-8 can't serialize link, script, style, or any html5 (NoScope) tags,
		// unless wrapped in a div with non-breaking characters in front of it.
		_default: support.htmlSerialize ? [ 0, "", "" ] : [ 1, "X<div>", "</div>"  ]
	},
	safeFragment = createSafeFragment( document ),
	fragmentDiv = safeFragment.appendChild( document.createElement("div") );

wrapMap.optgroup = wrapMap.option;
wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;

function getAll( context, tag ) {
	var elems, elem,
		i = 0,
		found = typeof context.getElementsByTagName !== strundefined ? context.getElementsByTagName( tag || "*" ) :
			typeof context.querySelectorAll !== strundefined ? context.querySelectorAll( tag || "*" ) :
			undefined;

	if ( !found ) {
		for ( found = [], elems = context.childNodes || context; (elem = elems[i]) != null; i++ ) {
			if ( !tag || jQuery.nodeName( elem, tag ) ) {
				found.push( elem );
			} else {
				jQuery.merge( found, getAll( elem, tag ) );
			}
		}
	}

	return tag === undefined || tag && jQuery.nodeName( context, tag ) ?
		jQuery.merge( [ context ], found ) :
		found;
}

// Used in buildFragment, fixes the defaultChecked property
function fixDefaultChecked( elem ) {
	if ( rcheckableType.test( elem.type ) ) {
		elem.defaultChecked = elem.checked;
	}
}

// Support: IE<8
// Manipulating tables requires a tbody
function manipulationTarget( elem, content ) {
	return jQuery.nodeName( elem, "table" ) &&
		jQuery.nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ?

		elem.getElementsByTagName("tbody")[0] ||
			elem.appendChild( elem.ownerDocument.createElement("tbody") ) :
		elem;
}

// Replace/restore the type attribute of script elements for safe DOM manipulation
function disableScript( elem ) {
	elem.type = (jQuery.find.attr( elem, "type" ) !== null) + "/" + elem.type;
	return elem;
}
function restoreScript( elem ) {
	var match = rscriptTypeMasked.exec( elem.type );
	if ( match ) {
		elem.type = match[1];
	} else {
		elem.removeAttribute("type");
	}
	return elem;
}

// Mark scripts as having already been evaluated
function setGlobalEval( elems, refElements ) {
	var elem,
		i = 0;
	for ( ; (elem = elems[i]) != null; i++ ) {
		jQuery._data( elem, "globalEval", !refElements || jQuery._data( refElements[i], "globalEval" ) );
	}
}

function cloneCopyEvent( src, dest ) {

	if ( dest.nodeType !== 1 || !jQuery.hasData( src ) ) {
		return;
	}

	var type, i, l,
		oldData = jQuery._data( src ),
		curData = jQuery._data( dest, oldData ),
		events = oldData.events;

	if ( events ) {
		delete curData.handle;
		curData.events = {};

		for ( type in events ) {
			for ( i = 0, l = events[ type ].length; i < l; i++ ) {
				jQuery.event.add( dest, type, events[ type ][ i ] );
			}
		}
	}

	// make the cloned public data object a copy from the original
	if ( curData.data ) {
		curData.data = jQuery.extend( {}, curData.data );
	}
}

function fixCloneNodeIssues( src, dest ) {
	var nodeName, e, data;

	// We do not need to do anything for non-Elements
	if ( dest.nodeType !== 1 ) {
		return;
	}

	nodeName = dest.nodeName.toLowerCase();

	// IE6-8 copies events bound via attachEvent when using cloneNode.
	if ( !support.noCloneEvent && dest[ jQuery.expando ] ) {
		data = jQuery._data( dest );

		for ( e in data.events ) {
			jQuery.removeEvent( dest, e, data.handle );
		}

		// Event data gets referenced instead of copied if the expando gets copied too
		dest.removeAttribute( jQuery.expando );
	}

	// IE blanks contents when cloning scripts, and tries to evaluate newly-set text
	if ( nodeName === "script" && dest.text !== src.text ) {
		disableScript( dest ).text = src.text;
		restoreScript( dest );

	// IE6-10 improperly clones children of object elements using classid.
	// IE10 throws NoModificationAllowedError if parent is null, #12132.
	} else if ( nodeName === "object" ) {
		if ( dest.parentNode ) {
			dest.outerHTML = src.outerHTML;
		}

		// This path appears unavoidable for IE9. When cloning an object
		// element in IE9, the outerHTML strategy above is not sufficient.
		// If the src has innerHTML and the destination does not,
		// copy the src.innerHTML into the dest.innerHTML. #10324
		if ( support.html5Clone && ( src.innerHTML && !jQuery.trim(dest.innerHTML) ) ) {
			dest.innerHTML = src.innerHTML;
		}

	} else if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
		// IE6-8 fails to persist the checked state of a cloned checkbox
		// or radio button. Worse, IE6-7 fail to give the cloned element
		// a checked appearance if the defaultChecked value isn't also set

		dest.defaultChecked = dest.checked = src.checked;

		// IE6-7 get confused and end up setting the value of a cloned
		// checkbox/radio button to an empty string instead of "on"
		if ( dest.value !== src.value ) {
			dest.value = src.value;
		}

	// IE6-8 fails to return the selected option to the default selected
	// state when cloning options
	} else if ( nodeName === "option" ) {
		dest.defaultSelected = dest.selected = src.defaultSelected;

	// IE6-8 fails to set the defaultValue to the correct value when
	// cloning other types of input fields
	} else if ( nodeName === "input" || nodeName === "textarea" ) {
		dest.defaultValue = src.defaultValue;
	}
}

jQuery.extend({
	clone: function( elem, dataAndEvents, deepDataAndEvents ) {
		var destElements, node, clone, i, srcElements,
			inPage = jQuery.contains( elem.ownerDocument, elem );

		if ( support.html5Clone || jQuery.isXMLDoc(elem) || !rnoshimcache.test( "<" + elem.nodeName + ">" ) ) {
			clone = elem.cloneNode( true );

		// IE<=8 does not properly clone detached, unknown element nodes
		} else {
			fragmentDiv.innerHTML = elem.outerHTML;
			fragmentDiv.removeChild( clone = fragmentDiv.firstChild );
		}

		if ( (!support.noCloneEvent || !support.noCloneChecked) &&
				(elem.nodeType === 1 || elem.nodeType === 11) && !jQuery.isXMLDoc(elem) ) {

			// We eschew Sizzle here for performance reasons: http://jsperf.com/getall-vs-sizzle/2
			destElements = getAll( clone );
			srcElements = getAll( elem );

			// Fix all IE cloning issues
			for ( i = 0; (node = srcElements[i]) != null; ++i ) {
				// Ensure that the destination node is not null; Fixes #9587
				if ( destElements[i] ) {
					fixCloneNodeIssues( node, destElements[i] );
				}
			}
		}

		// Copy the events from the original to the clone
		if ( dataAndEvents ) {
			if ( deepDataAndEvents ) {
				srcElements = srcElements || getAll( elem );
				destElements = destElements || getAll( clone );

				for ( i = 0; (node = srcElements[i]) != null; i++ ) {
					cloneCopyEvent( node, destElements[i] );
				}
			} else {
				cloneCopyEvent( elem, clone );
			}
		}

		// Preserve script evaluation history
		destElements = getAll( clone, "script" );
		if ( destElements.length > 0 ) {
			setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );
		}

		destElements = srcElements = node = null;

		// Return the cloned set
		return clone;
	},

	buildFragment: function( elems, context, scripts, selection ) {
		var j, elem, contains,
			tmp, tag, tbody, wrap,
			l = elems.length,

			// Ensure a safe fragment
			safe = createSafeFragment( context ),

			nodes = [],
			i = 0;

		for ( ; i < l; i++ ) {
			elem = elems[ i ];

			if ( elem || elem === 0 ) {

				// Add nodes directly
				if ( jQuery.type( elem ) === "object" ) {
					jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );

				// Convert non-html into a text node
				} else if ( !rhtml.test( elem ) ) {
					nodes.push( context.createTextNode( elem ) );

				// Convert html into DOM nodes
				} else {
					tmp = tmp || safe.appendChild( context.createElement("div") );

					// Deserialize a standard representation
					tag = (rtagName.exec( elem ) || [ "", "" ])[ 1 ].toLowerCase();
					wrap = wrapMap[ tag ] || wrapMap._default;

					tmp.innerHTML = wrap[1] + elem.replace( rxhtmlTag, "<$1></$2>" ) + wrap[2];

					// Descend through wrappers to the right content
					j = wrap[0];
					while ( j-- ) {
						tmp = tmp.lastChild;
					}

					// Manually add leading whitespace removed by IE
					if ( !support.leadingWhitespace && rleadingWhitespace.test( elem ) ) {
						nodes.push( context.createTextNode( rleadingWhitespace.exec( elem )[0] ) );
					}

					// Remove IE's autoinserted <tbody> from table fragments
					if ( !support.tbody ) {

						// String was a <table>, *may* have spurious <tbody>
						elem = tag === "table" && !rtbody.test( elem ) ?
							tmp.firstChild :

							// String was a bare <thead> or <tfoot>
							wrap[1] === "<table>" && !rtbody.test( elem ) ?
								tmp :
								0;

						j = elem && elem.childNodes.length;
						while ( j-- ) {
							if ( jQuery.nodeName( (tbody = elem.childNodes[j]), "tbody" ) && !tbody.childNodes.length ) {
								elem.removeChild( tbody );
							}
						}
					}

					jQuery.merge( nodes, tmp.childNodes );

					// Fix #12392 for WebKit and IE > 9
					tmp.textContent = "";

					// Fix #12392 for oldIE
					while ( tmp.firstChild ) {
						tmp.removeChild( tmp.firstChild );
					}

					// Remember the top-level container for proper cleanup
					tmp = safe.lastChild;
				}
			}
		}

		// Fix #11356: Clear elements from fragment
		if ( tmp ) {
			safe.removeChild( tmp );
		}

		// Reset defaultChecked for any radios and checkboxes
		// about to be appended to the DOM in IE 6/7 (#8060)
		if ( !support.appendChecked ) {
			jQuery.grep( getAll( nodes, "input" ), fixDefaultChecked );
		}

		i = 0;
		while ( (elem = nodes[ i++ ]) ) {

			// #4087 - If origin and destination elements are the same, and this is
			// that element, do not do anything
			if ( selection && jQuery.inArray( elem, selection ) !== -1 ) {
				continue;
			}

			contains = jQuery.contains( elem.ownerDocument, elem );

			// Append to fragment
			tmp = getAll( safe.appendChild( elem ), "script" );

			// Preserve script evaluation history
			if ( contains ) {
				setGlobalEval( tmp );
			}

			// Capture executables
			if ( scripts ) {
				j = 0;
				while ( (elem = tmp[ j++ ]) ) {
					if ( rscriptType.test( elem.type || "" ) ) {
						scripts.push( elem );
					}
				}
			}
		}

		tmp = null;

		return safe;
	},

	cleanData: function( elems, /* internal */ acceptData ) {
		var elem, type, id, data,
			i = 0,
			internalKey = jQuery.expando,
			cache = jQuery.cache,
			deleteExpando = support.deleteExpando,
			special = jQuery.event.special;

		for ( ; (elem = elems[i]) != null; i++ ) {
			if ( acceptData || jQuery.acceptData( elem ) ) {

				id = elem[ internalKey ];
				data = id && cache[ id ];

				if ( data ) {
					if ( data.events ) {
						for ( type in data.events ) {
							if ( special[ type ] ) {
								jQuery.event.remove( elem, type );

							// This is a shortcut to avoid jQuery.event.remove's overhead
							} else {
								jQuery.removeEvent( elem, type, data.handle );
							}
						}
					}

					// Remove cache only if it was not already removed by jQuery.event.remove
					if ( cache[ id ] ) {

						delete cache[ id ];

						// IE does not allow us to delete expando properties from nodes,
						// nor does it have a removeAttribute function on Document nodes;
						// we must handle all of these cases
						if ( deleteExpando ) {
							delete elem[ internalKey ];

						} else if ( typeof elem.removeAttribute !== strundefined ) {
							elem.removeAttribute( internalKey );

						} else {
							elem[ internalKey ] = null;
						}

						deletedIds.push( id );
					}
				}
			}
		}
	}
});

jQuery.fn.extend({
	text: function( value ) {
		return access( this, function( value ) {
			return value === undefined ?
				jQuery.text( this ) :
				this.empty().append( ( this[0] && this[0].ownerDocument || document ).createTextNode( value ) );
		}, null, value, arguments.length );
	},

	append: function() {
		return this.domManip( arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.appendChild( elem );
			}
		});
	},

	prepend: function() {
		return this.domManip( arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.insertBefore( elem, target.firstChild );
			}
		});
	},

	before: function() {
		return this.domManip( arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this );
			}
		});
	},

	after: function() {
		return this.domManip( arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this.nextSibling );
			}
		});
	},

	remove: function( selector, keepData /* Internal Use Only */ ) {
		var elem,
			elems = selector ? jQuery.filter( selector, this ) : this,
			i = 0;

		for ( ; (elem = elems[i]) != null; i++ ) {

			if ( !keepData && elem.nodeType === 1 ) {
				jQuery.cleanData( getAll( elem ) );
			}

			if ( elem.parentNode ) {
				if ( keepData && jQuery.contains( elem.ownerDocument, elem ) ) {
					setGlobalEval( getAll( elem, "script" ) );
				}
				elem.parentNode.removeChild( elem );
			}
		}

		return this;
	},

	empty: function() {
		var elem,
			i = 0;

		for ( ; (elem = this[i]) != null; i++ ) {
			// Remove element nodes and prevent memory leaks
			if ( elem.nodeType === 1 ) {
				jQuery.cleanData( getAll( elem, false ) );
			}

			// Remove any remaining nodes
			while ( elem.firstChild ) {
				elem.removeChild( elem.firstChild );
			}

			// If this is a select, ensure that it displays empty (#12336)
			// Support: IE<9
			if ( elem.options && jQuery.nodeName( elem, "select" ) ) {
				elem.options.length = 0;
			}
		}

		return this;
	},

	clone: function( dataAndEvents, deepDataAndEvents ) {
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

		return this.map(function() {
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
		});
	},

	html: function( value ) {
		return access( this, function( value ) {
			var elem = this[ 0 ] || {},
				i = 0,
				l = this.length;

			if ( value === undefined ) {
				return elem.nodeType === 1 ?
					elem.innerHTML.replace( rinlinejQuery, "" ) :
					undefined;
			}

			// See if we can take a shortcut and just use innerHTML
			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
				( support.htmlSerialize || !rnoshimcache.test( value )  ) &&
				( support.leadingWhitespace || !rleadingWhitespace.test( value ) ) &&
				!wrapMap[ (rtagName.exec( value ) || [ "", "" ])[ 1 ].toLowerCase() ] ) {

				value = value.replace( rxhtmlTag, "<$1></$2>" );

				try {
					for (; i < l; i++ ) {
						// Remove element nodes and prevent memory leaks
						elem = this[i] || {};
						if ( elem.nodeType === 1 ) {
							jQuery.cleanData( getAll( elem, false ) );
							elem.innerHTML = value;
						}
					}

					elem = 0;

				// If using innerHTML throws an exception, use the fallback method
				} catch(e) {}
			}

			if ( elem ) {
				this.empty().append( value );
			}
		}, null, value, arguments.length );
	},

	replaceWith: function() {
		var arg = arguments[ 0 ];

		// Make the changes, replacing each context element with the new content
		this.domManip( arguments, function( elem ) {
			arg = this.parentNode;

			jQuery.cleanData( getAll( this ) );

			if ( arg ) {
				arg.replaceChild( elem, this );
			}
		});

		// Force removal if there was no new content (e.g., from empty arguments)
		return arg && (arg.length || arg.nodeType) ? this : this.remove();
	},

	detach: function( selector ) {
		return this.remove( selector, true );
	},

	domManip: function( args, callback ) {

		// Flatten any nested arrays
		args = concat.apply( [], args );

		var first, node, hasScripts,
			scripts, doc, fragment,
			i = 0,
			l = this.length,
			set = this,
			iNoClone = l - 1,
			value = args[0],
			isFunction = jQuery.isFunction( value );

		// We can't cloneNode fragments that contain checked, in WebKit
		if ( isFunction ||
				( l > 1 && typeof value === "string" &&
					!support.checkClone && rchecked.test( value ) ) ) {
			return this.each(function( index ) {
				var self = set.eq( index );
				if ( isFunction ) {
					args[0] = value.call( this, index, self.html() );
				}
				self.domManip( args, callback );
			});
		}

		if ( l ) {
			fragment = jQuery.buildFragment( args, this[ 0 ].ownerDocument, false, this );
			first = fragment.firstChild;

			if ( fragment.childNodes.length === 1 ) {
				fragment = first;
			}

			if ( first ) {
				scripts = jQuery.map( getAll( fragment, "script" ), disableScript );
				hasScripts = scripts.length;

				// Use the original fragment for the last item instead of the first because it can end up
				// being emptied incorrectly in certain situations (#8070).
				for ( ; i < l; i++ ) {
					node = fragment;

					if ( i !== iNoClone ) {
						node = jQuery.clone( node, true, true );

						// Keep references to cloned scripts for later restoration
						if ( hasScripts ) {
							jQuery.merge( scripts, getAll( node, "script" ) );
						}
					}

					callback.call( this[i], node, i );
				}

				if ( hasScripts ) {
					doc = scripts[ scripts.length - 1 ].ownerDocument;

					// Reenable scripts
					jQuery.map( scripts, restoreScript );

					// Evaluate executable scripts on first document insertion
					for ( i = 0; i < hasScripts; i++ ) {
						node = scripts[ i ];
						if ( rscriptType.test( node.type || "" ) &&
							!jQuery._data( node, "globalEval" ) && jQuery.contains( doc, node ) ) {

							if ( node.src ) {
								// Optional AJAX dependency, but won't run scripts if not present
								if ( jQuery._evalUrl ) {
									jQuery._evalUrl( node.src );
								}
							} else {
								jQuery.globalEval( ( node.text || node.textContent || node.innerHTML || "" ).replace( rcleanScript, "" ) );
							}
						}
					}
				}

				// Fix #11809: Avoid leaking memory
				fragment = first = null;
			}
		}

		return this;
	}
});

jQuery.each({
	appendTo: "append",
	prependTo: "prepend",
	insertBefore: "before",
	insertAfter: "after",
	replaceAll: "replaceWith"
}, function( name, original ) {
	jQuery.fn[ name ] = function( selector ) {
		var elems,
			i = 0,
			ret = [],
			insert = jQuery( selector ),
			last = insert.length - 1;

		for ( ; i <= last; i++ ) {
			elems = i === last ? this : this.clone(true);
			jQuery( insert[i] )[ original ]( elems );

			// Modern browsers can apply jQuery collections as arrays, but oldIE needs a .get()
			push.apply( ret, elems.get() );
		}

		return this.pushStack( ret );
	};
});


var iframe,
	elemdisplay = {};

/**
 * Retrieve the actual display of a element
 * @param {String} name nodeName of the element
 * @param {Object} doc Document object
 */
// Called only from within defaultDisplay
function actualDisplay( name, doc ) {
	var elem = jQuery( doc.createElement( name ) ).appendTo( doc.body ),

		// getDefaultComputedStyle might be reliably used only on attached element
		display = window.getDefaultComputedStyle ?

			// Use of this method is a temporary fix (more like optmization) until something better comes along,
			// since it was removed from specification and supported only in FF
			window.getDefaultComputedStyle( elem[ 0 ] ).display : jQuery.css( elem[ 0 ], "display" );

	// We don't have any data stored on the element,
	// so use "detach" method as fast way to get rid of the element
	elem.detach();

	return display;
}

/**
 * Try to determine the default display value of an element
 * @param {String} nodeName
 */
function defaultDisplay( nodeName ) {
	var doc = document,
		display = elemdisplay[ nodeName ];

	if ( !display ) {
		display = actualDisplay( nodeName, doc );

		// If the simple way fails, read from inside an iframe
		if ( display === "none" || !display ) {

			// Use the already-created iframe if possible
			iframe = (iframe || jQuery( "<iframe frameborder='0' width='0' height='0'/>" )).appendTo( doc.documentElement );

			// Always write a new HTML skeleton so Webkit and Firefox don't choke on reuse
			doc = ( iframe[ 0 ].contentWindow || iframe[ 0 ].contentDocument ).document;

			// Support: IE
			doc.write();
			doc.close();

			display = actualDisplay( nodeName, doc );
			iframe.detach();
		}

		// Store the correct default display
		elemdisplay[ nodeName ] = display;
	}

	return display;
}


(function() {
	var a, shrinkWrapBlocksVal,
		div = document.createElement( "div" ),
		divReset =
			"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;" +
			"display:block;padding:0;margin:0;border:0";

	// Setup
	div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";
	a = div.getElementsByTagName( "a" )[ 0 ];

	a.style.cssText = "float:left;opacity:.5";

	// Make sure that element opacity exists
	// (IE uses filter instead)
	// Use a regex to work around a WebKit issue. See #5145
	support.opacity = /^0.5/.test( a.style.opacity );

	// Verify style float existence
	// (IE uses styleFloat instead of cssFloat)
	support.cssFloat = !!a.style.cssFloat;

	div.style.backgroundClip = "content-box";
	div.cloneNode( true ).style.backgroundClip = "";
	support.clearCloneStyle = div.style.backgroundClip === "content-box";

	// Null elements to avoid leaks in IE.
	a = div = null;

	support.shrinkWrapBlocks = function() {
		var body, container, div, containerStyles;

		if ( shrinkWrapBlocksVal == null ) {
			body = document.getElementsByTagName( "body" )[ 0 ];
			if ( !body ) {
				// Test fired too early or in an unsupported environment, exit.
				return;
			}

			containerStyles = "border:0;width:0;height:0;position:absolute;top:0;left:-9999px";
			container = document.createElement( "div" );
			div = document.createElement( "div" );

			body.appendChild( container ).appendChild( div );

			// Will be changed later if needed.
			shrinkWrapBlocksVal = false;

			if ( typeof div.style.zoom !== strundefined ) {
				// Support: IE6
				// Check if elements with layout shrink-wrap their children
				div.style.cssText = divReset + ";width:1px;padding:1px;zoom:1";
				div.innerHTML = "<div></div>";
				div.firstChild.style.width = "5px";
				shrinkWrapBlocksVal = div.offsetWidth !== 3;
			}

			body.removeChild( container );

			// Null elements to avoid leaks in IE.
			body = container = div = null;
		}

		return shrinkWrapBlocksVal;
	};

})();
var rmargin = (/^margin/);

var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );



var getStyles, curCSS,
	rposition = /^(top|right|bottom|left)$/;

if ( window.getComputedStyle ) {
	getStyles = function( elem ) {
		return elem.ownerDocument.defaultView.getComputedStyle( elem, null );
	};

	curCSS = function( elem, name, computed ) {
		var width, minWidth, maxWidth, ret,
			style = elem.style;

		computed = computed || getStyles( elem );

		// getPropertyValue is only needed for .css('filter') in IE9, see #12537
		ret = computed ? computed.getPropertyValue( name ) || computed[ name ] : undefined;

		if ( computed ) {

			if ( ret === "" && !jQuery.contains( elem.ownerDocument, elem ) ) {
				ret = jQuery.style( elem, name );
			}

			// A tribute to the "awesome hack by Dean Edwards"
			// Chrome < 17 and Safari 5.0 uses "computed value" instead of "used value" for margin-right
			// Safari 5.1.7 (at least) returns percentage for a larger set of values, but width seems to be reliably pixels
			// this is against the CSSOM draft spec: http://dev.w3.org/csswg/cssom/#resolved-values
			if ( rnumnonpx.test( ret ) && rmargin.test( name ) ) {

				// Remember the original values
				width = style.width;
				minWidth = style.minWidth;
				maxWidth = style.maxWidth;

				// Put in the new values to get a computed value out
				style.minWidth = style.maxWidth = style.width = ret;
				ret = computed.width;

				// Revert the changed values
				style.width = width;
				style.minWidth = minWidth;
				style.maxWidth = maxWidth;
			}
		}

		// Support: IE
		// IE returns zIndex value as an integer.
		return ret === undefined ?
			ret :
			ret + "";
	};
} else if ( document.documentElement.currentStyle ) {
	getStyles = function( elem ) {
		return elem.currentStyle;
	};

	curCSS = function( elem, name, computed ) {
		var left, rs, rsLeft, ret,
			style = elem.style;

		computed = computed || getStyles( elem );
		ret = computed ? computed[ name ] : undefined;

		// Avoid setting ret to empty string here
		// so we don't default to auto
		if ( ret == null && style && style[ name ] ) {
			ret = style[ name ];
		}

		// From the awesome hack by Dean Edwards
		// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291

		// If we're not dealing with a regular pixel number
		// but a number that has a weird ending, we need to convert it to pixels
		// but not position css attributes, as those are proportional to the parent element instead
		// and we can't measure the parent instead because it might trigger a "stacking dolls" problem
		if ( rnumnonpx.test( ret ) && !rposition.test( name ) ) {

			// Remember the original values
			left = style.left;
			rs = elem.runtimeStyle;
			rsLeft = rs && rs.left;

			// Put in the new values to get a computed value out
			if ( rsLeft ) {
				rs.left = elem.currentStyle.left;
			}
			style.left = name === "fontSize" ? "1em" : ret;
			ret = style.pixelLeft + "px";

			// Revert the changed values
			style.left = left;
			if ( rsLeft ) {
				rs.left = rsLeft;
			}
		}

		// Support: IE
		// IE returns zIndex value as an integer.
		return ret === undefined ?
			ret :
			ret + "" || "auto";
	};
}




function addGetHookIf( conditionFn, hookFn ) {
	// Define the hook, we'll check on the first run if it's really needed.
	return {
		get: function() {
			var condition = conditionFn();

			if ( condition == null ) {
				// The test was not ready at this point; screw the hook this time
				// but check again when needed next time.
				return;
			}

			if ( condition ) {
				// Hook not needed (or it's not possible to use it due to missing dependency),
				// remove it.
				// Since there are no other hooks for marginRight, remove the whole object.
				delete this.get;
				return;
			}

			// Hook needed; redefine it so that the support test is not executed again.

			return (this.get = hookFn).apply( this, arguments );
		}
	};
}


(function() {
	var a, reliableHiddenOffsetsVal, boxSizingVal, boxSizingReliableVal,
		pixelPositionVal, reliableMarginRightVal,
		div = document.createElement( "div" ),
		containerStyles = "border:0;width:0;height:0;position:absolute;top:0;left:-9999px",
		divReset =
			"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;" +
			"display:block;padding:0;margin:0;border:0";

	// Setup
	div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";
	a = div.getElementsByTagName( "a" )[ 0 ];

	a.style.cssText = "float:left;opacity:.5";

	// Make sure that element opacity exists
	// (IE uses filter instead)
	// Use a regex to work around a WebKit issue. See #5145
	support.opacity = /^0.5/.test( a.style.opacity );

	// Verify style float existence
	// (IE uses styleFloat instead of cssFloat)
	support.cssFloat = !!a.style.cssFloat;

	div.style.backgroundClip = "content-box";
	div.cloneNode( true ).style.backgroundClip = "";
	support.clearCloneStyle = div.style.backgroundClip === "content-box";

	// Null elements to avoid leaks in IE.
	a = div = null;

	jQuery.extend(support, {
		reliableHiddenOffsets: function() {
			if ( reliableHiddenOffsetsVal != null ) {
				return reliableHiddenOffsetsVal;
			}

			var container, tds, isSupported,
				div = document.createElement( "div" ),
				body = document.getElementsByTagName( "body" )[ 0 ];

			if ( !body ) {
				// Return for frameset docs that don't have a body
				return;
			}

			// Setup
			div.setAttribute( "className", "t" );
			div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";

			container = document.createElement( "div" );
			container.style.cssText = containerStyles;

			body.appendChild( container ).appendChild( div );

			// Support: IE8
			// Check if table cells still have offsetWidth/Height when they are set
			// to display:none and there are still other visible table cells in a
			// table row; if so, offsetWidth/Height are not reliable for use when
			// determining if an element has been hidden directly using
			// display:none (it is still safe to use offsets if a parent element is
			// hidden; don safety goggles and see bug #4512 for more information).
			div.innerHTML = "<table><tr><td></td><td>t</td></tr></table>";
			tds = div.getElementsByTagName( "td" );
			tds[ 0 ].style.cssText = "padding:0;margin:0;border:0;display:none";
			isSupported = ( tds[ 0 ].offsetHeight === 0 );

			tds[ 0 ].style.display = "";
			tds[ 1 ].style.display = "none";

			// Support: IE8
			// Check if empty table cells still have offsetWidth/Height
			reliableHiddenOffsetsVal = isSupported && ( tds[ 0 ].offsetHeight === 0 );

			body.removeChild( container );

			// Null elements to avoid leaks in IE.
			div = body = null;

			return reliableHiddenOffsetsVal;
		},

		boxSizing: function() {
			if ( boxSizingVal == null ) {
				computeStyleTests();
			}
			return boxSizingVal;
		},

		boxSizingReliable: function() {
			if ( boxSizingReliableVal == null ) {
				computeStyleTests();
			}
			return boxSizingReliableVal;
		},

		pixelPosition: function() {
			if ( pixelPositionVal == null ) {
				computeStyleTests();
			}
			return pixelPositionVal;
		},

		reliableMarginRight: function() {
			var body, container, div, marginDiv;

			// Use window.getComputedStyle because jsdom on node.js will break without it.
			if ( reliableMarginRightVal == null && window.getComputedStyle ) {
				body = document.getElementsByTagName( "body" )[ 0 ];
				if ( !body ) {
					// Test fired too early or in an unsupported environment, exit.
					return;
				}

				container = document.createElement( "div" );
				div = document.createElement( "div" );
				container.style.cssText = containerStyles;

				body.appendChild( container ).appendChild( div );

				// Check if div with explicit width and no margin-right incorrectly
				// gets computed margin-right based on width of container. (#3333)
				// Fails in WebKit before Feb 2011 nightlies
				// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
				marginDiv = div.appendChild( document.createElement( "div" ) );
				marginDiv.style.cssText = div.style.cssText = divReset;
				marginDiv.style.marginRight = marginDiv.style.width = "0";
				div.style.width = "1px";

				reliableMarginRightVal =
					!parseFloat( ( window.getComputedStyle( marginDiv, null ) || {} ).marginRight );

				body.removeChild( container );
			}

			return reliableMarginRightVal;
		}
	});

	function computeStyleTests() {
		var container, div,
			body = document.getElementsByTagName( "body" )[ 0 ];

		if ( !body ) {
			// Test fired too early or in an unsupported environment, exit.
			return;
		}

		container = document.createElement( "div" );
		div = document.createElement( "div" );
		container.style.cssText = containerStyles;

		body.appendChild( container ).appendChild( div );

		div.style.cssText =
			"-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;" +
				"position:absolute;display:block;padding:1px;border:1px;width:4px;" +
				"margin-top:1%;top:1%";

		// Workaround failing boxSizing test due to offsetWidth returning wrong value
		// with some non-1 values of body zoom, ticket #13543
		jQuery.swap( body, body.style.zoom != null ? { zoom: 1 } : {}, function() {
			boxSizingVal = div.offsetWidth === 4;
		});

		// Will be changed later if needed.
		boxSizingReliableVal = true;
		pixelPositionVal = false;
		reliableMarginRightVal = true;

		// Use window.getComputedStyle because jsdom on node.js will break without it.
		if ( window.getComputedStyle ) {
			pixelPositionVal = ( window.getComputedStyle( div, null ) || {} ).top !== "1%";
			boxSizingReliableVal =
				( window.getComputedStyle( div, null ) || { width: "4px" } ).width === "4px";
		}

		body.removeChild( container );

		// Null elements to avoid leaks in IE.
		div = body = null;
	}

})();


// A method for quickly swapping in/out CSS properties to get correct calculations.
jQuery.swap = function( elem, options, callback, args ) {
	var ret, name,
		old = {};

	// Remember the old values, and insert the new ones
	for ( name in options ) {
		old[ name ] = elem.style[ name ];
		elem.style[ name ] = options[ name ];
	}

	ret = callback.apply( elem, args || [] );

	// Revert the old values
	for ( name in options ) {
		elem.style[ name ] = old[ name ];
	}

	return ret;
};


var
		ralpha = /alpha\([^)]*\)/i,
	ropacity = /opacity\s*=\s*([^)]*)/,

	// swappable if display is none or starts with table except "table", "table-cell", or "table-caption"
	// see here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,
	rnumsplit = new RegExp( "^(" + pnum + ")(.*)$", "i" ),
	rrelNum = new RegExp( "^([+-])=(" + pnum + ")", "i" ),

	cssShow = { position: "absolute", visibility: "hidden", display: "block" },
	cssNormalTransform = {
		letterSpacing: 0,
		fontWeight: 400
	},

	cssPrefixes = [ "Webkit", "O", "Moz", "ms" ];


// return a css property mapped to a potentially vendor prefixed property
function vendorPropName( style, name ) {

	// shortcut for names that are not vendor prefixed
	if ( name in style ) {
		return name;
	}

	// check for vendor prefixed names
	var capName = name.charAt(0).toUpperCase() + name.slice(1),
		origName = name,
		i = cssPrefixes.length;

	while ( i-- ) {
		name = cssPrefixes[ i ] + capName;
		if ( name in style ) {
			return name;
		}
	}

	return origName;
}

function showHide( elements, show ) {
	var display, elem, hidden,
		values = [],
		index = 0,
		length = elements.length;

	for ( ; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}

		values[ index ] = jQuery._data( elem, "olddisplay" );
		display = elem.style.display;
		if ( show ) {
			// Reset the inline display of this element to learn if it is
			// being hidden by cascaded rules or not
			if ( !values[ index ] && display === "none" ) {
				elem.style.display = "";
			}

			// Set elements which have been overridden with display: none
			// in a stylesheet to whatever the default browser style is
			// for such an element
			if ( elem.style.display === "" && isHidden( elem ) ) {
				values[ index ] = jQuery._data( elem, "olddisplay", defaultDisplay(elem.nodeName) );
			}
		} else {

			if ( !values[ index ] ) {
				hidden = isHidden( elem );

				if ( display && display !== "none" || !hidden ) {
					jQuery._data( elem, "olddisplay", hidden ? display : jQuery.css( elem, "display" ) );
				}
			}
		}
	}

	// Set the display of most of the elements in a second loop
	// to avoid the constant reflow
	for ( index = 0; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}
		if ( !show || elem.style.display === "none" || elem.style.display === "" ) {
			elem.style.display = show ? values[ index ] || "" : "none";
		}
	}

	return elements;
}

function setPositiveNumber( elem, value, subtract ) {
	var matches = rnumsplit.exec( value );
	return matches ?
		// Guard against undefined "subtract", e.g., when used as in cssHooks
		Math.max( 0, matches[ 1 ] - ( subtract || 0 ) ) + ( matches[ 2 ] || "px" ) :
		value;
}

function augmentWidthOrHeight( elem, name, extra, isBorderBox, styles ) {
	var i = extra === ( isBorderBox ? "border" : "content" ) ?
		// If we already have the right measurement, avoid augmentation
		4 :
		// Otherwise initialize for horizontal or vertical properties
		name === "width" ? 1 : 0,

		val = 0;

	for ( ; i < 4; i += 2 ) {
		// both box models exclude margin, so add it if we want it
		if ( extra === "margin" ) {
			val += jQuery.css( elem, extra + cssExpand[ i ], true, styles );
		}

		if ( isBorderBox ) {
			// border-box includes padding, so remove it if we want content
			if ( extra === "content" ) {
				val -= jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );
			}

			// at this point, extra isn't border nor margin, so remove border
			if ( extra !== "margin" ) {
				val -= jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}
		} else {
			// at this point, extra isn't content, so add padding
			val += jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );

			// at this point, extra isn't content nor padding, so add border
			if ( extra !== "padding" ) {
				val += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}
		}
	}

	return val;
}

function getWidthOrHeight( elem, name, extra ) {

	// Start with offset property, which is equivalent to the border-box value
	var valueIsBorderBox = true,
		val = name === "width" ? elem.offsetWidth : elem.offsetHeight,
		styles = getStyles( elem ),
		isBorderBox = support.boxSizing() && jQuery.css( elem, "boxSizing", false, styles ) === "border-box";

	// some non-html elements return undefined for offsetWidth, so check for null/undefined
	// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285
	// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668
	if ( val <= 0 || val == null ) {
		// Fall back to computed then uncomputed css if necessary
		val = curCSS( elem, name, styles );
		if ( val < 0 || val == null ) {
			val = elem.style[ name ];
		}

		// Computed unit is not pixels. Stop here and return.
		if ( rnumnonpx.test(val) ) {
			return val;
		}

		// we need the check for style in case a browser which returns unreliable values
		// for getComputedStyle silently falls back to the reliable elem.style
		valueIsBorderBox = isBorderBox && ( support.boxSizingReliable() || val === elem.style[ name ] );

		// Normalize "", auto, and prepare for extra
		val = parseFloat( val ) || 0;
	}

	// use the active box-sizing model to add/subtract irrelevant styles
	return ( val +
		augmentWidthOrHeight(
			elem,
			name,
			extra || ( isBorderBox ? "border" : "content" ),
			valueIsBorderBox,
			styles
		)
	) + "px";
}

jQuery.extend({
	// Add in style property hooks for overriding the default
	// behavior of getting and setting a style property
	cssHooks: {
		opacity: {
			get: function( elem, computed ) {
				if ( computed ) {
					// We should always get a number back from opacity
					var ret = curCSS( elem, "opacity" );
					return ret === "" ? "1" : ret;
				}
			}
		}
	},

	// Don't automatically add "px" to these possibly-unitless properties
	cssNumber: {
		"columnCount": true,
		"fillOpacity": true,
		"fontWeight": true,
		"lineHeight": true,
		"opacity": true,
		"order": true,
		"orphans": true,
		"widows": true,
		"zIndex": true,
		"zoom": true
	},

	// Add in properties whose names you wish to fix before
	// setting or getting the value
	cssProps: {
		// normalize float css property
		"float": support.cssFloat ? "cssFloat" : "styleFloat"
	},

	// Get and set the style property on a DOM Node
	style: function( elem, name, value, extra ) {
		// Don't set styles on text and comment nodes
		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
			return;
		}

		// Make sure that we're working with the right name
		var ret, type, hooks,
			origName = jQuery.camelCase( name ),
			style = elem.style;

		name = jQuery.cssProps[ origName ] || ( jQuery.cssProps[ origName ] = vendorPropName( style, origName ) );

		// gets hook for the prefixed version
		// followed by the unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// Check if we're setting a value
		if ( value !== undefined ) {
			type = typeof value;

			// convert relative number strings (+= or -=) to relative numbers. #7345
			if ( type === "string" && (ret = rrelNum.exec( value )) ) {
				value = ( ret[1] + 1 ) * ret[2] + parseFloat( jQuery.css( elem, name ) );
				// Fixes bug #9237
				type = "number";
			}

			// Make sure that null and NaN values aren't set. See: #7116
			if ( value == null || value !== value ) {
				return;
			}

			// If a number was passed in, add 'px' to the (except for certain CSS properties)
			if ( type === "number" && !jQuery.cssNumber[ origName ] ) {
				value += "px";
			}

			// Fixes #8908, it can be done more correctly by specifing setters in cssHooks,
			// but it would mean to define eight (for every problematic property) identical functions
			if ( !support.clearCloneStyle && value === "" && name.indexOf("background") === 0 ) {
				style[ name ] = "inherit";
			}

			// If a hook was provided, use that value, otherwise just set the specified value
			if ( !hooks || !("set" in hooks) || (value = hooks.set( elem, value, extra )) !== undefined ) {

				// Support: IE
				// Swallow errors from 'invalid' CSS values (#5509)
				try {
					// Support: Chrome, Safari
					// Setting style to blank string required to delete "style: x !important;"
					style[ name ] = "";
					style[ name ] = value;
				} catch(e) {}
			}

		} else {
			// If a hook was provided get the non-computed value from there
			if ( hooks && "get" in hooks && (ret = hooks.get( elem, false, extra )) !== undefined ) {
				return ret;
			}

			// Otherwise just get the value from the style object
			return style[ name ];
		}
	},

	css: function( elem, name, extra, styles ) {
		var num, val, hooks,
			origName = jQuery.camelCase( name );

		// Make sure that we're working with the right name
		name = jQuery.cssProps[ origName ] || ( jQuery.cssProps[ origName ] = vendorPropName( elem.style, origName ) );

		// gets hook for the prefixed version
		// followed by the unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// If a hook was provided get the computed value from there
		if ( hooks && "get" in hooks ) {
			val = hooks.get( elem, true, extra );
		}

		// Otherwise, if a way to get the computed value exists, use that
		if ( val === undefined ) {
			val = curCSS( elem, name, styles );
		}

		//convert "normal" to computed value
		if ( val === "normal" && name in cssNormalTransform ) {
			val = cssNormalTransform[ name ];
		}

		// Return, converting to number if forced or a qualifier was provided and val looks numeric
		if ( extra === "" || extra ) {
			num = parseFloat( val );
			return extra === true || jQuery.isNumeric( num ) ? num || 0 : val;
		}
		return val;
	}
});

jQuery.each([ "height", "width" ], function( i, name ) {
	jQuery.cssHooks[ name ] = {
		get: function( elem, computed, extra ) {
			if ( computed ) {
				// certain elements can have dimension info if we invisibly show them
				// however, it must have a current display style that would benefit from this
				return elem.offsetWidth === 0 && rdisplayswap.test( jQuery.css( elem, "display" ) ) ?
					jQuery.swap( elem, cssShow, function() {
						return getWidthOrHeight( elem, name, extra );
					}) :
					getWidthOrHeight( elem, name, extra );
			}
		},

		set: function( elem, value, extra ) {
			var styles = extra && getStyles( elem );
			return setPositiveNumber( elem, value, extra ?
				augmentWidthOrHeight(
					elem,
					name,
					extra,
					support.boxSizing() && jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
					styles
				) : 0
			);
		}
	};
});

if ( !support.opacity ) {
	jQuery.cssHooks.opacity = {
		get: function( elem, computed ) {
			// IE uses filters for opacity
			return ropacity.test( (computed && elem.currentStyle ? elem.currentStyle.filter : elem.style.filter) || "" ) ?
				( 0.01 * parseFloat( RegExp.$1 ) ) + "" :
				computed ? "1" : "";
		},

		set: function( elem, value ) {
			var style = elem.style,
				currentStyle = elem.currentStyle,
				opacity = jQuery.isNumeric( value ) ? "alpha(opacity=" + value * 100 + ")" : "",
				filter = currentStyle && currentStyle.filter || style.filter || "";

			// IE has trouble with opacity if it does not have layout
			// Force it by setting the zoom level
			style.zoom = 1;

			// if setting opacity to 1, and no other filters exist - attempt to remove filter attribute #6652
			// if value === "", then remove inline opacity #12685
			if ( ( value >= 1 || value === "" ) &&
					jQuery.trim( filter.replace( ralpha, "" ) ) === "" &&
					style.removeAttribute ) {

				// Setting style.filter to null, "" & " " still leave "filter:" in the cssText
				// if "filter:" is present at all, clearType is disabled, we want to avoid this
				// style.removeAttribute is IE Only, but so apparently is this code path...
				style.removeAttribute( "filter" );

				// if there is no filter style applied in a css rule or unset inline opacity, we are done
				if ( value === "" || currentStyle && !currentStyle.filter ) {
					return;
				}
			}

			// otherwise, set new filter values
			style.filter = ralpha.test( filter ) ?
				filter.replace( ralpha, opacity ) :
				filter + " " + opacity;
		}
	};
}

jQuery.cssHooks.marginRight = addGetHookIf( support.reliableMarginRight,
	function( elem, computed ) {
		if ( computed ) {
			// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
			// Work around by temporarily setting element display to inline-block
			return jQuery.swap( elem, { "display": "inline-block" },
				curCSS, [ elem, "marginRight" ] );
		}
	}
);

// These hooks are used by animate to expand properties
jQuery.each({
	margin: "",
	padding: "",
	border: "Width"
}, function( prefix, suffix ) {
	jQuery.cssHooks[ prefix + suffix ] = {
		expand: function( value ) {
			var i = 0,
				expanded = {},

				// assumes a single number if not a string
				parts = typeof value === "string" ? value.split(" ") : [ value ];

			for ( ; i < 4; i++ ) {
				expanded[ prefix + cssExpand[ i ] + suffix ] =
					parts[ i ] || parts[ i - 2 ] || parts[ 0 ];
			}

			return expanded;
		}
	};

	if ( !rmargin.test( prefix ) ) {
		jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;
	}
});

jQuery.fn.extend({
	css: function( name, value ) {
		return access( this, function( elem, name, value ) {
			var styles, len,
				map = {},
				i = 0;

			if ( jQuery.isArray( name ) ) {
				styles = getStyles( elem );
				len = name.length;

				for ( ; i < len; i++ ) {
					map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );
				}

				return map;
			}

			return value !== undefined ?
				jQuery.style( elem, name, value ) :
				jQuery.css( elem, name );
		}, name, value, arguments.length > 1 );
	},
	show: function() {
		return showHide( this, true );
	},
	hide: function() {
		return showHide( this );
	},
	toggle: function( state ) {
		if ( typeof state === "boolean" ) {
			return state ? this.show() : this.hide();
		}

		return this.each(function() {
			if ( isHidden( this ) ) {
				jQuery( this ).show();
			} else {
				jQuery( this ).hide();
			}
		});
	}
});


function Tween( elem, options, prop, end, easing ) {
	return new Tween.prototype.init( elem, options, prop, end, easing );
}
jQuery.Tween = Tween;

Tween.prototype = {
	constructor: Tween,
	init: function( elem, options, prop, end, easing, unit ) {
		this.elem = elem;
		this.prop = prop;
		this.easing = easing || "swing";
		this.options = options;
		this.start = this.now = this.cur();
		this.end = end;
		this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );
	},
	cur: function() {
		var hooks = Tween.propHooks[ this.prop ];

		return hooks && hooks.get ?
			hooks.get( this ) :
			Tween.propHooks._default.get( this );
	},
	run: function( percent ) {
		var eased,
			hooks = Tween.propHooks[ this.prop ];

		if ( this.options.duration ) {
			this.pos = eased = jQuery.easing[ this.easing ](
				percent, this.options.duration * percent, 0, 1, this.options.duration
			);
		} else {
			this.pos = eased = percent;
		}
		this.now = ( this.end - this.start ) * eased + this.start;

		if ( this.options.step ) {
			this.options.step.call( this.elem, this.now, this );
		}

		if ( hooks && hooks.set ) {
			hooks.set( this );
		} else {
			Tween.propHooks._default.set( this );
		}
		return this;
	}
};

Tween.prototype.init.prototype = Tween.prototype;

Tween.propHooks = {
	_default: {
		get: function( tween ) {
			var result;

			if ( tween.elem[ tween.prop ] != null &&
				(!tween.elem.style || tween.elem.style[ tween.prop ] == null) ) {
				return tween.elem[ tween.prop ];
			}

			// passing an empty string as a 3rd parameter to .css will automatically
			// attempt a parseFloat and fallback to a string if the parse fails
			// so, simple values such as "10px" are parsed to Float.
			// complex values such as "rotate(1rad)" are returned as is.
			result = jQuery.css( tween.elem, tween.prop, "" );
			// Empty strings, null, undefined and "auto" are converted to 0.
			return !result || result === "auto" ? 0 : result;
		},
		set: function( tween ) {
			// use step hook for back compat - use cssHook if its there - use .style if its
			// available and use plain properties where available
			if ( jQuery.fx.step[ tween.prop ] ) {
				jQuery.fx.step[ tween.prop ]( tween );
			} else if ( tween.elem.style && ( tween.elem.style[ jQuery.cssProps[ tween.prop ] ] != null || jQuery.cssHooks[ tween.prop ] ) ) {
				jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );
			} else {
				tween.elem[ tween.prop ] = tween.now;
			}
		}
	}
};

// Support: IE <=9
// Panic based approach to setting things on disconnected nodes

Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
	set: function( tween ) {
		if ( tween.elem.nodeType && tween.elem.parentNode ) {
			tween.elem[ tween.prop ] = tween.now;
		}
	}
};

jQuery.easing = {
	linear: function( p ) {
		return p;
	},
	swing: function( p ) {
		return 0.5 - Math.cos( p * Math.PI ) / 2;
	}
};

jQuery.fx = Tween.prototype.init;

// Back Compat <1.8 extension point
jQuery.fx.step = {};




var
	fxNow, timerId,
	rfxtypes = /^(?:toggle|show|hide)$/,
	rfxnum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" ),
	rrun = /queueHooks$/,
	animationPrefilters = [ defaultPrefilter ],
	tweeners = {
		"*": [ function( prop, value ) {
			var tween = this.createTween( prop, value ),
				target = tween.cur(),
				parts = rfxnum.exec( value ),
				unit = parts && parts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),

				// Starting value computation is required for potential unit mismatches
				start = ( jQuery.cssNumber[ prop ] || unit !== "px" && +target ) &&
					rfxnum.exec( jQuery.css( tween.elem, prop ) ),
				scale = 1,
				maxIterations = 20;

			if ( start && start[ 3 ] !== unit ) {
				// Trust units reported by jQuery.css
				unit = unit || start[ 3 ];

				// Make sure we update the tween properties later on
				parts = parts || [];

				// Iteratively approximate from a nonzero starting point
				start = +target || 1;

				do {
					// If previous iteration zeroed out, double until we get *something*
					// Use a string for doubling factor so we don't accidentally see scale as unchanged below
					scale = scale || ".5";

					// Adjust and apply
					start = start / scale;
					jQuery.style( tween.elem, prop, start + unit );

				// Update scale, tolerating zero or NaN from tween.cur()
				// And breaking the loop if scale is unchanged or perfect, or if we've just had enough
				} while ( scale !== (scale = tween.cur() / target) && scale !== 1 && --maxIterations );
			}

			// Update tween properties
			if ( parts ) {
				start = tween.start = +start || +target || 0;
				tween.unit = unit;
				// If a +=/-= token was provided, we're doing a relative animation
				tween.end = parts[ 1 ] ?
					start + ( parts[ 1 ] + 1 ) * parts[ 2 ] :
					+parts[ 2 ];
			}

			return tween;
		} ]
	};

// Animations created synchronously will run synchronously
function createFxNow() {
	setTimeout(function() {
		fxNow = undefined;
	});
	return ( fxNow = jQuery.now() );
}

// Generate parameters to create a standard animation
function genFx( type, includeWidth ) {
	var which,
		attrs = { height: type },
		i = 0;

	// if we include width, step value is 1 to do all cssExpand values,
	// if we don't include width, step value is 2 to skip over Left and Right
	includeWidth = includeWidth ? 1 : 0;
	for ( ; i < 4 ; i += 2 - includeWidth ) {
		which = cssExpand[ i ];
		attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;
	}

	if ( includeWidth ) {
		attrs.opacity = attrs.width = type;
	}

	return attrs;
}

function createTween( value, prop, animation ) {
	var tween,
		collection = ( tweeners[ prop ] || [] ).concat( tweeners[ "*" ] ),
		index = 0,
		length = collection.length;
	for ( ; index < length; index++ ) {
		if ( (tween = collection[ index ].call( animation, prop, value )) ) {

			// we're done with this property
			return tween;
		}
	}
}

function defaultPrefilter( elem, props, opts ) {
	/* jshint validthis: true */
	var prop, value, toggle, tween, hooks, oldfire, display, dDisplay,
		anim = this,
		orig = {},
		style = elem.style,
		hidden = elem.nodeType && isHidden( elem ),
		dataShow = jQuery._data( elem, "fxshow" );

	// handle queue: false promises
	if ( !opts.queue ) {
		hooks = jQuery._queueHooks( elem, "fx" );
		if ( hooks.unqueued == null ) {
			hooks.unqueued = 0;
			oldfire = hooks.empty.fire;
			hooks.empty.fire = function() {
				if ( !hooks.unqueued ) {
					oldfire();
				}
			};
		}
		hooks.unqueued++;

		anim.always(function() {
			// doing this makes sure that the complete handler will be called
			// before this completes
			anim.always(function() {
				hooks.unqueued--;
				if ( !jQuery.queue( elem, "fx" ).length ) {
					hooks.empty.fire();
				}
			});
		});
	}

	// height/width overflow pass
	if ( elem.nodeType === 1 && ( "height" in props || "width" in props ) ) {
		// Make sure that nothing sneaks out
		// Record all 3 overflow attributes because IE does not
		// change the overflow attribute when overflowX and
		// overflowY are set to the same value
		opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];

		// Set display property to inline-block for height/width
		// animations on inline elements that are having width/height animated
		display = jQuery.css( elem, "display" );
		dDisplay = defaultDisplay( elem.nodeName );
		if ( display === "none" ) {
			display = dDisplay;
		}
		if ( display === "inline" &&
				jQuery.css( elem, "float" ) === "none" ) {

			// inline-level elements accept inline-block;
			// block-level elements need to be inline with layout
			if ( !support.inlineBlockNeedsLayout || dDisplay === "inline" ) {
				style.display = "inline-block";
			} else {
				style.zoom = 1;
			}
		}
	}

	if ( opts.overflow ) {
		style.overflow = "hidden";
		if ( !support.shrinkWrapBlocks() ) {
			anim.always(function() {
				style.overflow = opts.overflow[ 0 ];
				style.overflowX = opts.overflow[ 1 ];
				style.overflowY = opts.overflow[ 2 ];
			});
		}
	}

	// show/hide pass
	for ( prop in props ) {
		value = props[ prop ];
		if ( rfxtypes.exec( value ) ) {
			delete props[ prop ];
			toggle = toggle || value === "toggle";
			if ( value === ( hidden ? "hide" : "show" ) ) {

				// If there is dataShow left over from a stopped hide or show and we are going to proceed with show, we should pretend to be hidden
				if ( value === "show" && dataShow && dataShow[ prop ] !== undefined ) {
					hidden = true;
				} else {
					continue;
				}
			}
			orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );
		}
	}

	if ( !jQuery.isEmptyObject( orig ) ) {
		if ( dataShow ) {
			if ( "hidden" in dataShow ) {
				hidden = dataShow.hidden;
			}
		} else {
			dataShow = jQuery._data( elem, "fxshow", {} );
		}

		// store state if its toggle - enables .stop().toggle() to "reverse"
		if ( toggle ) {
			dataShow.hidden = !hidden;
		}
		if ( hidden ) {
			jQuery( elem ).show();
		} else {
			anim.done(function() {
				jQuery( elem ).hide();
			});
		}
		anim.done(function() {
			var prop;
			jQuery._removeData( elem, "fxshow" );
			for ( prop in orig ) {
				jQuery.style( elem, prop, orig[ prop ] );
			}
		});
		for ( prop in orig ) {
			tween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );

			if ( !( prop in dataShow ) ) {
				dataShow[ prop ] = tween.start;
				if ( hidden ) {
					tween.end = tween.start;
					tween.start = prop === "width" || prop === "height" ? 1 : 0;
				}
			}
		}
	}
}

function propFilter( props, specialEasing ) {
	var index, name, easing, value, hooks;

	// camelCase, specialEasing and expand cssHook pass
	for ( index in props ) {
		name = jQuery.camelCase( index );
		easing = specialEasing[ name ];
		value = props[ index ];
		if ( jQuery.isArray( value ) ) {
			easing = value[ 1 ];
			value = props[ index ] = value[ 0 ];
		}

		if ( index !== name ) {
			props[ name ] = value;
			delete props[ index ];
		}

		hooks = jQuery.cssHooks[ name ];
		if ( hooks && "expand" in hooks ) {
			value = hooks.expand( value );
			delete props[ name ];

			// not quite $.extend, this wont overwrite keys already present.
			// also - reusing 'index' from above because we have the correct "name"
			for ( index in value ) {
				if ( !( index in props ) ) {
					props[ index ] = value[ index ];
					specialEasing[ index ] = easing;
				}
			}
		} else {
			specialEasing[ name ] = easing;
		}
	}
}

function Animation( elem, properties, options ) {
	var result,
		stopped,
		index = 0,
		length = animationPrefilters.length,
		deferred = jQuery.Deferred().always( function() {
			// don't match elem in the :animated selector
			delete tick.elem;
		}),
		tick = function() {
			if ( stopped ) {
				return false;
			}
			var currentTime = fxNow || createFxNow(),
				remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),
				// archaic crash bug won't allow us to use 1 - ( 0.5 || 0 ) (#12497)
				temp = remaining / animation.duration || 0,
				percent = 1 - temp,
				index = 0,
				length = animation.tweens.length;

			for ( ; index < length ; index++ ) {
				animation.tweens[ index ].run( percent );
			}

			deferred.notifyWith( elem, [ animation, percent, remaining ]);

			if ( percent < 1 && length ) {
				return remaining;
			} else {
				deferred.resolveWith( elem, [ animation ] );
				return false;
			}
		},
		animation = deferred.promise({
			elem: elem,
			props: jQuery.extend( {}, properties ),
			opts: jQuery.extend( true, { specialEasing: {} }, options ),
			originalProperties: properties,
			originalOptions: options,
			startTime: fxNow || createFxNow(),
			duration: options.duration,
			tweens: [],
			createTween: function( prop, end ) {
				var tween = jQuery.Tween( elem, animation.opts, prop, end,
						animation.opts.specialEasing[ prop ] || animation.opts.easing );
				animation.tweens.push( tween );
				return tween;
			},
			stop: function( gotoEnd ) {
				var index = 0,
					// if we are going to the end, we want to run all the tweens
					// otherwise we skip this part
					length = gotoEnd ? animation.tweens.length : 0;
				if ( stopped ) {
					return this;
				}
				stopped = true;
				for ( ; index < length ; index++ ) {
					animation.tweens[ index ].run( 1 );
				}

				// resolve when we played the last frame
				// otherwise, reject
				if ( gotoEnd ) {
					deferred.resolveWith( elem, [ animation, gotoEnd ] );
				} else {
					deferred.rejectWith( elem, [ animation, gotoEnd ] );
				}
				return this;
			}
		}),
		props = animation.props;

	propFilter( props, animation.opts.specialEasing );

	for ( ; index < length ; index++ ) {
		result = animationPrefilters[ index ].call( animation, elem, props, animation.opts );
		if ( result ) {
			return result;
		}
	}

	jQuery.map( props, createTween, animation );

	if ( jQuery.isFunction( animation.opts.start ) ) {
		animation.opts.start.call( elem, animation );
	}

	jQuery.fx.timer(
		jQuery.extend( tick, {
			elem: elem,
			anim: animation,
			queue: animation.opts.queue
		})
	);

	// attach callbacks from options
	return animation.progress( animation.opts.progress )
		.done( animation.opts.done, animation.opts.complete )
		.fail( animation.opts.fail )
		.always( animation.opts.always );
}

jQuery.Animation = jQuery.extend( Animation, {
	tweener: function( props, callback ) {
		if ( jQuery.isFunction( props ) ) {
			callback = props;
			props = [ "*" ];
		} else {
			props = props.split(" ");
		}

		var prop,
			index = 0,
			length = props.length;

		for ( ; index < length ; index++ ) {
			prop = props[ index ];
			tweeners[ prop ] = tweeners[ prop ] || [];
			tweeners[ prop ].unshift( callback );
		}
	},

	prefilter: function( callback, prepend ) {
		if ( prepend ) {
			animationPrefilters.unshift( callback );
		} else {
			animationPrefilters.push( callback );
		}
	}
});

jQuery.speed = function( speed, easing, fn ) {
	var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {
		complete: fn || !fn && easing ||
			jQuery.isFunction( speed ) && speed,
		duration: speed,
		easing: fn && easing || easing && !jQuery.isFunction( easing ) && easing
	};

	opt.duration = jQuery.fx.off ? 0 : typeof opt.duration === "number" ? opt.duration :
		opt.duration in jQuery.fx.speeds ? jQuery.fx.speeds[ opt.duration ] : jQuery.fx.speeds._default;

	// normalize opt.queue - true/undefined/null -> "fx"
	if ( opt.queue == null || opt.queue === true ) {
		opt.queue = "fx";
	}

	// Queueing
	opt.old = opt.complete;

	opt.complete = function() {
		if ( jQuery.isFunction( opt.old ) ) {
			opt.old.call( this );
		}

		if ( opt.queue ) {
			jQuery.dequeue( this, opt.queue );
		}
	};

	return opt;
};

jQuery.fn.extend({
	fadeTo: function( speed, to, easing, callback ) {

		// show any hidden elements after setting opacity to 0
		return this.filter( isHidden ).css( "opacity", 0 ).show()

			// animate to the value specified
			.end().animate({ opacity: to }, speed, easing, callback );
	},
	animate: function( prop, speed, easing, callback ) {
		var empty = jQuery.isEmptyObject( prop ),
			optall = jQuery.speed( speed, easing, callback ),
			doAnimation = function() {
				// Operate on a copy of prop so per-property easing won't be lost
				var anim = Animation( this, jQuery.extend( {}, prop ), optall );

				// Empty animations, or finishing resolves immediately
				if ( empty || jQuery._data( this, "finish" ) ) {
					anim.stop( true );
				}
			};
			doAnimation.finish = doAnimation;

		return empty || optall.queue === false ?
			this.each( doAnimation ) :
			this.queue( optall.queue, doAnimation );
	},
	stop: function( type, clearQueue, gotoEnd ) {
		var stopQueue = function( hooks ) {
			var stop = hooks.stop;
			delete hooks.stop;
			stop( gotoEnd );
		};

		if ( typeof type !== "string" ) {
			gotoEnd = clearQueue;
			clearQueue = type;
			type = undefined;
		}
		if ( clearQueue && type !== false ) {
			this.queue( type || "fx", [] );
		}

		return this.each(function() {
			var dequeue = true,
				index = type != null && type + "queueHooks",
				timers = jQuery.timers,
				data = jQuery._data( this );

			if ( index ) {
				if ( data[ index ] && data[ index ].stop ) {
					stopQueue( data[ index ] );
				}
			} else {
				for ( index in data ) {
					if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {
						stopQueue( data[ index ] );
					}
				}
			}

			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this && (type == null || timers[ index ].queue === type) ) {
					timers[ index ].anim.stop( gotoEnd );
					dequeue = false;
					timers.splice( index, 1 );
				}
			}

			// start the next in the queue if the last step wasn't forced
			// timers currently will call their complete callbacks, which will dequeue
			// but only if they were gotoEnd
			if ( dequeue || !gotoEnd ) {
				jQuery.dequeue( this, type );
			}
		});
	},
	finish: function( type ) {
		if ( type !== false ) {
			type = type || "fx";
		}
		return this.each(function() {
			var index,
				data = jQuery._data( this ),
				queue = data[ type + "queue" ],
				hooks = data[ type + "queueHooks" ],
				timers = jQuery.timers,
				length = queue ? queue.length : 0;

			// enable finishing flag on private data
			data.finish = true;

			// empty the queue first
			jQuery.queue( this, type, [] );

			if ( hooks && hooks.stop ) {
				hooks.stop.call( this, true );
			}

			// look for any active animations, and finish them
			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this && timers[ index ].queue === type ) {
					timers[ index ].anim.stop( true );
					timers.splice( index, 1 );
				}
			}

			// look for any animations in the old queue and finish them
			for ( index = 0; index < length; index++ ) {
				if ( queue[ index ] && queue[ index ].finish ) {
					queue[ index ].finish.call( this );
				}
			}

			// turn off finishing flag
			delete data.finish;
		});
	}
});

jQuery.each([ "toggle", "show", "hide" ], function( i, name ) {
	var cssFn = jQuery.fn[ name ];
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return speed == null || typeof speed === "boolean" ?
			cssFn.apply( this, arguments ) :
			this.animate( genFx( name, true ), speed, easing, callback );
	};
});

// Generate shortcuts for custom animations
jQuery.each({
	slideDown: genFx("show"),
	slideUp: genFx("hide"),
	slideToggle: genFx("toggle"),
	fadeIn: { opacity: "show" },
	fadeOut: { opacity: "hide" },
	fadeToggle: { opacity: "toggle" }
}, function( name, props ) {
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return this.animate( props, speed, easing, callback );
	};
});

jQuery.timers = [];
jQuery.fx.tick = function() {
	var timer,
		timers = jQuery.timers,
		i = 0;

	fxNow = jQuery.now();

	for ( ; i < timers.length; i++ ) {
		timer = timers[ i ];
		// Checks the timer has not already been removed
		if ( !timer() && timers[ i ] === timer ) {
			timers.splice( i--, 1 );
		}
	}

	if ( !timers.length ) {
		jQuery.fx.stop();
	}
	fxNow = undefined;
};

jQuery.fx.timer = function( timer ) {
	jQuery.timers.push( timer );
	if ( timer() ) {
		jQuery.fx.start();
	} else {
		jQuery.timers.pop();
	}
};

jQuery.fx.interval = 13;

jQuery.fx.start = function() {
	if ( !timerId ) {
		timerId = setInterval( jQuery.fx.tick, jQuery.fx.interval );
	}
};

jQuery.fx.stop = function() {
	clearInterval( timerId );
	timerId = null;
};

jQuery.fx.speeds = {
	slow: 600,
	fast: 200,
	// Default speed
	_default: 400
};


// Based off of the plugin by Clint Helfers, with permission.
// http://blindsignals.com/index.php/2009/07/jquery-delay/
jQuery.fn.delay = function( time, type ) {
	time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;
	type = type || "fx";

	return this.queue( type, function( next, hooks ) {
		var timeout = setTimeout( next, time );
		hooks.stop = function() {
			clearTimeout( timeout );
		};
	});
};


(function() {
	var a, input, select, opt,
		div = document.createElement("div" );

	// Setup
	div.setAttribute( "className", "t" );
	div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";
	a = div.getElementsByTagName("a")[ 0 ];

	// First batch of tests.
	select = document.createElement("select");
	opt = select.appendChild( document.createElement("option") );
	input = div.getElementsByTagName("input")[ 0 ];

	a.style.cssText = "top:1px";

	// Test setAttribute on camelCase class. If it works, we need attrFixes when doing get/setAttribute (ie6/7)
	support.getSetAttribute = div.className !== "t";

	// Get the style information from getAttribute
	// (IE uses .cssText instead)
	support.style = /top/.test( a.getAttribute("style") );

	// Make sure that URLs aren't manipulated
	// (IE normalizes it by default)
	support.hrefNormalized = a.getAttribute("href") === "/a";

	// Check the default checkbox/radio value ("" on WebKit; "on" elsewhere)
	support.checkOn = !!input.value;

	// Make sure that a selected-by-default option has a working selected property.
	// (WebKit defaults to false instead of true, IE too, if it's in an optgroup)
	support.optSelected = opt.selected;

	// Tests for enctype support on a form (#6743)
	support.enctype = !!document.createElement("form").enctype;

	// Make sure that the options inside disabled selects aren't marked as disabled
	// (WebKit marks them as disabled)
	select.disabled = true;
	support.optDisabled = !opt.disabled;

	// Support: IE8 only
	// Check if we can trust getAttribute("value")
	input = document.createElement( "input" );
	input.setAttribute( "value", "" );
	support.input = input.getAttribute( "value" ) === "";

	// Check if an input maintains its value after becoming a radio
	input.value = "t";
	input.setAttribute( "type", "radio" );
	support.radioValue = input.value === "t";

	// Null elements to avoid leaks in IE.
	a = input = select = opt = div = null;
})();


var rreturn = /\r/g;

jQuery.fn.extend({
	val: function( value ) {
		var hooks, ret, isFunction,
			elem = this[0];

		if ( !arguments.length ) {
			if ( elem ) {
				hooks = jQuery.valHooks[ elem.type ] || jQuery.valHooks[ elem.nodeName.toLowerCase() ];

				if ( hooks && "get" in hooks && (ret = hooks.get( elem, "value" )) !== undefined ) {
					return ret;
				}

				ret = elem.value;

				return typeof ret === "string" ?
					// handle most common string cases
					ret.replace(rreturn, "") :
					// handle cases where value is null/undef or number
					ret == null ? "" : ret;
			}

			return;
		}

		isFunction = jQuery.isFunction( value );

		return this.each(function( i ) {
			var val;

			if ( this.nodeType !== 1 ) {
				return;
			}

			if ( isFunction ) {
				val = value.call( this, i, jQuery( this ).val() );
			} else {
				val = value;
			}

			// Treat null/undefined as ""; convert numbers to string
			if ( val == null ) {
				val = "";
			} else if ( typeof val === "number" ) {
				val += "";
			} else if ( jQuery.isArray( val ) ) {
				val = jQuery.map( val, function( value ) {
					return value == null ? "" : value + "";
				});
			}

			hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];

			// If set returns undefined, fall back to normal setting
			if ( !hooks || !("set" in hooks) || hooks.set( this, val, "value" ) === undefined ) {
				this.value = val;
			}
		});
	}
});

jQuery.extend({
	valHooks: {
		option: {
			get: function( elem ) {
				var val = jQuery.find.attr( elem, "value" );
				return val != null ?
					val :
					jQuery.text( elem );
			}
		},
		select: {
			get: function( elem ) {
				var value, option,
					options = elem.options,
					index = elem.selectedIndex,
					one = elem.type === "select-one" || index < 0,
					values = one ? null : [],
					max = one ? index + 1 : options.length,
					i = index < 0 ?
						max :
						one ? index : 0;

				// Loop through all the selected options
				for ( ; i < max; i++ ) {
					option = options[ i ];

					// oldIE doesn't update selected after form reset (#2551)
					if ( ( option.selected || i === index ) &&
							// Don't return options that are disabled or in a disabled optgroup
							( support.optDisabled ? !option.disabled : option.getAttribute("disabled") === null ) &&
							( !option.parentNode.disabled || !jQuery.nodeName( option.parentNode, "optgroup" ) ) ) {

						// Get the specific value for the option
						value = jQuery( option ).val();

						// We don't need an array for one selects
						if ( one ) {
							return value;
						}

						// Multi-Selects return an array
						values.push( value );
					}
				}

				return values;
			},

			set: function( elem, value ) {
				var optionSet, option,
					options = elem.options,
					values = jQuery.makeArray( value ),
					i = options.length;

				while ( i-- ) {
					option = options[ i ];

					if ( jQuery.inArray( jQuery.valHooks.option.get( option ), values ) >= 0 ) {

						// Support: IE6
						// When new option element is added to select box we need to
						// force reflow of newly added node in order to workaround delay
						// of initialization properties
						try {
							option.selected = optionSet = true;

						} catch ( _ ) {

							// Will be executed only in IE6
							option.scrollHeight;
						}

					} else {
						option.selected = false;
					}
				}

				// Force browsers to behave consistently when non-matching value is set
				if ( !optionSet ) {
					elem.selectedIndex = -1;
				}

				return options;
			}
		}
	}
});

// Radios and checkboxes getter/setter
jQuery.each([ "radio", "checkbox" ], function() {
	jQuery.valHooks[ this ] = {
		set: function( elem, value ) {
			if ( jQuery.isArray( value ) ) {
				return ( elem.checked = jQuery.inArray( jQuery(elem).val(), value ) >= 0 );
			}
		}
	};
	if ( !support.checkOn ) {
		jQuery.valHooks[ this ].get = function( elem ) {
			// Support: Webkit
			// "" is returned instead of "on" if a value isn't specified
			return elem.getAttribute("value") === null ? "on" : elem.value;
		};
	}
});




var nodeHook, boolHook,
	attrHandle = jQuery.expr.attrHandle,
	ruseDefault = /^(?:checked|selected)$/i,
	getSetAttribute = support.getSetAttribute,
	getSetInput = support.input;

jQuery.fn.extend({
	attr: function( name, value ) {
		return access( this, jQuery.attr, name, value, arguments.length > 1 );
	},

	removeAttr: function( name ) {
		return this.each(function() {
			jQuery.removeAttr( this, name );
		});
	}
});

jQuery.extend({
	attr: function( elem, name, value ) {
		var hooks, ret,
			nType = elem.nodeType;

		// don't get/set attributes on text, comment and attribute nodes
		if ( !elem || nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		// Fallback to prop when attributes are not supported
		if ( typeof elem.getAttribute === strundefined ) {
			return jQuery.prop( elem, name, value );
		}

		// All attributes are lowercase
		// Grab necessary hook if one is defined
		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {
			name = name.toLowerCase();
			hooks = jQuery.attrHooks[ name ] ||
				( jQuery.expr.match.bool.test( name ) ? boolHook : nodeHook );
		}

		if ( value !== undefined ) {

			if ( value === null ) {
				jQuery.removeAttr( elem, name );

			} else if ( hooks && "set" in hooks && (ret = hooks.set( elem, value, name )) !== undefined ) {
				return ret;

			} else {
				elem.setAttribute( name, value + "" );
				return value;
			}

		} else if ( hooks && "get" in hooks && (ret = hooks.get( elem, name )) !== null ) {
			return ret;

		} else {
			ret = jQuery.find.attr( elem, name );

			// Non-existent attributes return null, we normalize to undefined
			return ret == null ?
				undefined :
				ret;
		}
	},

	removeAttr: function( elem, value ) {
		var name, propName,
			i = 0,
			attrNames = value && value.match( rnotwhite );

		if ( attrNames && elem.nodeType === 1 ) {
			while ( (name = attrNames[i++]) ) {
				propName = jQuery.propFix[ name ] || name;

				// Boolean attributes get special treatment (#10870)
				if ( jQuery.expr.match.bool.test( name ) ) {
					// Set corresponding property to false
					if ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {
						elem[ propName ] = false;
					// Support: IE<9
					// Also clear defaultChecked/defaultSelected (if appropriate)
					} else {
						elem[ jQuery.camelCase( "default-" + name ) ] =
							elem[ propName ] = false;
					}

				// See #9699 for explanation of this approach (setting first, then removal)
				} else {
					jQuery.attr( elem, name, "" );
				}

				elem.removeAttribute( getSetAttribute ? name : propName );
			}
		}
	},

	attrHooks: {
		type: {
			set: function( elem, value ) {
				if ( !support.radioValue && value === "radio" && jQuery.nodeName(elem, "input") ) {
					// Setting the type on a radio button after the value resets the value in IE6-9
					// Reset value to default in case type is set after value during creation
					var val = elem.value;
					elem.setAttribute( "type", value );
					if ( val ) {
						elem.value = val;
					}
					return value;
				}
			}
		}
	}
});

// Hook for boolean attributes
boolHook = {
	set: function( elem, value, name ) {
		if ( value === false ) {
			// Remove boolean attributes when set to false
			jQuery.removeAttr( elem, name );
		} else if ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {
			// IE<8 needs the *property* name
			elem.setAttribute( !getSetAttribute && jQuery.propFix[ name ] || name, name );

		// Use defaultChecked and defaultSelected for oldIE
		} else {
			elem[ jQuery.camelCase( "default-" + name ) ] = elem[ name ] = true;
		}

		return name;
	}
};

// Retrieve booleans specially
jQuery.each( jQuery.expr.match.bool.source.match( /\w+/g ), function( i, name ) {

	var getter = attrHandle[ name ] || jQuery.find.attr;

	attrHandle[ name ] = getSetInput && getSetAttribute || !ruseDefault.test( name ) ?
		function( elem, name, isXML ) {
			var ret, handle;
			if ( !isXML ) {
				// Avoid an infinite loop by temporarily removing this function from the getter
				handle = attrHandle[ name ];
				attrHandle[ name ] = ret;
				ret = getter( elem, name, isXML ) != null ?
					name.toLowerCase() :
					null;
				attrHandle[ name ] = handle;
			}
			return ret;
		} :
		function( elem, name, isXML ) {
			if ( !isXML ) {
				return elem[ jQuery.camelCase( "default-" + name ) ] ?
					name.toLowerCase() :
					null;
			}
		};
});

// fix oldIE attroperties
if ( !getSetInput || !getSetAttribute ) {
	jQuery.attrHooks.value = {
		set: function( elem, value, name ) {
			if ( jQuery.nodeName( elem, "input" ) ) {
				// Does not return so that setAttribute is also used
				elem.defaultValue = value;
			} else {
				// Use nodeHook if defined (#1954); otherwise setAttribute is fine
				return nodeHook && nodeHook.set( elem, value, name );
			}
		}
	};
}

// IE6/7 do not support getting/setting some attributes with get/setAttribute
if ( !getSetAttribute ) {

	// Use this for any attribute in IE6/7
	// This fixes almost every IE6/7 issue
	nodeHook = {
		set: function( elem, value, name ) {
			// Set the existing or create a new attribute node
			var ret = elem.getAttributeNode( name );
			if ( !ret ) {
				elem.setAttributeNode(
					(ret = elem.ownerDocument.createAttribute( name ))
				);
			}

			ret.value = value += "";

			// Break association with cloned elements by also using setAttribute (#9646)
			if ( name === "value" || value === elem.getAttribute( name ) ) {
				return value;
			}
		}
	};

	// Some attributes are constructed with empty-string values when not defined
	attrHandle.id = attrHandle.name = attrHandle.coords =
		function( elem, name, isXML ) {
			var ret;
			if ( !isXML ) {
				return (ret = elem.getAttributeNode( name )) && ret.value !== "" ?
					ret.value :
					null;
			}
		};

	// Fixing value retrieval on a button requires this module
	jQuery.valHooks.button = {
		get: function( elem, name ) {
			var ret = elem.getAttributeNode( name );
			if ( ret && ret.specified ) {
				return ret.value;
			}
		},
		set: nodeHook.set
	};

	// Set contenteditable to false on removals(#10429)
	// Setting to empty string throws an error as an invalid value
	jQuery.attrHooks.contenteditable = {
		set: function( elem, value, name ) {
			nodeHook.set( elem, value === "" ? false : value, name );
		}
	};

	// Set width and height to auto instead of 0 on empty string( Bug #8150 )
	// This is for removals
	jQuery.each([ "width", "height" ], function( i, name ) {
		jQuery.attrHooks[ name ] = {
			set: function( elem, value ) {
				if ( value === "" ) {
					elem.setAttribute( name, "auto" );
					return value;
				}
			}
		};
	});
}

if ( !support.style ) {
	jQuery.attrHooks.style = {
		get: function( elem ) {
			// Return undefined in the case of empty string
			// Note: IE uppercases css property names, but if we were to .toLowerCase()
			// .cssText, that would destroy case senstitivity in URL's, like in "background"
			return elem.style.cssText || undefined;
		},
		set: function( elem, value ) {
			return ( elem.style.cssText = value + "" );
		}
	};
}




var rfocusable = /^(?:input|select|textarea|button|object)$/i,
	rclickable = /^(?:a|area)$/i;

jQuery.fn.extend({
	prop: function( name, value ) {
		return access( this, jQuery.prop, name, value, arguments.length > 1 );
	},

	removeProp: function( name ) {
		name = jQuery.propFix[ name ] || name;
		return this.each(function() {
			// try/catch handles cases where IE balks (such as removing a property on window)
			try {
				this[ name ] = undefined;
				delete this[ name ];
			} catch( e ) {}
		});
	}
});

jQuery.extend({
	propFix: {
		"for": "htmlFor",
		"class": "className"
	},

	prop: function( elem, name, value ) {
		var ret, hooks, notxml,
			nType = elem.nodeType;

		// don't get/set properties on text, comment and attribute nodes
		if ( !elem || nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		notxml = nType !== 1 || !jQuery.isXMLDoc( elem );

		if ( notxml ) {
			// Fix name and attach hooks
			name = jQuery.propFix[ name ] || name;
			hooks = jQuery.propHooks[ name ];
		}

		if ( value !== undefined ) {
			return hooks && "set" in hooks && (ret = hooks.set( elem, value, name )) !== undefined ?
				ret :
				( elem[ name ] = value );

		} else {
			return hooks && "get" in hooks && (ret = hooks.get( elem, name )) !== null ?
				ret :
				elem[ name ];
		}
	},

	propHooks: {
		tabIndex: {
			get: function( elem ) {
				// elem.tabIndex doesn't always return the correct value when it hasn't been explicitly set
				// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
				// Use proper attribute retrieval(#12072)
				var tabindex = jQuery.find.attr( elem, "tabindex" );

				return tabindex ?
					parseInt( tabindex, 10 ) :
					rfocusable.test( elem.nodeName ) || rclickable.test( elem.nodeName ) && elem.href ?
						0 :
						-1;
			}
		}
	}
});

// Some attributes require a special call on IE
// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
if ( !support.hrefNormalized ) {
	// href/src property should get the full normalized URL (#10299/#12915)
	jQuery.each([ "href", "src" ], function( i, name ) {
		jQuery.propHooks[ name ] = {
			get: function( elem ) {
				return elem.getAttribute( name, 4 );
			}
		};
	});
}

// Support: Safari, IE9+
// mis-reports the default selected property of an option
// Accessing the parent's selectedIndex property fixes it
if ( !support.optSelected ) {
	jQuery.propHooks.selected = {
		get: function( elem ) {
			var parent = elem.parentNode;

			if ( parent ) {
				parent.selectedIndex;

				// Make sure that it also works with optgroups, see #5701
				if ( parent.parentNode ) {
					parent.parentNode.selectedIndex;
				}
			}
			return null;
		}
	};
}

jQuery.each([
	"tabIndex",
	"readOnly",
	"maxLength",
	"cellSpacing",
	"cellPadding",
	"rowSpan",
	"colSpan",
	"useMap",
	"frameBorder",
	"contentEditable"
], function() {
	jQuery.propFix[ this.toLowerCase() ] = this;
});

// IE6/7 call enctype encoding
if ( !support.enctype ) {
	jQuery.propFix.enctype = "encoding";
}




var rclass = /[\t\r\n\f]/g;

jQuery.fn.extend({
	addClass: function( value ) {
		var classes, elem, cur, clazz, j, finalValue,
			i = 0,
			len = this.length,
			proceed = typeof value === "string" && value;

		if ( jQuery.isFunction( value ) ) {
			return this.each(function( j ) {
				jQuery( this ).addClass( value.call( this, j, this.className ) );
			});
		}

		if ( proceed ) {
			// The disjunction here is for better compressibility (see removeClass)
			classes = ( value || "" ).match( rnotwhite ) || [];

			for ( ; i < len; i++ ) {
				elem = this[ i ];
				cur = elem.nodeType === 1 && ( elem.className ?
					( " " + elem.className + " " ).replace( rclass, " " ) :
					" "
				);

				if ( cur ) {
					j = 0;
					while ( (clazz = classes[j++]) ) {
						if ( cur.indexOf( " " + clazz + " " ) < 0 ) {
							cur += clazz + " ";
						}
					}

					// only assign if different to avoid unneeded rendering.
					finalValue = jQuery.trim( cur );
					if ( elem.className !== finalValue ) {
						elem.className = finalValue;
					}
				}
			}
		}

		return this;
	},

	removeClass: function( value ) {
		var classes, elem, cur, clazz, j, finalValue,
			i = 0,
			len = this.length,
			proceed = arguments.length === 0 || typeof value === "string" && value;

		if ( jQuery.isFunction( value ) ) {
			return this.each(function( j ) {
				jQuery( this ).removeClass( value.call( this, j, this.className ) );
			});
		}
		if ( proceed ) {
			classes = ( value || "" ).match( rnotwhite ) || [];

			for ( ; i < len; i++ ) {
				elem = this[ i ];
				// This expression is here for better compressibility (see addClass)
				cur = elem.nodeType === 1 && ( elem.className ?
					( " " + elem.className + " " ).replace( rclass, " " ) :
					""
				);

				if ( cur ) {
					j = 0;
					while ( (clazz = classes[j++]) ) {
						// Remove *all* instances
						while ( cur.indexOf( " " + clazz + " " ) >= 0 ) {
							cur = cur.replace( " " + clazz + " ", " " );
						}
					}

					// only assign if different to avoid unneeded rendering.
					finalValue = value ? jQuery.trim( cur ) : "";
					if ( elem.className !== finalValue ) {
						elem.className = finalValue;
					}
				}
			}
		}

		return this;
	},

	toggleClass: function( value, stateVal ) {
		var type = typeof value;

		if ( typeof stateVal === "boolean" && type === "string" ) {
			return stateVal ? this.addClass( value ) : this.removeClass( value );
		}

		if ( jQuery.isFunction( value ) ) {
			return this.each(function( i ) {
				jQuery( this ).toggleClass( value.call(this, i, this.className, stateVal), stateVal );
			});
		}

		return this.each(function() {
			if ( type === "string" ) {
				// toggle individual class names
				var className,
					i = 0,
					self = jQuery( this ),
					classNames = value.match( rnotwhite ) || [];

				while ( (className = classNames[ i++ ]) ) {
					// check each className given, space separated list
					if ( self.hasClass( className ) ) {
						self.removeClass( className );
					} else {
						self.addClass( className );
					}
				}

			// Toggle whole class name
			} else if ( type === strundefined || type === "boolean" ) {
				if ( this.className ) {
					// store className if set
					jQuery._data( this, "__className__", this.className );
				}

				// If the element has a class name or if we're passed "false",
				// then remove the whole classname (if there was one, the above saved it).
				// Otherwise bring back whatever was previously saved (if anything),
				// falling back to the empty string if nothing was stored.
				this.className = this.className || value === false ? "" : jQuery._data( this, "__className__" ) || "";
			}
		});
	},

	hasClass: function( selector ) {
		var className = " " + selector + " ",
			i = 0,
			l = this.length;
		for ( ; i < l; i++ ) {
			if ( this[i].nodeType === 1 && (" " + this[i].className + " ").replace(rclass, " ").indexOf( className ) >= 0 ) {
				return true;
			}
		}

		return false;
	}
});




// Return jQuery for attributes-only inclusion


jQuery.each( ("blur focus focusin focusout load resize scroll unload click dblclick " +
	"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
	"change select submit keydown keypress keyup error contextmenu").split(" "), function( i, name ) {

	// Handle event binding
	jQuery.fn[ name ] = function( data, fn ) {
		return arguments.length > 0 ?
			this.on( name, null, data, fn ) :
			this.trigger( name );
	};
});

jQuery.fn.extend({
	hover: function( fnOver, fnOut ) {
		return this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );
	},

	bind: function( types, data, fn ) {
		return this.on( types, null, data, fn );
	},
	unbind: function( types, fn ) {
		return this.off( types, null, fn );
	},

	delegate: function( selector, types, data, fn ) {
		return this.on( types, selector, data, fn );
	},
	undelegate: function( selector, types, fn ) {
		// ( namespace ) or ( selector, types [, fn] )
		return arguments.length === 1 ? this.off( selector, "**" ) : this.off( types, selector || "**", fn );
	}
});


var nonce = jQuery.now();

var rquery = (/\?/);



var rvalidtokens = /(,)|(\[|{)|(}|])|"(?:[^"\\\r\n]|\\["\\\/bfnrt]|\\u[\da-fA-F]{4})*"\s*:?|true|false|null|-?(?!0\d)\d+(?:\.\d+|)(?:[eE][+-]?\d+|)/g;

jQuery.parseJSON = function( data ) {
	// Attempt to parse using the native JSON parser first
	if ( window.JSON && window.JSON.parse ) {
		// Support: Android 2.3
		// Workaround failure to string-cast null input
		return window.JSON.parse( data + "" );
	}

	var requireNonComma,
		depth = null,
		str = jQuery.trim( data + "" );

	// Guard against invalid (and possibly dangerous) input by ensuring that nothing remains
	// after removing valid tokens
	return str && !jQuery.trim( str.replace( rvalidtokens, function( token, comma, open, close ) {

		// Force termination if we see a misplaced comma
		if ( requireNonComma && comma ) {
			depth = 0;
		}

		// Perform no more replacements after returning to outermost depth
		if ( depth === 0 ) {
			return token;
		}

		// Commas must not follow "[", "{", or ","
		requireNonComma = open || comma;

		// Determine new depth
		// array/object open ("[" or "{"): depth += true - false (increment)
		// array/object close ("]" or "}"): depth += false - true (decrement)
		// other cases ("," or primitive): depth += true - true (numeric cast)
		depth += !close - !open;

		// Remove this token
		return "";
	}) ) ?
		( Function( "return " + str ) )() :
		jQuery.error( "Invalid JSON: " + data );
};


// Cross-browser xml parsing
jQuery.parseXML = function( data ) {
	var xml, tmp;
	if ( !data || typeof data !== "string" ) {
		return null;
	}
	try {
		if ( window.DOMParser ) { // Standard
			tmp = new DOMParser();
			xml = tmp.parseFromString( data, "text/xml" );
		} else { // IE
			xml = new ActiveXObject( "Microsoft.XMLDOM" );
			xml.async = "false";
			xml.loadXML( data );
		}
	} catch( e ) {
		xml = undefined;
	}
	if ( !xml || !xml.documentElement || xml.getElementsByTagName( "parsererror" ).length ) {
		jQuery.error( "Invalid XML: " + data );
	}
	return xml;
};


var
	// Document location
	ajaxLocParts,
	ajaxLocation,

	rhash = /#.*$/,
	rts = /([?&])_=[^&]*/,
	rheaders = /^(.*?):[ \t]*([^\r\n]*)\r?$/mg, // IE leaves an \r character at EOL
	// #7653, #8125, #8152: local protocol detection
	rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
	rnoContent = /^(?:GET|HEAD)$/,
	rprotocol = /^\/\//,
	rurl = /^([\w.+-]+:)(?:\/\/(?:[^\/?#]*@|)([^\/?#:]*)(?::(\d+)|)|)/,

	/* Prefilters
	 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
	 * 2) These are called:
	 *    - BEFORE asking for a transport
	 *    - AFTER param serialization (s.data is a string if s.processData is true)
	 * 3) key is the dataType
	 * 4) the catchall symbol "*" can be used
	 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
	 */
	prefilters = {},

	/* Transports bindings
	 * 1) key is the dataType
	 * 2) the catchall symbol "*" can be used
	 * 3) selection will start with transport dataType and THEN go to "*" if needed
	 */
	transports = {},

	// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
	allTypes = "*/".concat("*");

// #8138, IE may throw an exception when accessing
// a field from window.location if document.domain has been set
try {
	ajaxLocation = location.href;
} catch( e ) {
	// Use the href attribute of an A element
	// since IE will modify it given document.location
	ajaxLocation = document.createElement( "a" );
	ajaxLocation.href = "";
	ajaxLocation = ajaxLocation.href;
}

// Segment location into parts
ajaxLocParts = rurl.exec( ajaxLocation.toLowerCase() ) || [];

// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
function addToPrefiltersOrTransports( structure ) {

	// dataTypeExpression is optional and defaults to "*"
	return function( dataTypeExpression, func ) {

		if ( typeof dataTypeExpression !== "string" ) {
			func = dataTypeExpression;
			dataTypeExpression = "*";
		}

		var dataType,
			i = 0,
			dataTypes = dataTypeExpression.toLowerCase().match( rnotwhite ) || [];

		if ( jQuery.isFunction( func ) ) {
			// For each dataType in the dataTypeExpression
			while ( (dataType = dataTypes[i++]) ) {
				// Prepend if requested
				if ( dataType.charAt( 0 ) === "+" ) {
					dataType = dataType.slice( 1 ) || "*";
					(structure[ dataType ] = structure[ dataType ] || []).unshift( func );

				// Otherwise append
				} else {
					(structure[ dataType ] = structure[ dataType ] || []).push( func );
				}
			}
		}
	};
}

// Base inspection function for prefilters and transports
function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {

	var inspected = {},
		seekingTransport = ( structure === transports );

	function inspect( dataType ) {
		var selected;
		inspected[ dataType ] = true;
		jQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {
			var dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );
			if ( typeof dataTypeOrTransport === "string" && !seekingTransport && !inspected[ dataTypeOrTransport ] ) {
				options.dataTypes.unshift( dataTypeOrTransport );
				inspect( dataTypeOrTransport );
				return false;
			} else if ( seekingTransport ) {
				return !( selected = dataTypeOrTransport );
			}
		});
		return selected;
	}

	return inspect( options.dataTypes[ 0 ] ) || !inspected[ "*" ] && inspect( "*" );
}

// A special extend for ajax options
// that takes "flat" options (not to be deep extended)
// Fixes #9887
function ajaxExtend( target, src ) {
	var deep, key,
		flatOptions = jQuery.ajaxSettings.flatOptions || {};

	for ( key in src ) {
		if ( src[ key ] !== undefined ) {
			( flatOptions[ key ] ? target : ( deep || (deep = {}) ) )[ key ] = src[ key ];
		}
	}
	if ( deep ) {
		jQuery.extend( true, target, deep );
	}

	return target;
}

/* Handles responses to an ajax request:
 * - finds the right dataType (mediates between content-type and expected dataType)
 * - returns the corresponding response
 */
function ajaxHandleResponses( s, jqXHR, responses ) {
	var firstDataType, ct, finalDataType, type,
		contents = s.contents,
		dataTypes = s.dataTypes;

	// Remove auto dataType and get content-type in the process
	while ( dataTypes[ 0 ] === "*" ) {
		dataTypes.shift();
		if ( ct === undefined ) {
			ct = s.mimeType || jqXHR.getResponseHeader("Content-Type");
		}
	}

	// Check if we're dealing with a known content-type
	if ( ct ) {
		for ( type in contents ) {
			if ( contents[ type ] && contents[ type ].test( ct ) ) {
				dataTypes.unshift( type );
				break;
			}
		}
	}

	// Check to see if we have a response for the expected dataType
	if ( dataTypes[ 0 ] in responses ) {
		finalDataType = dataTypes[ 0 ];
	} else {
		// Try convertible dataTypes
		for ( type in responses ) {
			if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[0] ] ) {
				finalDataType = type;
				break;
			}
			if ( !firstDataType ) {
				firstDataType = type;
			}
		}
		// Or just use first one
		finalDataType = finalDataType || firstDataType;
	}

	// If we found a dataType
	// We add the dataType to the list if needed
	// and return the corresponding response
	if ( finalDataType ) {
		if ( finalDataType !== dataTypes[ 0 ] ) {
			dataTypes.unshift( finalDataType );
		}
		return responses[ finalDataType ];
	}
}

/* Chain conversions given the request and the original response
 * Also sets the responseXXX fields on the jqXHR instance
 */
function ajaxConvert( s, response, jqXHR, isSuccess ) {
	var conv2, current, conv, tmp, prev,
		converters = {},
		// Work with a copy of dataTypes in case we need to modify it for conversion
		dataTypes = s.dataTypes.slice();

	// Create converters map with lowercased keys
	if ( dataTypes[ 1 ] ) {
		for ( conv in s.converters ) {
			converters[ conv.toLowerCase() ] = s.converters[ conv ];
		}
	}

	current = dataTypes.shift();

	// Convert to each sequential dataType
	while ( current ) {

		if ( s.responseFields[ current ] ) {
			jqXHR[ s.responseFields[ current ] ] = response;
		}

		// Apply the dataFilter if provided
		if ( !prev && isSuccess && s.dataFilter ) {
			response = s.dataFilter( response, s.dataType );
		}

		prev = current;
		current = dataTypes.shift();

		if ( current ) {

			// There's only work to do if current dataType is non-auto
			if ( current === "*" ) {

				current = prev;

			// Convert response if prev dataType is non-auto and differs from current
			} else if ( prev !== "*" && prev !== current ) {

				// Seek a direct converter
				conv = converters[ prev + " " + current ] || converters[ "* " + current ];

				// If none found, seek a pair
				if ( !conv ) {
					for ( conv2 in converters ) {

						// If conv2 outputs current
						tmp = conv2.split( " " );
						if ( tmp[ 1 ] === current ) {

							// If prev can be converted to accepted input
							conv = converters[ prev + " " + tmp[ 0 ] ] ||
								converters[ "* " + tmp[ 0 ] ];
							if ( conv ) {
								// Condense equivalence converters
								if ( conv === true ) {
									conv = converters[ conv2 ];

								// Otherwise, insert the intermediate dataType
								} else if ( converters[ conv2 ] !== true ) {
									current = tmp[ 0 ];
									dataTypes.unshift( tmp[ 1 ] );
								}
								break;
							}
						}
					}
				}

				// Apply converter (if not an equivalence)
				if ( conv !== true ) {

					// Unless errors are allowed to bubble, catch and return them
					if ( conv && s[ "throws" ] ) {
						response = conv( response );
					} else {
						try {
							response = conv( response );
						} catch ( e ) {
							return { state: "parsererror", error: conv ? e : "No conversion from " + prev + " to " + current };
						}
					}
				}
			}
		}
	}

	return { state: "success", data: response };
}

jQuery.extend({

	// Counter for holding the number of active queries
	active: 0,

	// Last-Modified header cache for next request
	lastModified: {},
	etag: {},

	ajaxSettings: {
		url: ajaxLocation,
		type: "GET",
		isLocal: rlocalProtocol.test( ajaxLocParts[ 1 ] ),
		global: true,
		processData: true,
		async: true,
		contentType: "application/x-www-form-urlencoded; charset=UTF-8",
		/*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		throws: false,
		traditional: false,
		headers: {},
		*/

		accepts: {
			"*": allTypes,
			text: "text/plain",
			html: "text/html",
			xml: "application/xml, text/xml",
			json: "application/json, text/javascript"
		},

		contents: {
			xml: /xml/,
			html: /html/,
			json: /json/
		},

		responseFields: {
			xml: "responseXML",
			text: "responseText",
			json: "responseJSON"
		},

		// Data converters
		// Keys separate source (or catchall "*") and destination types with a single space
		converters: {

			// Convert anything to text
			"* text": String,

			// Text to html (true = no transformation)
			"text html": true,

			// Evaluate text as a json expression
			"text json": jQuery.parseJSON,

			// Parse text as xml
			"text xml": jQuery.parseXML
		},

		// For options that shouldn't be deep extended:
		// you can add your own custom options here if
		// and when you create one that shouldn't be
		// deep extended (see ajaxExtend)
		flatOptions: {
			url: true,
			context: true
		}
	},

	// Creates a full fledged settings object into target
	// with both ajaxSettings and settings fields.
	// If target is omitted, writes into ajaxSettings.
	ajaxSetup: function( target, settings ) {
		return settings ?

			// Building a settings object
			ajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :

			// Extending ajaxSettings
			ajaxExtend( jQuery.ajaxSettings, target );
	},

	ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
	ajaxTransport: addToPrefiltersOrTransports( transports ),

	// Main method
	ajax: function( url, options ) {

		// If url is an object, simulate pre-1.5 signature
		if ( typeof url === "object" ) {
			options = url;
			url = undefined;
		}

		// Force options to be an object
		options = options || {};

		var // Cross-domain detection vars
			parts,
			// Loop variable
			i,
			// URL without anti-cache param
			cacheURL,
			// Response headers as string
			responseHeadersString,
			// timeout handle
			timeoutTimer,

			// To know if global events are to be dispatched
			fireGlobals,

			transport,
			// Response headers
			responseHeaders,
			// Create the final options object
			s = jQuery.ajaxSetup( {}, options ),
			// Callbacks context
			callbackContext = s.context || s,
			// Context for global events is callbackContext if it is a DOM node or jQuery collection
			globalEventContext = s.context && ( callbackContext.nodeType || callbackContext.jquery ) ?
				jQuery( callbackContext ) :
				jQuery.event,
			// Deferreds
			deferred = jQuery.Deferred(),
			completeDeferred = jQuery.Callbacks("once memory"),
			// Status-dependent callbacks
			statusCode = s.statusCode || {},
			// Headers (they are sent all at once)
			requestHeaders = {},
			requestHeadersNames = {},
			// The jqXHR state
			state = 0,
			// Default abort message
			strAbort = "canceled",
			// Fake xhr
			jqXHR = {
				readyState: 0,

				// Builds headers hashtable if needed
				getResponseHeader: function( key ) {
					var match;
					if ( state === 2 ) {
						if ( !responseHeaders ) {
							responseHeaders = {};
							while ( (match = rheaders.exec( responseHeadersString )) ) {
								responseHeaders[ match[1].toLowerCase() ] = match[ 2 ];
							}
						}
						match = responseHeaders[ key.toLowerCase() ];
					}
					return match == null ? null : match;
				},

				// Raw string
				getAllResponseHeaders: function() {
					return state === 2 ? responseHeadersString : null;
				},

				// Caches the header
				setRequestHeader: function( name, value ) {
					var lname = name.toLowerCase();
					if ( !state ) {
						name = requestHeadersNames[ lname ] = requestHeadersNames[ lname ] || name;
						requestHeaders[ name ] = value;
					}
					return this;
				},

				// Overrides response content-type header
				overrideMimeType: function( type ) {
					if ( !state ) {
						s.mimeType = type;
					}
					return this;
				},

				// Status-dependent callbacks
				statusCode: function( map ) {
					var code;
					if ( map ) {
						if ( state < 2 ) {
							for ( code in map ) {
								// Lazy-add the new callback in a way that preserves old ones
								statusCode[ code ] = [ statusCode[ code ], map[ code ] ];
							}
						} else {
							// Execute the appropriate callbacks
							jqXHR.always( map[ jqXHR.status ] );
						}
					}
					return this;
				},

				// Cancel the request
				abort: function( statusText ) {
					var finalText = statusText || strAbort;
					if ( transport ) {
						transport.abort( finalText );
					}
					done( 0, finalText );
					return this;
				}
			};

		// Attach deferreds
		deferred.promise( jqXHR ).complete = completeDeferred.add;
		jqXHR.success = jqXHR.done;
		jqXHR.error = jqXHR.fail;

		// Remove hash character (#7531: and string promotion)
		// Add protocol if not provided (#5866: IE7 issue with protocol-less urls)
		// Handle falsy url in the settings object (#10093: consistency with old signature)
		// We also use the url parameter if available
		s.url = ( ( url || s.url || ajaxLocation ) + "" ).replace( rhash, "" ).replace( rprotocol, ajaxLocParts[ 1 ] + "//" );

		// Alias method option to type as per ticket #12004
		s.type = options.method || options.type || s.method || s.type;

		// Extract dataTypes list
		s.dataTypes = jQuery.trim( s.dataType || "*" ).toLowerCase().match( rnotwhite ) || [ "" ];

		// A cross-domain request is in order when we have a protocol:host:port mismatch
		if ( s.crossDomain == null ) {
			parts = rurl.exec( s.url.toLowerCase() );
			s.crossDomain = !!( parts &&
				( parts[ 1 ] !== ajaxLocParts[ 1 ] || parts[ 2 ] !== ajaxLocParts[ 2 ] ||
					( parts[ 3 ] || ( parts[ 1 ] === "http:" ? "80" : "443" ) ) !==
						( ajaxLocParts[ 3 ] || ( ajaxLocParts[ 1 ] === "http:" ? "80" : "443" ) ) )
			);
		}

		// Convert data if not already a string
		if ( s.data && s.processData && typeof s.data !== "string" ) {
			s.data = jQuery.param( s.data, s.traditional );
		}

		// Apply prefilters
		inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

		// If request was aborted inside a prefilter, stop there
		if ( state === 2 ) {
			return jqXHR;
		}

		// We can fire global events as of now if asked to
		fireGlobals = s.global;

		// Watch for a new set of requests
		if ( fireGlobals && jQuery.active++ === 0 ) {
			jQuery.event.trigger("ajaxStart");
		}

		// Uppercase the type
		s.type = s.type.toUpperCase();

		// Determine if request has content
		s.hasContent = !rnoContent.test( s.type );

		// Save the URL in case we're toying with the If-Modified-Since
		// and/or If-None-Match header later on
		cacheURL = s.url;

		// More options handling for requests with no content
		if ( !s.hasContent ) {

			// If data is available, append data to url
			if ( s.data ) {
				cacheURL = ( s.url += ( rquery.test( cacheURL ) ? "&" : "?" ) + s.data );
				// #9682: remove data so that it's not used in an eventual retry
				delete s.data;
			}

			// Add anti-cache in url if needed
			if ( s.cache === false ) {
				s.url = rts.test( cacheURL ) ?

					// If there is already a '_' parameter, set its value
					cacheURL.replace( rts, "$1_=" + nonce++ ) :

					// Otherwise add one to the end
					cacheURL + ( rquery.test( cacheURL ) ? "&" : "?" ) + "_=" + nonce++;
			}
		}

		// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
		if ( s.ifModified ) {
			if ( jQuery.lastModified[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ cacheURL ] );
			}
			if ( jQuery.etag[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ cacheURL ] );
			}
		}

		// Set the correct header, if data is being sent
		if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
			jqXHR.setRequestHeader( "Content-Type", s.contentType );
		}

		// Set the Accepts header for the server, depending on the dataType
		jqXHR.setRequestHeader(
			"Accept",
			s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[0] ] ?
				s.accepts[ s.dataTypes[0] ] + ( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
				s.accepts[ "*" ]
		);

		// Check for headers option
		for ( i in s.headers ) {
			jqXHR.setRequestHeader( i, s.headers[ i ] );
		}

		// Allow custom headers/mimetypes and early abort
		if ( s.beforeSend && ( s.beforeSend.call( callbackContext, jqXHR, s ) === false || state === 2 ) ) {
			// Abort if not done already and return
			return jqXHR.abort();
		}

		// aborting is no longer a cancellation
		strAbort = "abort";

		// Install callbacks on deferreds
		for ( i in { success: 1, error: 1, complete: 1 } ) {
			jqXHR[ i ]( s[ i ] );
		}

		// Get transport
		transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

		// If no transport, we auto-abort
		if ( !transport ) {
			done( -1, "No Transport" );
		} else {
			jqXHR.readyState = 1;

			// Send global event
			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
			}
			// Timeout
			if ( s.async && s.timeout > 0 ) {
				timeoutTimer = setTimeout(function() {
					jqXHR.abort("timeout");
				}, s.timeout );
			}

			try {
				state = 1;
				transport.send( requestHeaders, done );
			} catch ( e ) {
				// Propagate exception as error if not done
				if ( state < 2 ) {
					done( -1, e );
				// Simply rethrow otherwise
				} else {
					throw e;
				}
			}
		}

		// Callback for when everything is done
		function done( status, nativeStatusText, responses, headers ) {
			var isSuccess, success, error, response, modified,
				statusText = nativeStatusText;

			// Called once
			if ( state === 2 ) {
				return;
			}

			// State is "done" now
			state = 2;

			// Clear timeout if it exists
			if ( timeoutTimer ) {
				clearTimeout( timeoutTimer );
			}

			// Dereference transport for early garbage collection
			// (no matter how long the jqXHR object will be used)
			transport = undefined;

			// Cache response headers
			responseHeadersString = headers || "";

			// Set readyState
			jqXHR.readyState = status > 0 ? 4 : 0;

			// Determine if successful
			isSuccess = status >= 200 && status < 300 || status === 304;

			// Get response data
			if ( responses ) {
				response = ajaxHandleResponses( s, jqXHR, responses );
			}

			// Convert no matter what (that way responseXXX fields are always set)
			response = ajaxConvert( s, response, jqXHR, isSuccess );

			// If successful, handle type chaining
			if ( isSuccess ) {

				// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
				if ( s.ifModified ) {
					modified = jqXHR.getResponseHeader("Last-Modified");
					if ( modified ) {
						jQuery.lastModified[ cacheURL ] = modified;
					}
					modified = jqXHR.getResponseHeader("etag");
					if ( modified ) {
						jQuery.etag[ cacheURL ] = modified;
					}
				}

				// if no content
				if ( status === 204 || s.type === "HEAD" ) {
					statusText = "nocontent";

				// if not modified
				} else if ( status === 304 ) {
					statusText = "notmodified";

				// If we have data, let's convert it
				} else {
					statusText = response.state;
					success = response.data;
					error = response.error;
					isSuccess = !error;
				}
			} else {
				// We extract error from statusText
				// then normalize statusText and status for non-aborts
				error = statusText;
				if ( status || !statusText ) {
					statusText = "error";
					if ( status < 0 ) {
						status = 0;
					}
				}
			}

			// Set data for the fake xhr object
			jqXHR.status = status;
			jqXHR.statusText = ( nativeStatusText || statusText ) + "";

			// Success/Error
			if ( isSuccess ) {
				deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
			} else {
				deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
			}

			// Status-dependent callbacks
			jqXHR.statusCode( statusCode );
			statusCode = undefined;

			if ( fireGlobals ) {
				globalEventContext.trigger( isSuccess ? "ajaxSuccess" : "ajaxError",
					[ jqXHR, s, isSuccess ? success : error ] );
			}

			// Complete
			completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );
				// Handle the global AJAX counter
				if ( !( --jQuery.active ) ) {
					jQuery.event.trigger("ajaxStop");
				}
			}
		}

		return jqXHR;
	},

	getJSON: function( url, data, callback ) {
		return jQuery.get( url, data, callback, "json" );
	},

	getScript: function( url, callback ) {
		return jQuery.get( url, undefined, callback, "script" );
	}
});

jQuery.each( [ "get", "post" ], function( i, method ) {
	jQuery[ method ] = function( url, data, callback, type ) {
		// shift arguments if data argument was omitted
		if ( jQuery.isFunction( data ) ) {
			type = type || callback;
			callback = data;
			data = undefined;
		}

		return jQuery.ajax({
			url: url,
			type: method,
			dataType: type,
			data: data,
			success: callback
		});
	};
});

// Attach a bunch of functions for handling common AJAX events
jQuery.each( [ "ajaxStart", "ajaxStop", "ajaxComplete", "ajaxError", "ajaxSuccess", "ajaxSend" ], function( i, type ) {
	jQuery.fn[ type ] = function( fn ) {
		return this.on( type, fn );
	};
});


jQuery._evalUrl = function( url ) {
	return jQuery.ajax({
		url: url,
		type: "GET",
		dataType: "script",
		async: false,
		global: false,
		"throws": true
	});
};


jQuery.fn.extend({
	wrapAll: function( html ) {
		if ( jQuery.isFunction( html ) ) {
			return this.each(function(i) {
				jQuery(this).wrapAll( html.call(this, i) );
			});
		}

		if ( this[0] ) {
			// The elements to wrap the target around
			var wrap = jQuery( html, this[0].ownerDocument ).eq(0).clone(true);

			if ( this[0].parentNode ) {
				wrap.insertBefore( this[0] );
			}

			wrap.map(function() {
				var elem = this;

				while ( elem.firstChild && elem.firstChild.nodeType === 1 ) {
					elem = elem.firstChild;
				}

				return elem;
			}).append( this );
		}

		return this;
	},

	wrapInner: function( html ) {
		if ( jQuery.isFunction( html ) ) {
			return this.each(function(i) {
				jQuery(this).wrapInner( html.call(this, i) );
			});
		}

		return this.each(function() {
			var self = jQuery( this ),
				contents = self.contents();

			if ( contents.length ) {
				contents.wrapAll( html );

			} else {
				self.append( html );
			}
		});
	},

	wrap: function( html ) {
		var isFunction = jQuery.isFunction( html );

		return this.each(function(i) {
			jQuery( this ).wrapAll( isFunction ? html.call(this, i) : html );
		});
	},

	unwrap: function() {
		return this.parent().each(function() {
			if ( !jQuery.nodeName( this, "body" ) ) {
				jQuery( this ).replaceWith( this.childNodes );
			}
		}).end();
	}
});


jQuery.expr.filters.hidden = function( elem ) {
	// Support: Opera <= 12.12
	// Opera reports offsetWidths and offsetHeights less than zero on some elements
	return elem.offsetWidth <= 0 && elem.offsetHeight <= 0 ||
		(!support.reliableHiddenOffsets() &&
			((elem.style && elem.style.display) || jQuery.css( elem, "display" )) === "none");
};

jQuery.expr.filters.visible = function( elem ) {
	return !jQuery.expr.filters.hidden( elem );
};




var r20 = /%20/g,
	rbracket = /\[\]$/,
	rCRLF = /\r?\n/g,
	rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
	rsubmittable = /^(?:input|select|textarea|keygen)/i;

function buildParams( prefix, obj, traditional, add ) {
	var name;

	if ( jQuery.isArray( obj ) ) {
		// Serialize array item.
		jQuery.each( obj, function( i, v ) {
			if ( traditional || rbracket.test( prefix ) ) {
				// Treat each array item as a scalar.
				add( prefix, v );

			} else {
				// Item is non-scalar (array or object), encode its numeric index.
				buildParams( prefix + "[" + ( typeof v === "object" ? i : "" ) + "]", v, traditional, add );
			}
		});

	} else if ( !traditional && jQuery.type( obj ) === "object" ) {
		// Serialize object item.
		for ( name in obj ) {
			buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
		}

	} else {
		// Serialize scalar item.
		add( prefix, obj );
	}
}

// Serialize an array of form elements or a set of
// key/values into a query string
jQuery.param = function( a, traditional ) {
	var prefix,
		s = [],
		add = function( key, value ) {
			// If value is a function, invoke it and return its value
			value = jQuery.isFunction( value ) ? value() : ( value == null ? "" : value );
			s[ s.length ] = encodeURIComponent( key ) + "=" + encodeURIComponent( value );
		};

	// Set traditional to true for jQuery <= 1.3.2 behavior.
	if ( traditional === undefined ) {
		traditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;
	}

	// If an array was passed in, assume that it is an array of form elements.
	if ( jQuery.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {
		// Serialize the form elements
		jQuery.each( a, function() {
			add( this.name, this.value );
		});

	} else {
		// If traditional, encode the "old" way (the way 1.3.2 or older
		// did it), otherwise encode params recursively.
		for ( prefix in a ) {
			buildParams( prefix, a[ prefix ], traditional, add );
		}
	}

	// Return the resulting serialization
	return s.join( "&" ).replace( r20, "+" );
};

jQuery.fn.extend({
	serialize: function() {
		return jQuery.param( this.serializeArray() );
	},
	serializeArray: function() {
		return this.map(function() {
			// Can add propHook for "elements" to filter or add form elements
			var elements = jQuery.prop( this, "elements" );
			return elements ? jQuery.makeArray( elements ) : this;
		})
		.filter(function() {
			var type = this.type;
			// Use .is(":disabled") so that fieldset[disabled] works
			return this.name && !jQuery( this ).is( ":disabled" ) &&
				rsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&
				( this.checked || !rcheckableType.test( type ) );
		})
		.map(function( i, elem ) {
			var val = jQuery( this ).val();

			return val == null ?
				null :
				jQuery.isArray( val ) ?
					jQuery.map( val, function( val ) {
						return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
					}) :
					{ name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
		}).get();
	}
});


// Create the request object
// (This is still attached to ajaxSettings for backward compatibility)
jQuery.ajaxSettings.xhr = window.ActiveXObject !== undefined ?
	// Support: IE6+
	function() {

		// XHR cannot access local files, always use ActiveX for that case
		return !this.isLocal &&

			// Support: IE7-8
			// oldIE XHR does not support non-RFC2616 methods (#13240)
			// See http://msdn.microsoft.com/en-us/library/ie/ms536648(v=vs.85).aspx
			// and http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9
			// Although this check for six methods instead of eight
			// since IE also does not support "trace" and "connect"
			/^(get|post|head|put|delete|options)$/i.test( this.type ) &&

			createStandardXHR() || createActiveXHR();
	} :
	// For all other browsers, use the standard XMLHttpRequest object
	createStandardXHR;

var xhrId = 0,
	xhrCallbacks = {},
	xhrSupported = jQuery.ajaxSettings.xhr();

// Support: IE<10
// Open requests must be manually aborted on unload (#5280)
if ( window.ActiveXObject ) {
	jQuery( window ).on( "unload", function() {
		for ( var key in xhrCallbacks ) {
			xhrCallbacks[ key ]( undefined, true );
		}
	});
}

// Determine support properties
support.cors = !!xhrSupported && ( "withCredentials" in xhrSupported );
xhrSupported = support.ajax = !!xhrSupported;

// Create transport if the browser can provide an xhr
if ( xhrSupported ) {

	jQuery.ajaxTransport(function( options ) {
		// Cross domain only allowed if supported through XMLHttpRequest
		if ( !options.crossDomain || support.cors ) {

			var callback;

			return {
				send: function( headers, complete ) {
					var i,
						xhr = options.xhr(),
						id = ++xhrId;

					// Open the socket
					xhr.open( options.type, options.url, options.async, options.username, options.password );

					// Apply custom fields if provided
					if ( options.xhrFields ) {
						for ( i in options.xhrFields ) {
							xhr[ i ] = options.xhrFields[ i ];
						}
					}

					// Override mime type if needed
					if ( options.mimeType && xhr.overrideMimeType ) {
						xhr.overrideMimeType( options.mimeType );
					}

					// X-Requested-With header
					// For cross-domain requests, seeing as conditions for a preflight are
					// akin to a jigsaw puzzle, we simply never set it to be sure.
					// (it can always be set on a per-request basis or even using ajaxSetup)
					// For same-domain requests, won't change header if already provided.
					if ( !options.crossDomain && !headers["X-Requested-With"] ) {
						headers["X-Requested-With"] = "XMLHttpRequest";
					}

					// Set headers
					for ( i in headers ) {
						// Support: IE<9
						// IE's ActiveXObject throws a 'Type Mismatch' exception when setting
						// request header to a null-value.
						//
						// To keep consistent with other XHR implementations, cast the value
						// to string and ignore `undefined`.
						if ( headers[ i ] !== undefined ) {
							xhr.setRequestHeader( i, headers[ i ] + "" );
						}
					}

					// Do send the request
					// This may raise an exception which is actually
					// handled in jQuery.ajax (so no try/catch here)
					xhr.send( ( options.hasContent && options.data ) || null );

					// Listener
					callback = function( _, isAbort ) {
						var status, statusText, responses;

						// Was never called and is aborted or complete
						if ( callback && ( isAbort || xhr.readyState === 4 ) ) {
							// Clean up
							delete xhrCallbacks[ id ];
							callback = undefined;
							xhr.onreadystatechange = jQuery.noop;

							// Abort manually if needed
							if ( isAbort ) {
								if ( xhr.readyState !== 4 ) {
									xhr.abort();
								}
							} else {
								responses = {};
								status = xhr.status;

								// Support: IE<10
								// Accessing binary-data responseText throws an exception
								// (#11426)
								if ( typeof xhr.responseText === "string" ) {
									responses.text = xhr.responseText;
								}

								// Firefox throws an exception when accessing
								// statusText for faulty cross-domain requests
								try {
									statusText = xhr.statusText;
								} catch( e ) {
									// We normalize with Webkit giving an empty statusText
									statusText = "";
								}

								// Filter status for non standard behaviors

								// If the request is local and we have data: assume a success
								// (success with no data won't get notified, that's the best we
								// can do given current implementations)
								if ( !status && options.isLocal && !options.crossDomain ) {
									status = responses.text ? 200 : 404;
								// IE - #1450: sometimes returns 1223 when it should be 204
								} else if ( status === 1223 ) {
									status = 204;
								}
							}
						}

						// Call complete if needed
						if ( responses ) {
							complete( status, statusText, responses, xhr.getAllResponseHeaders() );
						}
					};

					if ( !options.async ) {
						// if we're in sync mode we fire the callback
						callback();
					} else if ( xhr.readyState === 4 ) {
						// (IE6 & IE7) if it's in cache and has been
						// retrieved directly we need to fire the callback
						setTimeout( callback );
					} else {
						// Add to the list of active xhr callbacks
						xhr.onreadystatechange = xhrCallbacks[ id ] = callback;
					}
				},

				abort: function() {
					if ( callback ) {
						callback( undefined, true );
					}
				}
			};
		}
	});
}

// Functions to create xhrs
function createStandardXHR() {
	try {
		return new window.XMLHttpRequest();
	} catch( e ) {}
}

function createActiveXHR() {
	try {
		return new window.ActiveXObject( "Microsoft.XMLHTTP" );
	} catch( e ) {}
}




// Install script dataType
jQuery.ajaxSetup({
	accepts: {
		script: "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"
	},
	contents: {
		script: /(?:java|ecma)script/
	},
	converters: {
		"text script": function( text ) {
			jQuery.globalEval( text );
			return text;
		}
	}
});

// Handle cache's special case and global
jQuery.ajaxPrefilter( "script", function( s ) {
	if ( s.cache === undefined ) {
		s.cache = false;
	}
	if ( s.crossDomain ) {
		s.type = "GET";
		s.global = false;
	}
});

// Bind script tag hack transport
jQuery.ajaxTransport( "script", function(s) {

	// This transport only deals with cross domain requests
	if ( s.crossDomain ) {

		var script,
			head = document.head || jQuery("head")[0] || document.documentElement;

		return {

			send: function( _, callback ) {

				script = document.createElement("script");

				script.async = true;

				if ( s.scriptCharset ) {
					script.charset = s.scriptCharset;
				}

				script.src = s.url;

				// Attach handlers for all browsers
				script.onload = script.onreadystatechange = function( _, isAbort ) {

					if ( isAbort || !script.readyState || /loaded|complete/.test( script.readyState ) ) {

						// Handle memory leak in IE
						script.onload = script.onreadystatechange = null;

						// Remove the script
						if ( script.parentNode ) {
							script.parentNode.removeChild( script );
						}

						// Dereference the script
						script = null;

						// Callback if not abort
						if ( !isAbort ) {
							callback( 200, "success" );
						}
					}
				};

				// Circumvent IE6 bugs with base elements (#2709 and #4378) by prepending
				// Use native DOM manipulation to avoid our domManip AJAX trickery
				head.insertBefore( script, head.firstChild );
			},

			abort: function() {
				if ( script ) {
					script.onload( undefined, true );
				}
			}
		};
	}
});




var oldCallbacks = [],
	rjsonp = /(=)\?(?=&|$)|\?\?/;

// Default jsonp settings
jQuery.ajaxSetup({
	jsonp: "callback",
	jsonpCallback: function() {
		var callback = oldCallbacks.pop() || ( jQuery.expando + "_" + ( nonce++ ) );
		this[ callback ] = true;
		return callback;
	}
});

// Detect, normalize options and install callbacks for jsonp requests
jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

	var callbackName, overwritten, responseContainer,
		jsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?
			"url" :
			typeof s.data === "string" && !( s.contentType || "" ).indexOf("application/x-www-form-urlencoded") && rjsonp.test( s.data ) && "data"
		);

	// Handle iff the expected data type is "jsonp" or we have a parameter to set
	if ( jsonProp || s.dataTypes[ 0 ] === "jsonp" ) {

		// Get callback name, remembering preexisting value associated with it
		callbackName = s.jsonpCallback = jQuery.isFunction( s.jsonpCallback ) ?
			s.jsonpCallback() :
			s.jsonpCallback;

		// Insert callback into url or form data
		if ( jsonProp ) {
			s[ jsonProp ] = s[ jsonProp ].replace( rjsonp, "$1" + callbackName );
		} else if ( s.jsonp !== false ) {
			s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
		}

		// Use data converter to retrieve json after script execution
		s.converters["script json"] = function() {
			if ( !responseContainer ) {
				jQuery.error( callbackName + " was not called" );
			}
			return responseContainer[ 0 ];
		};

		// force json dataType
		s.dataTypes[ 0 ] = "json";

		// Install callback
		overwritten = window[ callbackName ];
		window[ callbackName ] = function() {
			responseContainer = arguments;
		};

		// Clean-up function (fires after converters)
		jqXHR.always(function() {
			// Restore preexisting value
			window[ callbackName ] = overwritten;

			// Save back as free
			if ( s[ callbackName ] ) {
				// make sure that re-using the options doesn't screw things around
				s.jsonpCallback = originalSettings.jsonpCallback;

				// save the callback name for future use
				oldCallbacks.push( callbackName );
			}

			// Call if it was a function and we have a response
			if ( responseContainer && jQuery.isFunction( overwritten ) ) {
				overwritten( responseContainer[ 0 ] );
			}

			responseContainer = overwritten = undefined;
		});

		// Delegate to script
		return "script";
	}
});




// data: string of html
// context (optional): If specified, the fragment will be created in this context, defaults to document
// keepScripts (optional): If true, will include scripts passed in the html string
jQuery.parseHTML = function( data, context, keepScripts ) {
	if ( !data || typeof data !== "string" ) {
		return null;
	}
	if ( typeof context === "boolean" ) {
		keepScripts = context;
		context = false;
	}
	context = context || document;

	var parsed = rsingleTag.exec( data ),
		scripts = !keepScripts && [];

	// Single tag
	if ( parsed ) {
		return [ context.createElement( parsed[1] ) ];
	}

	parsed = jQuery.buildFragment( [ data ], context, scripts );

	if ( scripts && scripts.length ) {
		jQuery( scripts ).remove();
	}

	return jQuery.merge( [], parsed.childNodes );
};


// Keep a copy of the old load method
var _load = jQuery.fn.load;

/**
 * Load a url into a page
 */
jQuery.fn.load = function( url, params, callback ) {
	if ( typeof url !== "string" && _load ) {
		return _load.apply( this, arguments );
	}

	var selector, response, type,
		self = this,
		off = url.indexOf(" ");

	if ( off >= 0 ) {
		selector = url.slice( off, url.length );
		url = url.slice( 0, off );
	}

	// If it's a function
	if ( jQuery.isFunction( params ) ) {

		// We assume that it's the callback
		callback = params;
		params = undefined;

	// Otherwise, build a param string
	} else if ( params && typeof params === "object" ) {
		type = "POST";
	}

	// If we have elements to modify, make the request
	if ( self.length > 0 ) {
		jQuery.ajax({
			url: url,

			// if "type" variable is undefined, then "GET" method will be used
			type: type,
			dataType: "html",
			data: params
		}).done(function( responseText ) {

			// Save response for use in complete callback
			response = arguments;

			self.html( selector ?

				// If a selector was specified, locate the right elements in a dummy div
				// Exclude scripts to avoid IE 'Permission Denied' errors
				jQuery("<div>").append( jQuery.parseHTML( responseText ) ).find( selector ) :

				// Otherwise use the full result
				responseText );

		}).complete( callback && function( jqXHR, status ) {
			self.each( callback, response || [ jqXHR.responseText, status, jqXHR ] );
		});
	}

	return this;
};




jQuery.expr.filters.animated = function( elem ) {
	return jQuery.grep(jQuery.timers, function( fn ) {
		return elem === fn.elem;
	}).length;
};





var docElem = window.document.documentElement;

/**
 * Gets a window from an element
 */
function getWindow( elem ) {
	return jQuery.isWindow( elem ) ?
		elem :
		elem.nodeType === 9 ?
			elem.defaultView || elem.parentWindow :
			false;
}

jQuery.offset = {
	setOffset: function( elem, options, i ) {
		var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,
			position = jQuery.css( elem, "position" ),
			curElem = jQuery( elem ),
			props = {};

		// set position first, in-case top/left are set even on static elem
		if ( position === "static" ) {
			elem.style.position = "relative";
		}

		curOffset = curElem.offset();
		curCSSTop = jQuery.css( elem, "top" );
		curCSSLeft = jQuery.css( elem, "left" );
		calculatePosition = ( position === "absolute" || position === "fixed" ) &&
			jQuery.inArray("auto", [ curCSSTop, curCSSLeft ] ) > -1;

		// need to be able to calculate position if either top or left is auto and position is either absolute or fixed
		if ( calculatePosition ) {
			curPosition = curElem.position();
			curTop = curPosition.top;
			curLeft = curPosition.left;
		} else {
			curTop = parseFloat( curCSSTop ) || 0;
			curLeft = parseFloat( curCSSLeft ) || 0;
		}

		if ( jQuery.isFunction( options ) ) {
			options = options.call( elem, i, curOffset );
		}

		if ( options.top != null ) {
			props.top = ( options.top - curOffset.top ) + curTop;
		}
		if ( options.left != null ) {
			props.left = ( options.left - curOffset.left ) + curLeft;
		}

		if ( "using" in options ) {
			options.using.call( elem, props );
		} else {
			curElem.css( props );
		}
	}
};

jQuery.fn.extend({
	offset: function( options ) {
		if ( arguments.length ) {
			return options === undefined ?
				this :
				this.each(function( i ) {
					jQuery.offset.setOffset( this, options, i );
				});
		}

		var docElem, win,
			box = { top: 0, left: 0 },
			elem = this[ 0 ],
			doc = elem && elem.ownerDocument;

		if ( !doc ) {
			return;
		}

		docElem = doc.documentElement;

		// Make sure it's not a disconnected DOM node
		if ( !jQuery.contains( docElem, elem ) ) {
			return box;
		}

		// If we don't have gBCR, just use 0,0 rather than error
		// BlackBerry 5, iOS 3 (original iPhone)
		if ( typeof elem.getBoundingClientRect !== strundefined ) {
			box = elem.getBoundingClientRect();
		}
		win = getWindow( doc );
		return {
			top: box.top  + ( win.pageYOffset || docElem.scrollTop )  - ( docElem.clientTop  || 0 ),
			left: box.left + ( win.pageXOffset || docElem.scrollLeft ) - ( docElem.clientLeft || 0 )
		};
	},

	position: function() {
		if ( !this[ 0 ] ) {
			return;
		}

		var offsetParent, offset,
			parentOffset = { top: 0, left: 0 },
			elem = this[ 0 ];

		// fixed elements are offset from window (parentOffset = {top:0, left: 0}, because it is its only offset parent
		if ( jQuery.css( elem, "position" ) === "fixed" ) {
			// we assume that getBoundingClientRect is available when computed position is fixed
			offset = elem.getBoundingClientRect();
		} else {
			// Get *real* offsetParent
			offsetParent = this.offsetParent();

			// Get correct offsets
			offset = this.offset();
			if ( !jQuery.nodeName( offsetParent[ 0 ], "html" ) ) {
				parentOffset = offsetParent.offset();
			}

			// Add offsetParent borders
			parentOffset.top  += jQuery.css( offsetParent[ 0 ], "borderTopWidth", true );
			parentOffset.left += jQuery.css( offsetParent[ 0 ], "borderLeftWidth", true );
		}

		// Subtract parent offsets and element margins
		// note: when an element has margin: auto the offsetLeft and marginLeft
		// are the same in Safari causing offset.left to incorrectly be 0
		return {
			top:  offset.top  - parentOffset.top - jQuery.css( elem, "marginTop", true ),
			left: offset.left - parentOffset.left - jQuery.css( elem, "marginLeft", true)
		};
	},

	offsetParent: function() {
		return this.map(function() {
			var offsetParent = this.offsetParent || docElem;

			while ( offsetParent && ( !jQuery.nodeName( offsetParent, "html" ) && jQuery.css( offsetParent, "position" ) === "static" ) ) {
				offsetParent = offsetParent.offsetParent;
			}
			return offsetParent || docElem;
		});
	}
});

// Create scrollLeft and scrollTop methods
jQuery.each( { scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function( method, prop ) {
	var top = /Y/.test( prop );

	jQuery.fn[ method ] = function( val ) {
		return access( this, function( elem, method, val ) {
			var win = getWindow( elem );

			if ( val === undefined ) {
				return win ? (prop in win) ? win[ prop ] :
					win.document.documentElement[ method ] :
					elem[ method ];
			}

			if ( win ) {
				win.scrollTo(
					!top ? val : jQuery( win ).scrollLeft(),
					top ? val : jQuery( win ).scrollTop()
				);

			} else {
				elem[ method ] = val;
			}
		}, method, val, arguments.length, null );
	};
});

// Add the top/left cssHooks using jQuery.fn.position
// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
// getComputedStyle returns percent when specified for top/left/bottom/right
// rather than make the css module depend on the offset module, we just check for it here
jQuery.each( [ "top", "left" ], function( i, prop ) {
	jQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,
		function( elem, computed ) {
			if ( computed ) {
				computed = curCSS( elem, prop );
				// if curCSS returns percentage, fallback to offset
				return rnumnonpx.test( computed ) ?
					jQuery( elem ).position()[ prop ] + "px" :
					computed;
			}
		}
	);
});


// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
jQuery.each( { Height: "height", Width: "width" }, function( name, type ) {
	jQuery.each( { padding: "inner" + name, content: type, "": "outer" + name }, function( defaultExtra, funcName ) {
		// margin is only for outerHeight, outerWidth
		jQuery.fn[ funcName ] = function( margin, value ) {
			var chainable = arguments.length && ( defaultExtra || typeof margin !== "boolean" ),
				extra = defaultExtra || ( margin === true || value === true ? "margin" : "border" );

			return access( this, function( elem, type, value ) {
				var doc;

				if ( jQuery.isWindow( elem ) ) {
					// As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there
					// isn't a whole lot we can do. See pull request at this URL for discussion:
					// https://github.com/jquery/jquery/pull/764
					return elem.document.documentElement[ "client" + name ];
				}

				// Get document width or height
				if ( elem.nodeType === 9 ) {
					doc = elem.documentElement;

					// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height], whichever is greatest
					// unfortunately, this causes bug #3838 in IE6/8 only, but there is currently no good, small way to fix it.
					return Math.max(
						elem.body[ "scroll" + name ], doc[ "scroll" + name ],
						elem.body[ "offset" + name ], doc[ "offset" + name ],
						doc[ "client" + name ]
					);
				}

				return value === undefined ?
					// Get width or height on the element, requesting but not forcing parseFloat
					jQuery.css( elem, type, extra ) :

					// Set width or height on the element
					jQuery.style( elem, type, value, extra );
			}, type, chainable ? margin : undefined, chainable, null );
		};
	});
});


// The number of elements contained in the matched element set
jQuery.fn.size = function() {
	return this.length;
};

jQuery.fn.andSelf = jQuery.fn.addBack;




// Register as a named AMD module, since jQuery can be concatenated with other
// files that may use define, but not via a proper concatenation script that
// understands anonymous AMD modules. A named AMD is safest and most robust
// way to register. Lowercase jquery is used because AMD module names are
// derived from file names, and jQuery is normally delivered in a lowercase
// file name. Do this after creating the global so that if an AMD module wants
// to call noConflict to hide this version of jQuery, it will work.
if ( typeof define === "function" && define.amd ) {
	define( "jquery", [], function() {
		return jQuery;
	});
}




var
	// Map over jQuery in case of overwrite
	_jQuery = window.jQuery,

	// Map over the $ in case of overwrite
	_$ = window.$;

jQuery.noConflict = function( deep ) {
	if ( window.$ === jQuery ) {
		window.$ = _$;
	}

	if ( deep && window.jQuery === jQuery ) {
		window.jQuery = _jQuery;
	}

	return jQuery;
};

// Expose jQuery and $ identifiers, even in
// AMD (#7102#comment:10, https://github.com/jquery/jquery/pull/557)
// and CommonJS for browser emulators (#13566)
if ( typeof noGlobal === strundefined ) {
	window.jQuery = window.$ = jQuery;
}




return jQuery;

}));

/*!

 handlebars v1.3.0

Copyright (C) 2011 by Yehuda Katz

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

@license
*/
/* exported Handlebars */
var Handlebars = (function() {
// handlebars/safe-string.js
var __module4__ = (function() {
  "use strict";
  var __exports__;
  // Build out our basic SafeString type
  function SafeString(string) {
    this.string = string;
  }

  SafeString.prototype.toString = function() {
    return "" + this.string;
  };

  __exports__ = SafeString;
  return __exports__;
})();

// handlebars/utils.js
var __module3__ = (function(__dependency1__) {
  "use strict";
  var __exports__ = {};
  /*jshint -W004 */
  var SafeString = __dependency1__;

  var escape = {
    "&": "&amp;",
    "<": "&lt;",
    ">": "&gt;",
    '"': "&quot;",
    "'": "&#x27;",
    "`": "&#x60;"
  };

  var badChars = /[&<>"'`]/g;
  var possible = /[&<>"'`]/;

  function escapeChar(chr) {
    return escape[chr] || "&amp;";
  }

  function extend(obj, value) {
    for(var key in value) {
      if(Object.prototype.hasOwnProperty.call(value, key)) {
        obj[key] = value[key];
      }
    }
  }

  __exports__.extend = extend;var toString = Object.prototype.toString;
  __exports__.toString = toString;
  // Sourced from lodash
  // https://github.com/bestiejs/lodash/blob/master/LICENSE.txt
  var isFunction = function(value) {
    return typeof value === 'function';
  };
  // fallback for older versions of Chrome and Safari
  if (isFunction(/x/)) {
    isFunction = function(value) {
      return typeof value === 'function' && toString.call(value) === '[object Function]';
    };
  }
  var isFunction;
  __exports__.isFunction = isFunction;
  var isArray = Array.isArray || function(value) {
    return (value && typeof value === 'object') ? toString.call(value) === '[object Array]' : false;
  };
  __exports__.isArray = isArray;

  function escapeExpression(string) {
    // don't escape SafeStrings, since they're already safe
    if (string instanceof SafeString) {
      return string.toString();
    } else if (!string && string !== 0) {
      return "";
    }

    // Force a string conversion as this will be done by the append regardless and
    // the regex test will do this transparently behind the scenes, causing issues if
    // an object's to string has escaped characters in it.
    string = "" + string;

    if(!possible.test(string)) { return string; }
    return string.replace(badChars, escapeChar);
  }

  __exports__.escapeExpression = escapeExpression;function isEmpty(value) {
    if (!value && value !== 0) {
      return true;
    } else if (isArray(value) && value.length === 0) {
      return true;
    } else {
      return false;
    }
  }

  __exports__.isEmpty = isEmpty;
  return __exports__;
})(__module4__);

// handlebars/exception.js
var __module5__ = (function() {
  "use strict";
  var __exports__;

  var errorProps = ['description', 'fileName', 'lineNumber', 'message', 'name', 'number', 'stack'];

  function Exception(message, node) {
    var line;
    if (node && node.firstLine) {
      line = node.firstLine;

      message += ' - ' + line + ':' + node.firstColumn;
    }

    var tmp = Error.prototype.constructor.call(this, message);

    // Unfortunately errors are not enumerable in Chrome (at least), so `for prop in tmp` doesn't work.
    for (var idx = 0; idx < errorProps.length; idx++) {
      this[errorProps[idx]] = tmp[errorProps[idx]];
    }

    if (line) {
      this.lineNumber = line;
      this.column = node.firstColumn;
    }
  }

  Exception.prototype = new Error();

  __exports__ = Exception;
  return __exports__;
})();

// handlebars/base.js
var __module2__ = (function(__dependency1__, __dependency2__) {
  "use strict";
  var __exports__ = {};
  var Utils = __dependency1__;
  var Exception = __dependency2__;

  var VERSION = "1.3.0";
  __exports__.VERSION = VERSION;var COMPILER_REVISION = 4;
  __exports__.COMPILER_REVISION = COMPILER_REVISION;
  var REVISION_CHANGES = {
    1: '<= 1.0.rc.2', // 1.0.rc.2 is actually rev2 but doesn't report it
    2: '== 1.0.0-rc.3',
    3: '== 1.0.0-rc.4',
    4: '>= 1.0.0'
  };
  __exports__.REVISION_CHANGES = REVISION_CHANGES;
  var isArray = Utils.isArray,
      isFunction = Utils.isFunction,
      toString = Utils.toString,
      objectType = '[object Object]';

  function HandlebarsEnvironment(helpers, partials) {
    this.helpers = helpers || {};
    this.partials = partials || {};

    registerDefaultHelpers(this);
  }

  __exports__.HandlebarsEnvironment = HandlebarsEnvironment;HandlebarsEnvironment.prototype = {
    constructor: HandlebarsEnvironment,

    logger: logger,
    log: log,

    registerHelper: function(name, fn, inverse) {
      if (toString.call(name) === objectType) {
        if (inverse || fn) { throw new Exception('Arg not supported with multiple helpers'); }
        Utils.extend(this.helpers, name);
      } else {
        if (inverse) { fn.not = inverse; }
        this.helpers[name] = fn;
      }
    },

    registerPartial: function(name, str) {
      if (toString.call(name) === objectType) {
        Utils.extend(this.partials,  name);
      } else {
        this.partials[name] = str;
      }
    }
  };

  function registerDefaultHelpers(instance) {
    instance.registerHelper('helperMissing', function(arg) {
      if(arguments.length === 2) {
        return undefined;
      } else {
        throw new Exception("Missing helper: '" + arg + "'");
      }
    });

    instance.registerHelper('blockHelperMissing', function(context, options) {
      var inverse = options.inverse || function() {}, fn = options.fn;

      if (isFunction(context)) { context = context.call(this); }

      if(context === true) {
        return fn(this);
      } else if(context === false || context == null) {
        return inverse(this);
      } else if (isArray(context)) {
        if(context.length > 0) {
          return instance.helpers.each(context, options);
        } else {
          return inverse(this);
        }
      } else {
        return fn(context);
      }
    });

    instance.registerHelper('each', function(context, options) {
      var fn = options.fn, inverse = options.inverse;
      var i = 0, ret = "", data;

      if (isFunction(context)) { context = context.call(this); }

      if (options.data) {
        data = createFrame(options.data);
      }

      if(context && typeof context === 'object') {
        if (isArray(context)) {
          for(var j = context.length; i<j; i++) {
            if (data) {
              data.index = i;
              data.first = (i === 0);
              data.last  = (i === (context.length-1));
            }
            ret = ret + fn(context[i], { data: data });
          }
        } else {
          for(var key in context) {
            if(context.hasOwnProperty(key)) {
              if(data) { 
                data.key = key; 
                data.index = i;
                data.first = (i === 0);
              }
              ret = ret + fn(context[key], {data: data});
              i++;
            }
          }
        }
      }

      if(i === 0){
        ret = inverse(this);
      }

      return ret;
    });

    instance.registerHelper('if', function(conditional, options) {
      if (isFunction(conditional)) { conditional = conditional.call(this); }

      // Default behavior is to render the positive path if the value is truthy and not empty.
      // The `includeZero` option may be set to treat the condtional as purely not empty based on the
      // behavior of isEmpty. Effectively this determines if 0 is handled by the positive path or negative.
      if ((!options.hash.includeZero && !conditional) || Utils.isEmpty(conditional)) {
        return options.inverse(this);
      } else {
        return options.fn(this);
      }
    });

    instance.registerHelper('unless', function(conditional, options) {
      return instance.helpers['if'].call(this, conditional, {fn: options.inverse, inverse: options.fn, hash: options.hash});
    });

    instance.registerHelper('with', function(context, options) {
      if (isFunction(context)) { context = context.call(this); }

      if (!Utils.isEmpty(context)) return options.fn(context);
    });

    instance.registerHelper('log', function(context, options) {
      var level = options.data && options.data.level != null ? parseInt(options.data.level, 10) : 1;
      instance.log(level, context);
    });
  }

  var logger = {
    methodMap: { 0: 'debug', 1: 'info', 2: 'warn', 3: 'error' },

    // State enum
    DEBUG: 0,
    INFO: 1,
    WARN: 2,
    ERROR: 3,
    level: 3,

    // can be overridden in the host environment
    log: function(level, obj) {
      if (logger.level <= level) {
        var method = logger.methodMap[level];
        if (typeof console !== 'undefined' && console[method]) {
          console[method].call(console, obj);
        }
      }
    }
  };
  __exports__.logger = logger;
  function log(level, obj) { logger.log(level, obj); }

  __exports__.log = log;var createFrame = function(object) {
    var obj = {};
    Utils.extend(obj, object);
    return obj;
  };
  __exports__.createFrame = createFrame;
  return __exports__;
})(__module3__, __module5__);

// handlebars/runtime.js
var __module6__ = (function(__dependency1__, __dependency2__, __dependency3__) {
  "use strict";
  var __exports__ = {};
  var Utils = __dependency1__;
  var Exception = __dependency2__;
  var COMPILER_REVISION = __dependency3__.COMPILER_REVISION;
  var REVISION_CHANGES = __dependency3__.REVISION_CHANGES;

  function checkRevision(compilerInfo) {
    var compilerRevision = compilerInfo && compilerInfo[0] || 1,
        currentRevision = COMPILER_REVISION;

    if (compilerRevision !== currentRevision) {
      if (compilerRevision < currentRevision) {
        var runtimeVersions = REVISION_CHANGES[currentRevision],
            compilerVersions = REVISION_CHANGES[compilerRevision];
        throw new Exception("Template was precompiled with an older version of Handlebars than the current runtime. "+
              "Please update your precompiler to a newer version ("+runtimeVersions+") or downgrade your runtime to an older version ("+compilerVersions+").");
      } else {
        // Use the embedded version info since the runtime doesn't know about this revision yet
        throw new Exception("Template was precompiled with a newer version of Handlebars than the current runtime. "+
              "Please update your runtime to a newer version ("+compilerInfo[1]+").");
      }
    }
  }

  __exports__.checkRevision = checkRevision;// TODO: Remove this line and break up compilePartial

  function template(templateSpec, env) {
    if (!env) {
      throw new Exception("No environment passed to template");
    }

    // Note: Using env.VM references rather than local var references throughout this section to allow
    // for external users to override these as psuedo-supported APIs.
    var invokePartialWrapper = function(partial, name, context, helpers, partials, data) {
      var result = env.VM.invokePartial.apply(this, arguments);
      if (result != null) { return result; }

      if (env.compile) {
        var options = { helpers: helpers, partials: partials, data: data };
        partials[name] = env.compile(partial, { data: data !== undefined }, env);
        return partials[name](context, options);
      } else {
        throw new Exception("The partial " + name + " could not be compiled when running in runtime-only mode");
      }
    };

    // Just add water
    var container = {
      escapeExpression: Utils.escapeExpression,
      invokePartial: invokePartialWrapper,
      programs: [],
      program: function(i, fn, data) {
        var programWrapper = this.programs[i];
        if(data) {
          programWrapper = program(i, fn, data);
        } else if (!programWrapper) {
          programWrapper = this.programs[i] = program(i, fn);
        }
        return programWrapper;
      },
      merge: function(param, common) {
        var ret = param || common;

        if (param && common && (param !== common)) {
          ret = {};
          Utils.extend(ret, common);
          Utils.extend(ret, param);
        }
        return ret;
      },
      programWithDepth: env.VM.programWithDepth,
      noop: env.VM.noop,
      compilerInfo: null
    };

    return function(context, options) {
      options = options || {};
      var namespace = options.partial ? options : env,
          helpers,
          partials;

      if (!options.partial) {
        helpers = options.helpers;
        partials = options.partials;
      }
      var result = templateSpec.call(
            container,
            namespace, context,
            helpers,
            partials,
            options.data);

      if (!options.partial) {
        env.VM.checkRevision(container.compilerInfo);
      }

      return result;
    };
  }

  __exports__.template = template;function programWithDepth(i, fn, data /*, $depth */) {
    var args = Array.prototype.slice.call(arguments, 3);

    var prog = function(context, options) {
      options = options || {};

      return fn.apply(this, [context, options.data || data].concat(args));
    };
    prog.program = i;
    prog.depth = args.length;
    return prog;
  }

  __exports__.programWithDepth = programWithDepth;function program(i, fn, data) {
    var prog = function(context, options) {
      options = options || {};

      return fn(context, options.data || data);
    };
    prog.program = i;
    prog.depth = 0;
    return prog;
  }

  __exports__.program = program;function invokePartial(partial, name, context, helpers, partials, data) {
    var options = { partial: true, helpers: helpers, partials: partials, data: data };

    if(partial === undefined) {
      throw new Exception("The partial " + name + " could not be found");
    } else if(partial instanceof Function) {
      return partial(context, options);
    }
  }

  __exports__.invokePartial = invokePartial;function noop() { return ""; }

  __exports__.noop = noop;
  return __exports__;
})(__module3__, __module5__, __module2__);

// handlebars.runtime.js
var __module1__ = (function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__) {
  "use strict";
  var __exports__;
  /*globals Handlebars: true */
  var base = __dependency1__;

  // Each of these augment the Handlebars object. No need to setup here.
  // (This is done to easily share code between commonjs and browse envs)
  var SafeString = __dependency2__;
  var Exception = __dependency3__;
  var Utils = __dependency4__;
  var runtime = __dependency5__;

  // For compatibility and usage outside of module systems, make the Handlebars object a namespace
  var create = function() {
    var hb = new base.HandlebarsEnvironment();

    Utils.extend(hb, base);
    hb.SafeString = SafeString;
    hb.Exception = Exception;
    hb.Utils = Utils;

    hb.VM = runtime;
    hb.template = function(spec) {
      return runtime.template(spec, hb);
    };

    return hb;
  };

  var Handlebars = create();
  Handlebars.create = create;

  __exports__ = Handlebars;
  return __exports__;
})(__module2__, __module4__, __module5__, __module3__, __module6__);

// handlebars/compiler/ast.js
var __module7__ = (function(__dependency1__) {
  "use strict";
  var __exports__;
  var Exception = __dependency1__;

  function LocationInfo(locInfo){
    locInfo = locInfo || {};
    this.firstLine   = locInfo.first_line;
    this.firstColumn = locInfo.first_column;
    this.lastColumn  = locInfo.last_column;
    this.lastLine    = locInfo.last_line;
  }

  var AST = {
    ProgramNode: function(statements, inverseStrip, inverse, locInfo) {
      var inverseLocationInfo, firstInverseNode;
      if (arguments.length === 3) {
        locInfo = inverse;
        inverse = null;
      } else if (arguments.length === 2) {
        locInfo = inverseStrip;
        inverseStrip = null;
      }

      LocationInfo.call(this, locInfo);
      this.type = "program";
      this.statements = statements;
      this.strip = {};

      if(inverse) {
        firstInverseNode = inverse[0];
        if (firstInverseNode) {
          inverseLocationInfo = {
            first_line: firstInverseNode.firstLine,
            last_line: firstInverseNode.lastLine,
            last_column: firstInverseNode.lastColumn,
            first_column: firstInverseNode.firstColumn
          };
          this.inverse = new AST.ProgramNode(inverse, inverseStrip, inverseLocationInfo);
        } else {
          this.inverse = new AST.ProgramNode(inverse, inverseStrip);
        }
        this.strip.right = inverseStrip.left;
      } else if (inverseStrip) {
        this.strip.left = inverseStrip.right;
      }
    },

    MustacheNode: function(rawParams, hash, open, strip, locInfo) {
      LocationInfo.call(this, locInfo);
      this.type = "mustache";
      this.strip = strip;

      // Open may be a string parsed from the parser or a passed boolean flag
      if (open != null && open.charAt) {
        // Must use charAt to support IE pre-10
        var escapeFlag = open.charAt(3) || open.charAt(2);
        this.escaped = escapeFlag !== '{' && escapeFlag !== '&';
      } else {
        this.escaped = !!open;
      }

      if (rawParams instanceof AST.SexprNode) {
        this.sexpr = rawParams;
      } else {
        // Support old AST API
        this.sexpr = new AST.SexprNode(rawParams, hash);
      }

      this.sexpr.isRoot = true;

      // Support old AST API that stored this info in MustacheNode
      this.id = this.sexpr.id;
      this.params = this.sexpr.params;
      this.hash = this.sexpr.hash;
      this.eligibleHelper = this.sexpr.eligibleHelper;
      this.isHelper = this.sexpr.isHelper;
    },

    SexprNode: function(rawParams, hash, locInfo) {
      LocationInfo.call(this, locInfo);

      this.type = "sexpr";
      this.hash = hash;

      var id = this.id = rawParams[0];
      var params = this.params = rawParams.slice(1);

      // a mustache is an eligible helper if:
      // * its id is simple (a single part, not `this` or `..`)
      var eligibleHelper = this.eligibleHelper = id.isSimple;

      // a mustache is definitely a helper if:
      // * it is an eligible helper, and
      // * it has at least one parameter or hash segment
      this.isHelper = eligibleHelper && (params.length || hash);

      // if a mustache is an eligible helper but not a definite
      // helper, it is ambiguous, and will be resolved in a later
      // pass or at runtime.
    },

    PartialNode: function(partialName, context, strip, locInfo) {
      LocationInfo.call(this, locInfo);
      this.type         = "partial";
      this.partialName  = partialName;
      this.context      = context;
      this.strip = strip;
    },

    BlockNode: function(mustache, program, inverse, close, locInfo) {
      LocationInfo.call(this, locInfo);

      if(mustache.sexpr.id.original !== close.path.original) {
        throw new Exception(mustache.sexpr.id.original + " doesn't match " + close.path.original, this);
      }

      this.type = 'block';
      this.mustache = mustache;
      this.program  = program;
      this.inverse  = inverse;

      this.strip = {
        left: mustache.strip.left,
        right: close.strip.right
      };

      (program || inverse).strip.left = mustache.strip.right;
      (inverse || program).strip.right = close.strip.left;

      if (inverse && !program) {
        this.isInverse = true;
      }
    },

    ContentNode: function(string, locInfo) {
      LocationInfo.call(this, locInfo);
      this.type = "content";
      this.string = string;
    },

    HashNode: function(pairs, locInfo) {
      LocationInfo.call(this, locInfo);
      this.type = "hash";
      this.pairs = pairs;
    },

    IdNode: function(parts, locInfo) {
      LocationInfo.call(this, locInfo);
      this.type = "ID";

      var original = "",
          dig = [],
          depth = 0;

      for(var i=0,l=parts.length; i<l; i++) {
        var part = parts[i].part;
        original += (parts[i].separator || '') + part;

        if (part === ".." || part === "." || part === "this") {
          if (dig.length > 0) {
            throw new Exception("Invalid path: " + original, this);
          } else if (part === "..") {
            depth++;
          } else {
            this.isScoped = true;
          }
        } else {
          dig.push(part);
        }
      }

      this.original = original;
      this.parts    = dig;
      this.string   = dig.join('.');
      this.depth    = depth;

      // an ID is simple if it only has one part, and that part is not
      // `..` or `this`.
      this.isSimple = parts.length === 1 && !this.isScoped && depth === 0;

      this.stringModeValue = this.string;
    },

    PartialNameNode: function(name, locInfo) {
      LocationInfo.call(this, locInfo);
      this.type = "PARTIAL_NAME";
      this.name = name.original;
    },

    DataNode: function(id, locInfo) {
      LocationInfo.call(this, locInfo);
      this.type = "DATA";
      this.id = id;
    },

    StringNode: function(string, locInfo) {
      LocationInfo.call(this, locInfo);
      this.type = "STRING";
      this.original =
        this.string =
        this.stringModeValue = string;
    },

    IntegerNode: function(integer, locInfo) {
      LocationInfo.call(this, locInfo);
      this.type = "INTEGER";
      this.original =
        this.integer = integer;
      this.stringModeValue = Number(integer);
    },

    BooleanNode: function(bool, locInfo) {
      LocationInfo.call(this, locInfo);
      this.type = "BOOLEAN";
      this.bool = bool;
      this.stringModeValue = bool === "true";
    },

    CommentNode: function(comment, locInfo) {
      LocationInfo.call(this, locInfo);
      this.type = "comment";
      this.comment = comment;
    }
  };

  // Must be exported as an object rather than the root of the module as the jison lexer
  // most modify the object to operate properly.
  __exports__ = AST;
  return __exports__;
})(__module5__);

// handlebars/compiler/parser.js
var __module9__ = (function() {
  "use strict";
  var __exports__;
  /* jshint ignore:start */
  /* Jison generated parser */
  var handlebars = (function(){
  var parser = {trace: function trace() { },
  yy: {},
  symbols_: {"error":2,"root":3,"statements":4,"EOF":5,"program":6,"simpleInverse":7,"statement":8,"openInverse":9,"closeBlock":10,"openBlock":11,"mustache":12,"partial":13,"CONTENT":14,"COMMENT":15,"OPEN_BLOCK":16,"sexpr":17,"CLOSE":18,"OPEN_INVERSE":19,"OPEN_ENDBLOCK":20,"path":21,"OPEN":22,"OPEN_UNESCAPED":23,"CLOSE_UNESCAPED":24,"OPEN_PARTIAL":25,"partialName":26,"partial_option0":27,"sexpr_repetition0":28,"sexpr_option0":29,"dataName":30,"param":31,"STRING":32,"INTEGER":33,"BOOLEAN":34,"OPEN_SEXPR":35,"CLOSE_SEXPR":36,"hash":37,"hash_repetition_plus0":38,"hashSegment":39,"ID":40,"EQUALS":41,"DATA":42,"pathSegments":43,"SEP":44,"$accept":0,"$end":1},
  terminals_: {2:"error",5:"EOF",14:"CONTENT",15:"COMMENT",16:"OPEN_BLOCK",18:"CLOSE",19:"OPEN_INVERSE",20:"OPEN_ENDBLOCK",22:"OPEN",23:"OPEN_UNESCAPED",24:"CLOSE_UNESCAPED",25:"OPEN_PARTIAL",32:"STRING",33:"INTEGER",34:"BOOLEAN",35:"OPEN_SEXPR",36:"CLOSE_SEXPR",40:"ID",41:"EQUALS",42:"DATA",44:"SEP"},
  productions_: [0,[3,2],[3,1],[6,2],[6,3],[6,2],[6,1],[6,1],[6,0],[4,1],[4,2],[8,3],[8,3],[8,1],[8,1],[8,1],[8,1],[11,3],[9,3],[10,3],[12,3],[12,3],[13,4],[7,2],[17,3],[17,1],[31,1],[31,1],[31,1],[31,1],[31,1],[31,3],[37,1],[39,3],[26,1],[26,1],[26,1],[30,2],[21,1],[43,3],[43,1],[27,0],[27,1],[28,0],[28,2],[29,0],[29,1],[38,1],[38,2]],
  performAction: function anonymous(yytext,yyleng,yylineno,yy,yystate,$$,_$) {

  var $0 = $$.length - 1;
  switch (yystate) {
  case 1: return new yy.ProgramNode($$[$0-1], this._$); 
  break;
  case 2: return new yy.ProgramNode([], this._$); 
  break;
  case 3:this.$ = new yy.ProgramNode([], $$[$0-1], $$[$0], this._$);
  break;
  case 4:this.$ = new yy.ProgramNode($$[$0-2], $$[$0-1], $$[$0], this._$);
  break;
  case 5:this.$ = new yy.ProgramNode($$[$0-1], $$[$0], [], this._$);
  break;
  case 6:this.$ = new yy.ProgramNode($$[$0], this._$);
  break;
  case 7:this.$ = new yy.ProgramNode([], this._$);
  break;
  case 8:this.$ = new yy.ProgramNode([], this._$);
  break;
  case 9:this.$ = [$$[$0]];
  break;
  case 10: $$[$0-1].push($$[$0]); this.$ = $$[$0-1]; 
  break;
  case 11:this.$ = new yy.BlockNode($$[$0-2], $$[$0-1].inverse, $$[$0-1], $$[$0], this._$);
  break;
  case 12:this.$ = new yy.BlockNode($$[$0-2], $$[$0-1], $$[$0-1].inverse, $$[$0], this._$);
  break;
  case 13:this.$ = $$[$0];
  break;
  case 14:this.$ = $$[$0];
  break;
  case 15:this.$ = new yy.ContentNode($$[$0], this._$);
  break;
  case 16:this.$ = new yy.CommentNode($$[$0], this._$);
  break;
  case 17:this.$ = new yy.MustacheNode($$[$0-1], null, $$[$0-2], stripFlags($$[$0-2], $$[$0]), this._$);
  break;
  case 18:this.$ = new yy.MustacheNode($$[$0-1], null, $$[$0-2], stripFlags($$[$0-2], $$[$0]), this._$);
  break;
  case 19:this.$ = {path: $$[$0-1], strip: stripFlags($$[$0-2], $$[$0])};
  break;
  case 20:this.$ = new yy.MustacheNode($$[$0-1], null, $$[$0-2], stripFlags($$[$0-2], $$[$0]), this._$);
  break;
  case 21:this.$ = new yy.MustacheNode($$[$0-1], null, $$[$0-2], stripFlags($$[$0-2], $$[$0]), this._$);
  break;
  case 22:this.$ = new yy.PartialNode($$[$0-2], $$[$0-1], stripFlags($$[$0-3], $$[$0]), this._$);
  break;
  case 23:this.$ = stripFlags($$[$0-1], $$[$0]);
  break;
  case 24:this.$ = new yy.SexprNode([$$[$0-2]].concat($$[$0-1]), $$[$0], this._$);
  break;
  case 25:this.$ = new yy.SexprNode([$$[$0]], null, this._$);
  break;
  case 26:this.$ = $$[$0];
  break;
  case 27:this.$ = new yy.StringNode($$[$0], this._$);
  break;
  case 28:this.$ = new yy.IntegerNode($$[$0], this._$);
  break;
  case 29:this.$ = new yy.BooleanNode($$[$0], this._$);
  break;
  case 30:this.$ = $$[$0];
  break;
  case 31:$$[$0-1].isHelper = true; this.$ = $$[$0-1];
  break;
  case 32:this.$ = new yy.HashNode($$[$0], this._$);
  break;
  case 33:this.$ = [$$[$0-2], $$[$0]];
  break;
  case 34:this.$ = new yy.PartialNameNode($$[$0], this._$);
  break;
  case 35:this.$ = new yy.PartialNameNode(new yy.StringNode($$[$0], this._$), this._$);
  break;
  case 36:this.$ = new yy.PartialNameNode(new yy.IntegerNode($$[$0], this._$));
  break;
  case 37:this.$ = new yy.DataNode($$[$0], this._$);
  break;
  case 38:this.$ = new yy.IdNode($$[$0], this._$);
  break;
  case 39: $$[$0-2].push({part: $$[$0], separator: $$[$0-1]}); this.$ = $$[$0-2]; 
  break;
  case 40:this.$ = [{part: $$[$0]}];
  break;
  case 43:this.$ = [];
  break;
  case 44:$$[$0-1].push($$[$0]);
  break;
  case 47:this.$ = [$$[$0]];
  break;
  case 48:$$[$0-1].push($$[$0]);
  break;
  }
  },
  table: [{3:1,4:2,5:[1,3],8:4,9:5,11:6,12:7,13:8,14:[1,9],15:[1,10],16:[1,12],19:[1,11],22:[1,13],23:[1,14],25:[1,15]},{1:[3]},{5:[1,16],8:17,9:5,11:6,12:7,13:8,14:[1,9],15:[1,10],16:[1,12],19:[1,11],22:[1,13],23:[1,14],25:[1,15]},{1:[2,2]},{5:[2,9],14:[2,9],15:[2,9],16:[2,9],19:[2,9],20:[2,9],22:[2,9],23:[2,9],25:[2,9]},{4:20,6:18,7:19,8:4,9:5,11:6,12:7,13:8,14:[1,9],15:[1,10],16:[1,12],19:[1,21],20:[2,8],22:[1,13],23:[1,14],25:[1,15]},{4:20,6:22,7:19,8:4,9:5,11:6,12:7,13:8,14:[1,9],15:[1,10],16:[1,12],19:[1,21],20:[2,8],22:[1,13],23:[1,14],25:[1,15]},{5:[2,13],14:[2,13],15:[2,13],16:[2,13],19:[2,13],20:[2,13],22:[2,13],23:[2,13],25:[2,13]},{5:[2,14],14:[2,14],15:[2,14],16:[2,14],19:[2,14],20:[2,14],22:[2,14],23:[2,14],25:[2,14]},{5:[2,15],14:[2,15],15:[2,15],16:[2,15],19:[2,15],20:[2,15],22:[2,15],23:[2,15],25:[2,15]},{5:[2,16],14:[2,16],15:[2,16],16:[2,16],19:[2,16],20:[2,16],22:[2,16],23:[2,16],25:[2,16]},{17:23,21:24,30:25,40:[1,28],42:[1,27],43:26},{17:29,21:24,30:25,40:[1,28],42:[1,27],43:26},{17:30,21:24,30:25,40:[1,28],42:[1,27],43:26},{17:31,21:24,30:25,40:[1,28],42:[1,27],43:26},{21:33,26:32,32:[1,34],33:[1,35],40:[1,28],43:26},{1:[2,1]},{5:[2,10],14:[2,10],15:[2,10],16:[2,10],19:[2,10],20:[2,10],22:[2,10],23:[2,10],25:[2,10]},{10:36,20:[1,37]},{4:38,8:4,9:5,11:6,12:7,13:8,14:[1,9],15:[1,10],16:[1,12],19:[1,11],20:[2,7],22:[1,13],23:[1,14],25:[1,15]},{7:39,8:17,9:5,11:6,12:7,13:8,14:[1,9],15:[1,10],16:[1,12],19:[1,21],20:[2,6],22:[1,13],23:[1,14],25:[1,15]},{17:23,18:[1,40],21:24,30:25,40:[1,28],42:[1,27],43:26},{10:41,20:[1,37]},{18:[1,42]},{18:[2,43],24:[2,43],28:43,32:[2,43],33:[2,43],34:[2,43],35:[2,43],36:[2,43],40:[2,43],42:[2,43]},{18:[2,25],24:[2,25],36:[2,25]},{18:[2,38],24:[2,38],32:[2,38],33:[2,38],34:[2,38],35:[2,38],36:[2,38],40:[2,38],42:[2,38],44:[1,44]},{21:45,40:[1,28],43:26},{18:[2,40],24:[2,40],32:[2,40],33:[2,40],34:[2,40],35:[2,40],36:[2,40],40:[2,40],42:[2,40],44:[2,40]},{18:[1,46]},{18:[1,47]},{24:[1,48]},{18:[2,41],21:50,27:49,40:[1,28],43:26},{18:[2,34],40:[2,34]},{18:[2,35],40:[2,35]},{18:[2,36],40:[2,36]},{5:[2,11],14:[2,11],15:[2,11],16:[2,11],19:[2,11],20:[2,11],22:[2,11],23:[2,11],25:[2,11]},{21:51,40:[1,28],43:26},{8:17,9:5,11:6,12:7,13:8,14:[1,9],15:[1,10],16:[1,12],19:[1,11],20:[2,3],22:[1,13],23:[1,14],25:[1,15]},{4:52,8:4,9:5,11:6,12:7,13:8,14:[1,9],15:[1,10],16:[1,12],19:[1,11],20:[2,5],22:[1,13],23:[1,14],25:[1,15]},{14:[2,23],15:[2,23],16:[2,23],19:[2,23],20:[2,23],22:[2,23],23:[2,23],25:[2,23]},{5:[2,12],14:[2,12],15:[2,12],16:[2,12],19:[2,12],20:[2,12],22:[2,12],23:[2,12],25:[2,12]},{14:[2,18],15:[2,18],16:[2,18],19:[2,18],20:[2,18],22:[2,18],23:[2,18],25:[2,18]},{18:[2,45],21:56,24:[2,45],29:53,30:60,31:54,32:[1,57],33:[1,58],34:[1,59],35:[1,61],36:[2,45],37:55,38:62,39:63,40:[1,64],42:[1,27],43:26},{40:[1,65]},{18:[2,37],24:[2,37],32:[2,37],33:[2,37],34:[2,37],35:[2,37],36:[2,37],40:[2,37],42:[2,37]},{14:[2,17],15:[2,17],16:[2,17],19:[2,17],20:[2,17],22:[2,17],23:[2,17],25:[2,17]},{5:[2,20],14:[2,20],15:[2,20],16:[2,20],19:[2,20],20:[2,20],22:[2,20],23:[2,20],25:[2,20]},{5:[2,21],14:[2,21],15:[2,21],16:[2,21],19:[2,21],20:[2,21],22:[2,21],23:[2,21],25:[2,21]},{18:[1,66]},{18:[2,42]},{18:[1,67]},{8:17,9:5,11:6,12:7,13:8,14:[1,9],15:[1,10],16:[1,12],19:[1,11],20:[2,4],22:[1,13],23:[1,14],25:[1,15]},{18:[2,24],24:[2,24],36:[2,24]},{18:[2,44],24:[2,44],32:[2,44],33:[2,44],34:[2,44],35:[2,44],36:[2,44],40:[2,44],42:[2,44]},{18:[2,46],24:[2,46],36:[2,46]},{18:[2,26],24:[2,26],32:[2,26],33:[2,26],34:[2,26],35:[2,26],36:[2,26],40:[2,26],42:[2,26]},{18:[2,27],24:[2,27],32:[2,27],33:[2,27],34:[2,27],35:[2,27],36:[2,27],40:[2,27],42:[2,27]},{18:[2,28],24:[2,28],32:[2,28],33:[2,28],34:[2,28],35:[2,28],36:[2,28],40:[2,28],42:[2,28]},{18:[2,29],24:[2,29],32:[2,29],33:[2,29],34:[2,29],35:[2,29],36:[2,29],40:[2,29],42:[2,29]},{18:[2,30],24:[2,30],32:[2,30],33:[2,30],34:[2,30],35:[2,30],36:[2,30],40:[2,30],42:[2,30]},{17:68,21:24,30:25,40:[1,28],42:[1,27],43:26},{18:[2,32],24:[2,32],36:[2,32],39:69,40:[1,70]},{18:[2,47],24:[2,47],36:[2,47],40:[2,47]},{18:[2,40],24:[2,40],32:[2,40],33:[2,40],34:[2,40],35:[2,40],36:[2,40],40:[2,40],41:[1,71],42:[2,40],44:[2,40]},{18:[2,39],24:[2,39],32:[2,39],33:[2,39],34:[2,39],35:[2,39],36:[2,39],40:[2,39],42:[2,39],44:[2,39]},{5:[2,22],14:[2,22],15:[2,22],16:[2,22],19:[2,22],20:[2,22],22:[2,22],23:[2,22],25:[2,22]},{5:[2,19],14:[2,19],15:[2,19],16:[2,19],19:[2,19],20:[2,19],22:[2,19],23:[2,19],25:[2,19]},{36:[1,72]},{18:[2,48],24:[2,48],36:[2,48],40:[2,48]},{41:[1,71]},{21:56,30:60,31:73,32:[1,57],33:[1,58],34:[1,59],35:[1,61],40:[1,28],42:[1,27],43:26},{18:[2,31],24:[2,31],32:[2,31],33:[2,31],34:[2,31],35:[2,31],36:[2,31],40:[2,31],42:[2,31]},{18:[2,33],24:[2,33],36:[2,33],40:[2,33]}],
  defaultActions: {3:[2,2],16:[2,1],50:[2,42]},
  parseError: function parseError(str, hash) {
      throw new Error(str);
  },
  parse: function parse(input) {
      var self = this, stack = [0], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, recovering = 0, TERROR = 2, EOF = 1;
      this.lexer.setInput(input);
      this.lexer.yy = this.yy;
      this.yy.lexer = this.lexer;
      this.yy.parser = this;
      if (typeof this.lexer.yylloc == "undefined")
          this.lexer.yylloc = {};
      var yyloc = this.lexer.yylloc;
      lstack.push(yyloc);
      var ranges = this.lexer.options && this.lexer.options.ranges;
      if (typeof this.yy.parseError === "function")
          this.parseError = this.yy.parseError;
      function popStack(n) {
          stack.length = stack.length - 2 * n;
          vstack.length = vstack.length - n;
          lstack.length = lstack.length - n;
      }
      function lex() {
          var token;
          token = self.lexer.lex() || 1;
          if (typeof token !== "number") {
              token = self.symbols_[token] || token;
          }
          return token;
      }
      var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
      while (true) {
          state = stack[stack.length - 1];
          if (this.defaultActions[state]) {
              action = this.defaultActions[state];
          } else {
              if (symbol === null || typeof symbol == "undefined") {
                  symbol = lex();
              }
              action = table[state] && table[state][symbol];
          }
          if (typeof action === "undefined" || !action.length || !action[0]) {
              var errStr = "";
              if (!recovering) {
                  expected = [];
                  for (p in table[state])
                      if (this.terminals_[p] && p > 2) {
                          expected.push("'" + this.terminals_[p] + "'");
                      }
                  if (this.lexer.showPosition) {
                      errStr = "Parse error on line " + (yylineno + 1) + ":\n" + this.lexer.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
                  } else {
                      errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == 1?"end of input":"'" + (this.terminals_[symbol] || symbol) + "'");
                  }
                  this.parseError(errStr, {text: this.lexer.match, token: this.terminals_[symbol] || symbol, line: this.lexer.yylineno, loc: yyloc, expected: expected});
              }
          }
          if (action[0] instanceof Array && action.length > 1) {
              throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
          }
          switch (action[0]) {
          case 1:
              stack.push(symbol);
              vstack.push(this.lexer.yytext);
              lstack.push(this.lexer.yylloc);
              stack.push(action[1]);
              symbol = null;
              if (!preErrorSymbol) {
                  yyleng = this.lexer.yyleng;
                  yytext = this.lexer.yytext;
                  yylineno = this.lexer.yylineno;
                  yyloc = this.lexer.yylloc;
                  if (recovering > 0)
                      recovering--;
              } else {
                  symbol = preErrorSymbol;
                  preErrorSymbol = null;
              }
              break;
          case 2:
              len = this.productions_[action[1]][1];
              yyval.$ = vstack[vstack.length - len];
              yyval._$ = {first_line: lstack[lstack.length - (len || 1)].first_line, last_line: lstack[lstack.length - 1].last_line, first_column: lstack[lstack.length - (len || 1)].first_column, last_column: lstack[lstack.length - 1].last_column};
              if (ranges) {
                  yyval._$.range = [lstack[lstack.length - (len || 1)].range[0], lstack[lstack.length - 1].range[1]];
              }
              r = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);
              if (typeof r !== "undefined") {
                  return r;
              }
              if (len) {
                  stack = stack.slice(0, -1 * len * 2);
                  vstack = vstack.slice(0, -1 * len);
                  lstack = lstack.slice(0, -1 * len);
              }
              stack.push(this.productions_[action[1]][0]);
              vstack.push(yyval.$);
              lstack.push(yyval._$);
              newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
              stack.push(newState);
              break;
          case 3:
              return true;
          }
      }
      return true;
  }
  };


  function stripFlags(open, close) {
    return {
      left: open.charAt(2) === '~',
      right: close.charAt(0) === '~' || close.charAt(1) === '~'
    };
  }

  /* Jison generated lexer */
  var lexer = (function(){
  var lexer = ({EOF:1,
  parseError:function parseError(str, hash) {
          if (this.yy.parser) {
              this.yy.parser.parseError(str, hash);
          } else {
              throw new Error(str);
          }
      },
  setInput:function (input) {
          this._input = input;
          this._more = this._less = this.done = false;
          this.yylineno = this.yyleng = 0;
          this.yytext = this.matched = this.match = '';
          this.conditionStack = ['INITIAL'];
          this.yylloc = {first_line:1,first_column:0,last_line:1,last_column:0};
          if (this.options.ranges) this.yylloc.range = [0,0];
          this.offset = 0;
          return this;
      },
  input:function () {
          var ch = this._input[0];
          this.yytext += ch;
          this.yyleng++;
          this.offset++;
          this.match += ch;
          this.matched += ch;
          var lines = ch.match(/(?:\r\n?|\n).*/g);
          if (lines) {
              this.yylineno++;
              this.yylloc.last_line++;
          } else {
              this.yylloc.last_column++;
          }
          if (this.options.ranges) this.yylloc.range[1]++;

          this._input = this._input.slice(1);
          return ch;
      },
  unput:function (ch) {
          var len = ch.length;
          var lines = ch.split(/(?:\r\n?|\n)/g);

          this._input = ch + this._input;
          this.yytext = this.yytext.substr(0, this.yytext.length-len-1);
          //this.yyleng -= len;
          this.offset -= len;
          var oldLines = this.match.split(/(?:\r\n?|\n)/g);
          this.match = this.match.substr(0, this.match.length-1);
          this.matched = this.matched.substr(0, this.matched.length-1);

          if (lines.length-1) this.yylineno -= lines.length-1;
          var r = this.yylloc.range;

          this.yylloc = {first_line: this.yylloc.first_line,
            last_line: this.yylineno+1,
            first_column: this.yylloc.first_column,
            last_column: lines ?
                (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length:
                this.yylloc.first_column - len
            };

          if (this.options.ranges) {
              this.yylloc.range = [r[0], r[0] + this.yyleng - len];
          }
          return this;
      },
  more:function () {
          this._more = true;
          return this;
      },
  less:function (n) {
          this.unput(this.match.slice(n));
      },
  pastInput:function () {
          var past = this.matched.substr(0, this.matched.length - this.match.length);
          return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
      },
  upcomingInput:function () {
          var next = this.match;
          if (next.length < 20) {
              next += this._input.substr(0, 20-next.length);
          }
          return (next.substr(0,20)+(next.length > 20 ? '...':'')).replace(/\n/g, "");
      },
  showPosition:function () {
          var pre = this.pastInput();
          var c = new Array(pre.length + 1).join("-");
          return pre + this.upcomingInput() + "\n" + c+"^";
      },
  next:function () {
          if (this.done) {
              return this.EOF;
          }
          if (!this._input) this.done = true;

          var token,
              match,
              tempMatch,
              index,
              col,
              lines;
          if (!this._more) {
              this.yytext = '';
              this.match = '';
          }
          var rules = this._currentRules();
          for (var i=0;i < rules.length; i++) {
              tempMatch = this._input.match(this.rules[rules[i]]);
              if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                  match = tempMatch;
                  index = i;
                  if (!this.options.flex) break;
              }
          }
          if (match) {
              lines = match[0].match(/(?:\r\n?|\n).*/g);
              if (lines) this.yylineno += lines.length;
              this.yylloc = {first_line: this.yylloc.last_line,
                             last_line: this.yylineno+1,
                             first_column: this.yylloc.last_column,
                             last_column: lines ? lines[lines.length-1].length-lines[lines.length-1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length};
              this.yytext += match[0];
              this.match += match[0];
              this.matches = match;
              this.yyleng = this.yytext.length;
              if (this.options.ranges) {
                  this.yylloc.range = [this.offset, this.offset += this.yyleng];
              }
              this._more = false;
              this._input = this._input.slice(match[0].length);
              this.matched += match[0];
              token = this.performAction.call(this, this.yy, this, rules[index],this.conditionStack[this.conditionStack.length-1]);
              if (this.done && this._input) this.done = false;
              if (token) return token;
              else return;
          }
          if (this._input === "") {
              return this.EOF;
          } else {
              return this.parseError('Lexical error on line '+(this.yylineno+1)+'. Unrecognized text.\n'+this.showPosition(),
                      {text: "", token: null, line: this.yylineno});
          }
      },
  lex:function lex() {
          var r = this.next();
          if (typeof r !== 'undefined') {
              return r;
          } else {
              return this.lex();
          }
      },
  begin:function begin(condition) {
          this.conditionStack.push(condition);
      },
  popState:function popState() {
          return this.conditionStack.pop();
      },
  _currentRules:function _currentRules() {
          return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules;
      },
  topState:function () {
          return this.conditionStack[this.conditionStack.length-2];
      },
  pushState:function begin(condition) {
          this.begin(condition);
      }});
  lexer.options = {};
  lexer.performAction = function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {


  function strip(start, end) {
    return yy_.yytext = yy_.yytext.substr(start, yy_.yyleng-end);
  }


  var YYSTATE=YY_START
  switch($avoiding_name_collisions) {
  case 0:
                                     if(yy_.yytext.slice(-2) === "\\\\") {
                                       strip(0,1);
                                       this.begin("mu");
                                     } else if(yy_.yytext.slice(-1) === "\\") {
                                       strip(0,1);
                                       this.begin("emu");
                                     } else {
                                       this.begin("mu");
                                     }
                                     if(yy_.yytext) return 14;
                                   
  break;
  case 1:return 14;
  break;
  case 2:
                                     this.popState();
                                     return 14;
                                   
  break;
  case 3:strip(0,4); this.popState(); return 15;
  break;
  case 4:return 35;
  break;
  case 5:return 36;
  break;
  case 6:return 25;
  break;
  case 7:return 16;
  break;
  case 8:return 20;
  break;
  case 9:return 19;
  break;
  case 10:return 19;
  break;
  case 11:return 23;
  break;
  case 12:return 22;
  break;
  case 13:this.popState(); this.begin('com');
  break;
  case 14:strip(3,5); this.popState(); return 15;
  break;
  case 15:return 22;
  break;
  case 16:return 41;
  break;
  case 17:return 40;
  break;
  case 18:return 40;
  break;
  case 19:return 44;
  break;
  case 20:// ignore whitespace
  break;
  case 21:this.popState(); return 24;
  break;
  case 22:this.popState(); return 18;
  break;
  case 23:yy_.yytext = strip(1,2).replace(/\\"/g,'"'); return 32;
  break;
  case 24:yy_.yytext = strip(1,2).replace(/\\'/g,"'"); return 32;
  break;
  case 25:return 42;
  break;
  case 26:return 34;
  break;
  case 27:return 34;
  break;
  case 28:return 33;
  break;
  case 29:return 40;
  break;
  case 30:yy_.yytext = strip(1,2); return 40;
  break;
  case 31:return 'INVALID';
  break;
  case 32:return 5;
  break;
  }
  };
  lexer.rules = [/^(?:[^\x00]*?(?=(\{\{)))/,/^(?:[^\x00]+)/,/^(?:[^\x00]{2,}?(?=(\{\{|\\\{\{|\\\\\{\{|$)))/,/^(?:[\s\S]*?--\}\})/,/^(?:\()/,/^(?:\))/,/^(?:\{\{(~)?>)/,/^(?:\{\{(~)?#)/,/^(?:\{\{(~)?\/)/,/^(?:\{\{(~)?\^)/,/^(?:\{\{(~)?\s*else\b)/,/^(?:\{\{(~)?\{)/,/^(?:\{\{(~)?&)/,/^(?:\{\{!--)/,/^(?:\{\{![\s\S]*?\}\})/,/^(?:\{\{(~)?)/,/^(?:=)/,/^(?:\.\.)/,/^(?:\.(?=([=~}\s\/.)])))/,/^(?:[\/.])/,/^(?:\s+)/,/^(?:\}(~)?\}\})/,/^(?:(~)?\}\})/,/^(?:"(\\["]|[^"])*")/,/^(?:'(\\[']|[^'])*')/,/^(?:@)/,/^(?:true(?=([~}\s)])))/,/^(?:false(?=([~}\s)])))/,/^(?:-?[0-9]+(?=([~}\s)])))/,/^(?:([^\s!"#%-,\.\/;->@\[-\^`\{-~]+(?=([=~}\s\/.)]))))/,/^(?:\[[^\]]*\])/,/^(?:.)/,/^(?:$)/];
  lexer.conditions = {"mu":{"rules":[4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32],"inclusive":false},"emu":{"rules":[2],"inclusive":false},"com":{"rules":[3],"inclusive":false},"INITIAL":{"rules":[0,1,32],"inclusive":true}};
  return lexer;})()
  parser.lexer = lexer;
  function Parser () { this.yy = {}; }Parser.prototype = parser;parser.Parser = Parser;
  return new Parser;
  })();__exports__ = handlebars;
  /* jshint ignore:end */
  return __exports__;
})();

// handlebars/compiler/base.js
var __module8__ = (function(__dependency1__, __dependency2__) {
  "use strict";
  var __exports__ = {};
  var parser = __dependency1__;
  var AST = __dependency2__;

  __exports__.parser = parser;

  function parse(input) {
    // Just return if an already-compile AST was passed in.
    if(input.constructor === AST.ProgramNode) { return input; }

    parser.yy = AST;
    return parser.parse(input);
  }

  __exports__.parse = parse;
  return __exports__;
})(__module9__, __module7__);

// handlebars/compiler/compiler.js
var __module10__ = (function(__dependency1__) {
  "use strict";
  var __exports__ = {};
  var Exception = __dependency1__;

  function Compiler() {}

  __exports__.Compiler = Compiler;// the foundHelper register will disambiguate helper lookup from finding a
  // function in a context. This is necessary for mustache compatibility, which
  // requires that context functions in blocks are evaluated by blockHelperMissing,
  // and then proceed as if the resulting value was provided to blockHelperMissing.

  Compiler.prototype = {
    compiler: Compiler,

    disassemble: function() {
      var opcodes = this.opcodes, opcode, out = [], params, param;

      for (var i=0, l=opcodes.length; i<l; i++) {
        opcode = opcodes[i];

        if (opcode.opcode === 'DECLARE') {
          out.push("DECLARE " + opcode.name + "=" + opcode.value);
        } else {
          params = [];
          for (var j=0; j<opcode.args.length; j++) {
            param = opcode.args[j];
            if (typeof param === "string") {
              param = "\"" + param.replace("\n", "\\n") + "\"";
            }
            params.push(param);
          }
          out.push(opcode.opcode + " " + params.join(" "));
        }
      }

      return out.join("\n");
    },

    equals: function(other) {
      var len = this.opcodes.length;
      if (other.opcodes.length !== len) {
        return false;
      }

      for (var i = 0; i < len; i++) {
        var opcode = this.opcodes[i],
            otherOpcode = other.opcodes[i];
        if (opcode.opcode !== otherOpcode.opcode || opcode.args.length !== otherOpcode.args.length) {
          return false;
        }
        for (var j = 0; j < opcode.args.length; j++) {
          if (opcode.args[j] !== otherOpcode.args[j]) {
            return false;
          }
        }
      }

      len = this.children.length;
      if (other.children.length !== len) {
        return false;
      }
      for (i = 0; i < len; i++) {
        if (!this.children[i].equals(other.children[i])) {
          return false;
        }
      }

      return true;
    },

    guid: 0,

    compile: function(program, options) {
      this.opcodes = [];
      this.children = [];
      this.depths = {list: []};
      this.options = options;

      // These changes will propagate to the other compiler components
      var knownHelpers = this.options.knownHelpers;
      this.options.knownHelpers = {
        'helperMissing': true,
        'blockHelperMissing': true,
        'each': true,
        'if': true,
        'unless': true,
        'with': true,
        'log': true
      };
      if (knownHelpers) {
        for (var name in knownHelpers) {
          this.options.knownHelpers[name] = knownHelpers[name];
        }
      }

      return this.accept(program);
    },

    accept: function(node) {
      var strip = node.strip || {},
          ret;
      if (strip.left) {
        this.opcode('strip');
      }

      ret = this[node.type](node);

      if (strip.right) {
        this.opcode('strip');
      }

      return ret;
    },

    program: function(program) {
      var statements = program.statements;

      for(var i=0, l=statements.length; i<l; i++) {
        this.accept(statements[i]);
      }
      this.isSimple = l === 1;

      this.depths.list = this.depths.list.sort(function(a, b) {
        return a - b;
      });

      return this;
    },

    compileProgram: function(program) {
      var result = new this.compiler().compile(program, this.options);
      var guid = this.guid++, depth;

      this.usePartial = this.usePartial || result.usePartial;

      this.children[guid] = result;

      for(var i=0, l=result.depths.list.length; i<l; i++) {
        depth = result.depths.list[i];

        if(depth < 2) { continue; }
        else { this.addDepth(depth - 1); }
      }

      return guid;
    },

    block: function(block) {
      var mustache = block.mustache,
          program = block.program,
          inverse = block.inverse;

      if (program) {
        program = this.compileProgram(program);
      }

      if (inverse) {
        inverse = this.compileProgram(inverse);
      }

      var sexpr = mustache.sexpr;
      var type = this.classifySexpr(sexpr);

      if (type === "helper") {
        this.helperSexpr(sexpr, program, inverse);
      } else if (type === "simple") {
        this.simpleSexpr(sexpr);

        // now that the simple mustache is resolved, we need to
        // evaluate it by executing `blockHelperMissing`
        this.opcode('pushProgram', program);
        this.opcode('pushProgram', inverse);
        this.opcode('emptyHash');
        this.opcode('blockValue');
      } else {
        this.ambiguousSexpr(sexpr, program, inverse);

        // now that the simple mustache is resolved, we need to
        // evaluate it by executing `blockHelperMissing`
        this.opcode('pushProgram', program);
        this.opcode('pushProgram', inverse);
        this.opcode('emptyHash');
        this.opcode('ambiguousBlockValue');
      }

      this.opcode('append');
    },

    hash: function(hash) {
      var pairs = hash.pairs, pair, val;

      this.opcode('pushHash');

      for(var i=0, l=pairs.length; i<l; i++) {
        pair = pairs[i];
        val  = pair[1];

        if (this.options.stringParams) {
          if(val.depth) {
            this.addDepth(val.depth);
          }
          this.opcode('getContext', val.depth || 0);
          this.opcode('pushStringParam', val.stringModeValue, val.type);

          if (val.type === 'sexpr') {
            // Subexpressions get evaluated and passed in
            // in string params mode.
            this.sexpr(val);
          }
        } else {
          this.accept(val);
        }

        this.opcode('assignToHash', pair[0]);
      }
      this.opcode('popHash');
    },

    partial: function(partial) {
      var partialName = partial.partialName;
      this.usePartial = true;

      if(partial.context) {
        this.ID(partial.context);
      } else {
        this.opcode('push', 'depth0');
      }

      this.opcode('invokePartial', partialName.name);
      this.opcode('append');
    },

    content: function(content) {
      this.opcode('appendContent', content.string);
    },

    mustache: function(mustache) {
      this.sexpr(mustache.sexpr);

      if(mustache.escaped && !this.options.noEscape) {
        this.opcode('appendEscaped');
      } else {
        this.opcode('append');
      }
    },

    ambiguousSexpr: function(sexpr, program, inverse) {
      var id = sexpr.id,
          name = id.parts[0],
          isBlock = program != null || inverse != null;

      this.opcode('getContext', id.depth);

      this.opcode('pushProgram', program);
      this.opcode('pushProgram', inverse);

      this.opcode('invokeAmbiguous', name, isBlock);
    },

    simpleSexpr: function(sexpr) {
      var id = sexpr.id;

      if (id.type === 'DATA') {
        this.DATA(id);
      } else if (id.parts.length) {
        this.ID(id);
      } else {
        // Simplified ID for `this`
        this.addDepth(id.depth);
        this.opcode('getContext', id.depth);
        this.opcode('pushContext');
      }

      this.opcode('resolvePossibleLambda');
    },

    helperSexpr: function(sexpr, program, inverse) {
      var params = this.setupFullMustacheParams(sexpr, program, inverse),
          name = sexpr.id.parts[0];

      if (this.options.knownHelpers[name]) {
        this.opcode('invokeKnownHelper', params.length, name);
      } else if (this.options.knownHelpersOnly) {
        throw new Exception("You specified knownHelpersOnly, but used the unknown helper " + name, sexpr);
      } else {
        this.opcode('invokeHelper', params.length, name, sexpr.isRoot);
      }
    },

    sexpr: function(sexpr) {
      var type = this.classifySexpr(sexpr);

      if (type === "simple") {
        this.simpleSexpr(sexpr);
      } else if (type === "helper") {
        this.helperSexpr(sexpr);
      } else {
        this.ambiguousSexpr(sexpr);
      }
    },

    ID: function(id) {
      this.addDepth(id.depth);
      this.opcode('getContext', id.depth);

      var name = id.parts[0];
      if (!name) {
        this.opcode('pushContext');
      } else {
        this.opcode('lookupOnContext', id.parts[0]);
      }

      for(var i=1, l=id.parts.length; i<l; i++) {
        this.opcode('lookup', id.parts[i]);
      }
    },

    DATA: function(data) {
      this.options.data = true;
      if (data.id.isScoped || data.id.depth) {
        throw new Exception('Scoped data references are not supported: ' + data.original, data);
      }

      this.opcode('lookupData');
      var parts = data.id.parts;
      for(var i=0, l=parts.length; i<l; i++) {
        this.opcode('lookup', parts[i]);
      }
    },

    STRING: function(string) {
      this.opcode('pushString', string.string);
    },

    INTEGER: function(integer) {
      this.opcode('pushLiteral', integer.integer);
    },

    BOOLEAN: function(bool) {
      this.opcode('pushLiteral', bool.bool);
    },

    comment: function() {},

    // HELPERS
    opcode: function(name) {
      this.opcodes.push({ opcode: name, args: [].slice.call(arguments, 1) });
    },

    declare: function(name, value) {
      this.opcodes.push({ opcode: 'DECLARE', name: name, value: value });
    },

    addDepth: function(depth) {
      if(depth === 0) { return; }

      if(!this.depths[depth]) {
        this.depths[depth] = true;
        this.depths.list.push(depth);
      }
    },

    classifySexpr: function(sexpr) {
      var isHelper   = sexpr.isHelper;
      var isEligible = sexpr.eligibleHelper;
      var options    = this.options;

      // if ambiguous, we can possibly resolve the ambiguity now
      if (isEligible && !isHelper) {
        var name = sexpr.id.parts[0];

        if (options.knownHelpers[name]) {
          isHelper = true;
        } else if (options.knownHelpersOnly) {
          isEligible = false;
        }
      }

      if (isHelper) { return "helper"; }
      else if (isEligible) { return "ambiguous"; }
      else { return "simple"; }
    },

    pushParams: function(params) {
      var i = params.length, param;

      while(i--) {
        param = params[i];

        if(this.options.stringParams) {
          if(param.depth) {
            this.addDepth(param.depth);
          }

          this.opcode('getContext', param.depth || 0);
          this.opcode('pushStringParam', param.stringModeValue, param.type);

          if (param.type === 'sexpr') {
            // Subexpressions get evaluated and passed in
            // in string params mode.
            this.sexpr(param);
          }
        } else {
          this[param.type](param);
        }
      }
    },

    setupFullMustacheParams: function(sexpr, program, inverse) {
      var params = sexpr.params;
      this.pushParams(params);

      this.opcode('pushProgram', program);
      this.opcode('pushProgram', inverse);

      if (sexpr.hash) {
        this.hash(sexpr.hash);
      } else {
        this.opcode('emptyHash');
      }

      return params;
    }
  };

  function precompile(input, options, env) {
    if (input == null || (typeof input !== 'string' && input.constructor !== env.AST.ProgramNode)) {
      throw new Exception("You must pass a string or Handlebars AST to Handlebars.precompile. You passed " + input);
    }

    options = options || {};
    if (!('data' in options)) {
      options.data = true;
    }

    var ast = env.parse(input);
    var environment = new env.Compiler().compile(ast, options);
    return new env.JavaScriptCompiler().compile(environment, options);
  }

  __exports__.precompile = precompile;function compile(input, options, env) {
    if (input == null || (typeof input !== 'string' && input.constructor !== env.AST.ProgramNode)) {
      throw new Exception("You must pass a string or Handlebars AST to Handlebars.compile. You passed " + input);
    }

    options = options || {};

    if (!('data' in options)) {
      options.data = true;
    }

    var compiled;

    function compileInput() {
      var ast = env.parse(input);
      var environment = new env.Compiler().compile(ast, options);
      var templateSpec = new env.JavaScriptCompiler().compile(environment, options, undefined, true);
      return env.template(templateSpec);
    }

    // Template is only compiled on first use and cached after that point.
    return function(context, options) {
      if (!compiled) {
        compiled = compileInput();
      }
      return compiled.call(this, context, options);
    };
  }

  __exports__.compile = compile;
  return __exports__;
})(__module5__);

// handlebars/compiler/javascript-compiler.js
var __module11__ = (function(__dependency1__, __dependency2__) {
  "use strict";
  var __exports__;
  var COMPILER_REVISION = __dependency1__.COMPILER_REVISION;
  var REVISION_CHANGES = __dependency1__.REVISION_CHANGES;
  var log = __dependency1__.log;
  var Exception = __dependency2__;

  function Literal(value) {
    this.value = value;
  }

  function JavaScriptCompiler() {}

  JavaScriptCompiler.prototype = {
    // PUBLIC API: You can override these methods in a subclass to provide
    // alternative compiled forms for name lookup and buffering semantics
    nameLookup: function(parent, name /* , type*/) {
      var wrap,
          ret;
      if (parent.indexOf('depth') === 0) {
        wrap = true;
      }

      if (/^[0-9]+$/.test(name)) {
        ret = parent + "[" + name + "]";
      } else if (JavaScriptCompiler.isValidJavaScriptVariableName(name)) {
        ret = parent + "." + name;
      }
      else {
        ret = parent + "['" + name + "']";
      }

      if (wrap) {
        return '(' + parent + ' && ' + ret + ')';
      } else {
        return ret;
      }
    },

    compilerInfo: function() {
      var revision = COMPILER_REVISION,
          versions = REVISION_CHANGES[revision];
      return "this.compilerInfo = ["+revision+",'"+versions+"'];\n";
    },

    appendToBuffer: function(string) {
      if (this.environment.isSimple) {
        return "return " + string + ";";
      } else {
        return {
          appendToBuffer: true,
          content: string,
          toString: function() { return "buffer += " + string + ";"; }
        };
      }
    },

    initializeBuffer: function() {
      return this.quotedString("");
    },

    namespace: "Handlebars",
    // END PUBLIC API

    compile: function(environment, options, context, asObject) {
      this.environment = environment;
      this.options = options || {};

      log('debug', this.environment.disassemble() + "\n\n");

      this.name = this.environment.name;
      this.isChild = !!context;
      this.context = context || {
        programs: [],
        environments: [],
        aliases: { }
      };

      this.preamble();

      this.stackSlot = 0;
      this.stackVars = [];
      this.registers = { list: [] };
      this.hashes = [];
      this.compileStack = [];
      this.inlineStack = [];

      this.compileChildren(environment, options);

      var opcodes = environment.opcodes, opcode;

      this.i = 0;

      for(var l=opcodes.length; this.i<l; this.i++) {
        opcode = opcodes[this.i];

        if(opcode.opcode === 'DECLARE') {
          this[opcode.name] = opcode.value;
        } else {
          this[opcode.opcode].apply(this, opcode.args);
        }

        // Reset the stripNext flag if it was not set by this operation.
        if (opcode.opcode !== this.stripNext) {
          this.stripNext = false;
        }
      }

      // Flush any trailing content that might be pending.
      this.pushSource('');

      if (this.stackSlot || this.inlineStack.length || this.compileStack.length) {
        throw new Exception('Compile completed with content left on stack');
      }

      return this.createFunctionContext(asObject);
    },

    preamble: function() {
      var out = [];

      if (!this.isChild) {
        var namespace = this.namespace;

        var copies = "helpers = this.merge(helpers, " + namespace + ".helpers);";
        if (this.environment.usePartial) { copies = copies + " partials = this.merge(partials, " + namespace + ".partials);"; }
        if (this.options.data) { copies = copies + " data = data || {};"; }
        out.push(copies);
      } else {
        out.push('');
      }

      if (!this.environment.isSimple) {
        out.push(", buffer = " + this.initializeBuffer());
      } else {
        out.push("");
      }

      // track the last context pushed into place to allow skipping the
      // getContext opcode when it would be a noop
      this.lastContext = 0;
      this.source = out;
    },

    createFunctionContext: function(asObject) {
      var locals = this.stackVars.concat(this.registers.list);

      if(locals.length > 0) {
        this.source[1] = this.source[1] + ", " + locals.join(", ");
      }

      // Generate minimizer alias mappings
      if (!this.isChild) {
        for (var alias in this.context.aliases) {
          if (this.context.aliases.hasOwnProperty(alias)) {
            this.source[1] = this.source[1] + ', ' + alias + '=' + this.context.aliases[alias];
          }
        }
      }

      if (this.source[1]) {
        this.source[1] = "var " + this.source[1].substring(2) + ";";
      }

      // Merge children
      if (!this.isChild) {
        this.source[1] += '\n' + this.context.programs.join('\n') + '\n';
      }

      if (!this.environment.isSimple) {
        this.pushSource("return buffer;");
      }

      var params = this.isChild ? ["depth0", "data"] : ["Handlebars", "depth0", "helpers", "partials", "data"];

      for(var i=0, l=this.environment.depths.list.length; i<l; i++) {
        params.push("depth" + this.environment.depths.list[i]);
      }

      // Perform a second pass over the output to merge content when possible
      var source = this.mergeSource();

      if (!this.isChild) {
        source = this.compilerInfo()+source;
      }

      if (asObject) {
        params.push(source);

        return Function.apply(this, params);
      } else {
        var functionSource = 'function ' + (this.name || '') + '(' + params.join(',') + ') {\n  ' + source + '}';
        log('debug', functionSource + "\n\n");
        return functionSource;
      }
    },
    mergeSource: function() {
      // WARN: We are not handling the case where buffer is still populated as the source should
      // not have buffer append operations as their final action.
      var source = '',
          buffer;
      for (var i = 0, len = this.source.length; i < len; i++) {
        var line = this.source[i];
        if (line.appendToBuffer) {
          if (buffer) {
            buffer = buffer + '\n    + ' + line.content;
          } else {
            buffer = line.content;
          }
        } else {
          if (buffer) {
            source += 'buffer += ' + buffer + ';\n  ';
            buffer = undefined;
          }
          source += line + '\n  ';
        }
      }
      return source;
    },

    // [blockValue]
    //
    // On stack, before: hash, inverse, program, value
    // On stack, after: return value of blockHelperMissing
    //
    // The purpose of this opcode is to take a block of the form
    // `{{#foo}}...{{/foo}}`, resolve the value of `foo`, and
    // replace it on the stack with the result of properly
    // invoking blockHelperMissing.
    blockValue: function() {
      this.context.aliases.blockHelperMissing = 'helpers.blockHelperMissing';

      var params = ["depth0"];
      this.setupParams(0, params);

      this.replaceStack(function(current) {
        params.splice(1, 0, current);
        return "blockHelperMissing.call(" + params.join(", ") + ")";
      });
    },

    // [ambiguousBlockValue]
    //
    // On stack, before: hash, inverse, program, value
    // Compiler value, before: lastHelper=value of last found helper, if any
    // On stack, after, if no lastHelper: same as [blockValue]
    // On stack, after, if lastHelper: value
    ambiguousBlockValue: function() {
      this.context.aliases.blockHelperMissing = 'helpers.blockHelperMissing';

      var params = ["depth0"];
      this.setupParams(0, params);

      var current = this.topStack();
      params.splice(1, 0, current);

      this.pushSource("if (!" + this.lastHelper + ") { " + current + " = blockHelperMissing.call(" + params.join(", ") + "); }");
    },

    // [appendContent]
    //
    // On stack, before: ...
    // On stack, after: ...
    //
    // Appends the string value of `content` to the current buffer
    appendContent: function(content) {
      if (this.pendingContent) {
        content = this.pendingContent + content;
      }
      if (this.stripNext) {
        content = content.replace(/^\s+/, '');
      }

      this.pendingContent = content;
    },

    // [strip]
    //
    // On stack, before: ...
    // On stack, after: ...
    //
    // Removes any trailing whitespace from the prior content node and flags
    // the next operation for stripping if it is a content node.
    strip: function() {
      if (this.pendingContent) {
        this.pendingContent = this.pendingContent.replace(/\s+$/, '');
      }
      this.stripNext = 'strip';
    },

    // [append]
    //
    // On stack, before: value, ...
    // On stack, after: ...
    //
    // Coerces `value` to a String and appends it to the current buffer.
    //
    // If `value` is truthy, or 0, it is coerced into a string and appended
    // Otherwise, the empty string is appended
    append: function() {
      // Force anything that is inlined onto the stack so we don't have duplication
      // when we examine local
      this.flushInline();
      var local = this.popStack();
      this.pushSource("if(" + local + " || " + local + " === 0) { " + this.appendToBuffer(local) + " }");
      if (this.environment.isSimple) {
        this.pushSource("else { " + this.appendToBuffer("''") + " }");
      }
    },

    // [appendEscaped]
    //
    // On stack, before: value, ...
    // On stack, after: ...
    //
    // Escape `value` and append it to the buffer
    appendEscaped: function() {
      this.context.aliases.escapeExpression = 'this.escapeExpression';

      this.pushSource(this.appendToBuffer("escapeExpression(" + this.popStack() + ")"));
    },

    // [getContext]
    //
    // On stack, before: ...
    // On stack, after: ...
    // Compiler value, after: lastContext=depth
    //
    // Set the value of the `lastContext` compiler value to the depth
    getContext: function(depth) {
      if(this.lastContext !== depth) {
        this.lastContext = depth;
      }
    },

    // [lookupOnContext]
    //
    // On stack, before: ...
    // On stack, after: currentContext[name], ...
    //
    // Looks up the value of `name` on the current context and pushes
    // it onto the stack.
    lookupOnContext: function(name) {
      this.push(this.nameLookup('depth' + this.lastContext, name, 'context'));
    },

    // [pushContext]
    //
    // On stack, before: ...
    // On stack, after: currentContext, ...
    //
    // Pushes the value of the current context onto the stack.
    pushContext: function() {
      this.pushStackLiteral('depth' + this.lastContext);
    },

    // [resolvePossibleLambda]
    //
    // On stack, before: value, ...
    // On stack, after: resolved value, ...
    //
    // If the `value` is a lambda, replace it on the stack by
    // the return value of the lambda
    resolvePossibleLambda: function() {
      this.context.aliases.functionType = '"function"';

      this.replaceStack(function(current) {
        return "typeof " + current + " === functionType ? " + current + ".apply(depth0) : " + current;
      });
    },

    // [lookup]
    //
    // On stack, before: value, ...
    // On stack, after: value[name], ...
    //
    // Replace the value on the stack with the result of looking
    // up `name` on `value`
    lookup: function(name) {
      this.replaceStack(function(current) {
        return current + " == null || " + current + " === false ? " + current + " : " + this.nameLookup(current, name, 'context');
      });
    },

    // [lookupData]
    //
    // On stack, before: ...
    // On stack, after: data, ...
    //
    // Push the data lookup operator
    lookupData: function() {
      this.pushStackLiteral('data');
    },

    // [pushStringParam]
    //
    // On stack, before: ...
    // On stack, after: string, currentContext, ...
    //
    // This opcode is designed for use in string mode, which
    // provides the string value of a parameter along with its
    // depth rather than resolving it immediately.
    pushStringParam: function(string, type) {
      this.pushStackLiteral('depth' + this.lastContext);

      this.pushString(type);

      // If it's a subexpression, the string result
      // will be pushed after this opcode.
      if (type !== 'sexpr') {
        if (typeof string === 'string') {
          this.pushString(string);
        } else {
          this.pushStackLiteral(string);
        }
      }
    },

    emptyHash: function() {
      this.pushStackLiteral('{}');

      if (this.options.stringParams) {
        this.push('{}'); // hashContexts
        this.push('{}'); // hashTypes
      }
    },
    pushHash: function() {
      if (this.hash) {
        this.hashes.push(this.hash);
      }
      this.hash = {values: [], types: [], contexts: []};
    },
    popHash: function() {
      var hash = this.hash;
      this.hash = this.hashes.pop();

      if (this.options.stringParams) {
        this.push('{' + hash.contexts.join(',') + '}');
        this.push('{' + hash.types.join(',') + '}');
      }

      this.push('{\n    ' + hash.values.join(',\n    ') + '\n  }');
    },

    // [pushString]
    //
    // On stack, before: ...
    // On stack, after: quotedString(string), ...
    //
    // Push a quoted version of `string` onto the stack
    pushString: function(string) {
      this.pushStackLiteral(this.quotedString(string));
    },

    // [push]
    //
    // On stack, before: ...
    // On stack, after: expr, ...
    //
    // Push an expression onto the stack
    push: function(expr) {
      this.inlineStack.push(expr);
      return expr;
    },

    // [pushLiteral]
    //
    // On stack, before: ...
    // On stack, after: value, ...
    //
    // Pushes a value onto the stack. This operation prevents
    // the compiler from creating a temporary variable to hold
    // it.
    pushLiteral: function(value) {
      this.pushStackLiteral(value);
    },

    // [pushProgram]
    //
    // On stack, before: ...
    // On stack, after: program(guid), ...
    //
    // Push a program expression onto the stack. This takes
    // a compile-time guid and converts it into a runtime-accessible
    // expression.
    pushProgram: function(guid) {
      if (guid != null) {
        this.pushStackLiteral(this.programExpression(guid));
      } else {
        this.pushStackLiteral(null);
      }
    },

    // [invokeHelper]
    //
    // On stack, before: hash, inverse, program, params..., ...
    // On stack, after: result of helper invocation
    //
    // Pops off the helper's parameters, invokes the helper,
    // and pushes the helper's return value onto the stack.
    //
    // If the helper is not found, `helperMissing` is called.
    invokeHelper: function(paramSize, name, isRoot) {
      this.context.aliases.helperMissing = 'helpers.helperMissing';
      this.useRegister('helper');

      var helper = this.lastHelper = this.setupHelper(paramSize, name, true);
      var nonHelper = this.nameLookup('depth' + this.lastContext, name, 'context');

      var lookup = 'helper = ' + helper.name + ' || ' + nonHelper;
      if (helper.paramsInit) {
        lookup += ',' + helper.paramsInit;
      }

      this.push(
        '('
          + lookup
          + ',helper '
            + '? helper.call(' + helper.callParams + ') '
            + ': helperMissing.call(' + helper.helperMissingParams + '))');

      // Always flush subexpressions. This is both to prevent the compounding size issue that
      // occurs when the code has to be duplicated for inlining and also to prevent errors
      // due to the incorrect options object being passed due to the shared register.
      if (!isRoot) {
        this.flushInline();
      }
    },

    // [invokeKnownHelper]
    //
    // On stack, before: hash, inverse, program, params..., ...
    // On stack, after: result of helper invocation
    //
    // This operation is used when the helper is known to exist,
    // so a `helperMissing` fallback is not required.
    invokeKnownHelper: function(paramSize, name) {
      var helper = this.setupHelper(paramSize, name);
      this.push(helper.name + ".call(" + helper.callParams + ")");
    },

    // [invokeAmbiguous]
    //
    // On stack, before: hash, inverse, program, params..., ...
    // On stack, after: result of disambiguation
    //
    // This operation is used when an expression like `{{foo}}`
    // is provided, but we don't know at compile-time whether it
    // is a helper or a path.
    //
    // This operation emits more code than the other options,
    // and can be avoided by passing the `knownHelpers` and
    // `knownHelpersOnly` flags at compile-time.
    invokeAmbiguous: function(name, helperCall) {
      this.context.aliases.functionType = '"function"';
      this.useRegister('helper');

      this.emptyHash();
      var helper = this.setupHelper(0, name, helperCall);

      var helperName = this.lastHelper = this.nameLookup('helpers', name, 'helper');

      var nonHelper = this.nameLookup('depth' + this.lastContext, name, 'context');
      var nextStack = this.nextStack();

      if (helper.paramsInit) {
        this.pushSource(helper.paramsInit);
      }
      this.pushSource('if (helper = ' + helperName + ') { ' + nextStack + ' = helper.call(' + helper.callParams + '); }');
      this.pushSource('else { helper = ' + nonHelper + '; ' + nextStack + ' = typeof helper === functionType ? helper.call(' + helper.callParams + ') : helper; }');
    },

    // [invokePartial]
    //
    // On stack, before: context, ...
    // On stack after: result of partial invocation
    //
    // This operation pops off a context, invokes a partial with that context,
    // and pushes the result of the invocation back.
    invokePartial: function(name) {
      var params = [this.nameLookup('partials', name, 'partial'), "'" + name + "'", this.popStack(), "helpers", "partials"];

      if (this.options.data) {
        params.push("data");
      }

      this.context.aliases.self = "this";
      this.push("self.invokePartial(" + params.join(", ") + ")");
    },

    // [assignToHash]
    //
    // On stack, before: value, hash, ...
    // On stack, after: hash, ...
    //
    // Pops a value and hash off the stack, assigns `hash[key] = value`
    // and pushes the hash back onto the stack.
    assignToHash: function(key) {
      var value = this.popStack(),
          context,
          type;

      if (this.options.stringParams) {
        type = this.popStack();
        context = this.popStack();
      }

      var hash = this.hash;
      if (context) {
        hash.contexts.push("'" + key + "': " + context);
      }
      if (type) {
        hash.types.push("'" + key + "': " + type);
      }
      hash.values.push("'" + key + "': (" + value + ")");
    },

    // HELPERS

    compiler: JavaScriptCompiler,

    compileChildren: function(environment, options) {
      var children = environment.children, child, compiler;

      for(var i=0, l=children.length; i<l; i++) {
        child = children[i];
        compiler = new this.compiler();

        var index = this.matchExistingProgram(child);

        if (index == null) {
          this.context.programs.push('');     // Placeholder to prevent name conflicts for nested children
          index = this.context.programs.length;
          child.index = index;
          child.name = 'program' + index;
          this.context.programs[index] = compiler.compile(child, options, this.context);
          this.context.environments[index] = child;
        } else {
          child.index = index;
          child.name = 'program' + index;
        }
      }
    },
    matchExistingProgram: function(child) {
      for (var i = 0, len = this.context.environments.length; i < len; i++) {
        var environment = this.context.environments[i];
        if (environment && environment.equals(child)) {
          return i;
        }
      }
    },

    programExpression: function(guid) {
      this.context.aliases.self = "this";

      if(guid == null) {
        return "self.noop";
      }

      var child = this.environment.children[guid],
          depths = child.depths.list, depth;

      var programParams = [child.index, child.name, "data"];

      for(var i=0, l = depths.length; i<l; i++) {
        depth = depths[i];

        if(depth === 1) { programParams.push("depth0"); }
        else { programParams.push("depth" + (depth - 1)); }
      }

      return (depths.length === 0 ? "self.program(" : "self.programWithDepth(") + programParams.join(", ") + ")";
    },

    register: function(name, val) {
      this.useRegister(name);
      this.pushSource(name + " = " + val + ";");
    },

    useRegister: function(name) {
      if(!this.registers[name]) {
        this.registers[name] = true;
        this.registers.list.push(name);
      }
    },

    pushStackLiteral: function(item) {
      return this.push(new Literal(item));
    },

    pushSource: function(source) {
      if (this.pendingContent) {
        this.source.push(this.appendToBuffer(this.quotedString(this.pendingContent)));
        this.pendingContent = undefined;
      }

      if (source) {
        this.source.push(source);
      }
    },

    pushStack: function(item) {
      this.flushInline();

      var stack = this.incrStack();
      if (item) {
        this.pushSource(stack + " = " + item + ";");
      }
      this.compileStack.push(stack);
      return stack;
    },

    replaceStack: function(callback) {
      var prefix = '',
          inline = this.isInline(),
          stack,
          createdStack,
          usedLiteral;

      // If we are currently inline then we want to merge the inline statement into the
      // replacement statement via ','
      if (inline) {
        var top = this.popStack(true);

        if (top instanceof Literal) {
          // Literals do not need to be inlined
          stack = top.value;
          usedLiteral = true;
        } else {
          // Get or create the current stack name for use by the inline
          createdStack = !this.stackSlot;
          var name = !createdStack ? this.topStackName() : this.incrStack();

          prefix = '(' + this.push(name) + ' = ' + top + '),';
          stack = this.topStack();
        }
      } else {
        stack = this.topStack();
      }

      var item = callback.call(this, stack);

      if (inline) {
        if (!usedLiteral) {
          this.popStack();
        }
        if (createdStack) {
          this.stackSlot--;
        }
        this.push('(' + prefix + item + ')');
      } else {
        // Prevent modification of the context depth variable. Through replaceStack
        if (!/^stack/.test(stack)) {
          stack = this.nextStack();
        }

        this.pushSource(stack + " = (" + prefix + item + ");");
      }
      return stack;
    },

    nextStack: function() {
      return this.pushStack();
    },

    incrStack: function() {
      this.stackSlot++;
      if(this.stackSlot > this.stackVars.length) { this.stackVars.push("stack" + this.stackSlot); }
      return this.topStackName();
    },
    topStackName: function() {
      return "stack" + this.stackSlot;
    },
    flushInline: function() {
      var inlineStack = this.inlineStack;
      if (inlineStack.length) {
        this.inlineStack = [];
        for (var i = 0, len = inlineStack.length; i < len; i++) {
          var entry = inlineStack[i];
          if (entry instanceof Literal) {
            this.compileStack.push(entry);
          } else {
            this.pushStack(entry);
          }
        }
      }
    },
    isInline: function() {
      return this.inlineStack.length;
    },

    popStack: function(wrapped) {
      var inline = this.isInline(),
          item = (inline ? this.inlineStack : this.compileStack).pop();

      if (!wrapped && (item instanceof Literal)) {
        return item.value;
      } else {
        if (!inline) {
          if (!this.stackSlot) {
            throw new Exception('Invalid stack pop');
          }
          this.stackSlot--;
        }
        return item;
      }
    },

    topStack: function(wrapped) {
      var stack = (this.isInline() ? this.inlineStack : this.compileStack),
          item = stack[stack.length - 1];

      if (!wrapped && (item instanceof Literal)) {
        return item.value;
      } else {
        return item;
      }
    },

    quotedString: function(str) {
      return '"' + str
        .replace(/\\/g, '\\\\')
        .replace(/"/g, '\\"')
        .replace(/\n/g, '\\n')
        .replace(/\r/g, '\\r')
        .replace(/\u2028/g, '\\u2028')   // Per Ecma-262 7.3 + 7.8.4
        .replace(/\u2029/g, '\\u2029') + '"';
    },

    setupHelper: function(paramSize, name, missingParams) {
      var params = [],
          paramsInit = this.setupParams(paramSize, params, missingParams);
      var foundHelper = this.nameLookup('helpers', name, 'helper');

      return {
        params: params,
        paramsInit: paramsInit,
        name: foundHelper,
        callParams: ["depth0"].concat(params).join(", "),
        helperMissingParams: missingParams && ["depth0", this.quotedString(name)].concat(params).join(", ")
      };
    },

    setupOptions: function(paramSize, params) {
      var options = [], contexts = [], types = [], param, inverse, program;

      options.push("hash:" + this.popStack());

      if (this.options.stringParams) {
        options.push("hashTypes:" + this.popStack());
        options.push("hashContexts:" + this.popStack());
      }

      inverse = this.popStack();
      program = this.popStack();

      // Avoid setting fn and inverse if neither are set. This allows
      // helpers to do a check for `if (options.fn)`
      if (program || inverse) {
        if (!program) {
          this.context.aliases.self = "this";
          program = "self.noop";
        }

        if (!inverse) {
          this.context.aliases.self = "this";
          inverse = "self.noop";
        }

        options.push("inverse:" + inverse);
        options.push("fn:" + program);
      }

      for(var i=0; i<paramSize; i++) {
        param = this.popStack();
        params.push(param);

        if(this.options.stringParams) {
          types.push(this.popStack());
          contexts.push(this.popStack());
        }
      }

      if (this.options.stringParams) {
        options.push("contexts:[" + contexts.join(",") + "]");
        options.push("types:[" + types.join(",") + "]");
      }

      if(this.options.data) {
        options.push("data:data");
      }

      return options;
    },

    // the params and contexts arguments are passed in arrays
    // to fill in
    setupParams: function(paramSize, params, useRegister) {
      var options = '{' + this.setupOptions(paramSize, params).join(',') + '}';

      if (useRegister) {
        this.useRegister('options');
        params.push('options');
        return 'options=' + options;
      } else {
        params.push(options);
        return '';
      }
    }
  };

  var reservedWords = (
    "break else new var" +
    " case finally return void" +
    " catch for switch while" +
    " continue function this with" +
    " default if throw" +
    " delete in try" +
    " do instanceof typeof" +
    " abstract enum int short" +
    " boolean export interface static" +
    " byte extends long super" +
    " char final native synchronized" +
    " class float package throws" +
    " const goto private transient" +
    " debugger implements protected volatile" +
    " double import public let yield"
  ).split(" ");

  var compilerWords = JavaScriptCompiler.RESERVED_WORDS = {};

  for(var i=0, l=reservedWords.length; i<l; i++) {
    compilerWords[reservedWords[i]] = true;
  }

  JavaScriptCompiler.isValidJavaScriptVariableName = function(name) {
    if(!JavaScriptCompiler.RESERVED_WORDS[name] && /^[a-zA-Z_$][0-9a-zA-Z_$]*$/.test(name)) {
      return true;
    }
    return false;
  };

  __exports__ = JavaScriptCompiler;
  return __exports__;
})(__module2__, __module5__);

// handlebars.js
var __module0__ = (function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__) {
  "use strict";
  var __exports__;
  /*globals Handlebars: true */
  var Handlebars = __dependency1__;

  // Compiler imports
  var AST = __dependency2__;
  var Parser = __dependency3__.parser;
  var parse = __dependency3__.parse;
  var Compiler = __dependency4__.Compiler;
  var compile = __dependency4__.compile;
  var precompile = __dependency4__.precompile;
  var JavaScriptCompiler = __dependency5__;

  var _create = Handlebars.create;
  var create = function() {
    var hb = _create();

    hb.compile = function(input, options) {
      return compile(input, options, hb);
    };
    hb.precompile = function (input, options) {
      return precompile(input, options, hb);
    };

    hb.AST = AST;
    hb.Compiler = Compiler;
    hb.JavaScriptCompiler = JavaScriptCompiler;
    hb.Parser = Parser;
    hb.parse = parse;

    return hb;
  };

  Handlebars = create();
  Handlebars.create = create;

  __exports__ = Handlebars;
  return __exports__;
})(__module1__, __module7__, __module8__, __module10__, __module11__);

  return __module0__;
})();

/*!
 * @overview  Ember - JavaScript Application Framework
 * @copyright Copyright 2011-2014 Tilde Inc. and contributors
 *            Portions Copyright 2006-2011 Strobe Inc.
 *            Portions Copyright 2008-2011 Apple Inc. All rights reserved.
 * @license   Licensed under MIT license
 *            See https://raw.github.com/emberjs/ember.js/master/LICENSE
 * @version   1.8.1
 */

(function() {
var enifed, requireModule, eriuqer, requirejs, Ember;

(function() {
  Ember = this.Ember = this.Ember || {};
  if (typeof Ember === 'undefined') { Ember = {}; };

  if (typeof Ember.__loader === 'undefined') {
    var registry = {}, seen = {};

    enifed = function(name, deps, callback) {
      registry[name] = { deps: deps, callback: callback };
    };

    requirejs = eriuqer = requireModule = function(name) {
      if (seen.hasOwnProperty(name)) { return seen[name]; }
      seen[name] = {};

      if (!registry[name]) {
        throw new Error("Could not find module " + name);
      }

      var mod = registry[name];
      var deps = mod.deps;
      var callback = mod.callback;
      var reified = [];
      var exports;

      for (var i=0, l=deps.length; i<l; i++) {
        if (deps[i] === 'exports') {
          reified.push(exports = {});
        } else {
          reified.push(requireModule(resolve(deps[i])));
        }
      }

      var value = callback.apply(this, reified);
      return seen[name] = exports || value;

      function resolve(child) {
        if (child.charAt(0) !== '.') { return child; }
        var parts = child.split("/");
        var parentBase = name.split("/").slice(0, -1);

        for (var i=0, l=parts.length; i<l; i++) {
          var part = parts[i];

          if (part === '..') { parentBase.pop(); }
          else if (part === '.') { continue; }
          else { parentBase.push(part); }
        }

        return parentBase.join("/");
      }
    };
    requirejs._eak_seen = registry;

    Ember.__loader = {define: enifed, require: eriuqer, registry: registry};
  } else {
    enifed = Ember.__loader.define;
    requirejs = eriuqer = requireModule = Ember.__loader.require;
  }
})();

enifed("backburner",
  ["backburner/utils","backburner/platform","backburner/binary-search","backburner/deferred-action-queues","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    var each = __dependency1__.each;
    var isString = __dependency1__.isString;
    var isFunction = __dependency1__.isFunction;
    var isNumber = __dependency1__.isNumber;
    var isCoercableNumber = __dependency1__.isCoercableNumber;
    var wrapInTryCatch = __dependency1__.wrapInTryCatch;
    var now = __dependency1__.now;

    var needsIETryCatchFix = __dependency2__.needsIETryCatchFix;

    var searchTimer = __dependency3__["default"];

    var DeferredActionQueues = __dependency4__["default"];

    var slice = [].slice;
    var pop = [].pop;
    var global = this;

    function Backburner(queueNames, options) {
      this.queueNames = queueNames;
      this.options = options || {};
      if (!this.options.defaultQueue) {
        this.options.defaultQueue = queueNames[0];
      }
      this.instanceStack = [];
      this._debouncees = [];
      this._throttlers = [];
      this._timers = [];
    }

    Backburner.prototype = {
      begin: function() {
        var options = this.options;
        var onBegin = options && options.onBegin;
        var previousInstance = this.currentInstance;

        if (previousInstance) {
          this.instanceStack.push(previousInstance);
        }

        this.currentInstance = new DeferredActionQueues(this.queueNames, options);
        if (onBegin) {
          onBegin(this.currentInstance, previousInstance);
        }
      },

      end: function() {
        var options = this.options;
        var onEnd = options && options.onEnd;
        var currentInstance = this.currentInstance;
        var nextInstance = null;

        // Prevent double-finally bug in Safari 6.0.2 and iOS 6
        // This bug appears to be resolved in Safari 6.0.5 and iOS 7
        var finallyAlreadyCalled = false;
        try {
          currentInstance.flush();
        } finally {
          if (!finallyAlreadyCalled) {
            finallyAlreadyCalled = true;

            this.currentInstance = null;

            if (this.instanceStack.length) {
              nextInstance = this.instanceStack.pop();
              this.currentInstance = nextInstance;
            }

            if (onEnd) {
              onEnd(currentInstance, nextInstance);
            }
          }
        }
      },

      run: function(target, method /*, args */) {
        var onError = getOnError(this.options);

        this.begin();

        if (!method) {
          method = target;
          target = null;
        }

        if (isString(method)) {
          method = target[method];
        }

        var args = slice.call(arguments, 2);

        // guard against Safari 6's double-finally bug
        var didFinally = false;

        if (onError) {
          try {
            return method.apply(target, args);
          } catch(error) {
            onError(error);
          } finally {
            if (!didFinally) {
              didFinally = true;
              this.end();
            }
          }
        } else {
          try {
            return method.apply(target, args);
          } finally {
            if (!didFinally) {
              didFinally = true;
              this.end();
            }
          }
        }
      },

      defer: function(queueName, target, method /* , args */) {
        if (!method) {
          method = target;
          target = null;
        }

        if (isString(method)) {
          method = target[method];
        }

        var stack = this.DEBUG ? new Error() : undefined;
        var length = arguments.length;
        var args;

        if (length > 3) {
          args = new Array(length - 3);
          for (var i = 3; i < length; i++) {
            args[i-3] = arguments[i];
          }
        } else {
          args = undefined;
        }

        if (!this.currentInstance) { createAutorun(this); }
        return this.currentInstance.schedule(queueName, target, method, args, false, stack);
      },

      deferOnce: function(queueName, target, method /* , args */) {
        if (!method) {
          method = target;
          target = null;
        }

        if (isString(method)) {
          method = target[method];
        }

        var stack = this.DEBUG ? new Error() : undefined;
        var length = arguments.length;
        var args;

        if (length > 3) {
          args = new Array(length - 3);
          for (var i = 3; i < length; i++) {
            args[i-3] = arguments[i];
          }
        } else {
          args = undefined;
        }

        if (!this.currentInstance) {
          createAutorun(this);
        }
        return this.currentInstance.schedule(queueName, target, method, args, true, stack);
      },

      setTimeout: function() {
        var l = arguments.length;
        var args = new Array(l);

        for (var x = 0; x < l; x++) {
          args[x] = arguments[x];
        }

        var length = args.length,
            method, wait, target,
            methodOrTarget, methodOrWait, methodOrArgs;

        if (length === 0) {
          return;
        } else if (length === 1) {
          method = args.shift();
          wait = 0;
        } else if (length === 2) {
          methodOrTarget = args[0];
          methodOrWait = args[1];

          if (isFunction(methodOrWait) || isFunction(methodOrTarget[methodOrWait])) {
            target = args.shift();
            method = args.shift();
            wait = 0;
          } else if (isCoercableNumber(methodOrWait)) {
            method = args.shift();
            wait = args.shift();
          } else {
            method = args.shift();
            wait =  0;
          }
        } else {
          var last = args[args.length - 1];

          if (isCoercableNumber(last)) {
            wait = args.pop();
          } else {
            wait = 0;
          }

          methodOrTarget = args[0];
          methodOrArgs = args[1];

          if (isFunction(methodOrArgs) || (isString(methodOrArgs) &&
                                          methodOrTarget !== null &&
                                          methodOrArgs in methodOrTarget)) {
            target = args.shift();
            method = args.shift();
          } else {
            method = args.shift();
          }
        }

        var executeAt = now() + parseInt(wait, 10);

        if (isString(method)) {
          method = target[method];
        }

        var onError = getOnError(this.options);

        function fn() {
          if (onError) {
            try {
              method.apply(target, args);
            } catch (e) {
              onError(e);
            }
          } else {
            method.apply(target, args);
          }
        }

        // find position to insert
        var i = searchTimer(executeAt, this._timers);

        this._timers.splice(i, 0, executeAt, fn);

        updateLaterTimer(this, executeAt, wait);

        return fn;
      },

      throttle: function(target, method /* , args, wait, [immediate] */) {
        var backburner = this;
        var args = arguments;
        var immediate = pop.call(args);
        var wait, throttler, index, timer;

        if (isNumber(immediate) || isString(immediate)) {
          wait = immediate;
          immediate = true;
        } else {
          wait = pop.call(args);
        }

        wait = parseInt(wait, 10);

        index = findThrottler(target, method, this._throttlers);
        if (index > -1) { return this._throttlers[index]; } // throttled

        timer = global.setTimeout(function() {
          if (!immediate) {
            backburner.run.apply(backburner, args);
          }
          var index = findThrottler(target, method, backburner._throttlers);
          if (index > -1) {
            backburner._throttlers.splice(index, 1);
          }
        }, wait);

        if (immediate) {
          this.run.apply(this, args);
        }

        throttler = [target, method, timer];

        this._throttlers.push(throttler);

        return throttler;
      },

      debounce: function(target, method /* , args, wait, [immediate] */) {
        var backburner = this;
        var args = arguments;
        var immediate = pop.call(args);
        var wait, index, debouncee, timer;

        if (isNumber(immediate) || isString(immediate)) {
          wait = immediate;
          immediate = false;
        } else {
          wait = pop.call(args);
        }

        wait = parseInt(wait, 10);
        // Remove debouncee
        index = findDebouncee(target, method, this._debouncees);

        if (index > -1) {
          debouncee = this._debouncees[index];
          this._debouncees.splice(index, 1);
          clearTimeout(debouncee[2]);
        }

        timer = global.setTimeout(function() {
          if (!immediate) {
            backburner.run.apply(backburner, args);
          }
          var index = findDebouncee(target, method, backburner._debouncees);
          if (index > -1) {
            backburner._debouncees.splice(index, 1);
          }
        }, wait);

        if (immediate && index === -1) {
          backburner.run.apply(backburner, args);
        }

        debouncee = [
          target,
          method,
          timer
        ];

        backburner._debouncees.push(debouncee);

        return debouncee;
      },

      cancelTimers: function() {
        var clearItems = function(item) {
          clearTimeout(item[2]);
        };

        each(this._throttlers, clearItems);
        this._throttlers = [];

        each(this._debouncees, clearItems);
        this._debouncees = [];

        if (this._laterTimer) {
          clearTimeout(this._laterTimer);
          this._laterTimer = null;
        }
        this._timers = [];

        if (this._autorun) {
          clearTimeout(this._autorun);
          this._autorun = null;
        }
      },

      hasTimers: function() {
        return !!this._timers.length || !!this._debouncees.length || !!this._throttlers.length || this._autorun;
      },

      cancel: function(timer) {
        var timerType = typeof timer;

        if (timer && timerType === 'object' && timer.queue && timer.method) { // we're cancelling a deferOnce
          return timer.queue.cancel(timer);
        } else if (timerType === 'function') { // we're cancelling a setTimeout
          for (var i = 0, l = this._timers.length; i < l; i += 2) {
            if (this._timers[i + 1] === timer) {
              this._timers.splice(i, 2); // remove the two elements
              if (i === 0) {
                if (this._laterTimer) { // Active timer? Then clear timer and reset for future timer
                  clearTimeout(this._laterTimer);
                  this._laterTimer = null;
                }
                if (this._timers.length > 0) { // Update to next available timer when available
                  updateLaterTimer(this, this._timers[0], this._timers[0] - now());
                }
              }
              return true;
            }
          }
        } else if (Object.prototype.toString.call(timer) === "[object Array]"){ // we're cancelling a throttle or debounce
          return this._cancelItem(findThrottler, this._throttlers, timer) ||
                   this._cancelItem(findDebouncee, this._debouncees, timer);
        } else {
          return; // timer was null or not a timer
        }
      },

      _cancelItem: function(findMethod, array, timer){
        var item, index;

        if (timer.length < 3) { return false; }

        index = findMethod(timer[0], timer[1], array);

        if (index > -1) {

          item = array[index];

          if (item[2] === timer[2]) {
            array.splice(index, 1);
            clearTimeout(timer[2]);
            return true;
          }
        }

        return false;
      }
    };

    Backburner.prototype.schedule = Backburner.prototype.defer;
    Backburner.prototype.scheduleOnce = Backburner.prototype.deferOnce;
    Backburner.prototype.later = Backburner.prototype.setTimeout;

    if (needsIETryCatchFix) {
      var originalRun = Backburner.prototype.run;
      Backburner.prototype.run = wrapInTryCatch(originalRun);

      var originalEnd = Backburner.prototype.end;
      Backburner.prototype.end = wrapInTryCatch(originalEnd);
    }

    function getOnError(options) {
      return options.onError || (options.onErrorTarget && options.onErrorTarget[options.onErrorMethod]);
    }

    function createAutorun(backburner) {
      backburner.begin();
      backburner._autorun = global.setTimeout(function() {
        backburner._autorun = null;
        backburner.end();
      });
    }

    function updateLaterTimer(backburner, executeAt, wait) {
      var n = now();
      if (!backburner._laterTimer || executeAt < backburner._laterTimerExpiresAt || backburner._laterTimerExpiresAt < n) {

        if (backburner._laterTimer) {
          // Clear when:
          // - Already expired
          // - New timer is earlier
          clearTimeout(backburner._laterTimer);

          if (backburner._laterTimerExpiresAt < n) { // If timer was never triggered
            // Calculate the left-over wait-time
            wait = Math.max(0, executeAt - n);
          }
        }

        backburner._laterTimer = global.setTimeout(function() {
          backburner._laterTimer = null;
          backburner._laterTimerExpiresAt = null;
          executeTimers(backburner);
        }, wait);

        backburner._laterTimerExpiresAt = n + wait;
      }
    }

    function executeTimers(backburner) {
      var n = now();
      var fns, i, l;

      backburner.run(function() {
        i = searchTimer(n, backburner._timers);

        fns = backburner._timers.splice(0, i);

        for (i = 1, l = fns.length; i < l; i += 2) {
          backburner.schedule(backburner.options.defaultQueue, null, fns[i]);
        }
      });

      if (backburner._timers.length) {
        updateLaterTimer(backburner, backburner._timers[0], backburner._timers[0] - n);
      }
    }

    function findDebouncee(target, method, debouncees) {
      return findItem(target, method, debouncees);
    }

    function findThrottler(target, method, throttlers) {
      return findItem(target, method, throttlers);
    }

    function findItem(target, method, collection) {
      var item;
      var index = -1;

      for (var i = 0, l = collection.length; i < l; i++) {
        item = collection[i];
        if (item[0] === target && item[1] === method) {
          index = i;
          break;
        }
      }

      return index;
    }

    __exports__["default"] = Backburner;
  });
enifed("backburner.umd",
  ["./backburner"],
  function(__dependency1__) {
    "use strict";
    var Backburner = __dependency1__["default"];

    /* global define:true module:true window: true */
    if (typeof enifed === 'function' && enifed.amd) {
      enifed(function() { return Backburner; });
    } else if (typeof module !== 'undefined' && module.exports) {
      module.exports = Backburner;
    } else if (typeof this !== 'undefined') {
      this['Backburner'] = Backburner;
    }
  });
enifed("backburner/binary-search",
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = function binarySearch(time, timers) {
      var start = 0;
      var end = timers.length - 2;
      var middle, l;

      while (start < end) {
        // since timers is an array of pairs 'l' will always
        // be an integer
        l = (end - start) / 2;

        // compensate for the index in case even number
        // of pairs inside timers
        middle = start + l - (l % 2);

        if (time >= timers[middle]) {
          start = middle + 2;
        } else {
          end = middle;
        }
      }

      return (time >= timers[start]) ? start + 2 : start;
    }
  });
enifed("backburner/deferred-action-queues",
  ["./utils","./queue","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var each = __dependency1__.each;
    var isString = __dependency1__.isString;
    var Queue = __dependency2__["default"];

    function DeferredActionQueues(queueNames, options) {
      var queues = this.queues = {};
      this.queueNames = queueNames = queueNames || [];

      this.options = options;

      each(queueNames, function(queueName) {
        queues[queueName] = new Queue(queueName, options[queueName], options);
      });
    }

    function noSuchQueue(name) {
      throw new Error("You attempted to schedule an action in a queue (" + name + ") that doesn't exist");
    }

    DeferredActionQueues.prototype = {
      schedule: function(name, target, method, args, onceFlag, stack) {
        var queues = this.queues;
        var queue = queues[name];

        if (!queue) { noSuchQueue(name); }

        if (onceFlag) {
          return queue.pushUnique(target, method, args, stack);
        } else {
          return queue.push(target, method, args, stack);
        }
      },

      invoke: function(target, method, args, _, _errorRecordedForStack) {
        if (args && args.length > 0) {
          method.apply(target, args);
        } else {
          method.call(target);
        }
      },

      invokeWithOnError: function(target, method, args, onError, errorRecordedForStack) {
        try {
          if (args && args.length > 0) {
            method.apply(target, args);
          } else {
            method.call(target);
          }
        } catch(error) {
          onError(error, errorRecordedForStack);
        }
      },

      flush: function() {
        var queues = this.queues;
        var queueNames = this.queueNames;
        var queueName, queue, queueItems, priorQueueNameIndex;
        var queueNameIndex = 0;
        var numberOfQueues = queueNames.length;
        var options = this.options;
        var onError = options.onError || (options.onErrorTarget && options.onErrorTarget[options.onErrorMethod]);
        var invoke = onError ? this.invokeWithOnError : this.invoke;

        while (queueNameIndex < numberOfQueues) {
          queueName = queueNames[queueNameIndex];
          queue = queues[queueName];
          queueItems = queue._queueBeingFlushed = queue._queue.slice();
          queue._queue = [];
          queue.targetQueues = Object.create(null);

          var queueOptions = queue.options; // TODO: write a test for this
          var before = queueOptions && queueOptions.before;
          var after = queueOptions && queueOptions.after;
          var target, method, args, errorRecordedForStack;
          var queueIndex = 0;
          var numberOfQueueItems = queueItems.length;

          if (numberOfQueueItems && before) {
            before();
          }

          while (queueIndex < numberOfQueueItems) {
            target                = queueItems[queueIndex];
            method                = queueItems[queueIndex+1];
            args                  = queueItems[queueIndex+2];
            errorRecordedForStack = queueItems[queueIndex+3]; // Debugging assistance

            //

            if (isString(method)) {
              method = target[method];
            }

            // method could have been nullified / canceled during flush
            if (method) {
              //
              //    ** Attention intrepid developer **
              //
              //    To find out the stack of this task when it was scheduled onto
              //    the run loop, add the following to your app.js:
              //
              //    Ember.run.backburner.DEBUG = true; // NOTE: This slows your app, don't leave it on in production.
              //
              //    Once that is in place, when you are at a breakpoint and navigate
              //    here in the stack explorer, you can look at `errorRecordedForStack.stack`,
              //    which will be the captured stack when this job was scheduled.
              //
              invoke(target, method, args, onError, errorRecordedForStack);
            }

            queueIndex += 4;
          }

          queue._queueBeingFlushed = null;
          if (numberOfQueueItems && after) {
            after();
          }

          if ((priorQueueNameIndex = indexOfPriorQueueWithActions(this, queueNameIndex)) !== -1) {
            queueNameIndex = priorQueueNameIndex;
          } else {
            queueNameIndex++;
          }
        }
      }
    };

    function indexOfPriorQueueWithActions(daq, currentQueueIndex) {
      var queueName, queue;

      for (var i = 0, l = currentQueueIndex; i <= l; i++) {
        queueName = daq.queueNames[i];
        queue = daq.queues[queueName];
        if (queue._queue.length) { return i; }
      }

      return -1;
    }

    __exports__["default"] = DeferredActionQueues;
  });
enifed("backburner/platform",
  ["exports"],
  function(__exports__) {
    "use strict";
    // In IE 6-8, try/finally doesn't work without a catch.
    // Unfortunately, this is impossible to test for since wrapping it in a parent try/catch doesn't trigger the bug.
    // This tests for another broken try/catch behavior that only exhibits in the same versions of IE.
    var needsIETryCatchFix = (function(e,x){
      try{ x(); }
      catch(e) { } // jshint ignore:line
      return !!e;
    })();
    __exports__.needsIETryCatchFix = needsIETryCatchFix;
  });
enifed("backburner/queue",
  ["exports"],
  function(__exports__) {
    "use strict";
    function Queue(name, options, globalOptions) {
      this.name = name;
      this.globalOptions = globalOptions || {};
      this.options = options;
      this._queue = [];
      this.targetQueues = Object.create(null);
      this._queueBeingFlushed = undefined;
    }

    Queue.prototype = {
      push: function(target, method, args, stack) {
        var queue = this._queue;
        queue.push(target, method, args, stack);

        return {
          queue: this,
          target: target,
          method: method
        };
      },

      pushUniqueWithoutGuid: function(target, method, args, stack) {
        var queue = this._queue;

        for (var i = 0, l = queue.length; i < l; i += 4) {
          var currentTarget = queue[i];
          var currentMethod = queue[i+1];

          if (currentTarget === target && currentMethod === method) {
            queue[i+2] = args;  // replace args
            queue[i+3] = stack; // replace stack
            return;
          }
        }

        queue.push(target, method, args, stack);
      },

      targetQueue: function(targetQueue, target, method, args, stack) {
        var queue = this._queue;

        for (var i = 0, l = targetQueue.length; i < l; i += 4) {
          var currentMethod = targetQueue[i];
          var currentIndex  = targetQueue[i + 1];

          if (currentMethod === method) {
            queue[currentIndex + 2] = args;  // replace args
            queue[currentIndex + 3] = stack; // replace stack
            return;
          }
        }

        targetQueue.push(
          method,
          queue.push(target, method, args, stack) - 4
        );
      },

      pushUniqueWithGuid: function(guid, target, method, args, stack) {
        var hasLocalQueue = this.targetQueues[guid];

        if (hasLocalQueue) {
          this.targetQueue(hasLocalQueue, target, method, args, stack);
        } else {
          this.targetQueues[guid] = [
            method,
            this._queue.push(target, method, args, stack) - 4
          ];
        }

        return {
          queue: this,
          target: target,
          method: method
        };
      },

      pushUnique: function(target, method, args, stack) {
        var queue = this._queue, currentTarget, currentMethod, i, l;
        var KEY = this.globalOptions.GUID_KEY;

        if (target && KEY) {
          var guid = target[KEY];
          if (guid) {
            return this.pushUniqueWithGuid(guid, target, method, args, stack);
          }
        }

        this.pushUniqueWithoutGuid(target, method, args, stack);

        return {
          queue: this,
          target: target,
          method: method
        };
      },

      // TODO: remove me, only being used for Ember.run.sync
      flush: function() {
        var queue = this._queue;
        var globalOptions = this.globalOptions;
        var options = this.options;
        var before = options && options.before;
        var after = options && options.after;
        var onError = globalOptions.onError || (globalOptions.onErrorTarget && globalOptions.onErrorTarget[globalOptions.onErrorMethod]);
        var target, method, args, stack, i, l = queue.length;

        this.targetQueues = Object.create(null);

        if (l && before) { before(); }
        for (i = 0; i < l; i += 4) {
          target = queue[i];
          method = queue[i+1];
          args   = queue[i+2];
          stack  = queue[i+3]; // Debugging assistance

          // TODO: error handling
          if (args && args.length > 0) {
            if (onError) {
              try {
                method.apply(target, args);
              } catch (e) {
                onError(e);
              }
            } else {
              method.apply(target, args);
            }
          } else {
            if (onError) {
              try {
                method.call(target);
              } catch(e) {
                onError(e);
              }
            } else {
              method.call(target);
            }
          }
        }
        if (l && after) { after(); }

        // check if new items have been added
        if (queue.length > l) {
          this._queue = queue.slice(l);
          this.flush();
        } else {
          this._queue.length = 0;
        }
      },

      cancel: function(actionToCancel) {
        var queue = this._queue, currentTarget, currentMethod, i, l;
        var target = actionToCancel.target;
        var method = actionToCancel.method;
        var GUID_KEY = this.globalOptions.GUID_KEY;

        if (GUID_KEY && this.targetQueues && target) {
          var targetQueue = this.targetQueues[target[GUID_KEY]];

          if (targetQueue) {
            for (i = 0, l = targetQueue.length; i < l; i++) {
              if (targetQueue[i] === method) {
                targetQueue.splice(i, 1);
              }
            }
          }
        }

        for (i = 0, l = queue.length; i < l; i += 4) {
          currentTarget = queue[i];
          currentMethod = queue[i+1];

          if (currentTarget === target &&
              currentMethod === method) {
            queue.splice(i, 4);
            return true;
          }
        }

        // if not found in current queue
        // could be in the queue that is being flushed
        queue = this._queueBeingFlushed;
        if (!queue) {
          return;
        }
        for (i = 0, l = queue.length; i < l; i += 4) {
          currentTarget = queue[i];
          currentMethod = queue[i+1];

          if (currentTarget === target &&
              currentMethod === method) {
            // don't mess with array during flush
            // just nullify the method
            queue[i+1] = null;
            return true;
          }
        }
      }
    };

    __exports__["default"] = Queue;
  });
enifed("backburner/utils",
  ["exports"],
  function(__exports__) {
    "use strict";
    var NUMBER = /\d+/;

    function each(collection, callback) {
      for (var i = 0; i < collection.length; i++) {
        callback(collection[i]);
      }
    }

    __exports__.each = each;// Date.now is not available in browsers < IE9
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/now#Compatibility
    var now = Date.now || function() { return new Date().getTime(); };
    __exports__.now = now;
    function isString(suspect) {
      return typeof suspect === 'string';
    }

    __exports__.isString = isString;function isFunction(suspect) {
      return typeof suspect === 'function';
    }

    __exports__.isFunction = isFunction;function isNumber(suspect) {
      return typeof suspect === 'number';
    }

    __exports__.isNumber = isNumber;function isCoercableNumber(number) {
      return isNumber(number) || NUMBER.test(number);
    }

    __exports__.isCoercableNumber = isCoercableNumber;function wrapInTryCatch(func) {
      return function () {
        try {
          return func.apply(this, arguments);
        } catch (e) {
          throw e;
        }
      };
    }

    __exports__.wrapInTryCatch = wrapInTryCatch;
  });
enifed("calculateVersion",
  [],
  function() {
    "use strict";
    'use strict';

    var fs   = eriuqer('fs');
    var path = eriuqer('path');

    module.exports = function () {
      var packageVersion = eriuqer('../package.json').version;
      var output         = [packageVersion];
      var gitPath        = path.join(__dirname,'..','.git');
      var headFilePath   = path.join(gitPath, 'HEAD');

      if (packageVersion.indexOf('+') > -1) {
        try {
          if (fs.existsSync(headFilePath)) {
            var headFile = fs.readFileSync(headFilePath, {encoding: 'utf8'});
            var branchName = headFile.split('/').slice(-1)[0].trim();
            var refPath = headFile.split(' ')[1];
            var branchSHA;

            if (refPath) {
              var branchPath = path.join(gitPath, refPath.trim());
              branchSHA  = fs.readFileSync(branchPath);
            } else {
              branchSHA = branchName;
            }

            output.push(branchSHA.slice(0,10));
          }
        } catch (err) {
          console.error(err.stack);
        }
        return output.join('.');
      } else {
        return packageVersion;
      }
    };
  });
enifed("container",
  ["container/container","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    /*
    Public api for the container is still in flux.
    The public api, specified on the application namespace should be considered the stable api.
    // @module container
      @private
    */

    /*
     Flag to enable/disable model factory injections (disabled by default)
     If model factory injections are enabled, models should not be
     accessed globally (only through `container.lookupFactory('model:modelName'))`);
    */
    Ember.MODEL_FACTORY_INJECTIONS = false;

    if (Ember.ENV && typeof Ember.ENV.MODEL_FACTORY_INJECTIONS !== 'undefined') {
      Ember.MODEL_FACTORY_INJECTIONS = !!Ember.ENV.MODEL_FACTORY_INJECTIONS;
    }


    var Container = __dependency1__["default"];

    __exports__["default"] = Container;
  });
enifed("container/container",
  ["ember-metal/core","ember-metal/keys","ember-metal/dictionary","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    // Ember.assert
    var emberKeys = __dependency2__["default"];
    var dictionary = __dependency3__["default"];

    // A lightweight container that helps to assemble and decouple components.
    // Public api for the container is still in flux.
    // The public api, specified on the application namespace should be considered the stable api.
    function Container(parent) {
      this.parent = parent;
      this.children = [];

      this.resolver = parent && parent.resolver || function() {};

      this.registry       = dictionary(parent ? parent.registry : null);
      this.cache          = dictionary(parent ? parent.cache : null);
      this.factoryCache   = dictionary(parent ? parent.factoryCache : null);
      this.resolveCache   = dictionary(parent ? parent.resolveCache : null);
      this.typeInjections = dictionary(parent ? parent.typeInjections : null);
      this.injections     = dictionary(null);
      this.normalizeCache = dictionary(null);

      this.factoryTypeInjections = dictionary(parent ? parent.factoryTypeInjections : null);
      this.factoryInjections     = dictionary(null);

      this._options     = dictionary(parent ? parent._options : null);
      this._typeOptions = dictionary(parent ? parent._typeOptions : null);
    }

    Container.prototype = {

      /**
        @property parent
        @type Container
        @default null
      */
      parent: null,

      /**
        @property children
        @type Array
        @default []
      */
      children: null,

      /**
        @property resolver
        @type function
      */
      resolver: null,

      /**
        @property registry
        @type InheritingDict
      */
      registry: null,

      /**
        @property cache
        @type InheritingDict
      */
      cache: null,

      /**
        @property typeInjections
        @type InheritingDict
      */
      typeInjections: null,

      /**
        @property injections
        @type Object
        @default {}
      */
      injections: null,

      /**
        @private

        @property _options
        @type InheritingDict
        @default null
      */
      _options: null,

      /**
        @private

        @property _typeOptions
        @type InheritingDict
      */
      _typeOptions: null,

      /**
        Returns a new child of the current container. These children are configured
        to correctly inherit from the current container.

        @method child
        @return {Container}
      */
      child: function() {
        var container = new Container(this);
        this.children.push(container);
        return container;
      },

      /**
        Sets a key-value pair on the current container. If a parent container,
        has the same key, once set on a child, the parent and child will diverge
        as expected.

        @method set
        @param {Object} object
        @param {String} key
        @param {any} value
      */
      set: function(object, key, value) {
        object[key] = value;
      },

      /**
        Registers a factory for later injection.

        Example:

        ```javascript
        var container = new Container();

        container.register('model:user', Person, {singleton: false });
        container.register('fruit:favorite', Orange);
        container.register('communication:main', Email, {singleton: false});
        ```

        @method register
        @param {String} fullName
        @param {Function} factory
        @param {Object} options
      */
      register: function(fullName, factory, options) {
        Ember.assert('fullName must be a proper full name', validateFullName(fullName));

        if (factory === undefined) {
          throw new TypeError('Attempting to register an unknown factory: `' + fullName + '`');
        }

        var normalizedName = this.normalize(fullName);

        if (normalizedName in this.cache) {
          throw new Error('Cannot re-register: `' + fullName +'`, as it has already been looked up.');
        }

        this.registry[normalizedName] = factory;
        this._options[normalizedName] = (options || {});
      },

      /**
        Unregister a fullName

        ```javascript
        var container = new Container();
        container.register('model:user', User);

        container.lookup('model:user') instanceof User //=> true

        container.unregister('model:user')
        container.lookup('model:user') === undefined //=> true
        ```

        @method unregister
        @param {String} fullName
       */
      unregister: function(fullName) {
        Ember.assert('fullName must be a proper full name', validateFullName(fullName));

        var normalizedName = this.normalize(fullName);

        delete this.registry[normalizedName];
        delete this.cache[normalizedName];
        delete this.factoryCache[normalizedName];
        delete this.resolveCache[normalizedName];
        delete this._options[normalizedName];
      },

      /**
        Given a fullName return the corresponding factory.

        By default `resolve` will retrieve the factory from
        its container's registry.

        ```javascript
        var container = new Container();
        container.register('api:twitter', Twitter);

        container.resolve('api:twitter') // => Twitter
        ```

        Optionally the container can be provided with a custom resolver.
        If provided, `resolve` will first provide the custom resolver
        the opportunity to resolve the fullName, otherwise it will fallback
        to the registry.

        ```javascript
        var container = new Container();
        container.resolver = function(fullName) {
          // lookup via the module system of choice
        };

        // the twitter factory is added to the module system
        container.resolve('api:twitter') // => Twitter
        ```

        @method resolve
        @param {String} fullName
        @return {Function} fullName's factory
      */
      resolve: function(fullName) {
        Ember.assert('fullName must be a proper full name', validateFullName(fullName));
        return resolve(this, this.normalize(fullName));
      },

      /**
        A hook that can be used to describe how the resolver will
        attempt to find the factory.

        For example, the default Ember `.describe` returns the full
        class name (including namespace) where Ember's resolver expects
        to find the `fullName`.

        @method describe
        @param {String} fullName
        @return {string} described fullName
      */
      describe: function(fullName) {
        return fullName;
      },

      /**
        A hook to enable custom fullName normalization behaviour

        @method normalizeFullName
        @param {String} fullName
        @return {string} normalized fullName
      */
      normalizeFullName: function(fullName) {
        return fullName;
      },

      /**
        normalize a fullName based on the applications conventions

        @method normalize
        @param {String} fullName
        @return {string} normalized fullName
      */
      normalize: function(fullName) {
        return this.normalizeCache[fullName] || (
          this.normalizeCache[fullName] = this.normalizeFullName(fullName)
        );
      },

      /**
        @method makeToString

        @param {any} factory
        @param {string} fullName
        @return {function} toString function
      */
      makeToString: function(factory, fullName) {
        return factory.toString();
      },

      /**
        Given a fullName return a corresponding instance.

        The default behaviour is for lookup to return a singleton instance.
        The singleton is scoped to the container, allowing multiple containers
        to all have their own locally scoped singletons.

        ```javascript
        var container = new Container();
        container.register('api:twitter', Twitter);

        var twitter = container.lookup('api:twitter');

        twitter instanceof Twitter; // => true

        // by default the container will return singletons
        var twitter2 = container.lookup('api:twitter');
        twitter2 instanceof Twitter; // => true

        twitter === twitter2; //=> true
        ```

        If singletons are not wanted an optional flag can be provided at lookup.

        ```javascript
        var container = new Container();
        container.register('api:twitter', Twitter);

        var twitter = container.lookup('api:twitter', { singleton: false });
        var twitter2 = container.lookup('api:twitter', { singleton: false });

        twitter === twitter2; //=> false
        ```

        @method lookup
        @param {String} fullName
        @param {Object} options
        @return {any}
      */
      lookup: function(fullName, options) {
        Ember.assert('fullName must be a proper full name', validateFullName(fullName));
        return lookup(this, this.normalize(fullName), options);
      },

      /**
        Given a fullName return the corresponding factory.

        @method lookupFactory
        @param {String} fullName
        @return {any}
      */
      lookupFactory: function(fullName) {
        Ember.assert('fullName must be a proper full name', validateFullName(fullName));
        return factoryFor(this, this.normalize(fullName));
      },

      /**
        Given a fullName check if the container is aware of its factory
        or singleton instance.

        @method has
        @param {String} fullName
        @return {Boolean}
      */
      has: function(fullName) {
        Ember.assert('fullName must be a proper full name', validateFullName(fullName));
        return has(this, this.normalize(fullName));
      },

      /**
        Allow registering options for all factories of a type.

        ```javascript
        var container = new Container();

        // if all of type `connection` must not be singletons
        container.optionsForType('connection', { singleton: false });

        container.register('connection:twitter', TwitterConnection);
        container.register('connection:facebook', FacebookConnection);

        var twitter = container.lookup('connection:twitter');
        var twitter2 = container.lookup('connection:twitter');

        twitter === twitter2; // => false

        var facebook = container.lookup('connection:facebook');
        var facebook2 = container.lookup('connection:facebook');

        facebook === facebook2; // => false
        ```

        @method optionsForType
        @param {String} type
        @param {Object} options
      */
      optionsForType: function(type, options) {
        if (this.parent) { illegalChildOperation('optionsForType'); }

        this._typeOptions[type] = options;
      },

      /**
        @method options
        @param {String} type
        @param {Object} options
      */
      options: function(type, options) {
        this.optionsForType(type, options);
      },

      /**
        Used only via `injection`.

        Provides a specialized form of injection, specifically enabling
        all objects of one type to be injected with a reference to another
        object.

        For example, provided each object of type `controller` needed a `router`.
        one would do the following:

        ```javascript
        var container = new Container();

        container.register('router:main', Router);
        container.register('controller:user', UserController);
        container.register('controller:post', PostController);

        container.typeInjection('controller', 'router', 'router:main');

        var user = container.lookup('controller:user');
        var post = container.lookup('controller:post');

        user.router instanceof Router; //=> true
        post.router instanceof Router; //=> true

        // both controllers share the same router
        user.router === post.router; //=> true
        ```

        @private
        @method typeInjection
        @param {String} type
        @param {String} property
        @param {String} fullName
      */
      typeInjection: function(type, property, fullName) {
        Ember.assert('fullName must be a proper full name', validateFullName(fullName));

        if (this.parent) { illegalChildOperation('typeInjection'); }

        var fullNameType = fullName.split(':')[0];
        if (fullNameType === type) {
          throw new Error('Cannot inject a `' + fullName + '` on other ' + type + '(s). Register the `' + fullName + '` as a different type and perform the typeInjection.');
        }

        addTypeInjection(this.typeInjections, type, property, fullName);
      },

      /**
        Defines injection rules.

        These rules are used to inject dependencies onto objects when they
        are instantiated.

        Two forms of injections are possible:

        * Injecting one fullName on another fullName
        * Injecting one fullName on a type

        Example:

        ```javascript
        var container = new Container();

        container.register('source:main', Source);
        container.register('model:user', User);
        container.register('model:post', Post);

        // injecting one fullName on another fullName
        // eg. each user model gets a post model
        container.injection('model:user', 'post', 'model:post');

        // injecting one fullName on another type
        container.injection('model', 'source', 'source:main');

        var user = container.lookup('model:user');
        var post = container.lookup('model:post');

        user.source instanceof Source; //=> true
        post.source instanceof Source; //=> true

        user.post instanceof Post; //=> true

        // and both models share the same source
        user.source === post.source; //=> true
        ```

        @method injection
        @param {String} factoryName
        @param {String} property
        @param {String} injectionName
      */
      injection: function(fullName, property, injectionName) {
        if (this.parent) { illegalChildOperation('injection'); }

        validateFullName(injectionName);
        var normalizedInjectionName = this.normalize(injectionName);

        if (fullName.indexOf(':') === -1) {
          return this.typeInjection(fullName, property, normalizedInjectionName);
        }

        Ember.assert('fullName must be a proper full name', validateFullName(fullName));
        var normalizedName = this.normalize(fullName);

        if (this.cache[normalizedName]) {
          throw new Error("Attempted to register an injection for a type that has already been looked up. ('" + normalizedName + "', '" + property + "', '" + injectionName + "')");
        }
        addInjection(this.injections, normalizedName, property, normalizedInjectionName);
      },


      /**
        Used only via `factoryInjection`.

        Provides a specialized form of injection, specifically enabling
        all factory of one type to be injected with a reference to another
        object.

        For example, provided each factory of type `model` needed a `store`.
        one would do the following:

        ```javascript
        var container = new Container();

        container.register('store:main', SomeStore);

        container.factoryTypeInjection('model', 'store', 'store:main');

        var store = container.lookup('store:main');
        var UserFactory = container.lookupFactory('model:user');

        UserFactory.store instanceof SomeStore; //=> true
        ```

        @private
        @method factoryTypeInjection
        @param {String} type
        @param {String} property
        @param {String} fullName
      */
      factoryTypeInjection: function(type, property, fullName) {
        if (this.parent) { illegalChildOperation('factoryTypeInjection'); }

        addTypeInjection(this.factoryTypeInjections, type, property, this.normalize(fullName));
      },

      /**
        Defines factory injection rules.

        Similar to regular injection rules, but are run against factories, via
        `Container#lookupFactory`.

        These rules are used to inject objects onto factories when they
        are looked up.

        Two forms of injections are possible:

      * Injecting one fullName on another fullName
      * Injecting one fullName on a type

        Example:

        ```javascript
        var container = new Container();

        container.register('store:main', Store);
        container.register('store:secondary', OtherStore);
        container.register('model:user', User);
        container.register('model:post', Post);

        // injecting one fullName on another type
        container.factoryInjection('model', 'store', 'store:main');

        // injecting one fullName on another fullName
        container.factoryInjection('model:post', 'secondaryStore', 'store:secondary');

        var UserFactory = container.lookupFactory('model:user');
        var PostFactory = container.lookupFactory('model:post');
        var store = container.lookup('store:main');

        UserFactory.store instanceof Store; //=> true
        UserFactory.secondaryStore instanceof OtherStore; //=> false

        PostFactory.store instanceof Store; //=> true
        PostFactory.secondaryStore instanceof OtherStore; //=> true

        // and both models share the same source instance
        UserFactory.store === PostFactory.store; //=> true
        ```

        @method factoryInjection
        @param {String} factoryName
        @param {String} property
        @param {String} injectionName
      */
      factoryInjection: function(fullName, property, injectionName) {
        if (this.parent) { illegalChildOperation('injection'); }

        var normalizedName = this.normalize(fullName);
        var normalizedInjectionName = this.normalize(injectionName);

        validateFullName(injectionName);

        if (fullName.indexOf(':') === -1) {
          return this.factoryTypeInjection(normalizedName, property, normalizedInjectionName);
        }

        Ember.assert('fullName must be a proper full name', validateFullName(fullName));

        if (this.factoryCache[normalizedName]) {
          throw new Error('Attempted to register a factoryInjection for a type that has already ' +
            'been looked up. (\'' + normalizedName + '\', \'' + property + '\', \'' + injectionName + '\')');
        }

        addInjection(this.factoryInjections, normalizedName, property, normalizedInjectionName);
      },

      /**
        A depth first traversal, destroying the container, its descendant containers and all
        their managed objects.

        @method destroy
      */
      destroy: function() {
        for (var i = 0, length = this.children.length; i < length; i++) {
          this.children[i].destroy();
        }

        this.children = [];

        eachDestroyable(this, function(item) {
          item.destroy();
        });

        this.parent = undefined;
        this.isDestroyed = true;
      },

      /**
        @method reset
      */
      reset: function() {
        for (var i = 0, length = this.children.length; i < length; i++) {
          resetCache(this.children[i]);
        }

        resetCache(this);
      }
    };

    function resolve(container, normalizedName) {
      var cached = container.resolveCache[normalizedName];
      if (cached) { return cached; }

      var resolved = container.resolver(normalizedName) || container.registry[normalizedName];
      container.resolveCache[normalizedName] = resolved;

      return resolved;
    }

    function has(container, fullName){
      if (container.cache[fullName]) {
        return true;
      }

      return !!container.resolve(fullName);
    }

    function lookup(container, fullName, options) {
      options = options || {};

      if (container.cache[fullName] && options.singleton !== false) {
        return container.cache[fullName];
      }

      var value = instantiate(container, fullName);

      if (value === undefined) { return; }

      if (isSingleton(container, fullName) && options.singleton !== false) {
        container.cache[fullName] = value;
      }

      return value;
    }

    function illegalChildOperation(operation) {
      throw new Error(operation + ' is not currently supported on child containers');
    }

    function isSingleton(container, fullName) {
      var singleton = option(container, fullName, 'singleton');

      return singleton !== false;
    }

    function buildInjections(container, injections) {
      var hash = {};

      if (!injections) { return hash; }

      var injection, injectable;

      for (var i = 0, length = injections.length; i < length; i++) {
        injection = injections[i];
        injectable = lookup(container, injection.fullName);

        if (injectable !== undefined) {
          hash[injection.property] = injectable;
        } else {
          throw new Error('Attempting to inject an unknown injection: `' + injection.fullName + '`');
        }
      }

      return hash;
    }

    function option(container, fullName, optionName) {
      var options = container._options[fullName];

      if (options && options[optionName] !== undefined) {
        return options[optionName];
      }

      var type = fullName.split(':')[0];
      options = container._typeOptions[type];

      if (options) {
        return options[optionName];
      }
    }

    function factoryFor(container, fullName) {
      var cache = container.factoryCache;
      if (cache[fullName]) {
        return cache[fullName];
      }
      var factory = container.resolve(fullName);
      if (factory === undefined) { return; }

      var type = fullName.split(':')[0];
      if (!factory || typeof factory.extend !== 'function' || (!Ember.MODEL_FACTORY_INJECTIONS && type === 'model')) {
        // TODO: think about a 'safe' merge style extension
        // for now just fallback to create time injection
        cache[fullName] = factory;
        return factory;
      } else {
        var injections = injectionsFor(container, fullName);
        var factoryInjections = factoryInjectionsFor(container, fullName);

        factoryInjections._toString = container.makeToString(factory, fullName);

        var injectedFactory = factory.extend(injections);
        injectedFactory.reopenClass(factoryInjections);

        cache[fullName] = injectedFactory;

        return injectedFactory;
      }
    }

    function injectionsFor(container, fullName) {
      var splitName = fullName.split(':');
      var type = splitName[0];
      var injections = [];

      injections = injections.concat(container.typeInjections[type] || []);
      injections = injections.concat(container.injections[fullName] || []);

      injections = buildInjections(container, injections);
      injections._debugContainerKey = fullName;
      injections.container = container;

      return injections;
    }

    function factoryInjectionsFor(container, fullName) {
      var splitName = fullName.split(':');
      var type = splitName[0];
      var factoryInjections = [];

      factoryInjections = factoryInjections.concat(container.factoryTypeInjections[type] || []);
      factoryInjections = factoryInjections.concat(container.factoryInjections[fullName] || []);

      factoryInjections = buildInjections(container, factoryInjections);
      factoryInjections._debugContainerKey = fullName;

      return factoryInjections;
    }

    function instantiate(container, fullName) {
      var factory = factoryFor(container, fullName);

      if (option(container, fullName, 'instantiate') === false) {
        return factory;
      }

      if (factory) {
        if (typeof factory.create !== 'function') {
          throw new Error('Failed to create an instance of \'' + fullName + '\'. ' +
            'Most likely an improperly defined class or an invalid module export.');
        }

        if (typeof factory.extend === 'function') {
          // assume the factory was extendable and is already injected
          return factory.create();
        } else {
          // assume the factory was extendable
          // to create time injections
          // TODO: support new'ing for instantiation and merge injections for pure JS Functions
          return factory.create(injectionsFor(container, fullName));
        }
      }
    }

    function eachDestroyable(container, callback) {
      var cache = container.cache;
      var keys = emberKeys(cache);
      var key, value;

      for (var i = 0, l = keys.length; i < l; i++) {
        key = keys[i];
        value = cache[key];

        if (option(container, key, 'instantiate') !== false) {
          callback(value);
        }
      }
    }

    function resetCache(container) {
      eachDestroyable(container, function(value) {
        value.destroy();
      });

      container.cache.dict = dictionary(null);
    }

    function addTypeInjection(rules, type, property, fullName) {
      var injections = rules[type];

      if (!injections) {
        injections = [];
        rules[type] = injections;
      }

      injections.push({
        property: property,
        fullName: fullName
      });
    }

    var VALID_FULL_NAME_REGEXP = /^[^:]+.+:[^:]+$/;
    function validateFullName(fullName) {
      if (!VALID_FULL_NAME_REGEXP.test(fullName)) {
        throw new TypeError('Invalid Fullname, expected: `type:name` got: ' + fullName);
      }
      return true;
    }

    function addInjection(rules, factoryName, property, injectionName) {
      var injections = rules[factoryName] = rules[factoryName] || [];
      injections.push({
        property: property,
        fullName: injectionName
      });
    }

    __exports__["default"] = Container;
  });
enifed("ember-application",
  ["ember-metal/core","ember-runtime/system/lazy_load","ember-application/system/dag","ember-application/system/resolver","ember-application/system/application","ember-application/ext/controller"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__) {
    "use strict";
    var Ember = __dependency1__["default"];
    var runLoadHooks = __dependency2__.runLoadHooks;

    /**
    Ember Application

    @module ember
    @submodule ember-application
    @requires ember-views, ember-routing
    */

    var DAG = __dependency3__["default"];
    var Resolver = __dependency4__.Resolver;
    var DefaultResolver = __dependency4__["default"];
    var Application = __dependency5__["default"];
    // side effect of extending ControllerMixin

    Ember.Application = Application;
    Ember.DAG = DAG;
    Ember.Resolver = Resolver;
    Ember.DefaultResolver = DefaultResolver;

    runLoadHooks('Ember.Application', Application);
  });
enifed("ember-application/ext/controller",
  ["ember-metal/core","ember-metal/property_get","ember-metal/property_set","ember-metal/error","ember-metal/utils","ember-metal/computed","ember-runtime/mixins/controller","ember-routing/system/controller_for","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __exports__) {
    "use strict";
    /**
    @module ember
    @submodule ember-application
    */

    var Ember = __dependency1__["default"];
    // Ember.assert
    var get = __dependency2__.get;
    var set = __dependency3__.set;
    var EmberError = __dependency4__["default"];
    var inspect = __dependency5__.inspect;
    var computed = __dependency6__.computed;
    var ControllerMixin = __dependency7__["default"];
    var meta = __dependency5__.meta;
    var controllerFor = __dependency8__["default"];

    function verifyNeedsDependencies(controller, container, needs) {
      var dependency, i, l;
      var missing = [];

      for (i=0, l=needs.length; i<l; i++) {
        dependency = needs[i];

        Ember.assert(inspect(controller) + "#needs must not specify dependencies with periods in their names (" + dependency + ")", dependency.indexOf('.') === -1);

        if (dependency.indexOf(':') === -1) {
          dependency = "controller:" + dependency;
        }

        // Structure assert to still do verification but not string concat in production
        if (!container.has(dependency)) {
          missing.push(dependency);
        }
      }
      if (missing.length) {
        throw new EmberError(inspect(controller) + " needs [ " + missing.join(', ') + " ] but " + (missing.length > 1 ? 'they' : 'it') + " could not be found");
      }
    }

    var defaultControllersComputedProperty = computed(function() {
      var controller = this;

      return {
        needs: get(controller, 'needs'),
        container: get(controller, 'container'),
        unknownProperty: function(controllerName) {
          var needs = this.needs;
          var dependency, i, l;

          for (i=0, l=needs.length; i<l; i++) {
            dependency = needs[i];
            if (dependency === controllerName) {
              return this.container.lookup('controller:' + controllerName);
            }
          }

          var errorMessage = inspect(controller) + '#needs does not include `' + controllerName + '`. To access the ' + controllerName + ' controller from ' + inspect(controller) + ', ' + inspect(controller) + ' should have a `needs` property that is an array of the controllers it has access to.';
          throw new ReferenceError(errorMessage);
        },
        setUnknownProperty: function (key, value) {
          throw new Error("You cannot overwrite the value of `controllers." + key + "` of " + inspect(controller));
        }
      };
    });

    /**
      @class ControllerMixin
      @namespace Ember
    */
    ControllerMixin.reopen({
      concatenatedProperties: ['needs'],

      /**
        An array of other controller objects available inside
        instances of this controller via the `controllers`
        property:

        For example, when you define a controller:

        ```javascript
        App.CommentsController = Ember.ArrayController.extend({
          needs: ['post']
        });
        ```

        The application's single instance of these other
        controllers are accessible by name through the
        `controllers` property:

        ```javascript
        this.get('controllers.post'); // instance of App.PostController
        ```

        Given that you have a nested controller (nested resource):

        ```javascript
        App.CommentsNewController = Ember.ObjectController.extend({
        });
        ```

        When you define a controller that requires access to a nested one:

        ```javascript
        App.IndexController = Ember.ObjectController.extend({
          needs: ['commentsNew']
        });
        ```

        You will be able to get access to it:

        ```javascript
        this.get('controllers.commentsNew'); // instance of App.CommentsNewController
        ```

        This is only available for singleton controllers.

        @property {Array} needs
        @default []
      */
      needs: [],

      init: function() {
        var needs = get(this, 'needs');
        var length = get(needs, 'length');

        if (length > 0) {
          Ember.assert(' `' + inspect(this) + ' specifies `needs`, but does ' +
                       "not have a container. Please ensure this controller was " +
                       "instantiated with a container.",
                       this.container || meta(this, false).descs.controllers !== defaultControllersComputedProperty);

          if (this.container) {
            verifyNeedsDependencies(this, this.container, needs);
          }

          // if needs then initialize controllers proxy
          get(this, 'controllers');
        }

        this._super.apply(this, arguments);
      },

      /**
        @method controllerFor
        @see {Ember.Route#controllerFor}
        @deprecated Use `needs` instead
      */
      controllerFor: function(controllerName) {
        Ember.deprecate("Controller#controllerFor is deprecated, please use Controller#needs instead");
        return controllerFor(get(this, 'container'), controllerName);
      },

      /**
        Stores the instances of other controllers available from within
        this controller. Any controller listed by name in the `needs`
        property will be accessible by name through this property.

        ```javascript
        App.CommentsController = Ember.ArrayController.extend({
          needs: ['post'],
          postTitle: function(){
            var currentPost = this.get('controllers.post'); // instance of App.PostController
            return currentPost.get('title');
          }.property('controllers.post.title')
        });
        ```

        @see {Ember.ControllerMixin#needs}
        @property {Object} controllers
        @default null
      */
      controllers: defaultControllersComputedProperty
    });

    __exports__["default"] = ControllerMixin;
  });
enifed("ember-application/system/application",
  ["ember-metal","ember-metal/property_get","ember-metal/property_set","ember-runtime/system/lazy_load","ember-application/system/dag","ember-runtime/system/namespace","ember-runtime/mixins/deferred","ember-application/system/resolver","ember-metal/platform","ember-metal/run_loop","ember-metal/utils","container/container","ember-runtime/controllers/controller","ember-metal/enumerable_utils","ember-runtime/controllers/object_controller","ember-runtime/controllers/array_controller","ember-handlebars/controls/select","ember-views/system/event_dispatcher","ember-views/system/jquery","ember-routing/system/route","ember-routing/system/router","ember-routing/location/hash_location","ember-routing/location/history_location","ember-routing/location/auto_location","ember-routing/location/none_location","ember-routing/system/cache","ember-metal/core","ember-handlebars-compiler","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __dependency11__, __dependency12__, __dependency13__, __dependency14__, __dependency15__, __dependency16__, __dependency17__, __dependency18__, __dependency19__, __dependency20__, __dependency21__, __dependency22__, __dependency23__, __dependency24__, __dependency25__, __dependency26__, __dependency27__, __dependency28__, __exports__) {
    "use strict";
    /**
    @module ember
    @submodule ember-application
    */

    var Ember = __dependency1__["default"];
    // Ember.FEATURES, Ember.deprecate, Ember.assert, Ember.libraries, LOG_VERSION, Namespace, BOOTED
    var get = __dependency2__.get;
    var set = __dependency3__.set;
    var runLoadHooks = __dependency4__.runLoadHooks;
    var DAG = __dependency5__["default"];
    var Namespace = __dependency6__["default"];
    var DeferredMixin = __dependency7__["default"];
    var DefaultResolver = __dependency8__["default"];
    var create = __dependency9__.create;
    var run = __dependency10__["default"];
    var canInvoke = __dependency11__.canInvoke;
    var Container = __dependency12__["default"];
    var Controller = __dependency13__["default"];
    var EnumerableUtils = __dependency14__["default"];
    var ObjectController = __dependency15__["default"];
    var ArrayController = __dependency16__["default"];
    var SelectView = __dependency17__["default"];
    var EventDispatcher = __dependency18__["default"];
    //import ContainerDebugAdapter from "ember-extension-support/container_debug_adapter";
    var jQuery = __dependency19__["default"];
    var Route = __dependency20__["default"];
    var Router = __dependency21__["default"];
    var HashLocation = __dependency22__["default"];
    var HistoryLocation = __dependency23__["default"];
    var AutoLocation = __dependency24__["default"];
    var NoneLocation = __dependency25__["default"];
    var BucketCache = __dependency26__["default"];

    var K = __dependency27__.K;
    var EmberHandlebars = __dependency28__["default"];

    var ContainerDebugAdapter;
    function props(obj) {
      var properties = [];

      for (var key in obj) {
        properties.push(key);
      }

      return properties;
    }

    /**
      An instance of `Ember.Application` is the starting point for every Ember
      application. It helps to instantiate, initialize and coordinate the many
      objects that make up your app.

      Each Ember app has one and only one `Ember.Application` object. In fact, the
      very first thing you should do in your application is create the instance:

      ```javascript
      window.App = Ember.Application.create();
      ```

      Typically, the application object is the only global variable. All other
      classes in your app should be properties on the `Ember.Application` instance,
      which highlights its first role: a global namespace.

      For example, if you define a view class, it might look like this:

      ```javascript
      App.MyView = Ember.View.extend();
      ```

      By default, calling `Ember.Application.create()` will automatically initialize
      your application by calling the `Ember.Application.initialize()` method. If
      you need to delay initialization, you can call your app's `deferReadiness()`
      method. When you are ready for your app to be initialized, call its
      `advanceReadiness()` method.

      You can define a `ready` method on the `Ember.Application` instance, which
      will be run by Ember when the application is initialized.

      Because `Ember.Application` inherits from `Ember.Namespace`, any classes
      you create will have useful string representations when calling `toString()`.
      See the `Ember.Namespace` documentation for more information.

      While you can think of your `Ember.Application` as a container that holds the
      other classes in your application, there are several other responsibilities
      going on under-the-hood that you may want to understand.

      ### Event Delegation

      Ember uses a technique called _event delegation_. This allows the framework
      to set up a global, shared event listener instead of requiring each view to
      do it manually. For example, instead of each view registering its own
      `mousedown` listener on its associated element, Ember sets up a `mousedown`
      listener on the `body`.

      If a `mousedown` event occurs, Ember will look at the target of the event and
      start walking up the DOM node tree, finding corresponding views and invoking
      their `mouseDown` method as it goes.

      `Ember.Application` has a number of default events that it listens for, as
      well as a mapping from lowercase events to camel-cased view method names. For
      example, the `keypress` event causes the `keyPress` method on the view to be
      called, the `dblclick` event causes `doubleClick` to be called, and so on.

      If there is a bubbling browser event that Ember does not listen for by
      default, you can specify custom events and their corresponding view method
      names by setting the application's `customEvents` property:

      ```javascript
      App = Ember.Application.create({
        customEvents: {
          // add support for the paste event
          paste: "paste"
        }
      });
      ```

      By default, the application sets up these event listeners on the document
      body. However, in cases where you are embedding an Ember application inside
      an existing page, you may want it to set up the listeners on an element
      inside the body.

      For example, if only events inside a DOM element with the ID of `ember-app`
      should be delegated, set your application's `rootElement` property:

      ```javascript
      window.App = Ember.Application.create({
        rootElement: '#ember-app'
      });
      ```

      The `rootElement` can be either a DOM element or a jQuery-compatible selector
      string. Note that *views appended to the DOM outside the root element will
      not receive events.* If you specify a custom root element, make sure you only
      append views inside it!

      To learn more about the advantages of event delegation and the Ember view
      layer, and a list of the event listeners that are setup by default, visit the
      [Ember View Layer guide](http://emberjs.com/guides/understanding-ember/the-view-layer/#toc_event-delegation).

      ### Initializers

      Libraries on top of Ember can add initializers, like so:

      ```javascript
      Ember.Application.initializer({
        name: 'api-adapter',

        initialize: function(container, application) {
          application.register('api-adapter:main', ApiAdapter);
        }
      });
      ```

      Initializers provide an opportunity to access the container, which
      organizes the different components of an Ember application. Additionally
      they provide a chance to access the instantiated application. Beyond
      being used for libraries, initializers are also a great way to organize
      dependency injection or setup in your own application.

      ### Routing

      In addition to creating your application's router, `Ember.Application` is
      also responsible for telling the router when to start routing. Transitions
      between routes can be logged with the `LOG_TRANSITIONS` flag, and more
      detailed intra-transition logging can be logged with
      the `LOG_TRANSITIONS_INTERNAL` flag:

      ```javascript
      window.App = Ember.Application.create({
        LOG_TRANSITIONS: true, // basic logging of successful transitions
        LOG_TRANSITIONS_INTERNAL: true // detailed logging of all routing steps
      });
      ```

      By default, the router will begin trying to translate the current URL into
      application state once the browser emits the `DOMContentReady` event. If you
      need to defer routing, you can call the application's `deferReadiness()`
      method. Once routing can begin, call the `advanceReadiness()` method.

      If there is any setup required before routing begins, you can implement a
      `ready()` method on your app that will be invoked immediately before routing
      begins.
      ```

      @class Application
      @namespace Ember
      @extends Ember.Namespace
    */

    var Application = Namespace.extend(DeferredMixin, {
      _suppressDeferredDeprecation: true,

      /**
        The root DOM element of the Application. This can be specified as an
        element or a
        [jQuery-compatible selector string](http://api.jquery.com/category/selectors/).

        This is the element that will be passed to the Application's,
        `eventDispatcher`, which sets up the listeners for event delegation. Every
        view in your application should be a child of the element you specify here.

        @property rootElement
        @type DOMElement
        @default 'body'
      */
      rootElement: 'body',

      /**
        The `Ember.EventDispatcher` responsible for delegating events to this
        application's views.

        The event dispatcher is created by the application at initialization time
        and sets up event listeners on the DOM element described by the
        application's `rootElement` property.

        See the documentation for `Ember.EventDispatcher` for more information.

        @property eventDispatcher
        @type Ember.EventDispatcher
        @default null
      */
      eventDispatcher: null,

      /**
        The DOM events for which the event dispatcher should listen.

        By default, the application's `Ember.EventDispatcher` listens
        for a set of standard DOM events, such as `mousedown` and
        `keyup`, and delegates them to your application's `Ember.View`
        instances.

        If you would like additional bubbling events to be delegated to your
        views, set your `Ember.Application`'s `customEvents` property
        to a hash containing the DOM event name as the key and the
        corresponding view method name as the value. For example:

        ```javascript
        App = Ember.Application.create({
          customEvents: {
            // add support for the paste event
            paste: "paste"
          }
        });
        ```

        @property customEvents
        @type Object
        @default null
      */
      customEvents: null,

      // Start off the number of deferrals at 1. This will be
      // decremented by the Application's own `initialize` method.
      _readinessDeferrals: 1,

      init: function() {
        if (!this.$) { this.$ = jQuery; }
        this.__container__ = this.buildContainer();

        this.Router = this.defaultRouter();

        this._super();

        this.scheduleInitialize();

        Ember.libraries.registerCoreLibrary('Handlebars' + (EmberHandlebars.compile ? '' : '-runtime'), EmberHandlebars.VERSION);
        Ember.libraries.registerCoreLibrary('jQuery', jQuery().jquery);

        if ( Ember.LOG_VERSION ) {
          Ember.LOG_VERSION = false; // we only need to see this once per Application#init

          var nameLengths = EnumerableUtils.map(Ember.libraries, function(item) {
            return get(item, "name.length");
          });

          var maxNameLength = Math.max.apply(this, nameLengths);

          Ember.debug('-------------------------------');
          Ember.libraries.each(function(name, version) {
            var spaces = new Array(maxNameLength - name.length + 1).join(" ");
            Ember.debug([name, spaces, ' : ', version].join(""));
          });
          Ember.debug('-------------------------------');
        }
      },

      /**
        Build the container for the current application.

        Also register a default application view in case the application
        itself does not.

        @private
        @method buildContainer
        @return {Ember.Container} the configured container
      */
      buildContainer: function() {
        var container = this.__container__ = Application.buildContainer(this);

        return container;
      },

      /**
        If the application has not opted out of routing and has not explicitly
        defined a router, supply a default router for the application author
        to configure.

        This allows application developers to do:

        ```javascript
        var App = Ember.Application.create();

        App.Router.map(function() {
          this.resource('posts');
        });
        ```

        @private
        @method defaultRouter
        @return {Ember.Router} the default router
      */

      defaultRouter: function() {
        if (this.Router === false) { return; }
        var container = this.__container__;

        if (this.Router) {
          container.unregister('router:main');
          container.register('router:main', this.Router);
        }

        return container.lookupFactory('router:main');
      },

      /**
        Automatically initialize the application once the DOM has
        become ready.

        The initialization itself is scheduled on the actions queue
        which ensures that application loading finishes before
        booting.

        If you are asynchronously loading code, you should call
        `deferReadiness()` to defer booting, and then call
        `advanceReadiness()` once all of your code has finished
        loading.

        @private
        @method scheduleInitialize
      */
      scheduleInitialize: function() {
        var self = this;

        if (!this.$ || this.$.isReady) {
          run.schedule('actions', self, '_initialize');
        } else {
          this.$().ready(function runInitialize() {
            run(self, '_initialize');
          });
        }
      },

      /**
        Use this to defer readiness until some condition is true.

        Example:

        ```javascript
        App = Ember.Application.create();
        App.deferReadiness();

        jQuery.getJSON("/auth-token", function(token) {
          App.token = token;
          App.advanceReadiness();
        });
        ```

        This allows you to perform asynchronous setup logic and defer
        booting your application until the setup has finished.

        However, if the setup requires a loading UI, it might be better
        to use the router for this purpose.

        @method deferReadiness
      */
      deferReadiness: function() {
        Ember.assert("You must call deferReadiness on an instance of Ember.Application", this instanceof Application);
        Ember.assert("You cannot defer readiness since the `ready()` hook has already been called.", this._readinessDeferrals > 0);
        this._readinessDeferrals++;
      },

      /**
        Call `advanceReadiness` after any asynchronous setup logic has completed.
        Each call to `deferReadiness` must be matched by a call to `advanceReadiness`
        or the application will never become ready and routing will not begin.

        @method advanceReadiness
        @see {Ember.Application#deferReadiness}
      */
      advanceReadiness: function() {
        Ember.assert("You must call advanceReadiness on an instance of Ember.Application", this instanceof Application);
        this._readinessDeferrals--;

        if (this._readinessDeferrals === 0) {
          run.once(this, this.didBecomeReady);
        }
      },

      /**
        Registers a factory that can be used for dependency injection (with
        `App.inject`) or for service lookup. Each factory is registered with
        a full name including two parts: `type:name`.

        A simple example:

        ```javascript
        var App = Ember.Application.create();
        App.Orange  = Ember.Object.extend();
        App.register('fruit:favorite', App.Orange);
        ```

        Ember will resolve factories from the `App` namespace automatically.
        For example `App.CarsController` will be discovered and returned if
        an application requests `controller:cars`.

        An example of registering a controller with a non-standard name:

        ```javascript
        var App = Ember.Application.create(),
            Session  = Ember.Controller.extend();

        App.register('controller:session', Session);

        // The Session controller can now be treated like a normal controller,
        // despite its non-standard name.
        App.ApplicationController = Ember.Controller.extend({
          needs: ['session']
        });
        ```

        Registered factories are **instantiated** by having `create`
        called on them. Additionally they are **singletons**, each time
        they are looked up they return the same instance.

        Some examples modifying that default behavior:

        ```javascript
        var App = Ember.Application.create();

        App.Person  = Ember.Object.extend();
        App.Orange  = Ember.Object.extend();
        App.Email   = Ember.Object.extend();
        App.session = Ember.Object.create();

        App.register('model:user', App.Person, {singleton: false });
        App.register('fruit:favorite', App.Orange);
        App.register('communication:main', App.Email, {singleton: false});
        App.register('session', App.session, {instantiate: false});
        ```

        @method register
        @param  fullName {String} type:name (e.g., 'model:user')
        @param  factory {Function} (e.g., App.Person)
        @param  options {Object} (optional) disable instantiation or singleton usage
      **/
      register: function() {
        var container = this.__container__;
        container.register.apply(container, arguments);
      },

      /**
        Define a dependency injection onto a specific factory or all factories
        of a type.

        When Ember instantiates a controller, view, or other framework component
        it can attach a dependency to that component. This is often used to
        provide services to a set of framework components.

        An example of providing a session object to all controllers:

        ```javascript
        var App = Ember.Application.create(),
            Session = Ember.Object.extend({ isAuthenticated: false });

        // A factory must be registered before it can be injected
        App.register('session:main', Session);

        // Inject 'session:main' onto all factories of the type 'controller'
        // with the name 'session'
        App.inject('controller', 'session', 'session:main');

        App.IndexController = Ember.Controller.extend({
          isLoggedIn: Ember.computed.alias('session.isAuthenticated')
        });
        ```

        Injections can also be performed on specific factories.

        ```javascript
        App.inject(<full_name or type>, <property name>, <full_name>)
        App.inject('route', 'source', 'source:main')
        App.inject('route:application', 'email', 'model:email')
        ```

        It is important to note that injections can only be performed on
        classes that are instantiated by Ember itself. Instantiating a class
        directly (via `create` or `new`) bypasses the dependency injection
        system.

        Ember-Data instantiates its models in a unique manner, and consequently
        injections onto models (or all models) will not work as expected. Injections
        on models can be enabled by setting `Ember.MODEL_FACTORY_INJECTIONS`
        to `true`.

        @method inject
        @param  factoryNameOrType {String}
        @param  property {String}
        @param  injectionName {String}
      **/
      inject: function() {
        var container = this.__container__;
        container.injection.apply(container, arguments);
      },

      /**
        Calling initialize manually is not supported.

        Please see Ember.Application#advanceReadiness and
        Ember.Application#deferReadiness.

        @private
        @deprecated
        @method initialize
       **/
      initialize: function() {
        Ember.deprecate('Calling initialize manually is not supported. Please see Ember.Application#advanceReadiness and Ember.Application#deferReadiness');
      },

      /**
        Initialize the application. This happens automatically.

        Run any initializers and run the application load hook. These hooks may
        choose to defer readiness. For example, an authentication hook might want
        to defer readiness until the auth token has been retrieved.

        @private
        @method _initialize
      */
      _initialize: function() {
        if (this.isDestroyed) { return; }

        // At this point, the App.Router must already be assigned
        if (this.Router) {
          var container = this.__container__;
          container.unregister('router:main');
          container.register('router:main', this.Router);
        }

        this.runInitializers();
        runLoadHooks('application', this);

        // At this point, any initializers or load hooks that would have wanted
        // to defer readiness have fired. In general, advancing readiness here
        // will proceed to didBecomeReady.
        this.advanceReadiness();

        return this;
      },

      /**
        Reset the application. This is typically used only in tests. It cleans up
        the application in the following order:

        1. Deactivate existing routes
        2. Destroy all objects in the container
        3. Create a new application container
        4. Re-route to the existing url

        Typical Example:

        ```javascript

        var App;

        run(function() {
          App = Ember.Application.create();
        });

        module("acceptance test", {
          setup: function() {
            App.reset();
          }
        });

        test("first test", function() {
          // App is freshly reset
        });

        test("first test", function() {
          // App is again freshly reset
        });
        ```

        Advanced Example:

        Occasionally you may want to prevent the app from initializing during
        setup. This could enable extra configuration, or enable asserting prior
        to the app becoming ready.

        ```javascript

        var App;

        run(function() {
          App = Ember.Application.create();
        });

        module("acceptance test", {
          setup: function() {
            run(function() {
              App.reset();
              App.deferReadiness();
            });
          }
        });

        test("first test", function() {
          ok(true, 'something before app is initialized');

          run(function() {
            App.advanceReadiness();
          });
          ok(true, 'something after app is initialized');
        });
        ```

        @method reset
      **/
      reset: function() {
        this._readinessDeferrals = 1;

        function handleReset() {
          var router = this.__container__.lookup('router:main');
          router.reset();

          run(this.__container__, 'destroy');

          this.buildContainer();

          run.schedule('actions', this, function() {
            this._initialize();
          });
        }

        run.join(this, handleReset);
      },

      /**
        @private
        @method runInitializers
      */
      runInitializers: function() {
        var initializersByName = get(this.constructor, 'initializers');
        var initializers = props(initializersByName);
        var container = this.__container__;
        var graph = new DAG();
        var namespace = this;
        var name, initializer;

        for (var i = 0; i < initializers.length; i++) {
          initializer = initializersByName[initializers[i]];
          graph.addEdges(initializer.name, initializer.initialize, initializer.before, initializer.after);
        }

        graph.topsort(function (vertex) {
          var initializer = vertex.value;
          Ember.assert("No application initializer named '" + vertex.name + "'", initializer);
          initializer(container, namespace);
        });
      },

      /**
        @private
        @method didBecomeReady
      */
      didBecomeReady: function() {
        this.setupEventDispatcher();
        this.ready(); // user hook
        this.startRouting();

        if (!Ember.testing) {
          // Eagerly name all classes that are already loaded
          Ember.Namespace.processAll();
          Ember.BOOTED = true;
        }

        this.resolve(this);
      },

      /**
        Setup up the event dispatcher to receive events on the
        application's `rootElement` with any registered
        `customEvents`.

        @private
        @method setupEventDispatcher
      */
      setupEventDispatcher: function() {
        var customEvents = get(this, 'customEvents');
        var rootElement = get(this, 'rootElement');
        var dispatcher = this.__container__.lookup('event_dispatcher:main');

        set(this, 'eventDispatcher', dispatcher);
        dispatcher.setup(customEvents, rootElement);
      },

      /**
        If the application has a router, use it to route to the current URL, and
        trigger a new call to `route` whenever the URL changes.

        @private
        @method startRouting
        @property router {Ember.Router}
      */
      startRouting: function() {
        var router = this.__container__.lookup('router:main');
        if (!router) { return; }

        router.startRouting();
      },

      handleURL: function(url) {
        var router = this.__container__.lookup('router:main');

        router.handleURL(url);
      },

      /**
        Called when the Application has become ready.
        The call will be delayed until the DOM has become ready.

        @event ready
      */
      ready: K,

      /**
        @deprecated Use 'Resolver' instead
        Set this to provide an alternate class to `Ember.DefaultResolver`


        @property resolver
      */
      resolver: null,

      /**
        Set this to provide an alternate class to `Ember.DefaultResolver`

        @property resolver
      */
      Resolver: null,

      willDestroy: function() {
        Ember.BOOTED = false;
        // Ensure deactivation of routes before objects are destroyed
        this.__container__.lookup('router:main').reset();

        this.__container__.destroy();
      },

      initializer: function(options) {
        this.constructor.initializer(options);
      },

      /**
        @method then
        @private
        @deprecated
      */
      then: function() {
        Ember.deprecate('Do not use `.then` on an instance of Ember.Application.  Please use the `.ready` hook instead.');

        this._super.apply(this, arguments);
      }
    });

    Application.reopenClass({
      initializers: create(null),

      /**
        Initializer receives an object which has the following attributes:
        `name`, `before`, `after`, `initialize`. The only required attribute is
        `initialize, all others are optional.

        * `name` allows you to specify under which name the initializer is registered.
        This must be a unique name, as trying to register two initializers with the
        same name will result in an error.

        ```javascript
        Ember.Application.initializer({
          name: 'namedInitializer',
          initialize: function(container, application) {
            Ember.debug("Running namedInitializer!");
          }
        });
        ```

        * `before` and `after` are used to ensure that this initializer is ran prior
        or after the one identified by the value. This value can be a single string
        or an array of strings, referencing the `name` of other initializers.

        An example of ordering initializers, we create an initializer named `first`:

        ```javascript
        Ember.Application.initializer({
          name: 'first',
          initialize: function(container, application) {
            Ember.debug("First initializer!");
          }
        });

        // DEBUG: First initializer!
        ```

        We add another initializer named `second`, specifying that it should run
        after the initializer named `first`:

        ```javascript
        Ember.Application.initializer({
          name: 'second',
          after: 'first',

          initialize: function(container, application) {
            Ember.debug("Second initializer!");
          }
        });

        // DEBUG: First initializer!
        // DEBUG: Second initializer!
        ```

        Afterwards we add a further initializer named `pre`, this time specifying
        that it should run before the initializer named `first`:

        ```javascript
        Ember.Application.initializer({
          name: 'pre',
          before: 'first',

          initialize: function(container, application) {
            Ember.debug("Pre initializer!");
          }
        });

        // DEBUG: Pre initializer!
        // DEBUG: First initializer!
        // DEBUG: Second initializer!
        ```

        Finally we add an initializer named `post`, specifying it should run after
        both the `first` and the `second` initializers:

        ```javascript
        Ember.Application.initializer({
          name: 'post',
          after: ['first', 'second'],

          initialize: function(container, application) {
            Ember.debug("Post initializer!");
          }
        });

        // DEBUG: Pre initializer!
        // DEBUG: First initializer!
        // DEBUG: Second initializer!
        // DEBUG: Post initializer!
        ```

        * `initialize` is a callback function that receives two arguments, `container`
        and `application` on which you can operate.

        Example of using `container` to preload data into the store:

        ```javascript
        Ember.Application.initializer({
          name: "preload-data",

          initialize: function(container, application) {
            var store = container.lookup('store:main');
            store.pushPayload(preloadedData);
          }
        });
        ```

        Example of using `application` to register an adapter:

        ```javascript
        Ember.Application.initializer({
          name: 'api-adapter',

          initialize: function(container, application) {
            application.register('api-adapter:main', ApiAdapter);
          }
        });
        ```

        @method initializer
        @param initializer {Object}
       */
      initializer: function(initializer) {
        // If this is the first initializer being added to a subclass, we are going to reopen the class
        // to make sure we have a new `initializers` object, which extends from the parent class' using
        // prototypal inheritance. Without this, attempting to add initializers to the subclass would
        // pollute the parent class as well as other subclasses.
        if (this.superclass.initializers !== undefined && this.superclass.initializers === this.initializers) {
          this.reopenClass({
            initializers: create(this.initializers)
          });
        }

        Ember.assert("The initializer '" + initializer.name + "' has already been registered", !this.initializers[initializer.name]);
        Ember.assert("An initializer cannot be registered without an initialize function", canInvoke(initializer, 'initialize'));

        this.initializers[initializer.name] = initializer;
      },

      /**
        This creates a container with the default Ember naming conventions.

        It also configures the container:

        * registered views are created every time they are looked up (they are
          not singletons)
        * registered templates are not factories; the registered value is
          returned directly.
        * the router receives the application as its `namespace` property
        * all controllers receive the router as their `target` and `controllers`
          properties
        * all controllers receive the application as their `namespace` property
        * the application view receives the application controller as its
          `controller` property
        * the application view receives the application template as its
          `defaultTemplate` property

        @private
        @method buildContainer
        @static
        @param {Ember.Application} namespace the application to build the
          container for.
        @return {Ember.Container} the built container
      */
      buildContainer: function(namespace) {
        var container = new Container();

        container.set = set;
        container.resolver = resolverFor(namespace);
        container.normalizeFullName = container.resolver.normalize;
        container.describe = container.resolver.describe;
        container.makeToString = container.resolver.makeToString;

        container.optionsForType('component', { singleton: false });
        container.optionsForType('view', { singleton: false });
        container.optionsForType('template', { instantiate: false });
        container.optionsForType('helper', { instantiate: false });

        container.register('application:main', namespace, { instantiate: false });

        container.register('controller:basic', Controller, { instantiate: false });
        container.register('controller:object', ObjectController, { instantiate: false });
        container.register('controller:array', ArrayController, { instantiate: false });

        container.register('view:select', SelectView);

        container.register('route:basic', Route, { instantiate: false });
        container.register('event_dispatcher:main', EventDispatcher);

        container.register('router:main',  Router);
        container.injection('router:main', 'namespace', 'application:main');

        container.register('location:auto', AutoLocation);
        container.register('location:hash', HashLocation);
        container.register('location:history', HistoryLocation);
        container.register('location:none', NoneLocation);

        container.injection('controller', 'target', 'router:main');
        container.injection('controller', 'namespace', 'application:main');

        container.register('-bucket-cache:main', BucketCache);
        container.injection('router', '_bucketCache', '-bucket-cache:main');
        container.injection('route',  '_bucketCache', '-bucket-cache:main');
        container.injection('controller',  '_bucketCache', '-bucket-cache:main');

        container.injection('route', 'router', 'router:main');
        container.injection('location', 'rootURL', '-location-setting:root-url');

        // DEBUGGING
        container.register('resolver-for-debugging:main', container.resolver.__resolver__, { instantiate: false });
        container.injection('container-debug-adapter:main', 'resolver', 'resolver-for-debugging:main');
        container.injection('data-adapter:main', 'containerDebugAdapter', 'container-debug-adapter:main');
        // Custom resolver authors may want to register their own ContainerDebugAdapter with this key

        // ES6TODO: resolve this via import once ember-application package is ES6'ed
        if (!ContainerDebugAdapter) { ContainerDebugAdapter = requireModule('ember-extension-support/container_debug_adapter')['default']; }
        container.register('container-debug-adapter:main', ContainerDebugAdapter);

        return container;
      }
    });

    /**
      This function defines the default lookup rules for container lookups:

      * templates are looked up on `Ember.TEMPLATES`
      * other names are looked up on the application after classifying the name.
        For example, `controller:post` looks up `App.PostController` by default.
      * if the default lookup fails, look for registered classes on the container

      This allows the application to register default injections in the container
      that could be overridden by the normal naming convention.

      @private
      @method resolverFor
      @param {Ember.Namespace} namespace the namespace to look for classes
      @return {*} the resolved value for a given lookup
    */
    function resolverFor(namespace) {
      if (namespace.get('resolver')) {
        Ember.deprecate('Application.resolver is deprecated in favor of Application.Resolver', false);
      }

      var ResolverClass = namespace.get('resolver') || namespace.get('Resolver') || DefaultResolver;
      var resolver = ResolverClass.create({
        namespace: namespace
      });

      function resolve(fullName) {
        return resolver.resolve(fullName);
      }

      resolve.describe = function(fullName) {
        return resolver.lookupDescription(fullName);
      };

      resolve.makeToString = function(factory, fullName) {
        return resolver.makeToString(factory, fullName);
      };

      resolve.normalize = function(fullName) {
        if (resolver.normalize) {
          return resolver.normalize(fullName);
        } else {
          Ember.deprecate('The Resolver should now provide a \'normalize\' function', false);
          return fullName;
        }
      };

      resolve.__resolver__ = resolver;

      return resolve;
    }

    __exports__["default"] = Application;
  });
enifed("ember-application/system/dag",
  ["ember-metal/error","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var EmberError = __dependency1__["default"];

    function visit(vertex, fn, visited, path) {
      var name = vertex.name;
      var vertices = vertex.incoming;
      var names = vertex.incomingNames;
      var len = names.length;
      var i;

      if (!visited) {
        visited = {};
      }
      if (!path) {
        path = [];
      }
      if (visited.hasOwnProperty(name)) {
        return;
      }
      path.push(name);
      visited[name] = true;
      for (i = 0; i < len; i++) {
        visit(vertices[names[i]], fn, visited, path);
      }
      fn(vertex, path);
      path.pop();
    }


    /**
     * DAG stands for Directed acyclic graph.
     *
     * It is used to build a graph of dependencies checking that there isn't circular
     * dependencies. p.e Registering initializers with a certain precedence order.
     *
     * @class DAG
     * @constructor
     */
    function DAG() {
      this.names = [];
      this.vertices = Object.create(null);
    }

    /**
     * DAG Vertex
     *
     * @class Vertex
     * @constructor
     */

    function Vertex(name) {
      this.name = name;
      this.incoming = {};
      this.incomingNames = [];
      this.hasOutgoing = false;
      this.value = null;
    }

    /**
     * Adds a vertex entry to the graph unless it is already added.
     *
     * @private
     * @method add
     * @param {String} name The name of the vertex to add
     */
    DAG.prototype.add = function(name) {
      if (!name) {
        throw new Error("Can't add Vertex without name");
      }
      if (this.vertices[name] !== undefined) {
        return this.vertices[name];
      }
      var vertex = new Vertex(name);
      this.vertices[name] = vertex;
      this.names.push(name);
      return vertex;
    };

    /**
     * Adds a vertex to the graph and sets its value.
     *
     * @private
     * @method map
     * @param {String} name The name of the vertex.
     * @param         value The value to put in the vertex.
     */
    DAG.prototype.map = function(name, value) {
      this.add(name).value = value;
    };

    /**
     * Connects the vertices with the given names, adding them to the graph if
     * necessary, only if this does not produce is any circular dependency.
     *
     * @private
     * @method addEdge
     * @param {String} fromName The name the vertex where the edge starts.
     * @param {String} toName The name the vertex where the edge ends.
     */
    DAG.prototype.addEdge = function(fromName, toName) {
      if (!fromName || !toName || fromName === toName) {
        return;
      }
      var from = this.add(fromName);
      var to = this.add(toName);
      if (to.incoming.hasOwnProperty(fromName)) {
        return;
      }
      function checkCycle(vertex, path) {
        if (vertex.name === toName) {
          throw new EmberError("cycle detected: " + toName + " <- " + path.join(" <- "));
        }
      }
      visit(from, checkCycle);
      from.hasOutgoing = true;
      to.incoming[fromName] = from;
      to.incomingNames.push(fromName);
    };

    /**
     * Visits all the vertex of the graph calling the given function with each one,
     * ensuring that the vertices are visited respecting their precedence.
     *
     * @method  topsort
     * @param {Function} fn The function to be invoked on each vertex.
     */
    DAG.prototype.topsort = function(fn) {
      var visited = {};
      var vertices = this.vertices;
      var names = this.names;
      var len = names.length;
      var i, vertex;

      for (i = 0; i < len; i++) {
        vertex = vertices[names[i]];
        if (!vertex.hasOutgoing) {
          visit(vertex, fn, visited);
        }
      }
    };

    /**
     * Adds a vertex with the given name and value to the graph and joins it with the
     * vertices referenced in _before_ and _after_. If there isn't vertices with those
     * names, they are added too.
     *
     * If either _before_ or _after_ are falsy/empty, the added vertex will not have
     * an incoming/outgoing edge.
     *
     * @method addEdges
     * @param {String} name The name of the vertex to be added.
     * @param         value The value of that vertex.
     * @param        before An string or array of strings with the names of the vertices before
     *                      which this vertex must be visited.
     * @param         after An string or array of strings with the names of the vertex after
     *                      which this vertex must be visited.
     *
     */
    DAG.prototype.addEdges = function(name, value, before, after) {
      var i;
      this.map(name, value);
      if (before) {
        if (typeof before === 'string') {
          this.addEdge(name, before);
        } else {
          for (i = 0; i < before.length; i++) {
            this.addEdge(name, before[i]);
          }
        }
      }
      if (after) {
        if (typeof after === 'string') {
          this.addEdge(after, name);
        } else {
          for (i = 0; i < after.length; i++) {
            this.addEdge(after[i], name);
          }
        }
      }
    };

    __exports__["default"] = DAG;
  });
enifed("ember-application/system/resolver",
  ["ember-metal/core","ember-metal/property_get","ember-metal/logger","ember-runtime/system/string","ember-runtime/system/object","ember-runtime/system/namespace","ember-handlebars","ember-metal/dictionary","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __exports__) {
    "use strict";
    /**
    @module ember
    @submodule ember-application
    */

    var Ember = __dependency1__["default"];
    // Ember.TEMPLATES, Ember.assert
    var get = __dependency2__.get;
    var Logger = __dependency3__["default"];
    var classify = __dependency4__.classify;
    var capitalize = __dependency4__.capitalize;
    var decamelize = __dependency4__.decamelize;
    var EmberObject = __dependency5__["default"];
    var Namespace = __dependency6__["default"];
    var EmberHandlebars = __dependency7__["default"];

    var Resolver = EmberObject.extend({
      /**
        This will be set to the Application instance when it is
        created.

        @property namespace
      */
      namespace: null,
      normalize:         Ember.required(Function),
      resolve:           Ember.required(Function),
      parseName:         Ember.required(Function),
      lookupDescription: Ember.required(Function),
      makeToString:      Ember.required(Function),
      resolveOther:      Ember.required(Function),
      _logLookup:        Ember.required(Function)
    });
    __exports__.Resolver = Resolver;
    /**
      The DefaultResolver defines the default lookup rules to resolve
      container lookups before consulting the container for registered
      items:

      * templates are looked up on `Ember.TEMPLATES`
      * other names are looked up on the application after converting
        the name. For example, `controller:post` looks up
        `App.PostController` by default.
      * there are some nuances (see examples below)

      ### How Resolving Works

      The container calls this object's `resolve` method with the
      `fullName` argument.

      It first parses the fullName into an object using `parseName`.

      Then it checks for the presence of a type-specific instance
      method of the form `resolve[Type]` and calls it if it exists.
      For example if it was resolving 'template:post', it would call
      the `resolveTemplate` method.

      Its last resort is to call the `resolveOther` method.

      The methods of this object are designed to be easy to override
      in a subclass. For example, you could enhance how a template
      is resolved like so:

      ```javascript
      App = Ember.Application.create({
        Resolver: Ember.DefaultResolver.extend({
          resolveTemplate: function(parsedName) {
            var resolvedTemplate = this._super(parsedName);
            if (resolvedTemplate) { return resolvedTemplate; }
            return Ember.TEMPLATES['not_found'];
          }
        })
      });
      ```

      Some examples of how names are resolved:

      ```
      'template:post' //=> Ember.TEMPLATES['post']
      'template:posts/byline' //=> Ember.TEMPLATES['posts/byline']
      'template:posts.byline' //=> Ember.TEMPLATES['posts/byline']
      'template:blogPost' //=> Ember.TEMPLATES['blogPost']
                          //   OR
                          //   Ember.TEMPLATES['blog_post']
      'controller:post' //=> App.PostController
      'controller:posts.index' //=> App.PostsIndexController
      'controller:blog/post' //=> Blog.PostController
      'controller:basic' //=> Ember.Controller
      'route:post' //=> App.PostRoute
      'route:posts.index' //=> App.PostsIndexRoute
      'route:blog/post' //=> Blog.PostRoute
      'route:basic' //=> Ember.Route
      'view:post' //=> App.PostView
      'view:posts.index' //=> App.PostsIndexView
      'view:blog/post' //=> Blog.PostView
      'view:basic' //=> Ember.View
      'foo:post' //=> App.PostFoo
      'model:post' //=> App.Post
      ```

      @class DefaultResolver
      @namespace Ember
      @extends Ember.Object
    */
    var dictionary = __dependency8__["default"];

    __exports__["default"] = EmberObject.extend({
      /**
        This will be set to the Application instance when it is
        created.

        @property namespace
      */
      namespace: null,

      init: function() {
        this._parseNameCache = dictionary(null);
      },
      normalize: function(fullName) {
        var split = fullName.split(':', 2);
        var type = split[0];
        var name = split[1];

        Ember.assert("Tried to normalize a container name without a colon (:) in it. You probably tried to lookup a name that did not contain a type, a colon, and a name. A proper lookup name would be `view:post`.", split.length === 2);

        if (type !== 'template') {
          var result = name;

          if (result.indexOf('.') > -1) {
            result = result.replace(/\.(.)/g, function(m) {
              return m.charAt(1).toUpperCase();
            });
          }

          if (name.indexOf('_') > -1) {
            result = result.replace(/_(.)/g, function(m) {
              return m.charAt(1).toUpperCase();
            });
          }

          return type + ':' + result;
        } else {
          return fullName;
        }
      },


      /**
        This method is called via the container's resolver method.
        It parses the provided `fullName` and then looks up and
        returns the appropriate template or class.

        @method resolve
        @param {String} fullName the lookup string
        @return {Object} the resolved factory
      */
      resolve: function(fullName) {
        var parsedName = this.parseName(fullName);
        var resolveMethodName = parsedName.resolveMethodName;
        var resolved;

        if (!(parsedName.name && parsedName.type)) {
          throw new TypeError('Invalid fullName: `' + fullName + '`, must be of the form `type:name` ');
        }

        if (this[resolveMethodName]) {
          resolved = this[resolveMethodName](parsedName);
        }

        if (!resolved) {
          resolved = this.resolveOther(parsedName);
        }

        if (parsedName.root && parsedName.root.LOG_RESOLVER) {
          this._logLookup(resolved, parsedName);
        }

        return resolved;
      },
      /**
        Convert the string name of the form 'type:name' to
        a Javascript object with the parsed aspects of the name
        broken out.

        @protected
        @param {String} fullName the lookup string
        @method parseName
      */

      parseName: function(fullName) {
        return this._parseNameCache[fullName] || (
          this._parseNameCache[fullName] = this._parseName(fullName)
        );
      },

      _parseName: function(fullName) {
        var nameParts = fullName.split(':');
        var type = nameParts[0], fullNameWithoutType = nameParts[1];
        var name = fullNameWithoutType;
        var namespace = get(this, 'namespace');
        var root = namespace;

        if (type !== 'template' && name.indexOf('/') !== -1) {
          var parts = name.split('/');
          name = parts[parts.length - 1];
          var namespaceName = capitalize(parts.slice(0, -1).join('.'));
          root = Namespace.byName(namespaceName);

          Ember.assert('You are looking for a ' + name + ' ' + type + ' in the ' + namespaceName + ' namespace, but the namespace could not be found', root);
        }

        return {
          fullName: fullName,
          type: type,
          fullNameWithoutType: fullNameWithoutType,
          name: name,
          root: root,
          resolveMethodName: 'resolve' + classify(type)
        };
      },

      /**
        Returns a human-readable description for a fullName. Used by the
        Application namespace in assertions to describe the
        precise name of the class that Ember is looking for, rather than
        container keys.

        @protected
        @param {String} fullName the lookup string
        @method lookupDescription
      */
      lookupDescription: function(fullName) {
        var parsedName = this.parseName(fullName);

        if (parsedName.type === 'template') {
          return 'template at ' + parsedName.fullNameWithoutType.replace(/\./g, '/');
        }

        var description = parsedName.root + '.' + classify(parsedName.name);

        if (parsedName.type !== 'model') {
          description += classify(parsedName.type);
        }

        return description;
      },

      makeToString: function(factory, fullName) {
        return factory.toString();
      },
      /**
        Given a parseName object (output from `parseName`), apply
        the conventions expected by `Ember.Router`

        @protected
        @param {Object} parsedName a parseName object with the parsed
          fullName lookup string
        @method useRouterNaming
      */
      useRouterNaming: function(parsedName) {
        parsedName.name = parsedName.name.replace(/\./g, '_');
        if (parsedName.name === 'basic') {
          parsedName.name = '';
        }
      },
      /**
        Look up the template in Ember.TEMPLATES

        @protected
        @param {Object} parsedName a parseName object with the parsed
          fullName lookup string
        @method resolveTemplate
      */
      resolveTemplate: function(parsedName) {
        var templateName = parsedName.fullNameWithoutType.replace(/\./g, '/');

        if (Ember.TEMPLATES[templateName]) {
          return Ember.TEMPLATES[templateName];
        }

        templateName = decamelize(templateName);
        if (Ember.TEMPLATES[templateName]) {
          return Ember.TEMPLATES[templateName];
        }
      },

      /**
        Lookup the view using `resolveOther`

        @protected
        @param {Object} parsedName a parseName object with the parsed
          fullName lookup string
        @method resolveView
      */
      resolveView: function(parsedName) {
        this.useRouterNaming(parsedName);
        return this.resolveOther(parsedName);
      },

      /**
        Lookup the controller using `resolveOther`

        @protected
        @param {Object} parsedName a parseName object with the parsed
          fullName lookup string
        @method resolveController
      */
      resolveController: function(parsedName) {
        this.useRouterNaming(parsedName);
        return this.resolveOther(parsedName);
      },
      /**
        Lookup the route using `resolveOther`

        @protected
        @param {Object} parsedName a parseName object with the parsed
          fullName lookup string
        @method resolveRoute
      */
      resolveRoute: function(parsedName) {
        this.useRouterNaming(parsedName);
        return this.resolveOther(parsedName);
      },

      /**
        Lookup the model on the Application namespace

        @protected
        @param {Object} parsedName a parseName object with the parsed
          fullName lookup string
        @method resolveModel
      */
      resolveModel: function(parsedName) {
        var className = classify(parsedName.name);
        var factory = get(parsedName.root, className);

         if (factory) { return factory; }
      },
      /**
        Look up the specified object (from parsedName) on the appropriate
        namespace (usually on the Application)

        @protected
        @param {Object} parsedName a parseName object with the parsed
          fullName lookup string
        @method resolveHelper
      */
      resolveHelper: function(parsedName) {
        return this.resolveOther(parsedName) || EmberHandlebars.helpers[parsedName.fullNameWithoutType];
      },
      /**
        Look up the specified object (from parsedName) on the appropriate
        namespace (usually on the Application)

        @protected
        @param {Object} parsedName a parseName object with the parsed
          fullName lookup string
        @method resolveOther
      */
      resolveOther: function(parsedName) {
        var className = classify(parsedName.name) + classify(parsedName.type);
        var factory = get(parsedName.root, className);
        if (factory) { return factory; }
      },

      /**
       @method _logLookup
       @param {Boolean} found
       @param {Object} parsedName
       @private
      */
      _logLookup: function(found, parsedName) {
        var symbol, padding;

        if (found) { symbol = '[✓]'; }
        else       { symbol = '[ ]'; }

        if (parsedName.fullName.length > 60) {
          padding = '.';
        } else {
          padding = new Array(60 - parsedName.fullName.length).join('.');
        }

        Logger.info(symbol, parsedName.fullName, padding, this.lookupDescription(parsedName.fullName));
      }
    });
  });
enifed("ember-debug",
  ["ember-metal/core","ember-metal/error","ember-metal/logger"],
  function(__dependency1__, __dependency2__, __dependency3__) {
    "use strict";
    /*global __fail__*/

    var Ember = __dependency1__["default"];
    var EmberError = __dependency2__["default"];
    var Logger = __dependency3__["default"];

    /**
    Ember Debug

    @module ember
    @submodule ember-debug
    */

    /**
    @class Ember
    */

    /**
      Define an assertion that will throw an exception if the condition is not
      met. Ember build tools will remove any calls to `Ember.assert()` when
      doing a production build. Example:

      ```javascript
      // Test for truthiness
      Ember.assert('Must pass a valid object', obj);

      // Fail unconditionally
      Ember.assert('This code path should never be run');
      ```

      @method assert
      @param {String} desc A description of the assertion. This will become
        the text of the Error thrown if the assertion fails.
      @param {Boolean} test Must be truthy for the assertion to pass. If
        falsy, an exception will be thrown.
    */
    Ember.assert = function(desc, test) {
      if (!test) {
        throw new EmberError("Assertion Failed: " + desc);
      }
    };


    /**
      Display a warning with the provided message. Ember build tools will
      remove any calls to `Ember.warn()` when doing a production build.

      @method warn
      @param {String} message A warning to display.
      @param {Boolean} test An optional boolean. If falsy, the warning
        will be displayed.
    */
    Ember.warn = function(message, test) {
      if (!test) {
        Logger.warn("WARNING: "+message);
        if ('trace' in Logger) Logger.trace();
      }
    };

    /**
      Display a debug notice. Ember build tools will remove any calls to
      `Ember.debug()` when doing a production build.

      ```javascript
      Ember.debug('I\'m a debug notice!');
      ```

      @method debug
      @param {String} message A debug message to display.
    */
    Ember.debug = function(message) {
      Logger.debug("DEBUG: "+message);
    };

    /**
      Display a deprecation warning with the provided message and a stack trace
      (Chrome and Firefox only). Ember build tools will remove any calls to
      `Ember.deprecate()` when doing a production build.

      @method deprecate
      @param {String} message A description of the deprecation.
      @param {Boolean} test An optional boolean. If falsy, the deprecation
        will be displayed.
    */
    Ember.deprecate = function(message, test) {
      if (test) { return; }

      if (Ember.ENV.RAISE_ON_DEPRECATION) { throw new EmberError(message); }

      var error;

      // When using new Error, we can't do the arguments check for Chrome. Alternatives are welcome
      try { __fail__.fail(); } catch (e) { error = e; }

      if (Ember.LOG_STACKTRACE_ON_DEPRECATION && error.stack) {
        var stack;
        var stackStr = '';

        if (error['arguments']) {
          // Chrome
          stack = error.stack.replace(/^\s+at\s+/gm, '').
                              replace(/^([^\(]+?)([\n$])/gm, '{anonymous}($1)$2').
                              replace(/^Object.<anonymous>\s*\(([^\)]+)\)/gm, '{anonymous}($1)').split('\n');
          stack.shift();
        } else {
          // Firefox
          stack = error.stack.replace(/(?:\n@:0)?\s+$/m, '').
                              replace(/^\(/gm, '{anonymous}(').split('\n');
        }

        stackStr = "\n    " + stack.slice(2).join("\n    ");
        message = message + stackStr;
      }

      Logger.warn("DEPRECATION: "+message);
    };



    /**
      Alias an old, deprecated method with its new counterpart.

      Display a deprecation warning with the provided message and a stack trace
      (Chrome and Firefox only) when the assigned method is called.

      Ember build tools will not remove calls to `Ember.deprecateFunc()`, though
      no warnings will be shown in production.

      ```javascript
      Ember.oldMethod = Ember.deprecateFunc('Please use the new, updated method', Ember.newMethod);
      ```

      @method deprecateFunc
      @param {String} message A description of the deprecation.
      @param {Function} func The new function called to replace its deprecated counterpart.
      @return {Function} a new function that wrapped the original function with a deprecation warning
    */
    Ember.deprecateFunc = function(message, func) {
      return function() {
        Ember.deprecate(message);
        return func.apply(this, arguments);
      };
    };


    /**
      Run a function meant for debugging. Ember build tools will remove any calls to
      `Ember.runInDebug()` when doing a production build.

      ```javascript
      Ember.runInDebug(function() {
        Ember.Handlebars.EachView.reopen({
          didInsertElement: function() {
            console.log('I\'m happy');
          }
        });
      });
      ```

      @method runInDebug
      @param {Function} func The function to be executed.
      @since 1.5.0
    */
    Ember.runInDebug = function(func) {
      func();
    };

    // Inform the developer about the Ember Inspector if not installed.
    if (!Ember.testing) {
      var isFirefox = typeof InstallTrigger !== 'undefined';
      var isChrome = !!window.chrome && !window.opera;

      if (typeof window !== 'undefined' && (isFirefox || isChrome) && window.addEventListener) {
        window.addEventListener("load", function() {
          if (document.documentElement && document.documentElement.dataset && !document.documentElement.dataset.emberExtension) {
            var downloadURL;

            if(isChrome) {
              downloadURL = 'https://chrome.google.com/webstore/detail/ember-inspector/bmdblncegkenkacieihfhpjfppoconhi';
            } else if(isFirefox) {
              downloadURL = 'https://addons.mozilla.org/en-US/firefox/addon/ember-inspector/';
            }

            Ember.debug('For more advanced debugging, install the Ember Inspector from ' + downloadURL);
          }
        }, false);
      }
    }
  });
enifed("ember-extension-support",
  ["ember-metal/core","ember-extension-support/data_adapter","ember-extension-support/container_debug_adapter"],
  function(__dependency1__, __dependency2__, __dependency3__) {
    "use strict";
    /**
    Ember Extension Support

    @module ember
    @submodule ember-extension-support
    @requires ember-application
    */

    var Ember = __dependency1__["default"];
    var DataAdapter = __dependency2__["default"];
    var ContainerDebugAdapter = __dependency3__["default"];

    Ember.DataAdapter = DataAdapter;
    Ember.ContainerDebugAdapter = ContainerDebugAdapter;
  });
enifed("ember-extension-support/container_debug_adapter",
  ["ember-metal/core","ember-runtime/system/native_array","ember-metal/utils","ember-runtime/system/string","ember-runtime/system/namespace","ember-runtime/system/object","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    var emberA = __dependency2__.A;
    var typeOf = __dependency3__.typeOf;
    var dasherize = __dependency4__.dasherize;
    var classify = __dependency4__.classify;
    var Namespace = __dependency5__["default"];
    var EmberObject = __dependency6__["default"];

    /**
    @module ember
    @submodule ember-extension-support
    */

    /**
      The `ContainerDebugAdapter` helps the container and resolver interface
      with tools that debug Ember such as the
      [Ember Extension](https://github.com/tildeio/ember-extension)
      for Chrome and Firefox.

      This class can be extended by a custom resolver implementer
      to override some of the methods with library-specific code.

      The methods likely to be overridden are:

      * `canCatalogEntriesByType`
      * `catalogEntriesByType`

      The adapter will need to be registered
      in the application's container as `container-debug-adapter:main`

      Example:

      ```javascript
      Application.initializer({
        name: "containerDebugAdapter",

        initialize: function(container, application) {
          application.register('container-debug-adapter:main', require('app/container-debug-adapter'));
        }
      });
      ```

      @class ContainerDebugAdapter
      @namespace Ember
      @extends EmberObject
      @since 1.5.0
    */
    __exports__["default"] = EmberObject.extend({
      /**
        The container of the application being debugged.
        This property will be injected
        on creation.

        @property container
        @default null
      */
      container: null,

      /**
        The resolver instance of the application
        being debugged. This property will be injected
        on creation.

        @property resolver
        @default null
      */
      resolver: null,

      /**
        Returns true if it is possible to catalog a list of available
        classes in the resolver for a given type.

        @method canCatalogEntriesByType
        @param {String} type The type. e.g. "model", "controller", "route"
        @return {boolean} whether a list is available for this type.
      */
      canCatalogEntriesByType: function(type) {
        if (type === 'model' || type === 'template') return false;
        return true;
      },

      /**
        Returns the available classes a given type.

        @method catalogEntriesByType
        @param {String} type The type. e.g. "model", "controller", "route"
        @return {Array} An array of strings.
      */
      catalogEntriesByType: function(type) {
        var namespaces = emberA(Namespace.NAMESPACES), types = emberA(), self = this;
        var typeSuffixRegex = new RegExp(classify(type) + "$");

        namespaces.forEach(function(namespace) {
          if (namespace !== Ember) {
            for (var key in namespace) {
              if (!namespace.hasOwnProperty(key)) { continue; }
              if (typeSuffixRegex.test(key)) {
                var klass = namespace[key];
                if (typeOf(klass) === 'class') {
                  types.push(dasherize(key.replace(typeSuffixRegex, '')));
                }
              }
            }
          }
        });
        return types;
      }
    });
  });
enifed("ember-extension-support/data_adapter",
  ["ember-metal/core","ember-metal/property_get","ember-metal/run_loop","ember-runtime/system/string","ember-runtime/system/namespace","ember-runtime/system/object","ember-runtime/system/native_array","ember-application/system/application","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    var get = __dependency2__.get;
    var run = __dependency3__["default"];
    var dasherize = __dependency4__.dasherize;
    var Namespace = __dependency5__["default"];
    var EmberObject = __dependency6__["default"];
    var emberA = __dependency7__.A;
    var Application = __dependency8__["default"];

    /**
    @module ember
    @submodule ember-extension-support
    */

    /**
      The `DataAdapter` helps a data persistence library
      interface with tools that debug Ember such
      as the [Ember Extension](https://github.com/tildeio/ember-extension)
      for Chrome and Firefox.

      This class will be extended by a persistence library
      which will override some of the methods with
      library-specific code.

      The methods likely to be overridden are:

      * `getFilters`
      * `detect`
      * `columnsForType`
      * `getRecords`
      * `getRecordColumnValues`
      * `getRecordKeywords`
      * `getRecordFilterValues`
      * `getRecordColor`
      * `observeRecord`

      The adapter will need to be registered
      in the application's container as `dataAdapter:main`

      Example:

      ```javascript
      Application.initializer({
        name: "data-adapter",

        initialize: function(container, application) {
          application.register('data-adapter:main', DS.DataAdapter);
        }
      });
      ```

      @class DataAdapter
      @namespace Ember
      @extends EmberObject
    */
    __exports__["default"] = EmberObject.extend({
      init: function() {
        this._super();
        this.releaseMethods = emberA();
      },

      /**
        The container of the application being debugged.
        This property will be injected
        on creation.

        @property container
        @default null
        @since 1.3.0
      */
      container: null,


      /**
        The container-debug-adapter which is used
        to list all models.

        @property containerDebugAdapter
        @default undefined
        @since 1.5.0
      **/
      containerDebugAdapter: undefined,

      /**
        Number of attributes to send
        as columns. (Enough to make the record
        identifiable).

        @private
        @property attributeLimit
        @default 3
        @since 1.3.0
      */
      attributeLimit: 3,

      /**
        Stores all methods that clear observers.
        These methods will be called on destruction.

        @private
        @property releaseMethods
        @since 1.3.0
      */
      releaseMethods: emberA(),

      /**
        Specifies how records can be filtered.
        Records returned will need to have a `filterValues`
        property with a key for every name in the returned array.

        @public
        @method getFilters
        @return {Array} List of objects defining filters.
         The object should have a `name` and `desc` property.
      */
      getFilters: function() {
        return emberA();
      },

      /**
        Fetch the model types and observe them for changes.

        @public
        @method watchModelTypes

        @param {Function} typesAdded Callback to call to add types.
        Takes an array of objects containing wrapped types (returned from `wrapModelType`).

        @param {Function} typesUpdated Callback to call when a type has changed.
        Takes an array of objects containing wrapped types.

        @return {Function} Method to call to remove all observers
      */
      watchModelTypes: function(typesAdded, typesUpdated) {
        var modelTypes = this.getModelTypes();
        var self = this;
        var releaseMethods = emberA();
        var typesToSend;

        typesToSend = modelTypes.map(function(type) {
          var klass = type.klass;
          var wrapped = self.wrapModelType(klass, type.name);
          releaseMethods.push(self.observeModelType(klass, typesUpdated));
          return wrapped;
        });

        typesAdded(typesToSend);

        var release = function() {
          releaseMethods.forEach(function(fn) { fn(); });
          self.releaseMethods.removeObject(release);
        };
        this.releaseMethods.pushObject(release);
        return release;
      },

      _nameToClass: function(type) {
        if (typeof type === 'string') {
          type = this.container.lookupFactory('model:' + type);
        }
        return type;
      },

      /**
        Fetch the records of a given type and observe them for changes.

        @public
        @method watchRecords

        @param {Function} recordsAdded Callback to call to add records.
        Takes an array of objects containing wrapped records.
        The object should have the following properties:
          columnValues: {Object} key and value of a table cell
          object: {Object} the actual record object

        @param {Function} recordsUpdated Callback to call when a record has changed.
        Takes an array of objects containing wrapped records.

        @param {Function} recordsRemoved Callback to call when a record has removed.
        Takes the following parameters:
          index: the array index where the records were removed
          count: the number of records removed

        @return {Function} Method to call to remove all observers
      */
      watchRecords: function(type, recordsAdded, recordsUpdated, recordsRemoved) {
        var self = this, releaseMethods = emberA(), records = this.getRecords(type), release;

        var recordUpdated = function(updatedRecord) {
          recordsUpdated([updatedRecord]);
        };

        var recordsToSend = records.map(function(record) {
          releaseMethods.push(self.observeRecord(record, recordUpdated));
          return self.wrapRecord(record);
        });


        var contentDidChange = function(array, idx, removedCount, addedCount) {
          for (var i = idx; i < idx + addedCount; i++) {
            var record = array.objectAt(i);
            var wrapped = self.wrapRecord(record);
            releaseMethods.push(self.observeRecord(record, recordUpdated));
            recordsAdded([wrapped]);
          }

          if (removedCount) {
            recordsRemoved(idx, removedCount);
          }
        };

        var observer = { didChange: contentDidChange, willChange: Ember.K };
        records.addArrayObserver(self, observer);

        release = function() {
          releaseMethods.forEach(function(fn) { fn(); });
          records.removeArrayObserver(self, observer);
          self.releaseMethods.removeObject(release);
        };

        recordsAdded(recordsToSend);

        this.releaseMethods.pushObject(release);
        return release;
      },

      /**
        Clear all observers before destruction
        @private
        @method willDestroy
      */
      willDestroy: function() {
        this._super();
        this.releaseMethods.forEach(function(fn) {
          fn();
        });
      },

      /**
        Detect whether a class is a model.

        Test that against the model class
        of your persistence library

        @private
        @method detect
        @param {Class} klass The class to test
        @return boolean Whether the class is a model class or not
      */
      detect: function(klass) {
        return false;
      },

      /**
        Get the columns for a given model type.

        @private
        @method columnsForType
        @param {Class} type The model type
        @return {Array} An array of columns of the following format:
         name: {String} name of the column
         desc: {String} Humanized description (what would show in a table column name)
      */
      columnsForType: function(type) {
        return emberA();
      },

      /**
        Adds observers to a model type class.

        @private
        @method observeModelType
        @param {Class} type The model type class
        @param {Function} typesUpdated Called when a type is modified.
        @return {Function} The function to call to remove observers
      */

      observeModelType: function(type, typesUpdated) {
        var self = this;
        var records = this.getRecords(type);

        var onChange = function() {
          typesUpdated([self.wrapModelType(type)]);
        };
        var observer = {
          didChange: function() {
            run.scheduleOnce('actions', this, onChange);
          },
          willChange: Ember.K
        };

        records.addArrayObserver(this, observer);

        var release = function() {
          records.removeArrayObserver(self, observer);
        };

        return release;
      },


      /**
        Wraps a given model type and observes changes to it.

        @private
        @method wrapModelType
        @param {Class} type A model class
        @param {String}  Optional name of the class
        @return {Object} contains the wrapped type and the function to remove observers
        Format:
          type: {Object} the wrapped type
            The wrapped type has the following format:
              name: {String} name of the type
              count: {Integer} number of records available
              columns: {Columns} array of columns to describe the record
              object: {Class} the actual Model type class
          release: {Function} The function to remove observers
      */
      wrapModelType: function(type, name) {
        var records = this.getRecords(type);
        var self = this;
        var release, typeToSend;

        typeToSend = {
          name: name || type.toString(),
          count: get(records, 'length'),
          columns: this.columnsForType(type),
          object: type
        };


        return typeToSend;
      },


      /**
        Fetches all models defined in the application.

        @private
        @method getModelTypes
        @return {Array} Array of model types
      */
      getModelTypes: function() {
        var self = this;
        var containerDebugAdapter = this.get('containerDebugAdapter');
        var types;

        if (containerDebugAdapter.canCatalogEntriesByType('model')) {
          types = containerDebugAdapter.catalogEntriesByType('model');
        } else {
          types = this._getObjectsOnNamespaces();
        }

        // New adapters return strings instead of classes
        types = emberA(types).map(function(name) {
          return {
            klass: self._nameToClass(name),
            name: name
          };
        });
        types = emberA(types).filter(function(type) {
          return self.detect(type.klass);
        });

        return emberA(types);
      },

      /**
        Loops over all namespaces and all objects
        attached to them

        @private
        @method _getObjectsOnNamespaces
        @return {Array} Array of model type strings
      */
      _getObjectsOnNamespaces: function() {
        var namespaces = emberA(Namespace.NAMESPACES);
        var types = emberA();
        var self = this;

        namespaces.forEach(function(namespace) {
          for (var key in namespace) {
            if (!namespace.hasOwnProperty(key)) { continue; }
            // Even though we will filter again in `getModelTypes`,
            // we should not call `lookupContainer` on non-models
            // (especially when `Ember.MODEL_FACTORY_INJECTIONS` is `true`)
            if (!self.detect(namespace[key])) { continue; }
            var name = dasherize(key);
            if (!(namespace instanceof Application) && namespace.toString()) {
              name = namespace + '/' + name;
            }
            types.push(name);
          }
        });
        return types;
      },

      /**
        Fetches all loaded records for a given type.

        @private
        @method getRecords
        @return {Array} An array of records.
         This array will be observed for changes,
         so it should update when new records are added/removed.
      */
      getRecords: function(type) {
        return emberA();
      },

      /**
        Wraps a record and observers changes to it.

        @private
        @method wrapRecord
        @param {Object} record The record instance.
        @return {Object} The wrapped record. Format:
        columnValues: {Array}
        searchKeywords: {Array}
      */
      wrapRecord: function(record) {
        var recordToSend = { object: record };
        var columnValues = {};
        var self = this;

        recordToSend.columnValues = this.getRecordColumnValues(record);
        recordToSend.searchKeywords = this.getRecordKeywords(record);
        recordToSend.filterValues = this.getRecordFilterValues(record);
        recordToSend.color = this.getRecordColor(record);

        return recordToSend;
      },

      /**
        Gets the values for each column.

        @private
        @method getRecordColumnValues
        @return {Object} Keys should match column names defined
        by the model type.
      */
      getRecordColumnValues: function(record) {
        return {};
      },

      /**
        Returns keywords to match when searching records.

        @private
        @method getRecordKeywords
        @return {Array} Relevant keywords for search.
      */
      getRecordKeywords: function(record) {
        return emberA();
      },

      /**
        Returns the values of filters defined by `getFilters`.

        @private
        @method getRecordFilterValues
        @param {Object} record The record instance
        @return {Object} The filter values
      */
      getRecordFilterValues: function(record) {
        return {};
      },

      /**
        Each record can have a color that represents its state.

        @private
        @method getRecordColor
        @param {Object} record The record instance
        @return {String} The record's color
          Possible options: black, red, blue, green
      */
      getRecordColor: function(record) {
        return null;
      },

      /**
        Observes all relevant properties and re-sends the wrapped record
        when a change occurs.

        @private
        @method observerRecord
        @param {Object} record The record instance
        @param {Function} recordUpdated The callback to call when a record is updated.
        @return {Function} The function to call to remove all observers.
      */
      observeRecord: function(record, recordUpdated) {
        return function(){};
      }
    });
  });
enifed("ember-extension-support/initializers",
  [],
  function() {
    "use strict";

  });
enifed("ember-handlebars-compiler",
  ["ember-metal/core","exports"],
  function(__dependency1__, __exports__) {
        /* global Handlebars:true */

    // Remove "use strict"; from transpiled module (in browser builds only) until
    // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed
    //
    // REMOVE_USE_STRICT: true

    /**
    @module ember
    @submodule ember-handlebars-compiler
    */

    var Ember = __dependency1__["default"];

    // ES6Todo: you'll need to import debugger once debugger is es6'd.
    if (typeof Ember.assert === 'undefined')   { Ember.assert = function(){}; }
    if (typeof Ember.FEATURES === 'undefined') { Ember.FEATURES = { isEnabled: function(){} }; }

    var objectCreate = Object.create || function(parent) {
      function F() {}
      F.prototype = parent;
      return new F();
    };

    // set up for circular references later
    var View, Component;

    // ES6Todo: when ember-debug is es6'ed import this.
    // var emberAssert = Ember.assert;
    var Handlebars = (Ember.imports && Ember.imports.Handlebars) || (this && this.Handlebars);
    if (!Handlebars && typeof eriuqer === 'function') {
      Handlebars = eriuqer('handlebars');
    }

    Ember.assert("Ember Handlebars requires Handlebars version 1.0 or 1.1. Include " +
                 "a SCRIPT tag in the HTML HEAD linking to the Handlebars file " +
                 "before you link to Ember.", Handlebars);

    Ember.assert("Ember Handlebars requires Handlebars version 1.0 or 1.1, " +
                 "COMPILER_REVISION expected: 4, got: " +  Handlebars.COMPILER_REVISION +
                 " - Please note: Builds of master may have other COMPILER_REVISION values.",
                 Handlebars.COMPILER_REVISION === 4);

    /**
      Prepares the Handlebars templating library for use inside Ember's view
      system.

      The `Ember.Handlebars` object is the standard Handlebars library, extended to
      use Ember's `get()` method instead of direct property access, which allows
      computed properties to be used inside templates.

      To create an `Ember.Handlebars` template, call `Ember.Handlebars.compile()`.
      This will return a function that can be used by `Ember.View` for rendering.

      @class Handlebars
      @namespace Ember
    */
    var EmberHandlebars = Ember.Handlebars = objectCreate(Handlebars);

    /**
      Register a bound helper or custom view helper.

      ## Simple bound helper example

      ```javascript
      Ember.Handlebars.helper('capitalize', function(value) {
        return value.toUpperCase();
      });
      ```

      The above bound helper can be used inside of templates as follows:

      ```handlebars
      {{capitalize name}}
      ```

      In this case, when the `name` property of the template's context changes,
      the rendered value of the helper will update to reflect this change.

      For more examples of bound helpers, see documentation for
      `Ember.Handlebars.registerBoundHelper`.

      ## Custom view helper example

      Assuming a view subclass named `App.CalendarView` were defined, a helper
      for rendering instances of this view could be registered as follows:

      ```javascript
      Ember.Handlebars.helper('calendar', App.CalendarView):
      ```

      The above bound helper can be used inside of templates as follows:

      ```handlebars
      {{calendar}}
      ```

      Which is functionally equivalent to:

      ```handlebars
      {{view 'calendar'}}
      ```

      Options in the helper will be passed to the view in exactly the same
      manner as with the `view` helper.

      @method helper
      @for Ember.Handlebars
      @param {String} name
      @param {Function|Ember.View} function or view class constructor
      @param {String} dependentKeys*
    */
    EmberHandlebars.helper = function(name, value) {
      if (!View) { View = requireModule('ember-views/views/view')['default']; } // ES6TODO: stupid circular dep
      if (!Component) { Component = requireModule('ember-views/views/component')['default']; } // ES6TODO: stupid circular dep

      Ember.assert("You tried to register a component named '" + name + "', but component names must include a '-'", !Component.detect(value) || name.match(/-/));

      if (View.detect(value)) {
        EmberHandlebars.registerHelper(name, EmberHandlebars.makeViewHelper(value));
      } else {
        EmberHandlebars.registerBoundHelper.apply(null, arguments);
      }
    };

    /**
      Returns a helper function that renders the provided ViewClass.

      Used internally by Ember.Handlebars.helper and other methods
      involving helper/component registration.

      @private
      @method makeViewHelper
      @for Ember.Handlebars
      @param {Function} ViewClass view class constructor
      @since 1.2.0
    */
    EmberHandlebars.makeViewHelper = function(ViewClass) {
      return function(options) {
        Ember.assert("You can only pass attributes (such as name=value) not bare values to a helper for a View found in '" + ViewClass.toString() + "'", arguments.length < 2);
        return EmberHandlebars.helpers.view.call(this, ViewClass, options);
      };
    };

    /**
    @class helpers
    @namespace Ember.Handlebars
    */
    EmberHandlebars.helpers = objectCreate(Handlebars.helpers);

    /**
      Override the the opcode compiler and JavaScript compiler for Handlebars.

      @class Compiler
      @namespace Ember.Handlebars
      @private
      @constructor
    */
    EmberHandlebars.Compiler = function() {};

    // Handlebars.Compiler doesn't exist in runtime-only
    if (Handlebars.Compiler) {
      EmberHandlebars.Compiler.prototype = objectCreate(Handlebars.Compiler.prototype);
    }

    EmberHandlebars.Compiler.prototype.compiler = EmberHandlebars.Compiler;

    /**
      @class JavaScriptCompiler
      @namespace Ember.Handlebars
      @private
      @constructor
    */
    EmberHandlebars.JavaScriptCompiler = function() {};

    // Handlebars.JavaScriptCompiler doesn't exist in runtime-only
    if (Handlebars.JavaScriptCompiler) {
      EmberHandlebars.JavaScriptCompiler.prototype = objectCreate(Handlebars.JavaScriptCompiler.prototype);
      EmberHandlebars.JavaScriptCompiler.prototype.compiler = EmberHandlebars.JavaScriptCompiler;
    }


    EmberHandlebars.JavaScriptCompiler.prototype.namespace = "Ember.Handlebars";

    EmberHandlebars.JavaScriptCompiler.prototype.initializeBuffer = function() {
      return "''";
    };

    /**
      Override the default buffer for Ember Handlebars. By default, Handlebars
      creates an empty String at the beginning of each invocation and appends to
      it. Ember's Handlebars overrides this to append to a single shared buffer.

      @private
      @method appendToBuffer
      @param string {String}
    */
    EmberHandlebars.JavaScriptCompiler.prototype.appendToBuffer = function(string) {
      return "data.buffer.push("+string+");";
    };

    // Hacks ahead:
    // Handlebars presently has a bug where the `blockHelperMissing` hook
    // doesn't get passed the name of the missing helper name, but rather
    // gets passed the value of that missing helper evaluated on the current
    // context, which is most likely `undefined` and totally useless.
    //
    // So we alter the compiled template function to pass the name of the helper
    // instead, as expected.
    //
    // This can go away once the following is closed:
    // https://github.com/wycats/handlebars.js/issues/634

    var DOT_LOOKUP_REGEX = /helpers\.(.*?)\)/;
    var BRACKET_STRING_LOOKUP_REGEX = /helpers\['(.*?)'/;
    var INVOCATION_SPLITTING_REGEX = /(.*blockHelperMissing\.call\(.*)(stack[0-9]+)(,.*)/;

    EmberHandlebars.JavaScriptCompiler.stringifyLastBlockHelperMissingInvocation = function(source) {
      var helperInvocation = source[source.length - 1];
      var helperName = (DOT_LOOKUP_REGEX.exec(helperInvocation) || BRACKET_STRING_LOOKUP_REGEX.exec(helperInvocation))[1];
      var matches = INVOCATION_SPLITTING_REGEX.exec(helperInvocation);

      source[source.length - 1] = matches[1] + "'" + helperName + "'" + matches[3];
    };

    var stringifyBlockHelperMissing = EmberHandlebars.JavaScriptCompiler.stringifyLastBlockHelperMissingInvocation;

    var originalBlockValue = EmberHandlebars.JavaScriptCompiler.prototype.blockValue;
    EmberHandlebars.JavaScriptCompiler.prototype.blockValue = function() {
      originalBlockValue.apply(this, arguments);
      stringifyBlockHelperMissing(this.source);
    };

    var originalAmbiguousBlockValue = EmberHandlebars.JavaScriptCompiler.prototype.ambiguousBlockValue;
    EmberHandlebars.JavaScriptCompiler.prototype.ambiguousBlockValue = function() {
      originalAmbiguousBlockValue.apply(this, arguments);
      stringifyBlockHelperMissing(this.source);
    };

    /**
      Rewrite simple mustaches from `{{foo}}` to `{{bind "foo"}}`. This means that
      all simple mustaches in Ember's Handlebars will also set up an observer to
      keep the DOM up to date when the underlying property changes.

      @private
      @method mustache
      @for Ember.Handlebars.Compiler
      @param mustache
    */
    EmberHandlebars.Compiler.prototype.mustache = function(mustache) {
      if (!(mustache.params.length || mustache.hash)) {
        var id = new Handlebars.AST.IdNode([{ part: '_triageMustache' }]);

        // Update the mustache node to include a hash value indicating whether the original node
        // was escaped. This will allow us to properly escape values when the underlying value
        // changes and we need to re-render the value.
        if (!mustache.escaped) {
          mustache.hash = mustache.hash || new Handlebars.AST.HashNode([]);
          mustache.hash.pairs.push(["unescaped", new Handlebars.AST.StringNode("true")]);
        }
        mustache = new Handlebars.AST.MustacheNode([id].concat([mustache.id]), mustache.hash, !mustache.escaped);
      }

      return Handlebars.Compiler.prototype.mustache.call(this, mustache);
    };

    /**
      Used for precompilation of Ember Handlebars templates. This will not be used
      during normal app execution.

      @method precompile
      @for Ember.Handlebars
      @static
      @param {String|Object} value The template to precompile or an Handlebars AST
      @param {Boolean} asObject optional parameter, defaulting to true, of whether or not the
                                compiled template should be returned as an Object or a String
    */
    EmberHandlebars.precompile = function(value, asObject) {
      var ast = Handlebars.parse(value);

      var options = {
        knownHelpers: {
          action: true,
          unbound: true,
          'bind-attr': true,
          template: true,
          view: true,
          _triageMustache: true
        },
        data: true,
        stringParams: true
      };

      asObject = asObject === undefined ? true : asObject;

      var environment = new EmberHandlebars.Compiler().compile(ast, options);
      return new EmberHandlebars.JavaScriptCompiler().compile(environment, options, undefined, asObject);
    };

    // We don't support this for Handlebars runtime-only
    if (Handlebars.compile) {
      /**
        The entry point for Ember Handlebars. This replaces the default
        `Handlebars.compile` and turns on template-local data and String
        parameters.

        @method compile
        @for Ember.Handlebars
        @static
        @param {String} string The template to compile
        @return {Function}
      */
      EmberHandlebars.compile = function(string) {
        var ast = Handlebars.parse(string);
        var options = { data: true, stringParams: true };
        var environment = new EmberHandlebars.Compiler().compile(ast, options);
        var templateSpec = new EmberHandlebars.JavaScriptCompiler().compile(environment, options, undefined, true);

        var template = EmberHandlebars.template(templateSpec);
        template.isMethod = false; //Make sure we don't wrap templates with ._super

        return template;
      };
    }

    __exports__["default"] = EmberHandlebars;
  });
enifed("ember-handlebars",
  ["ember-handlebars-compiler","ember-metal/core","ember-runtime/system/lazy_load","ember-handlebars/loader","ember-handlebars/ext","ember-handlebars/string","ember-handlebars/helpers/shared","ember-handlebars/helpers/binding","ember-handlebars/helpers/collection","ember-handlebars/helpers/view","ember-handlebars/helpers/unbound","ember-handlebars/helpers/debug","ember-handlebars/helpers/each","ember-handlebars/helpers/template","ember-handlebars/helpers/partial","ember-handlebars/helpers/yield","ember-handlebars/helpers/loc","ember-handlebars/controls/checkbox","ember-handlebars/controls/select","ember-handlebars/controls/text_area","ember-handlebars/controls/text_field","ember-handlebars/controls/text_support","ember-handlebars/controls","ember-handlebars/component_lookup","ember-handlebars/views/handlebars_bound_view","ember-handlebars/views/metamorph_view","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __dependency11__, __dependency12__, __dependency13__, __dependency14__, __dependency15__, __dependency16__, __dependency17__, __dependency18__, __dependency19__, __dependency20__, __dependency21__, __dependency22__, __dependency23__, __dependency24__, __dependency25__, __dependency26__, __exports__) {
    "use strict";
    var EmberHandlebars = __dependency1__["default"];
    var Ember = __dependency2__["default"];
    // to add to globals

    var runLoadHooks = __dependency3__.runLoadHooks;
    var bootstrap = __dependency4__["default"];

    var normalizePath = __dependency5__.normalizePath;
    var template = __dependency5__.template;
    var makeBoundHelper = __dependency5__.makeBoundHelper;
    var registerBoundHelper = __dependency5__.registerBoundHelper;
    var resolveHash = __dependency5__.resolveHash;
    var resolveParams = __dependency5__.resolveParams;
    var getEscaped = __dependency5__.getEscaped;
    var handlebarsGet = __dependency5__.handlebarsGet;
    var evaluateUnboundHelper = __dependency5__.evaluateUnboundHelper;
    var helperMissingHelper = __dependency5__.helperMissingHelper;
    var blockHelperMissingHelper = __dependency5__.blockHelperMissingHelper;


    // side effect of extending StringUtils of htmlSafe

    var resolvePaths = __dependency7__["default"];
    var bind = __dependency8__.bind;
    var _triageMustacheHelper = __dependency8__._triageMustacheHelper;
    var resolveHelper = __dependency8__.resolveHelper;
    var bindHelper = __dependency8__.bindHelper;
    var boundIfHelper = __dependency8__.boundIfHelper;
    var unboundIfHelper = __dependency8__.unboundIfHelper;
    var withHelper = __dependency8__.withHelper;
    var ifHelper = __dependency8__.ifHelper;
    var unlessHelper = __dependency8__.unlessHelper;
    var bindAttrHelper = __dependency8__.bindAttrHelper;
    var bindAttrHelperDeprecated = __dependency8__.bindAttrHelperDeprecated;
    var bindClasses = __dependency8__.bindClasses;

    var collectionHelper = __dependency9__["default"];
    var ViewHelper = __dependency10__.ViewHelper;
    var viewHelper = __dependency10__.viewHelper;
    var unboundHelper = __dependency11__["default"];
    var logHelper = __dependency12__.logHelper;
    var debuggerHelper = __dependency12__.debuggerHelper;
    var EachView = __dependency13__.EachView;
    var GroupedEach = __dependency13__.GroupedEach;
    var eachHelper = __dependency13__.eachHelper;
    var templateHelper = __dependency14__["default"];
    var partialHelper = __dependency15__["default"];
    var yieldHelper = __dependency16__["default"];
    var locHelper = __dependency17__["default"];


    var Checkbox = __dependency18__["default"];
    var Select = __dependency19__.Select;
    var SelectOption = __dependency19__.SelectOption;
    var SelectOptgroup = __dependency19__.SelectOptgroup;
    var TextArea = __dependency20__["default"];
    var TextField = __dependency21__["default"];
    var TextSupport = __dependency22__["default"];
    var inputHelper = __dependency23__.inputHelper;
    var textareaHelper = __dependency23__.textareaHelper;


    var ComponentLookup = __dependency24__["default"];
    var _HandlebarsBoundView = __dependency25__._HandlebarsBoundView;
    var SimpleHandlebarsView = __dependency25__.SimpleHandlebarsView;
    var _wrapMap = __dependency26__._wrapMap;
    var _SimpleMetamorphView = __dependency26__._SimpleMetamorphView;
    var _MetamorphView = __dependency26__._MetamorphView;
    var _Metamorph = __dependency26__._Metamorph;


    /**
    Ember Handlebars

    @module ember
    @submodule ember-handlebars
    @requires ember-views
    */

    // Ember.Handlebars.Globals
    EmberHandlebars.bootstrap = bootstrap;
    EmberHandlebars.template = template;
    EmberHandlebars.makeBoundHelper = makeBoundHelper;
    EmberHandlebars.registerBoundHelper = registerBoundHelper;
    EmberHandlebars.resolveHash = resolveHash;
    EmberHandlebars.resolveParams = resolveParams;
    EmberHandlebars.resolveHelper = resolveHelper;
    EmberHandlebars.get = handlebarsGet;
    EmberHandlebars.getEscaped = getEscaped;
    EmberHandlebars.evaluateUnboundHelper = evaluateUnboundHelper;
    EmberHandlebars.bind = bind;
    EmberHandlebars.bindClasses = bindClasses;
    EmberHandlebars.EachView = EachView;
    EmberHandlebars.GroupedEach = GroupedEach;
    EmberHandlebars.resolvePaths = resolvePaths;
    EmberHandlebars.ViewHelper = ViewHelper;
    EmberHandlebars.normalizePath = normalizePath;


    // Ember Globals
    Ember.Handlebars = EmberHandlebars;
    Ember.ComponentLookup = ComponentLookup;
    Ember._SimpleHandlebarsView = SimpleHandlebarsView;
    Ember._HandlebarsBoundView = _HandlebarsBoundView;
    Ember._SimpleMetamorphView = _SimpleMetamorphView;
    Ember._MetamorphView = _MetamorphView;
    Ember._Metamorph = _Metamorph;
    Ember._metamorphWrapMap = _wrapMap;
    Ember.TextSupport = TextSupport;
    Ember.Checkbox = Checkbox;
    Ember.Select = Select;
    Ember.SelectOption = SelectOption;
    Ember.SelectOptgroup = SelectOptgroup;
    Ember.TextArea = TextArea;
    Ember.TextField = TextField;
    Ember.TextSupport = TextSupport;

    // register helpers
    EmberHandlebars.registerHelper('helperMissing', helperMissingHelper);
    EmberHandlebars.registerHelper('blockHelperMissing', blockHelperMissingHelper);
    EmberHandlebars.registerHelper('bind', bindHelper);
    EmberHandlebars.registerHelper('boundIf', boundIfHelper);
    EmberHandlebars.registerHelper('_triageMustache', _triageMustacheHelper);
    EmberHandlebars.registerHelper('unboundIf', unboundIfHelper);
    EmberHandlebars.registerHelper('with', withHelper);
    EmberHandlebars.registerHelper('if', ifHelper);
    EmberHandlebars.registerHelper('unless', unlessHelper);
    EmberHandlebars.registerHelper('bind-attr', bindAttrHelper);
    EmberHandlebars.registerHelper('bindAttr', bindAttrHelperDeprecated);
    EmberHandlebars.registerHelper('collection', collectionHelper);
    EmberHandlebars.registerHelper("log", logHelper);
    EmberHandlebars.registerHelper("debugger", debuggerHelper);
    EmberHandlebars.registerHelper("each", eachHelper);
    EmberHandlebars.registerHelper("loc", locHelper);
    EmberHandlebars.registerHelper("partial", partialHelper);
    EmberHandlebars.registerHelper("template", templateHelper);
    EmberHandlebars.registerHelper("yield", yieldHelper);
    EmberHandlebars.registerHelper("view", viewHelper);
    EmberHandlebars.registerHelper("unbound", unboundHelper);
    EmberHandlebars.registerHelper("input", inputHelper);
    EmberHandlebars.registerHelper("textarea", textareaHelper);

    // run load hooks
    runLoadHooks('Ember.Handlebars', EmberHandlebars);

    __exports__["default"] = EmberHandlebars;
  });
enifed("ember-handlebars/component_lookup",
  ["ember-runtime/system/object","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var EmberObject = __dependency1__["default"];

    var ComponentLookup = EmberObject.extend({
      lookupFactory: function(name, container) {

        container = container || this.container;

        var fullName = 'component:' + name;
        var templateFullName = 'template:components/' + name;
        var templateRegistered = container && container.has(templateFullName);

        if (templateRegistered) {
          container.injection(fullName, 'layout', templateFullName);
        }

        var Component = container.lookupFactory(fullName);

        // Only treat as a component if either the component
        // or a template has been registered.
        if (templateRegistered || Component) {
          if (!Component) {
            container.register(fullName, Ember.Component);
            Component = container.lookupFactory(fullName);
          }
          return Component;
        }
      }
    });

    __exports__["default"] = ComponentLookup;
  });
enifed("ember-handlebars/controls",
  ["ember-handlebars/controls/checkbox","ember-handlebars/controls/text_field","ember-handlebars/controls/text_area","ember-metal/core","ember-handlebars-compiler","ember-handlebars/ext","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __exports__) {
    "use strict";
    var Checkbox = __dependency1__["default"];
    var TextField = __dependency2__["default"];
    var TextArea = __dependency3__["default"];

    var Ember = __dependency4__["default"];
    // Ember.assert
    // var emberAssert = Ember.assert;

    var EmberHandlebars = __dependency5__["default"];
    var handlebarsGet = __dependency6__.handlebarsGet;
    var helpers = EmberHandlebars.helpers;
    /**
    @module ember
    @submodule ember-handlebars-compiler
    */

    function _resolveOption(context, options, key) {
      if (options.hashTypes[key] === "ID") {
        return handlebarsGet(context, options.hash[key], options);
      } else {
        return options.hash[key];
      }
    }

    /**

      The `{{input}}` helper inserts an HTML `<input>` tag into the template,
      with a `type` value of either `text` or `checkbox`. If no `type` is provided,
      `text` will be the default value applied. The attributes of `{{input}}`
      match those of the native HTML tag as closely as possible for these two types.

      ## Use as text field
      An `{{input}}` with no `type` or a `type` of `text` will render an HTML text input.
      The following HTML attributes can be set via the helper:

     <table>
      <tr><td>`readonly`</td><td>`required`</td><td>`autofocus`</td></tr>
      <tr><td>`value`</td><td>`placeholder`</td><td>`disabled`</td></tr>
      <tr><td>`size`</td><td>`tabindex`</td><td>`maxlength`</td></tr>
      <tr><td>`name`</td><td>`min`</td><td>`max`</td></tr>
      <tr><td>`pattern`</td><td>`accept`</td><td>`autocomplete`</td></tr>
      <tr><td>`autosave`</td><td>`formaction`</td><td>`formenctype`</td></tr>
      <tr><td>`formmethod`</td><td>`formnovalidate`</td><td>`formtarget`</td></tr>
      <tr><td>`height`</td><td>`inputmode`</td><td>`multiple`</td></tr>
      <tr><td>`step`</td><td>`width`</td><td>`form`</td></tr>
      <tr><td>`selectionDirection`</td><td>`spellcheck`</td><td>&nbsp;</td></tr>
     </table>


      When set to a quoted string, these values will be directly applied to the HTML
      element. When left unquoted, these values will be bound to a property on the
      template's current rendering context (most typically a controller instance).

      ## Unbound:

      ```handlebars
      {{input value="http://www.facebook.com"}}
      ```


      ```html
      <input type="text" value="http://www.facebook.com"/>
      ```

      ## Bound:

      ```javascript
      App.ApplicationController = Ember.Controller.extend({
        firstName: "Stanley",
        entryNotAllowed: true
      });
      ```


      ```handlebars
      {{input type="text" value=firstName disabled=entryNotAllowed size="50"}}
      ```


      ```html
      <input type="text" value="Stanley" disabled="disabled" size="50"/>
      ```

      ## Actions

      The helper can send multiple actions based on user events.

      The action property defines the action which is sent when
      the user presses the return key.

      ```handlebars
      {{input action="submit"}}
      ```

      The helper allows some user events to send actions.

    * `enter`
    * `insert-newline`
    * `escape-press`
    * `focus-in`
    * `focus-out`
    * `key-press`


      For example, if you desire an action to be sent when the input is blurred,
      you only need to setup the action name to the event name property.

      ```handlebars
      {{input focus-in="alertMessage"}}
      ```

      See more about [Text Support Actions](/api/classes/Ember.TextField.html)

      ## Extension

      Internally, `{{input type="text"}}` creates an instance of `Ember.TextField`, passing
      arguments from the helper to `Ember.TextField`'s `create` method. You can extend the
      capabilities of text inputs in your applications by reopening this class. For example,
      if you are building a Bootstrap project where `data-*` attributes are used, you
      can add one to the `TextField`'s `attributeBindings` property:


      ```javascript
      Ember.TextField.reopen({
        attributeBindings: ['data-error']
      });
      ```

      Keep in mind when writing `Ember.TextField` subclasses that `Ember.TextField`
      itself extends `Ember.Component`, meaning that it does NOT inherit
      the `controller` of the parent view.

      See more about [Ember components](/api/classes/Ember.Component.html)


      ## Use as checkbox

      An `{{input}}` with a `type` of `checkbox` will render an HTML checkbox input.
      The following HTML attributes can be set via the helper:

    * `checked`
    * `disabled`
    * `tabindex`
    * `indeterminate`
    * `name`
    * `autofocus`
    * `form`


      When set to a quoted string, these values will be directly applied to the HTML
      element. When left unquoted, these values will be bound to a property on the
      template's current rendering context (most typically a controller instance).

      ## Unbound:

      ```handlebars
      {{input type="checkbox" name="isAdmin"}}
      ```

      ```html
      <input type="checkbox" name="isAdmin" />
      ```

      ## Bound:

      ```javascript
      App.ApplicationController = Ember.Controller.extend({
        isAdmin: true
      });
      ```


      ```handlebars
      {{input type="checkbox" checked=isAdmin }}
      ```


      ```html
      <input type="checkbox" checked="checked" />
      ```

      ## Extension

      Internally, `{{input type="checkbox"}}` creates an instance of `Ember.Checkbox`, passing
      arguments from the helper to `Ember.Checkbox`'s `create` method. You can extend the
      capablilties of checkbox inputs in your applications by reopening this class. For example,
      if you wanted to add a css class to all checkboxes in your application:


      ```javascript
      Ember.Checkbox.reopen({
        classNames: ['my-app-checkbox']
      });
      ```


      @method input
      @for Ember.Handlebars.helpers
      @param {Hash} options
    */
    function inputHelper(options) {
      Ember.assert('You can only pass attributes to the `input` helper, not arguments', arguments.length < 2);

      var hash = options.hash;
      var types = options.hashTypes;
      var inputType = _resolveOption(this, options, 'type');
      var onEvent = hash.on;

      if (inputType === 'checkbox') {
        delete hash.type;
        delete types.type;

        Ember.assert("{{input type='checkbox'}} does not support setting `value=someBooleanValue`; you must use `checked=someBooleanValue` instead.", options.hashTypes.value !== 'ID');

        return helpers.view.call(this, Checkbox, options);
      } else {
        delete hash.on;

        hash.onEvent = onEvent || 'enter';
        return helpers.view.call(this, TextField, options);
      }
    }

    __exports__.inputHelper = inputHelper;/**
      `{{textarea}}` inserts a new instance of `<textarea>` tag into the template.
      The attributes of `{{textarea}}` match those of the native HTML tags as
      closely as possible.

      The following HTML attributes can be set:

        * `value`
        * `name`
        * `rows`
        * `cols`
        * `placeholder`
        * `disabled`
        * `maxlength`
        * `tabindex`
        * `selectionEnd`
        * `selectionStart`
        * `selectionDirection`
        * `wrap`
        * `readonly`
        * `autofocus`
        * `form`
        * `spellcheck`
        * `required`

      When set to a quoted string, these value will be directly applied to the HTML
      element. When left unquoted, these values will be bound to a property on the
      template's current rendering context (most typically a controller instance).

      Unbound:

      ```handlebars
      {{textarea value="Lots of static text that ISN'T bound"}}
      ```

      Would result in the following HTML:

      ```html
      <textarea class="ember-text-area">
        Lots of static text that ISN'T bound
      </textarea>
      ```

      Bound:

      In the following example, the `writtenWords` property on `App.ApplicationController`
      will be updated live as the user types 'Lots of text that IS bound' into
      the text area of their browser's window.

      ```javascript
      App.ApplicationController = Ember.Controller.extend({
        writtenWords: "Lots of text that IS bound"
      });
      ```

      ```handlebars
      {{textarea value=writtenWords}}
      ```

       Would result in the following HTML:

      ```html
      <textarea class="ember-text-area">
        Lots of text that IS bound
      </textarea>
      ```

      If you wanted a one way binding between the text area and a div tag
      somewhere else on your screen, you could use `Ember.computed.oneWay`:

      ```javascript
      App.ApplicationController = Ember.Controller.extend({
        writtenWords: "Lots of text that IS bound",
        outputWrittenWords: Ember.computed.oneWay("writtenWords")
      });
      ```

      ```handlebars
      {{textarea value=writtenWords}}

      <div>
        {{outputWrittenWords}}
      </div>
      ```

      Would result in the following HTML:

      ```html
      <textarea class="ember-text-area">
        Lots of text that IS bound
      </textarea>

      <-- the following div will be updated in real time as you type -->

      <div>
        Lots of text that IS bound
      </div>
      ```

      Finally, this example really shows the power and ease of Ember when two
      properties are bound to eachother via `Ember.computed.alias`. Type into
      either text area box and they'll both stay in sync. Note that
      `Ember.computed.alias` costs more in terms of performance, so only use it when
      your really binding in both directions:

      ```javascript
      App.ApplicationController = Ember.Controller.extend({
        writtenWords: "Lots of text that IS bound",
        twoWayWrittenWords: Ember.computed.alias("writtenWords")
      });
      ```

      ```handlebars
      {{textarea value=writtenWords}}
      {{textarea value=twoWayWrittenWords}}
      ```

      ```html
      <textarea id="ember1" class="ember-text-area">
        Lots of text that IS bound
      </textarea>

      <-- both updated in real time -->

      <textarea id="ember2" class="ember-text-area">
        Lots of text that IS bound
      </textarea>
      ```

      ## Actions

      The helper can send multiple actions based on user events.

      The action property defines the action which is send when
      the user presses the return key.

      ```handlebars
      {{input action="submit"}}
      ```

      The helper allows some user events to send actions.

    * `enter`
    * `insert-newline`
    * `escape-press`
    * `focus-in`
    * `focus-out`
    * `key-press`

      For example, if you desire an action to be sent when the input is blurred,
      you only need to setup the action name to the event name property.

      ```handlebars
      {{textarea focus-in="alertMessage"}}
      ```

      See more about [Text Support Actions](/api/classes/Ember.TextArea.html)

      ## Extension

      Internally, `{{textarea}}` creates an instance of `Ember.TextArea`, passing
      arguments from the helper to `Ember.TextArea`'s `create` method. You can
      extend the capabilities of text areas in your application by reopening this
      class. For example, if you are building a Bootstrap project where `data-*`
      attributes are used, you can globally add support for a `data-*` attribute
      on all `{{textarea}}`s' in your app by reopening `Ember.TextArea` or
      `Ember.TextSupport` and adding it to the `attributeBindings` concatenated
      property:

      ```javascript
      Ember.TextArea.reopen({
        attributeBindings: ['data-error']
      });
      ```

      Keep in mind when writing `Ember.TextArea` subclasses that `Ember.TextArea`
      itself extends `Ember.Component`, meaning that it does NOT inherit
      the `controller` of the parent view.

      See more about [Ember components](/api/classes/Ember.Component.html)

      @method textarea
      @for Ember.Handlebars.helpers
      @param {Hash} options
    */
    function textareaHelper(options) {
      Ember.assert('You can only pass attributes to the `textarea` helper, not arguments', arguments.length < 2);

      var hash = options.hash;
      var types = options.hashTypes;

      return helpers.view.call(this, TextArea, options);
    }

    __exports__.textareaHelper = textareaHelper;
  });
enifed("ember-handlebars/controls/checkbox",
  ["ember-metal/property_get","ember-metal/property_set","ember-views/views/view","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var get = __dependency1__.get;
    var set = __dependency2__.set;
    var View = __dependency3__["default"];

    /**
    @module ember
    @submodule ember-handlebars
    */

    /**
      The internal class used to create text inputs when the `{{input}}`
      helper is used with `type` of `checkbox`.

      See [handlebars.helpers.input](/api/classes/Ember.Handlebars.helpers.html#method_input)  for usage details.

      ## Direct manipulation of `checked`

      The `checked` attribute of an `Ember.Checkbox` object should always be set
      through the Ember object or by interacting with its rendered element
      representation via the mouse, keyboard, or touch. Updating the value of the
      checkbox via jQuery will result in the checked value of the object and its
      element losing synchronization.

      ## Layout and LayoutName properties

      Because HTML `input` elements are self closing `layout` and `layoutName`
      properties will not be applied. See [Ember.View](/api/classes/Ember.View.html)'s
      layout section for more information.

      @class Checkbox
      @namespace Ember
      @extends Ember.View
    */
    __exports__["default"] = View.extend({
      instrumentDisplay: '{{input type="checkbox"}}',

      classNames: ['ember-checkbox'],

      tagName: 'input',

      attributeBindings: [
        'type',
        'checked',
        'indeterminate',
        'disabled',
        'tabindex',
        'name',
        'autofocus',
        'required',
        'form'
      ],

      type: 'checkbox',
      checked: false,
      disabled: false,
      indeterminate: false,

      init: function() {
        this._super();
        this.on('change', this, this._updateElementValue);
      },

      didInsertElement: function() {
        this._super();
        get(this, 'element').indeterminate = !!get(this, 'indeterminate');
      },

      _updateElementValue: function() {
        set(this, 'checked', this.$().prop('checked'));
      }
    });
  });
enifed("ember-handlebars/controls/select",
  ["ember-handlebars-compiler","ember-metal/enumerable_utils","ember-metal/property_get","ember-metal/property_set","ember-views/views/view","ember-views/views/collection_view","ember-metal/utils","ember-metal/is_none","ember-metal/computed","ember-runtime/system/native_array","ember-metal/mixin","ember-metal/properties","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __dependency11__, __dependency12__, __exports__) {
    "use strict";
    /**
    @module ember
    @submodule ember-handlebars
    */

    var EmberHandlebars = __dependency1__["default"];

    var forEach = __dependency2__.forEach;
    var indexOf = __dependency2__.indexOf;
    var indexesOf = __dependency2__.indexesOf;
    var replace = __dependency2__.replace;

    var get = __dependency3__.get;
    var set = __dependency4__.set;
    var View = __dependency5__["default"];
    var CollectionView = __dependency6__["default"];
    var isArray = __dependency7__.isArray;
    var isNone = __dependency8__["default"];
    var computed = __dependency9__.computed;
    var emberA = __dependency10__.A;
    var observer = __dependency11__.observer;
    var defineProperty = __dependency12__.defineProperty;

    var precompileTemplate = EmberHandlebars.compile;

    var SelectOption = View.extend({
      instrumentDisplay: 'Ember.SelectOption',

      tagName: 'option',
      attributeBindings: ['value', 'selected'],

      defaultTemplate: function(context, options) {
        options = { data: options.data, hash: {} };
        EmberHandlebars.helpers.bind.call(context, "view.label", options);
      },

      init: function() {
        this.labelPathDidChange();
        this.valuePathDidChange();

        this._super();
      },

      selected: computed(function() {
        var content = get(this, 'content');
        var selection = get(this, 'parentView.selection');
        if (get(this, 'parentView.multiple')) {
          return selection && indexOf(selection, content.valueOf()) > -1;
        } else {
          // Primitives get passed through bindings as objects... since
          // `new Number(4) !== 4`, we use `==` below
          return content == selection; // jshint ignore:line
        }
      }).property('content', 'parentView.selection'),

      labelPathDidChange: observer('parentView.optionLabelPath', function() {
        var labelPath = get(this, 'parentView.optionLabelPath');

        if (!labelPath) { return; }

        defineProperty(this, 'label', computed(function() {
          return get(this, labelPath);
        }).property(labelPath));
      }),

      valuePathDidChange: observer('parentView.optionValuePath', function() {
        var valuePath = get(this, 'parentView.optionValuePath');

        if (!valuePath) { return; }

        defineProperty(this, 'value', computed(function() {
          return get(this, valuePath);
        }).property(valuePath));
      })
    });

    var SelectOptgroup = CollectionView.extend({
      instrumentDisplay: 'Ember.SelectOptgroup',

      tagName: 'optgroup',
      attributeBindings: ['label'],

      selectionBinding: 'parentView.selection',
      multipleBinding: 'parentView.multiple',
      optionLabelPathBinding: 'parentView.optionLabelPath',
      optionValuePathBinding: 'parentView.optionValuePath',

      itemViewClassBinding: 'parentView.optionView'
    });

    /**
      The `Ember.Select` view class renders a
      [select](https://developer.mozilla.org/en/HTML/Element/select) HTML element,
      allowing the user to choose from a list of options.

      The text and `value` property of each `<option>` element within the
      `<select>` element are populated from the objects in the `Element.Select`'s
      `content` property. The underlying data object of the selected `<option>` is
      stored in the `Element.Select`'s `value` property.

      ## The Content Property (array of strings)

      The simplest version of an `Ember.Select` takes an array of strings as its
      `content` property. The string will be used as both the `value` property and
      the inner text of each `<option>` element inside the rendered `<select>`.

      Example:

      ```javascript
      App.ApplicationController = Ember.ObjectController.extend({
        names: ["Yehuda", "Tom"]
      });
      ```

      ```handlebars
      {{view "select" content=names}}
      ```

      Would result in the following HTML:

      ```html
      <select class="ember-select">
        <option value="Yehuda">Yehuda</option>
        <option value="Tom">Tom</option>
      </select>
      ```

      You can control which `<option>` is selected through the `Ember.Select`'s
      `value` property:

      ```javascript
      App.ApplicationController = Ember.ObjectController.extend({
        selectedName: 'Tom',
        names: ["Yehuda", "Tom"]
      });
      ```

      ```handlebars
      {{view "select" content=names value=selectedName}}
      ```

      Would result in the following HTML with the `<option>` for 'Tom' selected:

      ```html
      <select class="ember-select">
        <option value="Yehuda">Yehuda</option>
        <option value="Tom" selected="selected">Tom</option>
      </select>
      ```

      A user interacting with the rendered `<select>` to choose "Yehuda" would
      update the value of `selectedName` to "Yehuda".

      ## The Content Property (array of Objects)

      An `Ember.Select` can also take an array of JavaScript or Ember objects as
      its `content` property.

      When using objects you need to tell the `Ember.Select` which property should
      be accessed on each object to supply the `value` attribute of the `<option>`
      and which property should be used to supply the element text.

      The `optionValuePath` option is used to specify the path on each object to
      the desired property for the `value` attribute. The `optionLabelPath`
      specifies the path on each object to the desired property for the
      element's text. Both paths must reference each object itself as `content`:

      ```javascript
      App.ApplicationController = Ember.ObjectController.extend({
        programmers: [
          {firstName: "Yehuda", id: 1},
          {firstName: "Tom",    id: 2}
        ]
      });
      ```

      ```handlebars
      {{view "select"
             content=programmers
             optionValuePath="content.id"
             optionLabelPath="content.firstName"}}
      ```

      Would result in the following HTML:

      ```html
      <select class="ember-select">
        <option value="1">Yehuda</option>
        <option value="2">Tom</option>
      </select>
      ```

      The `value` attribute of the selected `<option>` within an `Ember.Select`
      can be bound to a property on another object:

      ```javascript
      App.ApplicationController = Ember.ObjectController.extend({
        programmers: [
          {firstName: "Yehuda", id: 1},
          {firstName: "Tom",    id: 2}
        ],
        currentProgrammer: {
          id: 2
        }
      });
      ```

      ```handlebars
      {{view "select"
             content=programmers
             optionValuePath="content.id"
             optionLabelPath="content.firstName"
             value=currentProgrammer.id}}
      ```

      Would result in the following HTML with a selected option:

      ```html
      <select class="ember-select">
        <option value="1">Yehuda</option>
        <option value="2" selected="selected">Tom</option>
      </select>
      ```

      Interacting with the rendered element by selecting the first option
      ('Yehuda') will update the `id` of `currentProgrammer`
      to match the `value` property of the newly selected `<option>`.

      Alternatively, you can control selection through the underlying objects
      used to render each object by binding the `selection` option. When the selected
      `<option>` is changed, the property path provided to `selection`
      will be updated to match the content object of the rendered `<option>`
      element:

      ```javascript

      var yehuda = {firstName: "Yehuda", id: 1, bff4eva: 'tom'}
      var tom = {firstName: "Tom", id: 2, bff4eva: 'yehuda'};

      App.ApplicationController = Ember.ObjectController.extend({
        selectedPerson: tom,
        programmers: [ yehuda, tom ]
      });
      ```

      ```handlebars
      {{view "select"
             content=programmers
             optionValuePath="content.id"
             optionLabelPath="content.firstName"
             selection=selectedPerson}}
      ```

      Would result in the following HTML with a selected option:

      ```html
      <select class="ember-select">
        <option value="1">Yehuda</option>
        <option value="2" selected="selected">Tom</option>
      </select>
      ```

      Interacting with the rendered element by selecting the first option
      ('Yehuda') will update the `selectedPerson` to match the object of
      the newly selected `<option>`. In this case it is the first object
      in the `programmers`

      ## Supplying a Prompt

      A `null` value for the `Ember.Select`'s `value` or `selection` property
      results in there being no `<option>` with a `selected` attribute:

      ```javascript
      App.ApplicationController = Ember.ObjectController.extend({
        selectedProgrammer: null,
        programmers: ["Yehuda", "Tom"]
      });
      ```

      ``` handlebars
      {{view "select"
             content=programmers
             value=selectedProgrammer
      }}
      ```

      Would result in the following HTML:

      ```html
      <select class="ember-select">
        <option value="Yehuda">Yehuda</option>
        <option value="Tom">Tom</option>
      </select>
      ```

      Although `selectedProgrammer` is `null` and no `<option>`
      has a `selected` attribute the rendered HTML will display the
      first item as though it were selected. You can supply a string
      value for the `Ember.Select` to display when there is no selection
      with the `prompt` option:

      ```javascript
      App.ApplicationController = Ember.ObjectController.extend({
        selectedProgrammer: null,
        programmers: [ "Yehuda", "Tom" ]
      });
      ```

      ```handlebars
      {{view "select"
             content=programmers
             value=selectedProgrammer
             prompt="Please select a name"
      }}
      ```

      Would result in the following HTML:

      ```html
      <select class="ember-select">
        <option>Please select a name</option>
        <option value="Yehuda">Yehuda</option>
        <option value="Tom">Tom</option>
      </select>
      ```

      @class Select
      @namespace Ember
      @extends Ember.View
    */
    var Select = View.extend({
      instrumentDisplay: 'Ember.Select',

      tagName: 'select',
      classNames: ['ember-select'],
      defaultTemplate: Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {
    this.compilerInfo = [4,'>= 1.0.0'];
    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};
      var buffer = '', stack1, escapeExpression=this.escapeExpression, self=this;

    function program1(depth0,data) {
      
      var buffer = '', stack1;
      data.buffer.push("<option value=\"\">");
      stack1 = helpers._triageMustache.call(depth0, "view.prompt", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:["ID"],data:data});
      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }
      data.buffer.push("</option>");
      return buffer;
      }

    function program3(depth0,data) {
      
      var stack1;
      stack1 = helpers.each.call(depth0, "view.groupedContent", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(4, program4, data),contexts:[depth0],types:["ID"],data:data});
      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }
      else { data.buffer.push(''); }
      }
    function program4(depth0,data) {
      
      
      data.buffer.push(escapeExpression(helpers.view.call(depth0, "view.groupView", {hash:{
        'content': ("content"),
        'label': ("label")
      },hashTypes:{'content': "ID",'label': "ID"},hashContexts:{'content': depth0,'label': depth0},contexts:[depth0],types:["ID"],data:data})));
      }

    function program6(depth0,data) {
      
      var stack1;
      stack1 = helpers.each.call(depth0, "view.content", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(7, program7, data),contexts:[depth0],types:["ID"],data:data});
      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }
      else { data.buffer.push(''); }
      }
    function program7(depth0,data) {
      
      
      data.buffer.push(escapeExpression(helpers.view.call(depth0, "view.optionView", {hash:{
        'content': ("")
      },hashTypes:{'content': "ID"},hashContexts:{'content': depth0},contexts:[depth0],types:["ID"],data:data})));
      }

      stack1 = helpers['if'].call(depth0, "view.prompt", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[depth0],types:["ID"],data:data});
      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }
      stack1 = helpers['if'].call(depth0, "view.optionGroupPath", {hash:{},hashTypes:{},hashContexts:{},inverse:self.program(6, program6, data),fn:self.program(3, program3, data),contexts:[depth0],types:["ID"],data:data});
      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }
      return buffer;
      
    }),
      attributeBindings: ['multiple', 'disabled', 'tabindex', 'name', 'required', 'autofocus',
                          'form', 'size'],

      /**
        The `multiple` attribute of the select element. Indicates whether multiple
        options can be selected.

        @property multiple
        @type Boolean
        @default false
      */
      multiple: false,

      /**
        The `disabled` attribute of the select element. Indicates whether
        the element is disabled from interactions.

        @property disabled
        @type Boolean
        @default false
      */
      disabled: false,

      /**
        The `required` attribute of the select element. Indicates whether
        a selected option is required for form validation.

        @property required
        @type Boolean
        @default false
        @since 1.5.0
      */
      required: false,

      /**
        The list of options.

        If `optionLabelPath` and `optionValuePath` are not overridden, this should
        be a list of strings, which will serve simultaneously as labels and values.

        Otherwise, this should be a list of objects. For instance:

        ```javascript
        var App = Ember.Application.create();
        var App.MySelect = Ember.Select.extend({
          content: Ember.A([
              { id: 1, firstName: 'Yehuda' },
              { id: 2, firstName: 'Tom' }
            ]),
          optionLabelPath: 'content.firstName',
          optionValuePath: 'content.id'
        });
        ```

        @property content
        @type Array
        @default null
      */
      content: null,

      /**
        When `multiple` is `false`, the element of `content` that is currently
        selected, if any.

        When `multiple` is `true`, an array of such elements.

        @property selection
        @type Object or Array
        @default null
      */
      selection: null,

      /**
        In single selection mode (when `multiple` is `false`), value can be used to
        get the current selection's value or set the selection by it's value.

        It is not currently supported in multiple selection mode.

        @property value
        @type String
        @default null
      */
      value: computed(function(key, value) {
        if (arguments.length === 2) { return value; }
        var valuePath = get(this, 'optionValuePath').replace(/^content\.?/, '');
        return valuePath ? get(this, 'selection.' + valuePath) : get(this, 'selection');
      }).property('selection'),

      /**
        If given, a top-most dummy option will be rendered to serve as a user
        prompt.

        @property prompt
        @type String
        @default null
      */
      prompt: null,

      /**
        The path of the option labels. See [content](/api/classes/Ember.Select.html#property_content).

        @property optionLabelPath
        @type String
        @default 'content'
      */
      optionLabelPath: 'content',

      /**
        The path of the option values. See [content](/api/classes/Ember.Select.html#property_content).

        @property optionValuePath
        @type String
        @default 'content'
      */
      optionValuePath: 'content',

      /**
        The path of the option group.
        When this property is used, `content` should be sorted by `optionGroupPath`.

        @property optionGroupPath
        @type String
        @default null
      */
      optionGroupPath: null,

      /**
        The view class for optgroup.

        @property groupView
        @type Ember.View
        @default Ember.SelectOptgroup
      */
      groupView: SelectOptgroup,

      groupedContent: computed(function() {
        var groupPath = get(this, 'optionGroupPath');
        var groupedContent = emberA();
        var content = get(this, 'content') || [];

        forEach(content, function(item) {
          var label = get(item, groupPath);

          if (get(groupedContent, 'lastObject.label') !== label) {
            groupedContent.pushObject({
              label: label,
              content: emberA()
            });
          }

          get(groupedContent, 'lastObject.content').push(item);
        });

        return groupedContent;
      }).property('optionGroupPath', 'content.@each'),

      /**
        The view class for option.

        @property optionView
        @type Ember.View
        @default Ember.SelectOption
      */
      optionView: SelectOption,

      _change: function() {
        if (get(this, 'multiple')) {
          this._changeMultiple();
        } else {
          this._changeSingle();
        }
      },

      selectionDidChange: observer('selection.@each', function() {
        var selection = get(this, 'selection');
        if (get(this, 'multiple')) {
          if (!isArray(selection)) {
            set(this, 'selection', emberA([selection]));
            return;
          }
          this._selectionDidChangeMultiple();
        } else {
          this._selectionDidChangeSingle();
        }
      }),

      valueDidChange: observer('value', function() {
        var content = get(this, 'content');
        var value = get(this, 'value');
        var valuePath = get(this, 'optionValuePath').replace(/^content\.?/, '');
        var selectedValue = (valuePath ? get(this, 'selection.' + valuePath) : get(this, 'selection'));
        var selection;

        if (value !== selectedValue) {
          selection = content ? content.find(function(obj) {
            return value === (valuePath ? get(obj, valuePath) : obj);
          }) : null;

          this.set('selection', selection);
        }
      }),


      _triggerChange: function() {
        var selection = get(this, 'selection');
        var value = get(this, 'value');

        if (!isNone(selection)) { this.selectionDidChange(); }
        if (!isNone(value)) { this.valueDidChange(); }

        this._change();
      },

      _changeSingle: function() {
        var selectedIndex = this.$()[0].selectedIndex;
        var content = get(this, 'content');
        var prompt = get(this, 'prompt');

        if (!content || !get(content, 'length')) { return; }
        if (prompt && selectedIndex === 0) { set(this, 'selection', null); return; }

        if (prompt) { selectedIndex -= 1; }
        set(this, 'selection', content.objectAt(selectedIndex));
      },


      _changeMultiple: function() {
        var options = this.$('option:selected');
        var prompt = get(this, 'prompt');
        var offset = prompt ? 1 : 0;
        var content = get(this, 'content');
        var selection = get(this, 'selection');

        if (!content) { return; }
        if (options) {
          var selectedIndexes = options.map(function() {
            return this.index - offset;
          }).toArray();
          var newSelection = content.objectsAt(selectedIndexes);

          if (isArray(selection)) {
            replace(selection, 0, get(selection, 'length'), newSelection);
          } else {
            set(this, 'selection', newSelection);
          }
        }
      },

      _selectionDidChangeSingle: function() {
        var el = this.get('element');
        if (!el) { return; }

        var content = get(this, 'content');
        var selection = get(this, 'selection');
        var selectionIndex = content ? indexOf(content, selection) : -1;
        var prompt = get(this, 'prompt');

        if (prompt) { selectionIndex += 1; }
        if (el) { el.selectedIndex = selectionIndex; }
      },

      _selectionDidChangeMultiple: function() {
        var content = get(this, 'content');
        var selection = get(this, 'selection');
        var selectedIndexes = content ? indexesOf(content, selection) : [-1];
        var prompt = get(this, 'prompt');
        var offset = prompt ? 1 : 0;
        var options = this.$('option');
        var adjusted;

        if (options) {
          options.each(function() {
            adjusted = this.index > -1 ? this.index - offset : -1;
            this.selected = indexOf(selectedIndexes, adjusted) > -1;
          });
        }
      },

      init: function() {
        this._super();
        this.on("didInsertElement", this, this._triggerChange);
        this.on("change", this, this._change);
      }
    });

    __exports__["default"] = Select;
    __exports__.Select = Select;
    __exports__.SelectOption = SelectOption;
    __exports__.SelectOptgroup = SelectOptgroup;
  });
enifed("ember-handlebars/controls/text_area",
  ["ember-metal/property_get","ember-views/views/component","ember-handlebars/controls/text_support","ember-metal/mixin","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";

    /**
    @module ember
    @submodule ember-handlebars
    */
    var get = __dependency1__.get;
    var Component = __dependency2__["default"];
    var TextSupport = __dependency3__["default"];
    var observer = __dependency4__.observer;

    /**
      The internal class used to create textarea element when the `{{textarea}}`
      helper is used.

      See [handlebars.helpers.textarea](/api/classes/Ember.Handlebars.helpers.html#method_textarea)  for usage details.

      ## Layout and LayoutName properties

      Because HTML `textarea` elements do not contain inner HTML the `layout` and
      `layoutName` properties will not be applied. See [Ember.View](/api/classes/Ember.View.html)'s
      layout section for more information.

      @class TextArea
      @namespace Ember
      @extends Ember.Component
      @uses Ember.TextSupport
    */
    __exports__["default"] = Component.extend(TextSupport, {
      instrumentDisplay: '{{textarea}}',

      classNames: ['ember-text-area'],

      tagName: "textarea",
      attributeBindings: ['rows', 'cols', 'name', 'selectionEnd', 'selectionStart', 'wrap', 'lang', 'dir'],
      rows: null,
      cols: null,

      _updateElementValue: observer('value', function() {
        // We do this check so cursor position doesn't get affected in IE
        var value = get(this, 'value');
        var $el = this.$();
        if ($el && value !== $el.val()) {
          $el.val(value);
        }
      }),

      init: function() {
        this._super();
        this.on("didInsertElement", this, this._updateElementValue);
      }
    });
  });
enifed("ember-handlebars/controls/text_field",
  ["ember-metal/property_get","ember-metal/property_set","ember-views/views/component","ember-handlebars/controls/text_support","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    /**
    @module ember
    @submodule ember-handlebars
    */

    var get = __dependency1__.get;
    var set = __dependency2__.set;
    var Component = __dependency3__["default"];
    var TextSupport = __dependency4__["default"];

    /**

      The internal class used to create text inputs when the `{{input}}`
      helper is used with `type` of `text`.

      See [Handlebars.helpers.input](/api/classes/Ember.Handlebars.helpers.html#method_input)  for usage details.

      ## Layout and LayoutName properties

      Because HTML `input` elements are self closing `layout` and `layoutName`
      properties will not be applied. See [Ember.View](/api/classes/Ember.View.html)'s
      layout section for more information.

      @class TextField
      @namespace Ember
      @extends Ember.Component
      @uses Ember.TextSupport
    */
    __exports__["default"] = Component.extend(TextSupport, {
      instrumentDisplay: '{{input type="text"}}',

      classNames: ['ember-text-field'],
      tagName: "input",
      attributeBindings: ['type', 'value', 'size', 'pattern', 'name', 'min', 'max',
                          'accept', 'autocomplete', 'autosave', 'formaction',
                          'formenctype', 'formmethod', 'formnovalidate', 'formtarget',
                          'height', 'inputmode', 'list', 'multiple', 'step', 'lang', 'dir',
                          'width'],

      /**
        The `value` attribute of the input element. As the user inputs text, this
        property is updated live.

        @property value
        @type String
        @default ""
      */
      value: "",

      /**
        The `type` attribute of the input element.

        @property type
        @type String
        @default "text"
      */
      type: "text",

      /**
        The `size` of the text field in characters.

        @property size
        @type String
        @default null
      */
      size: null,

      /**
        The `pattern` attribute of input element.

        @property pattern
        @type String
        @default null
      */
      pattern: null,

      /**
        The `min` attribute of input element used with `type="number"` or `type="range"`.

        @property min
        @type String
        @default null
        @since 1.4.0
      */
      min: null,

      /**
        The `max` attribute of input element used with `type="number"` or `type="range"`.

        @property max
        @type String
        @default null
        @since 1.4.0
      */
      max: null
    });
  });
enifed("ember-handlebars/controls/text_support",
  ["ember-metal/property_get","ember-metal/property_set","ember-metal/mixin","ember-runtime/mixins/target_action_support","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    /**
    @module ember
    @submodule ember-handlebars
    */

    var get = __dependency1__.get;
    var set = __dependency2__.set;
    var Mixin = __dependency3__.Mixin;
    var TargetActionSupport = __dependency4__["default"];

    /**
      Shared mixin used by `Ember.TextField` and `Ember.TextArea`.

      @class TextSupport
      @namespace Ember
      @uses Ember.TargetActionSupport
      @extends Ember.Mixin
      @private
    */
    var TextSupport = Mixin.create(TargetActionSupport, {
      value: "",

      attributeBindings: ['placeholder', 'disabled', 'maxlength', 'tabindex', 'readonly',
                          'autofocus', 'form', 'selectionDirection', 'spellcheck', 'required',
                          'title', 'autocapitalize', 'autocorrect'],
      placeholder: null,
      disabled: false,
      maxlength: null,

      init: function() {
        this._super();
        this.on("focusOut", this, this._elementValueDidChange);
        this.on("change", this, this._elementValueDidChange);
        this.on("paste", this, this._elementValueDidChange);
        this.on("cut", this, this._elementValueDidChange);
        this.on("input", this, this._elementValueDidChange);
        this.on("keyUp", this, this.interpretKeyEvents);
      },

      /**
        The action to be sent when the user presses the return key.

        This is similar to the `{{action}}` helper, but is fired when
        the user presses the return key when editing a text field, and sends
        the value of the field as the context.

        @property action
        @type String
        @default null
      */
      action: null,

      /**
        The event that should send the action.

        Options are:

        * `enter`: the user pressed enter
        * `keyPress`: the user pressed a key

        @property onEvent
        @type String
        @default enter
      */
      onEvent: 'enter',

      /**
        Whether the `keyUp` event that triggers an `action` to be sent continues
        propagating to other views.

        By default, when the user presses the return key on their keyboard and
        the text field has an `action` set, the action will be sent to the view's
        controller and the key event will stop propagating.

        If you would like parent views to receive the `keyUp` event even after an
        action has been dispatched, set `bubbles` to true.

        @property bubbles
        @type Boolean
        @default false
      */
      bubbles: false,

      interpretKeyEvents: function(event) {
        var map = TextSupport.KEY_EVENTS;
        var method = map[event.keyCode];

        this._elementValueDidChange();
        if (method) { return this[method](event); }
      },

      _elementValueDidChange: function() {
        set(this, 'value', this.$().val());
      },

      /**
        Called when the user inserts a new line.

        Called by the `Ember.TextSupport` mixin on keyUp if keycode matches 13.
        Uses sendAction to send the `enter` action.

        @method insertNewline
        @param {Event} event
      */
      insertNewline: function(event) {
        sendAction('enter', this, event);
        sendAction('insert-newline', this, event);
      },

      /**
        Called when the user hits escape.

        Called by the `Ember.TextSupport` mixin on keyUp if keycode matches 27.
        Uses sendAction to send the `escape-press` action.

        @method cancel
        @param {Event} event
      */
      cancel: function(event) {
        sendAction('escape-press', this, event);
      },

      /**
        Called when the text area is focused.

        Uses sendAction to send the `focus-in` action.

        @method focusIn
        @param {Event} event
      */
      focusIn: function(event) {
        sendAction('focus-in', this, event);
      },

      /**
        Called when the text area is blurred.

        Uses sendAction to send the `focus-out` action.

        @method focusOut
        @param {Event} event
      */
      focusOut: function(event) {
        sendAction('focus-out', this, event);
      },

      /**
        Called when the user presses a key. Enabled by setting
        the `onEvent` property to `keyPress`.

        Uses sendAction to send the `key-press` action.

        @method keyPress
        @param {Event} event
      */
      keyPress: function(event) {
        sendAction('key-press', this, event);
      }

    });

    TextSupport.KEY_EVENTS = {
      13: 'insertNewline',
      27: 'cancel'
    };

    // In principle, this shouldn't be necessary, but the legacy
    // sendAction semantics for TextField are different from
    // the component semantics so this method normalizes them.
    function sendAction(eventName, view, event) {
      var action = get(view, eventName);
      var on = get(view, 'onEvent');
      var value = get(view, 'value');

      // back-compat support for keyPress as an event name even though
      // it's also a method name that consumes the event (and therefore
      // incompatible with sendAction semantics).
      if (on === eventName || (on === 'keyPress' && eventName === 'key-press')) {
        view.sendAction('action', value);
      }

      view.sendAction(eventName, value);

      if (action || on === eventName) {
        if(!get(view, 'bubbles')) {
          event.stopPropagation();
        }
      }
    }

    __exports__["default"] = TextSupport;
  });
enifed("ember-handlebars/ext",
  ["ember-metal/core","ember-runtime/system/string","ember-handlebars-compiler","ember-metal/property_get","ember-metal/error","ember-metal/mixin","ember-views/views/view","ember-handlebars/views/metamorph_view","ember-metal/path_cache","ember-metal/is_empty","ember-metal/cache","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __dependency11__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    // Ember.FEATURES, Ember.assert, Ember.Handlebars, Ember.lookup
    // var emberAssert = Ember.assert;

    var fmt = __dependency2__.fmt;

    var EmberHandlebars = __dependency3__["default"];
    var helpers = EmberHandlebars.helpers;

    var get = __dependency4__.get;
    var EmberError = __dependency5__["default"];
    var IS_BINDING = __dependency6__.IS_BINDING;

    var View = __dependency7__["default"];
    var _Metamorph = __dependency8__._Metamorph;
    var detectIsGlobal = __dependency9__.isGlobal;

    // late bound via requireModule because of circular dependencies.
    var resolveHelper, SimpleHandlebarsView;

    var isEmpty = __dependency10__["default"];

    var slice = [].slice;
    var originalTemplate = EmberHandlebars.template;

    /**
      If a path starts with a reserved keyword, returns the root
      that should be used.

      @private
      @method normalizePath
      @for Ember
      @param root {Object}
      @param path {String}
      @param data {Hash}
    */

    var Cache = __dependency11__["default"];

    var FIRST_SEGMENT_CACHE = new Cache(1000, function(path){
      return path.split('.', 1)[0];
    });

    function normalizePath(root, path, data) {
      var keywords = (data && data.keywords) || {};
      var keyword, isKeyword;

      // Get the first segment of the path. For example, if the
      // path is "foo.bar.baz", returns "foo".
      keyword = FIRST_SEGMENT_CACHE.get(path);

      // Test to see if the first path is a keyword that has been
      // passed along in the view's data hash. If so, we will treat
      // that object as the new root.
      if (keywords.hasOwnProperty(keyword)) {
        // Look up the value in the template's data hash.
        root = keywords[keyword];
        isKeyword = true;

        // Handle cases where the entire path is the reserved
        // word. In that case, return the object itself.
        if (path === keyword) {
          path = '';
        } else {
          // Strip the keyword from the path and look up
          // the remainder from the newly found root.
          path = path.substr(keyword.length+1);
        }
      }

      return {
        root: root,
        path: path,
        isKeyword: isKeyword
      };
    }


    /**
      Lookup both on root and on window. If the path starts with
      a keyword, the corresponding object will be looked up in the
      template's data hash and used to resolve the path.

      @method get
      @for Ember.Handlebars
      @param {Object} root The object to look up the property on
      @param {String} path The path to be lookedup
      @param {Object} options The template's option hash
    */
    function handlebarsGet(root, path, options) {
      var data = options && options.data;
      var normalizedPath = normalizePath(root, path, data);
      var value;

      // In cases where the path begins with a keyword, change the
      // root to the value represented by that keyword, and ensure
      // the path is relative to it.
      root = normalizedPath.root;
      path = normalizedPath.path;

      // Ember.get with a null root and GlobalPath will fall back to
      // Ember.lookup, which is no longer allowed in templates.
      //
      // But when outputting a primitive, root will be the primitive
      // and path a blank string. These primitives should pass through
      // to `get`.
      if (root || path === '') {
        value = get(root, path);
      }

      if (detectIsGlobal(path)) {
        if (value === undefined && root !== Ember.lookup) {
          root = Ember.lookup;
          value = get(root, path);
        }
        if (root === Ember.lookup || root === null) {
          Ember.deprecate("Global lookup of "+path+" from a Handlebars template is deprecated.");
        }
      }

      return value;
    }

    function lookupViewInContainer(container, path) {
      Ember.assert("View requires a container to resolve views not passed in through the context", !!container);
      return container.lookupFactory('view:'+path);
    }

    function lookupViewByClassName(path) {
      var viewClass;
      if (detectIsGlobal(path)) {
        viewClass = get(path);
        Ember.deprecate('Resolved the view "'+path+'" on the global context. Pass a view name to be looked up on the container instead, such as {{view "select"}}. http://emberjs.com/guides/deprecations#toc_global-lookup-of-views-since-1-8', !viewClass);
        return viewClass;
      }
    }

    /**
      handlebarsGetView resolves a view based on strings passed into a template.
      For example:

      ```handlebars
      {{view "some-view"}}
      {{view view.someView}}
      {{view App.SomeView}} {{! deprecated }}
      ```

      A value is first checked to be a string- non-strings are presumed to be
      an object and returned. This handles the "access a view on a context"
      case (line 2 in the above examples).

      Next a string is normalized, then called on the context with `get`. If
      there is still no value, a GlobalPath will be fetched from the global
      context (raising a deprecation) and a localPath will be passed to the
      container to be looked up.

      @private
      @for Ember.Handlebars
      @param {Object} context The context of the template being rendered
      @param {String} path The path to be lookedup
      @param {Object} container The container
      @param {Object} options The options from the template
    */
    function handlebarsGetView(context, path, container, options) {
      var viewClass;
      var data;
      var pathType;
      if (options) {
        data      = options.data;
        pathType  = options.types && options.types[0];
      }

      if ('string' === typeof path) {
        if('STRING' === pathType && container) {
          viewClass = lookupViewInContainer(container, path);
          Ember.deprecate('Quoted view names must refer to a view in the container.', viewClass);

        }

        if(!viewClass) {
          viewClass = lookupViewByClassName(path);
        }

        if(!viewClass) {
          if (data) {
            var normalizedPath = normalizePath(context, path, data);
            context = normalizedPath.root;
            path = normalizedPath.path;
          }

          // Only lookup view class on context if there is a context. If not,
          // the global lookup path on get may kick in.
          viewClass = context && get(context, path);

          if(!viewClass) {
            // try the container once more with the normalized path
            viewClass = lookupViewInContainer(container, path);
          }
        }
      } else {
        viewClass = path;
      }

      // Sometimes a view's value is yet another path
      if ('string' === typeof viewClass && data && data.view) {
        viewClass = handlebarsGetView(data.view, viewClass, container, {
          data: data,
          types: ['ID']
        });
      }

      Ember.assert(
        fmt(path+" must be a subclass or an instance of Ember.View, not %@", [viewClass]),
        View.detect(viewClass) || View.detectInstance(viewClass)
      );

      return viewClass;
    }

    /**
      This method uses `Ember.Handlebars.get` to lookup a value, then ensures
      that the value is escaped properly.

      If `unescaped` is a truthy value then the escaping will not be performed.

      @method getEscaped
      @for Ember.Handlebars
      @param {Object} root The object to look up the property on
      @param {String} path The path to be lookedup
      @param {Object} options The template's option hash
      @since 1.4.0
    */
    function getEscaped(root, path, options) {
      var result = handlebarsGet(root, path, options);

      if (result === null || result === undefined) {
        result = "";
      } else if (!(result instanceof Handlebars.SafeString)) {
        result = String(result);
      }
      if (!options.hash.unescaped){
        result = Handlebars.Utils.escapeExpression(result);
      }

      return result;
    }

    __exports__.getEscaped = getEscaped;function resolveParams(context, params, options) {
      var resolvedParams = [], types = options.types, param, type;

      for (var i=0, l=params.length; i<l; i++) {
        param = params[i];
        type = types[i];

        if (type === 'ID') {
          resolvedParams.push(handlebarsGet(context, param, options));
        } else {
          resolvedParams.push(param);
        }
      }

      return resolvedParams;
    }

    __exports__.resolveParams = resolveParams;function resolveHash(context, hash, options) {
      var resolvedHash = {}, types = options.hashTypes, type;

      for (var key in hash) {
        if (!hash.hasOwnProperty(key)) { continue; }

        type = types[key];

        if (type === 'ID') {
          resolvedHash[key] = handlebarsGet(context, hash[key], options);
        } else {
          resolvedHash[key] = hash[key];
        }
      }

      return resolvedHash;
    }

    __exports__.resolveHash = resolveHash;/**
      Registers a helper in Handlebars that will be called if no property with the
      given name can be found on the current context object, and no helper with
      that name is registered.

      This throws an exception with a more helpful error message so the user can
      track down where the problem is happening.

      @private
      @method helperMissing
      @for Ember.Handlebars.helpers
      @param {String} path
      @param {Hash} options
    */
    function helperMissingHelper(path) {
      if (!resolveHelper) { resolveHelper = requireModule('ember-handlebars/helpers/binding')['resolveHelper']; } // ES6TODO: stupid circular dep

      var error, view = "";

      var options = arguments[arguments.length - 1];

      var helper = resolveHelper(options.data.view.container, path);

      if (helper) {
        return helper.apply(this, slice.call(arguments, 1));
      }

      error = "%@ Handlebars error: Could not find property '%@' on object %@.";
      if (options.data) {
        view = options.data.view;
      }
      throw new EmberError(fmt(error, [view, path, this]));
    }

    __exports__.helperMissingHelper = helperMissingHelper;/**
      Registers a helper in Handlebars that will be called if no property with the
      given name can be found on the current context object, and no helper with
      that name is registered.

      This throws an exception with a more helpful error message so the user can
      track down where the problem is happening.

      @private
      @method helperMissing
      @for Ember.Handlebars.helpers
      @param {String} path
      @param {Hash} options
    */
    function blockHelperMissingHelper(path) {
      if (!resolveHelper) { resolveHelper = requireModule('ember-handlebars/helpers/binding')['resolveHelper']; } // ES6TODO: stupid circular dep

      var options = arguments[arguments.length - 1];

      Ember.assert("`blockHelperMissing` was invoked without a helper name, which " +
                   "is most likely due to a mismatch between the version of " +
                   "Ember.js you're running now and the one used to precompile your " +
                   "templates. Please make sure the version of " +
                   "`ember-handlebars-compiler` you're using is up to date.", path);

      var helper = resolveHelper(options.data.view.container, path);

      if (helper) {
        return helper.apply(this, slice.call(arguments, 1));
      } else {
        return helpers.helperMissing.call(this, path);
      }
    }

    __exports__.blockHelperMissingHelper = blockHelperMissingHelper;/**
      Register a bound handlebars helper. Bound helpers behave similarly to regular
      handlebars helpers, with the added ability to re-render when the underlying data
      changes.

      ## Simple example

      ```javascript
      Ember.Handlebars.registerBoundHelper('capitalize', function(value) {
        return Ember.String.capitalize(value);
      });
      ```

      The above bound helper can be used inside of templates as follows:

      ```handlebars
      {{capitalize name}}
      ```

      In this case, when the `name` property of the template's context changes,
      the rendered value of the helper will update to reflect this change.

      ## Example with options

      Like normal handlebars helpers, bound helpers have access to the options
      passed into the helper call.

      ```javascript
      Ember.Handlebars.registerBoundHelper('repeat', function(value, options) {
        var count = options.hash.count;
        var a = [];
        while(a.length < count) {
            a.push(value);
        }
        return a.join('');
      });
      ```

      This helper could be used in a template as follows:

      ```handlebars
      {{repeat text count=3}}
      ```

      ## Example with bound options

      Bound hash options are also supported. Example:

      ```handlebars
      {{repeat text count=numRepeats}}
      ```

      In this example, count will be bound to the value of
      the `numRepeats` property on the context. If that property
      changes, the helper will be re-rendered.

      ## Example with extra dependencies

      The `Ember.Handlebars.registerBoundHelper` method takes a variable length
      third parameter which indicates extra dependencies on the passed in value.
      This allows the handlebars helper to update when these dependencies change.

      ```javascript
      Ember.Handlebars.registerBoundHelper('capitalizeName', function(value) {
        return value.get('name').toUpperCase();
      }, 'name');
      ```

      ## Example with multiple bound properties

      `Ember.Handlebars.registerBoundHelper` supports binding to
      multiple properties, e.g.:

      ```javascript
      Ember.Handlebars.registerBoundHelper('concatenate', function() {
        var values = Array.prototype.slice.call(arguments, 0, -1);
        return values.join('||');
      });
      ```

      Which allows for template syntax such as `{{concatenate prop1 prop2}}` or
      `{{concatenate prop1 prop2 prop3}}`. If any of the properties change,
      the helper will re-render.  Note that dependency keys cannot be
      using in conjunction with multi-property helpers, since it is ambiguous
      which property the dependent keys would belong to.

      ## Use with unbound helper

      The `{{unbound}}` helper can be used with bound helper invocations
      to render them in their unbound form, e.g.

      ```handlebars
      {{unbound capitalize name}}
      ```

      In this example, if the name property changes, the helper
      will not re-render.

      ## Use with blocks not supported

      Bound helpers do not support use with Handlebars blocks or
      the addition of child views of any kind.

      @method registerBoundHelper
      @for Ember.Handlebars
      @param {String} name
      @param {Function} function
      @param {String} dependentKeys*
    */
    function registerBoundHelper(name, fn) {
      var boundHelperArgs = slice.call(arguments, 1);
      var boundFn = makeBoundHelper.apply(this, boundHelperArgs);
      EmberHandlebars.registerHelper(name, boundFn);
    }

    __exports__.registerBoundHelper = registerBoundHelper;/**
      A helper function used by `registerBoundHelper`. Takes the
      provided Handlebars helper function fn and returns it in wrapped
      bound helper form.

      The main use case for using this outside of `registerBoundHelper`
      is for registering helpers on the container:

      ```js
      var boundHelperFn = Ember.Handlebars.makeBoundHelper(function(word) {
        return word.toUpperCase();
      });

      container.register('helper:my-bound-helper', boundHelperFn);
      ```

      In the above example, if the helper function hadn't been wrapped in
      `makeBoundHelper`, the registered helper would be unbound.

      @method makeBoundHelper
      @for Ember.Handlebars
      @param {Function} function
      @param {String} dependentKeys*
      @since 1.2.0
    */
    function makeBoundHelper(fn) {
      if (!SimpleHandlebarsView) { SimpleHandlebarsView = requireModule('ember-handlebars/views/handlebars_bound_view')['SimpleHandlebarsView']; } // ES6TODO: stupid circular dep

      var dependentKeys = slice.call(arguments, 1);

      function helper() {
        var properties = slice.call(arguments, 0, -1);
        var numProperties = properties.length;
        var options = arguments[arguments.length - 1];
        var normalizedProperties = [];
        var data = options.data;
        var types = data.isUnbound ? slice.call(options.types, 1) : options.types;
        var hash = options.hash;
        var hashTypes = options.hashTypes;
        var view = data.view;
        var contexts = options.contexts;
        var currentContext = (contexts && contexts.length) ? contexts[0] : this;
        var prefixPathForDependentKeys = '';
        var loc, len, hashOption;
        var boundOption, property;
        var normalizedValue = SimpleHandlebarsView.prototype.normalizedValue;

        Ember.assert("registerBoundHelper-generated helpers do not support use with Handlebars blocks.", !options.fn);

        // Detect bound options (e.g. countBinding="otherCount")
        var boundOptions = hash.boundOptions = {};
        for (hashOption in hash) {
          if (IS_BINDING.test(hashOption)) {
            // Lop off 'Binding' suffix.
            boundOptions[hashOption.slice(0, -7)] = hash[hashOption];
          } else if (hashTypes[hashOption] === 'ID') {
            boundOptions[hashOption] = hash[hashOption];
          }
        }

        // Expose property names on data.properties object.
        var watchedProperties = [];
        data.properties = [];
        for (loc = 0; loc < numProperties; ++loc) {
          data.properties.push(properties[loc]);
          if (types[loc] === 'ID') {
            var normalizedProp = normalizePath(currentContext, properties[loc], data);
            normalizedProperties.push(normalizedProp);
            watchedProperties.push(normalizedProp);
          } else {
            if (data.isUnbound) {
              normalizedProperties.push({path: properties[loc]});
            }else {
              normalizedProperties.push(null);
            }
          }
        }

        // Handle case when helper invocation is preceded by `unbound`, e.g.
        // {{unbound myHelper foo}}
        if (data.isUnbound) {
          return evaluateUnboundHelper(this, fn, normalizedProperties, options);
        }

        var bindView = new SimpleHandlebarsView(null, null, !options.hash.unescaped, options.data);

        // Override SimpleHandlebarsView's method for generating the view's content.
        bindView.normalizedValue = function() {
          var args = [];
          var boundOption;

          // Copy over bound hash options.
          for (boundOption in boundOptions) {
            if (!boundOptions.hasOwnProperty(boundOption)) { continue; }
            property = normalizePath(currentContext, boundOptions[boundOption], data);
            bindView.path = property.path;
            bindView.pathRoot = property.root;
            hash[boundOption] = normalizedValue.call(bindView);
          }

          for (loc = 0; loc < numProperties; ++loc) {
            property = normalizedProperties[loc];
            if (property) {
              bindView.path = property.path;
              bindView.pathRoot = property.root;
              args.push(normalizedValue.call(bindView));
            } else {
              args.push(properties[loc]);
            }
          }
          args.push(options);

          // Run the supplied helper function.
          return fn.apply(currentContext, args);
        };

        view.appendChild(bindView);

        // Assemble list of watched properties that'll re-render this helper.
        for (boundOption in boundOptions) {
          if (boundOptions.hasOwnProperty(boundOption)) {
            watchedProperties.push(normalizePath(currentContext, boundOptions[boundOption], data));
          }
        }

        // Observe each property.
        for (loc = 0, len = watchedProperties.length; loc < len; ++loc) {
          property = watchedProperties[loc];
          view.registerObserver(property.root, property.path, bindView, bindView.rerender);
        }

        if (types[0] !== 'ID' || normalizedProperties.length === 0) {
          return;
        }

        // Add dependent key observers to the first param
        var normalized = normalizedProperties[0];
        var pathRoot = normalized.root;
        var path = normalized.path;

        if(!isEmpty(path)) {
          prefixPathForDependentKeys = path + '.';
        }
        for (var i=0, l=dependentKeys.length; i<l; i++) {
          view.registerObserver(pathRoot, prefixPathForDependentKeys + dependentKeys[i], bindView, bindView.rerender);
        }
      }

      helper._rawFunction = fn;
      return helper;
    }

    /**
      Renders the unbound form of an otherwise bound helper function.

      @private
      @method evaluateUnboundHelper
      @param {Function} fn
      @param {Object} context
      @param {Array} normalizedProperties
      @param {String} options
    */
    function evaluateUnboundHelper(context, fn, normalizedProperties, options) {
      var args = [];
      var hash = options.hash;
      var boundOptions = hash.boundOptions;
      var types = slice.call(options.types, 1);
      var loc, len, property, propertyType, boundOption;

      for (boundOption in boundOptions) {
        if (!boundOptions.hasOwnProperty(boundOption)) { continue; }
        hash[boundOption] = handlebarsGet(context, boundOptions[boundOption], options);
      }

      for (loc = 0, len = normalizedProperties.length; loc < len; ++loc) {
        property = normalizedProperties[loc];
        propertyType = types[loc];
        if (propertyType === "ID") {
          args.push(handlebarsGet(property.root, property.path, options));
        } else {
          args.push(property.path);
        }
      }
      args.push(options);
      return fn.apply(context, args);
    }

    /**
      Overrides Handlebars.template so that we can distinguish
      user-created, top-level templates from inner contexts.

      @private
      @method template
      @for Ember.Handlebars
      @param {String} spec
    */
    function template(spec) {
      var t = originalTemplate(spec);
      t.isTop = true;
      return t;
    }

    __exports__.template = template;__exports__.normalizePath = normalizePath;
    __exports__.makeBoundHelper = makeBoundHelper;
    __exports__.handlebarsGet = handlebarsGet;
    __exports__.handlebarsGetView = handlebarsGetView;
    __exports__.evaluateUnboundHelper = evaluateUnboundHelper;
  });
enifed("ember-handlebars/helpers/binding",
  ["ember-metal/core","ember-handlebars-compiler","ember-metal/property_get","ember-metal/property_set","ember-metal/utils","ember-runtime/system/string","ember-metal/platform","ember-metal/is_none","ember-metal/enumerable_utils","ember-metal/array","ember-views/views/view","ember-metal/run_loop","ember-metal/observer","ember-metal/binding","ember-views/system/jquery","ember-handlebars/ext","ember-metal/keys","ember-metal/cache","ember-handlebars/views/handlebars_bound_view","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __dependency11__, __dependency12__, __dependency13__, __dependency14__, __dependency15__, __dependency16__, __dependency17__, __dependency18__, __dependency19__, __exports__) {
    "use strict";
    /**
    @module ember
    @submodule ember-handlebars
    */

    var Ember = __dependency1__["default"];
    // Ember.assert, Ember.warn, uuid
    // var emberAssert = Ember.assert, Ember.warn = Ember.warn;

    var EmberHandlebars = __dependency2__["default"];
    var get = __dependency3__.get;
    var set = __dependency4__.set;
    var apply = __dependency5__.apply;
    var uuid = __dependency5__.uuid;
    var fmt = __dependency6__.fmt;
    var o_create = __dependency7__.create;
    var isNone = __dependency8__["default"];
    var EnumerableUtils = __dependency9__["default"];
    var forEach = __dependency10__.forEach;
    var View = __dependency11__["default"];
    var run = __dependency12__["default"];
    var removeObserver = __dependency13__.removeObserver;
    var isGlobalPath = __dependency14__.isGlobalPath;
    var emberBind = __dependency14__.bind;
    var jQuery = __dependency15__["default"];
    var isArray = __dependency5__.isArray;
    var handlebarsGetEscaped = __dependency16__.getEscaped;
    var keys = __dependency17__["default"];
    var Cache = __dependency18__["default"];

    var _HandlebarsBoundView = __dependency19__._HandlebarsBoundView;
    var SimpleHandlebarsView = __dependency19__.SimpleHandlebarsView;

    var normalizePath = __dependency16__.normalizePath;
    var handlebarsGet = __dependency16__.handlebarsGet;
    var getEscaped = __dependency16__.getEscaped;

    var guidFor = __dependency5__.guidFor;
    var typeOf = __dependency5__.typeOf;

    var helpers = EmberHandlebars.helpers;
    var SafeString = EmberHandlebars.SafeString;

    function exists(value) {
      return !isNone(value);
    }

    var WithView = _HandlebarsBoundView.extend({
      init: function() {
        var controller;

        apply(this, this._super, arguments);

        var keywords        = this.templateData.keywords;
        var keywordName     = this.templateHash.keywordName;
        var keywordPath     = this.templateHash.keywordPath;
        var controllerName  = this.templateHash.controller;
        var preserveContext = this.preserveContext;

        if (controllerName) {
          var previousContext = this.previousContext;
          controller = this.container.lookupFactory('controller:'+controllerName).create({
            parentController: previousContext,
            target: previousContext
          });

          this._generatedController = controller;

          if (!preserveContext) {
            this.set('controller', controller);

            this.valueNormalizerFunc = function(result) {
                controller.set('model', result);
                return controller;
            };
          } else {
            var controllerPath = jQuery.expando + guidFor(controller);
            keywords[controllerPath] = controller;
            emberBind(keywords, controllerPath + '.model', keywordPath);
            keywordPath = controllerPath;
          }
        }

        if (preserveContext) {
          emberBind(keywords, keywordName, keywordPath);
        }

      },
      willDestroy: function() {
        this._super();

        if (this._generatedController) {
          this._generatedController.destroy();
        }
      }
    });

    // Binds a property into the DOM. This will create a hook in DOM that the
    // KVO system will look for and update if the property changes.
    function bind(property, options, preserveContext, shouldDisplay, valueNormalizer, childProperties) {
      var data = options.data;
      var fn = options.fn;
      var inverse = options.inverse;
      var view = data.view;
      var normalized, observer, i;

      // we relied on the behavior of calling without
      // context to mean this === window, but when running
      // "use strict", it's possible for this to === undefined;
      var currentContext = this || window;

      normalized = normalizePath(currentContext, property, data);

      if (data.insideGroup) {
        observer = function() {
          while (view._contextView) {
            view = view._contextView;
          }
          run.once(view, 'rerender');
        };

        var template, context;
        var result = handlebarsGet(currentContext, property, options);

        result = valueNormalizer ? valueNormalizer(result) : result;

        context = preserveContext ? currentContext : result;
        if (shouldDisplay(result)) {
          template = fn;
        } else if (inverse) {
          template = inverse;
        }

        template(context, { data: options.data });
      } else {
        var viewClass = _HandlebarsBoundView;
        var viewOptions = {
          preserveContext: preserveContext,
          shouldDisplayFunc: shouldDisplay,
          valueNormalizerFunc: valueNormalizer,
          displayTemplate: fn,
          inverseTemplate: inverse,
          path: property,
          pathRoot: currentContext,
          previousContext: currentContext,
          isEscaped: !options.hash.unescaped,
          templateData: options.data,
          templateHash: options.hash,
          helperName: options.helperName
        };

        if (options.isWithHelper) {
          viewClass = WithView;
        }

        // Create the view that will wrap the output of this template/property
        // and add it to the nearest view's childViews array.
        // See the documentation of Ember._HandlebarsBoundView for more.
        var bindView = view.createChildView(viewClass, viewOptions);

        view.appendChild(bindView);

        observer = function() {
          run.scheduleOnce('render', bindView, 'rerenderIfNeeded');
        };
      }

      // Observes the given property on the context and
      // tells the Ember._HandlebarsBoundView to re-render. If property
      // is an empty string, we are printing the current context
      // object ({{this}}) so updating it is not our responsibility.
      if (typeof this === 'object' && normalized.path !== '') {
        view.registerObserver(normalized.root, normalized.path, observer);
        if (childProperties) {
          for (i=0; i<childProperties.length; i++) {
            view.registerObserver(normalized.root, normalized.path+'.'+childProperties[i], observer);
          }
        }
      }
    }

    function simpleBind(currentContext, property, options) {
      var data = options.data;
      var view = data.view;
      var normalized, observer, pathRoot, output;

      normalized = normalizePath(currentContext, property, data);
      pathRoot = normalized.root;

      // Set up observers for observable objects
      if (pathRoot && ('object' === typeof pathRoot)) {
        if (data.insideGroup) {
          observer = function() {
            while (view._contextView) {
              view = view._contextView;
            }
            run.once(view, 'rerender');
          };

          output = handlebarsGetEscaped(currentContext, property, options);

          data.buffer.push(output);
        } else {
          var bindView = new SimpleHandlebarsView(
            property, currentContext, !options.hash.unescaped, options.data
          );

          bindView._parentView = view;
          view.appendChild(bindView);

          observer = function() {
            run.scheduleOnce('render', bindView, 'rerender');
          };
        }

        // Observes the given property on the context and
        // tells the Ember._HandlebarsBoundView to re-render. If property
        // is an empty string, we are printing the current context
        // object ({{this}}) so updating it is not our responsibility.
        if (normalized.path !== '') {
          view.registerObserver(normalized.root, normalized.path, observer);
        }
      } else {
        // The object is not observable, so just render it out and
        // be done with it.
        output = handlebarsGetEscaped(currentContext, property, options);
        data.buffer.push(output);
      }
    }

    function shouldDisplayIfHelperContent(result) {
      var truthy = result && get(result, 'isTruthy');
      if (typeof truthy === 'boolean') { return truthy; }

      if (isArray(result)) {
        return get(result, 'length') !== 0;
      } else {
        return !!result;
      }
    }

    /**
      '_triageMustache' is used internally select between a binding, helper, or component for
      the given context. Until this point, it would be hard to determine if the
      mustache is a property reference or a regular helper reference. This triage
      helper resolves that.

      This would not be typically invoked by directly.

      @private
      @method _triageMustache
      @for Ember.Handlebars.helpers
      @param {String} property Property/helperID to triage
      @param {Object} options hash of template/rendering options
      @return {String} HTML string
    */
    function _triageMustacheHelper(property, options) {
      Ember.assert("You cannot pass more than one argument to the _triageMustache helper", arguments.length <= 2);

      var helper = EmberHandlebars.resolveHelper(options.data.view.container, property);
      if (helper) {
        return helper.call(this, options);
      }

      return helpers.bind.call(this, property, options);
    }

    var ISNT_HELPER_CACHE = new Cache(1000, function(key) {
      return key.indexOf('-') === -1;
    });
    __exports__.ISNT_HELPER_CACHE = ISNT_HELPER_CACHE;
    /**
      Used to lookup/resolve handlebars helpers. The lookup order is:

      * Look for a registered helper
      * If a dash exists in the name:
        * Look for a helper registed in the container
        * Use Ember.ComponentLookup to find an Ember.Component that resolves
          to the given name

      @private
      @method resolveHelper
      @param {Container} container
      @param {String} name the name of the helper to lookup
      @return {Handlebars Helper}
    */
    function resolveHelper(container, name) {
      if (helpers[name]) {
        return helpers[name];
      }

      if (!container || ISNT_HELPER_CACHE.get(name)) {
        return;
      }

      var helper = container.lookup('helper:' + name);
      if (!helper) {
        var componentLookup = container.lookup('component-lookup:main');
        Ember.assert("Could not find 'component-lookup:main' on the provided container, which is necessary for performing component lookups", componentLookup);

        var Component = componentLookup.lookupFactory(name, container);
        if (Component) {
          helper = EmberHandlebars.makeViewHelper(Component);
          container.register('helper:' + name, helper);
        }
      }
      return helper;
    }


    /**
      `bind` can be used to display a value, then update that value if it
      changes. For example, if you wanted to print the `title` property of
      `content`:

      ```handlebars
      {{bind "content.title"}}
      ```

      This will return the `title` property as a string, then create a new observer
      at the specified path. If it changes, it will update the value in DOM. Note
      that if you need to support IE7 and IE8 you must modify the model objects
      properties using `Ember.get()` and `Ember.set()` for this to work as it
      relies on Ember's KVO system. For all other browsers this will be handled for
      you automatically.

      @private
      @method bind
      @for Ember.Handlebars.helpers
      @param {String} property Property to bind
      @param {Function} fn Context to provide for rendering
      @return {String} HTML string
    */
    function bindHelper(property, options) {
      Ember.assert("You cannot pass more than one argument to the bind helper", arguments.length <= 2);

      var context = (options.contexts && options.contexts.length) ? options.contexts[0] : this;

      if (!options.fn) {
        return simpleBind(context, property, options);
      }

      options.helperName = 'bind';

      return bind.call(context, property, options, false, exists);
    }

    /**
      Use the `boundIf` helper to create a conditional that re-evaluates
      whenever the truthiness of the bound value changes.

      ```handlebars
      {{#boundIf "content.shouldDisplayTitle"}}
        {{content.title}}
      {{/boundIf}}
      ```

      @private
      @method boundIf
      @for Ember.Handlebars.helpers
      @param {String} property Property to bind
      @param {Function} fn Context to provide for rendering
      @return {String} HTML string
    */
    function boundIfHelper(property, fn) {
      var context = (fn.contexts && fn.contexts.length) ? fn.contexts[0] : this;

      fn.helperName = fn.helperName || 'boundIf';

      return bind.call(context, property, fn, true, shouldDisplayIfHelperContent, shouldDisplayIfHelperContent, ['isTruthy', 'length']);
    }

    /**
      @private

      Use the `unboundIf` helper to create a conditional that evaluates once.

      ```handlebars
      {{#unboundIf "content.shouldDisplayTitle"}}
        {{content.title}}
      {{/unboundIf}}
      ```

      @method unboundIf
      @for Ember.Handlebars.helpers
      @param {String} property Property to bind
      @param {Function} fn Context to provide for rendering
      @return {String} HTML string
      @since 1.4.0
    */
    function unboundIfHelper(property, fn) {
      var context = (fn.contexts && fn.contexts.length) ? fn.contexts[0] : this;
      var data = fn.data;
      var template = fn.fn;
      var inverse = fn.inverse;
      var normalized, propertyValue, result;

      normalized = normalizePath(context, property, data);
      propertyValue = handlebarsGet(context, property, fn);

      if (!shouldDisplayIfHelperContent(propertyValue)) {
        template = inverse;
      }

      template(context, { data: data });
    }

    /**
      Use the `{{with}}` helper when you want to scope context. Take the following code as an example:

      ```handlebars
      <h5>{{user.name}}</h5>

      <div class="role">
        <h6>{{user.role.label}}</h6>
        <span class="role-id">{{user.role.id}}</span>

        <p class="role-desc">{{user.role.description}}</p>
      </div>
      ```

      `{{with}}` can be our best friend in these cases,
      instead of writing `user.role.*` over and over, we use `{{#with user.role}}`.
      Now the context within the `{{#with}} .. {{/with}}` block is `user.role` so you can do the following:

      ```handlebars
      <h5>{{user.name}}</h5>

      <div class="role">
        {{#with user.role}}
          <h6>{{label}}</h6>
          <span class="role-id">{{id}}</span>

          <p class="role-desc">{{description}}</p>
        {{/with}}
      </div>
      ```

      ### `as` operator

      This operator aliases the scope to a new name. It's helpful for semantic clarity and to retain
      default scope or to reference from another `{{with}}` block.

      ```handlebars
      // posts might not be
      {{#with user.posts as blogPosts}}
        <div class="notice">
          There are {{blogPosts.length}} blog posts written by {{user.name}}.
        </div>

        {{#each post in blogPosts}}
          <li>{{post.title}}</li>
        {{/each}}
      {{/with}}
      ```

      Without the `as` operator, it would be impossible to reference `user.name` in the example above.

      NOTE: The alias should not reuse a name from the bound property path.
      For example: `{{#with foo.bar as foo}}` is not supported because it attempts to alias using
      the first part of the property path, `foo`. Instead, use `{{#with foo.bar as baz}}`.

      ### `controller` option

      Adding `controller='something'` instructs the `{{with}}` helper to create and use an instance of
      the specified controller with the new context as its content.

      This is very similar to using an `itemController` option with the `{{each}}` helper.

      ```handlebars
      {{#with users.posts controller='userBlogPosts'}}
        {{!- The current context is wrapped in our controller instance }}
      {{/with}}
      ```

      In the above example, the template provided to the `{{with}}` block is now wrapped in the
      `userBlogPost` controller, which provides a very elegant way to decorate the context with custom
      functions/properties.

      @method with
      @for Ember.Handlebars.helpers
      @param {Function} context
      @param {Hash} options
      @return {String} HTML string
    */
    function withHelper(context, options) {
      var bindContext, preserveContext, controller;
      var helperName = 'with';

      if (arguments.length === 4) {
        var keywordName, path, rootPath, normalized, contextPath;

        Ember.assert("If you pass more than one argument to the with helper, it must be in the form #with foo as bar", arguments[1] === "as");
        options = arguments[3];
        keywordName = arguments[2];
        path = arguments[0];

        if (path) {
          helperName += ' ' + path + ' as ' + keywordName;
        }

        Ember.assert("You must pass a block to the with helper", options.fn && options.fn !== Handlebars.VM.noop);

        var localizedOptions = o_create(options);
        localizedOptions.data = o_create(options.data);
        localizedOptions.data.keywords = o_create(options.data.keywords || {});

        if (isGlobalPath(path)) {
          contextPath = path;
        } else {
          normalized = normalizePath(this, path, options.data);
          path = normalized.path;
          rootPath = normalized.root;

          // This is a workaround for the fact that you cannot bind separate objects
          // together. When we implement that functionality, we should use it here.
          var contextKey = jQuery.expando + guidFor(rootPath);
          localizedOptions.data.keywords[contextKey] = rootPath;
          // if the path is '' ("this"), just bind directly to the current context
          contextPath = path ? contextKey + '.' + path : contextKey;
        }

        localizedOptions.hash.keywordName = keywordName;
        localizedOptions.hash.keywordPath = contextPath;

        bindContext = this;
        context = contextPath;
        options = localizedOptions;
        preserveContext = true;
      } else {
        Ember.assert("You must pass exactly one argument to the with helper", arguments.length === 2);
        Ember.assert("You must pass a block to the with helper", options.fn && options.fn !== Handlebars.VM.noop);

        helperName += ' ' + context;
        bindContext = options.contexts[0];
        preserveContext = false;
      }

      options.helperName = helperName;
      options.isWithHelper = true;

      return bind.call(bindContext, context, options, preserveContext, exists);
    }
    /**
      See [boundIf](/api/classes/Ember.Handlebars.helpers.html#method_boundIf)
      and [unboundIf](/api/classes/Ember.Handlebars.helpers.html#method_unboundIf)

      @method if
      @for Ember.Handlebars.helpers
      @param {Function} context
      @param {Hash} options
      @return {String} HTML string
    */
    function ifHelper(context, options) {
      Ember.assert("You must pass exactly one argument to the if helper", arguments.length === 2);
      Ember.assert("You must pass a block to the if helper", options.fn && options.fn !== Handlebars.VM.noop);

      options.helperName = options.helperName || ('if ' + context);

      if (options.data.isUnbound) {
        return helpers.unboundIf.call(options.contexts[0], context, options);
      } else {
        return helpers.boundIf.call(options.contexts[0], context, options);
      }
    }

    /**
      @method unless
      @for Ember.Handlebars.helpers
      @param {Function} context
      @param {Hash} options
      @return {String} HTML string
    */
    function unlessHelper(context, options) {
      Ember.assert("You must pass exactly one argument to the unless helper", arguments.length === 2);
      Ember.assert("You must pass a block to the unless helper", options.fn && options.fn !== Handlebars.VM.noop);

      var fn = options.fn;
      var inverse = options.inverse;
      var helperName = 'unless';

      if (context) {
        helperName += ' ' + context;
      }

      options.fn = inverse;
      options.inverse = fn;

      options.helperName = options.helperName || helperName;

      if (options.data.isUnbound) {
        return helpers.unboundIf.call(options.contexts[0], context, options);
      } else {
        return helpers.boundIf.call(options.contexts[0], context, options);
      }
    }

    /**
      `bind-attr` allows you to create a binding between DOM element attributes and
      Ember objects. For example:

      ```handlebars
      <img {{bind-attr src="imageUrl" alt="imageTitle"}}>
      ```

      The above handlebars template will fill the `<img>`'s `src` attribute with
      the value of the property referenced with `"imageUrl"` and its `alt`
      attribute with the value of the property referenced with `"imageTitle"`.

      If the rendering context of this template is the following object:

      ```javascript
      {
        imageUrl: 'http://lolcats.info/haz-a-funny',
        imageTitle: 'A humorous image of a cat'
      }
      ```

      The resulting HTML output will be:

      ```html
      <img src="http://lolcats.info/haz-a-funny" alt="A humorous image of a cat">
      ```

      `bind-attr` cannot redeclare existing DOM element attributes. The use of `src`
      in the following `bind-attr` example will be ignored and the hard coded value
      of `src="/failwhale.gif"` will take precedence:

      ```handlebars
      <img src="/failwhale.gif" {{bind-attr src="imageUrl" alt="imageTitle"}}>
      ```

      ### `bind-attr` and the `class` attribute

      `bind-attr` supports a special syntax for handling a number of cases unique
      to the `class` DOM element attribute. The `class` attribute combines
      multiple discrete values into a single attribute as a space-delimited
      list of strings. Each string can be:

      * a string return value of an object's property.
      * a boolean return value of an object's property
      * a hard-coded value

      A string return value works identically to other uses of `bind-attr`. The
      return value of the property will become the value of the attribute. For
      example, the following view and template:

      ```javascript
        AView = View.extend({
          someProperty: function() {
            return "aValue";
          }.property()
        })
      ```

      ```handlebars
      <img {{bind-attr class="view.someProperty}}>
      ```

      Result in the following rendered output:

      ```html
      <img class="aValue">
      ```

      A boolean return value will insert a specified class name if the property
      returns `true` and remove the class name if the property returns `false`.

      A class name is provided via the syntax
      `somePropertyName:class-name-if-true`.

      ```javascript
      AView = View.extend({
        someBool: true
      })
      ```

      ```handlebars
      <img {{bind-attr class="view.someBool:class-name-if-true"}}>
      ```

      Result in the following rendered output:

      ```html
      <img class="class-name-if-true">
      ```

      An additional section of the binding can be provided if you want to
      replace the existing class instead of removing it when the boolean
      value changes:

      ```handlebars
      <img {{bind-attr class="view.someBool:class-name-if-true:class-name-if-false"}}>
      ```

      A hard-coded value can be used by prepending `:` to the desired
      class name: `:class-name-to-always-apply`.

      ```handlebars
      <img {{bind-attr class=":class-name-to-always-apply"}}>
      ```

      Results in the following rendered output:

      ```html
      <img class="class-name-to-always-apply">
      ```

      All three strategies - string return value, boolean return value, and
      hard-coded value – can be combined in a single declaration:

      ```handlebars
      <img {{bind-attr class=":class-name-to-always-apply view.someBool:class-name-if-true view.someProperty"}}>
      ```

      @method bind-attr
      @for Ember.Handlebars.helpers
      @param {Hash} options
      @return {String} HTML string
    */
    function bindAttrHelper(options) {
      var attrs = options.hash;

      Ember.assert("You must specify at least one hash argument to bind-attr", !!keys(attrs).length);

      var view = options.data.view;
      var ret = [];

      // we relied on the behavior of calling without
      // context to mean this === window, but when running
      // "use strict", it's possible for this to === undefined;
      var ctx = this || window;

      // Generate a unique id for this element. This will be added as a
      // data attribute to the element so it can be looked up when
      // the bound property changes.
      var dataId = uuid();

      // Handle classes differently, as we can bind multiple classes
      var classBindings = attrs['class'];
      if (classBindings != null) {
        var classResults = bindClasses(ctx, classBindings, view, dataId, options);

        ret.push('class="' + Handlebars.Utils.escapeExpression(classResults.join(' ')) + '"');
        delete attrs['class'];
      }

      var attrKeys = keys(attrs);

      // For each attribute passed, create an observer and emit the
      // current value of the property as an attribute.
      forEach.call(attrKeys, function(attr) {
        var path = attrs[attr];
        var normalized;

        Ember.assert(fmt("You must provide an expression as the value of bound attribute. You specified: %@=%@", [attr, path]), typeof path === 'string');

        normalized = normalizePath(ctx, path, options.data);

        var value = (path === 'this') ? normalized.root : handlebarsGet(ctx, path, options);
        var type = typeOf(value);

        Ember.assert(fmt("Attributes must be numbers, strings or booleans, not %@", [value]), value === null || value === undefined || type === 'number' || type === 'string' || type === 'boolean');

        var observer;

        observer = function observer() {
          var result = handlebarsGet(ctx, path, options);

          Ember.assert(fmt("Attributes must be numbers, strings or booleans, not %@", [result]),
                       result === null || result === undefined || typeof result === 'number' ||
                         typeof result === 'string' || typeof result === 'boolean');

          var elem = view.$("[data-bindattr-" + dataId + "='" + dataId + "']");

          // If we aren't able to find the element, it means the element
          // to which we were bound has been removed from the view.
          // In that case, we can assume the template has been re-rendered
          // and we need to clean up the observer.
          if (!elem || elem.length === 0) {
            removeObserver(normalized.root, normalized.path, observer);
            return;
          }

          View.applyAttributeBindings(elem, attr, result);
        };

        // Add an observer to the view for when the property changes.
        // When the observer fires, find the element using the
        // unique data id and update the attribute to the new value.
        // Note: don't add observer when path is 'this' or path
        // is whole keyword e.g. {{#each x in list}} ... {{bind-attr attr="x"}}
        if (path !== 'this' && !(normalized.isKeyword && normalized.path === '' )) {
          view.registerObserver(normalized.root, normalized.path, observer);
        }

        // if this changes, also change the logic in ember-views/lib/views/view.js
        if ((type === 'string' || (type === 'number' && !isNaN(value)))) {
          ret.push(attr + '="' + Handlebars.Utils.escapeExpression(value) + '"');
        } else if (value && type === 'boolean') {
          // The developer controls the attr name, so it should always be safe
          ret.push(attr + '="' + attr + '"');
        }
      }, this);

      // Add the unique identifier
      // NOTE: We use all lower-case since Firefox has problems with mixed case in SVG
      ret.push('data-bindattr-' + dataId + '="' + dataId + '"');
      return new SafeString(ret.join(' '));
    }

    /**
      See `bind-attr`

      @method bindAttr
      @for Ember.Handlebars.helpers
      @deprecated
      @param {Function} context
      @param {Hash} options
      @return {String} HTML string
    */
    function bindAttrHelperDeprecated() {
      Ember.warn("The 'bindAttr' view helper is deprecated in favor of 'bind-attr'");
      return helpers['bind-attr'].apply(this, arguments);
    }

    /**
      Helper that, given a space-separated string of property paths and a context,
      returns an array of class names. Calling this method also has the side
      effect of setting up observers at those property paths, such that if they
      change, the correct class name will be reapplied to the DOM element.

      For example, if you pass the string "fooBar", it will first look up the
      "fooBar" value of the context. If that value is true, it will add the
      "foo-bar" class to the current element (i.e., the dasherized form of
      "fooBar"). If the value is a string, it will add that string as the class.
      Otherwise, it will not add any new class name.

      @private
      @method bindClasses
      @for Ember.Handlebars
      @param {Ember.Object} context The context from which to lookup properties
      @param {String} classBindings A string, space-separated, of class bindings
        to use
      @param {View} view The view in which observers should look for the
        element to update
      @param {Srting} bindAttrId Optional bindAttr id used to lookup elements
      @return {Array} An array of class names to add
    */
    function bindClasses(context, classBindings, view, bindAttrId, options) {
      var ret = [];
      var newClass, value, elem;

      // Helper method to retrieve the property from the context and
      // determine which class string to return, based on whether it is
      // a Boolean or not.
      var classStringForPath = function(root, parsedPath, options) {
        var val;
        var path = parsedPath.path;

        if (path === 'this') {
          val = root;
        } else if (path === '') {
          val = true;
        } else {
          val = handlebarsGet(root, path, options);
        }

        return View._classStringForValue(path, val, parsedPath.className, parsedPath.falsyClassName);
      };

      // For each property passed, loop through and setup
      // an observer.
      forEach.call(classBindings.split(' '), function(binding) {

        // Variable in which the old class value is saved. The observer function
        // closes over this variable, so it knows which string to remove when
        // the property changes.
        var oldClass;
        var observer;
        var parsedPath = View._parsePropertyPath(binding);
        var path = parsedPath.path;
        var pathRoot = context;
        var normalized;

        if (path !== '' && path !== 'this') {
          normalized = normalizePath(context, path, options.data);

          pathRoot = normalized.root;
          path = normalized.path;
        }

        // Set up an observer on the context. If the property changes, toggle the
        // class name.
        observer = function() {
          // Get the current value of the property
          newClass = classStringForPath(context, parsedPath, options);
          elem = bindAttrId ? view.$("[data-bindattr-" + bindAttrId + "='" + bindAttrId + "']") : view.$();

          // If we can't find the element anymore, a parent template has been
          // re-rendered and we've been nuked. Remove the observer.
          if (!elem || elem.length === 0) {
            removeObserver(pathRoot, path, observer);
          } else {
            // If we had previously added a class to the element, remove it.
            if (oldClass) {
              elem.removeClass(oldClass);
            }

            // If necessary, add a new class. Make sure we keep track of it so
            // it can be removed in the future.
            if (newClass) {
              elem.addClass(newClass);
              oldClass = newClass;
            } else {
              oldClass = null;
            }
          }
        };

        if (path !== '' && path !== 'this') {
          view.registerObserver(pathRoot, path, observer);
        }

        // We've already setup the observer; now we just need to figure out the
        // correct behavior right now on the first pass through.
        value = classStringForPath(context, parsedPath, options);

        if (value) {
          ret.push(value);

          // Make sure we save the current value so that it can be removed if the
          // observer fires.
          oldClass = value;
        }
      });

      return ret;
    }

    __exports__.bind = bind;
    __exports__._triageMustacheHelper = _triageMustacheHelper;
    __exports__.resolveHelper = resolveHelper;
    __exports__.bindHelper = bindHelper;
    __exports__.boundIfHelper = boundIfHelper;
    __exports__.unboundIfHelper = unboundIfHelper;
    __exports__.withHelper = withHelper;
    __exports__.ifHelper = ifHelper;
    __exports__.unlessHelper = unlessHelper;
    __exports__.bindAttrHelper = bindAttrHelper;
    __exports__.bindAttrHelperDeprecated = bindAttrHelperDeprecated;
    __exports__.bindClasses = bindClasses;
  });
enifed("ember-handlebars/helpers/collection",
  ["ember-metal/core","ember-metal/utils","ember-handlebars-compiler","ember-runtime/system/string","ember-metal/property_get","ember-handlebars/ext","ember-handlebars/helpers/view","ember-metal/computed","ember-views/views/collection_view","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __exports__) {
    "use strict";
    /**
    @module ember
    @submodule ember-handlebars
    */

    var Ember = __dependency1__["default"];
    // Ember.assert, Ember.deprecate
    var inspect = __dependency2__.inspect;

    // var emberAssert = Ember.assert;
        // emberDeprecate = Ember.deprecate;

    var EmberHandlebars = __dependency3__["default"];
    var helpers = EmberHandlebars.helpers;

    var fmt = __dependency4__.fmt;
    var get = __dependency5__.get;
    var handlebarsGet = __dependency6__.handlebarsGet;
    var handlebarsGetView = __dependency6__.handlebarsGetView;
    var ViewHelper = __dependency7__.ViewHelper;
    var computed = __dependency8__.computed;
    var CollectionView = __dependency9__["default"];

    var alias = computed.alias;
    /**
      `{{collection}}` is a `Ember.Handlebars` helper for adding instances of
      `Ember.CollectionView` to a template. See [Ember.CollectionView](/api/classes/Ember.CollectionView.html)
       for additional information on how a `CollectionView` functions.

      `{{collection}}`'s primary use is as a block helper with a `contentBinding`
      option pointing towards an `Ember.Array`-compatible object. An `Ember.View`
      instance will be created for each item in its `content` property. Each view
      will have its own `content` property set to the appropriate item in the
      collection.

      The provided block will be applied as the template for each item's view.

      Given an empty `<body>` the following template:

      ```handlebars
      {{! application.hbs }}
      {{#collection content=model}}
        Hi {{view.content.name}}
      {{/collection}}
      ```

      And the following application code

      ```javascript
      App = Ember.Application.create();
      App.ApplicationRoute = Ember.Route.extend({
        model: function(){
          return [{name: 'Yehuda'},{name: 'Tom'},{name: 'Peter'}];
        }
      });
      ```

      The following HTML will result:

      ```html
      <div class="ember-view">
        <div class="ember-view">Hi Yehuda</div>
        <div class="ember-view">Hi Tom</div>
        <div class="ember-view">Hi Peter</div>
      </div>
      ```

      ### Non-block version of collection

      If you provide an `itemViewClass` option that has its own `template` you may
      omit the block.

      The following template:

      ```handlebars
      {{! application.hbs }}
      {{collection content=model itemViewClass="an-item"}}
      ```

      And application code

      ```javascript
      App = Ember.Application.create();
      App.ApplicationRoute = Ember.Route.extend({
        model: function(){
          return [{name: 'Yehuda'},{name: 'Tom'},{name: 'Peter'}];
        }
      });

      App.AnItemView = Ember.View.extend({
        template: Ember.Handlebars.compile("Greetings {{view.content.name}}")
      });
      ```

      Will result in the HTML structure below

      ```html
      <div class="ember-view">
        <div class="ember-view">Greetings Yehuda</div>
        <div class="ember-view">Greetings Tom</div>
        <div class="ember-view">Greetings Peter</div>
      </div>
      ```

      ### Specifying a CollectionView subclass

      By default the `{{collection}}` helper will create an instance of
      `Ember.CollectionView`. You can supply a `Ember.CollectionView` subclass to
      the helper by passing it as the first argument:

      ```handlebars
      {{#collection "my-custom-collection" content=model}}
        Hi {{view.content.name}}
      {{/collection}}
      ```

      This example would look for the class `App.MyCustomCollection`.

      ### Forwarded `item.*`-named Options

      As with the `{{view}}`, helper options passed to the `{{collection}}` will be
      set on the resulting `Ember.CollectionView` as properties. Additionally,
      options prefixed with `item` will be applied to the views rendered for each
      item (note the camelcasing):

      ```handlebars
      {{#collection content=model
                    itemTagName="p"
                    itemClassNames="greeting"}}
        Howdy {{view.content.name}}
      {{/collection}}
      ```

      Will result in the following HTML structure:

      ```html
      <div class="ember-view">
        <p class="ember-view greeting">Howdy Yehuda</p>
        <p class="ember-view greeting">Howdy Tom</p>
        <p class="ember-view greeting">Howdy Peter</p>
      </div>
      ```

      @method collection
      @for Ember.Handlebars.helpers
      @param {String} path
      @param {Hash} options
      @return {String} HTML string
      @deprecated Use `{{each}}` helper instead.
    */
    function collectionHelper(path, options) {
      Ember.deprecate("Using the {{collection}} helper without specifying a class has been deprecated as the {{each}} helper now supports the same functionality.", path !== 'collection');

      // If no path is provided, treat path param as options.
      if (path && path.data && path.data.isRenderData) {
        options = path;
        path = undefined;
        Ember.assert("You cannot pass more than one argument to the collection helper", arguments.length === 1);
      } else {
        Ember.assert("You cannot pass more than one argument to the collection helper", arguments.length === 2);
      }

      var fn        = options.fn,
          data      = options.data,
          inverse   = options.inverse,
          view      = options.data.view,
          // This should be deterministic, and should probably come from a
          // parent view and not the controller.
          container = (view.controller && view.controller.container ? view.controller.container : view.container);

      // If passed a path string, convert that into an object.
      // Otherwise, just default to the standard class.
      var collectionClass;
      if (path) {
        collectionClass = handlebarsGetView(this, path, container, options);
        Ember.assert(fmt("%@ #collection: Could not find collection class %@", [data.view, path]), !!collectionClass);
      }
      else {
        collectionClass = CollectionView;
      }

      var hash = options.hash;
      var itemHash = {};
      var match;

      // Extract item view class if provided else default to the standard class
      var collectionPrototype = collectionClass.proto();
      var itemViewClass;

      if (hash.itemView) {
        itemViewClass = handlebarsGetView(this, hash.itemView, container, options);
      } else if (hash.itemViewClass) {
        itemViewClass = handlebarsGetView(collectionPrototype, hash.itemViewClass, container, options);
      } else {
        itemViewClass = handlebarsGetView(collectionPrototype, collectionPrototype.itemViewClass, container, options);
      }

      Ember.assert(fmt("%@ #collection: Could not find itemViewClass %@", [data.view, itemViewClass]), !!itemViewClass);

      delete hash.itemViewClass;
      delete hash.itemView;

      // Go through options passed to the {{collection}} helper and extract options
      // that configure item views instead of the collection itself.
      for (var prop in hash) {
        if (hash.hasOwnProperty(prop)) {
          match = prop.match(/^item(.)(.*)$/);

          if (match && prop !== 'itemController') {
            // Convert itemShouldFoo -> shouldFoo
            itemHash[match[1].toLowerCase() + match[2]] = hash[prop];
            // Delete from hash as this will end up getting passed to the
            // {{view}} helper method.
            delete hash[prop];
          }
        }
      }

      if (fn) {
        itemHash.template = fn;
        delete options.fn;
      }

      var emptyViewClass;
      if (inverse && inverse !== EmberHandlebars.VM.noop) {
        emptyViewClass = get(collectionPrototype, 'emptyViewClass');
        emptyViewClass = emptyViewClass.extend({
              template: inverse,
              tagName: itemHash.tagName
        });
      } else if (hash.emptyViewClass) {
        emptyViewClass = handlebarsGetView(this, hash.emptyViewClass, container, options);
      }
      if (emptyViewClass) { hash.emptyView = emptyViewClass; }

      if (hash.keyword) {
        itemHash._context = this;
      } else {
        itemHash._context = alias('content');
      }

      var viewOptions = ViewHelper.propertiesFromHTMLOptions({ data: data, hash: itemHash }, this);
      hash.itemViewClass = itemViewClass.extend(viewOptions);

      options.helperName = options.helperName || 'collection';

      return helpers.view.call(this, collectionClass, options);
    }

    __exports__["default"] = collectionHelper;
  });
enifed("ember-handlebars/helpers/debug",
  ["ember-metal/core","ember-metal/utils","ember-metal/logger","ember-metal/property_get","ember-handlebars/ext","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    /*jshint debug:true*/

    /**
    @module ember
    @submodule ember-handlebars
    */
    var Ember = __dependency1__["default"];
    // Ember.FEATURES,
    var inspect = __dependency2__.inspect;
    var Logger = __dependency3__["default"];

    var get = __dependency4__.get;
    var normalizePath = __dependency5__.normalizePath;
    var handlebarsGet = __dependency5__.handlebarsGet;

    var a_slice = [].slice;

    /**
      `log` allows you to output the value of variables in the current rendering
      context. `log` also accepts primitive types such as strings or numbers.

      ```handlebars
      {{log "myVariable:" myVariable }}
      ```

      @method log
      @for Ember.Handlebars.helpers
      @param {String} property
    */
    function logHelper() {
      var params = a_slice.call(arguments, 0, -1);
      var options = arguments[arguments.length - 1];
      var logger = Logger.log;
      var values = [];
      var allowPrimitives = true;

      for (var i = 0; i < params.length; i++) {
        var type = options.types[i];

        if (type === 'ID' || !allowPrimitives) {
          var context = (options.contexts && options.contexts[i]) || this;
          var normalized = normalizePath(context, params[i], options.data);

          if (normalized.path === 'this') {
            values.push(normalized.root);
          } else {
            values.push(handlebarsGet(normalized.root, normalized.path, options));
          }
        } else {
          values.push(params[i]);
        }
      }

      logger.apply(logger, values);
    }

    /**
      Execute the `debugger` statement in the current context.

      ```handlebars
      {{debugger}}
      ```

      Before invoking the `debugger` statement, there
      are a few helpful variables defined in the
      body of this helper that you can inspect while
      debugging that describe how and where this
      helper was invoked:

      - templateContext: this is most likely a controller
        from which this template looks up / displays properties
      - typeOfTemplateContext: a string description of
        what the templateContext is

      For example, if you're wondering why a value `{{foo}}`
      isn't rendering as expected within a template, you
      could place a `{{debugger}}` statement, and when
      the `debugger;` breakpoint is hit, you can inspect
      `templateContext`, determine if it's the object you
      expect, and/or evaluate expressions in the console
      to perform property lookups on the `templateContext`:

      ```
        > templateContext.get('foo') // -> "<value of {{foo}}>"
      ```

      @method debugger
      @for Ember.Handlebars.helpers
      @param {String} property
    */
    function debuggerHelper(options) {

      // These are helpful values you can inspect while debugging.
      var templateContext = this;
      var typeOfTemplateContext = inspect(templateContext);
      Ember.Logger.info('Use `this` to access the context of the calling template.');

      debugger;
    }

    __exports__.logHelper = logHelper;
    __exports__.debuggerHelper = debuggerHelper;
  });
enifed("ember-handlebars/helpers/each",
  ["ember-metal/core","ember-handlebars-compiler","ember-runtime/system/string","ember-metal/property_get","ember-metal/property_set","ember-views/views/collection_view","ember-metal/binding","ember-runtime/mixins/controller","ember-runtime/controllers/array_controller","ember-runtime/mixins/array","ember-runtime/copy","ember-metal/run_loop","ember-metal/events","ember-handlebars/ext","ember-metal/computed","ember-metal/observer","ember-handlebars/views/metamorph_view","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __dependency11__, __dependency12__, __dependency13__, __dependency14__, __dependency15__, __dependency16__, __dependency17__, __exports__) {
    "use strict";

    /**
    @module ember
    @submodule ember-handlebars
    */
    var Ember = __dependency1__["default"];
    // Ember.assert;, Ember.K
    var K = Ember.K;

    var EmberHandlebars = __dependency2__["default"];
    var helpers = EmberHandlebars.helpers;

    var fmt = __dependency3__.fmt;
    var get = __dependency4__.get;
    var set = __dependency5__.set;
    var CollectionView = __dependency6__["default"];
    var Binding = __dependency7__.Binding;
    var ControllerMixin = __dependency8__["default"];
    var ArrayController = __dependency9__["default"];
    var EmberArray = __dependency10__["default"];
    var copy = __dependency11__["default"];
    var run = __dependency12__["default"];
    var on = __dependency13__.on;
    var handlebarsGet = __dependency14__.handlebarsGet;
    var computed = __dependency15__.computed;

    var addObserver = __dependency16__.addObserver;
    var removeObserver = __dependency16__.removeObserver;
    var addBeforeObserver = __dependency16__.addBeforeObserver;
    var removeBeforeObserver = __dependency16__.removeBeforeObserver;

    var _Metamorph = __dependency17__._Metamorph;
    var _MetamorphView = __dependency17__._MetamorphView;

    var EachView = CollectionView.extend(_Metamorph, {

      init: function() {
        var itemController = get(this, 'itemController');
        var binding;

        if (itemController) {
          var controller = get(this, 'controller.container').lookupFactory('controller:array').create({
            _isVirtual: true,
            parentController: get(this, 'controller'),
            itemController: itemController,
            target: get(this, 'controller'),
            _eachView: this
          });

          this.disableContentObservers(function() {
            set(this, 'content', controller);
            binding = new Binding('content', '_eachView.dataSource').oneWay();
            binding.connect(controller);
          });

          set(this, '_arrayController', controller);
        } else {
          this.disableContentObservers(function() {
            binding = new Binding('content', 'dataSource').oneWay();
            binding.connect(this);
          });
        }

        return this._super();
      },

      _assertArrayLike: function(content) {
        Ember.assert(fmt("The value that #each loops over must be an Array. You " +
                         "passed %@, but it should have been an ArrayController",
                         [content.constructor]),
                         !ControllerMixin.detect(content) ||
                           (content && content.isGenerated) ||
                           content instanceof ArrayController);
        Ember.assert(fmt("The value that #each loops over must be an Array. You passed %@", [(ControllerMixin.detect(content) && content.get('model') !== undefined) ? fmt("'%@' (wrapped in %@)", [content.get('model'), content]) : content]), EmberArray.detect(content));
      },

      disableContentObservers: function(callback) {
        removeBeforeObserver(this, 'content', null, '_contentWillChange');
        removeObserver(this, 'content', null, '_contentDidChange');

        callback.call(this);

        addBeforeObserver(this, 'content', null, '_contentWillChange');
        addObserver(this, 'content', null, '_contentDidChange');
      },

      itemViewClass: _MetamorphView,
      emptyViewClass: _MetamorphView,

      createChildView: function(view, attrs) {
        view = this._super(view, attrs);

        // At the moment, if a container view subclass wants
        // to insert keywords, it is responsible for cloning
        // the keywords hash. This will be fixed momentarily.
        var keyword = get(this, 'keyword');
        var content = get(view, 'content');

        if (keyword) {
          var data = get(view, 'templateData');

          data = copy(data);
          data.keywords = view.cloneKeywords();
          set(view, 'templateData', data);

          // In this case, we do not bind, because the `content` of
          // a #each item cannot change.
          data.keywords[keyword] = content;
        }

        // If {{#each}} is looping over an array of controllers,
        // point each child view at their respective controller.
        if (content && content.isController) {
          set(view, 'controller', content);
        }

        return view;
      },

      destroy: function() {
        if (!this._super()) { return; }

        var arrayController = get(this, '_arrayController');

        if (arrayController) {
          arrayController.destroy();
        }

        return this;
      }
    });

    var GroupedEach = EmberHandlebars.GroupedEach = function(context, path, options) {
      var self = this;
      var normalized = EmberHandlebars.normalizePath(context, path, options.data);

      this.context = context;
      this.path = path;
      this.options = options;
      this.template = options.fn;
      this.containingView = options.data.view;
      this.normalizedRoot = normalized.root;
      this.normalizedPath = normalized.path;
      this.content = this.lookupContent();

      this.addContentObservers();
      this.addArrayObservers();

      this.containingView.on('willClearRender', function() {
        self.destroy();
      });
    };

    GroupedEach.prototype = {
      contentWillChange: function() {
        this.removeArrayObservers();
      },

      contentDidChange: function() {
        this.content = this.lookupContent();
        this.addArrayObservers();
        this.rerenderContainingView();
      },

      contentArrayWillChange: K,

      contentArrayDidChange: function() {
        this.rerenderContainingView();
      },

      lookupContent: function() {
        return handlebarsGet(this.normalizedRoot, this.normalizedPath, this.options);
      },

      addArrayObservers: function() {
        if (!this.content) { return; }

        this.content.addArrayObserver(this, {
          willChange: 'contentArrayWillChange',
          didChange: 'contentArrayDidChange'
        });
      },

      removeArrayObservers: function() {
        if (!this.content) { return; }

        this.content.removeArrayObserver(this, {
          willChange: 'contentArrayWillChange',
          didChange: 'contentArrayDidChange'
        });
      },

      addContentObservers: function() {
        addBeforeObserver(this.normalizedRoot, this.normalizedPath, this, this.contentWillChange);
        addObserver(this.normalizedRoot, this.normalizedPath, this, this.contentDidChange);
      },

      removeContentObservers: function() {
        removeBeforeObserver(this.normalizedRoot, this.normalizedPath, this.contentWillChange);
        removeObserver(this.normalizedRoot, this.normalizedPath, this.contentDidChange);
      },

      render: function() {
        if (!this.content) { return; }

        var content = this.content;
        var contentLength = get(content, 'length');
        var options = this.options;
        var data = options.data;
        var template = this.template;

        data.insideEach = true;
        for (var i = 0; i < contentLength; i++) {
          var context = content.objectAt(i);
          options.data.keywords[options.hash.keyword] = context;
          template(context, { data: data });
        }
      },

      rerenderContainingView: function() {
        var self = this;
        run.scheduleOnce('render', this, function() {
          // It's possible it's been destroyed after we enqueued a re-render call.
          if (!self.destroyed) {
            self.containingView.rerender();
          }
        });
      },

      destroy: function() {
        this.removeContentObservers();
        if (this.content) {
          this.removeArrayObservers();
        }
        this.destroyed = true;
      }
    };

    /**
      The `{{#each}}` helper loops over elements in a collection. It is an extension
      of the base Handlebars `{{#each}}` helper.

      The default behavior of `{{#each}}` is to yield its inner block once for every
      item in an array. Each yield will provide the item as the context of the block.

      ```javascript
      var developers = [{name: 'Yehuda'},{name: 'Tom'}, {name: 'Paul'}];
      ```

      ```handlebars
      {{#each developers}}
        {{name}}
        {{! `this` is each developer }}
      {{/each}}
      ```

      `{{#each}}` supports an alternative syntax with element naming. This preserves
      context of the yielded block:

      ```handlebars
      {{#each person in developers}}
        {{person.name}}
        {{! `this` is whatever it was outside the #each }}
      {{/each}}
      ```

      The same rules apply to arrays of primitives, but the items may need to be
      references with `{{this}}`.

      ```javascript
      var developerNames = ['Yehuda', 'Tom', 'Paul']
      ```

      ```handlebars
      {{#each developerNames}}
        {{this}}
      {{/each}}
      ```

      ### {{else}} condition

      `{{#each}}` can have a matching `{{else}}`. The contents of this block will render
      if the collection is empty.

      ```
      {{#each person in developers}}
        {{person.name}}
      {{else}}
        <p>Sorry, nobody is available for this task.</p>
      {{/each}}
      ```

      ### Specifying an alternative view for each item

      `itemViewClass` can control which view will be used during the render of each
      item's template.

      The following template:

      ```handlebars
      <ul>
      {{#each developers itemViewClass="person"}}
        {{name}}
      {{/each}}
      </ul>
      ```

      Will use the following view for each item

      ```javascript
      App.PersonView = Ember.View.extend({
        tagName: 'li'
      });
      ```

      Resulting in HTML output that looks like the following:

      ```html
      <ul>
        <li class="ember-view">Yehuda</li>
        <li class="ember-view">Tom</li>
        <li class="ember-view">Paul</li>
      </ul>
      ```

      `itemViewClass` also enables a non-block form of `{{each}}`. The view
      must {{#crossLink "Ember.View/toc_templates"}}provide its own template{{/crossLink}},
      and then the block should be dropped. An example that outputs the same HTML
      as the previous one:

      ```javascript
      App.PersonView = Ember.View.extend({
        tagName: 'li',
        template: '{{name}}'
      });
      ```

      ```handlebars
      <ul>
        {{each developers itemViewClass="person"}}
      </ul>
      ```

      ### Specifying an alternative view for no items (else)

      The `emptyViewClass` option provides the same flexibility to the `{{else}}`
      case of the each helper.

      ```javascript
      App.NoPeopleView = Ember.View.extend({
        tagName: 'li',
        template: 'No person is available, sorry'
      });
      ```

      ```handlebars
      <ul>
      {{#each developers emptyViewClass="no-people"}}
        <li>{{name}}</li>
      {{/each}}
      </ul>
      ```

      ### Wrapping each item in a controller

      Controllers in Ember manage state and decorate data. In many cases,
      providing a controller for each item in a list can be useful.
      Specifically, an {{#crossLink "Ember.ObjectController"}}Ember.ObjectController{{/crossLink}}
      should probably be used. Item controllers are passed the item they
      will present as a `model` property, and an object controller will
      proxy property lookups to `model` for us.

      This allows state and decoration to be added to the controller
      while any other property lookups are delegated to the model. An example:

      ```javascript
      App.RecruitController = Ember.ObjectController.extend({
        isAvailableForHire: function() {
          return !this.get('isEmployed') && this.get('isSeekingWork');
        }.property('isEmployed', 'isSeekingWork')
      })
      ```

      ```handlebars
      {{#each person in developers itemController="recruit"}}
        {{person.name}} {{#if person.isAvailableForHire}}Hire me!{{/if}}
      {{/each}}
      ```

      ### (Experimental) Grouped Each

      If a list's membership often changes, but properties of items in that
      group rarely change, a significant improvement in template rendering
      time can be achieved by using the experimental [group helper](https://github.com/emberjs/group-helper).

      ```handlebars
      {{#group}}
        {{#each people}}
          {{firstName}} {{lastName}}
        {{/each}}
      {{/group}}
      ```

      When the membership of `people` changes, or when any property changes, the entire
      `{{#group}}` block will be re-rendered.

      An `{{#each}}` inside the `{{#group}}` helper can opt-out of the special group
      behavior by passing the `groupedRows` option. For example:

      ```handlebars
      {{#group}}
        {{#each dealers}}
          {{! uses group's special behavior }}
          {{firstName}} {{lastName}}
        {{/each}}

        {{#each car in cars groupedRows=true}}
          {{! does not use group's special behavior }}
          {{car.make}} {{car.model}} {{car.color}}
        {{/each}}
      {{/group}}
      ```

      Any change to the `dealers` collection will cause the entire group to be re-rendered.
      Changes to the `cars` collection will be re-rendered individually, as they are with
      normal `{{#each}}` usage.

      `{{#group}}` is implemented with an `itemViewClass`, so specifying an `itemViewClass`
      on an `{{#each}}` will also disable the special re-rendering behavior.

      @method each
      @for Ember.Handlebars.helpers
      @param [name] {String} name for item (used with `in`)
      @param [path] {String} path
      @param [options] {Object} Handlebars key/value pairs of options
      @param [options.itemViewClass] {String} a path to a view class used for each item
      @param [options.emptyViewClass] {String} a path to a view class used for each item
      @param [options.itemController] {String} name of a controller to be created for each item
      @param [options.groupedRows] {boolean} enable normal item-by-item rendering when inside a `#group` helper
    */
    function eachHelper(path, options) {
      var ctx;
      var helperName = 'each';

      if (arguments.length === 4) {
        Ember.assert("If you pass more than one argument to the each helper, it must be in the form #each foo in bar", arguments[1] === "in");

        var keywordName = arguments[0];


        options = arguments[3];
        path = arguments[2];

        helperName += ' ' + keywordName + ' in ' + path;

        if (path === '') { path = "this"; }

        options.hash.keyword = keywordName;

      } else if (arguments.length === 1) {
        options = path;
        path = 'this';
      } else {
        helperName += ' ' + path;
      }

      options.hash.dataSourceBinding = path;
      // Set up emptyView as a metamorph with no tag
      //options.hash.emptyViewClass = Ember._MetamorphView;

      // can't rely on this default behavior when use strict
      ctx = this || window;

      options.helperName = options.helperName || helperName;

      if (options.data.insideGroup && !options.hash.groupedRows && !options.hash.itemViewClass) {
        new GroupedEach(ctx, path, options).render();
      } else {
        return helpers.collection.call(ctx, EmberHandlebars.EachView, options);
      }
    }

    __exports__.EachView = EachView;
    __exports__.GroupedEach = GroupedEach;
    __exports__.eachHelper = eachHelper;
  });
enifed("ember-handlebars/helpers/loc",
  ["ember-runtime/system/string","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var loc = __dependency1__.loc;

    /**
    @module ember
    @submodule ember-handlebars
    */

    /**
      Calls [Ember.String.loc](/api/classes/Ember.String.html#method_loc) with the
      provided string.

      This is a convenient way to localize text within a template:

      ```javascript
      Ember.STRINGS = {
        '_welcome_': 'Bonjour'
      };
      ```

      ```handlebars
      <div class='message'>
        {{loc '_welcome_'}}
      </div>
      ```

      ```html
      <div class='message'>
        Bonjour
      </div>
      ```

      See [Ember.String.loc](/api/classes/Ember.String.html#method_loc) for how to
      set up localized string references.

      @method loc
      @for Ember.Handlebars.helpers
      @param {String} str The string to format
      @see {Ember.String#loc}
    */
    __exports__["default"] = loc;
  });
enifed("ember-handlebars/helpers/partial",
  ["ember-metal/core","ember-metal/is_none","ember-handlebars/ext","ember-handlebars/helpers/binding","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    // Ember.assert
    // var emberAssert = Ember.assert;

    var isNone = __dependency2__.isNone;
    var handlebarsGet = __dependency3__.handlebarsGet;
    var bind = __dependency4__.bind;

    /**
    @module ember
    @submodule ember-handlebars
    */

    /**
      The `partial` helper renders another template without
      changing the template context:

      ```handlebars
      {{foo}}
      {{partial "nav"}}
      ```

      The above example template will render a template named
      "_nav", which has the same context as the parent template
      it's rendered into, so if the "_nav" template also referenced
      `{{foo}}`, it would print the same thing as the `{{foo}}`
      in the above example.

      If a "_nav" template isn't found, the `partial` helper will
      fall back to a template named "nav".

      ## Bound template names

      The parameter supplied to `partial` can also be a path
      to a property containing a template name, e.g.:

      ```handlebars
      {{partial someTemplateName}}
      ```

      The above example will look up the value of `someTemplateName`
      on the template context (e.g. a controller) and use that
      value as the name of the template to render. If the resolved
      value is falsy, nothing will be rendered. If `someTemplateName`
      changes, the partial will be re-rendered using the new template
      name.

      ## Setting the partial's context with `with`

      The `partial` helper can be used in conjunction with the `with`
      helper to set a context that will be used by the partial:

      ```handlebars
      {{#with currentUser}}
        {{partial "user_info"}}
      {{/with}}
      ```

      @method partial
      @for Ember.Handlebars.helpers
      @param {String} partialName the name of the template to render minus the leading underscore
    */

    __exports__["default"] = function partialHelper(name, options) {

      var context = (options.contexts && options.contexts.length) ? options.contexts[0] : this;

      options.helperName = options.helperName || 'partial';

      if (options.types[0] === "ID") {
        // Helper was passed a property path; we need to
        // create a binding that will re-render whenever
        // this property changes.
        options.fn = function(context, fnOptions) {
          var partialName = handlebarsGet(context, name, fnOptions);
          renderPartial(context, partialName, fnOptions);
        };

        return bind.call(context, name, options, true, exists);
      } else {
        // Render the partial right into parent template.
        renderPartial(context, name, options);
      }
    }

    function exists(value) {
      return !isNone(value);
    }

    function renderPartial(context, name, options) {
      var nameParts = name.split("/");
      var lastPart = nameParts[nameParts.length - 1];

      nameParts[nameParts.length - 1] = "_" + lastPart;

      var view = options.data.view;
      var underscoredName = nameParts.join("/");
      var template = view.templateForName(underscoredName);
      var deprecatedTemplate = !template && view.templateForName(name);

      Ember.assert("Unable to find partial with name '"+name+"'.", template || deprecatedTemplate);

      template = template || deprecatedTemplate;

      template(context, { data: options.data });
    }
  });
enifed("ember-handlebars/helpers/shared",
  ["ember-handlebars/ext","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var handlebarsGet = __dependency1__.handlebarsGet;

    __exports__["default"] = function resolvePaths(options) {
      var ret = [];
      var contexts = options.contexts;
      var roots = options.roots;
      var data = options.data;

      for (var i=0, l=contexts.length; i<l; i++) {
        ret.push(handlebarsGet(roots[i], contexts[i], { data: data }));
      }

      return ret;
    }
  });
enifed("ember-handlebars/helpers/template",
  ["ember-metal/core","ember-handlebars-compiler","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    // Ember.deprecate;

    var EmberHandlebars = __dependency2__["default"];
    var helpers = EmberHandlebars.helpers;
    /**
    @module ember
    @submodule ember-handlebars
    */

    /**
      @deprecated
      @method template
      @for Ember.Handlebars.helpers
      @param {String} templateName the template to render
    */
    __exports__["default"] = function templateHelper(name, options) {
      Ember.deprecate("The `template` helper has been deprecated in favor of the `partial` helper. Please use `partial` instead, which will work the same way.");

      options.helperName = options.helperName || 'template';

      return helpers.partial.apply(this, arguments);
    }
  });
enifed("ember-handlebars/helpers/unbound",
  ["ember-handlebars-compiler","ember-handlebars/helpers/binding","ember-handlebars/ext","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    /*globals Handlebars */

    /**
    @module ember
    @submodule ember-handlebars
    */

    var EmberHandlebars = __dependency1__["default"];
    var helpers = EmberHandlebars.helpers;

    var resolveHelper = __dependency2__.resolveHelper;
    var handlebarsGet = __dependency3__.handlebarsGet;

    var slice = [].slice;

    /**
      `unbound` allows you to output a property without binding. *Important:* The
      output will not be updated if the property changes. Use with caution.

      ```handlebars
      <div>{{unbound somePropertyThatDoesntChange}}</div>
      ```

      `unbound` can also be used in conjunction with a bound helper to
      render it in its unbound form:

      ```handlebars
      <div>{{unbound helperName somePropertyThatDoesntChange}}</div>
      ```

      @method unbound
      @for Ember.Handlebars.helpers
      @param {String} property
      @return {String} HTML string
    */
    __exports__["default"] = function unboundHelper(property, fn) {
      var options = arguments[arguments.length - 1];
      var container = options.data.view.container;
      var helper, context, out, ctx;

      ctx = this;
      if (arguments.length > 2) {
        // Unbound helper call.
        options.data.isUnbound = true;
        helper = resolveHelper(container, property) || helpers.helperMissing;
        out = helper.apply(ctx, slice.call(arguments, 1));
        delete options.data.isUnbound;
        return out;
      }

      context = (fn.contexts && fn.contexts.length) ? fn.contexts[0] : ctx;
      return handlebarsGet(context, property, fn);
    }
  });
enifed("ember-handlebars/helpers/view",
  ["ember-metal/core","ember-runtime/system/object","ember-metal/property_get","ember-metal/property_set","ember-metal/mixin","ember-views/system/jquery","ember-views/views/view","ember-metal/binding","ember-metal/keys","ember-handlebars/ext","ember-runtime/system/string","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __dependency11__, __exports__) {
    "use strict";
    /*globals Handlebars */

    /**
    @module ember
    @submodule ember-handlebars
    */

    var Ember = __dependency1__["default"];
    // Ember.warn, Ember.assert
    // var emberWarn = Ember.warn, emberAssert = Ember.assert;

    var EmberObject = __dependency2__["default"];
    var get = __dependency3__.get;
    var set = __dependency4__.set;
    var IS_BINDING = __dependency5__.IS_BINDING;
    var jQuery = __dependency6__["default"];
    var View = __dependency7__["default"];
    var isGlobalPath = __dependency8__.isGlobalPath;
    var keys = __dependency9__["default"];
    var normalizePath = __dependency10__.normalizePath;
    var handlebarsGet = __dependency10__.handlebarsGet;
    var handlebarsGetView = __dependency10__.handlebarsGetView;
    var EmberString = __dependency11__["default"];


    var LOWERCASE_A_Z = /^[a-z]/;
    var VIEW_PREFIX = /^view\./;

    function makeBindings(thisContext, options) {
      var hash = options.hash;
      var hashType = options.hashTypes;

      for (var prop in hash) {
        if (hashType[prop] === 'ID') {

          var value = hash[prop];

          if (IS_BINDING.test(prop)) {
            Ember.warn("You're attempting to render a view by passing " + prop + "=" + value + " to a view helper, but this syntax is ambiguous. You should either surround " + value + " in quotes or remove `Binding` from " + prop + ".");
          } else {
            hash[prop + 'Binding'] = value;
            hashType[prop + 'Binding'] = 'STRING';
            delete hash[prop];
            delete hashType[prop];
          }
        }
      }

      if (hash.hasOwnProperty('idBinding')) {
        // id can't be bound, so just perform one-time lookup.
        hash.id = handlebarsGet(thisContext, hash.idBinding, options);
        hashType.id = 'STRING';
        delete hash.idBinding;
        delete hashType.idBinding;
      }
    }

    var ViewHelper = EmberObject.create({
      propertiesFromHTMLOptions: function(options) {
        var hash    = options.hash;
        var data    = options.data;
        var classes = hash['class'];

        var extensions = {
          helperName: options.helperName || ''
        };

        if (hash.id) {
          extensions.elementId = hash.id;
        }

        if (hash.tag) {
          extensions.tagName = hash.tag;
        }

        if (classes) {
          classes = classes.split(' ');
          extensions.classNames = classes;
        }

        if (hash.classBinding) {
          extensions.classNameBindings = hash.classBinding.split(' ');
        }

        if (hash.classNameBindings) {
          if (extensions.classNameBindings === undefined) {
            extensions.classNameBindings = [];
          }
          extensions.classNameBindings = extensions.classNameBindings.concat(hash.classNameBindings.split(' '));
        }

        if (hash.attributeBindings) {
          Ember.assert("Setting 'attributeBindings' via Handlebars is not allowed. Please subclass Ember.View and set it there instead.");
          extensions.attributeBindings = null;
        }

        // Set the proper context for all bindings passed to the helper. This applies to regular attribute bindings
        // as well as class name bindings. If the bindings are local, make them relative to the current context
        // instead of the view.
        var path;
        var hashKeys = keys(hash);

        for (var i = 0, l = hashKeys.length; i < l; i++) {
          var prop      = hashKeys[i];
          var isBinding = IS_BINDING.test(prop);

          if (prop !== 'classNameBindings') {
            extensions[prop] = hash[prop];
          }

          // Test if the property ends in "Binding"
          if (isBinding && typeof extensions[prop] === 'string') {
            path = this.contextualizeBindingPath(hash[prop], data);
            if (path) {
              extensions[prop] = path;
            }
          }
        }

        if (extensions.classNameBindings) {
          // Evaluate the context of class name bindings:
          for (var j = 0, k = extensions.classNameBindings.length; j < k; j++) {
            var full = extensions.classNameBindings[j];

            if (typeof full === 'string') {
              // Contextualize the path of classNameBinding so this:
              //
              //     classNameBinding="isGreen:green"
              //
              // is converted to this:
              //
              //     classNameBinding="_parentView.context.isGreen:green"
              var parsedPath = View._parsePropertyPath(full);
              if (parsedPath.path !== '') {
                path = this.contextualizeBindingPath(parsedPath.path, data);
                if (path) {
                  extensions.classNameBindings[j] = path + parsedPath.classNames;
                }
              }
            }
          }
        }

        return extensions;
      },

      // Transform bindings from the current context to a context that can be evaluated within the view.
      // Returns null if the path shouldn't be changed.
      //
      // TODO: consider the addition of a prefix that would allow this method to return `path`.
      contextualizeBindingPath: function(path, data) {
        var normalized = normalizePath(null, path, data);
        if (normalized.isKeyword) {
          return 'templateData.keywords.' + path;
        } else if (isGlobalPath(path)) {
          return null;
        } else if (path === 'this' || path === '') {
          return '_parentView.context';
        } else {
          return '_parentView.context.' + path;
        }
      },

      helper: function(thisContext, path, options) {
        var data = options.data;
        var fn   = options.fn;
        var newView;
        var newViewProto;

        makeBindings(thisContext, options);

        var container = this.container || (data && data.view && data.view.container);
        newView = handlebarsGetView(thisContext, path, container, options);

        if (View.detectInstance(newView)) {
          newViewProto = newView;
        } else {
          newViewProto = newView.proto();
        }

        var viewOptions = this.propertiesFromHTMLOptions(options, thisContext);
        var currentView = data.view;
        viewOptions.templateData = data;

        if (fn) {
          Ember.assert("You cannot provide a template block if you also specified a templateName", !get(viewOptions, 'templateName') && !get(newViewProto, 'templateName'));
          viewOptions.template = fn;
        }

        // We only want to override the `_context` computed property if there is
        // no specified controller. See View#_context for more information.
        if (!newViewProto.controller && !newViewProto.controllerBinding && !viewOptions.controller && !viewOptions.controllerBinding) {
          viewOptions._context = thisContext;
        }

        currentView.appendChild(newView, viewOptions);
      },

      instanceHelper: function(thisContext, newView, options) {
        var data = options.data;
        var fn   = options.fn;

        makeBindings(thisContext, options);

        Ember.assert(
          'Only a instance of a view may be passed to the ViewHelper.instanceHelper',
          View.detectInstance(newView)
        );

        var viewOptions = this.propertiesFromHTMLOptions(options, thisContext);
        var currentView = data.view;
        viewOptions.templateData = data;

        if (fn) {
          Ember.assert("You cannot provide a template block if you also specified a templateName", !get(viewOptions, 'templateName') && !get(newView, 'templateName'));
          viewOptions.template = fn;
        }

        // We only want to override the `_context` computed property if there is
        // no specified controller. See View#_context for more information.
        if (!newView.controller && !newView.controllerBinding && !viewOptions.controller && !viewOptions.controllerBinding) {
          viewOptions._context = thisContext;
        }

        currentView.appendChild(newView, viewOptions);
      }
    });
    __exports__.ViewHelper = ViewHelper;
    /**
      `{{view}}` inserts a new instance of an `Ember.View` into a template passing its
      options to the `Ember.View`'s `create` method and using the supplied block as
      the view's own template.

      An empty `<body>` and the following template:

      ```handlebars
      A span:
      {{#view tagName="span"}}
        hello.
      {{/view}}
      ```

      Will result in HTML structure:

      ```html
      <body>
        <!-- Note: the handlebars template script
             also results in a rendered Ember.View
             which is the outer <div> here -->

        <div class="ember-view">
          A span:
          <span id="ember1" class="ember-view">
            Hello.
          </span>
        </div>
      </body>
      ```

      ### `parentView` setting

      The `parentView` property of the new `Ember.View` instance created through
      `{{view}}` will be set to the `Ember.View` instance of the template where
      `{{view}}` was called.

      ```javascript
      aView = Ember.View.create({
        template: Ember.Handlebars.compile("{{#view}} my parent: {{parentView.elementId}} {{/view}}")
      });

      aView.appendTo('body');
      ```

      Will result in HTML structure:

      ```html
      <div id="ember1" class="ember-view">
        <div id="ember2" class="ember-view">
          my parent: ember1
        </div>
      </div>
      ```

      ### Setting CSS id and class attributes

      The HTML `id` attribute can be set on the `{{view}}`'s resulting element with
      the `id` option. This option will _not_ be passed to `Ember.View.create`.

      ```handlebars
      {{#view tagName="span" id="a-custom-id"}}
        hello.
      {{/view}}
      ```

      Results in the following HTML structure:

      ```html
      <div class="ember-view">
        <span id="a-custom-id" class="ember-view">
          hello.
        </span>
      </div>
      ```

      The HTML `class` attribute can be set on the `{{view}}`'s resulting element
      with the `class` or `classNameBindings` options. The `class` option will
      directly set the CSS `class` attribute and will not be passed to
      `Ember.View.create`. `classNameBindings` will be passed to `create` and use
      `Ember.View`'s class name binding functionality:

      ```handlebars
      {{#view tagName="span" class="a-custom-class"}}
        hello.
      {{/view}}
      ```

      Results in the following HTML structure:

      ```html
      <div class="ember-view">
        <span id="ember2" class="ember-view a-custom-class">
          hello.
        </span>
      </div>
      ```

      ### Supplying a different view class

      `{{view}}` can take an optional first argument before its supplied options to
      specify a path to a custom view class.

      ```handlebars
      {{#view "custom"}}{{! will look up App.CustomView }}
        hello.
      {{/view}}
      ```

      The first argument can also be a relative path accessible from the current
      context.

      ```javascript
      MyApp = Ember.Application.create({});
      MyApp.OuterView = Ember.View.extend({
        innerViewClass: Ember.View.extend({
          classNames: ['a-custom-view-class-as-property']
        }),
        template: Ember.Handlebars.compile('{{#view view.innerViewClass}} hi {{/view}}')
      });

      MyApp.OuterView.create().appendTo('body');
      ```

      Will result in the following HTML:

      ```html
      <div id="ember1" class="ember-view">
        <div id="ember2" class="ember-view a-custom-view-class-as-property">
          hi
        </div>
      </div>
      ```

      ### Blockless use

      If you supply a custom `Ember.View` subclass that specifies its own template
      or provide a `templateName` option to `{{view}}` it can be used without
      supplying a block. Attempts to use both a `templateName` option and supply a
      block will throw an error.

      ```javascript
      var App = Ember.Application.create();
      App.WithTemplateDefinedView = Ember.View.extend({
        templateName: 'defined-template'
      });
      ```

      ```handlebars
      {{! application.hbs }}
      {{view 'with-template-defined'}}
      ```

      ```handlebars
      {{! defined-template.hbs }}
      Some content for the defined template view.
      ```

      ### `viewName` property

      You can supply a `viewName` option to `{{view}}`. The `Ember.View` instance
      will be referenced as a property of its parent view by this name.

      ```javascript
      aView = Ember.View.create({
        template: Ember.Handlebars.compile('{{#view viewName="aChildByName"}} hi {{/view}}')
      });

      aView.appendTo('body');
      aView.get('aChildByName') // the instance of Ember.View created by {{view}} helper
      ```

      @method view
      @for Ember.Handlebars.helpers
      @param {String} path
      @param {Hash} options
      @return {String} HTML string
    */
    function viewHelper(path, options) {
      Ember.assert("The view helper only takes a single argument", arguments.length <= 2);

      // If no path is provided, treat path param as options
      // and get an instance of the registered `view:toplevel`
      if (path && path.data && path.data.isRenderData) {
        options = path;
        if (options.data && options.data.view && options.data.view.container) {
          path = options.data.view.container.lookupFactory('view:toplevel');
        } else {
          path = View;
        }
      }

      options.helperName = options.helperName || 'view';

      return ViewHelper.helper(this, path, options);
    }

    __exports__.viewHelper = viewHelper;
  });
enifed("ember-handlebars/helpers/yield",
  ["ember-metal/core","ember-metal/property_get","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    /**
    @module ember
    @submodule ember-handlebars
    */

    var Ember = __dependency1__["default"];
    // var emberAssert = Ember.assert;

    var get = __dependency2__.get;

    /**
      `{{yield}}` denotes an area of a template that will be rendered inside
      of another template. It has two main uses:

      ### Use with `layout`
      When used in a Handlebars template that is assigned to an `Ember.View`
      instance's `layout` property Ember will render the layout template first,
      inserting the view's own rendered output at the `{{yield}}` location.

      An empty `<body>` and the following application code:

      ```javascript
      AView = Ember.View.extend({
        classNames: ['a-view-with-layout'],
        layout: Ember.Handlebars.compile('<div class="wrapper">{{yield}}</div>'),
        template: Ember.Handlebars.compile('<span>I am wrapped</span>')
      });

      aView = AView.create();
      aView.appendTo('body');
      ```

      Will result in the following HTML output:

      ```html
      <body>
        <div class='ember-view a-view-with-layout'>
          <div class="wrapper">
            <span>I am wrapped</span>
          </div>
        </div>
      </body>
      ```

      The `yield` helper cannot be used outside of a template assigned to an
      `Ember.View`'s `layout` property and will throw an error if attempted.

      ```javascript
      BView = Ember.View.extend({
        classNames: ['a-view-with-layout'],
        template: Ember.Handlebars.compile('{{yield}}')
      });

      bView = BView.create();
      bView.appendTo('body');

      // throws
      // Uncaught Error: assertion failed:
      // You called yield in a template that was not a layout
      ```

      ### Use with Ember.Component
      When designing components `{{yield}}` is used to denote where, inside the component's
      template, an optional block passed to the component should render:

      ```handlebars
      <!-- application.hbs -->
      {{#labeled-textfield value=someProperty}}
        First name:
      {{/labeled-textfield}}
      ```

      ```handlebars
      <!-- components/labeled-textfield.hbs -->
      <label>
        {{yield}} {{input value=value}}
      </label>
      ```

      Result:

      ```html
      <label>
        First name: <input type="text" />
      </label>
      ```

      @method yield
      @for Ember.Handlebars.helpers
      @param {Hash} options
      @return {String} HTML string
    */
    __exports__["default"] = function yieldHelper(options) {
      var view = options.data.view;

      while (view && !get(view, 'layout')) {
        if (view._contextView) {
          view = view._contextView;
        } else {
          view = get(view, '_parentView');
        }
      }

      Ember.assert("You called yield in a template that was not a layout", !!view);

      view._yield(this, options);
    }
  });
enifed("ember-handlebars/loader",
  ["ember-handlebars/component_lookup","ember-views/system/jquery","ember-metal/error","ember-runtime/system/lazy_load","ember-handlebars-compiler","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    /*globals Handlebars */

    var ComponentLookup = __dependency1__["default"];
    var jQuery = __dependency2__["default"];
    var EmberError = __dependency3__["default"];
    var onLoad = __dependency4__.onLoad;

    var EmberHandlebars = __dependency5__["default"];

    /**
    @module ember
    @submodule ember-handlebars
    */

    /**
      Find templates stored in the head tag as script tags and make them available
      to `Ember.CoreView` in the global `Ember.TEMPLATES` object. This will be run
      as as jQuery DOM-ready callback.

      Script tags with `text/x-handlebars` will be compiled
      with Ember's Handlebars and are suitable for use as a view's template.
      Those with type `text/x-raw-handlebars` will be compiled with regular
      Handlebars and are suitable for use in views' computed properties.

      @private
      @method bootstrap
      @for Ember.Handlebars
      @static
      @param ctx
    */
    function bootstrap(ctx) {
      var selectors = 'script[type="text/x-handlebars"], script[type="text/x-raw-handlebars"]';

      jQuery(selectors, ctx)
        .each(function() {
        // Get a reference to the script tag
        var script = jQuery(this);

        var compile = (script.attr('type') === 'text/x-raw-handlebars') ?
                      jQuery.proxy(Handlebars.compile, Handlebars) :
                      jQuery.proxy(EmberHandlebars.compile, EmberHandlebars);
        // Get the name of the script, used by Ember.View's templateName property.
        // First look for data-template-name attribute, then fall back to its
        // id if no name is found.
        var templateName = script.attr('data-template-name') || script.attr('id') || 'application';
        var template = compile(script.html());

        // Check if template of same name already exists
        if (Ember.TEMPLATES[templateName] !== undefined) {
          throw new EmberError('Template named "' + templateName  + '" already exists.');
        }

        // For templates which have a name, we save them and then remove them from the DOM
        Ember.TEMPLATES[templateName] = template;

        // Remove script tag from DOM
        script.remove();
      });
    }

    function _bootstrap() {
      bootstrap( jQuery(document) );
    }

    function registerComponentLookup(container) {
      container.register('component-lookup:main', ComponentLookup);
    }

    /*
      We tie this to application.load to ensure that we've at least
      attempted to bootstrap at the point that the application is loaded.

      We also tie this to document ready since we're guaranteed that all
      the inline templates are present at this point.

      There's no harm to running this twice, since we remove the templates
      from the DOM after processing.
    */

    onLoad('Ember.Application', function(Application) {
      Application.initializer({
        name: 'domTemplates',
        initialize: _bootstrap
      });

      Application.initializer({
        name: 'registerComponentLookup',
        after: 'domTemplates',
        initialize: registerComponentLookup
      });
    });

    __exports__["default"] = bootstrap;
  });
enifed("ember-handlebars/string",
  ["ember-runtime/system/string","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    // required so we can extend this object.
    var EmberStringUtils = __dependency1__["default"];

    /**
      Mark a string as safe for unescaped output with Handlebars. If you
      return HTML from a Handlebars helper, use this function to
      ensure Handlebars does not escape the HTML.

      ```javascript
      Ember.String.htmlSafe('<div>someString</div>')
      ```

      @method htmlSafe
      @for Ember.String
      @static
      @return {Handlebars.SafeString} a string that will not be html escaped by Handlebars
    */
    function htmlSafe(str) {
      if (typeof str !== 'string') {
        str = ''+str;
      }
      return new Handlebars.SafeString(str);
    }

    EmberStringUtils.htmlSafe = htmlSafe;
    if (Ember.EXTEND_PROTOTYPES === true || Ember.EXTEND_PROTOTYPES.String) {

      /**
        Mark a string as being safe for unescaped output with Handlebars.

        ```javascript
        '<div>someString</div>'.htmlSafe()
        ```

        See [Ember.String.htmlSafe](/api/classes/Ember.String.html#method_htmlSafe).

        @method htmlSafe
        @for String
        @return {Handlebars.SafeString} a string that will not be html escaped by Handlebars
      */
      String.prototype.htmlSafe = function() {
        return htmlSafe(this);
      };
    }

    __exports__["default"] = htmlSafe;
  });
enifed("ember-handlebars/views/handlebars_bound_view",
  ["ember-handlebars-compiler","ember-metal/core","ember-metal/error","ember-metal/property_get","ember-metal/property_set","ember-metal/merge","ember-metal/run_loop","ember-views/views/view","ember-handlebars/string","ember-views/views/states","ember-handlebars/views/metamorph_view","ember-handlebars/ext","ember-metal/utils","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __dependency11__, __dependency12__, __dependency13__, __exports__) {
    "use strict";
    /*globals Handlebars, Metamorph:true */
    /*jshint newcap:false*/


    /**
    @module ember
    @submodule ember-handlebars
    */

    var EmberHandlebars = __dependency1__["default"];
    // EmberHandlebars.SafeString;
    var SafeString = EmberHandlebars.SafeString;

    var Ember = __dependency2__["default"];
    // Ember.K
    var K = Ember.K;

    var EmberError = __dependency3__["default"];
    var get = __dependency4__.get;
    var set = __dependency5__.set;
    var merge = __dependency6__["default"];
    var run = __dependency7__["default"];
    var View = __dependency8__["default"];
    var htmlSafe = __dependency9__["default"];
    var cloneStates = __dependency10__.cloneStates;
    var states = __dependency10__.states;
    var viewStates = states;

    var _MetamorphView = __dependency11__["default"];
    var handlebarsGet = __dependency12__.handlebarsGet;
    var uuid = __dependency13__.uuid;

    function SimpleHandlebarsView(path, pathRoot, isEscaped, templateData) {
      this.path = path;
      this.pathRoot = pathRoot;
      this.isEscaped = isEscaped;
      this.templateData = templateData;
      this[Ember.GUID_KEY] = uuid();
      this._lastNormalizedValue = undefined;
      this.state = 'preRender';
      this.updateId = null;
      this._parentView = null;
      this.buffer = null;
      this._morph = null;
    }

    SimpleHandlebarsView.prototype = {
      isVirtual: true,
      isView: true,

      destroy: function () {
        if (this.updateId) {
          run.cancel(this.updateId);
          this.updateId = null;
        }
        if (this._parentView) {
          this._parentView.removeChild(this);
        }
        this.morph = null;
        this.state = 'destroyed';
      },

      propertyWillChange: K,

      propertyDidChange: K,

      normalizedValue: function() {
        var path = this.path;
        var pathRoot = this.pathRoot;
        var escape = this.isEscaped;
        var result, templateData;

        // Use the pathRoot as the result if no path is provided. This
        // happens if the path is `this`, which gets normalized into
        // a `pathRoot` of the current Handlebars context and a path
        // of `''`.
        if (path === '') {
          result = pathRoot;
        } else {
          templateData = this.templateData;
          result = handlebarsGet(pathRoot, path, { data: templateData });
        }

        if (!escape && !(result instanceof SafeString)) {
          result = htmlSafe(result);
        }

        return result;
      },

      render: function(buffer) {
        var value = this.normalizedValue();
        this._lastNormalizedValue = value;
        buffer._element = value;
      },

      rerender: function() {
        switch(this.state) {
          case 'preRender':
          case 'destroyed':
            break;
          case 'inBuffer':
            throw new EmberError("Something you did tried to replace an {{expression}} before it was inserted into the DOM.");
          case 'hasElement':
          case 'inDOM':
            this.updateId = run.scheduleOnce('render', this, 'update');
            break;
        }
        return this;
      },

      update: function () {
        this.updateId = null;
        var value = this.normalizedValue();
        // doesn't diff SafeString instances
        if (value !== this._lastNormalizedValue) {
          this._lastNormalizedValue = value;
          this._morph.update(value);
        }
      },

      _transitionTo: function(state) {
        this.state = state;
      }
    };

    states = cloneStates(viewStates);

    merge(states._default, {
      rerenderIfNeeded: K
    });

    merge(states.inDOM, {
      rerenderIfNeeded: function(view) {
        if (view.normalizedValue() !== view._lastNormalizedValue) {
          view.rerender();
        }
      }
    });

    /**
      `Ember._HandlebarsBoundView` is a private view created by the Handlebars
      `{{bind}}` helpers that is used to keep track of bound properties.

      Every time a property is bound using a `{{mustache}}`, an anonymous subclass
      of `Ember._HandlebarsBoundView` is created with the appropriate sub-template
      and context set up. When the associated property changes, just the template
      for this view will re-render.

      @class _HandlebarsBoundView
      @namespace Ember
      @extends Ember._MetamorphView
      @private
    */
    var _HandlebarsBoundView = _MetamorphView.extend({
      instrumentName: 'boundHandlebars',

      _states: states,

      /**
        The function used to determine if the `displayTemplate` or
        `inverseTemplate` should be rendered. This should be a function that takes
        a value and returns a Boolean.

        @property shouldDisplayFunc
        @type Function
        @default null
      */
      shouldDisplayFunc: null,

      /**
        Whether the template rendered by this view gets passed the context object
        of its parent template, or gets passed the value of retrieving `path`
        from the `pathRoot`.

        For example, this is true when using the `{{#if}}` helper, because the
        template inside the helper should look up properties relative to the same
        object as outside the block. This would be `false` when used with `{{#with
        foo}}` because the template should receive the object found by evaluating
        `foo`.

        @property preserveContext
        @type Boolean
        @default false
      */
      preserveContext: false,

      /**
        If `preserveContext` is true, this is the object that will be used
        to render the template.

        @property previousContext
        @type Object
      */
      previousContext: null,

      /**
        The template to render when `shouldDisplayFunc` evaluates to `true`.

        @property displayTemplate
        @type Function
        @default null
      */
      displayTemplate: null,

      /**
        The template to render when `shouldDisplayFunc` evaluates to `false`.

        @property inverseTemplate
        @type Function
        @default null
      */
      inverseTemplate: null,


      /**
        The path to look up on `pathRoot` that is passed to
        `shouldDisplayFunc` to determine which template to render.

        In addition, if `preserveContext` is `false,` the object at this path will
        be passed to the template when rendering.

        @property path
        @type String
        @default null
      */
      path: null,

      /**
        The object from which the `path` will be looked up. Sometimes this is the
        same as the `previousContext`, but in cases where this view has been
        generated for paths that start with a keyword such as `view` or
        `controller`, the path root will be that resolved object.

        @property pathRoot
        @type Object
      */
      pathRoot: null,

      normalizedValue: function() {
        var path = get(this, 'path');
        var pathRoot  = get(this, 'pathRoot');
        var valueNormalizer = get(this, 'valueNormalizerFunc');
        var result, templateData;

        // Use the pathRoot as the result if no path is provided. This
        // happens if the path is `this`, which gets normalized into
        // a `pathRoot` of the current Handlebars context and a path
        // of `''`.
        if (path === '') {
          result = pathRoot;
        } else {
          templateData = get(this, 'templateData');
          result = handlebarsGet(pathRoot, path, { data: templateData });
        }

        return valueNormalizer ? valueNormalizer(result) : result;
      },

      rerenderIfNeeded: function() {
        this.currentState.rerenderIfNeeded(this);
      },

      /**
        Determines which template to invoke, sets up the correct state based on
        that logic, then invokes the default `Ember.View` `render` implementation.

        This method will first look up the `path` key on `pathRoot`,
        then pass that value to the `shouldDisplayFunc` function. If that returns
        `true,` the `displayTemplate` function will be rendered to DOM. Otherwise,
        `inverseTemplate`, if specified, will be rendered.

        For example, if this `Ember._HandlebarsBoundView` represented the `{{#with
        foo}}` helper, it would look up the `foo` property of its context, and
        `shouldDisplayFunc` would always return true. The object found by looking
        up `foo` would be passed to `displayTemplate`.

        @method render
        @param {Ember.RenderBuffer} buffer
      */
      render: function(buffer) {
        // If not invoked via a triple-mustache ({{{foo}}}), escape
        // the content of the template.
        var escape = get(this, 'isEscaped');

        var shouldDisplay = get(this, 'shouldDisplayFunc');
        var preserveContext = get(this, 'preserveContext');
        var context = get(this, 'previousContext');

        var inverseTemplate = get(this, 'inverseTemplate');
        var displayTemplate = get(this, 'displayTemplate');

        var result = this.normalizedValue();

        this._lastNormalizedValue = result;

        // First, test the conditional to see if we should
        // render the template or not.
        if (shouldDisplay(result)) {
          set(this, 'template', displayTemplate);

          // If we are preserving the context (for example, if this
          // is an #if block, call the template with the same object.
          if (preserveContext) {
            set(this, '_context', context);
          } else {
          // Otherwise, determine if this is a block bind or not.
          // If so, pass the specified object to the template
            if (displayTemplate) {
              set(this, '_context', result);
            } else {
            // This is not a bind block, just push the result of the
            // expression to the render context and return.
              if (result === null || result === undefined) {
                result = "";
              } else if (!(result instanceof SafeString)) {
                result = String(result);
              }

              if (escape) { result = Handlebars.Utils.escapeExpression(result); }
              buffer.push(result);
              return;
            }
          }
        } else if (inverseTemplate) {
          set(this, 'template', inverseTemplate);

          if (preserveContext) {
            set(this, '_context', context);
          } else {
            set(this, '_context', result);
          }
        } else {
          set(this, 'template', function() { return ''; });
        }

        return this._super(buffer);
      }
    });

    __exports__._HandlebarsBoundView = _HandlebarsBoundView;
    __exports__.SimpleHandlebarsView = SimpleHandlebarsView;
  });
enifed("ember-handlebars/views/metamorph_view",
  ["ember-metal/core","ember-views/views/core_view","ember-views/views/view","ember-metal/mixin","ember-metal/run_loop","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    /* global Metamorph:true */

    /*jshint newcap:false*/
    var Ember = __dependency1__["default"];
    // Ember.deprecate

    var CoreView = __dependency2__["default"];
    var View = __dependency3__["default"];
    var Mixin = __dependency4__.Mixin;
    var run = __dependency5__["default"];

    /**
    @module ember
    @submodule ember-handlebars
    */

    function notifyMutationListeners() {
      run.once(View, 'notifyMutationListeners');
    }

    // The `morph` and `outerHTML` properties are internal only
    // and not observable.

    /**
      @class _Metamorph
      @namespace Ember
      @private
    */
    var _Metamorph = Mixin.create({
      isVirtual: true,
      tagName: '',

      instrumentName: 'metamorph',

      init: function() {
        this._super();
        Ember.deprecate('Supplying a tagName to Metamorph views is unreliable and is deprecated. You may be setting the tagName on a Handlebars helper that creates a Metamorph.', !this.tagName);
      }
    });
    __exports__._Metamorph = _Metamorph;
    /**
      @class _MetamorphView
      @namespace Ember
      @extends Ember.View
      @uses Ember._Metamorph
      @private
    */
    var _MetamorphView = View.extend(_Metamorph);
    __exports__._MetamorphView = _MetamorphView;
    /**
      @class _SimpleMetamorphView
      @namespace Ember
      @extends Ember.CoreView
      @uses Ember._Metamorph
      @private
    */
    var _SimpleMetamorphView = CoreView.extend(_Metamorph);
    __exports__._SimpleMetamorphView = _SimpleMetamorphView;__exports__["default"] = View.extend(_Metamorph);
  });
enifed("ember-metal-views",
  ["ember-metal-views/renderer","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var Renderer = __dependency1__["default"];
    __exports__.Renderer = Renderer;
  });
enifed("ember-metal-views/renderer",
  ["morph","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var DOMHelper = __dependency1__.DOMHelper;

    function Renderer() {
      this._uuid = 0;
      this._views = new Array(2000);
      this._queue = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
      this._parents = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
      this._elements = new Array(17);
      this._inserts = {};
      this._dom = new DOMHelper();
    }

    function Renderer_renderTree(_view, _parentView, _insertAt) {
      var views = this._views;
      views[0] = _view;
      var insertAt = _insertAt === undefined ? -1 : _insertAt;
      var index = 0;
      var total = 1;
      var levelBase = _parentView ? _parentView._level+1 : 0;

      var root = _parentView == null ? _view : _parentView._root;

      // if root view has a _morph assigned
      var willInsert = !!root._morph;

      var queue = this._queue;
      queue[0] = 0;
      var length = 1;

      var parentIndex = -1;
      var parents = this._parents;
      var parent = _parentView || null;
      var elements = this._elements;
      var element = null;
      var contextualElement = null;
      var level = 0;

      var view = _view;
      var children, i, l, child;
      while (length) {
        elements[level] = element;
        if (!view._morph) {
          // ensure props we add are in same order
          view._morph = null;
        }
        view._root = root;
        this.uuid(view);
        view._level = levelBase + level;
        if (view._elementCreated) {
          this.remove(view, false, true);
        }

        this.willCreateElement(view);

        contextualElement = view._morph && view._morph.contextualElement;
        if (!contextualElement && parent && parent._childViewsMorph) {
          contextualElement = parent._childViewsMorph.contextualElement;
        }
        if (!contextualElement && view._didCreateElementWithoutMorph) {
          // This code path is only used by createElement and rerender when createElement
          // was previously called on a view.
          contextualElement = document.body;
        }
        Ember.assert("Required contextualElement for view "+_view+" is missing", contextualElement);
        element = this.createElement(view, contextualElement);

        parents[level++] = parentIndex;
        parentIndex = index;
        parent = view;

        // enqueue for end
        queue[length++] = index;
        // enqueue children
        children = this.childViews(view);
        if (children) {
          for (i=children.length-1;i>=0;i--) {
            child = children[i];
            index = total++;
            views[index] = child;
            queue[length++] = index;
            view = child;
          }
        }

        index = queue[--length];
        view = views[index];

        while (parentIndex === index) {
          level--;
          view._elementCreated = true;
          this.didCreateElement(view);
          if (willInsert) {
            this.willInsertElement(view);
          }

          if (level === 0) {
            length--;
            break;
          }

          parentIndex = parents[level];
          parent = parentIndex === -1 ? _parentView : views[parentIndex];
          this.insertElement(view, parent, element, -1);
          index = queue[--length];
          view = views[index];
          element = elements[level];
          elements[level] = null;
        }
      }

      this.insertElement(view, _parentView, element, insertAt);

      for (i=total-1;i>=0;i--) {
        if (willInsert) {
          views[i]._elementInserted = true;
          this.didInsertElement(views[i]);
        }
        views[i] = null;
      }

      return element;
    }

    Renderer.prototype.uuid = function Renderer_uuid(view) {
      if (view._uuid === undefined) {
        view._uuid = ++this._uuid;
        view._renderer = this;
      } // else assert(view._renderer === this)
      return view._uuid;
    };

    Renderer.prototype.scheduleInsert =
      function Renderer_scheduleInsert(view, morph) {
        if (view._morph || view._elementCreated) {
          throw new Error("You cannot insert a View that has already been rendered");
        }
        Ember.assert("You cannot insert a View without a morph", morph);
        view._morph = morph;
        var viewId = this.uuid(view);
        this._inserts[viewId] = this.scheduleRender(this, function() {
          this._inserts[viewId] = null;
          this.renderTree(view);
        });
      };

    Renderer.prototype.appendTo =
      function Renderer_appendTo(view, target) {
        var morph = this._dom.appendMorph(target);
        this.scheduleInsert(view, morph);
      };

    Renderer.prototype.replaceIn =
      function Renderer_replaceIn(view, target) {
        var morph = this._dom.createMorph(target, null, null);
        this.scheduleInsert(view, morph);
      };

    function Renderer_remove(_view, shouldDestroy, reset) {
      var viewId = this.uuid(_view);

      if (this._inserts[viewId]) {
        this.cancelRender(this._inserts[viewId]);
        this._inserts[viewId] = undefined;
      }

      if (!_view._elementCreated) {
        return;
      }

      var removeQueue = [];
      var destroyQueue = [];
      var morph = _view._morph;
      var  idx, len, view, staticChildren, queue,
        childViews, i, l, parentView;

      removeQueue.push(_view);

      for (idx=0; idx<removeQueue.length; idx++) {
        view = removeQueue[idx];

        if (!shouldDestroy && view._childViewsMorph) {
          queue = removeQueue;
        } else {
          queue = destroyQueue;
        }

        this.beforeRemove(removeQueue[idx]);

        childViews = view._childViews;
        if (childViews) {
          for (i=0,l=childViews.length; i<l; i++) {
            queue.push(childViews[i]);
          }
        }
      }

      for (idx=0; idx<destroyQueue.length; idx++) {
        view = destroyQueue[idx];

        this.beforeRemove(destroyQueue[idx]);

        childViews = view._childViews;
        if (childViews) {
          for (i=0,l=childViews.length; i<l; i++) {
            destroyQueue.push(childViews[i]);
          }
        }
      }

      // destroy DOM from root insertion
      if (morph && !reset) {
        morph.destroy();
      }

      for (idx=0, len=removeQueue.length; idx < len; idx++) {
        this.afterRemove(removeQueue[idx], false);
      }

      for (idx=0, len=destroyQueue.length; idx < len; idx++) {
        this.afterRemove(destroyQueue[idx], true);
      }

      if (reset) {
        _view._morph = morph;
      }
    }

    function Renderer_insertElement(view, parentView, element, index) {
      if (element === null || element === undefined) return;
      if (view._morph) {
        view._morph.update(element);
      } else if (parentView) {
        if (index === -1) {
          view._morph = parentView._childViewsMorph.append(element);
        } else {
          view._morph = parentView._childViewsMorph.insert(index, element);
        }
      }
    }

    function Renderer_beforeRemove(view) {
      if (view._elementCreated) {
        this.willDestroyElement(view);
      }
      if (view._elementInserted) {
        this.willRemoveElement(view);
      }
    }

    function Renderer_afterRemove(view, shouldDestroy) {
      view._elementInserted = false;
      view._morph = null;
      view._childViewsMorph = null;
      if (view._elementCreated) {
        view._elementCreated = false;
        this.didDestroyElement(view);
      }
      if (shouldDestroy) {
        this.destroyView(view);
      }
    }

    Renderer.prototype.remove = Renderer_remove;
    Renderer.prototype.destroy = function (view) {
      this.remove(view, true);
    };

    Renderer.prototype.renderTree = Renderer_renderTree;
    Renderer.prototype.insertElement = Renderer_insertElement;
    Renderer.prototype.beforeRemove = Renderer_beforeRemove;
    Renderer.prototype.afterRemove = Renderer_afterRemove;

    /// HOOKS
    var noop = function () {};

    Renderer.prototype.willCreateElement = noop; // inBuffer
    Renderer.prototype.createElement = noop; // renderToBuffer or createElement
    Renderer.prototype.didCreateElement = noop; // hasElement
    Renderer.prototype.willInsertElement = noop; // will place into DOM
    Renderer.prototype.didInsertElement = noop; // inDOM // placed into DOM
    Renderer.prototype.willRemoveElement = noop; // removed from DOM  willDestroyElement currently paired with didInsertElement
    Renderer.prototype.willDestroyElement = noop; // willClearRender (currently balanced with render) this is now paired with createElement
    Renderer.prototype.didDestroyElement = noop; // element destroyed so view.destroy shouldn't try to remove it removedFromDOM
    Renderer.prototype.destroyView = noop;
    Renderer.prototype.childViews = noop;

    __exports__["default"] = Renderer;
  });
enifed("ember-metal",
  ["ember-metal/core","ember-metal/merge","ember-metal/instrumentation","ember-metal/utils","ember-metal/error","ember-metal/enumerable_utils","ember-metal/cache","ember-metal/platform","ember-metal/array","ember-metal/logger","ember-metal/property_get","ember-metal/events","ember-metal/observer_set","ember-metal/property_events","ember-metal/properties","ember-metal/property_set","ember-metal/map","ember-metal/get_properties","ember-metal/set_properties","ember-metal/watch_key","ember-metal/chains","ember-metal/watch_path","ember-metal/watching","ember-metal/expand_properties","ember-metal/computed","ember-metal/computed_macros","ember-metal/observer","ember-metal/mixin","ember-metal/binding","ember-metal/run_loop","ember-metal/libraries","ember-metal/is_none","ember-metal/is_empty","ember-metal/is_blank","ember-metal/is_present","ember-metal/keys","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __dependency11__, __dependency12__, __dependency13__, __dependency14__, __dependency15__, __dependency16__, __dependency17__, __dependency18__, __dependency19__, __dependency20__, __dependency21__, __dependency22__, __dependency23__, __dependency24__, __dependency25__, __dependency26__, __dependency27__, __dependency28__, __dependency29__, __dependency30__, __dependency31__, __dependency32__, __dependency33__, __dependency34__, __dependency35__, __dependency36__, __exports__) {
    "use strict";
    /**
    Ember Metal

    @module ember
    @submodule ember-metal
    */

    // BEGIN IMPORTS
    var Ember = __dependency1__["default"];
    var merge = __dependency2__["default"];
    var instrument = __dependency3__.instrument;
    var subscribe = __dependency3__.subscribe;
    var unsubscribe = __dependency3__.unsubscribe;
    var reset = __dependency3__.reset;
    var generateGuid = __dependency4__.generateGuid;
    var GUID_KEY = __dependency4__.GUID_KEY;
    var guidFor = __dependency4__.guidFor;
    var META_DESC = __dependency4__.META_DESC;
    var EMPTY_META = __dependency4__.EMPTY_META;
    var meta = __dependency4__.meta;
    var getMeta = __dependency4__.getMeta;
    var setMeta = __dependency4__.setMeta;
    var metaPath = __dependency4__.metaPath;
    var inspect = __dependency4__.inspect;
    var typeOf = __dependency4__.typeOf;
    var tryCatchFinally = __dependency4__.tryCatchFinally;
    var isArray = __dependency4__.isArray;
    var makeArray = __dependency4__.makeArray;
    var canInvoke = __dependency4__.canInvoke;
    var tryInvoke = __dependency4__.tryInvoke;
    var tryFinally = __dependency4__.tryFinally;
    var wrap = __dependency4__.wrap;
    var apply = __dependency4__.apply;
    var applyStr = __dependency4__.applyStr;
    var uuid = __dependency4__.uuid;
    var EmberError = __dependency5__["default"];
    var EnumerableUtils = __dependency6__["default"];
    var Cache = __dependency7__["default"];
    var create = __dependency8__.create;
    var hasPropertyAccessors = __dependency8__.hasPropertyAccessors;
    var filter = __dependency9__.filter;
    var forEach = __dependency9__.forEach;
    var indexOf = __dependency9__.indexOf;
    var map = __dependency9__.map;
    var Logger = __dependency10__["default"];

    var get = __dependency11__.get;
    var getWithDefault = __dependency11__.getWithDefault;
    var normalizeTuple = __dependency11__.normalizeTuple;
    var _getPath = __dependency11__._getPath;

    var on = __dependency12__.on;
    var addListener = __dependency12__.addListener;
    var removeListener = __dependency12__.removeListener;
    var suspendListener = __dependency12__.suspendListener;
    var suspendListeners = __dependency12__.suspendListeners;
    var sendEvent = __dependency12__.sendEvent;
    var hasListeners = __dependency12__.hasListeners;
    var watchedEvents = __dependency12__.watchedEvents;
    var listenersFor = __dependency12__.listenersFor;
    var listenersDiff = __dependency12__.listenersDiff;
    var listenersUnion = __dependency12__.listenersUnion;

    var ObserverSet = __dependency13__["default"];

    var propertyWillChange = __dependency14__.propertyWillChange;
    var propertyDidChange = __dependency14__.propertyDidChange;
    var overrideChains = __dependency14__.overrideChains;
    var beginPropertyChanges = __dependency14__.beginPropertyChanges;
    var endPropertyChanges = __dependency14__.endPropertyChanges;
    var changeProperties = __dependency14__.changeProperties;

    var Descriptor = __dependency15__.Descriptor;
    var defineProperty = __dependency15__.defineProperty;
    var set = __dependency16__.set;
    var trySet = __dependency16__.trySet;

    var OrderedSet = __dependency17__.OrderedSet;
    var Map = __dependency17__.Map;
    var MapWithDefault = __dependency17__.MapWithDefault;
    var getProperties = __dependency18__["default"];
    var setProperties = __dependency19__["default"];
    var watchKey = __dependency20__.watchKey;
    var unwatchKey = __dependency20__.unwatchKey;
    var flushPendingChains = __dependency21__.flushPendingChains;
    var removeChainWatcher = __dependency21__.removeChainWatcher;
    var ChainNode = __dependency21__.ChainNode;
    var finishChains = __dependency21__.finishChains;
    var watchPath = __dependency22__.watchPath;
    var unwatchPath = __dependency22__.unwatchPath;
    var watch = __dependency23__.watch;
    var isWatching = __dependency23__.isWatching;
    var unwatch = __dependency23__.unwatch;
    var rewatch = __dependency23__.rewatch;
    var destroy = __dependency23__.destroy;
    var expandProperties = __dependency24__["default"];
    var ComputedProperty = __dependency25__.ComputedProperty;
    var computed = __dependency25__.computed;
    var cacheFor = __dependency25__.cacheFor;

    // side effect of defining the computed.* macros

    var addObserver = __dependency27__.addObserver;
    var observersFor = __dependency27__.observersFor;
    var removeObserver = __dependency27__.removeObserver;
    var addBeforeObserver = __dependency27__.addBeforeObserver;
    var _suspendBeforeObserver = __dependency27__._suspendBeforeObserver;
    var _suspendObserver = __dependency27__._suspendObserver;
    var _suspendBeforeObservers = __dependency27__._suspendBeforeObservers;
    var _suspendObservers = __dependency27__._suspendObservers;
    var beforeObserversFor = __dependency27__.beforeObserversFor;
    var removeBeforeObserver = __dependency27__.removeBeforeObserver;
    var IS_BINDING = __dependency28__.IS_BINDING;
    var mixin = __dependency28__.mixin;
    var Mixin = __dependency28__.Mixin;
    var required = __dependency28__.required;
    var aliasMethod = __dependency28__.aliasMethod;
    var observer = __dependency28__.observer;
    var immediateObserver = __dependency28__.immediateObserver;
    var beforeObserver = __dependency28__.beforeObserver;
    var Binding = __dependency29__.Binding;
    var isGlobalPath = __dependency29__.isGlobalPath;
    var bind = __dependency29__.bind;
    var oneWay = __dependency29__.oneWay;
    var run = __dependency30__["default"];
    var libraries = __dependency31__["default"];
    var isNone = __dependency32__.isNone;
    var none = __dependency32__.none;
    var isEmpty = __dependency33__.isEmpty;
    var empty = __dependency33__.empty;
    var isBlank = __dependency34__["default"];
    var isPresent = __dependency35__["default"];
    var keys = __dependency36__["default"];

    // END IMPORTS

    // BEGIN EXPORTS
    var EmberInstrumentation = Ember.Instrumentation = {};
    EmberInstrumentation.instrument = instrument;
    EmberInstrumentation.subscribe = subscribe;
    EmberInstrumentation.unsubscribe = unsubscribe;
    EmberInstrumentation.reset  = reset;

    Ember.instrument = instrument;
    Ember.subscribe = subscribe;

    Ember._Cache = Cache;

    Ember.generateGuid    = generateGuid;
    Ember.GUID_KEY        = GUID_KEY;
    Ember.create          = create;
    Ember.keys            = keys;
    Ember.platform        = {
      defineProperty: defineProperty,
      hasPropertyAccessors: hasPropertyAccessors
    };

    var EmberArrayPolyfills = Ember.ArrayPolyfills = {};

    EmberArrayPolyfills.map = map;
    EmberArrayPolyfills.forEach = forEach;
    EmberArrayPolyfills.filter = filter;
    EmberArrayPolyfills.indexOf = indexOf;

    Ember.Error           = EmberError;
    Ember.guidFor         = guidFor;
    Ember.META_DESC       = META_DESC;
    Ember.EMPTY_META      = EMPTY_META;
    Ember.meta            = meta;
    Ember.getMeta         = getMeta;
    Ember.setMeta         = setMeta;
    Ember.metaPath        = metaPath;
    Ember.inspect         = inspect;
    Ember.typeOf          = typeOf;
    Ember.tryCatchFinally = tryCatchFinally;
    Ember.isArray         = isArray;
    Ember.makeArray       = makeArray;
    Ember.canInvoke       = canInvoke;
    Ember.tryInvoke       = tryInvoke;
    Ember.tryFinally      = tryFinally;
    Ember.wrap            = wrap;
    Ember.apply           = apply;
    Ember.applyStr        = applyStr;
    Ember.uuid            = uuid;

    Ember.Logger = Logger;

    Ember.get            = get;
    Ember.getWithDefault = getWithDefault;
    Ember.normalizeTuple = normalizeTuple;
    Ember._getPath       = _getPath;

    Ember.EnumerableUtils = EnumerableUtils;

    Ember.on                = on;
    Ember.addListener       = addListener;
    Ember.removeListener    = removeListener;
    Ember._suspendListener  = suspendListener;
    Ember._suspendListeners = suspendListeners;
    Ember.sendEvent         = sendEvent;
    Ember.hasListeners      = hasListeners;
    Ember.watchedEvents     = watchedEvents;
    Ember.listenersFor      = listenersFor;
    Ember.listenersDiff     = listenersDiff;
    Ember.listenersUnion    = listenersUnion;

    Ember._ObserverSet = ObserverSet;

    Ember.propertyWillChange = propertyWillChange;
    Ember.propertyDidChange = propertyDidChange;
    Ember.overrideChains = overrideChains;
    Ember.beginPropertyChanges = beginPropertyChanges;
    Ember.endPropertyChanges = endPropertyChanges;
    Ember.changeProperties = changeProperties;

    Ember.Descriptor     = Descriptor;
    Ember.defineProperty = defineProperty;

    Ember.set    = set;
    Ember.trySet = trySet;

    Ember.OrderedSet = OrderedSet;
    Ember.Map = Map;
    Ember.MapWithDefault = MapWithDefault;

    Ember.getProperties = getProperties;
    Ember.setProperties = setProperties;

    Ember.watchKey   = watchKey;
    Ember.unwatchKey = unwatchKey;

    Ember.flushPendingChains = flushPendingChains;
    Ember.removeChainWatcher = removeChainWatcher;
    Ember._ChainNode = ChainNode;
    Ember.finishChains = finishChains;

    Ember.watchPath = watchPath;
    Ember.unwatchPath = unwatchPath;

    Ember.watch = watch;
    Ember.isWatching = isWatching;
    Ember.unwatch = unwatch;
    Ember.rewatch = rewatch;
    Ember.destroy = destroy;

    Ember.expandProperties = expandProperties;

    Ember.ComputedProperty = ComputedProperty;
    Ember.computed = computed;
    Ember.cacheFor = cacheFor;

    Ember.addObserver = addObserver;
    Ember.observersFor = observersFor;
    Ember.removeObserver = removeObserver;
    Ember.addBeforeObserver = addBeforeObserver;
    Ember._suspendBeforeObserver = _suspendBeforeObserver;
    Ember._suspendBeforeObservers = _suspendBeforeObservers;
    Ember._suspendObserver = _suspendObserver;
    Ember._suspendObservers = _suspendObservers;
    Ember.beforeObserversFor = beforeObserversFor;
    Ember.removeBeforeObserver = removeBeforeObserver;

    Ember.IS_BINDING = IS_BINDING;
    Ember.required = required;
    Ember.aliasMethod = aliasMethod;
    Ember.observer = observer;
    Ember.immediateObserver = immediateObserver;
    Ember.beforeObserver = beforeObserver;
    Ember.mixin = mixin;
    Ember.Mixin = Mixin;

    Ember.oneWay = oneWay;
    Ember.bind = bind;
    Ember.Binding = Binding;
    Ember.isGlobalPath = isGlobalPath;

    Ember.run = run;

    Ember.libraries = libraries;
    Ember.libraries.registerCoreLibrary('Ember', Ember.VERSION);

    Ember.isNone = isNone;
    Ember.none = none;

    Ember.isEmpty = isEmpty;
    Ember.empty = empty;

    Ember.isBlank = isBlank;

    
      Ember.isPresent = isPresent;
    

    Ember.merge = merge;

    /**
      A function may be assigned to `Ember.onerror` to be called when Ember
      internals encounter an error. This is useful for specialized error handling
      and reporting code.

      ```javascript
      Ember.onerror = function(error) {
        Em.$.ajax('/report-error', 'POST', {
          stack: error.stack,
          otherInformation: 'whatever app state you want to provide'
        });
      };
      ```

      Internally, `Ember.onerror` is used as Backburner's error handler.

      @event onerror
      @for Ember
      @param {Exception} error the error object
    */
    Ember.onerror = null;
    // END EXPORTS

    // do this for side-effects of updating Ember.assert, warn, etc when
    // ember-debug is present
    if (Ember.__loader.registry['ember-debug']) {
      requireModule('ember-debug');
    }

    __exports__["default"] = Ember;
  });
enifed("ember-metal/alias",
  ["ember-metal/property_get","ember-metal/property_set","ember-metal/error","ember-metal/properties","ember-metal/computed","ember-metal/platform","ember-metal/utils","ember-metal/dependent_keys","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __exports__) {
    "use strict";
    var get = __dependency1__.get;
    var set = __dependency2__.set;
    var EmberError = __dependency3__["default"];
    var Descriptor = __dependency4__.Descriptor;
    var defineProperty = __dependency4__.defineProperty;
    var ComputedProperty = __dependency5__.ComputedProperty;
    var create = __dependency6__.create;
    var meta = __dependency7__.meta;
    var inspect = __dependency7__.inspect;
    var addDependentKeys = __dependency8__.addDependentKeys;
    var removeDependentKeys = __dependency8__.removeDependentKeys;

    function alias(altKey) {
      return new AliasedProperty(altKey);
    }

    __exports__.alias = alias;function AliasedProperty(altKey) {
      this.altKey = altKey;
      this._dependentKeys = [ altKey ];
    }

    __exports__.AliasedProperty = AliasedProperty;AliasedProperty.prototype = create(Descriptor.prototype);

    AliasedProperty.prototype.get = function AliasedProperty_get(obj, keyName) {
      return get(obj, this.altKey);
    };

    AliasedProperty.prototype.set = function AliasedProperty_set(obj, keyName, value) {
      return set(obj, this.altKey, value);
    };

    AliasedProperty.prototype.willWatch = function(obj, keyName) {
      addDependentKeys(this, obj, keyName, meta(obj));
    };

    AliasedProperty.prototype.didUnwatch = function(obj, keyName) {
      removeDependentKeys(this, obj, keyName, meta(obj));
    };

    AliasedProperty.prototype.setup = function(obj, keyName) {
      var m = meta(obj);
      if (m.watching[keyName]) {
        addDependentKeys(this, obj, keyName, m);
      }
    };

    AliasedProperty.prototype.teardown = function(obj, keyName) {
      var m = meta(obj);
      if (m.watching[keyName]) {
        removeDependentKeys(this, obj, keyName, m);
      }
    };

    AliasedProperty.prototype.readOnly = function() {
      this.set = AliasedProperty_readOnlySet;
      return this;
    };

    function AliasedProperty_readOnlySet(obj, keyName, value) {
      throw new EmberError('Cannot set read-only property "' + keyName + '" on object: ' + inspect(obj));
    }

    AliasedProperty.prototype.oneWay = function() {
      this.set = AliasedProperty_oneWaySet;
      return this;
    };

    function AliasedProperty_oneWaySet(obj, keyName, value) {
      defineProperty(obj, keyName, null);
      return set(obj, keyName, value);
    }

    // Backwards compatibility with Ember Data
    AliasedProperty.prototype._meta = undefined;
    AliasedProperty.prototype.meta = ComputedProperty.prototype.meta;
  });
enifed("ember-metal/array",
  ["exports"],
  function(__exports__) {
    "use strict";
    /**
    @module ember-metal
    */

    var ArrayPrototype = Array.prototype;

    // Testing this is not ideal, but we want to use native functions
    // if available, but not to use versions created by libraries like Prototype
    var isNativeFunc = function(func) {
      // This should probably work in all browsers likely to have ES5 array methods
      return func && Function.prototype.toString.call(func).indexOf('[native code]') > -1;
    };

    var defineNativeShim = function(nativeFunc, shim) {
      if (isNativeFunc(nativeFunc)) {
        return nativeFunc;
      }
      return shim;
    };

    // From: https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/array/map
    var map = defineNativeShim(ArrayPrototype.map, function(fun /*, thisp */) {
      //"use strict";

      if (this === void 0 || this === null || typeof fun !== "function") {
        throw new TypeError();
      }

      var t = Object(this);
      var len = t.length >>> 0;
      var res = new Array(len);
      var thisp = arguments[1];

      for (var i = 0; i < len; i++) {
        if (i in t) {
          res[i] = fun.call(thisp, t[i], i, t);
        }
      }

      return res;
    });

    // From: https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/array/foreach
    var forEach = defineNativeShim(ArrayPrototype.forEach, function(fun /*, thisp */) {
      //"use strict";

      if (this === void 0 || this === null || typeof fun !== "function") {
        throw new TypeError();
      }

      var t = Object(this);
      var len = t.length >>> 0;
      var thisp = arguments[1];

      for (var i = 0; i < len; i++) {
        if (i in t) {
          fun.call(thisp, t[i], i, t);
        }
      }
    });

    var indexOf = defineNativeShim(ArrayPrototype.indexOf, function (obj, fromIndex) {
      if (fromIndex === null || fromIndex === undefined) {
        fromIndex = 0;
      }
      else if (fromIndex < 0) {
        fromIndex = Math.max(0, this.length + fromIndex);
      }

      for (var i = fromIndex, j = this.length; i < j; i++) {
        if (this[i] === obj) {
          return i;
        }
      }
      return -1;
    });

    var lastIndexOf = defineNativeShim(ArrayPrototype.lastIndexOf, function(obj, fromIndex) {
        var len = this.length;
        var idx;

        if (fromIndex === undefined) fromIndex = len-1;
        else fromIndex = (fromIndex < 0) ? Math.ceil(fromIndex) : Math.floor(fromIndex);
        if (fromIndex < 0) fromIndex += len;

        for(idx = fromIndex;idx>=0;idx--) {
          if (this[idx] === obj) return idx ;
        }
        return -1;
    });

    var filter = defineNativeShim(ArrayPrototype.filter, function (fn, context) {
      var i, value;
      var result = [];
      var length = this.length;

      for (i = 0; i < length; i++) {
        if (this.hasOwnProperty(i)) {
          value = this[i];
          if (fn.call(context, value, i, this)) {
            result.push(value);
          }
        }
      }
      return result;
    });

    if (Ember.SHIM_ES5) {
      ArrayPrototype.map = ArrayPrototype.map || map;
      ArrayPrototype.forEach = ArrayPrototype.forEach || forEach;
      ArrayPrototype.filter = ArrayPrototype.filter || filter;
      ArrayPrototype.indexOf = ArrayPrototype.indexOf || indexOf;
      ArrayPrototype.lastIndexOf = ArrayPrototype.lastIndexOf || lastIndexOf;
    }

    /**
      Array polyfills to support ES5 features in older browsers.

      @namespace Ember
      @property ArrayPolyfills
    */
    __exports__.map = map;
    __exports__.forEach = forEach;
    __exports__.filter = filter;
    __exports__.indexOf = indexOf;
    __exports__.lastIndexOf = lastIndexOf;
  });
enifed("ember-metal/binding",
  ["ember-metal/core","ember-metal/property_get","ember-metal/property_set","ember-metal/utils","ember-metal/observer","ember-metal/run_loop","ember-metal/path_cache","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    // Ember.Logger, Ember.LOG_BINDINGS, assert
    var get = __dependency2__.get;
    var set = __dependency3__.set;
    var trySet = __dependency3__.trySet;
    var guidFor = __dependency4__.guidFor;
    var addObserver = __dependency5__.addObserver;
    var removeObserver = __dependency5__.removeObserver;
    var _suspendObserver = __dependency5__._suspendObserver;
    var run = __dependency6__["default"];
    var isGlobalPath = __dependency7__.isGlobal;


    // ES6TODO: where is Ember.lookup defined?
    /**
    @module ember-metal
    */

    // ..........................................................
    // CONSTANTS
    //

    /**
      Debug parameter you can turn on. This will log all bindings that fire to
      the console. This should be disabled in production code. Note that you
      can also enable this from the console or temporarily.

      @property LOG_BINDINGS
      @for Ember
      @type Boolean
      @default false
    */
    Ember.LOG_BINDINGS = false || !!Ember.ENV.LOG_BINDINGS;

    /**
      Returns true if the provided path is global (e.g., `MyApp.fooController.bar`)
      instead of local (`foo.bar.baz`).

      @method isGlobalPath
      @for Ember
      @private
      @param {String} path
      @return Boolean
    */

    function getWithGlobals(obj, path) {
      return get(isGlobalPath(path) ? Ember.lookup : obj, path);
    }

    // ..........................................................
    // BINDING
    //

    function Binding(toPath, fromPath) {
      this._direction = undefined;
      this._from = fromPath;
      this._to   = toPath;
      this._readyToSync = undefined;
      this._oneWay = undefined;
    }

    /**
    @class Binding
    @namespace Ember
    */

    Binding.prototype = {
      /**
        This copies the Binding so it can be connected to another object.

        @method copy
        @return {Ember.Binding} `this`
      */
      copy: function () {
        var copy = new Binding(this._to, this._from);
        if (this._oneWay) { copy._oneWay = true; }
        return copy;
      },

      // ..........................................................
      // CONFIG
      //

      /**
        This will set `from` property path to the specified value. It will not
        attempt to resolve this property path to an actual object until you
        connect the binding.

        The binding will search for the property path starting at the root object
        you pass when you `connect()` the binding. It follows the same rules as
        `get()` - see that method for more information.

        @method from
        @param {String} path the property path to connect to
        @return {Ember.Binding} `this`
      */
      from: function(path) {
        this._from = path;
        return this;
      },

      /**
        This will set the `to` property path to the specified value. It will not
        attempt to resolve this property path to an actual object until you
        connect the binding.

        The binding will search for the property path starting at the root object
        you pass when you `connect()` the binding. It follows the same rules as
        `get()` - see that method for more information.

        @method to
        @param {String|Tuple} path A property path or tuple
        @return {Ember.Binding} `this`
      */
      to: function(path) {
        this._to = path;
        return this;
      },

      /**
        Configures the binding as one way. A one-way binding will relay changes
        on the `from` side to the `to` side, but not the other way around. This
        means that if you change the `to` side directly, the `from` side may have
        a different value.

        @method oneWay
        @return {Ember.Binding} `this`
      */
      oneWay: function() {
        this._oneWay = true;
        return this;
      },

      /**
        @method toString
        @return {String} string representation of binding
      */
      toString: function() {
        var oneWay = this._oneWay ? '[oneWay]' : '';
        return "Ember.Binding<" + guidFor(this) + ">(" + this._from + " -> " + this._to + ")" + oneWay;
      },

      // ..........................................................
      // CONNECT AND SYNC
      //

      /**
        Attempts to connect this binding instance so that it can receive and relay
        changes. This method will raise an exception if you have not set the
        from/to properties yet.

        @method connect
        @param {Object} obj The root object for this binding.
        @return {Ember.Binding} `this`
      */
      connect: function(obj) {
        Ember.assert('Must pass a valid object to Ember.Binding.connect()', !!obj);

        var fromPath = this._from;
        var toPath = this._to;
        trySet(obj, toPath, getWithGlobals(obj, fromPath));

        // add an observer on the object to be notified when the binding should be updated
        addObserver(obj, fromPath, this, this.fromDidChange);

        // if the binding is a two-way binding, also set up an observer on the target
        if (!this._oneWay) { addObserver(obj, toPath, this, this.toDidChange); }

        this._readyToSync = true;

        return this;
      },

      /**
        Disconnects the binding instance. Changes will no longer be relayed. You
        will not usually need to call this method.

        @method disconnect
        @param {Object} obj The root object you passed when connecting the binding.
        @return {Ember.Binding} `this`
      */
      disconnect: function(obj) {
        Ember.assert('Must pass a valid object to Ember.Binding.disconnect()', !!obj);

        var twoWay = !this._oneWay;

        // remove an observer on the object so we're no longer notified of
        // changes that should update bindings.
        removeObserver(obj, this._from, this, this.fromDidChange);

        // if the binding is two-way, remove the observer from the target as well
        if (twoWay) { removeObserver(obj, this._to, this, this.toDidChange); }

        this._readyToSync = false; // disable scheduled syncs...
        return this;
      },

      // ..........................................................
      // PRIVATE
      //

      /* called when the from side changes */
      fromDidChange: function(target) {
        this._scheduleSync(target, 'fwd');
      },

      /* called when the to side changes */
      toDidChange: function(target) {
        this._scheduleSync(target, 'back');
      },

      _scheduleSync: function(obj, dir) {
        var existingDir = this._direction;

        // if we haven't scheduled the binding yet, schedule it
        if (existingDir === undefined) {
          run.schedule('sync', this, this._sync, obj);
          this._direction  = dir;
        }

        // If both a 'back' and 'fwd' sync have been scheduled on the same object,
        // default to a 'fwd' sync so that it remains deterministic.
        if (existingDir === 'back' && dir === 'fwd') {
          this._direction = 'fwd';
        }
      },

      _sync: function(obj) {
        var log = Ember.LOG_BINDINGS;

        // don't synchronize destroyed objects or disconnected bindings
        if (obj.isDestroyed || !this._readyToSync) { return; }

        // get the direction of the binding for the object we are
        // synchronizing from
        var direction = this._direction;

        var fromPath = this._from;
        var toPath = this._to;

        this._direction = undefined;

        // if we're synchronizing from the remote object...
        if (direction === 'fwd') {
          var fromValue = getWithGlobals(obj, this._from);
          if (log) {
            Ember.Logger.log(' ', this.toString(), '->', fromValue, obj);
          }
          if (this._oneWay) {
            trySet(obj, toPath, fromValue);
          } else {
            _suspendObserver(obj, toPath, this, this.toDidChange, function () {
              trySet(obj, toPath, fromValue);
            });
          }
        // if we're synchronizing *to* the remote object
        } else if (direction === 'back') {
          var toValue = get(obj, this._to);
          if (log) {
            Ember.Logger.log(' ', this.toString(), '<-', toValue, obj);
          }
          _suspendObserver(obj, fromPath, this, this.fromDidChange, function () {
            trySet(isGlobalPath(fromPath) ? Ember.lookup : obj, fromPath, toValue);
          });
        }
      }

    };

    function mixinProperties(to, from) {
      for (var key in from) {
        if (from.hasOwnProperty(key)) {
          to[key] = from[key];
        }
      }
    }

    mixinProperties(Binding, {

      /*
        See `Ember.Binding.from`.

        @method from
        @static
      */
      from: function(from) {
        var C = this;
        return new C(undefined, from);
      },

      /*
        See `Ember.Binding.to`.

        @method to
        @static
      */
      to: function(to) {
        var C = this;
        return new C(to, undefined);
      },

      /**
        Creates a new Binding instance and makes it apply in a single direction.
        A one-way binding will relay changes on the `from` side object (supplied
        as the `from` argument) the `to` side, but not the other way around.
        This means that if you change the "to" side directly, the "from" side may have
        a different value.

        See `Binding.oneWay`.

        @method oneWay
        @param {String} from from path.
        @param {Boolean} [flag] (Optional) passing nothing here will make the
          binding `oneWay`. You can instead pass `false` to disable `oneWay`, making the
          binding two way again.
        @return {Ember.Binding} `this`
      */
      oneWay: function(from, flag) {
        var C = this;
        return new C(undefined, from).oneWay(flag);
      }

    });
    /**
      An `Ember.Binding` connects the properties of two objects so that whenever
      the value of one property changes, the other property will be changed also.

      ## Automatic Creation of Bindings with `/^*Binding/`-named Properties

      You do not usually create Binding objects directly but instead describe
      bindings in your class or object definition using automatic binding
      detection.

      Properties ending in a `Binding` suffix will be converted to `Ember.Binding`
      instances. The value of this property should be a string representing a path
      to another object or a custom binding instance created using Binding helpers
      (see "One Way Bindings"):

      ```
      valueBinding: "MyApp.someController.title"
      ```

      This will create a binding from `MyApp.someController.title` to the `value`
      property of your object instance automatically. Now the two values will be
      kept in sync.

      ## One Way Bindings

      One especially useful binding customization you can use is the `oneWay()`
      helper. This helper tells Ember that you are only interested in
      receiving changes on the object you are binding from. For example, if you
      are binding to a preference and you want to be notified if the preference
      has changed, but your object will not be changing the preference itself, you
      could do:

      ```
      bigTitlesBinding: Ember.Binding.oneWay("MyApp.preferencesController.bigTitles")
      ```

      This way if the value of `MyApp.preferencesController.bigTitles` changes the
      `bigTitles` property of your object will change also. However, if you
      change the value of your `bigTitles` property, it will not update the
      `preferencesController`.

      One way bindings are almost twice as fast to setup and twice as fast to
      execute because the binding only has to worry about changes to one side.

      You should consider using one way bindings anytime you have an object that
      may be created frequently and you do not intend to change a property; only
      to monitor it for changes (such as in the example above).

      ## Adding Bindings Manually

      All of the examples above show you how to configure a custom binding, but the
      result of these customizations will be a binding template, not a fully active
      Binding instance. The binding will actually become active only when you
      instantiate the object the binding belongs to. It is useful however, to
      understand what actually happens when the binding is activated.

      For a binding to function it must have at least a `from` property and a `to`
      property. The `from` property path points to the object/key that you want to
      bind from while the `to` path points to the object/key you want to bind to.

      When you define a custom binding, you are usually describing the property
      you want to bind from (such as `MyApp.someController.value` in the examples
      above). When your object is created, it will automatically assign the value
      you want to bind `to` based on the name of your binding key. In the
      examples above, during init, Ember objects will effectively call
      something like this on your binding:

      ```javascript
      binding = Ember.Binding.from("valueBinding").to("value");
      ```

      This creates a new binding instance based on the template you provide, and
      sets the to path to the `value` property of the new object. Now that the
      binding is fully configured with a `from` and a `to`, it simply needs to be
      connected to become active. This is done through the `connect()` method:

      ```javascript
      binding.connect(this);
      ```

      Note that when you connect a binding you pass the object you want it to be
      connected to. This object will be used as the root for both the from and
      to side of the binding when inspecting relative paths. This allows the
      binding to be automatically inherited by subclassed objects as well.

      This also allows you to bind between objects using the paths you declare in
      `from` and `to`:

      ```javascript
      // Example 1
      binding = Ember.Binding.from("App.someObject.value").to("value");
      binding.connect(this);

      // Example 2
      binding = Ember.Binding.from("parentView.value").to("App.someObject.value");
      binding.connect(this);
      ```

      Now that the binding is connected, it will observe both the from and to side
      and relay changes.

      If you ever needed to do so (you almost never will, but it is useful to
      understand this anyway), you could manually create an active binding by
      using the `Ember.bind()` helper method. (This is the same method used by
      to setup your bindings on objects):

      ```javascript
      Ember.bind(MyApp.anotherObject, "value", "MyApp.someController.value");
      ```

      Both of these code fragments have the same effect as doing the most friendly
      form of binding creation like so:

      ```javascript
      MyApp.anotherObject = Ember.Object.create({
        valueBinding: "MyApp.someController.value",

        // OTHER CODE FOR THIS OBJECT...
      });
      ```

      Ember's built in binding creation method makes it easy to automatically
      create bindings for you. You should always use the highest-level APIs
      available, even if you understand how it works underneath.

      @class Binding
      @namespace Ember
      @since Ember 0.9
    */
    // Ember.Binding = Binding; ES6TODO: where to put this?


    /**
      Global helper method to create a new binding. Just pass the root object
      along with a `to` and `from` path to create and connect the binding.

      @method bind
      @for Ember
      @param {Object} obj The root object of the transform.
      @param {String} to The path to the 'to' side of the binding.
        Must be relative to obj.
      @param {String} from The path to the 'from' side of the binding.
        Must be relative to obj or a global path.
      @return {Ember.Binding} binding instance
    */
    function bind(obj, to, from) {
      return new Binding(to, from).connect(obj);
    }

    __exports__.bind = bind;/**
      @method oneWay
      @for Ember
      @param {Object} obj The root object of the transform.
      @param {String} to The path to the 'to' side of the binding.
        Must be relative to obj.
      @param {String} from The path to the 'from' side of the binding.
        Must be relative to obj or a global path.
      @return {Ember.Binding} binding instance
    */
    function oneWay(obj, to, from) {
      return new Binding(to, from).oneWay().connect(obj);
    }

    __exports__.oneWay = oneWay;__exports__.Binding = Binding;
    __exports__.isGlobalPath = isGlobalPath;
  });
enifed("ember-metal/cache",
  ["ember-metal/dictionary","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var dictionary = __dependency1__["default"];
    __exports__["default"] = Cache;

    function Cache(limit, func) {
      this.store  = dictionary(null);
      this.size   = 0;
      this.misses = 0;
      this.hits   = 0;
      this.limit  = limit;
      this.func   = func;
    }

    var FALSE     = function() { };
    var ZERO      = function() { };
    var UNDEFINED = function() { };
    var NULL      = function() { };

    Cache.prototype = {
      set: function(key, value) {
        if (this.limit > this.size) {
          this.size ++;
          if (value === undefined) {
            this.store[key] = UNDEFINED;
          } else {
            this.store[key] = value;
          }
        }

        return value;
      },

      get: function(key) {
        var value = this.store[key];

        if (value === undefined) {
          this.misses ++;
          value = this.set(key, this.func(key));
        } else if (value === UNDEFINED) {
          this.hits ++;
          value = undefined;
        } else {
          this.hits ++;
          // nothing to translate
        }

        return value;
      },

      purge: function() {
        this.store  = dictionary(null);
        this.size   = 0;
        this.hits   = 0;
        this.misses = 0;
      }
    };
  });
enifed("ember-metal/chains",
  ["ember-metal/core","ember-metal/property_get","ember-metal/utils","ember-metal/array","ember-metal/watch_key","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    // warn, assert, etc;
    var get = __dependency2__.get;
    var normalizeTuple = __dependency2__.normalizeTuple;
    var meta = __dependency3__.meta;
    var forEach = __dependency4__.forEach;
    var watchKey = __dependency5__.watchKey;
    var unwatchKey = __dependency5__.unwatchKey;

    var metaFor = meta;
    var warn = Ember.warn;
    var FIRST_KEY = /^([^\.]+)/;

    function firstKey(path) {
      return path.match(FIRST_KEY)[0];
    }

    var pendingQueue = [];

    // attempts to add the pendingQueue chains again. If some of them end up
    // back in the queue and reschedule is true, schedules a timeout to try
    // again.
    function flushPendingChains() {
      if (pendingQueue.length === 0) { return; } // nothing to do

      var queue = pendingQueue;
      pendingQueue = [];

      forEach.call(queue, function(q) { q[0].add(q[1]); });

      warn('Watching an undefined global, Ember expects watched globals to be setup by the time the run loop is flushed, check for typos', pendingQueue.length === 0);
    }

    __exports__.flushPendingChains = flushPendingChains;function addChainWatcher(obj, keyName, node) {
      if (!obj || ('object' !== typeof obj)) { return; } // nothing to do

      var m = metaFor(obj);
      var nodes = m.chainWatchers;

      if (!m.hasOwnProperty('chainWatchers')) {
        nodes = m.chainWatchers = {};
      }

      if (!nodes[keyName]) { nodes[keyName] = []; }
      nodes[keyName].push(node);
      watchKey(obj, keyName, m);
    }

    function removeChainWatcher(obj, keyName, node) {
      if (!obj || 'object' !== typeof obj) { return; } // nothing to do

      var m = obj['__ember_meta__'];
      if (m && !m.hasOwnProperty('chainWatchers')) { return; } // nothing to do

      var nodes = m && m.chainWatchers;

      if (nodes && nodes[keyName]) {
        nodes = nodes[keyName];
        for (var i = 0, l = nodes.length; i < l; i++) {
          if (nodes[i] === node) {
            nodes.splice(i, 1);
            break;
          }
        }
      }
      unwatchKey(obj, keyName, m);
    }

    // A ChainNode watches a single key on an object. If you provide a starting
    // value for the key then the node won't actually watch it. For a root node
    // pass null for parent and key and object for value.
    function ChainNode(parent, key, value) {
      this._parent = parent;
      this._key    = key;

      // _watching is true when calling get(this._parent, this._key) will
      // return the value of this node.
      //
      // It is false for the root of a chain (because we have no parent)
      // and for global paths (because the parent node is the object with
      // the observer on it)
      this._watching = value===undefined;

      this._value  = value;
      this._paths = {};
      if (this._watching) {
        this._object = parent.value();
        if (this._object) { addChainWatcher(this._object, this._key, this); }
      }

      // Special-case: the EachProxy relies on immediate evaluation to
      // establish its observers.
      //
      // TODO: Replace this with an efficient callback that the EachProxy
      // can implement.
      if (this._parent && this._parent._key === '@each') {
        this.value();
      }
    }

    var ChainNodePrototype = ChainNode.prototype;

    function lazyGet(obj, key) {
      if (!obj) return undefined;

      var meta = obj['__ember_meta__'];
      // check if object meant only to be a prototype
      if (meta && meta.proto === obj) return undefined;

      if (key === "@each") return get(obj, key);

      // if a CP only return cached value
      var desc = meta && meta.descs[key];
      if (desc && desc._cacheable) {
        if (key in meta.cache) {
          return meta.cache[key];
        } else {
          return undefined;
        }
      }

      return get(obj, key);
    }

    ChainNodePrototype.value = function() {
      if (this._value === undefined && this._watching) {
        var obj = this._parent.value();
        this._value = lazyGet(obj, this._key);
      }
      return this._value;
    };

    ChainNodePrototype.destroy = function() {
      if (this._watching) {
        var obj = this._object;
        if (obj) { removeChainWatcher(obj, this._key, this); }
        this._watching = false; // so future calls do nothing
      }
    };

    // copies a top level object only
    ChainNodePrototype.copy = function(obj) {
      var ret = new ChainNode(null, null, obj);
      var paths = this._paths;
      var path;

      for (path in paths) {
        if (paths[path] <= 0) { continue; } // this check will also catch non-number vals.
        ret.add(path);
      }
      return ret;
    };

    // called on the root node of a chain to setup watchers on the specified
    // path.
    ChainNodePrototype.add = function(path) {
      var obj, tuple, key, src, paths;

      paths = this._paths;
      paths[path] = (paths[path] || 0) + 1;

      obj = this.value();
      tuple = normalizeTuple(obj, path);

      // the path was a local path
      if (tuple[0] && tuple[0] === obj) {
        path = tuple[1];
        key  = firstKey(path);
        path = path.slice(key.length+1);

      // global path, but object does not exist yet.
      // put into a queue and try to connect later.
      } else if (!tuple[0]) {
        pendingQueue.push([this, path]);
        tuple.length = 0;
        return;

      // global path, and object already exists
      } else {
        src  = tuple[0];
        key  = path.slice(0, 0-(tuple[1].length+1));
        path = tuple[1];
      }

      tuple.length = 0;
      this.chain(key, path, src);
    };

    // called on the root node of a chain to teardown watcher on the specified
    // path
    ChainNodePrototype.remove = function(path) {
      var obj, tuple, key, src, paths;

      paths = this._paths;
      if (paths[path] > 0) { paths[path]--; }

      obj = this.value();
      tuple = normalizeTuple(obj, path);
      if (tuple[0] === obj) {
        path = tuple[1];
        key  = firstKey(path);
        path = path.slice(key.length+1);
      } else {
        src  = tuple[0];
        key  = path.slice(0, 0-(tuple[1].length+1));
        path = tuple[1];
      }

      tuple.length = 0;
      this.unchain(key, path);
    };

    ChainNodePrototype.count = 0;

    ChainNodePrototype.chain = function(key, path, src) {
      var chains = this._chains;
      var node;
      if (!chains) { chains = this._chains = {}; }

      node = chains[key];
      if (!node) { node = chains[key] = new ChainNode(this, key, src); }
      node.count++; // count chains...

      // chain rest of path if there is one
      if (path) {
        key = firstKey(path);
        path = path.slice(key.length+1);
        node.chain(key, path); // NOTE: no src means it will observe changes...
      }
    };

    ChainNodePrototype.unchain = function(key, path) {
      var chains = this._chains;
      var node = chains[key];

      // unchain rest of path first...
      if (path && path.length>1) {
        key  = firstKey(path);
        path = path.slice(key.length+1);
        node.unchain(key, path);
      }

      // delete node if needed.
      node.count--;
      if (node.count<=0) {
        delete chains[node._key];
        node.destroy();
      }

    };

    ChainNodePrototype.willChange = function(events) {
      var chains = this._chains;
      if (chains) {
        for(var key in chains) {
          if (!chains.hasOwnProperty(key)) { continue; }
          chains[key].willChange(events);
        }
      }

      if (this._parent) { this._parent.chainWillChange(this, this._key, 1, events); }
    };

    ChainNodePrototype.chainWillChange = function(chain, path, depth, events) {
      if (this._key) { path = this._key + '.' + path; }

      if (this._parent) {
        this._parent.chainWillChange(this, path, depth+1, events);
      } else {
        if (depth > 1) {
          events.push(this.value(), path);
        }
        path = 'this.' + path;
        if (this._paths[path] > 0) {
          events.push(this.value(), path);
        }
      }
    };

    ChainNodePrototype.chainDidChange = function(chain, path, depth, events) {
      if (this._key) { path = this._key + '.' + path; }
      if (this._parent) {
        this._parent.chainDidChange(this, path, depth+1, events);
      } else {
        if (depth > 1) {
          events.push(this.value(), path);
        }
        path = 'this.' + path;
        if (this._paths[path] > 0) {
          events.push(this.value(), path);
        }
      }
    };

    ChainNodePrototype.didChange = function(events) {
      // invalidate my own value first.
      if (this._watching) {
        var obj = this._parent.value();
        if (obj !== this._object) {
          removeChainWatcher(this._object, this._key, this);
          this._object = obj;
          addChainWatcher(obj, this._key, this);
        }
        this._value  = undefined;

        // Special-case: the EachProxy relies on immediate evaluation to
        // establish its observers.
        if (this._parent && this._parent._key === '@each')
          this.value();
      }

      // then notify chains...
      var chains = this._chains;
      if (chains) {
        for(var key in chains) {
          if (!chains.hasOwnProperty(key)) { continue; }
          chains[key].didChange(events);
        }
      }

      // if no events are passed in then we only care about the above wiring update
      if (events === null) { return; }

      // and finally tell parent about my path changing...
      if (this._parent) { this._parent.chainDidChange(this, this._key, 1, events); }
    };

    function finishChains(obj) {
      // We only create meta if we really have to
      var m = obj['__ember_meta__'],
        chains, chainWatchers, chainNodes;
      if (m) {
        // finish any current chains node watchers that reference obj
        chainWatchers = m.chainWatchers;
        if (chainWatchers) {
          for(var key in chainWatchers) {
            if (!chainWatchers.hasOwnProperty(key)) { continue; }
            chainNodes = chainWatchers[key];
            if (chainNodes) {
              for (var i=0,l=chainNodes.length;i<l;i++) {
                chainNodes[i].didChange(null);
              }
            }
          }
        }
        // copy chains from prototype
        chains = m.chains;
        if (chains && chains.value() !== obj) {
          metaFor(obj).chains = chains = chains.copy(obj);
        }
      }
    }

    __exports__.finishChains = finishChains;__exports__.removeChainWatcher = removeChainWatcher;
    __exports__.ChainNode = ChainNode;
  });
enifed("ember-metal/computed",
  ["ember-metal/core","ember-metal/property_get","ember-metal/property_set","ember-metal/utils","ember-metal/expand_properties","ember-metal/error","ember-metal/properties","ember-metal/property_events","ember-metal/dependent_keys","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    var get = __dependency2__.get;
    var set = __dependency3__.set;
    var meta = __dependency4__.meta;
    var inspect = __dependency4__.inspect;
    var expandProperties = __dependency5__["default"];
    var EmberError = __dependency6__["default"];
    var Descriptor = __dependency7__.Descriptor;
    var defineProperty = __dependency7__.defineProperty;
    var propertyWillChange = __dependency8__.propertyWillChange;
    var propertyDidChange = __dependency8__.propertyDidChange;
    var addDependentKeys = __dependency9__.addDependentKeys;
    var removeDependentKeys = __dependency9__.removeDependentKeys;

    /**
    @module ember-metal
    */

    Ember.warn("The CP_DEFAULT_CACHEABLE flag has been removed and computed properties are always cached by default. Use `volatile` if you don't want caching.", Ember.ENV.CP_DEFAULT_CACHEABLE !== false);


    var metaFor = meta;
    var a_slice = [].slice;

    function UNDEFINED() { }

    // ..........................................................
    // COMPUTED PROPERTY
    //

    /**
      A computed property transforms an objects function into a property.

      By default the function backing the computed property will only be called
      once and the result will be cached. You can specify various properties
      that your computed property is dependent on. This will force the cached
      result to be recomputed if the dependencies are modified.

      In the following example we declare a computed property (by calling
      `.property()` on the fullName function) and setup the properties
      dependencies (depending on firstName and lastName). The fullName function
      will be called once (regardless of how many times it is accessed) as long
      as it's dependencies have not been changed. Once firstName or lastName are updated
      any future calls (or anything bound) to fullName will incorporate the new
      values.

      ```javascript
      var Person = Ember.Object.extend({
        // these will be supplied by `create`
        firstName: null,
        lastName: null,

        fullName: function() {
          var firstName = this.get('firstName');
          var lastName = this.get('lastName');

         return firstName + ' ' + lastName;
        }.property('firstName', 'lastName')
      });

      var tom = Person.create({
        firstName: 'Tom',
        lastName: 'Dale'
      });

      tom.get('fullName') // 'Tom Dale'
      ```

      You can also define what Ember should do when setting a computed property.
      If you try to set a computed property, it will be invoked with the key and
      value you want to set it to. You can also accept the previous value as the
      third parameter.

      ```javascript
      var Person = Ember.Object.extend({
        // these will be supplied by `create`
        firstName: null,
        lastName: null,

        fullName: function(key, value, oldValue) {
          // getter
          if (arguments.length === 1) {
            var firstName = this.get('firstName');
            var lastName = this.get('lastName');

            return firstName + ' ' + lastName;

          // setter
          } else {
            var name = value.split(' ');

            this.set('firstName', name[0]);
            this.set('lastName', name[1]);

            return value;
          }
        }.property('firstName', 'lastName')
      });

      var person = Person.create();

      person.set('fullName', 'Peter Wagenet');
      person.get('firstName'); // 'Peter'
      person.get('lastName');  // 'Wagenet'
      ```

      @class ComputedProperty
      @namespace Ember
      @extends Ember.Descriptor
      @constructor
    */
    function ComputedProperty(func, opts) {
      func.__ember_arity__ = func.length;
      this.func = func;

      this._cacheable = (opts && opts.cacheable !== undefined) ? opts.cacheable : true;
      this._dependentKeys = opts && opts.dependentKeys;
      this._readOnly = opts && (opts.readOnly !== undefined || !!opts.readOnly) || false;
    }

    ComputedProperty.prototype = new Descriptor();

    var ComputedPropertyPrototype = ComputedProperty.prototype;
    ComputedPropertyPrototype._dependentKeys = undefined;
    ComputedPropertyPrototype._suspended = undefined;
    ComputedPropertyPrototype._meta = undefined;

    /**
      Properties are cacheable by default. Computed property will automatically
      cache the return value of your function until one of the dependent keys changes.

      Call `volatile()` to set it into non-cached mode. When in this mode
      the computed property will not automatically cache the return value.

      However, if a property is properly observable, there is no reason to disable
      caching.

      @method cacheable
      @param {Boolean} aFlag optional set to `false` to disable caching
      @return {Ember.ComputedProperty} this
      @chainable
    */
    ComputedPropertyPrototype.cacheable = function(aFlag) {
      this._cacheable = aFlag !== false;
      return this;
    };

    /**
      Call on a computed property to set it into non-cached mode. When in this
      mode the computed property will not automatically cache the return value.

      ```javascript
      var outsideService = Ember.Object.extend({
        value: function() {
          return OutsideService.getValue();
        }.property().volatile()
      }).create();
      ```

      @method volatile
      @return {Ember.ComputedProperty} this
      @chainable
    */
    ComputedPropertyPrototype["volatile"] = function() {
      return this.cacheable(false);
    };

    /**
      Call on a computed property to set it into read-only mode. When in this
      mode the computed property will throw an error when set.

      ```javascript
      var Person = Ember.Object.extend({
        guid: function() {
          return 'guid-guid-guid';
        }.property().readOnly()
      });

      var person = Person.create();

      person.set('guid', 'new-guid'); // will throw an exception
      ```

      @method readOnly
      @return {Ember.ComputedProperty} this
      @chainable
    */
    ComputedPropertyPrototype.readOnly = function(readOnly) {
      this._readOnly = readOnly === undefined || !!readOnly;
      return this;
    };

    /**
      Sets the dependent keys on this computed property. Pass any number of
      arguments containing key paths that this computed property depends on.

      ```javascript
      var President = Ember.Object.extend({
        fullName: computed(function() {
          return this.get('firstName') + ' ' + this.get('lastName');

          // Tell Ember that this computed property depends on firstName
          // and lastName
        }).property('firstName', 'lastName')
      });

      var president = President.create({
        firstName: 'Barack',
        lastName: 'Obama'
      });

      president.get('fullName'); // 'Barack Obama'
      ```

      @method property
      @param {String} path* zero or more property paths
      @return {Ember.ComputedProperty} this
      @chainable
    */
    ComputedPropertyPrototype.property = function() {
      var args;

      var addArg = function (property) {
        args.push(property);
      };

      args = [];
      for (var i = 0, l = arguments.length; i < l; i++) {
        expandProperties(arguments[i], addArg);
      }

      this._dependentKeys = args;
      return this;
    };

    /**
      In some cases, you may want to annotate computed properties with additional
      metadata about how they function or what values they operate on. For example,
      computed property functions may close over variables that are then no longer
      available for introspection.

      You can pass a hash of these values to a computed property like this:

      ```
      person: function() {
        var personId = this.get('personId');
        return App.Person.create({ id: personId });
      }.property().meta({ type: App.Person })
      ```

      The hash that you pass to the `meta()` function will be saved on the
      computed property descriptor under the `_meta` key. Ember runtime
      exposes a public API for retrieving these values from classes,
      via the `metaForProperty()` function.

      @method meta
      @param {Hash} meta
      @chainable
    */

    ComputedPropertyPrototype.meta = function(meta) {
      if (arguments.length === 0) {
        return this._meta || {};
      } else {
        this._meta = meta;
        return this;
      }
    };

    /* impl descriptor API */
    ComputedPropertyPrototype.didChange = function(obj, keyName) {
      // _suspended is set via a CP.set to ensure we don't clear
      // the cached value set by the setter
      if (this._cacheable && this._suspended !== obj) {
        var meta = metaFor(obj);
        if (meta.cache[keyName] !== undefined) {
          meta.cache[keyName] = undefined;
          removeDependentKeys(this, obj, keyName, meta);
        }
      }
    };

    function finishChains(chainNodes)
    {
      for (var i=0, l=chainNodes.length; i<l; i++) {
        chainNodes[i].didChange(null);
      }
    }

    /**
      Access the value of the function backing the computed property.
      If this property has already been cached, return the cached result.
      Otherwise, call the function passing the property name as an argument.

      ```javascript
      var Person = Ember.Object.extend({
        fullName: function(keyName) {
          // the keyName parameter is 'fullName' in this case.
          return this.get('firstName') + ' ' + this.get('lastName');
        }.property('firstName', 'lastName')
      });


      var tom = Person.create({
        firstName: 'Tom',
        lastName: 'Dale'
      });

      tom.get('fullName') // 'Tom Dale'
      ```

      @method get
      @param {String} keyName The key being accessed.
      @return {Object} The return value of the function backing the CP.
    */
    ComputedPropertyPrototype.get = function(obj, keyName) {
      var ret, cache, meta, chainNodes;
      if (this._cacheable) {
        meta = metaFor(obj);
        cache = meta.cache;

        var result = cache[keyName];

        if (result === UNDEFINED) {
          return undefined;
        }  else if (result !== undefined) {
          return result;
        }

        ret = this.func.call(obj, keyName);
        if (ret === undefined) {
          cache[keyName] = UNDEFINED;
        } else {
          cache[keyName] = ret;
        }

        chainNodes = meta.chainWatchers && meta.chainWatchers[keyName];
        if (chainNodes) { finishChains(chainNodes); }
        addDependentKeys(this, obj, keyName, meta);
      } else {
        ret = this.func.call(obj, keyName);
      }
      return ret;
    };

    /**
      Set the value of a computed property. If the function that backs your
      computed property does not accept arguments then the default action for
      setting would be to define the property on the current object, and set
      the value of the property to the value being set.

      Generally speaking if you intend for your computed property to be set
      your backing function should accept either two or three arguments.

      ```javascript
      var Person = Ember.Object.extend({
        // these will be supplied by `create`
        firstName: null,
        lastName: null,

        fullName: function(key, value, oldValue) {
          // getter
          if (arguments.length === 1) {
            var firstName = this.get('firstName');
            var lastName = this.get('lastName');

            return firstName + ' ' + lastName;

          // setter
          } else {
            var name = value.split(' ');

            this.set('firstName', name[0]);
            this.set('lastName', name[1]);

            return value;
          }
        }.property('firstName', 'lastName')
      });

      var person = Person.create();

      person.set('fullName', 'Peter Wagenet');
      person.get('firstName'); // 'Peter'
      person.get('lastName');  // 'Wagenet'
      ```

      @method set
      @param {String} keyName The key being accessed.
      @param {Object} newValue The new value being assigned.
      @param {String} oldValue The old value being replaced.
      @return {Object} The return value of the function backing the CP.
    */
    ComputedPropertyPrototype.set = function computedPropertySetWithSuspend(obj, keyName, value) {
      var oldSuspended = this._suspended;

      this._suspended = obj;

      try {
        this._set(obj, keyName, value);
      } finally {
        this._suspended = oldSuspended;
      }
    };

    ComputedPropertyPrototype._set = function computedPropertySet(obj, keyName, value) {
      var cacheable      = this._cacheable;
      var func           = this.func;
      var meta           = metaFor(obj, cacheable);
      var cache          = meta.cache;
      var hadCachedValue = false;

      var funcArgLength, cachedValue, ret;

      if (this._readOnly) {
        throw new EmberError('Cannot set read-only property "' + keyName + '" on object: ' + inspect(obj));
      }

      if (cacheable && cache[keyName] !== undefined) {
        if(cache[keyName] !== UNDEFINED) {
          cachedValue = cache[keyName];
        }

        hadCachedValue = true;
      }

      // Check if the CP has been wrapped. If it has, use the
      // length from the wrapped function.

      funcArgLength = func.wrappedFunction ? func.wrappedFunction.__ember_arity__ : func.__ember_arity__;

      // For backwards-compatibility with computed properties
      // that check for arguments.length === 2 to determine if
      // they are being get or set, only pass the old cached
      // value if the computed property opts into a third
      // argument.
      if (funcArgLength === 3) {
        ret = func.call(obj, keyName, value, cachedValue);
      } else if (funcArgLength === 2) {
        ret = func.call(obj, keyName, value);
      } else {
        defineProperty(obj, keyName, null, cachedValue);
        set(obj, keyName, value);
        return;
      }

      if (hadCachedValue && cachedValue === ret) { return; }

      var watched = meta.watching[keyName];
      if (watched) {
        propertyWillChange(obj, keyName);
      }

      if (hadCachedValue) {
        cache[keyName] = undefined;
      }

      if (cacheable) {
        if (!hadCachedValue) {
          addDependentKeys(this, obj, keyName, meta);
        }
        if (ret === undefined) {
          cache[keyName] = UNDEFINED;
        } else {
          cache[keyName] = ret;
        }
      }

      if (watched) {
        propertyDidChange(obj, keyName);
      }

      return ret;
    };

    /* called before property is overridden */
    ComputedPropertyPrototype.teardown = function(obj, keyName) {
      var meta = metaFor(obj);

      if (keyName in meta.cache) {
        removeDependentKeys(this, obj, keyName, meta);
      }

      if (this._cacheable) { delete meta.cache[keyName]; }

      return null; // no value to restore
    };


    /**
      This helper returns a new property descriptor that wraps the passed
      computed property function. You can use this helper to define properties
      with mixins or via `Ember.defineProperty()`.

      The function you pass will be used to both get and set property values.
      The function should accept two parameters, key and value. If value is not
      undefined you should set the value first. In either case return the
      current value of the property.
      
      A computed property defined in this way might look like this:

      ```js
      var Person = Ember.Object.extend({
        firstName: 'Betty',
        lastName: 'Jones',

        fullName: Ember.computed('firstName', 'lastName', function(key, value) {
          return this.get('firstName') + ' ' + this.get('lastName');
        })
      });

      var client = Person.create();

      client.get('fullName'); // 'Betty Jones'
      
      client.set('lastName', 'Fuller');
      client.get('fullName'); // 'Betty Fuller'
      ```

      _Note: This is the prefered way to define computed properties when writing third-party
      libraries that depend on or use Ember, since there is no guarantee that the user
      will have prototype extensions enabled._

      You might use this method if you disabled
      [Prototype Extensions](http://emberjs.com/guides/configuring-ember/disabling-prototype-extensions/).
      The alternative syntax might look like this
      (if prototype extensions are enabled, which is the default behavior):

      ```js
      fullName: function () {
        return this.get('firstName') + ' ' + this.get('lastName');
      }.property('firstName', 'lastName')
      ```

      @method computed
      @for Ember
      @param {String} [dependentKeys*] Optional dependent keys that trigger this computed property.
      @param {Function} func The computed property function.
      @return {Ember.ComputedProperty} property descriptor instance
    */
    function computed(func) {
      var args;

      if (arguments.length > 1) {
        args = a_slice.call(arguments);
        func = args.pop();
      }

      if (typeof func !== "function") {
        throw new EmberError("Computed Property declared without a property function");
      }

      var cp = new ComputedProperty(func);

      if (args) {
        cp.property.apply(cp, args);
      }

      return cp;
    }

    /**
      Returns the cached value for a property, if one exists.
      This can be useful for peeking at the value of a computed
      property that is generated lazily, without accidentally causing
      it to be created.

      @method cacheFor
      @for Ember
      @param {Object} obj the object whose property you want to check
      @param {String} key the name of the property whose cached value you want
        to return
      @return {Object} the cached value
    */
    function cacheFor(obj, key) {
      var meta = obj['__ember_meta__'];
      var cache = meta && meta.cache;
      var ret = cache && cache[key];

      if (ret === UNDEFINED) { return undefined; }
      return ret;
    }

    cacheFor.set = function(cache, key, value) {
      if (value === undefined) {
        cache[key] = UNDEFINED;
      } else {
        cache[key] = value;
      }
    };

    cacheFor.get = function(cache, key) {
      var ret = cache[key];
      if (ret === UNDEFINED) { return undefined; }
      return ret;
    };

    cacheFor.remove = function(cache, key) {
      cache[key] = undefined;
    };

    __exports__.ComputedProperty = ComputedProperty;
    __exports__.computed = computed;
    __exports__.cacheFor = cacheFor;
  });
enifed("ember-metal/computed_macros",
  ["ember-metal/core","ember-metal/property_get","ember-metal/property_set","ember-metal/computed","ember-metal/is_empty","ember-metal/is_none","ember-metal/alias"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__) {
    "use strict";
    var Ember = __dependency1__["default"];
    var get = __dependency2__.get;
    var set = __dependency3__.set;
    var computed = __dependency4__.computed;
    var isEmpty = __dependency5__["default"];
    var isNone = __dependency6__.isNone;
    var alias = __dependency7__.alias;

    /**
    @module ember-metal
    */

    var a_slice = [].slice;

    function getProperties(self, propertyNames) {
      var ret = {};
      for(var i = 0; i < propertyNames.length; i++) {
        ret[propertyNames[i]] = get(self, propertyNames[i]);
      }
      return ret;
    }

    function registerComputed(name, macro) {
      computed[name] = function(dependentKey) {
        var args = a_slice.call(arguments);
        return computed(dependentKey, function() {
          return macro.apply(this, args);
        });
      };
    }

    function registerComputedWithProperties(name, macro) {
      computed[name] = function() {
        var properties = a_slice.call(arguments);

        var computedFunc = computed(function() {
          return macro.apply(this, [getProperties(this, properties)]);
        });

        return computedFunc.property.apply(computedFunc, properties);
      };
    }

    /**
      A computed property that returns true if the value of the dependent
      property is null, an empty string, empty array, or empty function.

      Example

      ```javascript
      var ToDoList = Ember.Object.extend({
        done: Ember.computed.empty('todos')
      });

      var todoList = ToDoList.create({
        todos: ['Unit Test', 'Documentation', 'Release']
      });

      todoList.get('done'); // false
      todoList.get('todos').clear();
      todoList.get('done'); // true
      ```

      @since 1.6.0
      @method computed.empty
      @for Ember
      @param {String} dependentKey
      @return {Ember.ComputedProperty} computed property which negate
      the original value for property
    */
    computed.empty = function (dependentKey) {
      return computed(dependentKey + '.length', function () {
        return isEmpty(get(this, dependentKey));
      });
    };

    /**
      A computed property that returns true if the value of the dependent
      property is NOT null, an empty string, empty array, or empty function.

      Example

      ```javascript
      var Hamster = Ember.Object.extend({
        hasStuff: Ember.computed.notEmpty('backpack')
      });

      var hamster = Hamster.create({ backpack: ['Food', 'Sleeping Bag', 'Tent'] });

      hamster.get('hasStuff');         // true
      hamster.get('backpack').clear(); // []
      hamster.get('hasStuff');         // false
      ```

      @method computed.notEmpty
      @for Ember
      @param {String} dependentKey
      @return {Ember.ComputedProperty} computed property which returns true if
      original value for property is not empty.
    */
    computed.notEmpty = function(dependentKey) {
      return computed(dependentKey + '.length', function () {
        return !isEmpty(get(this, dependentKey));
      });
    };

    /**
      A computed property that returns true if the value of the dependent
      property is null or undefined. This avoids errors from JSLint complaining
      about use of ==, which can be technically confusing.

      Example

      ```javascript
      var Hamster = Ember.Object.extend({
        isHungry: Ember.computed.none('food')
      });

      var hamster = Hamster.create();

      hamster.get('isHungry'); // true
      hamster.set('food', 'Banana');
      hamster.get('isHungry'); // false
      hamster.set('food', null);
      hamster.get('isHungry'); // true
      ```

      @method computed.none
      @for Ember
      @param {String} dependentKey
      @return {Ember.ComputedProperty} computed property which
      returns true if original value for property is null or undefined.
    */
    registerComputed('none', function(dependentKey) {
      return isNone(get(this, dependentKey));
    });

    /**
      A computed property that returns the inverse boolean value
      of the original value for the dependent property.

      Example

      ```javascript
      var User = Ember.Object.extend({
        isAnonymous: Ember.computed.not('loggedIn')
      });

      var user = User.create({loggedIn: false});

      user.get('isAnonymous'); // true
      user.set('loggedIn', true);
      user.get('isAnonymous'); // false
      ```

      @method computed.not
      @for Ember
      @param {String} dependentKey
      @return {Ember.ComputedProperty} computed property which returns
      inverse of the original value for property
    */
    registerComputed('not', function(dependentKey) {
      return !get(this, dependentKey);
    });

    /**
      A computed property that converts the provided dependent property
      into a boolean value.

      ```javascript
      var Hamster = Ember.Object.extend({
        hasBananas: Ember.computed.bool('numBananas')
      });

      var hamster = Hamster.create();

      hamster.get('hasBananas'); // false
      hamster.set('numBananas', 0);
      hamster.get('hasBananas'); // false
      hamster.set('numBananas', 1);
      hamster.get('hasBananas'); // true
      hamster.set('numBananas', null);
      hamster.get('hasBananas'); // false
      ```

      @method computed.bool
      @for Ember
      @param {String} dependentKey
      @return {Ember.ComputedProperty} computed property which converts
      to boolean the original value for property
    */
    registerComputed('bool', function(dependentKey) {
      return !!get(this, dependentKey);
    });

    /**
      A computed property which matches the original value for the
      dependent property against a given RegExp, returning `true`
      if they values matches the RegExp and `false` if it does not.

      Example

      ```javascript
      var User = Ember.Object.extend({
        hasValidEmail: Ember.computed.match('email', /^.+@.+\..+$/)
      });

      var user = User.create({loggedIn: false});

      user.get('hasValidEmail'); // false
      user.set('email', '');
      user.get('hasValidEmail'); // false
      user.set('email', 'ember_hamster@example.com');
      user.get('hasValidEmail'); // true
      ```

      @method computed.match
      @for Ember
      @param {String} dependentKey
      @param {RegExp} regexp
      @return {Ember.ComputedProperty} computed property which match
      the original value for property against a given RegExp
    */
    registerComputed('match', function(dependentKey, regexp) {
      var value = get(this, dependentKey);
      return typeof value === 'string' ? regexp.test(value) : false;
    });

    /**
      A computed property that returns true if the provided dependent property
      is equal to the given value.

      Example

      ```javascript
      var Hamster = Ember.Object.extend({
        napTime: Ember.computed.equal('state', 'sleepy')
      });

      var hamster = Hamster.create();

      hamster.get('napTime'); // false
      hamster.set('state', 'sleepy');
      hamster.get('napTime'); // true
      hamster.set('state', 'hungry');
      hamster.get('napTime'); // false
      ```

      @method computed.equal
      @for Ember
      @param {String} dependentKey
      @param {String|Number|Object} value
      @return {Ember.ComputedProperty} computed property which returns true if
      the original value for property is equal to the given value.
    */
    registerComputed('equal', function(dependentKey, value) {
      return get(this, dependentKey) === value;
    });

    /**
      A computed property that returns true if the provided dependent property
      is greater than the provided value.

      Example

      ```javascript
      var Hamster = Ember.Object.extend({
        hasTooManyBananas: Ember.computed.gt('numBananas', 10)
      });

      var hamster = Hamster.create();

      hamster.get('hasTooManyBananas'); // false
      hamster.set('numBananas', 3);
      hamster.get('hasTooManyBananas'); // false
      hamster.set('numBananas', 11);
      hamster.get('hasTooManyBananas'); // true
      ```

      @method computed.gt
      @for Ember
      @param {String} dependentKey
      @param {Number} value
      @return {Ember.ComputedProperty} computed property which returns true if
      the original value for property is greater than given value.
    */
    registerComputed('gt', function(dependentKey, value) {
      return get(this, dependentKey) > value;
    });

    /**
      A computed property that returns true if the provided dependent property
      is greater than or equal to the provided value.

      Example

      ```javascript
      var Hamster = Ember.Object.extend({
        hasTooManyBananas: Ember.computed.gte('numBananas', 10)
      });

      var hamster = Hamster.create();

      hamster.get('hasTooManyBananas'); // false
      hamster.set('numBananas', 3);
      hamster.get('hasTooManyBananas'); // false
      hamster.set('numBananas', 10);
      hamster.get('hasTooManyBananas'); // true
      ```

      @method computed.gte
      @for Ember
      @param {String} dependentKey
      @param {Number} value
      @return {Ember.ComputedProperty} computed property which returns true if
      the original value for property is greater or equal then given value.
    */
    registerComputed('gte', function(dependentKey, value) {
      return get(this, dependentKey) >= value;
    });

    /**
      A computed property that returns true if the provided dependent property
      is less than the provided value.

      Example

      ```javascript
      var Hamster = Ember.Object.extend({
        needsMoreBananas: Ember.computed.lt('numBananas', 3)
      });

      var hamster = Hamster.create();

      hamster.get('needsMoreBananas'); // true
      hamster.set('numBananas', 3);
      hamster.get('needsMoreBananas'); // false
      hamster.set('numBananas', 2);
      hamster.get('needsMoreBananas'); // true
      ```

      @method computed.lt
      @for Ember
      @param {String} dependentKey
      @param {Number} value
      @return {Ember.ComputedProperty} computed property which returns true if
      the original value for property is less then given value.
    */
    registerComputed('lt', function(dependentKey, value) {
      return get(this, dependentKey) < value;
    });

    /**
      A computed property that returns true if the provided dependent property
      is less than or equal to the provided value.

      Example

      ```javascript
      var Hamster = Ember.Object.extend({
        needsMoreBananas: Ember.computed.lte('numBananas', 3)
      });

      var hamster = Hamster.create();

      hamster.get('needsMoreBananas'); // true
      hamster.set('numBananas', 5);
      hamster.get('needsMoreBananas'); // false
      hamster.set('numBananas', 3);
      hamster.get('needsMoreBananas'); // true
      ```

      @method computed.lte
      @for Ember
      @param {String} dependentKey
      @param {Number} value
      @return {Ember.ComputedProperty} computed property which returns true if
      the original value for property is less or equal than given value.
    */
    registerComputed('lte', function(dependentKey, value) {
      return get(this, dependentKey) <= value;
    });

    /**
      A computed property that performs a logical `and` on the
      original values for the provided dependent properties.

      Example

      ```javascript
      var Hamster = Ember.Object.extend({
        readyForCamp: Ember.computed.and('hasTent', 'hasBackpack')
      });

      var hamster = Hamster.create();

      hamster.get('readyForCamp'); // false
      hamster.set('hasTent', true);
      hamster.get('readyForCamp'); // false
      hamster.set('hasBackpack', true);
      hamster.get('readyForCamp'); // true
      ```

      @method computed.and
      @for Ember
      @param {String} dependentKey*
      @return {Ember.ComputedProperty} computed property which performs
      a logical `and` on the values of all the original values for properties.
    */
    registerComputedWithProperties('and', function(properties) {
      for (var key in properties) {
        if (properties.hasOwnProperty(key) && !properties[key]) {
          return false;
        }
      }
      return true;
    });

    /**
      A computed property which performs a logical `or` on the
      original values for the provided dependent properties.

      Example

      ```javascript
      var Hamster = Ember.Object.extend({
        readyForRain: Ember.computed.or('hasJacket', 'hasUmbrella')
      });

      var hamster = Hamster.create();

      hamster.get('readyForRain'); // false
      hamster.set('hasJacket', true);
      hamster.get('readyForRain'); // true
      ```

      @method computed.or
      @for Ember
      @param {String} dependentKey*
      @return {Ember.ComputedProperty} computed property which performs
      a logical `or` on the values of all the original values for properties.
    */
    registerComputedWithProperties('or', function(properties) {
      for (var key in properties) {
        if (properties.hasOwnProperty(key) && properties[key]) {
          return true;
        }
      }
      return false;
    });

    /**
      A computed property that returns the first truthy value
      from a list of dependent properties.

      Example

      ```javascript
      var Hamster = Ember.Object.extend({
        hasClothes: Ember.computed.any('hat', 'shirt')
      });

      var hamster = Hamster.create();

      hamster.get('hasClothes'); // null
      hamster.set('shirt', 'Hawaiian Shirt');
      hamster.get('hasClothes'); // 'Hawaiian Shirt'
      ```

      @method computed.any
      @for Ember
      @param {String} dependentKey*
      @return {Ember.ComputedProperty} computed property which returns
      the first truthy value of given list of properties.
    */
    registerComputedWithProperties('any', function(properties) {
      for (var key in properties) {
        if (properties.hasOwnProperty(key) && properties[key]) {
          return properties[key];
        }
      }
      return null;
    });

    /**
      A computed property that returns the array of values
      for the provided dependent properties.

      Example

      ```javascript
      var Hamster = Ember.Object.extend({
        clothes: Ember.computed.collect('hat', 'shirt')
      });

      var hamster = Hamster.create();

      hamster.get('clothes'); // [null, null]
      hamster.set('hat', 'Camp Hat');
      hamster.set('shirt', 'Camp Shirt');
      hamster.get('clothes'); // ['Camp Hat', 'Camp Shirt']
      ```

      @method computed.collect
      @for Ember
      @param {String} dependentKey*
      @return {Ember.ComputedProperty} computed property which maps
      values of all passed in properties to an array.
    */
    registerComputedWithProperties('collect', function(properties) {
      var res = [];
      for (var key in properties) {
        if (properties.hasOwnProperty(key)) {
          if (isNone(properties[key])) {
            res.push(null);
          } else {
            res.push(properties[key]);
          }
        }
      }
      return res;
    });

    /**
      Creates a new property that is an alias for another property
      on an object. Calls to `get` or `set` this property behave as
      though they were called on the original property.

      ```javascript
      var Person = Ember.Object.extend({
        name: 'Alex Matchneer',
        nomen: Ember.computed.alias('name')
      });

      var alex = Person.create();

      alex.get('nomen'); // 'Alex Matchneer'
      alex.get('name');  // 'Alex Matchneer'

      alex.set('nomen', '@machty');
      alex.get('name');  // '@machty'
      ```

      @method computed.alias
      @for Ember
      @param {String} dependentKey
      @return {Ember.ComputedProperty} computed property which creates an
      alias to the original value for property.
    */
    computed.alias = alias;

    /**
      Where `computed.alias` aliases `get` and `set`, and allows for bidirectional
      data flow, `computed.oneWay` only provides an aliased `get`. The `set` will
      not mutate the upstream property, rather causes the current property to
      become the value set. This causes the downstream property to permanently
      diverge from the upstream property.

      Example

      ```javascript
      var User = Ember.Object.extend({
        firstName: null,
        lastName: null,
        nickName: Ember.computed.oneWay('firstName')
      });

      var teddy = User.create({
        firstName: 'Teddy',
        lastName:  'Zeenny'
      });

      teddy.get('nickName');              // 'Teddy'
      teddy.set('nickName', 'TeddyBear'); // 'TeddyBear'
      teddy.get('firstName');             // 'Teddy'
      ```

      @method computed.oneWay
      @for Ember
      @param {String} dependentKey
      @return {Ember.ComputedProperty} computed property which creates a
      one way computed property to the original value for property.
    */
    computed.oneWay = function(dependentKey) {
      return alias(dependentKey).oneWay();
    };

    /**
      This is a more semantically meaningful alias of `computed.oneWay`,
      whose name is somewhat ambiguous as to which direction the data flows.

      @method computed.reads
      @for Ember
      @param {String} dependentKey
      @return {Ember.ComputedProperty} computed property which creates a
        one way computed property to the original value for property.
     */
    computed.reads = computed.oneWay;

    /**
      Where `computed.oneWay` provides oneWay bindings, `computed.readOnly` provides
      a readOnly one way binding. Very often when using `computed.oneWay` one does
      not also want changes to propogate back up, as they will replace the value.

      This prevents the reverse flow, and also throws an exception when it occurs.

      Example

      ```javascript
      var User = Ember.Object.extend({
        firstName: null,
        lastName: null,
        nickName: Ember.computed.readOnly('firstName')
      });

      var teddy = User.create({
        firstName: 'Teddy',
        lastName:  'Zeenny'
      });

      teddy.get('nickName');              // 'Teddy'
      teddy.set('nickName', 'TeddyBear'); // throws Exception
      // throw new Ember.Error('Cannot Set: nickName on: <User:ember27288>' );`
      teddy.get('firstName');             // 'Teddy'
      ```

      @method computed.readOnly
      @for Ember
      @param {String} dependentKey
      @return {Ember.ComputedProperty} computed property which creates a
      one way computed property to the original value for property.
      @since 1.5.0
    */
    computed.readOnly = function(dependentKey) {
      return alias(dependentKey).readOnly();
    };
    /**
      A computed property that acts like a standard getter and setter,
      but returns the value at the provided `defaultPath` if the
      property itself has not been set to a value

      Example

      ```javascript
      var Hamster = Ember.Object.extend({
        wishList: Ember.computed.defaultTo('favoriteFood')
      });

      var hamster = Hamster.create({ favoriteFood: 'Banana' });

      hamster.get('wishList');                     // 'Banana'
      hamster.set('wishList', 'More Unit Tests');
      hamster.get('wishList');                     // 'More Unit Tests'
      hamster.get('favoriteFood');                 // 'Banana'
      ```

      @method computed.defaultTo
      @for Ember
      @param {String} defaultPath
      @return {Ember.ComputedProperty} computed property which acts like
      a standard getter and setter, but defaults to the value from `defaultPath`.
      @deprecated Use `Ember.computed.oneWay` or custom CP with default instead.
    */
    // ES6TODO: computed should have its own export path so you can do import {defaultTo} from computed
    computed.defaultTo = function(defaultPath) {
      return computed(function(key, newValue, cachedValue) {
        Ember.deprecate('Usage of Ember.computed.defaultTo is deprecated, use `Ember.computed.oneWay` instead.');

        if (arguments.length === 1) {
          return get(this, defaultPath);
        }
        return newValue != null ? newValue : get(this, defaultPath);
      });
    };

    /**
      Creates a new property that is an alias for another property
      on an object. Calls to `get` or `set` this property behave as
      though they were called on the original property, but also
      print a deprecation warning.

      @method computed.deprecatingAlias
      @for Ember
      @param {String} dependentKey
      @return {Ember.ComputedProperty} computed property which creates an
      alias with a deprecation to the original value for property.
      @since 1.7.0
    */
    computed.deprecatingAlias = function(dependentKey) {
      return computed(dependentKey, function(key, value) {
        Ember.deprecate('Usage of `' + key + '` is deprecated, use `' + dependentKey + '` instead.');

        if (arguments.length > 1) {
          set(this, dependentKey, value);
          return value;
        } else {
          return get(this, dependentKey);
        }
      });
    };
  });
enifed("ember-metal/core",
  ["exports"],
  function(__exports__) {
    "use strict";
    /*globals Ember:true,Em:true,ENV,EmberENV,MetamorphENV:true */

    /**
    @module ember
    @submodule ember-metal
    */

    /**
      All Ember methods and functions are defined inside of this namespace. You
      generally should not add new properties to this namespace as it may be
      overwritten by future versions of Ember.

      You can also use the shorthand `Em` instead of `Ember`.

      Ember-Runtime is a framework that provides core functions for Ember including
      cross-platform functions, support for property observing and objects. Its
      focus is on small size and performance. You can use this in place of or
      along-side other cross-platform libraries such as jQuery.

      The core Runtime framework is based on the jQuery API with a number of
      performance optimizations.

      @class Ember
      @static
      @version 1.8.1
    */

    if ('undefined' === typeof Ember) {
      // Create core object. Make it act like an instance of Ember.Namespace so that
      // objects assigned to it are given a sane string representation.
      Ember = {};
    }

    // Default imports, exports and lookup to the global object;
    var imports = Ember.imports = Ember.imports || this;
    var exports = Ember.exports = Ember.exports || this;
    var lookup  = Ember.lookup  = Ember.lookup  || this;

    // aliases needed to keep minifiers from removing the global context
    exports.Em = exports.Ember = Ember;

    // Make sure these are set whether Ember was already defined or not

    Ember.isNamespace = true;

    Ember.toString = function() { return "Ember"; };


    /**
      @property VERSION
      @type String
      @default '1.8.1'
      @static
    */
    Ember.VERSION = '1.8.1';

    /**
      Standard environmental variables. You can define these in a global `EmberENV`
      variable before loading Ember to control various configuration settings.

      For backwards compatibility with earlier versions of Ember the global `ENV`
      variable will be used if `EmberENV` is not defined.

      @property ENV
      @type Hash
    */

    if (Ember.ENV) {
      // do nothing if Ember.ENV is already setup
    } else if ('undefined' !== typeof EmberENV) {
      Ember.ENV = EmberENV;
    } else if('undefined' !== typeof ENV) {
      Ember.ENV = ENV;
    } else {
      Ember.ENV = {};
    }

    Ember.config = Ember.config || {};

    // We disable the RANGE API by default for performance reasons
    if ('undefined' === typeof Ember.ENV.DISABLE_RANGE_API) {
      Ember.ENV.DISABLE_RANGE_API = true;
    }

    if ("undefined" === typeof MetamorphENV) {
      exports.MetamorphENV = {};
    }

    MetamorphENV.DISABLE_RANGE_API = Ember.ENV.DISABLE_RANGE_API;

    /**
      Hash of enabled Canary features. Add to this before creating your application.

      You can also define `ENV.FEATURES` if you need to enable features flagged at runtime.

      @class FEATURES
      @namespace Ember
      @static
      @since 1.1.0
    */

    Ember.FEATURES = Ember.ENV.FEATURES || {};

    /**
      Test that a feature is enabled. Parsed by Ember's build tools to leave
      experimental features out of beta/stable builds.

      You can define the following configuration options:

      * `ENV.ENABLE_ALL_FEATURES` - force all features to be enabled.
      * `ENV.ENABLE_OPTIONAL_FEATURES` - enable any features that have not been explicitly
        enabled/disabled.

      @method isEnabled
      @param {String} feature
      @return {Boolean}
      @for Ember.FEATURES
      @since 1.1.0
    */

    Ember.FEATURES.isEnabled = function(feature) {
      var featureValue = Ember.FEATURES[feature];

      if (Ember.ENV.ENABLE_ALL_FEATURES) {
        return true;
      } else if (featureValue === true || featureValue === false || featureValue === undefined) {
        return featureValue;
      } else if (Ember.ENV.ENABLE_OPTIONAL_FEATURES) {
        return true;
      } else {
        return false;
      }
    };

    // ..........................................................
    // BOOTSTRAP
    //

    /**
      Determines whether Ember should enhance some built-in object prototypes to
      provide a more friendly API. If enabled, a few methods will be added to
      `Function`, `String`, and `Array`. `Object.prototype` will not be enhanced,
      which is the one that causes most trouble for people.

      In general we recommend leaving this option set to true since it rarely
      conflicts with other code. If you need to turn it off however, you can
      define an `ENV.EXTEND_PROTOTYPES` config to disable it.

      @property EXTEND_PROTOTYPES
      @type Boolean
      @default true
      @for Ember
    */
    Ember.EXTEND_PROTOTYPES = Ember.ENV.EXTEND_PROTOTYPES;

    if (typeof Ember.EXTEND_PROTOTYPES === 'undefined') {
      Ember.EXTEND_PROTOTYPES = true;
    }

    /**
      Determines whether Ember logs a full stack trace during deprecation warnings

      @property LOG_STACKTRACE_ON_DEPRECATION
      @type Boolean
      @default true
    */
    Ember.LOG_STACKTRACE_ON_DEPRECATION = (Ember.ENV.LOG_STACKTRACE_ON_DEPRECATION !== false);

    /**
      Determines whether Ember should add ECMAScript 5 shims to older browsers.

      @property SHIM_ES5
      @type Boolean
      @default Ember.EXTEND_PROTOTYPES
    */
    Ember.SHIM_ES5 = (Ember.ENV.SHIM_ES5 === false) ? false : Ember.EXTEND_PROTOTYPES;

    /**
      Determines whether Ember logs info about version of used libraries

      @property LOG_VERSION
      @type Boolean
      @default true
    */
    Ember.LOG_VERSION = (Ember.ENV.LOG_VERSION === false) ? false : true;

    /**
      Empty function. Useful for some operations. Always returns `this`.

      @method K
      @private
      @return {Object}
    */
    var K = function() { return this; };
    var K = K;
    __exports__.K = K;Ember.K = K;
    //TODO: ES6 GLOBL TODO

    // Stub out the methods defined by the ember-debug package in case it's not loaded

    if ('undefined' === typeof Ember.assert) { Ember.assert = Ember.K; }
    if ('undefined' === typeof Ember.warn) { Ember.warn = Ember.K; }
    if ('undefined' === typeof Ember.debug) { Ember.debug = Ember.K; }
    if ('undefined' === typeof Ember.runInDebug) { Ember.runInDebug = Ember.K; }
    if ('undefined' === typeof Ember.deprecate) { Ember.deprecate = Ember.K; }
    if ('undefined' === typeof Ember.deprecateFunc) {
      Ember.deprecateFunc = function(_, func) { return func; };
    }

    __exports__["default"] = Ember;
  });
enifed("ember-metal/dependent_keys",
  ["ember-metal/platform","ember-metal/watching","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
        // Remove "use strict"; from transpiled module until
    // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed
    //
    // REMOVE_USE_STRICT: true

    var o_create = __dependency1__.create;
    var watch = __dependency2__.watch;
    var unwatch = __dependency2__.unwatch;

    /**
    @module ember-metal
    */

    // ..........................................................
    // DEPENDENT KEYS
    //

    // data structure:
    //  meta.deps = {
    //    'depKey': {
    //      'keyName': count,
    //    }
    //  }

    /*
      This function returns a map of unique dependencies for a
      given object and key.
    */
    function keysForDep(depsMeta, depKey) {
      var keys = depsMeta[depKey];
      if (!keys) {
        // if there are no dependencies yet for a the given key
        // create a new empty list of dependencies for the key
        keys = depsMeta[depKey] = {};
      } else if (!depsMeta.hasOwnProperty(depKey)) {
        // otherwise if the dependency list is inherited from
        // a superclass, clone the hash
        keys = depsMeta[depKey] = o_create(keys);
      }
      return keys;
    }

    function metaForDeps(meta) {
      return keysForDep(meta, 'deps');
    }

    function addDependentKeys(desc, obj, keyName, meta) {
      // the descriptor has a list of dependent keys, so
      // add all of its dependent keys.
      var depKeys = desc._dependentKeys, depsMeta, idx, len, depKey, keys;
      if (!depKeys) return;

      depsMeta = metaForDeps(meta);

      for(idx = 0, len = depKeys.length; idx < len; idx++) {
        depKey = depKeys[idx];
        // Lookup keys meta for depKey
        keys = keysForDep(depsMeta, depKey);
        // Increment the number of times depKey depends on keyName.
        keys[keyName] = (keys[keyName] || 0) + 1;
        // Watch the depKey
        watch(obj, depKey, meta);
      }
    }

    __exports__.addDependentKeys = addDependentKeys;function removeDependentKeys(desc, obj, keyName, meta) {
      // the descriptor has a list of dependent keys, so
      // remove all of its dependent keys.
      var depKeys = desc._dependentKeys, depsMeta, idx, len, depKey, keys;
      if (!depKeys) return;

      depsMeta = metaForDeps(meta);

      for(idx = 0, len = depKeys.length; idx < len; idx++) {
        depKey = depKeys[idx];
        // Lookup keys meta for depKey
        keys = keysForDep(depsMeta, depKey);
        // Decrement the number of times depKey depends on keyName.
        keys[keyName] = (keys[keyName] || 0) - 1;
        // Unwatch the depKey
        unwatch(obj, depKey, meta);
      }
    }

    __exports__.removeDependentKeys = removeDependentKeys;
  });
enifed("ember-metal/deprecate_property",
  ["ember-metal/core","ember-metal/platform","ember-metal/properties","ember-metal/property_get","ember-metal/property_set","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    /**
    @module ember-metal
    */

    var Ember = __dependency1__["default"];
    var hasPropertyAccessors = __dependency2__.hasPropertyAccessors;
    var defineProperty = __dependency3__.defineProperty;
    var get = __dependency4__.get;
    var set = __dependency5__.set;


    /**
      Used internally to allow changing properties in a backwards compatible way, and print a helpful
      deprecation warning.

      @method deprecateProperty
      @param {Object} object The object to add the deprecated property to.
      @param {String} deprecatedKey The property to add (and print deprecation warnings upon accessing).
      @param {String} newKey The property that will be aliased.
      @private
      @since 1.7.0
    */

    function deprecateProperty(object, deprecatedKey, newKey) {
      function deprecate() {
        Ember.deprecate('Usage of `' + deprecatedKey + '` is deprecated, use `' + newKey + '` instead.');
      }

      if (hasPropertyAccessors) {
        defineProperty(object, deprecatedKey, {
            configurable: true,
            enumerable: false,
            set: function(value) { deprecate(); set(this, newKey, value); },
            get: function() { deprecate(); return get(this, newKey); }
        });
      }
    }

    __exports__.deprecateProperty = deprecateProperty;
  });
enifed("ember-metal/dictionary",
  ["ember-metal/platform","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var create = __dependency1__.create;

    // the delete is meant to hint at runtimes that this object should remain in
    // dictionary mode. This is clearly a runtime specific hack, but currently it
    // appears worthwile in some usecases. Please note, these deletes do increase
    // the cost of creation dramatically over a plain Object.create. And as this
    // only makes sense for long-lived dictionaries that aren't instantiated often.
    __exports__["default"] = function makeDictionary(parent) {
      var dict = create(parent);
      dict['_dict'] = null;
      delete dict['_dict'];
      return dict;
    }
  });
enifed("ember-metal/enumerable_utils",
  ["ember-metal/array","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var _filter = __dependency1__.filter;
    var a_forEach = __dependency1__.forEach;
    var _indexOf = __dependency1__.indexOf;
    var _map = __dependency1__.map;

    var splice = Array.prototype.splice;

    /**
     * Defines some convenience methods for working with Enumerables.
     * `Ember.EnumerableUtils` uses `Ember.ArrayPolyfills` when necessary.
     *
     * @class EnumerableUtils
     * @namespace Ember
     * @static
     * */

    /**
     * Calls the map function on the passed object with a specified callback. This
     * uses `Ember.ArrayPolyfill`'s-map method when necessary.
     *
     * @method map
     * @param {Object} obj The object that should be mapped
     * @param {Function} callback The callback to execute
     * @param {Object} thisArg Value to use as this when executing *callback*
     *
     * @return {Array} An array of mapped values.
     */
    function map(obj, callback, thisArg) {
      return obj.map ? obj.map(callback, thisArg) : _map.call(obj, callback, thisArg);
    }

    __exports__.map = map;/**
     * Calls the forEach function on the passed object with a specified callback. This
     * uses `Ember.ArrayPolyfill`'s-forEach method when necessary.
     *
     * @method forEach
     * @param {Object} obj The object to call forEach on
     * @param {Function} callback The callback to execute
     * @param {Object} thisArg Value to use as this when executing *callback*
     *
     */
    function forEach(obj, callback, thisArg) {
      return obj.forEach ? obj.forEach(callback, thisArg) : a_forEach.call(obj, callback, thisArg);
    }

    __exports__.forEach = forEach;/**
     * Calls the filter function on the passed object with a specified callback. This
     * uses `Ember.ArrayPolyfill`'s-filter method when necessary.
     *
     * @method filter
     * @param {Object} obj The object to call filter on
     * @param {Function} callback The callback to execute
     * @param {Object} thisArg Value to use as this when executing *callback*
     *
     * @return {Array} An array containing the filtered values
     * @since 1.4.0
     */
    function filter(obj, callback, thisArg) {
      return obj.filter ? obj.filter(callback, thisArg) : _filter.call(obj, callback, thisArg);
    }

    __exports__.filter = filter;/**
     * Calls the indexOf function on the passed object with a specified callback. This
     * uses `Ember.ArrayPolyfill`'s-indexOf method when necessary.
     *
     * @method indexOf
     * @param {Object} obj The object to call indexOn on
     * @param {Function} callback The callback to execute
     * @param {Object} index The index to start searching from
     *
     */
    function indexOf(obj, element, index) {
      return obj.indexOf ? obj.indexOf(element, index) : _indexOf.call(obj, element, index);
    }

    __exports__.indexOf = indexOf;/**
     * Returns an array of indexes of the first occurrences of the passed elements
     * on the passed object.
     *
     * ```javascript
     *  var array = [1, 2, 3, 4, 5];
     *  Ember.EnumerableUtils.indexesOf(array, [2, 5]); // [1, 4]
     *
     *  var fubar = "Fubarr";
     *  Ember.EnumerableUtils.indexesOf(fubar, ['b', 'r']); // [2, 4]
     * ```
     *
     * @method indexesOf
     * @param {Object} obj The object to check for element indexes
     * @param {Array} elements The elements to search for on *obj*
     *
     * @return {Array} An array of indexes.
     *
     */
    function indexesOf(obj, elements) {
      return elements === undefined ? [] : map(elements, function(item) {
        return indexOf(obj, item);
      });
    }

    __exports__.indexesOf = indexesOf;/**
     * Adds an object to an array. If the array already includes the object this
     * method has no effect.
     *
     * @method addObject
     * @param {Array} array The array the passed item should be added to
     * @param {Object} item The item to add to the passed array
     *
     * @return 'undefined'
     */
    function addObject(array, item) {
      var index = indexOf(array, item);
      if (index === -1) { array.push(item); }
    }

    __exports__.addObject = addObject;/**
     * Removes an object from an array. If the array does not contain the passed
     * object this method has no effect.
     *
     * @method removeObject
     * @param {Array} array The array to remove the item from.
     * @param {Object} item The item to remove from the passed array.
     *
     * @return 'undefined'
     */
    function removeObject(array, item) {
      var index = indexOf(array, item);
      if (index !== -1) { array.splice(index, 1); }
    }

    __exports__.removeObject = removeObject;function _replace(array, idx, amt, objects) {
      var args = [].concat(objects);
      var ret = [];
      // https://code.google.com/p/chromium/issues/detail?id=56588
      var size = 60000;
      var start = idx;
      var ends = amt;
      var count, chunk;

      while (args.length) {
        count = ends > size ? size : ends;
        if (count <= 0) { count = 0; }

        chunk = args.splice(0, size);
        chunk = [start, count].concat(chunk);

        start += size;
        ends -= count;

        ret = ret.concat(splice.apply(array, chunk));
      }
      return ret;
    }

    __exports__._replace = _replace;/**
     * Replaces objects in an array with the passed objects.
     *
     * ```javascript
     *   var array = [1,2,3];
     *   Ember.EnumerableUtils.replace(array, 1, 2, [4, 5]); // [1, 4, 5]
     *
     *   var array = [1,2,3];
     *   Ember.EnumerableUtils.replace(array, 1, 1, [4, 5]); // [1, 4, 5, 3]
     *
     *   var array = [1,2,3];
     *   Ember.EnumerableUtils.replace(array, 10, 1, [4, 5]); // [1, 2, 3, 4, 5]
     * ```
     *
     * @method replace
     * @param {Array} array The array the objects should be inserted into.
     * @param {Number} idx Starting index in the array to replace. If *idx* >=
     * length, then append to the end of the array.
     * @param {Number} amt Number of elements that should be removed from the array,
     * starting at *idx*
     * @param {Array} objects An array of zero or more objects that should be
     * inserted into the array at *idx*
     *
     * @return {Array} The modified array.
     */
    function replace(array, idx, amt, objects) {
      if (array.replace) {
        return array.replace(idx, amt, objects);
      } else {
        return _replace(array, idx, amt, objects);
      }
    }

    __exports__.replace = replace;/**
     * Calculates the intersection of two arrays. This method returns a new array
     * filled with the records that the two passed arrays share with each other.
     * If there is no intersection, an empty array will be returned.
     *
     * ```javascript
     * var array1 = [1, 2, 3, 4, 5];
     * var array2 = [1, 3, 5, 6, 7];
     *
     * Ember.EnumerableUtils.intersection(array1, array2); // [1, 3, 5]
     *
     * var array1 = [1, 2, 3];
     * var array2 = [4, 5, 6];
     *
     * Ember.EnumerableUtils.intersection(array1, array2); // []
     * ```
     *
     * @method intersection
     * @param {Array} array1 The first array
     * @param {Array} array2 The second array
     *
     * @return {Array} The intersection of the two passed arrays.
     */
    function intersection(array1, array2) {
      var result = [];
      forEach(array1, function(element) {
        if (indexOf(array2, element) >= 0) {
          result.push(element);
        }
      });

      return result;
    }

    __exports__.intersection = intersection;// TODO: this only exists to maintain the existing api, as we move forward it
    // should only be part of the "global build" via some shim
    __exports__["default"] = {
      _replace: _replace,
      addObject: addObject,
      filter: filter,
      forEach: forEach,
      indexOf: indexOf,
      indexesOf: indexesOf,
      intersection: intersection,
      map: map,
      removeObject: removeObject,
      replace: replace
    };
  });
enifed("ember-metal/error",
  ["ember-metal/platform","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var create = __dependency1__.create;

    var errorProps = [
      'description',
      'fileName',
      'lineNumber',
      'message',
      'name',
      'number',
      'stack'
    ];

    /**
      A subclass of the JavaScript Error object for use in Ember.

      @class Error
      @namespace Ember
      @extends Error
      @constructor
    */
    function EmberError() {
      var tmp = Error.apply(this, arguments);

      // Adds a `stack` property to the given error object that will yield the
      // stack trace at the time captureStackTrace was called.
      // When collecting the stack trace all frames above the topmost call
      // to this function, including that call, will be left out of the
      // stack trace.
      // This is useful because we can hide Ember implementation details
      // that are not very helpful for the user.
      if (Error.captureStackTrace) {
        Error.captureStackTrace(this, Ember.Error);
      }
      // Unfortunately errors are not enumerable in Chrome (at least), so `for prop in tmp` doesn't work.
      for (var idx = 0; idx < errorProps.length; idx++) {
        this[errorProps[idx]] = tmp[errorProps[idx]];
      }
    }

    EmberError.prototype = create(Error.prototype);

    __exports__["default"] = EmberError;
  });
enifed("ember-metal/events",
  ["ember-metal/core","ember-metal/utils","ember-metal/platform","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
        // Remove "use strict"; from transpiled module until
    // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed
    //
    // REMOVE_USE_STRICT: true

    /**
    @module ember-metal
    */
    var Ember = __dependency1__["default"];
    var meta = __dependency2__.meta;
    var tryFinally = __dependency2__.tryFinally;
    var apply = __dependency2__.apply;
    var applyStr = __dependency2__.applyStr;
    var create = __dependency3__.create;

    var a_slice = [].slice;
    var metaFor = meta;

    /* listener flags */
    var ONCE = 1;
    var SUSPENDED = 2;


    /*
      The event system uses a series of nested hashes to store listeners on an
      object. When a listener is registered, or when an event arrives, these
      hashes are consulted to determine which target and action pair to invoke.

      The hashes are stored in the object's meta hash, and look like this:

          // Object's meta hash
          {
            listeners: {       // variable name: `listenerSet`
              "foo:changed": [ // variable name: `actions`
                target, method, flags
              ]
            }
          }

    */

    function indexOf(array, target, method) {
      var index = -1;
      // hashes are added to the end of the event array
      // so it makes sense to start searching at the end
      // of the array and search in reverse
      for (var i = array.length - 3 ; i >=0; i -= 3) {
        if (target === array[i] && method === array[i + 1]) {
             index = i; break;
        }
      }
      return index;
    }

    function actionsFor(obj, eventName) {
      var meta = metaFor(obj, true);
      var actions;

      if (!meta.listeners) { meta.listeners = {}; }

      if (!meta.hasOwnProperty('listeners')) {
        // setup inherited copy of the listeners object
        meta.listeners = create(meta.listeners);
      }

      actions = meta.listeners[eventName];

      // if there are actions, but the eventName doesn't exist in our listeners, then copy them from the prototype
      if (actions && !meta.listeners.hasOwnProperty(eventName)) {
        actions = meta.listeners[eventName] = meta.listeners[eventName].slice();
      } else if (!actions) {
        actions = meta.listeners[eventName] = [];
      }

      return actions;
    }

    function listenersUnion(obj, eventName, otherActions) {
      var meta = obj['__ember_meta__'];
      var actions = meta && meta.listeners && meta.listeners[eventName];

      if (!actions) { return; }
      for (var i = actions.length - 3; i >= 0; i -= 3) {
        var target = actions[i];
        var method = actions[i+1];
        var flags = actions[i+2];
        var actionIndex = indexOf(otherActions, target, method);

        if (actionIndex === -1) {
          otherActions.push(target, method, flags);
        }
      }
    }

    __exports__.listenersUnion = listenersUnion;function listenersDiff(obj, eventName, otherActions) {
      var meta = obj['__ember_meta__'];
      var actions = meta && meta.listeners && meta.listeners[eventName];
      var diffActions = [];

      if (!actions) { return; }
      for (var i = actions.length - 3; i >= 0; i -= 3) {
        var target = actions[i];
        var method = actions[i+1];
        var flags = actions[i+2];
        var actionIndex = indexOf(otherActions, target, method);

        if (actionIndex !== -1) { continue; }

        otherActions.push(target, method, flags);
        diffActions.push(target, method, flags);
      }

      return diffActions;
    }

    __exports__.listenersDiff = listenersDiff;/**
      Add an event listener

      @method addListener
      @for Ember
      @param obj
      @param {String} eventName
      @param {Object|Function} targetOrMethod A target object or a function
      @param {Function|String} method A function or the name of a function to be called on `target`
      @param {Boolean} once A flag whether a function should only be called once
    */
    function addListener(obj, eventName, target, method, once) {
      Ember.assert("You must pass at least an object and event name to Ember.addListener", !!obj && !!eventName);

      if (!method && 'function' === typeof target) {
        method = target;
        target = null;
      }

      var actions = actionsFor(obj, eventName);
      var actionIndex = indexOf(actions, target, method);
      var flags = 0;

      if (once) flags |= ONCE;

      if (actionIndex !== -1) { return; }

      actions.push(target, method, flags);

      if ('function' === typeof obj.didAddListener) {
        obj.didAddListener(eventName, target, method);
      }
    }

    __exports__.addListener = addListener;/**
      Remove an event listener

      Arguments should match those passed to `Ember.addListener`.

      @method removeListener
      @for Ember
      @param obj
      @param {String} eventName
      @param {Object|Function} targetOrMethod A target object or a function
      @param {Function|String} method A function or the name of a function to be called on `target`
    */
    function removeListener(obj, eventName, target, method) {
      Ember.assert("You must pass at least an object and event name to Ember.removeListener", !!obj && !!eventName);

      if (!method && 'function' === typeof target) {
        method = target;
        target = null;
      }

      function _removeListener(target, method) {
        var actions = actionsFor(obj, eventName);
        var actionIndex = indexOf(actions, target, method);

        // action doesn't exist, give up silently
        if (actionIndex === -1) { return; }

        actions.splice(actionIndex, 3);

        if ('function' === typeof obj.didRemoveListener) {
          obj.didRemoveListener(eventName, target, method);
        }
      }

      if (method) {
        _removeListener(target, method);
      } else {
        var meta = obj['__ember_meta__'];
        var actions = meta && meta.listeners && meta.listeners[eventName];

        if (!actions) { return; }
        for (var i = actions.length - 3; i >= 0; i -= 3) {
          _removeListener(actions[i], actions[i+1]);
        }
      }
    }

    /**
      Suspend listener during callback.

      This should only be used by the target of the event listener
      when it is taking an action that would cause the event, e.g.
      an object might suspend its property change listener while it is
      setting that property.

      @method suspendListener
      @for Ember

      @private
      @param obj
      @param {String} eventName
      @param {Object|Function} targetOrMethod A target object or a function
      @param {Function|String} method A function or the name of a function to be called on `target`
      @param {Function} callback
    */
    function suspendListener(obj, eventName, target, method, callback) {
      if (!method && 'function' === typeof target) {
        method = target;
        target = null;
      }

      var actions = actionsFor(obj, eventName);
      var actionIndex = indexOf(actions, target, method);

      if (actionIndex !== -1) {
        actions[actionIndex+2] |= SUSPENDED; // mark the action as suspended
      }

      function tryable()   { return callback.call(target); }
      function finalizer() { if (actionIndex !== -1) { actions[actionIndex+2] &= ~SUSPENDED; } }

      return tryFinally(tryable, finalizer);
    }

    __exports__.suspendListener = suspendListener;/**
      Suspends multiple listeners during a callback.

      @method suspendListeners
      @for Ember

      @private
      @param obj
      @param {Array} eventName Array of event names
      @param {Object|Function} targetOrMethod A target object or a function
      @param {Function|String} method A function or the name of a function to be called on `target`
      @param {Function} callback
    */
    function suspendListeners(obj, eventNames, target, method, callback) {
      if (!method && 'function' === typeof target) {
        method = target;
        target = null;
      }

      var suspendedActions = [];
      var actionsList = [];
      var eventName, actions, i, l;

      for (i=0, l=eventNames.length; i<l; i++) {
        eventName = eventNames[i];
        actions = actionsFor(obj, eventName);
        var actionIndex = indexOf(actions, target, method);

        if (actionIndex !== -1) {
          actions[actionIndex+2] |= SUSPENDED;
          suspendedActions.push(actionIndex);
          actionsList.push(actions);
        }
      }

      function tryable() { return callback.call(target); }

      function finalizer() {
        for (var i = 0, l = suspendedActions.length; i < l; i++) {
          var actionIndex = suspendedActions[i];
          actionsList[i][actionIndex+2] &= ~SUSPENDED;
        }
      }

      return tryFinally(tryable, finalizer);
    }

    __exports__.suspendListeners = suspendListeners;/**
      Return a list of currently watched events

      @private
      @method watchedEvents
      @for Ember
      @param obj
    */
    function watchedEvents(obj) {
      var listeners = obj['__ember_meta__'].listeners, ret = [];

      if (listeners) {
        for(var eventName in listeners) {
          if (listeners[eventName]) { ret.push(eventName); }
        }
      }
      return ret;
    }

    __exports__.watchedEvents = watchedEvents;/**
      Send an event. The execution of suspended listeners
      is skipped, and once listeners are removed. A listener without
      a target is executed on the passed object. If an array of actions
      is not passed, the actions stored on the passed object are invoked.

      @method sendEvent
      @for Ember
      @param obj
      @param {String} eventName
      @param {Array} params Optional parameters for each listener.
      @param {Array} actions Optional array of actions (listeners).
      @return true
    */
    function sendEvent(obj, eventName, params, actions) {
      // first give object a chance to handle it
      if (obj !== Ember && 'function' === typeof obj.sendEvent) {
        obj.sendEvent(eventName, params);
      }

      if (!actions) {
        var meta = obj['__ember_meta__'];
        actions = meta && meta.listeners && meta.listeners[eventName];
      }

      if (!actions) { return; }

      for (var i = actions.length - 3; i >= 0; i -= 3) { // looping in reverse for once listeners
        var target = actions[i], method = actions[i+1], flags = actions[i+2];
        if (!method) { continue; }
        if (flags & SUSPENDED) { continue; }
        if (flags & ONCE) { removeListener(obj, eventName, target, method); }
        if (!target) { target = obj; }
        if ('string' === typeof method) {
          if (params) {
            applyStr(target, method, params);
          } else {
            target[method]();
          }
        } else {
          if (params) {
            apply(target, method, params);
          } else {
            method.call(target);
          }
        }
      }
      return true;
    }

    __exports__.sendEvent = sendEvent;/**
      @private
      @method hasListeners
      @for Ember
      @param obj
      @param {String} eventName
    */
    function hasListeners(obj, eventName) {
      var meta = obj['__ember_meta__'];
      var actions = meta && meta.listeners && meta.listeners[eventName];

      return !!(actions && actions.length);
    }

    __exports__.hasListeners = hasListeners;/**
      @private
      @method listenersFor
      @for Ember
      @param obj
      @param {String} eventName
    */
    function listenersFor(obj, eventName) {
      var ret = [];
      var meta = obj['__ember_meta__'];
      var actions = meta && meta.listeners && meta.listeners[eventName];

      if (!actions) { return ret; }

      for (var i = 0, l = actions.length; i < l; i += 3) {
        var target = actions[i];
        var method = actions[i+1];
        ret.push([target, method]);
      }

      return ret;
    }

    __exports__.listenersFor = listenersFor;/**
      Define a property as a function that should be executed when
      a specified event or events are triggered.


      ``` javascript
      var Job = Ember.Object.extend({
        logCompleted: Ember.on('completed', function() {
          console.log('Job completed!');
        })
      });

      var job = Job.create();

      Ember.sendEvent(job, 'completed'); // Logs 'Job completed!'
     ```

      @method on
      @for Ember
      @param {String} eventNames*
      @param {Function} func
      @return func
    */
    function on(){
      var func = a_slice.call(arguments, -1)[0];
      var events = a_slice.call(arguments, 0, -1);
      func.__ember_listens__ = events;
      return func;
    }

    __exports__.on = on;__exports__.removeListener = removeListener;
  });
enifed("ember-metal/expand_properties",
  ["ember-metal/core","ember-metal/error","ember-metal/enumerable_utils","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    var EmberError = __dependency2__["default"];
    var forEach = __dependency3__.forEach;

    /**
      @module ember-metal
      */

    var BRACE_EXPANSION = /^((?:[^\.]*\.)*)\{(.*)\}$/;
    var SPLIT_REGEX = /\{|\}/;

    /**
      Expands `pattern`, invoking `callback` for each expansion.

      The only pattern supported is brace-expansion, anything else will be passed
      once to `callback` directly.

      Example

      ```js
      function echo(arg){ console.log(arg); }

      Ember.expandProperties('foo.bar', echo);              //=> 'foo.bar'
      Ember.expandProperties('{foo,bar}', echo);            //=> 'foo', 'bar'
      Ember.expandProperties('foo.{bar,baz}', echo);        //=> 'foo.bar', 'foo.baz'
      Ember.expandProperties('{foo,bar}.baz', echo);        //=> '{foo,bar}.baz'
      Ember.expandProperties('foo.{bar,baz}.@each', echo)   //=> 'foo.bar.@each', 'foo.baz.@each'
      Ember.expandProperties('{foo,bar}.{spam,eggs}', echo) //=> 'foo.spam', 'foo.eggs', 'bar.spam', 'bar.eggs'
      Ember.expandProperties('{foo}.bar.{baz}')             //=> 'foo.bar.baz'
      ```

      @method
      @private
      @param {String} pattern The property pattern to expand.
      @param {Function} callback The callback to invoke.  It is invoked once per
      expansion, and is passed the expansion.
      */
    __exports__["default"] = function expandProperties(pattern, callback) {
      if (pattern.indexOf(' ') > -1) {
        throw new EmberError('Brace expanded properties cannot contain spaces, ' +
          'e.g. `user.{firstName, lastName}` should be `user.{firstName,lastName}`');
      }

      
        return newExpandProperties(pattern, callback);
          }

    function oldExpandProperties(pattern, callback) {
      var match, prefix, list;

      if (match = BRACE_EXPANSION.exec(pattern)) {
        prefix = match[1];
        list = match[2];

        forEach(list.split(','), function (suffix) {
            callback(prefix + suffix);
        });
      } else {
        callback(pattern);
      }
    }

    function newExpandProperties(pattern, callback) {
      if ('string' === Ember.typeOf(pattern)) {
        var parts = pattern.split(SPLIT_REGEX);
        var properties = [parts];

        forEach(parts, function(part, index) {
          if (part.indexOf(',') >= 0) {
            properties = duplicateAndReplace(properties, part.split(','), index);
          }
        });

        forEach(properties, function(property) {
          callback(property.join(''));
        });
      } else {
        callback(pattern);
      }
    }

    function duplicateAndReplace(properties, currentParts, index) {
      var all = [];

      forEach(properties, function(property) {
        forEach(currentParts, function(part) {
          var current = property.slice(0);
          current[index] = part;
          all.push(current);
        });
      });

      return all;
    }
  });
enifed("ember-metal/get_properties",
  ["ember-metal/property_get","ember-metal/utils","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var get = __dependency1__.get;
    var typeOf = __dependency2__.typeOf;

    /**
      To get multiple properties at once, call `Ember.getProperties`
      with an object followed by a list of strings or an array:

      ```javascript
      Ember.getProperties(record, 'firstName', 'lastName', 'zipCode');
      // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
      ```

      is equivalent to:

      ```javascript
      Ember.getProperties(record, ['firstName', 'lastName', 'zipCode']);
      // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
      ```

      @method getProperties
      @param obj
      @param {String...|Array} list of keys to get
      @return {Hash}
    */
    __exports__["default"] = function getProperties(obj) {
      var ret = {};
      var propertyNames = arguments;
      var i = 1;

      if (arguments.length === 2 && typeOf(arguments[1]) === 'array') {
        i = 0;
        propertyNames = arguments[1];
      }
      for(var len = propertyNames.length; i < len; i++) {
        ret[propertyNames[i]] = get(obj, propertyNames[i]);
      }
      return ret;
    }
  });
enifed("ember-metal/instrumentation",
  ["ember-metal/core","ember-metal/utils","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    var tryCatchFinally = __dependency2__.tryCatchFinally;

    /**
      The purpose of the Ember Instrumentation module is
      to provide efficient, general-purpose instrumentation
      for Ember.

      Subscribe to a listener by using `Ember.subscribe`:

      ```javascript
      Ember.subscribe("render", {
        before: function(name, timestamp, payload) {

        },

        after: function(name, timestamp, payload) {

        }
      });
      ```

      If you return a value from the `before` callback, that same
      value will be passed as a fourth parameter to the `after`
      callback.

      Instrument a block of code by using `Ember.instrument`:

      ```javascript
      Ember.instrument("render.handlebars", payload, function() {
        // rendering logic
      }, binding);
      ```

      Event names passed to `Ember.instrument` are namespaced
      by periods, from more general to more specific. Subscribers
      can listen for events by whatever level of granularity they
      are interested in.

      In the above example, the event is `render.handlebars`,
      and the subscriber listened for all events beginning with
      `render`. It would receive callbacks for events named
      `render`, `render.handlebars`, `render.container`, or
      even `render.handlebars.layout`.

      @class Instrumentation
      @namespace Ember
      @static
    */
    var subscribers = [];
    __exports__.subscribers = subscribers;var cache = {};

    var populateListeners = function(name) {
      var listeners = [];
      var subscriber;

      for (var i=0, l=subscribers.length; i<l; i++) {
        subscriber = subscribers[i];
        if (subscriber.regex.test(name)) {
          listeners.push(subscriber.object);
        }
      }

      cache[name] = listeners;
      return listeners;
    };

    var time = (function() {
      var perf = 'undefined' !== typeof window ? window.performance || {} : {};
      var fn = perf.now || perf.mozNow || perf.webkitNow || perf.msNow || perf.oNow;
      // fn.bind will be available in all the browsers that support the advanced window.performance... ;-)
      return fn ? fn.bind(perf) : function() { return +new Date(); };
    })();

    /**
      Notifies event's subscribers, calls `before` and `after` hooks.

      @method instrument
      @namespace Ember.Instrumentation

      @param {String} [name] Namespaced event name.
      @param {Object} payload
      @param {Function} callback Function that you're instrumenting.
      @param {Object} binding Context that instrument function is called with.
    */
    function instrument(name, _payload, callback, binding) {
      if (subscribers.length === 0) {
        return callback.call(binding);
      }
      var payload = _payload || {};
      var finalizer = _instrumentStart(name, function () {
        return payload;
      });
      if (finalizer) {
        var tryable = function _instrumenTryable() {
          return callback.call(binding);
        };
        var catchable = function _instrumentCatchable(e) {
          payload.exception = e;
        };
        return tryCatchFinally(tryable, catchable, finalizer);
      } else {
        return callback.call(binding);
      }
    }

    __exports__.instrument = instrument;// private for now
    function _instrumentStart(name, _payload) {
      var listeners = cache[name];

      if (!listeners) {
        listeners = populateListeners(name);
      }

      if (listeners.length === 0) {
        return;
      }

      var payload = _payload();

      var STRUCTURED_PROFILE = Ember.STRUCTURED_PROFILE;
      var timeName;
      if (STRUCTURED_PROFILE) {
        timeName = name + ": " + payload.object;
        console.time(timeName);
      }

      var l = listeners.length;
      var beforeValues = new Array(l);
      var i, listener;
      var timestamp = time();
      for (i=0; i<l; i++) {
        listener = listeners[i];
        beforeValues[i] = listener.before(name, timestamp, payload);
      }

      return function _instrumentEnd() {
        var i, l, listener;
        var timestamp = time();
        for (i=0, l=listeners.length; i<l; i++) {
          listener = listeners[i];
          listener.after(name, timestamp, payload, beforeValues[i]);
        }

        if (STRUCTURED_PROFILE) {
          console.timeEnd(timeName);
        }
      };
    }

    __exports__._instrumentStart = _instrumentStart;/**
      Subscribes to a particular event or instrumented block of code.

      @method subscribe
      @namespace Ember.Instrumentation

      @param {String} [pattern] Namespaced event name.
      @param {Object} [object] Before and After hooks.

      @return {Subscriber}
    */
    function subscribe(pattern, object) {
      var paths = pattern.split("."), path, regex = [];

      for (var i=0, l=paths.length; i<l; i++) {
        path = paths[i];
        if (path === "*") {
          regex.push("[^\\.]*");
        } else {
          regex.push(path);
        }
      }

      regex = regex.join("\\.");
      regex = regex + "(\\..*)?";

      var subscriber = {
        pattern: pattern,
        regex: new RegExp("^" + regex + "$"),
        object: object
      };

      subscribers.push(subscriber);
      cache = {};

      return subscriber;
    }

    __exports__.subscribe = subscribe;/**
      Unsubscribes from a particular event or instrumented block of code.

      @method unsubscribe
      @namespace Ember.Instrumentation

      @param {Object} [subscriber]
    */
    function unsubscribe(subscriber) {
      var index;

      for (var i=0, l=subscribers.length; i<l; i++) {
        if (subscribers[i] === subscriber) {
          index = i;
        }
      }

      subscribers.splice(index, 1);
      cache = {};
    }

    __exports__.unsubscribe = unsubscribe;/**
      Resets `Ember.Instrumentation` by flushing list of subscribers.

      @method reset
      @namespace Ember.Instrumentation
    */
    function reset() {
      subscribers.length = 0;
      cache = {};
    }

    __exports__.reset = reset;
  });
enifed("ember-metal/is_blank",
  ["ember-metal/core","ember-metal/is_empty","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    // deprecateFunc
    var isEmpty = __dependency2__["default"];

    /**
      A value is blank if it is empty or a whitespace string.

      ```javascript
      Ember.isBlank();                // true
      Ember.isBlank(null);            // true
      Ember.isBlank(undefined);       // true
      Ember.isBlank('');              // true
      Ember.isBlank([]);              // true
      Ember.isBlank('\n\t');          // true
      Ember.isBlank('  ');            // true
      Ember.isBlank({});              // false
      Ember.isBlank('\n\t Hello');    // false
      Ember.isBlank('Hello world');   // false
      Ember.isBlank([1,2,3]);         // false
      ```

      @method isBlank
      @for Ember
      @param {Object} obj Value to test
      @return {Boolean}
      @since 1.5.0
      */
    __exports__["default"] = function isBlank(obj) {
      return isEmpty(obj) || (typeof obj === 'string' && obj.match(/\S/) === null);
    }
  });
enifed("ember-metal/is_empty",
  ["ember-metal/core","ember-metal/property_get","ember-metal/is_none","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    // deprecateFunc
    var get = __dependency2__.get;
    var isNone = __dependency3__["default"];

    /**
      Verifies that a value is `null` or an empty string, empty array,
      or empty function.

      Constrains the rules on `Ember.isNone` by returning true for empty
      string and empty arrays.

      ```javascript
      Ember.isEmpty();                // true
      Ember.isEmpty(null);            // true
      Ember.isEmpty(undefined);       // true
      Ember.isEmpty('');              // true
      Ember.isEmpty([]);              // true
      Ember.isEmpty('Adam Hawkins');  // false
      Ember.isEmpty([0,1,2]);         // false
      ```

      @method isEmpty
      @for Ember
      @param {Object} obj Value to test
      @return {Boolean}
    */
    function isEmpty(obj) {
      var none = isNone(obj);
      if (none) {
        return none;
      }

      if (typeof obj.size === 'number') {
        return !obj.size;
      }

      var objectType = typeof obj;

      if (objectType === 'object') {
        var size = get(obj, 'size');
        if (typeof size === 'number') {
          return !size;
        }
      }

      if (typeof obj.length === 'number' && objectType !== 'function') {
        return !obj.length;
      }

      if (objectType === 'object') {
        var length = get(obj, 'length');
        if (typeof length === 'number') {
          return !length;
        }
      }

      return false;
    }

    var empty = Ember.deprecateFunc("Ember.empty is deprecated. Please use Ember.isEmpty instead.", isEmpty);
    __exports__.empty = empty;
    __exports__["default"] = isEmpty;
    __exports__.isEmpty = isEmpty;
    __exports__.empty = empty;
  });
enifed("ember-metal/is_none",
  ["ember-metal/core","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    // deprecateFunc

    /**
      Returns true if the passed value is null or undefined. This avoids errors
      from JSLint complaining about use of ==, which can be technically
      confusing.

      ```javascript
      Ember.isNone();              // true
      Ember.isNone(null);          // true
      Ember.isNone(undefined);     // true
      Ember.isNone('');            // false
      Ember.isNone([]);            // false
      Ember.isNone(function() {});  // false
      ```

      @method isNone
      @for Ember
      @param {Object} obj Value to test
      @return {Boolean}
    */
    function isNone(obj) {
      return obj === null || obj === undefined;
    }

    var none = Ember.deprecateFunc("Ember.none is deprecated. Please use Ember.isNone instead.", isNone);
    __exports__.none = none;
    __exports__["default"] = isNone;
    __exports__.isNone = isNone;
  });
enifed("ember-metal/is_present",
  ["ember-metal/is_blank","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var isBlank = __dependency1__["default"];
    var isPresent;

    
      /**
        A value is present if it not `isBlank`.

        ```javascript
        Ember.isPresent();                // false
        Ember.isPresent(null);            // false
        Ember.isPresent(undefined);       // false
        Ember.isPresent('');              // false
        Ember.isPresent([]);              // false
        Ember.isPresent('\n\t');          // false
        Ember.isPresent('  ');            // false
        Ember.isPresent({});              // true
        Ember.isPresent('\n\t Hello');    // true
        Ember.isPresent('Hello world');   // true
        Ember.isPresent([1,2,3]);         // true
        ```

        @method isPresent
        @for Ember
        @param {Object} obj Value to test
        @return {Boolean}
        @since 1.7.0
        */
      isPresent = function isPresent(obj) {
        return !isBlank(obj);
      };
    

    __exports__["default"] = isPresent;
  });
enifed("ember-metal/keys",
  ["ember-metal/platform","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var canDefineNonEnumerableProperties = __dependency1__.canDefineNonEnumerableProperties;

    /**
      Returns all of the keys defined on an object or hash. This is useful
      when inspecting objects for debugging. On browsers that support it, this
      uses the native `Object.keys` implementation.

      @method keys
      @for Ember
      @param {Object} obj
      @return {Array} Array containing keys of obj
    */
    var keys = Object.keys;

    if (!keys || !canDefineNonEnumerableProperties) {
      // modified from
      // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/keys
      keys = (function () {
        var hasOwnProperty = Object.prototype.hasOwnProperty,
            hasDontEnumBug = !({toString: null}).propertyIsEnumerable('toString'),
            dontEnums = [
              'toString',
              'toLocaleString',
              'valueOf',
              'hasOwnProperty',
              'isPrototypeOf',
              'propertyIsEnumerable',
              'constructor'
            ],
            dontEnumsLength = dontEnums.length;

        return function keys(obj) {
          if (typeof obj !== 'object' && (typeof obj !== 'function' || obj === null)) {
            throw new TypeError('Object.keys called on non-object');
          }

          var result = [], prop, i;

          for (prop in obj) {
            if (prop !== '_super' &&
              prop.lastIndexOf('__',0) !== 0 &&
              hasOwnProperty.call(obj, prop)) {
              result.push(prop);
            }
          }

          if (hasDontEnumBug) {
            for (i = 0; i < dontEnumsLength; i++) {
              if (hasOwnProperty.call(obj, dontEnums[i])) {
                result.push(dontEnums[i]);
              }
            }
          }
          return result;
        };
      }());
    }

    __exports__["default"] = keys;
  });
enifed("ember-metal/libraries",
  ["ember-metal/enumerable_utils","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    // Provides a way to register library versions with ember.
    var forEach = __dependency1__.forEach;
    var indexOf = __dependency1__.indexOf;

    var libraries = function() {
      var _libraries   = [];
      var coreLibIndex = 0;

      var getLibrary = function(name) {
        for (var i = 0; i < _libraries.length; i++) {
          if (_libraries[i].name === name) {
            return _libraries[i];
          }
        }
      };

      _libraries.register = function(name, version) {
        if (!getLibrary(name)) {
          _libraries.push({name: name, version: version});
        }
      };

      _libraries.registerCoreLibrary = function(name, version) {
        if (!getLibrary(name)) {
          _libraries.splice(coreLibIndex++, 0, {name: name, version: version});
        }
      };

      _libraries.deRegister = function(name) {
        var lib = getLibrary(name);
        if (lib) _libraries.splice(indexOf(_libraries, lib), 1);
      };

      _libraries.each = function (callback) {
        forEach(_libraries, function(lib) {
          callback(lib.name, lib.version);
        });
      };

      return _libraries;
    }();

    __exports__["default"] = libraries;
  });
enifed("ember-metal/logger",
  ["ember-metal/core","ember-metal/error","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    var EmberError = __dependency2__["default"];

    function consoleMethod(name) {
      var consoleObj, logToConsole;
      if (Ember.imports.console) {
        consoleObj = Ember.imports.console;
      } else if (typeof console !== 'undefined') {
        consoleObj = console;
      }

      var method = typeof consoleObj === 'object' ? consoleObj[name] : null;

      if (method) {
        // Older IE doesn't support apply, but Chrome needs it
        if (typeof method.apply === 'function') {
          logToConsole = function() {
            method.apply(consoleObj, arguments);
          };
          logToConsole.displayName = 'console.' + name;
          return logToConsole;
        } else {
          return function() {
            var message = Array.prototype.join.call(arguments, ', ');
            method(message);
          };
        }
      }
    }

    function assertPolyfill(test, message) {
      if (!test) {
        try {
          // attempt to preserve the stack
          throw new EmberError("assertion failed: " + message);
        } catch(error) {
          setTimeout(function() {
            throw error;
          }, 0);
        }
      }
    }

    /**
      Inside Ember-Metal, simply uses the methods from `imports.console`.
      Override this to provide more robust logging functionality.

      @class Logger
      @namespace Ember
    */
    __exports__["default"] = {
      /**
       Logs the arguments to the console.
       You can pass as many arguments as you want and they will be joined together with a space.

        ```javascript
        var foo = 1;
        Ember.Logger.log('log value of foo:', foo);
        // "log value of foo: 1" will be printed to the console
        ```

       @method log
       @for Ember.Logger
       @param {*} arguments
      */
      log:   consoleMethod('log')   || Ember.K,

      /**
       Prints the arguments to the console with a warning icon.
       You can pass as many arguments as you want and they will be joined together with a space.

        ```javascript
        Ember.Logger.warn('Something happened!');
        // "Something happened!" will be printed to the console with a warning icon.
        ```

       @method warn
       @for Ember.Logger
       @param {*} arguments
      */
      warn:  consoleMethod('warn')  || Ember.K,

      /**
       Prints the arguments to the console with an error icon, red text and a stack trace.
       You can pass as many arguments as you want and they will be joined together with a space.

        ```javascript
        Ember.Logger.error('Danger! Danger!');
        // "Danger! Danger!" will be printed to the console in red text.
        ```

       @method error
       @for Ember.Logger
       @param {*} arguments
      */
      error: consoleMethod('error') || Ember.K,

      /**
       Logs the arguments to the console.
       You can pass as many arguments as you want and they will be joined together with a space.

        ```javascript
        var foo = 1;
        Ember.Logger.info('log value of foo:', foo);
        // "log value of foo: 1" will be printed to the console
        ```

       @method info
       @for Ember.Logger
       @param {*} arguments
      */
      info:  consoleMethod('info')  || Ember.K,

      /**
       Logs the arguments to the console in blue text.
       You can pass as many arguments as you want and they will be joined together with a space.

        ```javascript
        var foo = 1;
        Ember.Logger.debug('log value of foo:', foo);
        // "log value of foo: 1" will be printed to the console
        ```

       @method debug
       @for Ember.Logger
       @param {*} arguments
      */
      debug: consoleMethod('debug') || consoleMethod('info') || Ember.K,

      /**
       If the value passed into `Ember.Logger.assert` is not truthy it will throw an error with a stack trace.

        ```javascript
        Ember.Logger.assert(true); // undefined
        Ember.Logger.assert(true === false); // Throws an Assertion failed error.
        ```

       @method assert
       @for Ember.Logger
       @param {Boolean} bool Value to test
      */
      assert: consoleMethod('assert') || assertPolyfill
    };
  });
enifed("ember-metal/map",
  ["ember-metal/utils","ember-metal/array","ember-metal/platform","ember-metal/deprecate_property","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    /**
    @module ember-metal
    */

    /*
      JavaScript (before ES6) does not have a Map implementation. Objects,
      which are often used as dictionaries, may only have Strings as keys.

      Because Ember has a way to get a unique identifier for every object
      via `Ember.guidFor`, we can implement a performant Map with arbitrary
      keys. Because it is commonly used in low-level bookkeeping, Map is
      implemented as a pure JavaScript object for performance.

      This implementation follows the current iteration of the ES6 proposal for
      maps (http://wiki.ecmascript.org/doku.php?id=harmony:simple_maps_and_sets),
      with one exception:  as we do not have the luxury of in-VM iteration, we implement a
      forEach method for iteration.

      Map is mocked out to look like an Ember object, so you can do
      `Ember.Map.create()` for symmetry with other Ember classes.
    */

    var guidFor = __dependency1__.guidFor;
    var indexOf = __dependency2__.indexOf;
    var create = __dependency3__.create;
    var deprecateProperty = __dependency4__.deprecateProperty;

    function missingFunction(fn) {
      throw new TypeError('' + Object.prototype.toString.call(fn) + " is not a function");
    }

    function missingNew(name) {
      throw new TypeError("Constructor " + name + "requires 'new'");
    }

    function copyNull(obj) {
      var output = create(null);

      for (var prop in obj) {
        // hasOwnPropery is not needed because obj is Object.create(null);
        output[prop] = obj[prop];
      }

      return output;
    }

    function copyMap(original, newObject) {
      var keys = original.keys.copy();
      var values = copyNull(original.values);

      newObject.keys = keys;
      newObject.values = values;
      newObject.size = original.size;

      return newObject;
    }

    /**
      This class is used internally by Ember and Ember Data.
      Please do not use it at this time. We plan to clean it up
      and add many tests soon.

      @class OrderedSet
      @namespace Ember
      @constructor
      @private
    */
    function OrderedSet() {

      if (this instanceof OrderedSet) {
        this.clear();
        this._silenceRemoveDeprecation = false;
      } else {
        missingNew("OrderedSet");
      }
    }

    /**
      @method create
      @static
      @return {Ember.OrderedSet}
    */
    OrderedSet.create = function() {
      var Constructor = this;

      return new Constructor();
    };

    OrderedSet.prototype = {
      constructor: OrderedSet,
      /**
        @method clear
      */
      clear: function() {
        this.presenceSet = create(null);
        this.list = [];
        this.size = 0;
      },

      /**
        @method add
        @param obj
        @param guid (optional, and for internal use)
        @return {Ember.OrderedSet}
      */
      add: function(obj, _guid) {
        var guid = _guid || guidFor(obj);
        var presenceSet = this.presenceSet;
        var list = this.list;

        if (presenceSet[guid] === true) {
          return;
        }

        presenceSet[guid] = true;
        this.size = list.push(obj);

        return this;
      },

      /**
        @deprecated

        @method remove
        @param obj
        @param _guid (optional and for internal use only)
        @return {Boolean}
      */
      remove: function(obj, _guid) {
        Ember.deprecate('Calling `OrderedSet.prototype.remove` has been deprecated, please use `OrderedSet.prototype.delete` instead.', this._silenceRemoveDeprecation);

        return this["delete"](obj, _guid);
      },

      /**
        @method delete
        @param obj
        @param _guid (optional and for internal use only)
        @return {Boolean}
      */
      "delete": function(obj, _guid) {
        var guid = _guid || guidFor(obj);
        var presenceSet = this.presenceSet;
        var list = this.list;

        if (presenceSet[guid] === true) {
          delete presenceSet[guid];
          var index = indexOf.call(list, obj);
          if (index > -1) {
            list.splice(index, 1);
          }
          this.size = list.length;
          return true;
        } else {
          return false;
        }
      },

      /**
        @method isEmpty
        @return {Boolean}
      */
      isEmpty: function() {
        return this.size === 0;
      },

      /**
        @method has
        @param obj
        @return {Boolean}
      */
      has: function(obj) {
        if (this.size === 0) { return false; }

        var guid = guidFor(obj);
        var presenceSet = this.presenceSet;

        return presenceSet[guid] === true;
      },

      /**
        @method forEach
        @param {Function} fn
        @param self
      */
      forEach: function(fn /*, thisArg*/) {
        if (typeof fn !== 'function') {
          missingFunction(fn);
        }

        if (this.size === 0) { return; }

        var list = this.list;
        var length = arguments.length;
        var i;

        if (length === 2) {
          for (i = 0; i < list.length; i++) {
            fn.call(arguments[1], list[i]);
          }
        } else {
          for (i = 0; i < list.length; i++) {
            fn(list[i]);
          }
        }
      },

      /**
        @method toArray
        @return {Array}
      */
      toArray: function() {
        return this.list.slice();
      },

      /**
        @method copy
        @return {Ember.OrderedSet}
      */
      copy: function() {
        var Constructor = this.constructor;
        var set = new Constructor();

        set._silenceRemoveDeprecation = this._silenceRemoveDeprecation;
        set.presenceSet = copyNull(this.presenceSet);
        set.list = this.toArray();
        set.size = this.size;

        return set;
      }
    };

    deprecateProperty(OrderedSet.prototype, 'length', 'size');

    /**
      A Map stores values indexed by keys. Unlike JavaScript's
      default Objects, the keys of a Map can be any JavaScript
      object.

      Internally, a Map has two data structures:

      1. `keys`: an OrderedSet of all of the existing keys
      2. `values`: a JavaScript Object indexed by the `Ember.guidFor(key)`

      When a key/value pair is added for the first time, we
      add the key to the `keys` OrderedSet, and create or
      replace an entry in `values`. When an entry is deleted,
      we delete its entry in `keys` and `values`.

      @class Map
      @namespace Ember
      @private
      @constructor
    */
    function Map() {
      if (this instanceof this.constructor) {
        this.keys = OrderedSet.create();
        this.keys._silenceRemoveDeprecation = true;
        this.values = create(null);
        this.size = 0;
      } else {
        missingNew("OrderedSet");
      }
    }

    Ember.Map = Map;

    /**
      @method create
      @static
    */
    Map.create = function() {
      var Constructor = this;
      return new Constructor();
    };

    Map.prototype = {
      constructor: Map,

      /**
        This property will change as the number of objects in the map changes.

        @property size
        @type number
        @default 0
      */
      size: 0,

      /**
        Retrieve the value associated with a given key.

        @method get
        @param {*} key
        @return {*} the value associated with the key, or `undefined`
      */
      get: function(key) {
        if (this.size === 0) { return; }

        var values = this.values;
        var guid = guidFor(key);

        return values[guid];
      },

      /**
        Adds a value to the map. If a value for the given key has already been
        provided, the new value will replace the old value.

        @method set
        @param {*} key
        @param {*} value
        @return {Ember.Map}
      */
      set: function(key, value) {
        var keys = this.keys;
        var values = this.values;
        var guid = guidFor(key);

        // ensure we don't store -0
        var k = key === -0 ? 0 : key;

        keys.add(k, guid);

        values[guid] = value;

        this.size = keys.size;

        return this;
      },

      /**
        @deprecated see delete
        Removes a value from the map for an associated key.

        @method remove
        @param {*} key
        @return {Boolean} true if an item was removed, false otherwise
      */
      remove: function(key) {
        Ember.deprecate('Calling `Map.prototype.remove` has been deprecated, please use `Map.prototype.delete` instead.');

        return this["delete"](key);
      },

      /**
        Removes a value from the map for an associated key.

        @method delete
        @param {*} key
        @return {Boolean} true if an item was removed, false otherwise
      */
      "delete": function(key) {
        if (this.size === 0) { return false; }
        // don't use ES6 "delete" because it will be annoying
        // to use in browsers that are not ES6 friendly;
        var keys = this.keys;
        var values = this.values;
        var guid = guidFor(key);

        if (keys["delete"](key, guid)) {
          delete values[guid];
          this.size = keys.size;
          return true;
        } else {
          return false;
        }
      },

      /**
        Check whether a key is present.

        @method has
        @param {*} key
        @return {Boolean} true if the item was present, false otherwise
      */
      has: function(key) {
        return this.keys.has(key);
      },

      /**
        Iterate over all the keys and values. Calls the function once
        for each key, passing in the key and value, in that order.

        The keys are guaranteed to be iterated over in insertion order.

        @method forEach
        @param {Function} callback
        @param {*} self if passed, the `this` value inside the
          callback. By default, `this` is the map.
      */
      forEach: function(callback /*, thisArg*/) {
        if (typeof callback !== 'function') {
          missingFunction(callback);
        }

        if (this.size === 0) { return; }

        var length = arguments.length;
        var map = this;
        var cb, thisArg;

        if (length === 2) {
          thisArg = arguments[1];
          cb = function(key) {
            callback.call(thisArg, map.get(key), key);
          };
        } else {
          cb = function(key) {
            callback(map.get(key), key);
          };
        }

        this.keys.forEach(cb);
      },

      /**
        @method clear
      */
      clear: function() {
        this.keys.clear();
        this.values = create(null);
        this.size = 0;
      },

      /**
        @method copy
        @return {Ember.Map}
      */
      copy: function() {
        return copyMap(this, new Map());
      }
    };

    deprecateProperty(Map.prototype, 'length', 'size');

    /**
      @class MapWithDefault
      @namespace Ember
      @extends Ember.Map
      @private
      @constructor
      @param [options]
        @param {*} [options.defaultValue]
    */
    function MapWithDefault(options) {
      this._super$constructor();
      this.defaultValue = options.defaultValue;
    }

    /**
      @method create
      @static
      @param [options]
        @param {*} [options.defaultValue]
      @return {Ember.MapWithDefault|Ember.Map} If options are passed, returns
        `Ember.MapWithDefault` otherwise returns `Ember.Map`
    */
    MapWithDefault.create = function(options) {
      if (options) {
        return new MapWithDefault(options);
      } else {
        return new Map();
      }
    };

    MapWithDefault.prototype = create(Map.prototype);
    MapWithDefault.prototype.constructor = MapWithDefault;
    MapWithDefault.prototype._super$constructor = Map;
    MapWithDefault.prototype._super$get = Map.prototype.get;

    /**
      Retrieve the value associated with a given key.

      @method get
      @param {*} key
      @return {*} the value associated with the key, or the default value
    */
    MapWithDefault.prototype.get = function(key) {
      var hasValue = this.has(key);

      if (hasValue) {
        return this._super$get(key);
      } else {
        var defaultValue = this.defaultValue(key);
        this.set(key, defaultValue);
        return defaultValue;
      }
    };

    /**
      @method copy
      @return {Ember.MapWithDefault}
    */
    MapWithDefault.prototype.copy = function() {
      var Constructor = this.constructor;
      return copyMap(this, new Constructor({
        defaultValue: this.defaultValue
      }));
    };

    __exports__["default"] = Map;

    __exports__.OrderedSet = OrderedSet;
    __exports__.Map = Map;
    __exports__.MapWithDefault = MapWithDefault;
  });
enifed("ember-metal/merge",
  ["ember-metal/keys","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var keys = __dependency1__["default"];

    /**
      Merge the contents of two objects together into the first object.

      ```javascript
      Ember.merge({first: 'Tom'}, {last: 'Dale'}); // {first: 'Tom', last: 'Dale'}
      var a = {first: 'Yehuda'}, b = {last: 'Katz'};
      Ember.merge(a, b); // a == {first: 'Yehuda', last: 'Katz'}, b == {last: 'Katz'}
      ```

      @method merge
      @for Ember
      @param {Object} original The object to merge into
      @param {Object} updates The object to copy properties from
      @return {Object}
    */
    __exports__["default"] = function merge(original, updates) {
      if (!updates || typeof updates !== 'object') { 
        return original;
      }

      var props = keys(updates);
      var prop;
      var length = props.length;

      for (var i = 0; i < length; i++) {
        prop = props[i];
        original[prop] = updates[prop];
      }

      return original;
    }
  });
enifed("ember-metal/mixin",
  ["ember-metal/core","ember-metal/merge","ember-metal/array","ember-metal/platform","ember-metal/utils","ember-metal/expand_properties","ember-metal/properties","ember-metal/computed","ember-metal/binding","ember-metal/observer","ember-metal/events","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __dependency11__, __exports__) {
        // Remove "use strict"; from transpiled module until
    // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed
    //
    // REMOVE_USE_STRICT: true

    /**
    @module ember
    @submodule ember-metal
    */

    var Ember = __dependency1__["default"];
    // warn, assert, wrap, et;
    var merge = __dependency2__["default"];
    var map = __dependency3__.map;
    var indexOf = __dependency3__.indexOf;
    var forEach = __dependency3__.forEach;
    var create = __dependency4__.create;
    var guidFor = __dependency5__.guidFor;
    var meta = __dependency5__.meta;
    var wrap = __dependency5__.wrap;
    var makeArray = __dependency5__.makeArray;
    var apply = __dependency5__.apply;
    var isArray = __dependency5__.isArray;
    var expandProperties = __dependency6__["default"];
    var Descriptor = __dependency7__.Descriptor;
    var defineProperty = __dependency7__.defineProperty;
    var ComputedProperty = __dependency8__.ComputedProperty;
    var Binding = __dependency9__.Binding;
    var addObserver = __dependency10__.addObserver;
    var removeObserver = __dependency10__.removeObserver;
    var addBeforeObserver = __dependency10__.addBeforeObserver;
    var removeBeforeObserver = __dependency10__.removeBeforeObserver;
    var addListener = __dependency11__.addListener;
    var removeListener = __dependency11__.removeListener;

    var REQUIRED;
    var a_map = map;
    var a_indexOf = indexOf;
    var a_forEach = forEach;
    var a_slice = [].slice;
    var o_create = create;
    var metaFor = meta;

    function superFunction(){
      var func = this.__nextSuper;
      var ret;
      if (func) {
        var args = new Array(arguments.length);
        for (var i = 0, l = args.length; i < l; i++) {
          args[i] = arguments[i];
        }
        this.__nextSuper = null;
        ret = apply(this, func, args);
        this.__nextSuper = func;
      }
      return ret;
    }

    function mixinsMeta(obj) {
      var m = metaFor(obj, true);
      var ret = m.mixins;
      if (!ret) {
        ret = m.mixins = {};
      } else if (!m.hasOwnProperty('mixins')) {
        ret = m.mixins = o_create(ret);
      }
      return ret;
    }

    function initMixin(mixin, args) {
      if (args && args.length > 0) {
        mixin.mixins = a_map.call(args, function(x) {
          if (x instanceof Mixin) { return x; }

          // Note: Manually setup a primitive mixin here. This is the only
          // way to actually get a primitive mixin. This way normal creation
          // of mixins will give you combined mixins...
          var mixin = new Mixin();
          mixin.properties = x;
          return mixin;
        });
      }
      return mixin;
    }

    function isMethod(obj) {
      return 'function' === typeof obj &&
             obj.isMethod !== false &&
             obj !== Boolean && obj !== Object && obj !== Number && obj !== Array && obj !== Date && obj !== String;
    }

    var CONTINUE = {};

    function mixinProperties(mixinsMeta, mixin) {
      var guid;

      if (mixin instanceof Mixin) {
        guid = guidFor(mixin);
        if (mixinsMeta[guid]) { return CONTINUE; }
        mixinsMeta[guid] = mixin;
        return mixin.properties;
      } else {
        return mixin; // apply anonymous mixin properties
      }
    }

    function concatenatedMixinProperties(concatProp, props, values, base) {
      var concats;

      // reset before adding each new mixin to pickup concats from previous
      concats = values[concatProp] || base[concatProp];
      if (props[concatProp]) {
        concats = concats ? concats.concat(props[concatProp]) : props[concatProp];
      }

      return concats;
    }

    function giveDescriptorSuper(meta, key, property, values, descs) {
      var superProperty;

      // Computed properties override methods, and do not call super to them
      if (values[key] === undefined) {
        // Find the original descriptor in a parent mixin
        superProperty = descs[key];
      }

      // If we didn't find the original descriptor in a parent mixin, find
      // it on the original object.
      superProperty = superProperty || meta.descs[key];

      if (superProperty === undefined || !(superProperty instanceof ComputedProperty)) {
        return property;
      }

      // Since multiple mixins may inherit from the same parent, we need
      // to clone the computed property so that other mixins do not receive
      // the wrapped version.
      property = o_create(property);
      property.func = wrap(property.func, superProperty.func);

      return property;
    }

    function giveMethodSuper(obj, key, method, values, descs) {
      var superMethod;

      // Methods overwrite computed properties, and do not call super to them.
      if (descs[key] === undefined) {
        // Find the original method in a parent mixin
        superMethod = values[key];
      }

      // If we didn't find the original value in a parent mixin, find it in
      // the original object
      superMethod = superMethod || obj[key];

      // Only wrap the new method if the original method was a function
      if (superMethod === undefined || 'function' !== typeof superMethod) {
        return method;
      }

      return wrap(method, superMethod);
    }

    function applyConcatenatedProperties(obj, key, value, values) {
      var baseValue = values[key] || obj[key];

      if (baseValue) {
        if ('function' === typeof baseValue.concat) {
          return baseValue.concat(value);
        } else {
          return makeArray(baseValue).concat(value);
        }
      } else {
        return makeArray(value);
      }
    }

    function applyMergedProperties(obj, key, value, values) {
      var baseValue = values[key] || obj[key];

      Ember.assert("You passed in `" + JSON.stringify(value) + "` as the value for `" + key +
                   "` but `" + key + "` cannot be an Array", !isArray(value));

      if (!baseValue) { return value; }

      var newBase = merge({}, baseValue);
      var hasFunction = false;

      for (var prop in value) {
        if (!value.hasOwnProperty(prop)) { continue; }

        var propValue = value[prop];
        if (isMethod(propValue)) {
          // TODO: support for Computed Properties, etc?
          hasFunction = true;
          newBase[prop] = giveMethodSuper(obj, prop, propValue, baseValue, {});
        } else {
          newBase[prop] = propValue;
        }
      }

      if (hasFunction) {
        newBase._super = superFunction;
      }

      return newBase;
    }

    function addNormalizedProperty(base, key, value, meta, descs, values, concats, mergings) {
      if (value instanceof Descriptor) {
        if (value === REQUIRED && descs[key]) { return CONTINUE; }

        // Wrap descriptor function to implement
        // __nextSuper() if needed
        if (value.func) {
          value = giveDescriptorSuper(meta, key, value, values, descs);
        }

        descs[key]  = value;
        values[key] = undefined;
      } else {
        if ((concats && a_indexOf.call(concats, key) >= 0) ||
                    key === 'concatenatedProperties' ||
                    key === 'mergedProperties') {
          value = applyConcatenatedProperties(base, key, value, values);
        } else if ((mergings && a_indexOf.call(mergings, key) >= 0)) {
          value = applyMergedProperties(base, key, value, values);
        } else if (isMethod(value)) {
          value = giveMethodSuper(base, key, value, values, descs);
        }

        descs[key] = undefined;
        values[key] = value;
      }
    }

    function mergeMixins(mixins, m, descs, values, base, keys) {
      var mixin, props, key, concats, mergings, meta;

      function removeKeys(keyName) {
        delete descs[keyName];
        delete values[keyName];
      }

      for(var i=0, l=mixins.length; i<l; i++) {
        mixin = mixins[i];
        Ember.assert('Expected hash or Mixin instance, got ' + Object.prototype.toString.call(mixin),
                     typeof mixin === 'object' && mixin !== null && Object.prototype.toString.call(mixin) !== '[object Array]');

        props = mixinProperties(m, mixin);
        if (props === CONTINUE) { continue; }

        if (props) {
          meta = metaFor(base);
          if (base.willMergeMixin) { base.willMergeMixin(props); }
          concats = concatenatedMixinProperties('concatenatedProperties', props, values, base);
          mergings = concatenatedMixinProperties('mergedProperties', props, values, base);

          for (key in props) {
            if (!props.hasOwnProperty(key)) { continue; }
            keys.push(key);
            addNormalizedProperty(base, key, props[key], meta, descs, values, concats, mergings);
          }

          // manually copy toString() because some JS engines do not enumerate it
          if (props.hasOwnProperty('toString')) { base.toString = props.toString; }
        } else if (mixin.mixins) {
          mergeMixins(mixin.mixins, m, descs, values, base, keys);
          if (mixin._without) { a_forEach.call(mixin._without, removeKeys); }
        }
      }
    }

    var IS_BINDING = /^.+Binding$/;

    function detectBinding(obj, key, value, m) {
      if (IS_BINDING.test(key)) {
        var bindings = m.bindings;
        if (!bindings) {
          bindings = m.bindings = {};
        } else if (!m.hasOwnProperty('bindings')) {
          bindings = m.bindings = o_create(m.bindings);
        }
        bindings[key] = value;
      }
    }

    function connectBindings(obj, m) {
      // TODO Mixin.apply(instance) should disconnect binding if exists
      var bindings = m.bindings;
      var key, binding, to;
      if (bindings) {
        for (key in bindings) {
          binding = bindings[key];
          if (binding) {
            to = key.slice(0, -7); // strip Binding off end
            if (binding instanceof Binding) {
              binding = binding.copy(); // copy prototypes' instance
              binding.to(to);
            } else { // binding is string path
              binding = new Binding(to, binding);
            }
            binding.connect(obj);
            obj[key] = binding;
          }
        }
        // mark as applied
        m.bindings = {};
      }
    }

    function finishPartial(obj, m) {
      connectBindings(obj, m || metaFor(obj));
      return obj;
    }

    function followAlias(obj, desc, m, descs, values) {
      var altKey = desc.methodName;
      var value;
      if (descs[altKey] || values[altKey]) {
        value = values[altKey];
        desc  = descs[altKey];
      } else if (m.descs[altKey]) {
        desc  = m.descs[altKey];
        value = undefined;
      } else {
        desc = undefined;
        value = obj[altKey];
      }

      return { desc: desc, value: value };
    }

    function updateObserversAndListeners(obj, key, observerOrListener, pathsKey, updateMethod) {
      var paths = observerOrListener[pathsKey];

      if (paths) {
        for (var i=0, l=paths.length; i<l; i++) {
          updateMethod(obj, paths[i], null, key);
        }
      }
    }

    function replaceObserversAndListeners(obj, key, observerOrListener) {
      var prev = obj[key];

      if ('function' === typeof prev) {
        updateObserversAndListeners(obj, key, prev, '__ember_observesBefore__', removeBeforeObserver);
        updateObserversAndListeners(obj, key, prev, '__ember_observes__', removeObserver);
        updateObserversAndListeners(obj, key, prev, '__ember_listens__', removeListener);
      }

      if ('function' === typeof observerOrListener) {
        updateObserversAndListeners(obj, key, observerOrListener, '__ember_observesBefore__', addBeforeObserver);
        updateObserversAndListeners(obj, key, observerOrListener, '__ember_observes__', addObserver);
        updateObserversAndListeners(obj, key, observerOrListener, '__ember_listens__', addListener);
      }
    }

    function applyMixin(obj, mixins, partial) {
      var descs = {};
      var values = {};
      var m = metaFor(obj);
      var keys = [];
      var key, value, desc;

      obj._super = superFunction;

      // Go through all mixins and hashes passed in, and:
      //
      // * Handle concatenated properties
      // * Handle merged properties
      // * Set up _super wrapping if necessary
      // * Set up computed property descriptors
      // * Copying `toString` in broken browsers
      mergeMixins(mixins, mixinsMeta(obj), descs, values, obj, keys);

      for(var i = 0, l = keys.length; i < l; i++) {
        key = keys[i];
        if (key === 'constructor' || !values.hasOwnProperty(key)) { continue; }

        desc = descs[key];
        value = values[key];

        if (desc === REQUIRED) { continue; }

        while (desc && desc instanceof Alias) {
          var followed = followAlias(obj, desc, m, descs, values);
          desc = followed.desc;
          value = followed.value;
        }

        if (desc === undefined && value === undefined) { continue; }

        replaceObserversAndListeners(obj, key, value);
        detectBinding(obj, key, value, m);
        defineProperty(obj, key, desc, value, m);
      }

      if (!partial) { // don't apply to prototype
        finishPartial(obj, m);
      }

      return obj;
    }

    /**
      @method mixin
      @for Ember
      @param obj
      @param mixins*
      @return obj
    */
    function mixin(obj) {
      var args = a_slice.call(arguments, 1);
      applyMixin(obj, args, false);
      return obj;
    }

    __exports__.mixin = mixin;/**
      The `Ember.Mixin` class allows you to create mixins, whose properties can be
      added to other classes. For instance,

      ```javascript
      App.Editable = Ember.Mixin.create({
        edit: function() {
          console.log('starting to edit');
          this.set('isEditing', true);
        },
        isEditing: false
      });

      // Mix mixins into classes by passing them as the first arguments to
      // .extend.
      App.CommentView = Ember.View.extend(App.Editable, {
        template: Ember.Handlebars.compile('{{#if view.isEditing}}...{{else}}...{{/if}}')
      });

      commentView = App.CommentView.create();
      commentView.edit(); // outputs 'starting to edit'
      ```

      Note that Mixins are created with `Ember.Mixin.create`, not
      `Ember.Mixin.extend`.

      Note that mixins extend a constructor's prototype so arrays and object literals
      defined as properties will be shared amongst objects that implement the mixin.
      If you want to define a property in a mixin that is not shared, you can define
      it either as a computed property or have it be created on initialization of the object.

      ```javascript
      //filters array will be shared amongst any object implementing mixin
      App.Filterable = Ember.Mixin.create({
        filters: Ember.A()
      });

      //filters will be a separate  array for every object implementing the mixin
      App.Filterable = Ember.Mixin.create({
        filters: Ember.computed(function(){return Ember.A();})
      });

      //filters will be created as a separate array during the object's initialization
      App.Filterable = Ember.Mixin.create({
        init: function() {
          this._super();
          this.set("filters", Ember.A());
        }
      });
      ```

      @class Mixin
      @namespace Ember
    */
    __exports__["default"] = Mixin;
    function Mixin() { return initMixin(this, arguments); }
    Mixin.prototype = {
      properties: null,
      mixins: null,
      ownerConstructor: null
    };

    Mixin._apply = applyMixin;

    Mixin.applyPartial = function(obj) {
      var args = a_slice.call(arguments, 1);
      return applyMixin(obj, args, true);
    };

    Mixin.finishPartial = finishPartial;

    // ES6TODO: this relies on a global state?
    Ember.anyUnprocessedMixins = false;

    /**
      @method create
      @static
      @param arguments*
    */
    Mixin.create = function() {
      // ES6TODO: this relies on a global state?
      Ember.anyUnprocessedMixins = true;
      var M = this;
      return initMixin(new M(), arguments);
    };

    var MixinPrototype = Mixin.prototype;

    /**
      @method reopen
      @param arguments*
    */
    MixinPrototype.reopen = function() {
      var mixin, tmp;

      if (this.properties) {
        mixin = Mixin.create();
        mixin.properties = this.properties;
        delete this.properties;
        this.mixins = [mixin];
      } else if (!this.mixins) {
        this.mixins = [];
      }

      var len = arguments.length;
      var mixins = this.mixins;
      var idx;

      for(idx=0; idx < len; idx++) {
        mixin = arguments[idx];
        Ember.assert('Expected hash or Mixin instance, got ' + Object.prototype.toString.call(mixin),
                     typeof mixin === 'object' && mixin !== null && Object.prototype.toString.call(mixin) !== '[object Array]');

        if (mixin instanceof Mixin) {
          mixins.push(mixin);
        } else {
          tmp = Mixin.create();
          tmp.properties = mixin;
          mixins.push(tmp);
        }
      }

      return this;
    };

    /**
      @method apply
      @param obj
      @return applied object
    */
    MixinPrototype.apply = function(obj) {
      return applyMixin(obj, [this], false);
    };

    MixinPrototype.applyPartial = function(obj) {
      return applyMixin(obj, [this], true);
    };

    function _detect(curMixin, targetMixin, seen) {
      var guid = guidFor(curMixin);

      if (seen[guid]) { return false; }
      seen[guid] = true;

      if (curMixin === targetMixin) { return true; }
      var mixins = curMixin.mixins;
      var loc = mixins ? mixins.length : 0;
      while (--loc >= 0) {
        if (_detect(mixins[loc], targetMixin, seen)) { return true; }
      }
      return false;
    }

    /**
      @method detect
      @param obj
      @return {Boolean}
    */
    MixinPrototype.detect = function(obj) {
      if (!obj) { return false; }
      if (obj instanceof Mixin) { return _detect(obj, this, {}); }
      var m = obj['__ember_meta__'];
      var mixins = m && m.mixins;
      if (mixins) {
        return !!mixins[guidFor(this)];
      }
      return false;
    };

    MixinPrototype.without = function() {
      var ret = new Mixin(this);
      ret._without = a_slice.call(arguments);
      return ret;
    };

    function _keys(ret, mixin, seen) {
      if (seen[guidFor(mixin)]) { return; }
      seen[guidFor(mixin)] = true;

      if (mixin.properties) {
        var props = mixin.properties;
        for (var key in props) {
          if (props.hasOwnProperty(key)) { ret[key] = true; }
        }
      } else if (mixin.mixins) {
        a_forEach.call(mixin.mixins, function(x) { _keys(ret, x, seen); });
      }
    }

    MixinPrototype.keys = function() {
      var keys = {};
      var seen = {};
      var ret = [];
      _keys(keys, this, seen);
      for(var key in keys) {
        if (keys.hasOwnProperty(key)) { ret.push(key); }
      }
      return ret;
    };

    // returns the mixins currently applied to the specified object
    // TODO: Make Ember.mixin
    Mixin.mixins = function(obj) {
      var m = obj['__ember_meta__'];
      var mixins = m && m.mixins;
      var ret = [];

      if (!mixins) { return ret; }

      for (var key in mixins) {
        var mixin = mixins[key];

        // skip primitive mixins since these are always anonymous
        if (!mixin.properties) { ret.push(mixin); }
      }

      return ret;
    };

    REQUIRED = new Descriptor();
    REQUIRED.toString = function() { return '(Required Property)'; };

    /**
      Denotes a required property for a mixin

      @method required
      @for Ember
    */
    function required() {
      return REQUIRED;
    }

    __exports__.required = required;function Alias(methodName) {
      this.methodName = methodName;
    }

    Alias.prototype = new Descriptor();

    /**
      Makes a method available via an additional name.

      ```javascript
      App.Person = Ember.Object.extend({
        name: function() {
          return 'Tomhuda Katzdale';
        },
        moniker: Ember.aliasMethod('name')
      });

      var goodGuy = App.Person.create();

      goodGuy.name();    // 'Tomhuda Katzdale'
      goodGuy.moniker(); // 'Tomhuda Katzdale'
      ```

      @method aliasMethod
      @for Ember
      @param {String} methodName name of the method to alias
      @return {Ember.Descriptor}
    */
    function aliasMethod(methodName) {
      return new Alias(methodName);
    }

    __exports__.aliasMethod = aliasMethod;// ..........................................................
    // OBSERVER HELPER
    //

    /**
      Specify a method that observes property changes.

      ```javascript
      Ember.Object.extend({
        valueObserver: Ember.observer('value', function() {
          // Executes whenever the "value" property changes
        })
      });
      ```

      In the future this method may become asynchronous. If you want to ensure
      synchronous behavior, use `immediateObserver`.

      Also available as `Function.prototype.observes` if prototype extensions are
      enabled.

      @method observer
      @for Ember
      @param {String} propertyNames*
      @param {Function} func
      @return func
    */
    function observer() {
      var func  = a_slice.call(arguments, -1)[0];
      var paths;

      var addWatchedProperty = function (path) { paths.push(path); };
      var _paths = a_slice.call(arguments, 0, -1);

      if (typeof func !== "function") {
        // revert to old, soft-deprecated argument ordering

        func  = arguments[0];
        _paths = a_slice.call(arguments, 1);
      }

      paths = [];

      for (var i=0; i<_paths.length; ++i) {
        expandProperties(_paths[i], addWatchedProperty);
      }

      if (typeof func !== "function") {
        throw new Ember.Error("Ember.observer called without a function");
      }

      func.__ember_observes__ = paths;
      return func;
    }

    __exports__.observer = observer;/**
      Specify a method that observes property changes.

      ```javascript
      Ember.Object.extend({
        valueObserver: Ember.immediateObserver('value', function() {
          // Executes whenever the "value" property changes
        })
      });
      ```

      In the future, `Ember.observer` may become asynchronous. In this event,
      `Ember.immediateObserver` will maintain the synchronous behavior.

      Also available as `Function.prototype.observesImmediately` if prototype extensions are
      enabled.

      @method immediateObserver
      @for Ember
      @param {String} propertyNames*
      @param {Function} func
      @return func
    */
    function immediateObserver() {
      for (var i=0, l=arguments.length; i<l; i++) {
        var arg = arguments[i];
        Ember.assert("Immediate observers must observe internal properties only, not properties on other objects.", typeof arg !== "string" || arg.indexOf('.') === -1);
      }

      return observer.apply(this, arguments);
    }

    __exports__.immediateObserver = immediateObserver;/**
      When observers fire, they are called with the arguments `obj`, `keyName`.

      Note, `@each.property` observer is called per each add or replace of an element
      and it's not called with a specific enumeration item.

      A `beforeObserver` fires before a property changes.

      A `beforeObserver` is an alternative form of `.observesBefore()`.

      ```javascript
      App.PersonView = Ember.View.extend({
        friends: [{ name: 'Tom' }, { name: 'Stefan' }, { name: 'Kris' }],

        valueWillChange: Ember.beforeObserver('content.value', function(obj, keyName) {
          this.changingFrom = obj.get(keyName);
        }),

        valueDidChange: Ember.observer('content.value', function(obj, keyName) {
            // only run if updating a value already in the DOM
            if (this.get('state') === 'inDOM') {
              var color = obj.get(keyName) > this.changingFrom ? 'green' : 'red';
              // logic
            }
        }),

        friendsDidChange: Ember.observer('friends.@each.name', function(obj, keyName) {
          // some logic
          // obj.get(keyName) returns friends array
        })
      });
      ```

      Also available as `Function.prototype.observesBefore` if prototype extensions are
      enabled.

      @method beforeObserver
      @for Ember
      @param {String} propertyNames*
      @param {Function} func
      @return func
    */
    function beforeObserver() {
      var func  = a_slice.call(arguments, -1)[0];
      var paths;

      var addWatchedProperty = function(path) { paths.push(path); };

      var _paths = a_slice.call(arguments, 0, -1);

      if (typeof func !== "function") {
        // revert to old, soft-deprecated argument ordering

        func  = arguments[0];
        _paths = a_slice.call(arguments, 1);
      }

      paths = [];

      for (var i=0; i<_paths.length; ++i) {
        expandProperties(_paths[i], addWatchedProperty);
      }

      if (typeof func !== "function") {
        throw new Ember.Error("Ember.beforeObserver called without a function");
      }

      func.__ember_observesBefore__ = paths;
      return func;
    }

    __exports__.beforeObserver = beforeObserver;__exports__.IS_BINDING = IS_BINDING;
    __exports__.Mixin = Mixin;
  });
enifed("ember-metal/observer",
  ["ember-metal/watching","ember-metal/array","ember-metal/events","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var watch = __dependency1__.watch;
    var unwatch = __dependency1__.unwatch;
    var map = __dependency2__.map;
    var listenersFor = __dependency3__.listenersFor;
    var addListener = __dependency3__.addListener;
    var removeListener = __dependency3__.removeListener;
    var suspendListeners = __dependency3__.suspendListeners;
    var suspendListener = __dependency3__.suspendListener;
    /**
    @module ember-metal
    */

    var AFTER_OBSERVERS = ':change';
    var BEFORE_OBSERVERS = ':before';

    function changeEvent(keyName) {
      return keyName + AFTER_OBSERVERS;
    }

    function beforeEvent(keyName) {
      return keyName + BEFORE_OBSERVERS;
    }

    /**
      @method addObserver
      @for Ember
      @param obj
      @param {String} path
      @param {Object|Function} targetOrMethod
      @param {Function|String} [method]
    */
    function addObserver(obj, _path, target, method) {
      addListener(obj, changeEvent(_path), target, method);
      watch(obj, _path);

      return this;
    }

    __exports__.addObserver = addObserver;function observersFor(obj, path) {
      return listenersFor(obj, changeEvent(path));
    }

    __exports__.observersFor = observersFor;/**
      @method removeObserver
      @for Ember
      @param obj
      @param {String} path
      @param {Object|Function} targetOrMethod
      @param {Function|String} [method]
    */
    function removeObserver(obj, _path, target, method) {
      unwatch(obj, _path);
      removeListener(obj, changeEvent(_path), target, method);

      return this;
    }

    __exports__.removeObserver = removeObserver;/**
      @method addBeforeObserver
      @for Ember
      @param obj
      @param {String} path
      @param {Object|Function} targetOrMethod
      @param {Function|String} [method]
    */
    function addBeforeObserver(obj, _path, target, method) {
      addListener(obj, beforeEvent(_path), target, method);
      watch(obj, _path);

      return this;
    }

    __exports__.addBeforeObserver = addBeforeObserver;// Suspend observer during callback.
    //
    // This should only be used by the target of the observer
    // while it is setting the observed path.
    function _suspendBeforeObserver(obj, path, target, method, callback) {
      return suspendListener(obj, beforeEvent(path), target, method, callback);
    }

    __exports__._suspendBeforeObserver = _suspendBeforeObserver;function _suspendObserver(obj, path, target, method, callback) {
      return suspendListener(obj, changeEvent(path), target, method, callback);
    }

    __exports__._suspendObserver = _suspendObserver;function _suspendBeforeObservers(obj, paths, target, method, callback) {
      var events = map.call(paths, beforeEvent);
      return suspendListeners(obj, events, target, method, callback);
    }

    __exports__._suspendBeforeObservers = _suspendBeforeObservers;function _suspendObservers(obj, paths, target, method, callback) {
      var events = map.call(paths, changeEvent);
      return suspendListeners(obj, events, target, method, callback);
    }

    __exports__._suspendObservers = _suspendObservers;function beforeObserversFor(obj, path) {
      return listenersFor(obj, beforeEvent(path));
    }

    __exports__.beforeObserversFor = beforeObserversFor;/**
      @method removeBeforeObserver
      @for Ember
      @param obj
      @param {String} path
      @param {Object|Function} targetOrMethod
      @param {Function|String} [method]
    */
    function removeBeforeObserver(obj, _path, target, method) {
      unwatch(obj, _path);
      removeListener(obj, beforeEvent(_path), target, method);

      return this;
    }

    __exports__.removeBeforeObserver = removeBeforeObserver;
  });
enifed("ember-metal/observer_set",
  ["ember-metal/utils","ember-metal/events","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var guidFor = __dependency1__.guidFor;
    var sendEvent = __dependency2__.sendEvent;

    /*
      this.observerSet = {
        [senderGuid]: { // variable name: `keySet`
          [keyName]: listIndex
        }
      },
      this.observers = [
        {
          sender: obj,
          keyName: keyName,
          eventName: eventName,
          listeners: [
            [target, method, flags]
          ]
        },
        ...
      ]
    */
    __exports__["default"] = ObserverSet;
    function ObserverSet() {
      this.clear();
    }


    ObserverSet.prototype.add = function(sender, keyName, eventName) {
      var observerSet = this.observerSet;
      var observers = this.observers;
      var senderGuid = guidFor(sender);
      var keySet = observerSet[senderGuid];
      var index;

      if (!keySet) {
        observerSet[senderGuid] = keySet = {};
      }
      index = keySet[keyName];
      if (index === undefined) {
        index = observers.push({
          sender: sender,
          keyName: keyName,
          eventName: eventName,
          listeners: []
        }) - 1;
        keySet[keyName] = index;
      }
      return observers[index].listeners;
    };

    ObserverSet.prototype.flush = function() {
      var observers = this.observers;
      var i, len, observer, sender;
      this.clear();
      for (i=0, len=observers.length; i < len; ++i) {
        observer = observers[i];
        sender = observer.sender;
        if (sender.isDestroying || sender.isDestroyed) { continue; }
        sendEvent(sender, observer.eventName, [sender, observer.keyName], observer.listeners);
      }
    };

    ObserverSet.prototype.clear = function() {
      this.observerSet = {};
      this.observers = [];
    };
  });
enifed("ember-metal/path_cache",
  ["ember-metal/cache","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var Cache = __dependency1__["default"];

    var IS_GLOBAL      = /^([A-Z$]|([0-9][A-Z$]))/;
    var IS_GLOBAL_PATH = /^([A-Z$]|([0-9][A-Z$])).*[\.]/;
    var HAS_THIS       = 'this.';

    var isGlobalCache     = new Cache(1000, function(key) { return IS_GLOBAL.test(key);          });
    var isGlobalPathCache = new Cache(1000, function(key) { return IS_GLOBAL_PATH.test(key);     });
    var hasThisCache      = new Cache(1000, function(key) { return key.indexOf(HAS_THIS) !== -1; });
    var isPathCache       = new Cache(1000, function(key) { return key.indexOf('.')      !== -1; });

    var caches = {
      isGlobalCache:     isGlobalCache,
      isGlobalPathCache: isGlobalPathCache,
      hasThisCache:      hasThisCache,
      isPathCache:       isPathCache
    };
    __exports__.caches = caches;
    function isGlobal(path) {
      return isGlobalCache.get(path);
    }

    __exports__.isGlobal = isGlobal;function isGlobalPath(path) {
      return isGlobalPathCache.get(path);
    }

    __exports__.isGlobalPath = isGlobalPath;function hasThis(path) {
      return hasThisCache.get(path);
    }

    __exports__.hasThis = hasThis;function isPath(path) {
      return isPathCache.get(path);
    }

    __exports__.isPath = isPath;
  });
enifed("ember-metal/platform",
  ["ember-metal/platform/define_property","ember-metal/platform/define_properties","ember-metal/platform/create","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var hasES5CompliantDefineProperty = __dependency1__.hasES5CompliantDefineProperty;
    var defineProperty = __dependency1__.defineProperty;
    var defineProperties = __dependency2__["default"];
    var create = __dependency3__["default"];

    /**
    @module ember-metal
    */

    var hasPropertyAccessors = hasES5CompliantDefineProperty;
    var canDefineNonEnumerableProperties = hasES5CompliantDefineProperty;

    /**
      Platform specific methods and feature detectors needed by the framework.

      @class platform
      @namespace Ember
      @static
    */

    __exports__.create = create;
    __exports__.defineProperty = defineProperty;
    __exports__.defineProperties = defineProperties;
    __exports__.hasPropertyAccessors = hasPropertyAccessors;
    __exports__.canDefineNonEnumerableProperties = canDefineNonEnumerableProperties;
  });
enifed("ember-metal/platform/create",
  ["exports"],
  function(__exports__) {
        // Remove "use strict"; from transpiled module until
    // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed
    //
    // REMOVE_USE_STRICT: true

    /**
    @class platform
    @namespace Ember
    @static
    */

    /**
      Identical to `Object.create()`. Implements if not available natively.

      @method create
      @for Ember
    */
    var create;
    // ES5 15.2.3.5
    // http://es5.github.com/#x15.2.3.5
    if (!(Object.create && !Object.create(null).hasOwnProperty)) {
      /* jshint scripturl:true, proto:true */
      // Contributed by Brandon Benvie, October, 2012
      var createEmpty;
      var supportsProto = !({'__proto__':null} instanceof Object);
      // the following produces false positives
      // in Opera Mini => not a reliable check
      // Object.prototype.__proto__ === null
      if (supportsProto || typeof document === 'undefined') {
        createEmpty = function () {
          return { "__proto__": null };
        };
      } else {
        // In old IE __proto__ can't be used to manually set `null`, nor does
        // any other method exist to make an object that inherits from nothing,
        // aside from Object.prototype itself. Instead, create a new global
        // object and *steal* its Object.prototype and strip it bare. This is
        // used as the prototype to create nullary objects.
        createEmpty = function () {
          var iframe = document.createElement('iframe');
          var parent = document.body || document.documentElement;
          iframe.style.display = 'none';
          parent.appendChild(iframe);
          iframe.src = 'javascript:';
          var empty = iframe.contentWindow.Object.prototype;
          parent.removeChild(iframe);
          iframe = null;
          delete empty.constructor;
          delete empty.hasOwnProperty;
          delete empty.propertyIsEnumerable;
          delete empty.isPrototypeOf;
          delete empty.toLocaleString;
          delete empty.toString;
          delete empty.valueOf;

          function Empty() {}
          Empty.prototype = empty;
          // short-circuit future calls
          createEmpty = function () {
            return new Empty();
          };
          return new Empty();
        };
      }

      create = Object.create = function create(prototype, properties) {

        var object;
        function Type() {}  // An empty constructor.

        if (prototype === null) {
          object = createEmpty();
        } else {
          if (typeof prototype !== "object" && typeof prototype !== "function") {
            // In the native implementation `parent` can be `null`
            // OR *any* `instanceof Object`  (Object|Function|Array|RegExp|etc)
            // Use `typeof` tho, b/c in old IE, DOM elements are not `instanceof Object`
            // like they are in modern browsers. Using `Object.create` on DOM elements
            // is...err...probably inappropriate, but the native version allows for it.
            throw new TypeError("Object prototype may only be an Object or null"); // same msg as Chrome
          }

          Type.prototype = prototype;

          object = new Type();
        }

        if (properties !== undefined) {
          Object.defineProperties(object, properties);
        }

        return object;
      };
    } else {
      create = Object.create;
    }

    __exports__["default"] = create;
  });
enifed("ember-metal/platform/define_properties",
  ["ember-metal/platform/define_property","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var defineProperty = __dependency1__.defineProperty;

    var defineProperties = Object.defineProperties;

    // ES5 15.2.3.7
    // http://es5.github.com/#x15.2.3.7
    if (!defineProperties) {
      defineProperties = function defineProperties(object, properties) {
        for (var property in properties) {
          if (properties.hasOwnProperty(property) && property !== "__proto__") {
            defineProperty(object, property, properties[property]);
          }
        }
        return object;
      };

      Object.defineProperties = defineProperties;
    }

    __exports__["default"] = defineProperties;
  });
enifed("ember-metal/platform/define_property",
  ["exports"],
  function(__exports__) {
    "use strict";
    /*globals Node */

    /**
    @class platform
    @namespace Ember
    @static
    */

    /**
      Set to true if the platform supports native getters and setters.

      @property hasPropertyAccessors
      @final
    */

    /**
      Identical to `Object.defineProperty()`. Implements as much functionality
      as possible if not available natively.

      @method defineProperty
      @param {Object} obj The object to modify
      @param {String} keyName property name to modify
      @param {Object} desc descriptor hash
      @return {void}
    */
    var defineProperty = (function checkCompliance(defineProperty) {
      if (!defineProperty) return;
      try {
        var a = 5;
        var obj = {};
        defineProperty(obj, 'a', {
          configurable: true,
          enumerable: true,
          get: function () {
            return a;
          },
          set: function (v) {
            a = v;
          }
        });
        if (obj.a !== 5) return;
        obj.a = 10;
        if (a !== 10) return;

        // check non-enumerability
        defineProperty(obj, 'a', {
          configurable: true,
          enumerable: false,
          writable: true,
          value: true
        });
        for (var key in obj) {
          if (key === 'a') return;
        }

        // Detects a bug in Android <3.2 where you cannot redefine a property using
        // Object.defineProperty once accessors have already been set.
        if (obj.a !== true) return;

        // defineProperty is compliant
        return defineProperty;
      } catch (e) {
        // IE8 defines Object.defineProperty but calling it on an Object throws
        return;
      }
    })(Object.defineProperty);

    var hasES5CompliantDefineProperty = !!defineProperty;

    if (hasES5CompliantDefineProperty && typeof document !== 'undefined') {
      // This is for Safari 5.0, which supports Object.defineProperty, but not
      // on DOM nodes.
      var canDefinePropertyOnDOM = (function() {
        try {
          defineProperty(document.createElement('div'), 'definePropertyOnDOM', {});
          return true;
        } catch(e) { }

        return false;
      })();

      if (!canDefinePropertyOnDOM) {
        defineProperty = function(obj, keyName, desc) {
          var isNode;

          if (typeof Node === "object") {
            isNode = obj instanceof Node;
          } else {
            isNode = typeof obj === "object" && typeof obj.nodeType === "number" && typeof obj.nodeName === "string";
          }

          if (isNode) {
            // TODO: Should we have a warning here?
            return (obj[keyName] = desc.value);
          } else {
            return Object.defineProperty(obj, keyName, desc);
          }
        };
      }
    }

    if (!hasES5CompliantDefineProperty) {
      defineProperty = function defineProperty(obj, keyName, desc) {
        if (!desc.get) { obj[keyName] = desc.value; }
      };
    }

    __exports__.hasES5CompliantDefineProperty = hasES5CompliantDefineProperty;
    __exports__.defineProperty = defineProperty;
  });
enifed("ember-metal/properties",
  ["ember-metal/core","ember-metal/utils","ember-metal/platform","ember-metal/property_events","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    /**
    @module ember-metal
    */

    var Ember = __dependency1__["default"];
    var metaFor = __dependency2__.meta;
    var objectDefineProperty = __dependency3__.defineProperty;
    var hasPropertyAccessors = __dependency3__.hasPropertyAccessors;
    var overrideChains = __dependency4__.overrideChains;
    // ..........................................................
    // DESCRIPTOR
    //

    /**
      Objects of this type can implement an interface to respond to requests to
      get and set. The default implementation handles simple properties.

      You generally won't need to create or subclass this directly.

      @class Descriptor
      @namespace Ember
      @private
      @constructor
    */
    function Descriptor() {}

    __exports__.Descriptor = Descriptor;// ..........................................................
    // DEFINING PROPERTIES API
    //

    function MANDATORY_SETTER_FUNCTION(name) {
      return function SETTER_FUNCTION(value) {
        Ember.assert("You must use Ember.set() to set the `" + name + "` property (of " + this + ") to `" + value + "`.", false);
      };
    }

    __exports__.MANDATORY_SETTER_FUNCTION = MANDATORY_SETTER_FUNCTION;function DEFAULT_GETTER_FUNCTION(name) {
      return function GETTER_FUNCTION() {
        var meta = this['__ember_meta__'];
        return meta && meta.values[name];
      };
    }

    __exports__.DEFAULT_GETTER_FUNCTION = DEFAULT_GETTER_FUNCTION;/**
      NOTE: This is a low-level method used by other parts of the API. You almost
      never want to call this method directly. Instead you should use
      `Ember.mixin()` to define new properties.

      Defines a property on an object. This method works much like the ES5
      `Object.defineProperty()` method except that it can also accept computed
      properties and other special descriptors.

      Normally this method takes only three parameters. However if you pass an
      instance of `Ember.Descriptor` as the third param then you can pass an
      optional value as the fourth parameter. This is often more efficient than
      creating new descriptor hashes for each property.

      ## Examples

      ```javascript
      // ES5 compatible mode
      Ember.defineProperty(contact, 'firstName', {
        writable: true,
        configurable: false,
        enumerable: true,
        value: 'Charles'
      });

      // define a simple property
      Ember.defineProperty(contact, 'lastName', undefined, 'Jolley');

      // define a computed property
      Ember.defineProperty(contact, 'fullName', Ember.computed(function() {
        return this.firstName+' '+this.lastName;
      }).property('firstName', 'lastName'));
      ```

      @private
      @method defineProperty
      @for Ember
      @param {Object} obj the object to define this property on. This may be a prototype.
      @param {String} keyName the name of the property
      @param {Ember.Descriptor} [desc] an instance of `Ember.Descriptor` (typically a
        computed property) or an ES5 descriptor.
        You must provide this or `data` but not both.
      @param {*} [data] something other than a descriptor, that will
        become the explicit value of this property.
    */
    function defineProperty(obj, keyName, desc, data, meta) {
      var descs, existingDesc, watching, value;

      if (!meta) meta = metaFor(obj);
      descs = meta.descs;
      existingDesc = meta.descs[keyName];
      var watchEntry = meta.watching[keyName];

      watching = watchEntry !== undefined && watchEntry > 0;

      if (existingDesc instanceof Descriptor) {
        existingDesc.teardown(obj, keyName);
      }

      if (desc instanceof Descriptor) {
        value = desc;

        descs[keyName] = desc;
        
          if (watching && hasPropertyAccessors) {
            objectDefineProperty(obj, keyName, {
              configurable: true,
              enumerable: true,
              writable: true,
              value: undefined // make enumerable
            });
          } else {
            obj[keyName] = undefined; // make enumerable
          }
                if (desc.setup) { desc.setup(obj, keyName); }
      } else {
        descs[keyName] = undefined; // shadow descriptor in proto
        if (desc == null) {
          value = data;

          
            if (watching && hasPropertyAccessors) {
              meta.values[keyName] = data;
              objectDefineProperty(obj, keyName, {
                configurable: true,
                enumerable: true,
                set: MANDATORY_SETTER_FUNCTION(keyName),
                get: DEFAULT_GETTER_FUNCTION(keyName)
              });
            } else {
              obj[keyName] = data;
            }
                  } else {
          value = desc;

          // compatibility with ES5
          objectDefineProperty(obj, keyName, desc);
        }
      }

      // if key is being watched, override chains that
      // were initialized with the prototype
      if (watching) { overrideChains(obj, keyName, meta); }

      // The `value` passed to the `didDefineProperty` hook is
      // either the descriptor or data, whichever was passed.
      if (obj.didDefineProperty) { obj.didDefineProperty(obj, keyName, value); }

      return this;
    }
    __exports__.defineProperty = defineProperty;
  });
enifed("ember-metal/property_events",
  ["ember-metal/utils","ember-metal/events","ember-metal/observer_set","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var guidFor = __dependency1__.guidFor;
    var tryFinally = __dependency1__.tryFinally;
    var sendEvent = __dependency2__.sendEvent;
    var listenersUnion = __dependency2__.listenersUnion;
    var listenersDiff = __dependency2__.listenersDiff;
    var ObserverSet = __dependency3__["default"];

    var beforeObserverSet = new ObserverSet();
    var observerSet = new ObserverSet();
    var deferred = 0;

    // ..........................................................
    // PROPERTY CHANGES
    //

    /**
      This function is called just before an object property is about to change.
      It will notify any before observers and prepare caches among other things.

      Normally you will not need to call this method directly but if for some
      reason you can't directly watch a property you can invoke this method
      manually along with `Ember.propertyDidChange()` which you should call just
      after the property value changes.

      @method propertyWillChange
      @for Ember
      @param {Object} obj The object with the property that will change
      @param {String} keyName The property key (or path) that will change.
      @return {void}
    */
    function propertyWillChange(obj, keyName) {
      var m = obj['__ember_meta__'];
      var watching = (m && m.watching[keyName] > 0) || keyName === 'length';
      var proto = m && m.proto;
      var desc = m && m.descs[keyName];

      if (!watching) { return; }
      if (proto === obj) { return; }
      if (desc && desc.willChange) { desc.willChange(obj, keyName); }
      dependentKeysWillChange(obj, keyName, m);
      chainsWillChange(obj, keyName, m);
      notifyBeforeObservers(obj, keyName);
    }

    /**
      This function is called just after an object property has changed.
      It will notify any observers and clear caches among other things.

      Normally you will not need to call this method directly but if for some
      reason you can't directly watch a property you can invoke this method
      manually along with `Ember.propertyWillChange()` which you should call just
      before the property value changes.

      @method propertyDidChange
      @for Ember
      @param {Object} obj The object with the property that will change
      @param {String} keyName The property key (or path) that will change.
      @return {void}
    */
    function propertyDidChange(obj, keyName) {
      var m = obj['__ember_meta__'];
      var watching = (m && m.watching[keyName] > 0) || keyName === 'length';
      var proto = m && m.proto;
      var desc = m && m.descs[keyName];

      if (proto === obj) { return; }

      // shouldn't this mean that we're watching this key?
      if (desc && desc.didChange) { desc.didChange(obj, keyName); }
      if (!watching && keyName !== 'length') { return; }

      if (m && m.deps && m.deps[keyName]) {
        dependentKeysDidChange(obj, keyName, m);
      }

      chainsDidChange(obj, keyName, m, false);
      notifyObservers(obj, keyName);
    }

    var WILL_SEEN, DID_SEEN;
    // called whenever a property is about to change to clear the cache of any dependent keys (and notify those properties of changes, etc...)
    function dependentKeysWillChange(obj, depKey, meta) {
      if (obj.isDestroying) { return; }

      var deps;
      if (meta && meta.deps && (deps = meta.deps[depKey])) {
        var seen = WILL_SEEN;
        var top = !seen;
        if (top) { seen = WILL_SEEN = {}; }
        iterDeps(propertyWillChange, obj, deps, depKey, seen, meta);
        if (top) { WILL_SEEN = null; }
      }
    }

    // called whenever a property has just changed to update dependent keys
    function dependentKeysDidChange(obj, depKey, meta) {
      if (obj.isDestroying) { return; }

      var deps;
      if (meta && meta.deps && (deps = meta.deps[depKey])) {
        var seen = DID_SEEN;
        var top = !seen;
        if (top) { seen = DID_SEEN = {}; }
        iterDeps(propertyDidChange, obj, deps, depKey, seen, meta);
        if (top) { DID_SEEN = null; }
      }
    }

    function keysOf(obj) {
      var keys = [];
      for (var key in obj) keys.push(key);
      return keys;
    }

    function iterDeps(method, obj, deps, depKey, seen, meta) {
      var keys, key, i, desc;
      var guid = guidFor(obj);
      var current = seen[guid];
      if (!current) current = seen[guid] = {};
      if (current[depKey]) return;
      current[depKey] = true;

      if (deps) {
        keys = keysOf(deps);
        var descs = meta.descs;
        for (i=0; i<keys.length; i++) {
          key = keys[i];
          desc = descs[key];
          if (desc && desc._suspended === obj) continue;
          method(obj, key);
        }
      }
    }

    function chainsWillChange(obj, keyName, m) {
      if (!(m.hasOwnProperty('chainWatchers') &&
            m.chainWatchers[keyName])) {
        return;
      }

      var nodes = m.chainWatchers[keyName];
      var events = [];
      var i, l;

      for(i = 0, l = nodes.length; i < l; i++) {
        nodes[i].willChange(events);
      }

      for (i = 0, l = events.length; i < l; i += 2) {
        propertyWillChange(events[i], events[i+1]);
      }
    }

    function chainsDidChange(obj, keyName, m, suppressEvents) {
      if (!(m && m.hasOwnProperty('chainWatchers') &&
            m.chainWatchers[keyName])) {
        return;
      }

      var nodes = m.chainWatchers[keyName];
      var events = suppressEvents ? null : [];
      var i, l;

      for(i = 0, l = nodes.length; i < l; i++) {
        nodes[i].didChange(events);
      }

      if (suppressEvents) {
        return;
      }

      for (i = 0, l = events.length; i < l; i += 2) {
        propertyDidChange(events[i], events[i+1]);
      }
    }

    function overrideChains(obj, keyName, m) {
      chainsDidChange(obj, keyName, m, true);
    }

    /**
      @method beginPropertyChanges
      @chainable
      @private
    */
    function beginPropertyChanges() {
      deferred++;
    }

    /**
      @method endPropertyChanges
      @private
    */
    function endPropertyChanges() {
      deferred--;
      if (deferred<=0) {
        beforeObserverSet.clear();
        observerSet.flush();
      }
    }

    /**
      Make a series of property changes together in an
      exception-safe way.

      ```javascript
      Ember.changeProperties(function() {
        obj1.set('foo', mayBlowUpWhenSet);
        obj2.set('bar', baz);
      });
      ```

      @method changeProperties
      @param {Function} callback
      @param [binding]
    */
    function changeProperties(cb, binding) {
      beginPropertyChanges();
      tryFinally(cb, endPropertyChanges, binding);
    }

    function notifyBeforeObservers(obj, keyName) {
      if (obj.isDestroying) { return; }

      var eventName = keyName + ':before';
      var listeners, diff;
      if (deferred) {
        listeners = beforeObserverSet.add(obj, keyName, eventName);
        diff = listenersDiff(obj, eventName, listeners);
        sendEvent(obj, eventName, [obj, keyName], diff);
      } else {
        sendEvent(obj, eventName, [obj, keyName]);
      }
    }

    function notifyObservers(obj, keyName) {
      if (obj.isDestroying) { return; }

      var eventName = keyName + ':change';
      var listeners;
      if (deferred) {
        listeners = observerSet.add(obj, keyName, eventName);
        listenersUnion(obj, eventName, listeners);
      } else {
        sendEvent(obj, eventName, [obj, keyName]);
      }
    }

    __exports__.propertyWillChange = propertyWillChange;
    __exports__.propertyDidChange = propertyDidChange;
    __exports__.overrideChains = overrideChains;
    __exports__.beginPropertyChanges = beginPropertyChanges;
    __exports__.endPropertyChanges = endPropertyChanges;
    __exports__.changeProperties = changeProperties;
  });
enifed("ember-metal/property_get",
  ["ember-metal/core","ember-metal/error","ember-metal/path_cache","ember-metal/platform","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    /**
    @module ember-metal
    */

    var Ember = __dependency1__["default"];
    var EmberError = __dependency2__["default"];
    var isGlobalPath = __dependency3__.isGlobalPath;
    var isPath = __dependency3__.isPath;
    var pathHasThis = __dependency3__.hasThis;
    var hasPropertyAccessors = __dependency4__.hasPropertyAccessors;

    var FIRST_KEY = /^([^\.]+)/;

    // ..........................................................
    // GET AND SET
    //
    // If we are on a platform that supports accessors we can use those.
    // Otherwise simulate accessors by looking up the property directly on the
    // object.

    /**
      Gets the value of a property on an object. If the property is computed,
      the function will be invoked. If the property is not defined but the
      object implements the `unknownProperty` method then that will be invoked.

      If you plan to run on IE8 and older browsers then you should use this
      method anytime you want to retrieve a property on an object that you don't
      know for sure is private. (Properties beginning with an underscore '_'
      are considered private.)

      On all newer browsers, you only need to use this method to retrieve
      properties if the property might not be defined on the object and you want
      to respect the `unknownProperty` handler. Otherwise you can ignore this
      method.

      Note that if the object itself is `undefined`, this method will throw
      an error.

      @method get
      @for Ember
      @param {Object} obj The object to retrieve from.
      @param {String} keyName The property key to retrieve
      @return {Object} the property value or `null`.
    */
    var get = function get(obj, keyName) {
      // Helpers that operate with 'this' within an #each
      if (keyName === '') {
        return obj;
      }

      if (!keyName && 'string' === typeof obj) {
        keyName = obj;
        obj = null;
      }

      Ember.assert("Cannot call get with "+ keyName +" key.", !!keyName);
      Ember.assert("Cannot call get with '"+ keyName +"' on an undefined object.", obj !== undefined);

      if (obj === null) {
        var value = _getPath(obj, keyName);
        Ember.deprecate(
          "Ember.get fetched '"+keyName+"' from the global context. This behavior will change in the future (issue #3852)",
          !value || (obj && obj !== Ember.lookup) || isPath(keyName) || isGlobalPath(keyName+".") // Add a . to ensure simple paths are matched.
        );
        return value;
      }

      var meta = obj['__ember_meta__'];
      var desc = meta && meta.descs[keyName];
      var ret;

      if (desc === undefined && isPath(keyName)) {
        return _getPath(obj, keyName);
      }

      if (desc) {
        return desc.get(obj, keyName);
      } else {
        
          if (hasPropertyAccessors && meta && meta.watching[keyName] > 0) {
            ret = meta.values[keyName];
          } else {
            ret = obj[keyName];
          }
        
        if (ret === undefined &&
            'object' === typeof obj && !(keyName in obj) && 'function' === typeof obj.unknownProperty) {
          return obj.unknownProperty(keyName);
        }

        return ret;
      }
    };

    // Currently used only by Ember Data tests
    if (Ember.config.overrideAccessors) {
      Ember.get = get;
      Ember.config.overrideAccessors();
      get = Ember.get;
    }

    /**
      Normalizes a target/path pair to reflect that actual target/path that should
      be observed, etc. This takes into account passing in global property
      paths (i.e. a path beginning with a captial letter not defined on the
      target).

      @private
      @method normalizeTuple
      @for Ember
      @param {Object} target The current target. May be `null`.
      @param {String} path A path on the target or a global property path.
      @return {Array} a temporary array with the normalized target/path pair.
    */
    function normalizeTuple(target, path) {
      var hasThis  = pathHasThis(path);
      var isGlobal = !hasThis && isGlobalPath(path);
      var key;

      if (!target || isGlobal) target = Ember.lookup;
      if (hasThis) path = path.slice(5);

      Ember.deprecate(
        "normalizeTuple will return '"+path+"' as a non-global. This behavior will change in the future (issue #3852)",
        target === Ember.lookup || !target || hasThis || isGlobal || !isGlobalPath(path+'.')
      );

      if (target === Ember.lookup) {
        key = path.match(FIRST_KEY)[0];
        target = get(target, key);
        path   = path.slice(key.length+1);
      }

      // must return some kind of path to be valid else other things will break.
      if (!path || path.length===0) throw new EmberError('Path cannot be empty');

      return [ target, path ];
    }

    function _getPath(root, path) {
      var hasThis, parts, tuple, idx, len;

      // If there is no root and path is a key name, return that
      // property from the global object.
      // E.g. get('Ember') -> Ember
      if (root === null && !isPath(path)) {
        return get(Ember.lookup, path);
      }

      // detect complicated paths and normalize them
      hasThis = pathHasThis(path);

      if (!root || hasThis) {
        tuple = normalizeTuple(root, path);
        root = tuple[0];
        path = tuple[1];
        tuple.length = 0;
      }

      parts = path.split(".");
      len = parts.length;
      for (idx = 0; root != null && idx < len; idx++) {
        root = get(root, parts[idx], true);
        if (root && root.isDestroyed) { return undefined; }
      }
      return root;
    }

    function getWithDefault(root, key, defaultValue) {
      var value = get(root, key);

      if (value === undefined) { return defaultValue; }
      return value;
    }

    __exports__.getWithDefault = getWithDefault;__exports__["default"] = get;
    __exports__.get = get;
    __exports__.normalizeTuple = normalizeTuple;
    __exports__._getPath = _getPath;
  });
enifed("ember-metal/property_set",
  ["ember-metal/core","ember-metal/property_get","ember-metal/property_events","ember-metal/properties","ember-metal/error","ember-metal/path_cache","ember-metal/platform","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    var getPath = __dependency2__._getPath;
    var propertyWillChange = __dependency3__.propertyWillChange;
    var propertyDidChange = __dependency3__.propertyDidChange;
    var defineProperty = __dependency4__.defineProperty;
    var EmberError = __dependency5__["default"];
    var isPath = __dependency6__.isPath;
    var hasPropertyAccessors = __dependency7__.hasPropertyAccessors;

    var IS_GLOBAL = /^([A-Z$]|([0-9][A-Z$]))/;

    /**
      Sets the value of a property on an object, respecting computed properties
      and notifying observers and other listeners of the change. If the
      property is not defined but the object implements the `setUnknownProperty`
      method then that will be invoked as well.

      @method set
      @for Ember
      @param {Object} obj The object to modify.
      @param {String} keyName The property key to set
      @param {Object} value The value to set
      @return {Object} the passed value.
    */
    var set = function set(obj, keyName, value, tolerant) {
      if (typeof obj === 'string') {
        Ember.assert("Path '" + obj + "' must be global if no obj is given.", IS_GLOBAL.test(obj));
        value = keyName;
        keyName = obj;
        obj = null;
      }

      Ember.assert("Cannot call set with "+ keyName +" key.", !!keyName);

      if (!obj) {
        return setPath(obj, keyName, value, tolerant);
      }

      var meta = obj['__ember_meta__'];
      var desc = meta && meta.descs[keyName];
      var isUnknown, currentValue;

      if (desc === undefined && isPath(keyName)) {
        return setPath(obj, keyName, value, tolerant);
      }

      Ember.assert("You need to provide an object and key to `set`.", !!obj && keyName !== undefined);
      Ember.assert('calling set on destroyed object', !obj.isDestroyed);

      if (desc !== undefined) {
        desc.set(obj, keyName, value);
      } else {

        if (typeof obj === 'object' && obj !== null && value !== undefined && obj[keyName] === value) {
          return value;
        }

        isUnknown = 'object' === typeof obj && !(keyName in obj);

        // setUnknownProperty is called if `obj` is an object,
        // the property does not already exist, and the
        // `setUnknownProperty` method exists on the object
        if (isUnknown && 'function' === typeof obj.setUnknownProperty) {
          obj.setUnknownProperty(keyName, value);
        } else if (meta && meta.watching[keyName] > 0) {
          
            if (hasPropertyAccessors) {
              currentValue = meta.values[keyName];
            } else {
              currentValue = obj[keyName];
            }
                    // only trigger a change if the value has changed
          if (value !== currentValue) {
            propertyWillChange(obj, keyName);
            
              if (hasPropertyAccessors) {
                if (
                  (currentValue === undefined && !(keyName in obj)) ||
                  !Object.prototype.propertyIsEnumerable.call(obj, keyName)
                ) {
                  defineProperty(obj, keyName, null, value); // setup mandatory setter
                } else {
                  meta.values[keyName] = value;
                }
              } else {
                obj[keyName] = value;
              }
                        propertyDidChange(obj, keyName);
          }
        } else {
          obj[keyName] = value;
        }
      }
      return value;
    };

    // Currently used only by Ember Data tests
    // ES6TODO: Verify still true
    if (Ember.config.overrideAccessors) {
      Ember.set = set;
      Ember.config.overrideAccessors();
      set = Ember.set;
    }

    function setPath(root, path, value, tolerant) {
      var keyName;

      // get the last part of the path
      keyName = path.slice(path.lastIndexOf('.') + 1);

      // get the first part of the part
      path    = (path === keyName) ? keyName : path.slice(0, path.length-(keyName.length+1));

      // unless the path is this, look up the first part to
      // get the root
      if (path !== 'this') {
        root = getPath(root, path);
      }

      if (!keyName || keyName.length === 0) {
        throw new EmberError('Property set failed: You passed an empty path');
      }

      if (!root) {
        if (tolerant) { return; }
        else { throw new EmberError('Property set failed: object in path "'+path+'" could not be found or was destroyed.'); }
      }

      return set(root, keyName, value);
    }

    /**
      Error-tolerant form of `Ember.set`. Will not blow up if any part of the
      chain is `undefined`, `null`, or destroyed.

      This is primarily used when syncing bindings, which may try to update after
      an object has been destroyed.

      @method trySet
      @for Ember
      @param {Object} obj The object to modify.
      @param {String} path The property path to set
      @param {Object} value The value to set
    */
    function trySet(root, path, value) {
      return set(root, path, value, true);
    }

    __exports__.trySet = trySet;__exports__.set = set;
  });
enifed("ember-metal/run_loop",
  ["ember-metal/core","ember-metal/utils","ember-metal/array","ember-metal/property_events","backburner","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    var Ember = __dependency1__["default"];
    var apply = __dependency2__.apply;
    var GUID_KEY = __dependency2__.GUID_KEY;
    var indexOf = __dependency3__.indexOf;
    var beginPropertyChanges = __dependency4__.beginPropertyChanges;
    var endPropertyChanges = __dependency4__.endPropertyChanges;
    var Backburner = __dependency5__["default"];

    function onBegin(current) {
      run.currentRunLoop = current;
    }

    function onEnd(current, next) {
      run.currentRunLoop = next;
    }

    // ES6TODO: should Backburner become es6?
    var backburner = new Backburner(['sync', 'actions', 'destroy'], {
      GUID_KEY: GUID_KEY,
      sync: {
        before: beginPropertyChanges,
        after: endPropertyChanges
      },
      defaultQueue: 'actions',
      onBegin: onBegin,
      onEnd: onEnd,
      onErrorTarget: Ember,
      onErrorMethod: 'onerror'
    });
    var slice = [].slice;
    var concat = [].concat;

    // ..........................................................
    // run - this is ideally the only public API the dev sees
    //

    /**
      Runs the passed target and method inside of a RunLoop, ensuring any
      deferred actions including bindings and views updates are flushed at the
      end.

      Normally you should not need to invoke this method yourself. However if
      you are implementing raw event handlers when interfacing with other
      libraries or plugins, you should probably wrap all of your code inside this
      call.

      ```javascript
      run(function() {
        // code to be execute within a RunLoop
      });
      ```

      @class run
      @namespace Ember
      @static
      @constructor
      @param {Object} [target] target of method to call
      @param {Function|String} method Method to invoke.
        May be a function or a string. If you pass a string
        then it will be looked up on the passed target.
      @param {Object} [args*] Any additional arguments you wish to pass to the method.
      @return {Object} return value from invoking the passed function.
    */
    __exports__["default"] = run;
    function run() {
      return backburner.run.apply(backburner, arguments);
    }

    /**
      If no run-loop is present, it creates a new one. If a run loop is
      present it will queue itself to run on the existing run-loops action
      queue.

      Please note: This is not for normal usage, and should be used sparingly.

      If invoked when not within a run loop:

      ```javascript
      run.join(function() {
        // creates a new run-loop
      });
      ```

      Alternatively, if called within an existing run loop:

      ```javascript
      run(function() {
        // creates a new run-loop
        run.join(function() {
          // joins with the existing run-loop, and queues for invocation on
          // the existing run-loops action queue.
        });
      });
      ```

      @method join
      @namespace Ember
      @param {Object} [target] target of method to call
      @param {Function|String} method Method to invoke.
        May be a function or a string. If you pass a string
        then it will be looked up on the passed target.
      @param {Object} [args*] Any additional arguments you wish to pass to the method.
      @return {Object} Return value from invoking the passed function. Please note,
      when called within an existing loop, no return value is possible.
    */
    run.join = function(target, method /* args */) {
      if (!run.currentRunLoop) {
        return Ember.run.apply(Ember, arguments);
      }

      var args = slice.call(arguments);
      args.unshift('actions');
      run.schedule.apply(run, args);
    };

    /**
      Provides a useful utility for when integrating with non-Ember libraries
      that provide asynchronous callbacks.

      Ember utilizes a run-loop to batch and coalesce changes. This works by
      marking the start and end of Ember-related Javascript execution.

      When using events such as a View's click handler, Ember wraps the event
      handler in a run-loop, but when integrating with non-Ember libraries this
      can be tedious.

      For example, the following is rather verbose but is the correct way to combine
      third-party events and Ember code.

      ```javascript
      var that = this;
      jQuery(window).on('resize', function(){
        run(function(){
          that.handleResize();
        });
      });
      ```

      To reduce the boilerplate, the following can be used to construct a
      run-loop-wrapped callback handler.

      ```javascript
      jQuery(window).on('resize', run.bind(this, this.handleResize));
      ```

      @method bind
      @namespace Ember
      @param {Object} [target] target of method to call
      @param {Function|String} method Method to invoke.
        May be a function or a string. If you pass a string
        then it will be looked up on the passed target.
      @param {Object} [args*] Any additional arguments you wish to pass to the method.
      @return {Object} return value from invoking the passed function. Please note,
      when called within an existing loop, no return value is possible.
      @since 1.4.0
    */
    run.bind = function(target, method /* args*/) {
      var args = slice.call(arguments);
      return function() {
        return run.join.apply(run, args.concat(slice.call(arguments)));
      };
    };

    run.backburner = backburner;
    run.currentRunLoop = null;
    run.queues = backburner.queueNames;

    /**
      Begins a new RunLoop. Any deferred actions invoked after the begin will
      be buffered until you invoke a matching call to `run.end()`. This is
      a lower-level way to use a RunLoop instead of using `run()`.

      ```javascript
      run.begin();
      // code to be execute within a RunLoop
      run.end();
      ```

      @method begin
      @return {void}
    */
    run.begin = function() {
      backburner.begin();
    };

    /**
      Ends a RunLoop. This must be called sometime after you call
      `run.begin()` to flush any deferred actions. This is a lower-level way
      to use a RunLoop instead of using `run()`.

      ```javascript
      run.begin();
      // code to be execute within a RunLoop
      run.end();
      ```

      @method end
      @return {void}
    */
    run.end = function() {
      backburner.end();
    };

    /**
      Array of named queues. This array determines the order in which queues
      are flushed at the end of the RunLoop. You can define your own queues by
      simply adding the queue name to this array. Normally you should not need
      to inspect or modify this property.

      @property queues
      @type Array
      @default ['sync', 'actions', 'destroy']
    */

    /**
      Adds the passed target/method and any optional arguments to the named
      queue to be executed at the end of the RunLoop. If you have not already
      started a RunLoop when calling this method one will be started for you
      automatically.

      At the end of a RunLoop, any methods scheduled in this way will be invoked.
      Methods will be invoked in an order matching the named queues defined in
      the `run.queues` property.

      ```javascript
      run.schedule('sync', this, function() {
        // this will be executed in the first RunLoop queue, when bindings are synced
        console.log("scheduled on sync queue");
      });

      run.schedule('actions', this, function() {
        // this will be executed in the 'actions' queue, after bindings have synced.
        console.log("scheduled on actions queue");
      });

      // Note the functions will be run in order based on the run queues order.
      // Output would be:
      //   scheduled on sync queue
      //   scheduled on actions queue
      ```

      @method schedule
      @param {String} queue The name of the queue to schedule against.
        Default queues are 'sync' and 'actions'
      @param {Object} [target] target object to use as the context when invoking a method.
      @param {String|Function} method The method to invoke. If you pass a string it
        will be resolved on the target object at the time the scheduled item is
        invoked allowing you to change the target function.
      @param {Object} [arguments*] Optional arguments to be passed to the queued method.
      @return {void}
    */
    run.schedule = function(queue, target, method) {
      checkAutoRun();
      backburner.schedule.apply(backburner, arguments);
    };

    // Used by global test teardown
    run.hasScheduledTimers = function() {
      return backburner.hasTimers();
    };

    // Used by global test teardown
    run.cancelTimers = function () {
      backburner.cancelTimers();
    };

    /**
      Immediately flushes any events scheduled in the 'sync' queue. Bindings
      use this queue so this method is a useful way to immediately force all
      bindings in the application to sync.

      You should call this method anytime you need any changed state to propagate
      throughout the app immediately without repainting the UI (which happens
      in the later 'render' queue added by the `ember-views` package).

      ```javascript
      run.sync();
      ```

      @method sync
      @return {void}
    */
    run.sync = function() {
      if (backburner.currentInstance) {
        backburner.currentInstance.queues.sync.flush();
      }
    };

    /**
      Invokes the passed target/method and optional arguments after a specified
      period of time. The last parameter of this method must always be a number
      of milliseconds.

      You should use this method whenever you need to run some action after a
      period of time instead of using `setTimeout()`. This method will ensure that
      items that expire during the same script execution cycle all execute
      together, which is often more efficient than using a real setTimeout.

      ```javascript
      run.later(myContext, function() {
        // code here will execute within a RunLoop in about 500ms with this == myContext
      }, 500);
      ```

      @method later
      @param {Object} [target] target of method to invoke
      @param {Function|String} method The method to invoke.
        If you pass a string it will be resolved on the
        target at the time the method is invoked.
      @param {Object} [args*] Optional arguments to pass to the timeout.
      @param {Number} wait Number of milliseconds to wait.
      @return {Object} Timer information for use in cancelling, see `run.cancel`.
    */
    run.later = function(/*target, method*/) {
      return backburner.later.apply(backburner, arguments);
    };

    /**
      Schedule a function to run one time during the current RunLoop. This is equivalent
      to calling `scheduleOnce` with the "actions" queue.

      @method once
      @param {Object} [target] The target of the method to invoke.
      @param {Function|String} method The method to invoke.
        If you pass a string it will be resolved on the
        target at the time the method is invoked.
      @param {Object} [args*] Optional arguments to pass to the timeout.
      @return {Object} Timer information for use in cancelling, see `run.cancel`.
    */
    run.once = function(target, method) {
      checkAutoRun();
      var args = slice.call(arguments);
      args.unshift('actions');
      return apply(backburner, backburner.scheduleOnce, args);
    };

    /**
      Schedules a function to run one time in a given queue of the current RunLoop.
      Calling this method with the same queue/target/method combination will have
      no effect (past the initial call).

      Note that although you can pass optional arguments these will not be
      considered when looking for duplicates. New arguments will replace previous
      calls.

      ```javascript
      run(function() {
        var sayHi = function() { console.log('hi'); }
        run.scheduleOnce('afterRender', myContext, sayHi);
        run.scheduleOnce('afterRender', myContext, sayHi);
        // sayHi will only be executed once, in the afterRender queue of the RunLoop
      });
      ```

      Also note that passing an anonymous function to `run.scheduleOnce` will
      not prevent additional calls with an identical anonymous function from
      scheduling the items multiple times, e.g.:

      ```javascript
      function scheduleIt() {
        run.scheduleOnce('actions', myContext, function() { console.log("Closure"); });
      }
      scheduleIt();
      scheduleIt();
      // "Closure" will print twice, even though we're using `run.scheduleOnce`,
      // because the function we pass to it is anonymous and won't match the
      // previously scheduled operation.
      ```

      Available queues, and their order, can be found at `run.queues`

      @method scheduleOnce
      @param {String} [queue] The name of the queue to schedule against. Default queues are 'sync' and 'actions'.
      @param {Object} [target] The target of the method to invoke.
      @param {Function|String} method The method to invoke.
        If you pass a string it will be resolved on the
        target at the time the method is invoked.
      @param {Object} [args*] Optional arguments to pass to the timeout.
      @return {Object} Timer information for use in cancelling, see `run.cancel`.
    */
    run.scheduleOnce = function(/*queue, target, method*/) {
      checkAutoRun();
      return backburner.scheduleOnce.apply(backburner, arguments);
    };

    /**
      Schedules an item to run from within a separate run loop, after
      control has been returned to the system. This is equivalent to calling
      `run.later` with a wait time of 1ms.

      ```javascript
      run.next(myContext, function() {
        // code to be executed in the next run loop,
        // which will be scheduled after the current one
      });
      ```

      Multiple operations scheduled with `run.next` will coalesce
      into the same later run loop, along with any other operations
      scheduled by `run.later` that expire right around the same
      time that `run.next` operations will fire.

      Note that there are often alternatives to using `run.next`.
      For instance, if you'd like to schedule an operation to happen
      after all DOM element operations have completed within the current
      run loop, you can make use of the `afterRender` run loop queue (added
      by the `ember-views` package, along with the preceding `render` queue
      where all the DOM element operations happen). Example:

      ```javascript
      App.MyCollectionView = Ember.CollectionView.extend({
        didInsertElement: function() {
          run.scheduleOnce('afterRender', this, 'processChildElements');
        },
        processChildElements: function() {
          // ... do something with collectionView's child view
          // elements after they've finished rendering, which
          // can't be done within the CollectionView's
          // `didInsertElement` hook because that gets run
          // before the child elements have been added to the DOM.
        }
      });
      ```

      One benefit of the above approach compared to using `run.next` is
      that you will be able to perform DOM/CSS operations before unprocessed
      elements are rendered to the screen, which may prevent flickering or
      other artifacts caused by delaying processing until after rendering.

      The other major benefit to the above approach is that `run.next`
      introduces an element of non-determinism, which can make things much
      harder to test, due to its reliance on `setTimeout`; it's much harder
      to guarantee the order of scheduled operations when they are scheduled
      outside of the current run loop, i.e. with `run.next`.

      @method next
      @param {Object} [target] target of method to invoke
      @param {Function|String} method The method to invoke.
        If you pass a string it will be resolved on the
        target at the time the method is invoked.
      @param {Object} [args*] Optional arguments to pass to the timeout.
      @return {Object} Timer information for use in cancelling, see `run.cancel`.
    */
    run.next = function() {
      var args = slice.call(arguments);
      args.push(1);
      return apply(backburner, backburner.later, args);
    };

    /**
      Cancels a scheduled item. Must be a value returned by `run.later()`,
      `run.once()`, `run.next()`, `run.debounce()`, or
      `run.throttle()`.

      ```javascript
      var runNext = run.next(myContext, function() {
        // will not be executed
      });
      run.cancel(runNext);

      var runLater = run.later(myContext, function() {
        // will not be executed
      }, 500);
      run.cancel(runLater);

      var runOnce = run.once(myContext, function() {
        // will not be executed
      });
      run.cancel(runOnce);

      var throttle = run.throttle(myContext, function() {
        // will not be executed
      }, 1, false);
      run.cancel(throttle);

      var debounce = run.debounce(myContext, function() {
        // will not be executed
      }, 1);
      run.cancel(debounce);

      var debounceImmediate = run.debounce(myContext, function() {
        // will be executed since we passed in true (immediate)
      }, 100, true);
      // the 100ms delay until this method can be called again will be cancelled
      run.cancel(debounceImmediate);
      ```

      @method cancel
      @param {Object} timer Timer object to cancel
      @return {Boolean} true if cancelled or false/undefined if it wasn't found
    */
    run.cancel = function(timer) {
      return backburner.cancel(timer);
    };

    /**
      Delay calling the target method until the debounce period has elapsed
      with no additional debounce calls. If `debounce` is called again before
      the specified time has elapsed, the timer is reset and the entire period
      must pass again before the target method is called.

      This method should be used when an event may be called multiple times
      but the action should only be called once when the event is done firing.
      A common example is for scroll events where you only want updates to
      happen once scrolling has ceased.

      ```javascript
        var myFunc = function() { console.log(this.name + ' ran.'); };
        var myContext = {name: 'debounce'};

        run.debounce(myContext, myFunc, 150);

        // less than 150ms passes

        run.debounce(myContext, myFunc, 150);

        // 150ms passes
        // myFunc is invoked with context myContext
        // console logs 'debounce ran.' one time.
      ```

      Immediate allows you to run the function immediately, but debounce
      other calls for this function until the wait time has elapsed. If
      `debounce` is called again before the specified time has elapsed,
      the timer is reset and the entire period must pass again before
      the method can be called again.

      ```javascript
        var myFunc = function() { console.log(this.name + ' ran.'); };
        var myContext = {name: 'debounce'};

        run.debounce(myContext, myFunc, 150, true);

        // console logs 'debounce ran.' one time immediately.
        // 100ms passes

        run.debounce(myContext, myFunc, 150, true);

        // 150ms passes and nothing else is logged to the console and
        // the debouncee is no longer being watched

        run.debounce(myContext, myFunc, 150, true);

        // console logs 'debounce ran.' one time immediately.
        // 150ms passes and nothing else is logged to the console and
        // the debouncee is no longer being watched

      ```

      @method debounce
      @param {Object} [target] target of method to invoke
      @param {Function|String} method The method to invoke.
        May be a function or a string. If you pass a string
        then it will be looked up on the passed target.
      @param {Object} [args*] Optional arguments to pass to the timeout.
      @param {Number} wait Number of milliseconds to wait.
      @param {Boolean} immediate Trigger the function on the leading instead
        of the trailing edge of the wait interval. Defaults to false.
      @return {Array} Timer information for use in cancelling, see `run.cancel`.
    */
    run.debounce = function() {
      return backburner.debounce.apply(backburner, arguments);
    };

    /**
      Ensure that the target method is never called more frequently than
      the specified spacing period. The target method is called immediately.

      ```javascript
        var myFunc = function() { console.log(this.name + ' ran.'); };
        var myContext = {name: 'throttle'};

        run.throttle(myContext, myFunc, 150);
        // myFunc is invoked with context myContext
        // console logs 'throttle ran.'

        // 50ms passes
        run.throttle(myContext, myFunc, 150);

        // 50ms passes
        run.throttle(myContext, myFunc, 150);

        // 150ms passes
        run.throttle(myContext, myFunc, 150);
        // myFunc is invoked with context myContext
        // console logs 'throttle ran.'
      ```

      @method throttle
      @param {Object} [target] target of method to invoke
      @param {Function|String} method The method to invoke.
        May be a function or a string. If you pass a string
        then it will be looked up on the passed target.
      @param {Object} [args*] Optional arguments to pass to the timeout.
      @param {Number} spacing Number of milliseconds to space out requests.
      @param {Boolean} immediate Trigger the function on the leading instead
        of the trailing edge of the wait interval. Defaults to true.
      @return {Array} Timer information for use in cancelling, see `run.cancel`.
    */
    run.throttle = function() {
      return backburner.throttle.apply(backburner, arguments);
    };

    // Make sure it's not an autorun during testing
    function checkAutoRun() {
      if (!run.currentRunLoop) {
        Ember.assert("You have turned on testing mode, which disabled the run-loop's autorun. You will need to wrap any code with asynchronous side-effects in an run", !Ember.testing);
      }
    }

    /**
      Add a new named queue after the specified queue.

      The queue to add will only be added once.

      @method _addQueue
      @param {String} name the name of the queue to add.
      @param {String} after the name of the queue to add after.
      @private
    */
    run._addQueue = function(name, after) {
      if (indexOf.call(run.queues, name) === -1) {
        run.queues.splice(indexOf.call(run.queues, after)+1, 0, name);
      }
    };
  });
enifed("ember-metal/set_properties",
  ["ember-metal/property_events","ember-metal/property_set","ember-metal/keys","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var changeProperties = __dependency1__.changeProperties;
    var set = __dependency2__.set;
    var keys = __dependency3__["default"];

    /**
      Set a list of properties on an object. These properties are set inside
      a single `beginPropertyChanges` and `endPropertyChanges` batch, so
      observers will be buffered.

      ```javascript
      var anObject = Ember.Object.create();

      anObject.setProperties({
        firstName: 'Stanley',
        lastName: 'Stuart',
        age: 21
      });
      ```

      @method setProperties
      @param obj
      @param {Object} properties
      @return obj
    */
    __exports__["default"] = function setProperties(obj, properties) {
      if (!properties || typeof properties !== "object") { return obj; }
      changeProperties(function() {
        var props = keys(properties);
        var propertyName;

        for (var i = 0, l = props.length; i < l; i++) {
          propertyName = props[i];

          set(obj, propertyName, properties[propertyName]);
        }
      });
      return obj;
    }
  });
enifed("ember-metal/utils",
  ["ember-metal/core","ember-metal/platform","ember-metal/array","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
        // Remove "use strict"; from transpiled module until
    // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed
    //
    // REMOVE_USE_STRICT: true

    var Ember = __dependency1__["default"];
    var o_defineProperty = __dependency2__.defineProperty;
    var canDefineNonEnumerableProperties = __dependency2__.canDefineNonEnumerableProperties;
    var hasPropertyAccessors = __dependency2__.hasPropertyAccessors;
    var create = __dependency2__.create;

    var forEach = __dependency3__.forEach;

    /**
    @module ember-metal
    */

    /**
      Previously we used `Ember.$.uuid`, however `$.uuid` has been removed from
      jQuery master. We'll just bootstrap our own uuid now.

      @private
      @return {Number} the uuid
    */
    var _uuid = 0;

    /**
      Generates a universally unique identifier. This method
      is used internally by Ember for assisting with
      the generation of GUID's and other unique identifiers
      such as `bind-attr` data attributes.

      @public
      @return {Number} [description]
     */
    function uuid() {
      return ++_uuid;
    }

    __exports__.uuid = uuid;/**
      Prefix used for guids through out Ember.
      @private
      @property GUID_PREFIX
      @for Ember
      @type String
      @final
    */
    var GUID_PREFIX = 'ember';

    var o_create = create;
    // Used for guid generation...
    var numberCache  = [];
    var stringCache  = {};

    /**
      Strongly hint runtimes to intern the provided string.

      When do I need to use this function?

      For the most part, never. Pre-mature optimization is bad, and often the
      runtime does exactly what you need it to, and more often the trade-off isn't
      worth it.

      Why?

      Runtimes store strings in at least 2 different representations:
      Ropes and Symbols (interned strings). The Rope provides a memory efficient
      data-structure for strings created from concatenation or some other string
      manipulation like splitting.

      Unfortunately checking equality of different ropes can be quite costly as
      runtimes must resort to clever string comparison algorithims. These
      algorithims typically cost in proportion to the length of the string.
      Luckily, this is where the Symbols (interned strings) shine. As Symbols are
      unique by their string content, equality checks can be done by pointer
      comparision.

      How do I know if my string is a rope or symbol?

      Typically (warning general sweeping statement, but truthy in runtimes at
      present) static strings created as part of the JS source are interned.
      Strings often used for comparisions can be interned at runtime if some
      criteria are met.  One of these criteria can be the size of the entire rope.
      For example, in chrome 38 a rope longer then 12 characters will not
      intern, nor will segments of that rope.

      Some numbers: http://jsperf.com/eval-vs-keys/8

      Known Trick™

      @private
      @return {String} interned version of the provided string
    */
    function intern(str) {
      var obj = {};
      obj[str] = 1;
      for (var key in obj) {
        if (key === str) return key;
      }
      return str;
    }

    /**
      A unique key used to assign guids and other private metadata to objects.
      If you inspect an object in your browser debugger you will often see these.
      They can be safely ignored.

      On browsers that support it, these properties are added with enumeration
      disabled so they won't show up when you iterate over your properties.

      @private
      @property GUID_KEY
      @for Ember
      @type String
      @final
    */
    var GUID_KEY = intern('__ember' + (+ new Date()));

    var GUID_DESC = {
      writable:    false,
      configurable: false,
      enumerable:  false,
      value: null
    };

    /**
      Generates a new guid, optionally saving the guid to the object that you
      pass in. You will rarely need to use this method. Instead you should
      call `Ember.guidFor(obj)`, which return an existing guid if available.

      @private
      @method generateGuid
      @for Ember
      @param {Object} [obj] Object the guid will be used for. If passed in, the guid will
        be saved on the object and reused whenever you pass the same object
        again.

        If no object is passed, just generate a new guid.
      @param {String} [prefix] Prefix to place in front of the guid. Useful when you want to
        separate the guid into separate namespaces.
      @return {String} the guid
    */
    function generateGuid(obj, prefix) {
      if (!prefix) prefix = GUID_PREFIX;
      var ret = (prefix + uuid());
      if (obj) {
        if (obj[GUID_KEY] === null) {
          obj[GUID_KEY] = ret;
        } else {
          GUID_DESC.value = ret;
          o_defineProperty(obj, GUID_KEY, GUID_DESC);
        }
      }
      return ret;
    }

    __exports__.generateGuid = generateGuid;/**
      Returns a unique id for the object. If the object does not yet have a guid,
      one will be assigned to it. You can call this on any object,
      `Ember.Object`-based or not, but be aware that it will add a `_guid`
      property.

      You can also use this method on DOM Element objects.

      @private
      @method guidFor
      @for Ember
      @param {Object} obj any object, string, number, Element, or primitive
      @return {String} the unique guid for this instance.
    */
    function guidFor(obj) {

      // special cases where we don't want to add a key to object
      if (obj === undefined) return "(undefined)";
      if (obj === null) return "(null)";

      var ret;
      var type = typeof obj;

      // Don't allow prototype changes to String etc. to change the guidFor
      switch(type) {
        case 'number':
          ret = numberCache[obj];
          if (!ret) ret = numberCache[obj] = 'nu'+obj;
          return ret;

        case 'string':
          ret = stringCache[obj];
          if (!ret) ret = stringCache[obj] = 'st' + uuid();
          return ret;

        case 'boolean':
          return obj ? '(true)' : '(false)';

        default:
          if (obj[GUID_KEY]) return obj[GUID_KEY];
          if (obj === Object) return '(Object)';
          if (obj === Array)  return '(Array)';
          ret = GUID_PREFIX + uuid();

          if (obj[GUID_KEY] === null) {
            obj[GUID_KEY] = ret;
          } else {
            GUID_DESC.value = ret;
            o_defineProperty(obj, GUID_KEY, GUID_DESC);
          }
          return ret;
      }
    }

    __exports__.guidFor = guidFor;// ..........................................................
    // META
    //

    var META_DESC = {
      writable: true,
      configurable: false,
      enumerable: false,
      value: null
    };

    function Meta(obj) {
      this.descs = {};
      this.watching = {};
      this.cache = {};
      this.cacheMeta = {};
      this.source = obj;
    }

    Meta.prototype = {
      descs: null,
      deps: null,
      watching: null,
      listeners: null,
      cache: null,
      cacheMeta: null,
      source: null,
      mixins: null,
      bindings: null,
      chains: null,
      chainWatchers: null,
      values: null,
      proto: null
    };

    if (!canDefineNonEnumerableProperties) {
      // on platforms that don't support enumerable false
      // make meta fail jQuery.isPlainObject() to hide from
      // jQuery.extend() by having a property that fails
      // hasOwnProperty check.
      Meta.prototype.__preventPlainObject__ = true;

      // Without non-enumerable properties, meta objects will be output in JSON
      // unless explicitly suppressed
      Meta.prototype.toJSON = function () { };
    }

    // Placeholder for non-writable metas.
    var EMPTY_META = new Meta(null);

    
      if (hasPropertyAccessors) {
        EMPTY_META.values = {};
      }
    

    /**
      Retrieves the meta hash for an object. If `writable` is true ensures the
      hash is writable for this object as well.

      The meta object contains information about computed property descriptors as
      well as any watched properties and other information. You generally will
      not access this information directly but instead work with higher level
      methods that manipulate this hash indirectly.

      @method meta
      @for Ember
      @private

      @param {Object} obj The object to retrieve meta for
      @param {Boolean} [writable=true] Pass `false` if you do not intend to modify
        the meta hash, allowing the method to avoid making an unnecessary copy.
      @return {Object} the meta hash for an object
    */
    function meta(obj, writable) {

      var ret = obj['__ember_meta__'];
      if (writable===false) return ret || EMPTY_META;

      if (!ret) {
        if (canDefineNonEnumerableProperties) o_defineProperty(obj, '__ember_meta__', META_DESC);

        ret = new Meta(obj);

        
          if (hasPropertyAccessors) {
            ret.values = {};
          }
        

        obj['__ember_meta__'] = ret;

        // make sure we don't accidentally try to create constructor like desc
        ret.descs.constructor = null;

      } else if (ret.source !== obj) {
        if (canDefineNonEnumerableProperties) o_defineProperty(obj, '__ember_meta__', META_DESC);

        ret = o_create(ret);
        ret.descs     = o_create(ret.descs);
        ret.watching  = o_create(ret.watching);
        ret.cache     = {};
        ret.cacheMeta = {};
        ret.source    = obj;

        
          if (hasPropertyAccessors) {
            ret.values = o_create(ret.values);
          }
        

        obj['__ember_meta__'] = ret;
      }
      return ret;
    }

    function getMeta(obj, property) {
      var _meta = meta(obj, false);
      return _meta[property];
    }

    __exports__.getMeta = getMeta;function setMeta(obj, property, value) {
      var _meta = meta(obj, true);
      _meta[property] = value;
      return value;
    }

    __exports__.setMeta = setMeta;/**
      @deprecated
      @private

      In order to store defaults for a class, a prototype may need to create
      a default meta object, which will be inherited by any objects instantiated
      from the class's constructor.

      However, the properties of that meta object are only shallow-cloned,
      so if a property is a hash (like the event system's `listeners` hash),
      it will by default be shared across all instances of that class.

      This method allows extensions to deeply clone a series of nested hashes or
      other complex objects. For instance, the event system might pass
      `['listeners', 'foo:change', 'ember157']` to `prepareMetaPath`, which will
      walk down the keys provided.

      For each key, if the key does not exist, it is created. If it already
      exists and it was inherited from its constructor, the constructor's
      key is cloned.

      You can also pass false for `writable`, which will simply return
      undefined if `prepareMetaPath` discovers any part of the path that
      shared or undefined.

      @method metaPath
      @for Ember
      @param {Object} obj The object whose meta we are examining
      @param {Array} path An array of keys to walk down
      @param {Boolean} writable whether or not to create a new meta
        (or meta property) if one does not already exist or if it's
        shared with its constructor
    */
    function metaPath(obj, path, writable) {
      Ember.deprecate("Ember.metaPath is deprecated and will be removed from future releases.");
      var _meta = meta(obj, writable);
      var keyName, value;

      for (var i=0, l=path.length; i<l; i++) {
        keyName = path[i];
        value = _meta[keyName];

        if (!value) {
          if (!writable) { return undefined; }
          value = _meta[keyName] = { __ember_source__: obj };
        } else if (value.__ember_source__ !== obj) {
          if (!writable) { return undefined; }
          value = _meta[keyName] = o_create(value);
          value.__ember_source__ = obj;
        }

        _meta = value;
      }

      return value;
    }

    __exports__.metaPath = metaPath;/**
      Wraps the passed function so that `this._super` will point to the superFunc
      when the function is invoked. This is the primitive we use to implement
      calls to super.

      @private
      @method wrap
      @for Ember
      @param {Function} func The function to call
      @param {Function} superFunc The super function.
      @return {Function} wrapped function.
    */
    function wrap(func, superFunc) {
      function superWrapper() {
        var ret;
        var sup  = this && this.__nextSuper;
        var args = new Array(arguments.length);
        for (var i = 0, l = args.length; i < l; i++) {
          args[i] = arguments[i];
        }
        if(this) { this.__nextSuper = superFunc; }
        ret = apply(this, func, args);
        if(this) { this.__nextSuper = sup; }
        return ret;
      }

      superWrapper.wrappedFunction = func;
      superWrapper.wrappedFunction.__ember_arity__ = func.length;
      superWrapper.__ember_observes__ = func.__ember_observes__;
      superWrapper.__ember_observesBefore__ = func.__ember_observesBefore__;
      superWrapper.__ember_listens__ = func.__ember_listens__;

      return superWrapper;
    }

    __exports__.wrap = wrap;var EmberArray;

    /**
      Returns true if the passed object is an array or Array-like.

      Ember Array Protocol:

        - the object has an objectAt property
        - the object is a native Array
        - the object is an Object, and has a length property

      Unlike `Ember.typeOf` this method returns true even if the passed object is
   