/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi;

import android.text.TextUtils;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.AsyncWeiboRunner;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.LogUtil;

public abstract class AbsOpenAPI {
    private static final String TAG = AbsOpenAPI.class.getName();
    protected static final String API_SERVER = "https://api.weibo.com/2";
    protected static final String HTTPMETHOD_POST = "POST";
    protected static final String HTTPMETHOD_GET = "GET";
    protected static final String KEY_ACCESS_TOKEN = "access_token";
    protected Oauth2AccessToken mAccessToken;

    public AbsOpenAPI(Oauth2AccessToken accessToken) {
        this.mAccessToken = accessToken;
    }

    protected void requestAsync(String url, WeiboParameters params, String httpMethod, RequestListener listener) {
        if (this.mAccessToken == null || TextUtils.isEmpty((CharSequence)url) || params == null || TextUtils.isEmpty((CharSequence)httpMethod) || listener == null) {
            LogUtil.e((String)TAG, (String)"Argument error!");
            return;
        }
        params.put(KEY_ACCESS_TOKEN, this.mAccessToken.getToken());
        AsyncWeiboRunner.requestAsync((String)url, (WeiboParameters)params, (String)httpMethod, (RequestListener)listener);
    }

    protected String requestSync(String url, WeiboParameters params, String httpMethod) {
        if (this.mAccessToken == null || TextUtils.isEmpty((CharSequence)url) || params == null || TextUtils.isEmpty((CharSequence)httpMethod)) {
            LogUtil.e((String)TAG, (String)"Argument error!");
            return "";
        }
        params.put(KEY_ACCESS_TOKEN, this.mAccessToken.getToken());
        return AsyncWeiboRunner.request((String)url, (WeiboParameters)params, (String)httpMethod);
    }
}

