/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi;

import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.SparseArray;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class StatusesAPI
extends AbsOpenAPI {
    public static final int FEATURE_ALL = 0;
    public static final int FEATURE_ORIGINAL = 1;
    public static final int FEATURE_PICTURE = 2;
    public static final int FEATURE_VIDEO = 3;
    public static final int FEATURE_MUSICE = 4;
    public static final int AUTHOR_FILTER_ALL = 0;
    public static final int AUTHOR_FILTER_ATTENTIONS = 1;
    public static final int AUTHOR_FILTER_STRANGER = 2;
    public static final int SRC_FILTER_ALL = 0;
    public static final int SRC_FILTER_WEIBO = 1;
    public static final int SRC_FILTER_WEIQUN = 2;
    public static final int TYPE_FILTER_ALL = 0;
    public static final int TYPE_FILTER_ORIGAL = 1;
    private static final String API_BASE_URL = "https://api.weibo.com/2/statuses";
    private static final int READ_API_FRIENDS_TIMELINE = 0;
    private static final int READ_API_MENTIONS = 1;
    private static final int WRITE_API_UPDATE = 2;
    private static final int WRITE_API_REPOST = 3;
    private static final int WRITE_API_UPLOAD = 4;
    private static final int WRITE_API_UPLOAD_URL_TEXT = 5;
    private static final SparseArray<String> sAPIList = new SparseArray();

    static {
        sAPIList.put(0, (Object)"https://api.weibo.com/2/statuses/friends_timeline.json");
        sAPIList.put(1, (Object)"https://api.weibo.com/2/statuses/mentions.json");
        sAPIList.put(3, (Object)"https://api.weibo.com/2/statuses/repost.json");
        sAPIList.put(2, (Object)"https://api.weibo.com/2/statuses/update.json");
        sAPIList.put(4, (Object)"https://api.weibo.com/2/statuses/upload.json");
        sAPIList.put(5, (Object)"https://api.weibo.com/2/statuses/upload_url_text.json");
    }

    public StatusesAPI(Oauth2AccessToken accessToken) {
        super(accessToken);
    }

    public void friendsTimeline(long since_id, long max_id, int count, int page, boolean base_app, int featureType, boolean trim_user, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page, base_app, trim_user, featureType);
        this.requestAsync((String)sAPIList.get(0), params, "GET", listener);
    }

    public void mentions(long since_id, long max_id, int count, int page, int authorType, int sourceType, int filterType, boolean trim_user, RequestListener listener) {
        WeiboParameters params = this.buildMentionsParams(since_id, max_id, count, page, authorType, sourceType, filterType, trim_user);
        this.requestAsync((String)sAPIList.get(1), params, "GET", listener);
    }

    public void update(String content, String lat, String lon, RequestListener listener) {
        WeiboParameters params = this.buildUpdateParams(content, lat, lon);
        this.requestAsync((String)sAPIList.get(2), params, "POST", listener);
    }

    public void upload(String content, Bitmap bitmap, String lat, String lon, RequestListener listener) {
        WeiboParameters params = this.buildUpdateParams(content, lat, lon);
        params.put("pic", bitmap);
        this.requestAsync((String)sAPIList.get(4), params, "POST", listener);
    }

    public void uploadUrlText(String status, String imageUrl, String pic_id, String lat, String lon, RequestListener listener) {
        WeiboParameters params = this.buildUpdateParams(status, lat, lon);
        params.put("url", imageUrl);
        params.put("pic_id", pic_id);
        this.requestAsync((String)sAPIList.get(5), params, "POST", listener);
    }

    public String friendsTimelineSync(long since_id, long max_id, int count, int page, boolean base_app, int featureType, boolean trim_user) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page, base_app, trim_user, featureType);
        return this.requestSync((String)sAPIList.get(0), params, "GET");
    }

    public String mentionsSync(long since_id, long max_id, int count, int page, int authorType, int sourceType, int filterType, boolean trim_user) {
        WeiboParameters params = this.buildMentionsParams(since_id, max_id, count, page, authorType, sourceType, filterType, trim_user);
        return this.requestSync((String)sAPIList.get(1), params, "GET");
    }

    public String updateSync(String content, String lat, String lon) {
        WeiboParameters params = this.buildUpdateParams(content, lat, lon);
        return this.requestSync((String)sAPIList.get(2), params, "POST");
    }

    public String uploadSync(String content, Bitmap bitmap, String lat, String lon) {
        WeiboParameters params = this.buildUpdateParams(content, lat, lon);
        params.put("pic", bitmap);
        return this.requestSync((String)sAPIList.get(4), params, "POST");
    }

    public String uploadUrlTextSync(String status, String imageUrl, String pic_id, String lat, String lon) {
        WeiboParameters params = this.buildUpdateParams(status, lat, lon);
        params.put("url", imageUrl);
        params.put("pic_id", pic_id);
        return this.requestSync((String)sAPIList.get(5), params, "POST");
    }

    private WeiboParameters buildTimeLineParamsBase(long since_id, long max_id, int count, int page, boolean base_app, boolean trim_user, int featureType) {
        WeiboParameters params = new WeiboParameters();
        params.put("since_id", since_id);
        params.put("max_id", max_id);
        params.put("count", count);
        params.put("page", page);
        params.put("base_app", base_app ? 1 : 0);
        params.put("trim_user", trim_user ? 1 : 0);
        params.put("feature", featureType);
        return params;
    }

    private WeiboParameters buildUpdateParams(String content, String lat, String lon) {
        WeiboParameters params = new WeiboParameters();
        params.put("status", content);
        if (!TextUtils.isEmpty((CharSequence)lon)) {
            params.put("long", lon);
        }
        if (!TextUtils.isEmpty((CharSequence)lat)) {
            params.put("lat", lat);
        }
        return params;
    }

    private WeiboParameters buildMentionsParams(long since_id, long max_id, int count, int page, int authorType, int sourceType, int filterType, boolean trim_user) {
        WeiboParameters params = new WeiboParameters();
        params.put("since_id", since_id);
        params.put("max_id", max_id);
        params.put("count", count);
        params.put("page", page);
        params.put("filter_by_author", authorType);
        params.put("filter_by_source", sourceType);
        params.put("filter_by_type", filterType);
        params.put("trim_user", trim_user ? 1 : 0);
        return params;
    }
}

