/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class FavoritesAPI
extends AbsOpenAPI {
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/favorites";

    public FavoritesAPI(Oauth2AccessToken accessToken) {
        super(accessToken);
    }

    public void favorites(int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildCountPage(count, page);
        this.requestAsync("https://api.weibo.com/2/favorites.json", params, "GET", listener);
    }

    public void ids(int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildCountPage(count, page);
        this.requestAsync("https://api.weibo.com/2/favorites/ids.json", params, "GET", listener);
    }

    public void show(long id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("id", id);
        this.requestAsync("https://api.weibo.com/2/favorites/show.json", params, "GET", listener);
    }

    public void byTags(long tid, int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildCountPage(count, page);
        params.put("tid", tid);
        this.requestAsync("https://api.weibo.com/2/favorites/by_tags.json", params, "GET", listener);
    }

    public void tags(int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildCountPage(count, page);
        this.requestAsync("https://api.weibo.com/2/favorites/tags.json", params, "GET", listener);
    }

    public void byTagsIds(long tid, int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildCountPage(count, page);
        params.put("tid", tid);
        this.requestAsync("https://api.weibo.com/2/favorites/by_tags/ids.json", params, "GET", listener);
    }

    public void create(long id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("id", id);
        this.requestAsync("https://api.weibo.com/2/favorites/create.json", params, "POST", listener);
    }

    public void destroy(long id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("id", id);
        this.requestAsync("https://api.weibo.com/2/favorites/destroy.json", params, "POST", listener);
    }

    public void destroyBatch(long[] ids, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        StringBuilder strb = new StringBuilder();
        long[] lArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            strb.append(id).append(",");
            ++n2;
        }
        strb.deleteCharAt(strb.length() - 1);
        params.put("ids", strb.toString());
        this.requestAsync("https://api.weibo.com/2/favorites/destroy_batch.json", params, "POST", listener);
    }

    public void tagsUpdate(long id, String[] tags, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("id", id);
        StringBuilder strb = new StringBuilder();
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            strb.append(tag).append(",");
            ++n2;
        }
        strb.deleteCharAt(strb.length() - 1);
        params.put("tags", strb.toString());
        this.requestAsync("https://api.weibo.com/2/favorites/tags/update.json", params, "POST", listener);
    }

    public void tagsUpdateBatch(long id, String tag, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("tid", id);
        params.put("tag", tag);
        this.requestAsync("https://api.weibo.com/2/favorites/tags/update_batch.json", params, "POST", listener);
    }

    public void tagsDestroyBatch(long tid, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("tid", tid);
        this.requestAsync("https://api.weibo.com/2/favorites/tags/destroy_batch.json", params, "POST", listener);
    }

    private WeiboParameters buildCountPage(int count, int page) {
        WeiboParameters params = new WeiboParameters();
        params.put("count", count);
        params.put("page", page);
        return params;
    }
}

