/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class SearchAPI
extends AbsOpenAPI {
    public static final int SCHOOL_TYPE_COLLEGE = 1;
    public static final int SCHOOL_TYPE_SENIOR = 2;
    public static final int SCHOOL_TYPE_TECHNICAL = 3;
    public static final int SCHOOL_TYPE_JUNIOR = 4;
    public static final int SCHOOL_TYPE_PRIMARY = 5;
    public static final int FRIEND_TYPE_ATTENTIONS = 0;
    public static final int FRIEND_TYPE_FELLOWS = 1;
    public static final int RANGE_ATTENTIONS = 0;
    public static final int RANGE_ATTENTION_TAGS = 1;
    public static final int RANGE_ALL = 2;
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/search";

    public SearchAPI(Oauth2AccessToken accessToken) {
        super(accessToken);
    }

    public void users(String q, int count, RequestListener listener) {
        WeiboParameters params = this.buildBaseParams(q, count);
        this.requestAsync("https://api.weibo.com/2/search/suggestions/users.json", params, "GET", listener);
    }

    public void statuses(String q, int count, RequestListener listener) {
        WeiboParameters params = this.buildBaseParams(q, count);
        this.requestAsync("https://api.weibo.com/2/search/suggestions/statuses.json", params, "GET", listener);
    }

    public void schools(String q, int count, int schoolType, RequestListener listener) {
        WeiboParameters params = this.buildBaseParams(q, count);
        params.put("type", schoolType);
        this.requestAsync("https://api.weibo.com/2/search/suggestions/schools.json", params, "GET", listener);
    }

    public void companies(String q, int count, RequestListener listener) {
        WeiboParameters params = this.buildBaseParams(q, count);
        this.requestAsync("https://api.weibo.com/2/search/suggestions/companies.json", params, "GET", listener);
    }

    public void apps(String q, int count, RequestListener listener) {
        WeiboParameters params = this.buildBaseParams(q, count);
        this.requestAsync("https://api.weibo.com/2/search/suggestions/apps.json", params, "GET", listener);
    }

    public void atUsers(String q, int count, int type, int range, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("q", q);
        params.put("count", count);
        params.put("type", type);
        params.put("range", range);
        this.requestAsync("https://api.weibo.com/2/search/suggestions/at_users.json", params, "GET", listener);
    }

    private WeiboParameters buildBaseParams(String q, int count) {
        WeiboParameters params = new WeiboParameters();
        params.put("q", q);
        params.put("count", count);
        return params;
    }
}

