/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class ShortUrlAPI
extends AbsOpenAPI {
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/short_url";

    public ShortUrlAPI(Oauth2AccessToken accessToken) {
        super(accessToken);
    }

    public void shorten(String[] url_long, RequestListener listener) {
        WeiboParameters params = this.buildURLRequest(url_long, "url_long");
        this.requestAsync("https://api.weibo.com/2/short_url/shorten.json", params, "GET", listener);
    }

    public void expand(String[] url_short, RequestListener listener) {
        WeiboParameters params = this.buildURLRequest(url_short, "url_short");
        this.requestAsync("https://api.weibo.com/2/short_url/expand.json", params, "GET", listener);
    }

    public String expandSync(String[] url_short) {
        WeiboParameters params = this.buildURLRequest(url_short, "url_short");
        return this.requestSync("https://api.weibo.com/2/short_url/expand.json", params, "GET");
    }

    public void clicks(String[] url_short, RequestListener listener) {
        WeiboParameters params = this.buildURLRequest(url_short, "url_short");
        this.requestAsync("https://api.weibo.com/2/short_url/clicks.json", params, "GET", listener);
    }

    public void referers(String url_short, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("url_short", url_short);
        this.requestAsync("https://api.weibo.com/2/short_url/referers.json", params, "GET", listener);
    }

    public void locations(String url_short, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("url_short", url_short);
        this.requestAsync("https://api.weibo.com/2/short_url/locations.json", params, "GET", listener);
    }

    public void shareCounts(String[] url_short, RequestListener listener) {
        WeiboParameters params = this.buildURLRequest(url_short, "url_short");
        this.requestAsync("https://api.weibo.com/2/short_url/share/counts.json", params, "GET", listener);
    }

    public void shareStatuses(String url_short, long since_id, long max_id, int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildRequestParams(url_short, since_id, max_id, count, page);
        this.requestAsync("https://api.weibo.com/2/short_url/share/statuses.json", params, "GET", listener);
    }

    public void commentCounts(String[] url_short, RequestListener listener) {
        WeiboParameters params = this.buildURLRequest(url_short, "url_short");
        this.requestAsync("https://api.weibo.com/2/short_url/comment/counts.json", params, "GET", listener);
    }

    public void comments(String url_short, long since_id, long max_id, int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildRequestParams(url_short, since_id, max_id, count, page);
        this.requestAsync("https://api.weibo.com/2/short_url/comment/comments.json", params, "GET", listener);
    }

    private WeiboParameters buildRequestParams(String url_short, long since_id, long max_id, int count, int page) {
        WeiboParameters params = new WeiboParameters();
        params.put("url_short", url_short);
        params.put("since_id", since_id);
        params.put("max_id", max_id);
        params.put("count", count);
        params.put("page", page);
        return params;
    }

    private WeiboParameters buildURLRequest(String[] url, String type) {
        WeiboParameters params = new WeiboParameters();
        if (url != null) {
            int length = url.length;
            int i = 0;
            while (i < length) {
                params.put(type, url[i]);
                ++i;
            }
        }
        return params;
    }
}

