/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.models;

import android.text.TextUtils;
import com.sina.weibo.sdk.openapi.models.Comment;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommentList {
    public ArrayList<Comment> commentList;
    public String previous_cursor;
    public String next_cursor;
    public int total_number;

    public static CommentList parse(String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        CommentList comments = new CommentList();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            comments.previous_cursor = jsonObject.optString("previous_cursor", "0");
            comments.next_cursor = jsonObject.optString("next_cursor", "0");
            comments.total_number = jsonObject.optInt("total_number", 0);
            JSONArray jsonArray = jsonObject.optJSONArray("comments");
            if (jsonArray != null && jsonArray.length() > 0) {
                int length = jsonArray.length();
                comments.commentList = new ArrayList(length);
                int ix = 0;
                while (ix < length) {
                    comments.commentList.add(Comment.parse(jsonArray.optJSONObject(ix)));
                    ++ix;
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return comments;
    }
}

