/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.models;

import android.text.TextUtils;
import com.sina.weibo.sdk.openapi.models.Poi;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PoiList {
    public ArrayList<Poi> pois;
    public String totalNumber;

    public static PoiList parse(String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        PoiList poiList = new PoiList();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            poiList.totalNumber = jsonObject.optString("total_number");
            JSONArray jsonArray = jsonObject.optJSONArray("geos");
            if (jsonArray != null && jsonArray.length() > 0) {
                int length = jsonArray.length();
                poiList.pois = new ArrayList(length);
                int ix = 0;
                while (ix < length) {
                    poiList.pois.add(Poi.parse(jsonArray.optJSONObject(ix)));
                    ++ix;
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return poiList;
    }
}

