/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.widget;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import com.sina.weibo.sdk.R;
import com.sina.weibo.sdk.auth.WeiboAuth;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.auth.sso.SsoHandler;
import com.sina.weibo.sdk.utils.LogUtil;

public class LoginButton
extends Button
implements View.OnClickListener {
    private static final String TAG = "LoginButton";
    public static final int LOGIN_INCON_STYLE_1 = 1;
    public static final int LOGIN_INCON_STYLE_2 = 2;
    public static final int LOGIN_INCON_STYLE_3 = 3;
    private Context mContext;
    private WeiboAuth.AuthInfo mAuthInfo;
    private SsoHandler mSsoHandler;
    private WeiboAuthListener mAuthListener;
    private View.OnClickListener mExternalOnClickListener;

    public LoginButton(Context context) {
        this(context, null);
    }

    public LoginButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoginButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize(context);
    }

    public void setWeiboAuthInfo(WeiboAuth.AuthInfo authInfo, WeiboAuthListener authListener) {
        this.mAuthInfo = authInfo;
        this.mAuthListener = authListener;
    }

    public void setWeiboAuthInfo(String appKey, String redirectUrl, String scope, WeiboAuthListener authListener) {
        this.mAuthInfo = new WeiboAuth.AuthInfo(this.mContext, appKey, redirectUrl, scope);
        this.mAuthListener = authListener;
    }

    public void setStyle(int style) {
        int iconResId = R.drawable.com_sina_weibo_sdk_login_button_with_account_text;
        switch (style) {
            case 1: {
                iconResId = R.drawable.com_sina_weibo_sdk_login_button_with_account_text;
                break;
            }
            case 2: {
                iconResId = R.drawable.com_sina_weibo_sdk_login_button_with_frame_logo;
                break;
            }
            case 3: {
                iconResId = R.drawable.com_sina_weibo_sdk_login_button_with_original_logo;
                break;
            }
        }
        this.setBackgroundResource(iconResId);
    }

    public void setExternalOnClickListener(View.OnClickListener listener) {
        this.mExternalOnClickListener = listener;
    }

    public void onClick(View v) {
        if (this.mExternalOnClickListener != null) {
            this.mExternalOnClickListener.onClick(v);
        }
        if (this.mSsoHandler == null && this.mAuthInfo != null) {
            WeiboAuth weiboAuth = new WeiboAuth(this.mContext, this.mAuthInfo);
            this.mSsoHandler = new SsoHandler((Activity)this.mContext, weiboAuth);
        }
        if (this.mSsoHandler != null) {
            this.mSsoHandler.authorize(this.mAuthListener);
        } else {
            LogUtil.e((String)TAG, (String)"Please setWeiboAuthInfo(...) for first");
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mSsoHandler != null) {
            this.mSsoHandler.authorizeCallBack(requestCode, resultCode, data);
        }
    }

    private void initialize(Context context) {
        this.mContext = context;
        this.setOnClickListener(this);
        this.setStyle(1);
    }
}

