/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api.share;

import android.app.Activity;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.api.share.ApiUtils;
import com.sina.weibo.sdk.api.share.BaseRequest;
import com.sina.weibo.sdk.api.share.BaseResponse;
import com.sina.weibo.sdk.api.share.IWeiboDownloadListener;
import com.sina.weibo.sdk.api.share.IWeiboHandler;
import com.sina.weibo.sdk.api.share.IWeiboShareAPI;
import com.sina.weibo.sdk.api.share.ProvideMessageForWeiboRequest;
import com.sina.weibo.sdk.api.share.SendMessageToWeiboResponse;
import com.sina.weibo.sdk.api.share.VersionCheckHandler;
import com.sina.weibo.sdk.api.share.WeiboDownloader;
import com.sina.weibo.sdk.exception.WeiboShareException;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.Utility;

class WeiboShareAPIImpl
implements IWeiboShareAPI {
    private static final String TAG = "WeiboApiImpl";
    private Context mContext;
    private String mAppKey;
    private ApiUtils.WeiboInfo mWeiboInfo = null;
    private boolean mNeedDownloadWeibo = true;
    private IWeiboDownloadListener mDownloadListener;
    private Dialog mDownloadConfirmDialog = null;

    public WeiboShareAPIImpl(Context context, String appKey, boolean needDownloadWeibo) {
        this.mContext = context;
        this.mAppKey = appKey;
        this.mNeedDownloadWeibo = needDownloadWeibo;
        this.mWeiboInfo = ApiUtils.queryWeiboInfo(this.mContext);
        if (this.mWeiboInfo != null) {
            LogUtil.d(TAG, this.mWeiboInfo.toString());
        } else {
            LogUtil.d(TAG, "WeiboInfo: is null");
        }
    }

    @Override
    public boolean isWeiboAppInstalled() {
        return this.mWeiboInfo != null;
    }

    @Override
    public boolean isWeiboAppSupportAPI() {
        return ApiUtils.isWeiboAppSupportAPI(this.getWeiboAppSupportAPI());
    }

    @Override
    public int getWeiboAppSupportAPI() {
        return this.mWeiboInfo == null ? -1 : this.mWeiboInfo.supportApi;
    }

    @Override
    public boolean registerApp() {
        try {
            if (!this.checkEnvironment(this.mNeedDownloadWeibo)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        this.sendBroadcast(this.mContext, "com.sina.weibo.sdk.Intent.ACTION_WEIBO_REGISTER", this.mAppKey, null, null);
        return true;
    }

    @Override
    public boolean handleWeiboResponse(Intent intent, IWeiboHandler.Response handler) {
        String appPackage = intent.getStringExtra("_weibo_appPackage");
        if (appPackage == null) {
            LogUtil.e(TAG, "responseListener() faild appPackage is null");
            return false;
        }
        if (!(handler instanceof Activity)) {
            LogUtil.e(TAG, "responseListener() faild handler is not Activity");
            return false;
        }
        Activity act = (Activity)handler;
        String callPkg = act.getCallingPackage();
        LogUtil.d(TAG, "responseListener() callPkg : " + callPkg);
        if (intent.getStringExtra("_weibo_transaction") == null) {
            LogUtil.e(TAG, "responseListener() faild intent TRAN is null");
            return false;
        }
        if (!ApiUtils.validateWeiboSign(this.mContext, appPackage)) {
            LogUtil.e(TAG, "responseListener() faild appPackage validateSign faild");
            return false;
        }
        SendMessageToWeiboResponse data = new SendMessageToWeiboResponse(intent.getExtras());
        handler.onResponse(data);
        return true;
    }

    @Override
    public boolean handleWeiboRequest(Intent intent, IWeiboHandler.Request handler) {
        if (intent == null || handler == null) {
            return false;
        }
        String appPackage = intent.getStringExtra("_weibo_appPackage");
        String transaction = intent.getStringExtra("_weibo_transaction");
        if (appPackage == null) {
            LogUtil.e(TAG, "requestListener() faild appPackage validateSign faild");
            handler.onRequest(null);
            return false;
        }
        if (transaction == null) {
            LogUtil.e(TAG, "requestListener() faild intent TRAN is null");
            handler.onRequest(null);
            return false;
        }
        if (!ApiUtils.validateWeiboSign(this.mContext, appPackage)) {
            LogUtil.e(TAG, "requestListener() faild appPackage validateSign faild");
            handler.onRequest(null);
            return false;
        }
        ProvideMessageForWeiboRequest data = new ProvideMessageForWeiboRequest(intent.getExtras());
        handler.onRequest(data);
        return true;
    }

    @Override
    public boolean launchWeibo() {
        block4: {
            if (this.mWeiboInfo == null) {
                LogUtil.e(TAG, "startWeibo() faild winfo is null");
                return false;
            }
            try {
                if (!TextUtils.isEmpty((CharSequence)this.mWeiboInfo.packageName)) break block4;
                LogUtil.e(TAG, "startWeibo() faild packageName is null");
                return false;
            }
            catch (Exception e) {
                LogUtil.e(TAG, e.getMessage());
                return false;
            }
        }
        this.mContext.startActivity(this.mContext.getPackageManager().getLaunchIntentForPackage(this.mWeiboInfo.packageName));
        return true;
    }

    @Override
    public boolean sendRequest(BaseRequest request) {
        if (request == null) {
            LogUtil.e(TAG, "sendRequest faild act == null or request == null");
            return false;
        }
        try {
            if (!this.checkEnvironment(this.mNeedDownloadWeibo)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        VersionCheckHandler checkHandler = new VersionCheckHandler(this.mWeiboInfo.packageName);
        if (!request.check(this.mContext, checkHandler)) {
            LogUtil.e(TAG, "sendRequest faild request check faild");
            return false;
        }
        Bundle data = new Bundle();
        request.toBundle(data);
        return this.launchWeiboActivity((Activity)this.mContext, "com.sina.weibo.sdk.action.ACTION_WEIBO_ACTIVITY", this.mWeiboInfo.packageName, this.mAppKey, data);
    }

    @Override
    public boolean sendResponse(BaseResponse response) {
        if (response == null) {
            LogUtil.e(TAG, "sendResponse failed response null");
            return false;
        }
        if (!response.check(this.mContext, new VersionCheckHandler())) {
            LogUtil.e(TAG, "sendResponse checkArgs fail");
            return false;
        }
        Bundle data = new Bundle();
        response.toBundle(data);
        this.sendBroadcast(this.mContext, "com.sina.weibo.sdk.Intent.ACTION_WEIBO_RESPONSE", this.mAppKey, response.reqPackageName, data);
        return true;
    }

    @Override
    public void registerWeiboDownloadListener(IWeiboDownloadListener listener) {
        this.mDownloadListener = listener;
    }

    @Override
    public boolean checkEnvironment(boolean bShowDownloadDialog) throws WeiboShareException {
        if (this.mWeiboInfo == null) {
            if (bShowDownloadDialog) {
                if (this.mDownloadConfirmDialog == null) {
                    this.mDownloadConfirmDialog = WeiboDownloader.createDownloadConfirmDialog(this.mContext, this.mDownloadListener);
                    this.mDownloadConfirmDialog.show();
                } else if (!this.mDownloadConfirmDialog.isShowing()) {
                    this.mDownloadConfirmDialog.show();
                }
                return false;
            }
            throw new WeiboShareException("Weibo is NOT installed!");
        }
        if (!ApiUtils.isWeiboAppSupportAPI(this.mWeiboInfo.supportApi)) {
            throw new WeiboShareException("Weibo do NOT support Share API!");
        }
        if (!ApiUtils.validateWeiboSign(this.mContext, this.mWeiboInfo.packageName)) {
            throw new WeiboShareException("Weibo signature is incorrect!");
        }
        return true;
    }

    private boolean launchWeiboActivity(Activity activity, String action, String pkgName, String appkey, Bundle data) {
        if (activity == null || TextUtils.isEmpty((CharSequence)action) || TextUtils.isEmpty((CharSequence)pkgName) || TextUtils.isEmpty((CharSequence)appkey)) {
            LogUtil.e("ActivityHandler", "send fail, invalid arguments");
            return false;
        }
        Intent intent = new Intent();
        intent.setPackage(pkgName);
        intent.setAction(action);
        String appPackage = activity.getPackageName();
        intent.putExtra("_weibo_sdkVersion", 22);
        intent.putExtra("_weibo_appPackage", appPackage);
        intent.putExtra("_weibo_appKey", appkey);
        intent.putExtra("_weibo_flag", 538116905);
        intent.putExtra("_weibo_sign", MD5.hexdigest(Utility.getSign((Context)activity, appPackage)));
        if (data != null) {
            intent.putExtras(data);
        }
        try {
            LogUtil.d(TAG, "intent=" + intent + ", extra=" + intent.getExtras());
            activity.startActivityForResult(intent, 765);
        }
        catch (ActivityNotFoundException e) {
            LogUtil.e(TAG, "Failed, target ActivityNotFound");
            return false;
        }
        return true;
    }

    private void sendBroadcast(Context context, String action, String key, String packageName, Bundle data) {
        Intent intent = new Intent(action);
        String appPackage = context.getPackageName();
        intent.putExtra("_weibo_sdkVersion", 22);
        intent.putExtra("_weibo_appPackage", appPackage);
        intent.putExtra("_weibo_appKey", key);
        intent.putExtra("_weibo_flag", 538116905);
        intent.putExtra("_weibo_sign", MD5.hexdigest(Utility.getSign(context, appPackage)));
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            intent.setPackage(packageName);
        }
        if (data != null) {
            intent.putExtras(data);
        }
        LogUtil.d(TAG, "intent=" + intent + ", extra=" + intent.getExtras());
        context.sendBroadcast(intent, "com.sina.weibo.permission.WEIBO_SDK_PERMISSION");
    }
}

