/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import com.sina.weibo.sdk.api.share.ApiUtils;
import com.sina.weibo.sdk.utils.MD5;

public class SecurityHelper {
    private static final String WEIBO_MD5_SIGNATURE = "18da2bf10352443a00a5e046d9fca6bd";

    public static boolean validateAppSignatureForIntent(Context context, Intent intent) {
        PackageManager pkgMgr = context.getPackageManager();
        if (pkgMgr == null) {
            return false;
        }
        ResolveInfo resolveInfo = pkgMgr.resolveActivity(intent, 0);
        if (resolveInfo == null) {
            return false;
        }
        String packageName = resolveInfo.activityInfo.packageName;
        try {
            PackageInfo packageInfo = pkgMgr.getPackageInfo(packageName, 64);
            return SecurityHelper.containSign(packageInfo.signatures, WEIBO_MD5_SIGNATURE);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean checkResponseAppLegal(Context context, Intent intent) {
        String appPackage;
        ApiUtils.WeiboInfo winfo = ApiUtils.queryWeiboInfo(context);
        if (winfo != null && winfo.supportApi <= 10352) {
            return true;
        }
        if (winfo == null) {
            return true;
        }
        String string = appPackage = intent != null ? intent.getStringExtra("_weibo_appPackage") : null;
        return appPackage != null && intent.getStringExtra("_weibo_transaction") != null && ApiUtils.validateWeiboSign(context, appPackage);
    }

    public static boolean containSign(Signature[] signatures, String destSign) {
        if (signatures == null || destSign == null) {
            return false;
        }
        Signature[] signatureArray = signatures;
        int n = signatures.length;
        int n2 = 0;
        while (n2 < n) {
            Signature signature = signatureArray[n2];
            String s = MD5.hexdigest(signature.toByteArray());
            if (destSign.equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

