/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.connect.common;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.connect.common.BaseApi;
import org.json.JSONObject;

public class AssistActivity
extends Activity {
    private static BaseApi sApiObject;
    private static final String RESTART_FLAG = "RESTART_FLAG";
    private static final String TAG = "AssistActivity";
    private BaseApi mAPiObject;

    public static Intent getAssistActivityIntent(Context context) {
        Intent intent = new Intent(context, AssistActivity.class);
        return intent;
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.requestWindowFeature(1);
        Log.d((String)TAG, (String)"AssistActivity--onCreate--");
        if (sApiObject == null) {
            return;
        }
        this.mAPiObject = sApiObject;
        sApiObject = null;
        int n = this.mAPiObject.getActivityIntent().getIntExtra("key_request_code", 0);
        boolean bl = false;
        if (bundle != null) {
            bl = bundle.getBoolean(RESTART_FLAG);
        }
        if (!bl) {
            this.startActivityForResult(this.mAPiObject.getActivityIntent(), n);
        }
    }

    protected void onStart() {
        Log.d((String)TAG, (String)"-->onStart");
        super.onStart();
    }

    protected void onResume() {
        Log.d((String)TAG, (String)"-->onResume");
        super.onResume();
    }

    protected void onPause() {
        Log.d((String)TAG, (String)"-->onPause");
        super.onPause();
    }

    protected void onStop() {
        Log.d((String)TAG, (String)"-->onStop");
        super.onStop();
    }

    protected void onDestroy() {
        Log.d((String)TAG, (String)"-->onDestroy");
        super.onDestroy();
    }

    protected void onSaveInstanceState(Bundle bundle) {
        Log.d((String)TAG, (String)"AssistActivity--onSaveInstanceState--");
        bundle.putBoolean(RESTART_FLAG, true);
        super.onSaveInstanceState(bundle);
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        Log.d((String)TAG, (String)("AssistActivity--onActivityResult--" + n2 + " data=" + intent));
        Log.d((String)TAG, (String)("--requestCode: " + n + " | resultCode: " + n2 + " | data: " + intent));
        super.onActivityResult(n, n2, intent);
        if (this.mAPiObject != null) {
            Log.d((String)TAG, (String)"AssistActivity--onActivityResult-- mAPiObject != null");
            this.mAPiObject.onActivityResult(this, n, n2, intent);
        } else {
            Log.d((String)TAG, (String)"AssistActivity--onActivityResult-- mAPiObject == null");
            AssistActivity.setResultDataForLogin(this, intent);
        }
        this.finish();
    }

    public static void setApiObject(BaseApi baseApi) {
        sApiObject = baseApi;
    }

    public static void setResultDataForLogin(Activity activity, Intent intent) {
        try {
            String string = intent.getStringExtra("key_response");
            Log.d((String)TAG, (String)("AssistActivity--setResultDataForLogin-- " + string));
            if (!TextUtils.isEmpty((CharSequence)string)) {
                JSONObject jSONObject = new JSONObject(string);
                String string2 = jSONObject.optString("openid");
                String string3 = jSONObject.optString("access_token");
                if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
                    activity.setResult(10101, intent);
                } else {
                    activity.setResult(12345, intent);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

