/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.connect.common;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.a.b.c;
import com.tencent.connect.auth.QQAuth;
import com.tencent.connect.auth.QQToken;
import com.tencent.connect.common.AssistActivity;
import com.tencent.open.TDialog;
import com.tencent.open.utils.HttpUtils;
import com.tencent.open.utils.SystemUtils;
import com.tencent.open.utils.Util;
import com.tencent.tauth.IRequestListener;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.UiError;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.conn.ConnectTimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseApi {
    private static final String KEY_REQUEST_CODE = "key_request_code";
    protected static final String DEFAULT_PF = "openmobile_android";
    protected static final String PREFERENCE_PF = "pfStore";
    protected static final String ACTIVITY_ENCRY_TOKEN = "com.tencent.open.agent.EncryTokenActivity";
    protected static final String ACTIVITY_AGENT = "com.tencent.open.agent.AgentActivity";
    protected static final String ACTION_CHECK_TOKEN = "action_check_token";
    protected static final String PARAM_ENCRY_EOKEN = "encry_token";
    private static final String TAG = BaseApi.class.getName();
    private static final int MSG_COMPLETE = 0;
    protected QQAuth mQQAuth;
    protected QQToken mToken;
    protected List<ApiTask> mTaskList = null;
    protected Intent mActivityIntent = null;
    protected static int sRequestCode = 1000;
    protected IUiListener mUiListener = null;
    public static String registerChannel = null;
    public static String installChannel = null;
    public static String businessId = null;
    public static boolean isOEM = false;
    protected static final String VERSION = "android";
    protected static final String PLATFORM = "desktop_m_qq";
    protected ProgressDialog mProgressDialog;

    public BaseApi(QQAuth qQAuth, QQToken qQToken) {
        this.mQQAuth = qQAuth;
        this.mToken = qQToken;
        this.mTaskList = new ArrayList<ApiTask>();
    }

    public BaseApi(QQToken qQToken) {
        this(null, qQToken);
    }

    public void onActivityResult(Activity activity, int n, int n2, Intent intent) {
        IUiListener iUiListener = null;
        for (ApiTask apiTask : this.mTaskList) {
            if (apiTask.mRequestCode != n) continue;
            iUiListener = apiTask.mListener;
            this.mTaskList.remove(apiTask);
            break;
        }
        if (iUiListener == null) {
            Log.d((String)TAG, (String)"BaseApi--onActivityResult-- listener == null");
            AssistActivity.setResultDataForLogin(activity, intent);
            return;
        }
        if (n2 == -1) {
            BaseApi.handleDataToListener(intent, iUiListener);
        } else {
            com.tencent.a.a.c.b("openSDK_LOG", "OpenUi, onActivityResult, Constants.ACTIVITY_CANCEL");
            iUiListener.onCancel();
        }
        com.tencent.a.a.c.a().b();
    }

    public static void handleDataToListener(Intent intent, IUiListener iUiListener) {
        int n = intent.getIntExtra("key_error_code", 0);
        if (n == 0) {
            String string = intent.getStringExtra("key_response");
            if (string != null) {
                try {
                    JSONObject jSONObject = Util.parseJson(string);
                    iUiListener.onComplete(jSONObject);
                }
                catch (JSONException jSONException) {
                    iUiListener.onError(new UiError(-4, "\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u6709\u8bef!", string));
                    com.tencent.a.a.c.a("openSDK_LOG", "OpenUi, onActivityResult, json error", jSONException);
                }
            } else {
                com.tencent.a.a.c.b("openSDK_LOG", "OpenUi, onActivityResult, onComplete");
                iUiListener.onComplete(new JSONObject());
            }
        } else {
            com.tencent.a.a.c.d("openSDK_LOG", "OpenUi, onActivityResult, onError = " + n + "");
            String string = intent.getStringExtra("key_error_msg");
            String string2 = intent.getStringExtra("key_error_detail");
            iUiListener.onError(new UiError(n, string, string2));
        }
    }

    Intent getActivityIntent() {
        return this.mActivityIntent;
    }

    protected Bundle composeCGIParams() {
        Bundle bundle = new Bundle();
        bundle.putString("format", "json");
        bundle.putString("status_os", Build.VERSION.RELEASE);
        bundle.putString("status_machine", Build.MODEL);
        bundle.putString("status_version", Build.VERSION.SDK);
        bundle.putString("sdkv", "2.6.lite");
        bundle.putString("sdkp", "a");
        if (this.mToken != null && this.mToken.isSessionValid()) {
            bundle.putString("access_token", this.mToken.getAccessToken());
            bundle.putString("oauth_consumer_key", this.mToken.getAppId());
            bundle.putString("openid", this.mToken.getOpenId());
            bundle.putString("appid_for_getting_config", this.mToken.getAppId());
        }
        SharedPreferences sharedPreferences = c.a().getSharedPreferences(PREFERENCE_PF, 0);
        if (isOEM) {
            bundle.putString("pf", "desktop_m_qq-" + installChannel + "-" + VERSION + "-" + registerChannel + "-" + businessId);
        } else {
            String string = sharedPreferences.getString("pf", DEFAULT_PF);
            bundle.putString("pf", string);
        }
        return bundle;
    }

    protected String getCommonDownloadQQUrl() {
        Bundle bundle = this.composeCGIParams();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("http://qzs.qq.com/open/mobile/login/qzsjump.html?");
        stringBuilder.append(Util.encodeUrl(bundle));
        return stringBuilder.toString();
    }

    protected Bundle composeActivityParams() {
        String string;
        Bundle bundle = new Bundle();
        bundle.putString("appid", this.mToken.getAppId());
        if (this.mToken.isSessionValid()) {
            bundle.putString("keystr", this.mToken.getAccessToken());
            bundle.putString("keytype", "0x80");
        }
        if ((string = this.mToken.getOpenId()) != null) {
            bundle.putString("hopenid", string);
        }
        bundle.putString("platform", "androidqz");
        SharedPreferences sharedPreferences = c.a().getSharedPreferences(PREFERENCE_PF, 0);
        if (isOEM) {
            bundle.putString("pf", "desktop_m_qq-" + installChannel + "-" + VERSION + "-" + registerChannel + "-" + businessId);
        } else {
            String string2 = sharedPreferences.getString("pf", DEFAULT_PF);
            bundle.putString("pf", string2);
            bundle.putString("pf", DEFAULT_PF);
        }
        bundle.putString("sdkv", "2.6.lite");
        bundle.putString("sdkp", "a");
        return bundle;
    }

    private Intent getAssitIntent(Activity activity) {
        Intent intent = new Intent(activity.getApplicationContext(), AssistActivity.class);
        return intent;
    }

    protected void startAssitActivity(Activity activity, IUiListener iUiListener) {
        AssistActivity.setApiObject(this);
        int n = sRequestCode++;
        this.mActivityIntent.putExtra(KEY_REQUEST_CODE, n);
        this.mTaskList.add(new ApiTask(n, iUiListener));
        activity.startActivityForResult(this.getAssitIntent(activity), 10100);
    }

    protected void startAssitActivity(Fragment fragment, IUiListener iUiListener) {
        AssistActivity.setApiObject(this);
        int n = sRequestCode++;
        this.mActivityIntent.putExtra(KEY_REQUEST_CODE, n);
        this.mTaskList.add(new ApiTask(n, iUiListener));
        fragment.startActivityForResult(this.getAssitIntent((Activity)fragment.getActivity()), 10100);
    }

    protected boolean hasActivityForIntent() {
        if (this.mActivityIntent != null) {
            return SystemUtils.isActivityExist(c.a(), this.mActivityIntent);
        }
        return false;
    }

    protected Intent getTargetActivityIntent(String string) {
        String string2;
        Intent intent = new Intent();
        intent.setClassName("com.qzone", string);
        Intent intent2 = new Intent();
        intent2.setClassName("com.tencent.mobileqq", string);
        if (SystemUtils.isActivityExist(c.a(), intent2)) {
            return intent2;
        }
        if (SystemUtils.isActivityExist(c.a(), intent) && SystemUtils.compareVersion(string2 = SystemUtils.getAppVersionName(c.a(), "com.qzone"), "3.4") >= 0) {
            return SystemUtils.isAppSignatureValid(c.a(), intent.getComponent().getPackageName(), "ec96e9ac1149251acbb1b0c5777cae95") ? intent : null;
        }
        return null;
    }

    protected void handleDownloadLastestQQ(Activity activity, Bundle bundle, IUiListener iUiListener) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("http://qzs.qq.com/open/mobile/login/qzsjump.html?");
        stringBuilder.append(Util.encodeUrl(bundle));
        String string = stringBuilder.toString();
        TDialog tDialog = new TDialog((Context)activity, "", string, null, this.mToken);
        tDialog.show();
    }

    protected void showProgressDialog(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "\u8bf7\u7a0d\u5019";
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "\u6b63\u5728\u52a0\u8f7d...";
        }
        this.mProgressDialog = ProgressDialog.show((Context)context, (CharSequence)string, (CharSequence)string2);
        this.mProgressDialog.setCancelable(true);
    }

    protected Intent getAgentIntent() {
        return this.getTargetActivityIntent(ACTIVITY_AGENT);
    }

    protected Intent getAgentIntentWithTarget(String string) {
        Intent intent = new Intent();
        Intent intent2 = this.getTargetActivityIntent(string);
        if (intent2 == null) {
            intent = null;
        } else if (intent2.getComponent() != null) {
            intent.setClassName(intent2.getComponent().getPackageName(), ACTIVITY_AGENT);
        } else {
            intent = null;
        }
        return intent;
    }

    public void releaseResource() {
    }

    public class TempRequestListener
    implements IRequestListener {
        private final IUiListener mListener;
        private final Handler mHandler;

        public TempRequestListener(IUiListener iUiListener) {
            this.mListener = iUiListener;
            this.mHandler = new Handler(c.a().getMainLooper()){

                public void handleMessage(Message message) {
                    if (message.what == 0) {
                        TempRequestListener.this.mListener.onComplete(message.obj);
                    } else {
                        TempRequestListener.this.mListener.onError(new UiError(message.what, (String)message.obj, null));
                    }
                }
            };
        }

        @Override
        public void onComplete(JSONObject jSONObject) {
            Message message = this.mHandler.obtainMessage();
            message.obj = jSONObject;
            message.what = 0;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onIOException(IOException iOException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = iOException.getMessage();
            message.what = -2;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onMalformedURLException(MalformedURLException malformedURLException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = malformedURLException.getMessage();
            message.what = -3;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onJSONException(JSONException jSONException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = jSONException.getMessage();
            message.what = -4;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onConnectTimeoutException(ConnectTimeoutException connectTimeoutException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = connectTimeoutException.getMessage();
            message.what = -7;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onSocketTimeoutException(SocketTimeoutException socketTimeoutException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = socketTimeoutException.getMessage();
            message.what = -8;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onNetworkUnavailableException(HttpUtils.NetworkUnavailableException networkUnavailableException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = networkUnavailableException.getMessage();
            message.what = -10;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onHttpStatusException(HttpUtils.HttpStatusException httpStatusException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = httpStatusException.getMessage();
            message.what = -9;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onUnknowException(Exception exception) {
            Message message = this.mHandler.obtainMessage();
            message.obj = exception.getMessage();
            message.what = -6;
            this.mHandler.sendMessage(message);
        }
    }

    public class ApiTask {
        public int mRequestCode;
        public IUiListener mListener;

        public ApiTask(int n, IUiListener iUiListener) {
            this.mRequestCode = n;
            this.mListener = iUiListener;
        }
    }
}

