/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.open.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.view.MotionEvent;
import com.tencent.a.a.c;
import com.tencent.open.utils.Util;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.List;

public class SystemUtils {
    public static final String QQ_VERSION_NAME_4_2_0 = "4.2.0";
    public static final String QQ_VERSION_NAME_4_3_0 = "4.3.0";
    public static final String QQ_VERSION_NAME_4_5_0 = "4.5.0";
    public static final String QQ_VERSION_NAME_4_6_0 = "4.6.0";
    public static final String QQ_VERSION_NAME_5_0_0 = "5.0.0";
    public static final String QQ_VERSION_NAME_5_1_0 = "5.1.0";
    public static final String QQ_VERSION_NAME_5_2_0 = "5.2.0";
    public static final String QQ_SHARE_CALLBACK_ACTION = "shareToQQ";
    public static final String QZONE_SHARE_CALLBACK_ACTION = "shareToQzone";
    public static final String QQFAVORITES_CALLBACK_ACTION = "addToQQFavorites";
    public static final String QQDATALINE_CALLBACK_ACTION = "sendToMyComputer";

    public static String getAppVersionName(Context context, String string) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static int compareVersion(String string, String string2) {
        if (string == null && string2 == null) {
            return 0;
        }
        if (string != null && string2 == null) {
            return 1;
        }
        if (string == null && string2 != null) {
            return -1;
        }
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        try {
            int n;
            for (n = 0; n < stringArray.length && n < stringArray2.length; ++n) {
                int n2;
                int n3 = Integer.parseInt(stringArray[n]);
                if (n3 < (n2 = Integer.parseInt(stringArray2[n]))) {
                    return -1;
                }
                if (n3 <= n2) continue;
                return 1;
            }
            if (stringArray.length > n) {
                return 1;
            }
            if (stringArray2.length > n) {
                return -1;
            }
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            return string.compareTo(string2);
        }
    }

    public static boolean isAppSignatureValid(Context context, String string, String string2) {
        PackageInfo packageInfo;
        c.a("openSDK_LOG", "OpenUi, validateAppSignatureForPackage");
        try {
            packageInfo = context.getPackageManager().getPackageInfo(string, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
        for (Signature signature : packageInfo.signatures) {
            String string3 = Util.encrypt(signature.toCharsString());
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static String getAppSignatureMD5(Context context, String string) {
        c.a("openSDK_LOG", "OpenUi, getSignValidString");
        String string2 = "";
        try {
            String string3 = context.getPackageName();
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string3, 64);
            Signature[] signatureArray = packageInfo.signatures;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(signatureArray[0].toByteArray());
            String string4 = Util.toHexString(messageDigest.digest());
            messageDigest.reset();
            Log.d((String)"SystemUtils", (String)("-->sign: " + string4));
            String string5 = string3 + "_" + string4 + "_" + string + "";
            messageDigest.update(Util.getBytesUTF8(string5));
            string2 = Util.toHexString(messageDigest.digest());
            messageDigest.reset();
            Log.d((String)"SystemUtils", (String)("-->signEncryped: " + string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            c.a("openSDK_LOG", "OpenUi, getSignValidString error", exception);
        }
        return string2;
    }

    public static boolean isActivityExist(Context context, Intent intent) {
        if (context == null || intent == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 0);
        return list.size() != 0;
    }

    public static String getRealPathFromUri(Activity activity, Uri uri) {
        String[] stringArray = new String[]{"_data"};
        Cursor cursor = activity.managedQuery(uri, stringArray, null, null, null);
        if (cursor != null) {
            int n = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(n);
        }
        return null;
    }

    public static String getAppName(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        return ((Object)applicationInfo.loadLabel(context.getPackageManager())).toString();
    }

    public static int compareQQVersion(Context context, String string) {
        String string2 = SystemUtils.getAppVersionName(context, "com.tencent.mobileqq");
        return SystemUtils.compareVersion(string2, string);
    }

    public static boolean checkMobileQQ(Context context) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo("com.tencent.mobileqq", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.d((String)"checkMobileQQ", (String)"error");
            nameNotFoundException.printStackTrace();
        }
        if (packageInfo != null) {
            String string = packageInfo.versionName;
            try {
                Log.d((String)"MobileQQ verson", (String)string);
                String[] stringArray = string.split("\\.");
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                return n > 4 || n == 4 && n2 >= 1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static int getAndroidSDKVersion() {
        int n = 0;
        try {
            n = Integer.valueOf(Build.VERSION.SDK);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static boolean isSupportMultiTouch() {
        Method[] methodArray;
        boolean bl = false;
        boolean bl2 = false;
        for (Method method : methodArray = MotionEvent.class.getDeclaredMethods()) {
            if (method.getName().equals("getPointerCount")) {
                bl = true;
            }
            if (!method.getName().equals("getPointerId")) continue;
            bl2 = true;
        }
        return SystemUtils.getAndroidSDKVersion() >= 7 || bl && bl2;
    }
}

