/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tauth;

import android.app.Activity;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.tencent.connect.auth.AuthMap;
import com.tencent.open.utils.TemporaryStorage;
import com.tencent.open.utils.Util;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.UiError;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthActivity
extends Activity {
    private static final String TAG = "AuthActivity";
    private static final String ACTION_KEY = "action";
    private static final String ACTION_SHARE_TO_QQ = "shareToQQ";
    private static final String ACTION_SHARE_TO_QZONE = "shareToQzone";
    private static final String ACTION_ADD_TO_QQFAVORITES = "addToQQFavorites";
    private static final String ACTION_SEND_TO_MY_COMPUTER = "sendToMyComputer";

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Uri uri = this.getIntent().getData();
        Log.d((String)TAG, (String)("-->onCreate, uri: " + uri));
        this.handleActionUri(uri);
    }

    private void handleActionUri(Uri uri) {
        if (null == uri || uri.toString().equals("")) {
            this.finish();
            return;
        }
        String string = uri.toString();
        String string2 = string.substring(string.indexOf("#") + 1);
        Bundle bundle = Util.decodeUrl(string2);
        String string3 = bundle.getString(ACTION_KEY);
        Log.d((String)TAG, (String)("-->handleActionUri, action: " + string3));
        if (null == string3) {
            this.execAuthCallback(bundle, string);
        } else if (string3.equals(ACTION_SHARE_TO_QQ) || string3.equals(ACTION_SHARE_TO_QZONE) || string3.equals(ACTION_ADD_TO_QQFAVORITES) || string3.equals(ACTION_SEND_TO_MY_COMPUTER)) {
            this.execShareToQQCallback(bundle);
        } else {
            this.execAuthCallback(bundle, string);
        }
    }

    private void execAuthCallback(Bundle bundle, String string) {
        String string2;
        AuthMap authMap = AuthMap.getInstance();
        AuthMap.Auth auth = authMap.get(string2 = bundle.getString("serial"));
        if (auth != null) {
            if (string.indexOf("://cancel") != -1) {
                auth.listener.onCancel();
                auth.dialog.dismiss();
            } else {
                String string3 = bundle.getString("access_token");
                if (null != string3) {
                    bundle.putString("access_token", authMap.decode(string3, auth.key));
                }
                String string4 = Util.encodeUrl(bundle);
                JSONObject jSONObject = new JSONObject();
                String string5 = (jSONObject = Util.decodeUrlToJson(jSONObject, string4)).optString("cb");
                if (!"".equals(string5)) {
                    auth.dialog.callJs(string5, jSONObject.toString());
                } else {
                    auth.listener.onComplete(jSONObject);
                    auth.dialog.dismiss();
                }
            }
            authMap.remove(string2);
        }
        this.finish();
    }

    private void execShareToQQCallback(Bundle bundle) {
        String string = bundle.getString(ACTION_KEY);
        Object object = TemporaryStorage.get(string);
        Log.d((String)TAG, (String)("-->execShareToQQCallback, object: " + object));
        if (null == object) {
            this.finish();
            return;
        }
        IUiListener iUiListener = (IUiListener)object;
        String string2 = bundle.getString("result");
        String string3 = bundle.getString("response");
        if (string2.equals("cancel")) {
            iUiListener.onCancel();
        } else if (string2.equals("error")) {
            iUiListener.onError(new UiError(-6, "unknown error", string3 + ""));
        } else if (string2.equals("complete")) {
            JSONObject jSONObject = null;
            if (null == string3) {
                string3 = "{\"ret\": 0}";
            }
            try {
                jSONObject = new JSONObject(string3);
                iUiListener.onComplete(jSONObject);
                Log.d((String)TAG, (String)("-->execShareToQQCallback, response: " + jSONObject));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                Log.e((String)TAG, (String)"-->execShareToQQCallback, JSONException e: ", (Throwable)jSONException);
                iUiListener.onError(new UiError(-4, "json error", string3 + ""));
            }
        }
        this.finish();
    }
}

