/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tauth;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import com.tencent.a.b.c;
import com.tencent.connect.auth.QQAuth;
import com.tencent.connect.auth.QQToken;
import com.tencent.connect.common.BaseApi;
import com.tencent.connect.share.QQShare;
import com.tencent.connect.share.QzoneShare;
import com.tencent.open.SocialApi;
import com.tencent.open.utils.HttpUtils;
import com.tencent.open.utils.SystemUtils;
import com.tencent.open.utils.TemporaryStorage;
import com.tencent.tauth.IRequestListener;
import com.tencent.tauth.IUiListener;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class Tencent {
    private final QQAuth mQQAuth;
    private static Tencent sInstance;

    private Tencent(String string, Context context) {
        c.a(context.getApplicationContext());
        this.mQQAuth = QQAuth.createInstance(string, context);
    }

    public static synchronized Tencent createInstance(String string, Context context) {
        if (sInstance == null) {
            sInstance = new Tencent(string, context);
        } else if (!string.equals(sInstance.getAppId())) {
            sInstance.logout(context);
            sInstance = new Tencent(string, context);
        }
        if (!Tencent.checkManifestConfig(context, string)) {
            return null;
        }
        com.tencent.a.a.c.a("openSDK_LOG", "createInstance()  --end");
        return sInstance;
    }

    private static boolean checkManifestConfig(Context context, String string) {
        Object object;
        ComponentName componentName;
        try {
            componentName = new ComponentName(context.getPackageName(), "com.tencent.tauth.AuthActivity");
            object = context.getPackageManager();
            object.getActivityInfo(componentName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = "\u6ca1\u6709\u5728AndroidManifest.xml\u4e2d\u68c0\u6d4b\u5230com.tencent.tauth.AuthActivity,\u8bf7\u52a0\u4e0acom.tencent.open.AuthActivity,\u5e76\u914d\u7f6e<data android:scheme=\"tencent" + string + "\" />,\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u5b98\u7f51\u6587\u6863.";
            string2 = string2 + "\n\u914d\u7f6e\u793a\u4f8b\u5982\u4e0b: \n<activity\n     android:name=\"com.tencent.connect.util.AuthActivity\"\n     android:noHistory=\"true\"\n     android:launchMode=\"singleTask\">\n<intent-filter>\n    <action android:name=\"android.intent.action.VIEW\" />\n     <category android:name=\"android.intent.category.DEFAULT\" />\n    <category android:name=\"android.intent.category.BROWSABLE\" />\n    <data android:scheme=\"tencent" + string + "\" />\n" + "</intent-filter>\n" + "</activity>";
            com.tencent.a.a.c.a();
            com.tencent.a.a.c.d("AndroidManifest.xml \u6ca1\u6709\u68c0\u6d4b\u5230com.tencent.tauth.AuthActivity", string2);
            return false;
        }
        try {
            componentName = new ComponentName(context.getPackageName(), "com.tencent.connect.common.AssistActivity");
            object = context.getPackageManager();
            object.getActivityInfo(componentName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = "\u6ca1\u6709\u5728AndroidManifest.xml\u4e2d\u68c0\u6d4b\u5230com.tencent.connect.common.AssistActivity,\u8bf7\u52a0\u4e0acom.tencent.connect.common.AssistActivity,\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u5b98\u7f51\u6587\u6863.";
            object = (String)object + "\n\u914d\u7f6e\u793a\u4f8b\u5982\u4e0b: \n<activity\n     android:name=\"com.tencent.connect.common.AssistActivity\"\n     android:screenOrientation=\"portrait\"\n     android:theme=\"@android:style/Theme.Translucent.NoTitleBar\"\n     android:configChanges=\"orientation|keyboardHidden\">\n</activity>";
            com.tencent.a.a.c.a();
            com.tencent.a.a.c.d("AndroidManifest.xml \u6ca1\u6709\u68c0\u6d4b\u5230com.tencent.connect.common.AssistActivity", (String)object);
            return false;
        }
        return true;
    }

    public int login(Activity activity, String string, IUiListener iUiListener) {
        return this.mQQAuth.login(activity, string, iUiListener);
    }

    public int login(Fragment fragment, String string, IUiListener iUiListener) {
        return this.mQQAuth.login(fragment, string, iUiListener, "");
    }

    public int loginWithOEM(Activity activity, String string, IUiListener iUiListener, String string2, String string3, String string4) {
        return this.mQQAuth.loginWithOEM(activity, string, iUiListener, string2, string3, string4);
    }

    public void logout(Context context) {
        this.mQQAuth.getQQToken().setAccessToken(null, "0");
        this.mQQAuth.getQQToken().setOpenId(null);
    }

    public int reAuth(Activity activity, String string, IUiListener iUiListener) {
        return this.mQQAuth.reAuth(activity, string, iUiListener);
    }

    public int invite(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.invite(activity, bundle, iUiListener);
        return 0;
    }

    public int story(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.story(activity, bundle, iUiListener);
        return 0;
    }

    public int gift(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.gift(activity, bundle, iUiListener);
        return 0;
    }

    public int ask(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.ask(activity, bundle, iUiListener);
        return 0;
    }

    public void requestAsync(String string, Bundle bundle, String string2, IRequestListener iRequestListener, Object object) {
        HttpUtils.requestAsync(this.mQQAuth.getQQToken(), c.a(), string, bundle, string2, iRequestListener);
    }

    public JSONObject request(String string, Bundle bundle, String string2) throws IOException, JSONException, HttpUtils.NetworkUnavailableException, HttpUtils.HttpStatusException {
        return HttpUtils.request(this.mQQAuth.getQQToken(), c.a(), string, bundle, string2);
    }

    public void shareToQQ(Activity activity, Bundle bundle, IUiListener iUiListener) {
        QQShare qQShare = new QQShare((Context)activity, this.mQQAuth.getQQToken());
        qQShare.shareToQQ(activity, bundle, iUiListener);
    }

    public void shareToQzone(Activity activity, Bundle bundle, IUiListener iUiListener) {
        QzoneShare qzoneShare = new QzoneShare((Context)activity, this.mQQAuth.getQQToken());
        qzoneShare.shareToQzone(activity, bundle, iUiListener);
    }

    public void releaseResource() {
        TemporaryStorage.remove("shareToQQ");
        TemporaryStorage.remove("shareToQzone");
        TemporaryStorage.remove("sendToMyComputer");
        TemporaryStorage.remove("addToQQFavorites");
    }

    public boolean onActivityResult(int n, int n2, Intent intent) {
        return false;
    }

    public boolean isSessionValid() {
        return this.mQQAuth.isSessionValid();
    }

    public String getAppId() {
        return this.mQQAuth.getQQToken().getAppId();
    }

    public String getAccessToken() {
        return this.mQQAuth.getQQToken().getAccessToken();
    }

    public long getExpiresIn() {
        return this.mQQAuth.getQQToken().getExpireTimeInSecond();
    }

    public String getOpenId() {
        return this.mQQAuth.getQQToken().getOpenId();
    }

    public void handleLoginData(Intent intent, IUiListener iUiListener) {
        BaseApi.handleDataToListener(intent, iUiListener);
    }

    public void setAccessToken(String string, String string2) {
        com.tencent.a.a.c.a("openSDK_LOG", "setAccessToken(), expiresIn = " + string2 + "");
        this.mQQAuth.setAccessToken(string, string2);
    }

    public void setOpenId(String string) {
        com.tencent.a.a.c.a("openSDK_LOG", "setOpenId() --start");
        this.mQQAuth.setOpenId(c.a(), string);
        com.tencent.a.a.c.a("openSDK_LOG", "setOpenId() --end");
    }

    public boolean isReady() {
        boolean bl = this.isSessionValid() && this.getOpenId() != null;
        return bl;
    }

    public QQToken getQQToken() {
        return this.mQQAuth.getQQToken();
    }

    public boolean isSupportSSOLogin(Activity activity) {
        String string = SystemUtils.getAppVersionName((Context)activity, "com.tencent.mobileqq");
        if (string == null) {
            return false;
        }
        return SystemUtils.checkMobileQQ((Context)activity);
    }
}

