/**
 * controller
 * @return 
 */
module.exports = Controller("Home/BaseController", function(){
  "use strict";
  return {
    __call: function(action){
        console.log(action);
    },
    _404Action:function(){
        this.display();
    },
    indexAction: function(){
      //render View/Home/index_index.html file
      this.display();
    },
    demoAction:function(){
        this.display();
    },
    listAction:function(){
        var ip = this.ip();
        var self = this;
        var page = parseInt(this.get('page')) || 1;
        this.assign('ip',ip);  
        this.assign('page',page);        
        var promise = D('Messages').field('id,content,uptime').order('id DESC').page(page, 2).countSelect(false).then(function(data){
            var num = data.count;
            self.assign("data", data.data);
            self.assign("num", num);

            //将模版渲染返回
            return self.display();
        });
        
    },
    contentAction:function(){
        var id = this.get('id');
        var self = this;
        this.assign('id',id);
        D('Messages').where({id:id}).field('id,content,uptime').find().then(function(data){

            self.assign("data", data);
            //将模版渲染返回
            return self.display();
        });

    },
    addAction:function(){
        if(!this.isPost()){
            this.display();
            return false;
        }
        var title = this.post('title');
        var isValid = this.valid(title, "required");

       var _this = this;
        D("Messages").add({
            content:title,
            uptime:(new Date()).getTime()
        }).then(function(insertId){
            var obj = {code:1,msg:'添加成功!'};
            _this.json( obj );
            //insertId为插入到数据库中的id
            console.log(insertId);
            return false;
        }).catch(function(err){
            var obj = {code:0,msg:'添加失败!'};
            _this.json( obj );
            //插入异常，比如：email已经存在
            console.log(err);
            return false;
        });
    },
    editAction:function(){

        if(this.isAjax()){
            var id = this.post('id');
            var _this = this;
            D('Messages').where({id: id}).update({
                content: this.post('title'),
                uptime:(new Date()).getTime()
            }).then(function(affectedRows){
                //affectedRows为影响的行数
                if(affectedRows >0){
                    _this.json( {code:1,msg:'编辑成功'} );
                }else{
                    _this.json( {code:0,msg:'编辑失败'} );
                }
            });
            return false;
        }

        var id = this.get('id');
        var self = this;
        D('Messages').where({id:id}).field('id,content,uptime').find().then(function(data){

            self.assign("data", data);
            console.log(data);
            //将模版渲染返回
            return self.display();
        });
        

    },
    delAction:function(){
        var id = this.get('id');
        var isValid = this.valid(id, "int");
        var _this = this;

        if(isValid){
            D('Messages').where({id: id}).delete().then(function(affectedRows){
                //affectedRows为影响的行数
                if(affectedRows >0){
                    _this.json( {code:1,msg:'删除成功'} );
                }else{
                    _this.json( {code:0,msg:'删除失败'} );
                }

            });

        }

    },
    testAction: function(){
        var _this = this;
        //设置session也是异步操作
        this.session("userInfo", {name: "welefen"}).then(function(data){
            _this.session('userInfo').then(function(data){
                console.log(data);
            });
        });
        this.end();
    }

     

  };
});