/*
 * Decompiled with CFR 0.152.
 */
package webim.client;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONException;
import org.json.JSONObject;
import webim.client.WebimCluster;
import webim.client.WebimException;
import webim.model.WebimEndpoint;
import webim.model.WebimMessage;
import webim.model.WebimPresence;
import webim.model.WebimStatus;

public class WebimClient {
    public static String APIVSN = "v5";
    private WebimEndpoint ep;
    private String domain;
    private String apikey;
    private WebimCluster cluster;
    private String ticket = null;

    public WebimClient(WebimEndpoint ep, String domain, String apikey, WebimCluster cluster) {
        this.ep = ep;
        this.domain = domain;
        this.apikey = apikey;
        this.cluster = cluster;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String getDomain() {
        return this.domain;
    }

    public WebimEndpoint getEndpoint() {
        return this.ep;
    }

    public WebimCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(WebimCluster cluster) {
        this.cluster = cluster;
    }

    public Map<String, Object> online(Set<String> buddies, Set<String> rooms) throws WebimException {
        Map<String, String> data = this.newData();
        data.put("rooms", this.join(",", rooms));
        data.put("buddies", this.join(",", buddies));
        data.put("name", this.ep.getId());
        data.put("nick", this.ep.getNick());
        data.put("status", this.ep.getStatus());
        data.put("show", this.ep.getShow());
        try {
            String body = this.httpost("/presences/online", data);
            JSONObject json = new JSONObject(body);
            this.setTicket(json.getString("ticket"));
            HashMap<String, String> conn = new HashMap<String, String>();
            conn.put("ticket", json.getString("ticket"));
            conn.put("domain", this.domain);
            conn.put("jsonpd", json.getString("jsonpd"));
            conn.put("server", json.getString("jsonpd"));
            if (json.has("websocket")) {
                conn.put("websocket", json.getString("websocket"));
            }
            if (json.has("mqtt")) {
                conn.put("mqtt", json.getString("mqtt"));
            }
            HashMap<String, Object> rtData = new HashMap<String, Object>();
            rtData.put("success", true);
            rtData.put("connection", conn);
            rtData.put("presences", this.json2Map(json.getJSONObject("presences")));
            return rtData;
        }
        catch (WebimException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebimException(500, e.getMessage());
        }
    }

    public JSONObject offline() throws WebimException {
        Map<String, String> data = this.newData();
        data.put("ticket", this.ticket);
        try {
            String body = this.httpost("/presences/offline", data);
            return new JSONObject(body);
        }
        catch (WebimException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebimException(500, e.getMessage());
        }
    }

    public JSONObject publish(WebimPresence presence) throws WebimException {
        Map<String, String> data = this.newData();
        data.put("nick", this.ep.getNick());
        presence.feed(data);
        try {
            String body = this.httpost("/presences/show", data);
            return new JSONObject(body);
        }
        catch (WebimException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebimException(500, e.getMessage());
        }
    }

    public JSONObject publish(WebimStatus status) throws WebimException {
        Map<String, String> data = this.newData();
        data.put("nick", this.ep.getNick());
        status.feed(data);
        try {
            String body = this.httpost("/statuses", data);
            return new JSONObject(body);
        }
        catch (WebimException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebimException(500, e.getMessage());
        }
    }

    public JSONObject publish(WebimMessage message) throws WebimException {
        Map<String, String> data = this.newData();
        message.feed(data);
        try {
            String body = this.httpost("/messages", data);
            return new JSONObject(body);
        }
        catch (WebimException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebimException(500, e.getMessage());
        }
    }

    public JSONObject push(String from, WebimMessage message) throws WebimException {
        Map<String, String> data = this.newData();
        data.put("from", from);
        message.feed(data);
        try {
            String body = this.httpost("/messages", data);
            return new JSONObject(body);
        }
        catch (WebimException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebimException(500, e.getMessage());
        }
    }

    public JSONObject presences(Set<String> ids) throws WebimException {
        Map<String, String> data = this.newData();
        data.put("ids", this.join(",", ids));
        try {
            String body = this.httpget("/presences", data);
            if (body.startsWith("[")) {
                return new JSONObject("{}");
            }
            return new JSONObject(body);
        }
        catch (WebimException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebimException(500, e.getMessage());
        }
    }

    public JSONObject members(String room) throws WebimException {
        Map<String, String> data = this.newData();
        data.put("room", room);
        try {
            String uri = String.format("/rooms/%s/members", room);
            String body = this.httpget(uri, data);
            if (body.startsWith("[")) {
                return new JSONObject("{}");
            }
            return new JSONObject(body);
        }
        catch (WebimException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebimException(500, e.getMessage());
        }
    }

    public JSONObject join(String room) throws WebimException {
        Map<String, String> data = this.newData();
        data.put("nick", this.ep.getNick());
        data.put("room", room);
        try {
            String uri = String.format("/rooms/%s/join", room);
            String body = this.httpost(uri, data);
            JSONObject respObj = new JSONObject(body);
            return respObj;
        }
        catch (WebimException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebimException(500, e.getMessage());
        }
    }

    public JSONObject leave(String room) throws WebimException {
        Map<String, String> data = this.newData();
        data.put("nick", this.ep.getNick());
        data.put("room", room);
        try {
            String uri = String.format("/rooms/%s/leave", room);
            String body = this.httpost(uri, data);
            return new JSONObject(body);
        }
        catch (WebimException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebimException(500, e.getMessage());
        }
    }

    private String httpget(String path, Map<String, String> params) throws Exception {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(String.valueOf(this.apiurl(path)) + "?" + this.encodeData(params));
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            this.initConn(conn);
            conn.connect();
            String string = this.readResonpse(conn);
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String httpost(String path, Map<String, String> data) throws Exception {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(this.apiurl(path));
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String urlParameters = this.encodeData(data);
            conn.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes().length));
            this.initConn(conn);
            DataOutputStream wr = null;
            try {
                wr = new DataOutputStream(conn.getOutputStream());
                wr.writeBytes(urlParameters);
                wr.flush();
            }
            finally {
                if (wr != null) {
                    wr.close();
                }
            }
            String string = this.readResonpse(conn);
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void initConn(HttpURLConnection conn) throws UnsupportedEncodingException {
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        String basicAuth = DatatypeConverter.printBase64Binary((byte[])(String.valueOf(this.domain) + ":" + this.apikey).getBytes("UTF-8"));
        conn.setRequestProperty("Authorization", "Basic " + basicAuth);
    }

    private String readResonpse(HttpURLConnection conn) throws IOException, WebimException {
        if (conn.getResponseCode() != 200) {
            throw new WebimException(conn.getResponseCode(), conn.getResponseMessage());
        }
        BufferedReader rd = null;
        StringBuffer response = new StringBuffer();
        try {
            String line;
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
        }
        finally {
            if (rd != null) {
                rd.close();
            }
        }
        return response.toString();
    }

    private Map<String, String> newData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("version", APIVSN);
        data.put("domain", this.domain);
        data.put("apikey", this.apikey);
        if (this.ticket != null) {
            data.put("ticket", this.ticket);
        }
        return data;
    }

    private String encodeData(Map<String, String> data) throws Exception {
        HashSet<String> list = new HashSet<String>();
        for (Map.Entry<String, String> pair : data.entrySet()) {
            list.add(String.valueOf(pair.getKey()) + "=" + URLEncoder.encode(pair.getValue(), "utf-8"));
        }
        return this.join("&", list);
    }

    private String join(String sep, Set<String> ss) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String s : ss) {
            if (first) {
                sb.append(s);
                first = false;
                continue;
            }
            sb.append(sep);
            sb.append(s);
        }
        return sb.toString();
    }

    private String apiurl(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return String.format("http://%s/%s%s", this.cluster.getServer(this.ep), APIVSN, path);
    }

    private Map<String, String> json2Map(JSONObject json) throws JSONException {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator it = json.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            map.put(key, json.getString(key));
        }
        return map;
    }
}

