/*
 * Decompiled with CFR 0.152.
 */
package webim.test;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import webim.client.WebimClient;
import webim.client.WebimCluster;
import webim.model.WebimEndpoint;
import webim.model.WebimMessage;
import webim.model.WebimPresence;
import webim.model.WebimStatus;
import webim.model.WebimUser;

public class WebimClientTest {
    private WebimClient client;
    private Set<String> buddyIds;
    private Set<String> roomIds;
    private WebimCluster cluster = new WebimCluster(){

        @Override
        public String getServer(WebimEndpoint ep) {
            return "t.nextalk.im:8000";
        }
    };

    @Before
    public void setUp() throws Exception {
        WebimUser ep = new WebimUser("uid1", "user1");
        this.client = new WebimClient(ep, "localhost", "public", this.cluster);
        this.buddyIds = new HashSet<String>();
        this.buddyIds.add("uid1");
        this.buddyIds.add("uid2");
        this.roomIds = new HashSet<String>();
        this.roomIds.add("room1");
        this.roomIds.add("room2");
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testOnline() throws Exception {
        Map<String, Object> rt = this.client.online(this.buddyIds, this.roomIds);
        System.out.println(rt);
    }

    @Test
    public void testOffline() throws Exception {
        Map<String, Object> rt = this.client.online(this.buddyIds, this.roomIds);
        System.out.println(rt);
        this.client.offline();
    }

    @Test
    public void testPublishWebimPresence() throws Exception {
        this.client.online(this.buddyIds, this.roomIds);
        this.client.publish(new WebimPresence("away", "Away"));
    }

    @Test
    public void testPublishWebimStatus() throws Exception {
        this.client.online(this.buddyIds, this.roomIds);
        this.client.publish(new WebimStatus("uid2", "typing", "User2 is typing"));
    }

    @Test
    public void testPublishWebimMessage() throws Exception {
        this.client.online(this.buddyIds, this.roomIds);
        this.client.publish(new WebimMessage("uid2", "User1", "hahaha", "", 1292832.183));
    }

    public void testPushMessage() throws Exception {
        this.client.push("uid3", new WebimMessage("uid2", "User3", "hahaha", "", 1292832.183));
    }

    @Test
    public void testPresences() throws Exception {
        this.client.online(this.buddyIds, this.roomIds);
        System.out.println(this.client.presences(this.buddyIds));
    }

    @Test
    public void testMembers() throws Exception {
        this.client.online(this.buddyIds, this.roomIds);
        JSONObject members = this.client.members("room1");
        System.out.println(members);
        members = this.client.members("room3");
        System.out.println(members);
    }

    @Test
    public void testJoin() throws Exception {
        this.client.online(this.buddyIds, this.roomIds);
        JSONObject rtObj = this.client.join("room1");
        System.out.print(rtObj);
    }

    @Test
    public void testLeave() throws Exception {
        this.client.online(this.buddyIds, this.roomIds);
    }
}

