/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.DateTimeFormatter;
import hirondelle.date4j.DateTimeInterval;
import hirondelle.date4j.DateTimeParser;
import hirondelle.date4j.ModelUtil;
import hirondelle.date4j.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateTime
implements Comparable<DateTime>,
Serializable {
    private String fDateTime;
    private Integer fYear;
    private Integer fMonth;
    private Integer fDay;
    private Integer fHour;
    private Integer fMinute;
    private Integer fSecond;
    private Integer fNanosecond;
    private boolean fIsAlreadyParsed;
    private int fHashCode;
    private static final int EQUAL = 0;
    private static int EPOCH_MODIFIED_JD = 2400000;
    private static final long serialVersionUID = -1300068157085493891L;

    public DateTime(String string) {
        this.fIsAlreadyParsed = false;
        if (string == null) {
            throw new IllegalArgumentException("String passed to DateTime constructor is null. You can use an empty string, but not a null reference.");
        }
        this.fDateTime = string;
    }

    public DateTime(Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7) {
        this.fIsAlreadyParsed = true;
        this.fYear = n;
        this.fMonth = n2;
        this.fDay = n3;
        this.fHour = n4;
        this.fMinute = n5;
        this.fSecond = n6;
        this.fNanosecond = n7;
        this.validateState();
    }

    public static DateTime forDateOnly(Integer n, Integer n2, Integer n3) {
        return new DateTime(n, n2, n3, null, null, null, null);
    }

    public static DateTime forTimeOnly(Integer n, Integer n2, Integer n3, Integer n4) {
        return new DateTime(null, null, null, n, n2, n3, n4);
    }

    public static DateTime forInstant(long l, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTimeInMillis(l);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        int n7 = gregorianCalendar.get(14);
        int n8 = n7 * 1000 * 1000;
        return new DateTime(n, n2, n3, n4, n5, n6, n8);
    }

    public long getMilliseconds(TimeZone timeZone) {
        Integer n = this.getYear();
        Integer n2 = this.getMonth();
        Integer n3 = this.getDay();
        Integer n4 = this.getHour() == null ? 0 : this.getHour();
        Integer n5 = this.getMinute() == null ? 0 : this.getMinute();
        Integer n6 = this.getSecond() == null ? 0 : this.getSecond();
        Integer n7 = this.getNanoseconds() == null ? 0 : this.getNanoseconds();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(2, n2 - 1);
        gregorianCalendar.set(5, n3);
        gregorianCalendar.set(11, n4);
        gregorianCalendar.set(12, n5);
        gregorianCalendar.set(13, n6);
        gregorianCalendar.set(14, n7 / 1000000);
        return gregorianCalendar.getTimeInMillis();
    }

    public String getRawDateString() {
        return this.fDateTime;
    }

    public Integer getYear() {
        this.ensureParsed();
        return this.fYear;
    }

    public Integer getMonth() {
        this.ensureParsed();
        return this.fMonth;
    }

    public Integer getDay() {
        this.ensureParsed();
        return this.fDay;
    }

    public Integer getHour() {
        this.ensureParsed();
        return this.fHour;
    }

    public Integer getMinute() {
        this.ensureParsed();
        return this.fMinute;
    }

    public Integer getSecond() {
        this.ensureParsed();
        return this.fSecond;
    }

    public Integer getNanoseconds() {
        this.ensureParsed();
        return this.fNanosecond;
    }

    public Integer getModifiedJulianDayNumber() {
        this.ensureHasYearMonthDay();
        int n = this.calculateJulianDayNumberAtNoon() - 1 - EPOCH_MODIFIED_JD;
        return n;
    }

    public Integer getWeekDay() {
        this.ensureHasYearMonthDay();
        int n = this.calculateJulianDayNumberAtNoon() + 1;
        int n2 = n % 7;
        return n2 + 1;
    }

    public Integer getDayOfYear() {
        this.ensureHasYearMonthDay();
        int n = this.isLeapYear() != false ? 1 : 2;
        Integer n2 = 275 * this.fMonth / 9 - n * ((this.fMonth + 9) / 12) + this.fDay - 30;
        return n2;
    }

    public Boolean isLeapYear() {
        this.ensureParsed();
        Boolean bl = null;
        if (!this.isPresent(this.fYear)) {
            throw new MissingItem("Year is absent. Cannot determine if leap year.");
        }
        bl = DateTime.isLeapYear(this.fYear);
        return bl;
    }

    public int getNumDaysInMonth() {
        this.ensureHasYearMonthDay();
        return DateTime.getNumDaysInMonth(this.fYear, this.fMonth);
    }

    public Integer getWeekIndex(DateTime dateTime) {
        this.ensureHasYearMonthDay();
        dateTime.ensureHasYearMonthDay();
        int n = this.getModifiedJulianDayNumber() - dateTime.getModifiedJulianDayNumber();
        return n / 7 + 1;
    }

    public Integer getWeekIndex() {
        DateTime dateTime = DateTime.forDateOnly(2000, 1, 2);
        return this.getWeekIndex(dateTime);
    }

    public boolean isSameDayAs(DateTime dateTime) {
        boolean bl = false;
        this.ensureHasYearMonthDay();
        dateTime.ensureHasYearMonthDay();
        bl = this.fYear.equals(dateTime.fYear) && this.fMonth.equals(dateTime.fMonth) && this.fDay.equals(dateTime.fDay);
        return bl;
    }

    public boolean lt(DateTime dateTime) {
        return this.compareTo(dateTime) < 0;
    }

    public boolean lteq(DateTime dateTime) {
        return this.compareTo(dateTime) < 0 || this.equals(dateTime);
    }

    public boolean gt(DateTime dateTime) {
        return this.compareTo(dateTime) > 0;
    }

    public boolean gteq(DateTime dateTime) {
        return this.compareTo(dateTime) > 0 || this.equals(dateTime);
    }

    public Unit getPrecision() {
        this.ensureParsed();
        Unit unit = null;
        if (this.isPresent(this.fNanosecond)) {
            unit = Unit.NANOSECONDS;
        } else if (this.isPresent(this.fSecond)) {
            unit = Unit.SECOND;
        } else if (this.isPresent(this.fMinute)) {
            unit = Unit.MINUTE;
        } else if (this.isPresent(this.fHour)) {
            unit = Unit.HOUR;
        } else if (this.isPresent(this.fDay)) {
            unit = Unit.DAY;
        } else if (this.isPresent(this.fMonth)) {
            unit = Unit.MONTH;
        } else if (this.isPresent(this.fYear)) {
            unit = Unit.YEAR;
        }
        return unit;
    }

    public DateTime truncate(Unit unit) {
        this.ensureParsed();
        DateTime dateTime = null;
        if (Unit.NANOSECONDS == unit) {
            throw new IllegalArgumentException("It makes no sense to truncate to nanosecond precision, since that's the highest precision available.");
        }
        if (Unit.SECOND == unit) {
            dateTime = new DateTime(this.fYear, this.fMonth, this.fDay, this.fHour, this.fMinute, this.fSecond, null);
        } else if (Unit.MINUTE == unit) {
            dateTime = new DateTime(this.fYear, this.fMonth, this.fDay, this.fHour, this.fMinute, null, null);
        } else if (Unit.HOUR == unit) {
            dateTime = new DateTime(this.fYear, this.fMonth, this.fDay, this.fHour, null, null, null);
        } else if (Unit.DAY == unit) {
            dateTime = new DateTime(this.fYear, this.fMonth, this.fDay, null, null, null, null);
        } else if (Unit.MONTH == unit) {
            dateTime = new DateTime(this.fYear, this.fMonth, null, null, null, null, null);
        } else if (Unit.YEAR == unit) {
            dateTime = new DateTime(this.fYear, null, null, null, null, null, null);
        }
        return dateTime;
    }

    public boolean unitsAllPresent(Unit ... unitArray) {
        boolean bl = true;
        this.ensureParsed();
        for (Unit unit : unitArray) {
            if (Unit.NANOSECONDS == unit) {
                bl = bl && this.fNanosecond != null;
                continue;
            }
            if (Unit.SECOND == unit) {
                bl = bl && this.fSecond != null;
                continue;
            }
            if (Unit.MINUTE == unit) {
                bl = bl && this.fMinute != null;
                continue;
            }
            if (Unit.HOUR == unit) {
                bl = bl && this.fHour != null;
                continue;
            }
            if (Unit.DAY == unit) {
                bl = bl && this.fDay != null;
                continue;
            }
            if (Unit.MONTH == unit) {
                bl = bl && this.fMonth != null;
                continue;
            }
            if (Unit.YEAR != unit) continue;
            bl = bl && this.fYear != null;
        }
        return bl;
    }

    public boolean hasYearMonthDay() {
        return this.unitsAllPresent(Unit.YEAR, Unit.MONTH, Unit.DAY);
    }

    public boolean hasHourMinuteSecond() {
        return this.unitsAllPresent(Unit.HOUR, Unit.MINUTE, Unit.SECOND);
    }

    public boolean unitsAllAbsent(Unit ... unitArray) {
        boolean bl = true;
        this.ensureParsed();
        for (Unit unit : unitArray) {
            if (Unit.NANOSECONDS == unit) {
                bl = bl && this.fNanosecond == null;
                continue;
            }
            if (Unit.SECOND == unit) {
                bl = bl && this.fSecond == null;
                continue;
            }
            if (Unit.MINUTE == unit) {
                bl = bl && this.fMinute == null;
                continue;
            }
            if (Unit.HOUR == unit) {
                bl = bl && this.fHour == null;
                continue;
            }
            if (Unit.DAY == unit) {
                bl = bl && this.fDay == null;
                continue;
            }
            if (Unit.MONTH == unit) {
                bl = bl && this.fMonth == null;
                continue;
            }
            if (Unit.YEAR != unit) continue;
            bl = bl && this.fYear == null;
        }
        return bl;
    }

    public DateTime getStartOfDay() {
        this.ensureHasYearMonthDay();
        return this.getStartEndDateTime(this.fDay, 0, 0, 0, 0);
    }

    public DateTime getEndOfDay() {
        this.ensureHasYearMonthDay();
        return this.getStartEndDateTime(this.fDay, 23, 59, 59, 999999999);
    }

    public DateTime getStartOfMonth() {
        this.ensureHasYearMonthDay();
        return this.getStartEndDateTime(1, 0, 0, 0, 0);
    }

    public DateTime getEndOfMonth() {
        this.ensureHasYearMonthDay();
        return this.getStartEndDateTime(this.getNumDaysInMonth(), 23, 59, 59, 999999999);
    }

    public DateTime plus(Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, DayOverflow dayOverflow) {
        DateTimeInterval dateTimeInterval = new DateTimeInterval(this, dayOverflow);
        return dateTimeInterval.plus(n, n2, n3, n4, n5, n6);
    }

    public DateTime minus(Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, DayOverflow dayOverflow) {
        DateTimeInterval dateTimeInterval = new DateTimeInterval(this, dayOverflow);
        return dateTimeInterval.minus(n, n2, n3, n4, n5, n6);
    }

    public DateTime plusDays(Integer n) {
        this.ensureHasYearMonthDay();
        int n2 = this.getModifiedJulianDayNumber() + 1 + EPOCH_MODIFIED_JD;
        int n3 = n2 + n;
        DateTime dateTime = DateTime.fromJulianDayNumberAtNoon(n3);
        return new DateTime(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), this.fHour, this.fMinute, this.fSecond, this.fNanosecond);
    }

    public DateTime minusDays(Integer n) {
        return this.plusDays(-1 * n);
    }

    public int numDaysFrom(DateTime dateTime) {
        return dateTime.getModifiedJulianDayNumber() - this.getModifiedJulianDayNumber();
    }

    public long numSecondsFrom(DateTime dateTime) {
        long l = 0L;
        if (this.hasYearMonthDay() && dateTime.hasYearMonthDay()) {
            l = this.numDaysFrom(dateTime) * 86400;
        }
        l = l - (long)this.numSecondsInTimePortion() + (long)dateTime.numSecondsInTimePortion();
        return l;
    }

    public static boolean isValidFormatString(String string) {
        boolean bl = false;
        DateTime dateTime = new DateTime(1972, 11, 11, 15, 30, 59, 999999999);
        try {
            String string2 = dateTime.format(string, Locale.ENGLISH);
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return bl;
    }

    public String format(String string) {
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatter(string);
        return dateTimeFormatter.format(this);
    }

    public String format(String string, Locale locale) {
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatter(string, locale);
        return dateTimeFormatter.format(this);
    }

    public String format(String string, List<String> list, List<String> list2, List<String> list3) {
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatter(string, list, list2, list3);
        return dateTimeFormatter.format(this);
    }

    public static DateTime now(TimeZone timeZone) {
        return DateTime.forInstant(System.currentTimeMillis(), timeZone);
    }

    public static DateTime today(TimeZone timeZone) {
        DateTime dateTime = DateTime.now(timeZone);
        return dateTime.truncate(Unit.DAY);
    }

    public boolean isInTheFuture(TimeZone timeZone) {
        return DateTime.now(timeZone).lt(this);
    }

    public boolean isInThePast(TimeZone timeZone) {
        return DateTime.now(timeZone).gt(this);
    }

    public DateTime changeTimeZone(TimeZone timeZone, TimeZone timeZone2) {
        DateTime dateTime = null;
        this.ensureHasYearMonthDay();
        if (this.unitsAllAbsent(Unit.HOUR)) {
            throw new IllegalArgumentException("DateTime does not include the hour. Cannot change the time zone if no hour is present.");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(1, this.getYear());
        gregorianCalendar.set(2, this.getMonth() - 1);
        gregorianCalendar.set(5, this.getDay());
        gregorianCalendar.set(11, this.getHour());
        if (this.getMinute() != null) {
            gregorianCalendar.set(12, this.getMinute());
        } else {
            gregorianCalendar.set(12, 0);
        }
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(timeZone2);
        gregorianCalendar2.setTimeInMillis(gregorianCalendar.getTimeInMillis());
        Integer n = this.getMinute() != null ? Integer.valueOf(gregorianCalendar2.get(12)) : null;
        dateTime = new DateTime(gregorianCalendar2.get(1), gregorianCalendar2.get(2) + 1, gregorianCalendar2.get(5), gregorianCalendar2.get(11), n, this.getSecond(), this.getNanoseconds());
        return dateTime;
    }

    @Override
    public int compareTo(DateTime dateTime) {
        if (this == dateTime) {
            return 0;
        }
        this.ensureParsed();
        dateTime.ensureParsed();
        ModelUtil.NullsGo nullsGo = ModelUtil.NullsGo.FIRST;
        int n = ModelUtil.comparePossiblyNull(this.fYear, dateTime.fYear, nullsGo);
        if (n != 0) {
            return n;
        }
        n = ModelUtil.comparePossiblyNull(this.fMonth, dateTime.fMonth, nullsGo);
        if (n != 0) {
            return n;
        }
        n = ModelUtil.comparePossiblyNull(this.fDay, dateTime.fDay, nullsGo);
        if (n != 0) {
            return n;
        }
        n = ModelUtil.comparePossiblyNull(this.fHour, dateTime.fHour, nullsGo);
        if (n != 0) {
            return n;
        }
        n = ModelUtil.comparePossiblyNull(this.fMinute, dateTime.fMinute, nullsGo);
        if (n != 0) {
            return n;
        }
        n = ModelUtil.comparePossiblyNull(this.fSecond, dateTime.fSecond, nullsGo);
        if (n != 0) {
            return n;
        }
        n = ModelUtil.comparePossiblyNull(this.fNanosecond, dateTime.fNanosecond, nullsGo);
        if (n != 0) {
            return n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        this.ensureParsed();
        Boolean bl = ModelUtil.quickEquals(this, object);
        if (bl == null) {
            DateTime dateTime = (DateTime)object;
            dateTime.ensureParsed();
            bl = ModelUtil.equalsFor(this.getSignificantFields(), dateTime.getSignificantFields());
        }
        return bl;
    }

    public int hashCode() {
        if (this.fHashCode == 0) {
            this.ensureParsed();
            this.fHashCode = ModelUtil.hashCodeFor(this.getSignificantFields());
        }
        return this.fHashCode;
    }

    public String toString() {
        String string = "";
        if (Util.textHasContent(this.fDateTime)) {
            string = this.fDateTime;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            this.addToString("Y", this.fYear, stringBuilder);
            this.addToString("M", this.fMonth, stringBuilder);
            this.addToString("D", this.fDay, stringBuilder);
            this.addToString("h", this.fHour, stringBuilder);
            this.addToString("m", this.fMinute, stringBuilder);
            this.addToString("s", this.fSecond, stringBuilder);
            this.addToString("f", this.fNanosecond, stringBuilder);
            string = stringBuilder.toString().trim();
        }
        return string;
    }

    void ensureParsed() {
        if (!this.fIsAlreadyParsed) {
            this.parseDateTimeText();
        }
    }

    static Integer getNumDaysInMonth(Integer n, Integer n2) {
        Integer n3 = null;
        if (n != null && n2 != null) {
            if (n2 == 1) {
                n3 = 31;
            } else if (n2 == 2) {
                n3 = DateTime.isLeapYear(n) ? 29 : 28;
            } else if (n2 == 3) {
                n3 = 31;
            } else if (n2 == 4) {
                n3 = 30;
            } else if (n2 == 5) {
                n3 = 31;
            } else if (n2 == 6) {
                n3 = 30;
            } else if (n2 == 7) {
                n3 = 31;
            } else if (n2 == 8) {
                n3 = 31;
            } else if (n2 == 9) {
                n3 = 30;
            } else if (n2 == 10) {
                n3 = 31;
            } else if (n2 == 11) {
                n3 = 30;
            } else if (n2 == 12) {
                n3 = 31;
            } else {
                throw new AssertionError((Object)("Month is out of range 1..12:" + n2));
            }
        }
        return n3;
    }

    static DateTime fromJulianDayNumberAtNoon(int n) {
        int n2 = n + 68569;
        int n3 = 4 * n2 / 146097;
        int n4 = 4000 * ((n2 -= (146097 * n3 + 3) / 4) + 1) / 1461001;
        n2 = n2 - 1461 * n4 / 4 + 31;
        int n5 = 80 * n2 / 2447;
        int n6 = n2 - 2447 * n5 / 80;
        n2 = n5 / 11;
        int n7 = n5 + 2 - 12 * n2;
        int n8 = 100 * (n3 - 49) + n4 + n2;
        return DateTime.forDateOnly(n8, n7, n6);
    }

    private int calculateJulianDayNumberAtNoon() {
        int n = this.fYear;
        int n2 = this.fMonth;
        int n3 = this.fDay;
        int n4 = 1461 * (n + 4800 + (n2 - 14) / 12) / 4 + 367 * (n2 - 2 - 12 * ((n2 - 14) / 12)) / 12 - 3 * ((n + 4900 + (n2 - 14) / 12) / 100) / 4 + n3 - 32075;
        return n4;
    }

    private void ensureHasYearMonthDay() {
        this.ensureParsed();
        if (!this.hasYearMonthDay()) {
            throw new MissingItem("DateTime does not include year/month/day.");
        }
    }

    private int numSecondsInTimePortion() {
        int n = 0;
        if (this.fSecond != null) {
            n += this.fSecond.intValue();
        }
        if (this.fMinute != null) {
            n += 60 * this.fMinute;
        }
        if (this.fHour != null) {
            n += 3600 * this.fHour;
        }
        return n;
    }

    private void validateState() {
        this.checkRange(this.fYear, 1, 9999, "Year");
        this.checkRange(this.fMonth, 1, 12, "Month");
        this.checkRange(this.fDay, 1, 31, "Day");
        this.checkRange(this.fHour, 0, 23, "Hour");
        this.checkRange(this.fMinute, 0, 59, "Minute");
        this.checkRange(this.fSecond, 0, 59, "Second");
        this.checkRange(this.fNanosecond, 0, 999999999, "Nanosecond");
        this.checkNumDaysInMonth(this.fYear, this.fMonth, this.fDay);
    }

    private void checkRange(Integer n, int n2, int n3, String string) {
        if (n != null && (n < n2 || n > n3)) {
            throw new ItemOutOfRange(string + " is not in the range " + n2 + ".." + n3 + ". Value is:" + n);
        }
    }

    private void checkNumDaysInMonth(Integer n, Integer n2, Integer n3) {
        if (this.hasYearMonthDay(n, n2, n3) && n3 > DateTime.getNumDaysInMonth(n, n2)) {
            throw new ItemOutOfRange("The day-of-the-month value '" + n3 + "' exceeds the number of days in the month: " + DateTime.getNumDaysInMonth(n, n2));
        }
    }

    private void parseDateTimeText() {
        DateTimeParser dateTimeParser = new DateTimeParser();
        DateTime dateTime = dateTimeParser.parse(this.fDateTime);
        this.fYear = dateTime.fYear;
        this.fMonth = dateTime.fMonth;
        this.fDay = dateTime.fDay;
        this.fHour = dateTime.fHour;
        this.fMinute = dateTime.fMinute;
        this.fSecond = dateTime.fSecond;
        this.fNanosecond = dateTime.fNanosecond;
        this.validateState();
    }

    private boolean hasYearMonthDay(Integer n, Integer n2, Integer n3) {
        return this.isPresent(n, n2, n3);
    }

    private static boolean isLeapYear(Integer n) {
        boolean bl = false;
        if (n % 100 == 0) {
            if (n % 400 == 0) {
                bl = true;
            }
        } else if (n % 4 == 0) {
            bl = true;
        }
        return bl;
    }

    private Object[] getSignificantFields() {
        return new Object[]{this.fYear, this.fMonth, this.fDay, this.fHour, this.fMinute, this.fSecond, this.fNanosecond};
    }

    private void addToString(String string, Object object, StringBuilder stringBuilder) {
        stringBuilder.append(string + ":" + String.valueOf(object) + " ");
    }

    private boolean isPresent(Object ... objectArray) {
        boolean bl = true;
        for (Object object : objectArray) {
            if (object != null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private DateTime getStartEndDateTime(Integer n, Integer n2, Integer n3, Integer n4, Integer n5) {
        this.ensureHasYearMonthDay();
        return new DateTime(this.fYear, this.fMonth, n, n2, n3, n4, n5);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.validateState();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    static final class MissingItem
    extends RuntimeException {
        private static final long serialVersionUID = -7359967338896127755L;

        MissingItem(String string) {
            super(string);
        }
    }

    static final class ItemOutOfRange
    extends RuntimeException {
        private static final long serialVersionUID = 4760138291907517660L;

        ItemOutOfRange(String string) {
            super(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DayOverflow {
        LastDay,
        FirstDay,
        Spillover,
        Abort;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Unit {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        NANOSECONDS;

    }
}

