/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.DateTime;

final class DateTimeInterval {
    private final DateTime fFrom;
    private boolean fIsPlus;
    private DateTime.DayOverflow fDayOverflow;
    private int fYearIncr;
    private int fMonthIncr;
    private int fDayIncr;
    private int fHourIncr;
    private int fMinuteIncr;
    private int fSecondIncr;
    private Integer fYear;
    private Integer fMonth;
    private Integer fDay;
    private Integer fHour;
    private Integer fMinute;
    private Integer fSecond;
    private static final int MIN = 0;
    private static final int MAX = 9999;
    private static final boolean PLUS = true;
    private static final boolean MINUS = false;

    DateTimeInterval(DateTime dateTime, DateTime.DayOverflow dayOverflow) {
        this.fFrom = dateTime;
        this.checkUnits();
        this.fYear = this.fFrom.getYear() == null ? 1 : this.fFrom.getYear();
        this.fMonth = this.fFrom.getMonth() == null ? 1 : this.fFrom.getMonth();
        this.fDay = this.fFrom.getDay() == null ? 1 : this.fFrom.getDay();
        this.fHour = this.fFrom.getHour() == null ? 0 : this.fFrom.getHour();
        this.fMinute = this.fFrom.getMinute() == null ? 0 : this.fFrom.getMinute();
        this.fSecond = this.fFrom.getSecond() == null ? 0 : this.fFrom.getSecond();
        this.fDayOverflow = dayOverflow;
    }

    DateTime plus(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.plusOrMinus(true, n, n2, n3, n4, n5, n6);
    }

    DateTime minus(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.plusOrMinus(false, n, n2, n3, n4, n5, n6);
    }

    private void checkUnits() {
        boolean bl = false;
        bl = this.fFrom.unitsAllPresent(DateTime.Unit.YEAR, DateTime.Unit.MONTH, DateTime.Unit.DAY, DateTime.Unit.HOUR, DateTime.Unit.MINUTE, DateTime.Unit.SECOND) ? true : (this.fFrom.unitsAllPresent(DateTime.Unit.YEAR, DateTime.Unit.MONTH, DateTime.Unit.DAY) && this.fFrom.unitsAllAbsent(DateTime.Unit.HOUR, DateTime.Unit.MINUTE, DateTime.Unit.SECOND) ? true : this.fFrom.unitsAllAbsent(DateTime.Unit.YEAR, DateTime.Unit.MONTH, DateTime.Unit.DAY) && this.fFrom.unitsAllPresent(DateTime.Unit.HOUR, DateTime.Unit.MINUTE, DateTime.Unit.SECOND));
        if (!bl) {
            throw new IllegalArgumentException("For interval calculations, DateTime must have year-month-day, or hour-minute-second, or both.");
        }
    }

    private DateTime plusOrMinus(boolean bl, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6) {
        this.fIsPlus = bl;
        this.fYearIncr = n;
        this.fMonthIncr = n2;
        this.fDayIncr = n3;
        this.fHourIncr = n4;
        this.fMinuteIncr = n5;
        this.fSecondIncr = n6;
        this.checkRange(this.fYearIncr, "Year");
        this.checkRange(this.fMonthIncr, "Month");
        this.checkRange(this.fDayIncr, "Day");
        this.checkRange(this.fHourIncr, "Hour");
        this.checkRange(this.fMinuteIncr, "Minute");
        this.checkRange(this.fSecondIncr, "Second");
        this.changeYear();
        this.changeMonth();
        this.handleMonthOverflow();
        this.changeDay();
        this.changeHour();
        this.changeMinute();
        this.changeSecond();
        return new DateTime(this.fYear, this.fMonth, this.fDay, this.fHour, this.fMinute, this.fSecond, this.fFrom.getNanoseconds());
    }

    private void checkRange(Integer n, String string) {
        if (n < 0 || n > 9999) {
            throw new IllegalArgumentException(string + " is not in the range " + 0 + ".." + 9999);
        }
    }

    private void changeYear() {
        this.fYear = this.fIsPlus ? Integer.valueOf(this.fYear + this.fYearIncr) : Integer.valueOf(this.fFrom.getYear() - this.fYearIncr);
    }

    private void changeMonth() {
        for (int i = 0; i < this.fMonthIncr; ++i) {
            this.stepMonth();
        }
    }

    private void changeDay() {
        for (int i = 0; i < this.fDayIncr; ++i) {
            this.stepDay();
        }
    }

    private void changeHour() {
        for (int i = 0; i < this.fHourIncr; ++i) {
            this.stepHour();
        }
    }

    private void changeMinute() {
        for (int i = 0; i < this.fMinuteIncr; ++i) {
            this.stepMinute();
        }
    }

    private void changeSecond() {
        for (int i = 0; i < this.fSecondIncr; ++i) {
            this.fSecond = this.fIsPlus ? Integer.valueOf(this.fSecond + 1) : Integer.valueOf(this.fSecond - 1);
            if (this.fSecond > 59) {
                this.fSecond = 0;
                this.stepMinute();
                continue;
            }
            if (this.fSecond >= 0) continue;
            this.fSecond = 59;
            this.stepMinute();
        }
    }

    private void stepYear() {
        this.fYear = this.fIsPlus ? Integer.valueOf(this.fYear + 1) : Integer.valueOf(this.fYear - 1);
    }

    private void stepMonth() {
        this.fMonth = this.fIsPlus ? Integer.valueOf(this.fMonth + 1) : Integer.valueOf(this.fMonth - 1);
        if (this.fMonth > 12) {
            this.fMonth = 1;
            this.stepYear();
        } else if (this.fMonth < 1) {
            this.fMonth = 12;
            this.stepYear();
        }
    }

    private void stepDay() {
        this.fDay = this.fIsPlus ? Integer.valueOf(this.fDay + 1) : Integer.valueOf(this.fDay - 1);
        if (this.fDay > this.numDaysInMonth()) {
            this.fDay = 1;
            this.stepMonth();
        } else if (this.fDay < 1) {
            this.fDay = this.numDaysInPreviousMonth();
            this.stepMonth();
        }
    }

    private int numDaysInMonth() {
        return DateTime.getNumDaysInMonth(this.fYear, this.fMonth);
    }

    private int numDaysInPreviousMonth() {
        int n = 0;
        n = this.fMonth > 1 ? DateTime.getNumDaysInMonth(this.fYear, this.fMonth - 1).intValue() : DateTime.getNumDaysInMonth(this.fYear - 1, 12).intValue();
        return n;
    }

    private void stepHour() {
        this.fHour = this.fIsPlus ? Integer.valueOf(this.fHour + 1) : Integer.valueOf(this.fHour - 1);
        if (this.fHour > 23) {
            this.fHour = 0;
            this.stepDay();
        } else if (this.fHour < 0) {
            this.fHour = 23;
            this.stepDay();
        }
    }

    private void stepMinute() {
        this.fMinute = this.fIsPlus ? Integer.valueOf(this.fMinute + 1) : Integer.valueOf(this.fMinute - 1);
        if (this.fMinute > 59) {
            this.fMinute = 0;
            this.stepHour();
        } else if (this.fMinute < 0) {
            this.fMinute = 59;
            this.stepHour();
        }
    }

    private void handleMonthOverflow() {
        int n = this.numDaysInMonth();
        if (this.fDay > n) {
            if (DateTime.DayOverflow.Abort == this.fDayOverflow) {
                throw new RuntimeException("Day Overflow: Year:" + this.fYear + " Month:" + this.fMonth + " has " + n + " days, but day has value:" + this.fDay + " To avoid these exceptions, please specify a different DayOverflow policy.");
            }
            if (DateTime.DayOverflow.FirstDay == this.fDayOverflow) {
                this.fDay = 1;
                this.stepMonth();
            } else if (DateTime.DayOverflow.LastDay == this.fDayOverflow) {
                this.fDay = n;
            } else if (DateTime.DayOverflow.Spillover == this.fDayOverflow) {
                int n2 = this.fDay - n;
                this.fDay = n2;
                this.stepMonth();
            }
        }
    }
}

