/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.DateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DateTimeParser {
    private static final Pattern DATE = Pattern.compile("(\\d{1,4})-(\\d\\d)-(\\d\\d)|(\\d{1,4})-(\\d\\d)|(\\d{1,4})");
    private static final String CL = "\\:";
    private static final String TT = "(\\d\\d)";
    private static final String NUM_DIGITS_FOR_FRACTIONAL_SECONDS = "9";
    private static final Integer NUM_DIGITS = Integer.valueOf("9");
    private static final Pattern TIME = Pattern.compile("(\\d\\d)\\:(\\d\\d)\\:(\\d\\d)\\.(\\d{1,9})|(\\d\\d)\\:(\\d\\d)\\:(\\d\\d)|(\\d\\d)\\:(\\d\\d)|(\\d\\d)");
    private static final String COLON = ":";
    private static final int THIRD_POSITION = 2;
    private Integer fYear;
    private Integer fMonth;
    private Integer fDay;
    private Integer fHour;
    private Integer fMinute;
    private Integer fSecond;
    private Integer fNanosecond;

    DateTimeParser() {
    }

    DateTime parse(String string) {
        if (string == null) {
            throw new NullPointerException("DateTime string is null");
        }
        String string2 = string.trim();
        Parts parts = this.splitIntoDateAndTime(string2);
        if (parts.hasTwoParts()) {
            this.parseDate(parts.datePart);
            this.parseTime(parts.timePart);
        } else if (parts.hasDateOnly()) {
            this.parseDate(parts.datePart);
        } else if (parts.hasTimeOnly()) {
            this.parseTime(parts.timePart);
        }
        DateTime dateTime = new DateTime(this.fYear, this.fMonth, this.fDay, this.fHour, this.fMinute, this.fSecond, this.fNanosecond);
        return dateTime;
    }

    private Parts splitIntoDateAndTime(String string) {
        boolean bl;
        String string2 = " ";
        Parts parts = new Parts();
        int n = string.indexOf(string2);
        boolean bl2 = bl = 0 < n && n < string.length();
        if (bl) {
            parts.datePart = string.substring(0, n);
            parts.timePart = string.substring(n + 1);
        } else if (this.hasColonInThirdPlace(string)) {
            parts.timePart = string;
        } else {
            parts.datePart = string;
        }
        return parts;
    }

    private boolean hasColonInThirdPlace(String string) {
        boolean bl = false;
        if (string.length() >= 2) {
            bl = COLON.equals(string.substring(2, 3));
        }
        return bl;
    }

    private void parseDate(String string) {
        Matcher matcher = DATE.matcher(string);
        if (matcher.matches()) {
            String string2;
            String string3;
            String string4 = this.getGroup(matcher, 1, 4, 6);
            if (string4 != null) {
                this.fYear = Integer.valueOf(string4);
            }
            if ((string3 = this.getGroup(matcher, 2, 5)) != null) {
                this.fMonth = Integer.valueOf(string3);
            }
            if ((string2 = this.getGroup(matcher, 3)) != null) {
                this.fDay = Integer.valueOf(string2);
            }
        } else {
            throw new UnknownDateTimeFormat("Unexpected format for date:" + string);
        }
    }

    private String getGroup(Matcher matcher, int ... nArray) {
        int n;
        String string = null;
        int[] nArray2 = nArray;
        int n2 = nArray2.length;
        for (int i = 0; i < n2 && (string = matcher.group(n = nArray2[i])) == null; ++i) {
        }
        return string;
    }

    private void parseTime(String string) {
        Matcher matcher = TIME.matcher(string);
        if (matcher.matches()) {
            String string2;
            String string3;
            String string4;
            String string5 = this.getGroup(matcher, 1, 5, 8, 10);
            if (string5 != null) {
                this.fHour = Integer.valueOf(string5);
            }
            if ((string4 = this.getGroup(matcher, 2, 6, 9)) != null) {
                this.fMinute = Integer.valueOf(string4);
            }
            if ((string3 = this.getGroup(matcher, 3, 7)) != null) {
                this.fSecond = Integer.valueOf(string3);
            }
            if ((string2 = this.getGroup(matcher, 4)) != null) {
                this.fNanosecond = Integer.valueOf(this.convertToNanoseconds(string2));
            }
        } else {
            throw new UnknownDateTimeFormat("Unexpected format for time:" + string);
        }
    }

    private String convertToNanoseconds(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() < NUM_DIGITS) {
            stringBuilder.append("0");
        }
        return stringBuilder.toString();
    }

    private class Parts {
        String datePart;
        String timePart;

        private Parts() {
        }

        boolean hasTwoParts() {
            return this.datePart != null && this.timePart != null;
        }

        boolean hasDateOnly() {
            return this.timePart == null;
        }

        boolean hasTimeOnly() {
            return this.datePart == null;
        }
    }

    static final class UnknownDateTimeFormat
    extends RuntimeException {
        private static final long serialVersionUID = -7179421566055773208L;

        UnknownDateTimeFormat(String string) {
            super(string);
        }

        UnknownDateTimeFormat(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

