/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.ToStringUtil;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ModelUtil {
    static final int HASH_SEED = 23;
    private static final int fODD_PRIME_NUMBER = 37;

    static String toStringFor(Object object) {
        return ToStringUtil.getText(object);
    }

    static String toStringAvoidCyclicRefs(Object object, Class clazz, String string) {
        return ToStringUtil.getTextAvoidCyclicRefs(object, clazz, string);
    }

    static final int hashCodeFor(Object ... objectArray) {
        int n = 23;
        for (Object object : objectArray) {
            n = ModelUtil.hash(n, object);
        }
        return n;
    }

    static int hash(int n, boolean bl) {
        return ModelUtil.firstTerm(n) + (bl ? 1 : 0);
    }

    static int hash(int n, char c) {
        return ModelUtil.firstTerm(n) + c;
    }

    static int hash(int n, int n2) {
        return ModelUtil.firstTerm(n) + n2;
    }

    static int hash(int n, long l) {
        return ModelUtil.firstTerm(n) + (int)(l ^ l >>> 32);
    }

    static int hash(int n, float f) {
        return ModelUtil.hash(n, Float.floatToIntBits(f));
    }

    static int hash(int n, double d) {
        return ModelUtil.hash(n, Double.doubleToLongBits(d));
    }

    static int hash(int n, Object object) {
        int n2 = n;
        if (object == null) {
            n2 = ModelUtil.hash(n2, 0);
        } else if (!ModelUtil.isArray(object)) {
            n2 = ModelUtil.hash(n2, object.hashCode());
        } else {
            int n3 = Array.getLength(object);
            for (int i = 0; i < n3; ++i) {
                Object object2 = Array.get(object, i);
                n2 = ModelUtil.hash(n2, object2);
            }
        }
        return n2;
    }

    static Boolean quickEquals(Object object, Object object2) {
        Boolean bl = null;
        if (object == object2) {
            bl = Boolean.TRUE;
        } else {
            Class<?> clazz = object.getClass();
            if (!clazz.isInstance(object2)) {
                bl = Boolean.FALSE;
            }
        }
        return bl;
    }

    static boolean equalsFor(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            throw new IllegalArgumentException("Array lengths do not match. 'This' length is " + objectArray.length + ", while 'That' length is " + objectArray2.length + ".");
        }
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            if (ModelUtil.areEqual(objectArray[i], objectArray2[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    static boolean areEqual(boolean bl, boolean bl2) {
        return bl == bl2;
    }

    static boolean areEqual(char c, char c2) {
        return c == c2;
    }

    static boolean areEqual(long l, long l2) {
        return l == l2;
    }

    static boolean areEqual(float f, float f2) {
        return Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    static boolean areEqual(double d, double d2) {
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    static boolean areEqual(Object object, Object object2) {
        if (ModelUtil.isArray(object) || ModelUtil.isArray(object2)) {
            throw new IllegalArgumentException("This method does not currently support arrays.");
        }
        return object == null ? object2 == null : object.equals(object2);
    }

    static <T extends Comparable<T>> int comparePossiblyNull(T t, T t2, NullsGo nullsGo) {
        int n = 0;
        int n2 = -1;
        int n3 = 1;
        int n4 = n;
        if (t != null && t2 != null) {
            n4 = t.compareTo(t2);
        } else {
            if (t != null || t2 != null) {
                if (t == null && t2 != null) {
                    n4 = n2;
                } else if (t != null && t2 == null) {
                    n4 = n3;
                }
            }
            if (NullsGo.LAST == nullsGo) {
                n4 = -1 * n4;
            }
        }
        return n4;
    }

    private ModelUtil() {
    }

    private static int firstTerm(int n) {
        return 37 * n;
    }

    private static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NullsGo {
        FIRST,
        LAST;

    }
}

