/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ToStringUtil {
    private static final String fGET_CLASS = "getClass";
    private static final String fCLONE = "clone";
    private static final String fHASH_CODE = "hashCode";
    private static final String fTO_STRING = "toString";
    private static final String fGET = "get";
    private static final Object[] fNO_ARGS = new Object[0];
    private static final Class[] fNO_PARAMS = new Class[0];
    private static final String fINDENT = "";
    private static final String fAVOID_CIRCULAR_REFERENCES = "[circular reference]";
    private static final Logger fLogger = Util.getLogger(ToStringUtil.class);
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static Pattern PASSWORD_PATTERN = Pattern.compile("password", 2);
    private static String HIDDEN_PASSWORD_VALUE = "****";

    static String getText(Object object) {
        return ToStringUtil.getTextAvoidCyclicRefs(object, null, null);
    }

    static String getTextAvoidCyclicRefs(Object object, Class clazz, String string) {
        Method[] methodArray;
        StringBuilder stringBuilder = new StringBuilder();
        ToStringUtil.addStartLine(object, stringBuilder);
        for (Method method : methodArray = object.getClass().getDeclaredMethods()) {
            if (!ToStringUtil.isContributingMethod(method, object.getClass())) continue;
            ToStringUtil.addLineForGetXXXMethod(object, method, stringBuilder, clazz, string);
        }
        ToStringUtil.addEndLine(stringBuilder);
        return stringBuilder.toString();
    }

    private ToStringUtil() {
    }

    private static void addStartLine(Object object, StringBuilder stringBuilder) {
        stringBuilder.append(object.getClass().getName());
        stringBuilder.append(" {");
        stringBuilder.append(NEW_LINE);
    }

    private static void addEndLine(StringBuilder stringBuilder) {
        stringBuilder.append("}");
        stringBuilder.append(NEW_LINE);
    }

    private static boolean isContributingMethod(Method method, Class clazz) {
        boolean bl = Modifier.isPublic(method.getModifiers());
        boolean bl2 = method.getParameterTypes().length == 0;
        boolean bl3 = method.getReturnType() != Void.TYPE;
        boolean bl4 = method.getReturnType() == clazz;
        boolean bl5 = method.getName().equals(fCLONE) || method.getName().equals(fGET_CLASS) || method.getName().equals(fHASH_CODE) || method.getName().equals(fTO_STRING);
        return bl && bl2 && bl3 && !bl5 && !bl4;
    }

    private static void addLineForGetXXXMethod(Object object, Method method, StringBuilder stringBuilder, Class clazz, String string) {
        stringBuilder.append(fINDENT);
        stringBuilder.append(ToStringUtil.getMethodNameMinusGet(method));
        stringBuilder.append(": ");
        Object object2 = ToStringUtil.getMethodReturnValue(object, method);
        if (object2 != null && object2.getClass().isArray()) {
            stringBuilder.append(Util.getArrayAsString(object2));
        } else if (clazz == null) {
            stringBuilder.append(object2);
        } else if (clazz == object2.getClass()) {
            Method method2 = ToStringUtil.getMethodFromName(clazz, string);
            if (ToStringUtil.isContributingMethod(method2, clazz)) {
                object2 = ToStringUtil.getMethodReturnValue(object2, method2);
                stringBuilder.append(object2);
            } else {
                stringBuilder.append(fAVOID_CIRCULAR_REFERENCES);
            }
        }
        stringBuilder.append(NEW_LINE);
    }

    private static String getMethodNameMinusGet(Method method) {
        String string = method.getName();
        if (string.startsWith(fGET)) {
            string = string.substring(fGET.length());
        }
        return string;
    }

    private static Object getMethodReturnValue(Object object, Method method) {
        Object object2 = null;
        try {
            object2 = method.invoke(object, fNO_ARGS);
        }
        catch (IllegalAccessException illegalAccessException) {
            ToStringUtil.vomit(object, method);
        }
        catch (InvocationTargetException invocationTargetException) {
            ToStringUtil.vomit(object, method);
        }
        object2 = ToStringUtil.dontShowPasswords(object2, method);
        return object2;
    }

    private static Method getMethodFromName(Class clazz, String string) {
        Method method = null;
        try {
            method = clazz.getMethod(string, fNO_PARAMS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ToStringUtil.vomit(clazz, string);
        }
        return method;
    }

    private static void vomit(Object object, Method method) {
        fLogger.severe("Cannot get return value using reflection. Class: " + object.getClass().getName() + " Method: " + method.getName());
    }

    private static void vomit(Class clazz, String string) {
        fLogger.severe("Reflection fails to get no-arg method named: " + Util.quote(string) + " for class: " + clazz.getName());
    }

    private static Object dontShowPasswords(Object object, Method method) {
        Object object2 = object;
        Matcher matcher = PASSWORD_PATTERN.matcher(method.getName());
        if (matcher.find()) {
            object2 = HIDDEN_PASSWORD_VALUE;
        }
        return object2;
    }

    public static void main(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("blah");
        arrayList.add("blah");
        arrayList.add("blah");
        System.out.println(ToStringUtil.getText(arrayList));
        StringTokenizer stringTokenizer = new StringTokenizer("This is the end.");
        System.out.println(ToStringUtil.getText(stringTokenizer));
        Ping ping = new Ping();
        Pong pong = new Pong();
        ping.setPong(pong);
        pong.setPing(ping);
        System.out.println(ping);
        System.out.println(pong);
    }

    private static final class Pong {
        private Ping fPing;

        private Pong() {
        }

        public void setPing(Ping ping) {
            this.fPing = ping;
        }

        public Ping getPing() {
            return this.fPing;
        }

        public String toString() {
            return ToStringUtil.getTextAvoidCyclicRefs(this, Ping.class, "getId");
        }
    }

    private static final class Ping {
        private Pong fPong;

        private Ping() {
        }

        public void setPong(Pong pong) {
            this.fPong = pong;
        }

        public Pong getPong() {
            return this.fPong;
        }

        public Integer getId() {
            return new Integer(123);
        }

        public String getUserPassword() {
            return "blah";
        }

        public String toString() {
            return ToStringUtil.getText(this);
        }
    }
}

