/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.TerracottaStore;
import net.sf.ehcache.terracotta.TerracottaNotRunningException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransactionStore
extends AbstractStore
implements TerracottaStore {
    protected final Store underlyingStore;

    protected AbstractTransactionStore(Store underlyingStore) {
        this.underlyingStore = underlyingStore;
    }

    @Override
    public int getInMemorySize() {
        return this.underlyingStore.getInMemorySize();
    }

    @Override
    public int getOffHeapSize() {
        return this.underlyingStore.getOffHeapSize();
    }

    @Override
    public int getOnDiskSize() {
        return this.underlyingStore.getOnDiskSize();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.underlyingStore.getInMemorySizeInBytes();
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return this.underlyingStore.getOffHeapSizeInBytes();
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return this.underlyingStore.getOnDiskSizeInBytes();
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return this.underlyingStore.containsKeyOnDisk(key);
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return this.underlyingStore.containsKeyOffHeap(key);
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        return this.underlyingStore.containsKeyInMemory(key);
    }

    @Override
    public void dispose() {
        this.underlyingStore.dispose();
    }

    @Override
    public Status getStatus() {
        return this.underlyingStore.getStatus();
    }

    @Override
    public void expireElements() {
        this.underlyingStore.expireElements();
    }

    @Override
    public void flush() throws IOException {
        this.underlyingStore.flush();
    }

    @Override
    public boolean bufferFull() {
        return this.underlyingStore.bufferFull();
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return this.underlyingStore.getInMemoryEvictionPolicy();
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
        this.underlyingStore.setInMemoryEvictionPolicy(policy);
    }

    @Override
    public Object getInternalContext() {
        return this.underlyingStore.getInternalContext();
    }

    @Override
    public Object getMBean() {
        return this.underlyingStore.getMBean();
    }

    @Override
    public void setNodeCoherent(boolean coherent) {
        if (!coherent) {
            throw new InvalidConfigurationException("a transactional cache cannot be incoherent");
        }
        this.underlyingStore.setNodeCoherent(coherent);
    }

    @Override
    public boolean isNodeCoherent() {
        return this.underlyingStore.isNodeCoherent();
    }

    @Override
    public boolean isCacheCoherent() {
        return this.underlyingStore.isCacheCoherent();
    }

    @Override
    public boolean isClusterCoherent() {
        return this.underlyingStore.isClusterCoherent();
    }

    @Override
    public void waitUntilClusterCoherent() throws TerracottaNotRunningException, UnsupportedOperationException, InterruptedException {
        this.underlyingStore.waitUntilClusterCoherent();
    }

    @Override
    public void setAttributeExtractors(Map<String, AttributeExtractor> extractors) {
        this.underlyingStore.setAttributeExtractors(extractors);
    }

    @Override
    public Results executeQuery(StoreQuery query) {
        return this.underlyingStore.executeQuery(query);
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) throws CacheException {
        return this.underlyingStore.getSearchAttribute(attributeName);
    }

    @Override
    public Element unsafeGet(Object key) {
        if (this.underlyingStore instanceof TerracottaStore) {
            return ((TerracottaStore)this.underlyingStore).unsafeGet(key);
        }
        throw new CacheException("underlying store is not an instance of TerracottaStore");
    }

    @Override
    public Element unsafeGetQuiet(Object key) {
        if (this.underlyingStore instanceof TerracottaStore) {
            return ((TerracottaStore)this.underlyingStore).unsafeGetQuiet(key);
        }
        throw new CacheException("underlying store is not an instance of TerracottaStore");
    }

    @Override
    public Element unlockedGet(Object key) {
        if (this.underlyingStore instanceof TerracottaStore) {
            return ((TerracottaStore)this.underlyingStore).unlockedGet(key);
        }
        throw new CacheException("underlying store is not an instance of TerracottaStore");
    }

    @Override
    public Element unlockedGetQuiet(Object key) {
        if (this.underlyingStore instanceof TerracottaStore) {
            return ((TerracottaStore)this.underlyingStore).unlockedGetQuiet(key);
        }
        throw new CacheException("underlying store is not an instance of TerracottaStore");
    }

    @Override
    public Set getLocalKeys() {
        if (this.underlyingStore instanceof TerracottaStore) {
            return ((TerracottaStore)this.underlyingStore).getLocalKeys();
        }
        throw new CacheException("underlying store is not an instance of TerracottaStore");
    }
}

