/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.dispatcher.StrutsResultSupport;

public class PlainTextResult
extends StrutsResultSupport {
    public static final int BUFFER_SIZE = 1024;
    private static final Logger LOG = LoggerFactory.getLogger(PlainTextResult.class);
    private static final long serialVersionUID = 3633371605905583950L;
    private String charSet;

    public PlainTextResult() {
    }

    public PlainTextResult(String location) {
        super(location);
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        Charset charset = this.readCharset();
        HttpServletResponse response = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        this.applyCharset(charset, response);
        this.applyAdditionalHeaders(response);
        String location = this.adjustLocation(finalLocation);
        PrintWriter writer = response.getWriter();
        InputStreamReader reader = null;
        try {
            InputStream resourceAsStream = this.readStream(invocation, location);
            this.logWrongStream(finalLocation, resourceAsStream);
            reader = charset != null ? new InputStreamReader(resourceAsStream, charset) : new InputStreamReader(resourceAsStream);
            if (resourceAsStream != null) {
                this.sendStream(writer, reader);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    protected InputStream readStream(ActionInvocation invocation, String location) {
        ServletContext servletContext = (ServletContext)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.ServletContext");
        return servletContext.getResourceAsStream(location);
    }

    protected void logWrongStream(String finalLocation, InputStream resourceAsStream) {
        if (resourceAsStream == null && LOG.isWarnEnabled()) {
            LOG.warn("Resource at location [" + finalLocation + "] cannot be obtained (return null) from ServletContext !!! ", new String[0]);
        }
    }

    protected void sendStream(PrintWriter writer, InputStreamReader reader) throws IOException {
        int charRead;
        char[] buffer = new char[1024];
        while ((charRead = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, charRead);
        }
    }

    protected String adjustLocation(String location) {
        if (location.charAt(0) != '/') {
            return "/" + location;
        }
        return location;
    }

    protected void applyAdditionalHeaders(HttpServletResponse response) {
        response.setHeader("Content-Disposition", "inline");
    }

    protected void applyCharset(Charset charset, HttpServletResponse response) {
        if (charset != null) {
            response.setContentType("text/plain; charset=" + this.charSet);
        } else {
            response.setContentType("text/plain");
        }
    }

    protected Charset readCharset() {
        Charset charset = null;
        if (this.charSet != null) {
            if (Charset.isSupported(this.charSet)) {
                charset = Charset.forName(this.charSet);
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("charset [" + this.charSet + "] is not recognized ", new String[0]);
                }
                charset = null;
            }
        }
        return charset;
    }
}

