﻿/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Button 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Button 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {
	
	// 初始化按钮
	function initButton(obj) {
		var opts = $(obj).data("button").options;
		$(obj).empty();
		$(obj).addClass("exmayui-button");
		if (opts.plain) {
			$(obj).addClass("exmayui-button-plain");
		} else {
			$(obj).removeClass("exmayui-button-plain");
		}
		if (opts.text) {
			$(obj).html(opts.text).wrapInner('<span class="exmayui-button-left"><span class="exmayui-button-text"></span></span>');
			if (opts.icon) {
				$(obj).find(".exmayui-button-text").addClass(opts.icon).css("padding-left", "20px");
			}
		} else {
			$(obj).html("&nbsp;").wrapInner('<span class="exmayui-button-left"><span class="exmayui-button-text"><span class="exmayui-button-empty"></span></span></span>');
			if (opts.icon) {
				$(obj).find(".exmayui-button-empty").addClass(opts.icon);
			}
		}
		if(opts.type == "splitbutton") {
			$("span.exmayui-button-text", obj).append('<span class="exmayui-button-split-downarrow">&nbsp;</span>');
			$(obj).removeClass("exmayui-button-split-active exmayui-button-split-plain-active");
			var $buttonArrow = $(obj).find(".exmayui-button-split-downarrow");
			$buttonArrow.unbind(".splitbutton");
			if (opts.disabled == false) {
				$(obj).hover(function(){
					$(obj).addClass((opts.plain==true) ? 'exmayui-button-split-plain-active' : 'exmayui-button-split-active');
				},function(){
					$(obj).removeClass((opts.plain==true) ? 'exmayui-button-split-plain-active' : 'exmayui-button-split-active');
				});
				$buttonArrow.bind("click.splitbutton", function() {
					var left = $(obj).offset().left;
					var top = $(obj).offset().top;
					var height = $(obj).outerHeight();
					$(opts.menu).exmayMenu("show", {left : left, top : top + height});
					return false;
				});
			}
		}
	
		if(opts.type == "menubutton") {
			$("span.exmayui-button-text", obj).append('<span class="exmayui-button-split-downarrow">&nbsp;</span>');
			$(obj).removeClass("exmayui-button-split-active exmayui-button-split-plain-active");
			var $buttonArrow = $(obj).find(".exmayui-button-split-downarrow");
			$(obj).unbind(".splitbutton");
			if (opts.disabled == false) {
				$(obj).hover(function(){
					$(obj).addClass((opts.plain==true) ? 'exmayui-button-split-plain-active' : 'exmayui-button-split-active');
				},function(){
					$(obj).removeClass((opts.plain==true) ? 'exmayui-button-split-plain-active' : 'exmayui-button-split-active');
				});
				$(obj).bind("click.splitbutton", function() {
					var left = $(obj).offset().left;
					var top = $(obj).offset().top;
					var height = $(obj).outerHeight();
					$(opts.menu).exmayMenu("show", {left : left, top : top + height});
					return false;
				});
			}
		}
		
		if(opts.type == "togglebutton") {
			$(obj).bind("click.togglebutton", function() { 
				$(obj).toggleClass("exmayui-button-pressed");
			});
		}
	
		disableButton(obj, opts.disabled);
	};
	
	// 初始化按钮事件
	function initExmayButtonEvents(target){
		var opts = $(target).data("button").options;
		$(target).click(function(){
			var isDisable = $(target).hasClass("exmayui-button-disabled");
			if(opts.onClick && !isDisable) {
				opts.onClick.call(target);
			}
		});
	};
	
	// 启用禁用按钮
	function disableButton(obj, isDisable) {
		var cache = $(obj).data("button");
		if (isDisable) {
			cache.options.disabled = true;
			var href = $(obj).attr("href");
			if (href) {
				cache.href = href;
				$(obj).attr("href", "javascript:;");
			}
			var onclick = $(obj).attr("onclick");
			if (onclick) {
				cache.onclick = onclick;
				$(obj).attr("onclick", null);
			}
			$(obj).addClass("exmayui-button-disabled");
		} else {
			if (cache.href) {
				$(obj).attr("href", cache.href);
			}
			if (cache.onclick) {
				obj.onclick = cache.onclick;
			}
			$(obj).removeClass("exmayui-button-disabled");
		}
	};
	
	// 获取选项值
	function getOptions($obj) {
		return {
			type : $obj.attr("type"),
			disabled : ($obj.attr("disabled") ? true : undefined),
			plain : ($obj.attr("plain") ? $obj.attr("plain") == "true" : undefined),
			text : $.trim($obj.html()),
			icon : $obj.attr("icon"),
			menu : $obj.attr("menu")
		}
	};
	
	// 清除属性参数
	function removeAttrData($obj) {
		if($obj.attr("type")) {
			$obj.removeAttr("type");
		}
		if($obj.attr("icon")) {
			$obj.removeAttr("icon");
		}
		if($obj.attr("plain")) {
			$obj.removeAttr("plain");
		}
		if($obj.attr("menu")) {
			$obj.removeAttr("menu");
		}
	};
	
	function exmaySetButtonText(target,data) {
		var $target = $(target);
		var cache = $target.data("button");
		if(data) {
			cache.options = $.extend(cache.options, {text : data});
			$(".exmayui-button-text", target).html(data);
		}
	};
	
	$.fn.exmayButton = function(options,data) {
		
		if (typeof options == "string") {
			switch (options) {
			case "options":
				return $(this).data("button").options;
			case "enable":
				return this.each(function() {
					disableButton(this, false);
				});
			case "disable":
				return this.each(function() {
					disableButton(this, true);
				});
			case "setText":
				exmaySetButtonText(this,data);
			}
		}
		
		options = options || {};
		
		return this.each(function() {
			var $this = $(this);  
			// 定义缓存
			var cache = $this.data("button");
			// 定义选项
			var opts = null;
			if (cache) {
				opts = $.extend(cache.options, options || {});
				cache.options = opts;
			} else {
				opts = $.extend( {}, $.fn.exmayButton.defaults, getOptions($this), options || {});
				removeAttrData($this);
				$this.data("button", { options : opts });
				$this.removeAttr("disabled");
				initButton(this);
				initExmayButtonEvents(this);
			}
		});
	};
	
	$.fn.exmayButton.defaults = {
		type : "button", // 按钮类型
//(普通按钮:button/分隔按钮:splitbutton/菜单按钮:menubutton/切换按钮(开关按钮):togglebutton/单选按钮:radiobutton/复选按键:checkboxbutton/工具栏按钮:toobarbutton/窗口按钮:windowbutton)
		disabled : false,  // 是否禁用
		plain : false,  //　是否简单
		text : "",  //　文本
		icon : null,  // 图标样式
		menu : "null", // 菜单,
		onClick : function(){}
	};
	
})(jQuery);