/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Changable 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Changable 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {
	// 初始化验证器
	function initExmayChangable(target) {

	};

	function bindExmayChangableEvents(target) {
		if ("\v" == "v") {
			target.onpropertychange = function(){
				exmayChange(target);
			};
		} else {
			target.addEventListener("input", function(){
				exmayChange(target);
			}, false);
		}
	}
	;

	function exmayChange(target) {
		var $target = $(target);
		var opts = $target.data("exmayChangable").options;
		if (opts.onChange) {
			opts.onChange.call(target);
		}
	}

	// 客户端校验器
	$.fn.exmayChangable = function(options, data) {
		// 方法调用
		if (typeof options == "string") {
			return $.fn.exmayChangable.methods[options](this, data);
		}

		this.each(function() {
			var $this = $(this);
			var opts = null;
			var cache = $this.data("exmayChangable");
			if (cache) {
				opts = $.extend(cache.options, options);
				cache.options = opts;
			} else {
				opts = $.extend( {}, $.fn.exmayChangable.defaults, $.fn.exmayChangable.parseOptions($this), options);
				$this.data("exmayChangable", {
					options : opts
				});
				initExmayChangable(this);
				bindExmayChangableEvents(this);
			}
		});

	};

	// 插件方法
	$.fn.exmayChangable.methods = {
		change : function(target,data) {
			if ("\v" != "v") {
				exmayChange(target);
			}
		}
	};

	// 解析插件属性
	$.fn.exmayChangable.parseOptions = function(target) {
		var $target = $(target);
		return {

		}
	};

	$.fn.exmayChangable.defaults = {
		onChange : function() {
		}
	};

})(jQuery);