/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Checkbox 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Checkbox 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

//
// [Checkbox插件]
//
(function($) {

	// 初始化复选框
	function initExmayChecked(target, opts) {
		$(target).hide();
		var $checkbox = $('<span class="exmayui-checkbox-icon"></span>');
		$checkbox.addClass("exmayui-checkbox-unchecked");
		$checkbox.insertBefore($(target));
		if ($(target).attr("id")) {
			$("label[for='" + $(target).attr("id") + "']").addClass("exmayui-checkbox-text");
		}
		if ($(target).attr("checked")) {
			$checkbox.removeClass("exmayui-checkbox-unchecked").addClass("exmayui-checkbox-checked");
		}
		if ($(target).attr("title")) {
			$checkbox.attr("title", $(target).attr("title"));
		}
		if (opts.disabled) {
			$checkbox.addClass("exmayui-checkbox-disabled");
		}
	}
	;

	// 复选框事件绑定
	function bindExmayCheckboxEvents(target) {
		var $target = $(target);
		var opts = $target.data("checkbox").options;

		// 复选框改变
		$(target).bind("change.exmayCheckbox", function() {
			$(target).prev(".exmayui-checkbox-icon").trigger("");
		});

		// 复选图标
		$(target).prev(".exmayui-checkbox-icon").bind("click.exmayCheckbox", function() {
			var isChecked = false;
			var name = $(target).attr("name");
			var isAll = $(target).hasClass("exmayui-checkbox-all");
			var isInvert = $(target).hasClass("exmayui-checkbox-invert");
			var names = null;
			if (isAll || isInvert) {
				names = $(target).attr("names");
			}
			// 复选判断
				if ($(this).hasClass("exmayui-checkbox-checked")) { // 取消选中
					exmayUnchecked(target);
					if (isAll) {
						exmayUncheckedAll(target, names);
					} else if (isInvert) {
						exmayCheckedInvert(target, names);
					} else {
						$(".exmayui-checkbox-all").each(function() {
							if ($(this).attr("names") == name)
								exmayUnchecked(this);
						});
						$(".exmayui-checkbox-invert").each(function() {
							if ($(this).attr("names") == name)
								exmayUnchecked(this);
						});
						isChecked = hasChecked(name);
						if(names != null) {
							isChecked = hasChecked(names);
						}
					}
				} else { //　选中
					exmaySetChecked(target);
					isChecked = true;
					if (isAll) { // 全选
						exmayCheckedAll(target, names);
						$(".exmayui-checkbox-invert").each(function() {
							if ($(this).attr("names") == names)
								exmayUnchecked(this);
						});
						$(".exmay-ui-tr").find("td").css("backgroundColor","#FFFFD4");
					} else if (isInvert) {
						exmayCheckedInvert(target, names);
						$(".exmayui-checkbox-all").each(function() {
							if ($(this).attr("names") == names)
								exmayUnchecked(this);
						});
						
					} else {
						$(".exmayui-checkbox-invert").each(function() {
							if ($(this).attr("names") == name)
								exmayUnchecked(this);
						});
					}
				}
				
				/*if(opts.onChange) {
					opts.onChange.call(target, isChecked);
				}*/
				
				return false;
			}).hover(function(){
				$(".exmayui-selectable").exmaySelectable({checkbox : true});
			},function(){
				$(".exmayui-selectable").exmaySelectable({checkbox : false});
			});

		// 复选框文本
		$(target).next(".exmayui-checkbox-text").bind("click.exmayCheckbox", function(e) {
			if ($.browser.msie) {
				$(target).prev(".exmayui-checkbox-icon").trigger("click");
			}
		});

	}
	;

	// 取消已绑定的事件
	function unbindExmayCheckboxEvents(target) {
		$(target).unbind(".exmayCheckbox");
		$(target).prev(".exmayui-checkbox-icon").unbind(".exmayCheckbox");
		$(target).next(".exmayui-checkbox-text").unbind(".exmayCheckbox");
	};

	// 全选
	function exmayCheckedAll(target, name) {
		if (name == null) {
			name = $(target).attr("name");
		}
		var $checkboxs = $("input[type='checkbox'][name='" + name + "']");
		$checkboxs.attr("checked", true);
		//$("input[type='checkbox'][name='" + name + "']").prev(".exmayui-checkbox-icon").removeClass("exmayui-checkbox-unchecked").addClass("exmayui-checkbox-checked");
		//exmaySetChecked($checkboxs);
		$checkboxs.each(function(i){
			exmaySetChecked($(this));
			if(i == 0) {
				var opts = $(this).data("checkbox").options;
				if(opts.onChange) {
					opts.onChange.call(target, true);
				}
			}
		});
	}
	;

	// 全不选
	function exmayUncheckedAll(target, name) {
	
		if (name == null) {
			name = $(target).attr("name");
		}
		var $checkboxs = $("input[type='checkbox'][name='" + name + "']");
		$checkboxs.removeAttr("checked");
		//$("input[type='checkbox'][name='" + name + "']").prev(".exmayui-checkbox-icon").removeClass("exmayui-checkbox-checked").addClass("exmayui-checkbox-unchecked");
		//exmayUnchecked($checkboxs);
		$checkboxs.each(function(i){
			exmayUnchecked($(this));
			if(i == 0) {
				var opts = $(this).data("checkbox").options;
				if(opts.onChange) {
					opts.onChange.call(target, false);
				}
			}
		});
	}
	;
	
	// 反选
	function exmayCheckedInvert(target, name) {
//		if (name == null) {
//			name = $(target).attr("name");
//		}
		var $checkboxs = $("input[type='checkbox'][name='" + name + "']");
//		var uncheckedSize = $checkboxs.length - exmayCheckedSize(name);
		
		var isFirstChecked = true;
		var uncheckedIndex = 0;
		$checkboxs.each(function(i) {
			if ($(this).attr("checked")) {
				$(this).removeAttr("checked");
				exmayUnchecked($(this));
				uncheckedIndex++;
				if(uncheckedIndex==$checkboxs.length) {
					var opts = $(this).data("checkbox").options;
					if(opts.onChange) {
						opts.onChange.call(target, false);
					}
				}
			} else {
				$(this).attr("checked", true);
				exmaySetChecked($(this));
				if(isFirstChecked) {
					var opts = $(this).data("checkbox").options;
					if(opts.onChange) {
						opts.onChange.call(target, true);
					}
				}
				isFirstChecked = false;
			}
		});

	}
	;

	// 取出选中
	function exmayGetChecked(name) {
		var value = [];
		var text = [];
		$("input[type='checkbox'][name='" + name + "']:checked").each(function() {
			value.push($(this).val());
			text.push($(this).next(".exmayui-checkbox-text").text());
		});
		return {
			value : value,
			text : text
		};
	};
	
	// 加入document兼容弹出框
	// 取出选中
	function exmayGetCheckedItems(document, name) {
		return $("input[type='checkbox'][name='" + name + "']:checked", document);
	};
	
	// 被选中的个数
	function exmayCheckedSize(name) {
		return $("input[type='checkbox'][name='" + name + "']:checked").length;
	}
	
	// 是否有选中项
	function hasChecked(name) {
		return exmayCheckedSize(name) != 0;
	}

	// 设置选中
	function exmaySetChecked(target) {
		var $target = $(target);
		var opts ={};
		if($target.data("checkbox")!=undefined){
			opts = $target.data("checkbox").options;
		}
		var name = $target.attr("name");
		var $proxy = $target.prev(".exmayui-checkbox-icon");
			
		$target.attr("checked", true);
		$proxy.removeClass("exmayui-checkbox-unchecked").addClass("exmayui-checkbox-checked");
		
		if (opts.onClick) {
			opts.onClick.call(target, {
				name : name,
				isChecked : true,
				item : $proxy
			});
		}
		
		if(opts.onChange) {
			opts.onChange.call(target, true);
		}
		
	}
	;
	
	

	// 取消选中
	function exmayUnchecked(target) {
		var $target = $(target);
		var opts ={};
		if($target.data("checkbox")!=undefined){
			opts = $target.data("checkbox").options;
		}
		var name = $target.attr("name");
		var $proxy = $target.prev(".exmayui-checkbox-icon");
		
		$(target).attr("checked", false);
		$proxy.removeClass("exmayui-checkbox-checked").addClass("exmayui-checkbox-unchecked");

		if (opts.onClick) {
			opts.onClick.call(target, {
				name : name,
				isChecked : false,
				item : $proxy
			});
		}
		if(opts.onChange) {
			opts.onChange.call(target, false);
		}
	}
	;

	// 启用
	function exmayEnableCheckbox(target) {
		$(target).removeAttr("disabled");
		$(target).prev(".exmayui-checkbox-icon").removeClass("exmayui-checkbox-disabled");
		bindExmayCheckboxEvents(target);
	}
	;

	// 禁用
	function exmayDisableCheckbox(target) {
		$(target).attr("disabled", true);
		$(target).prev(".exmayui-checkbox-icon").addClass("exmayui-checkbox-disabled");
		unbindExmayCheckboxEvents(target);
	}
	;

	// 点击事件
	function exmayClickCheckbox(target) {
		$(target).prev(".exmayui-checkbox-icon").trigger("click");
	}
	;

	//  
	// 复选框插件的定义
	//  
	$.fn.exmayCheckbox = function(options, data) {

		// 方法调用
		if (typeof options == "string") {
			return $.fn.exmayCheckbox.methods[options](this, data);
		}

		//
		// 复选框插件主方法
		//
		return this.each(function() {
			$this = $(this);
			// 定义选项
				var opts = null;
				// 将数据缓存赋值给缓存
				var cache = $this.data("checkbox");
				// 如果数据已缓存
				if (cache) {
					// 通过数据缓存为选项赋值
					opts = $.extend(cache.options, options || {});
				} else {
					// 重新初始化选项
					opts = $.extend( {}, $.fn.exmayCheckbox.defaults, $.fn.exmayCheckbox.parseOptions(this), options || {});
					// 初始化
					initExmayChecked(this, opts);
					// 对数据进行缓存
					$this.data("checkbox", {
						options : opts
					});
				if (!opts.disabled) {
					// 清除绑定的事件
					unbindExmayCheckboxEvents(this);
					// 绑定事件
					bindExmayCheckboxEvents(this);
				}
				}
			});
	};

	//
	// 复选框插件的方法
	//
	$.fn.exmayCheckbox.methods = {
		checkedInvert : function(target, data) {// 反选
			return exmayCheckedInvert(target, data);
		},
		checkedAll : function(target, data) { // 全选
			return exmayCheckedAll(target, data);
		},
		uncheckedAll : function(target, data) { // 全不选
			return exmayUncheckedAll(target, data);
		},
		getChecked : function(target, data) {//　选中
			return exmayGetChecked(data);
		},
		getCheckedItems : function(document, data) {//　选中项
			return exmayGetCheckedItems(document, data);
		},
		setChecked : function(target, data) { //设选中
			return exmaySetChecked(target);
		},
		setCheckeds : function(target, data) { //设选中
			return exmaySetChecked(target,data);
		},
		checkedSize : function(target, data) { //选中个数
			return exmayCheckedSize(data);
		},
		unchecked : function(target, data) {// 取消选中
			return exmayUnchecked(target);
		},
		enable : function(target) {//　启用
			return exmayEnableCheckbox(target);
		},
		disable : function(target) { // 禁用
			return exmayDisableCheckbox(target);
		},
		click : function(target) { //点击
			return exmayClickCheckbox(target);
		}
	};

	//
	// 解析复选框选项
	// 
	$.fn.exmayCheckbox.parseOptions = function(target) {
		var $target = $(target);
		return {
			disabled : $(target).attr("disabled")
		}
	};

	//  
	// 复选框插件的属性
	//  
	$.fn.exmayCheckbox.defaults = {
		disabled : false,
		onClick : function(isChecked) {
		},
		onChange : function(hasChecked) {
		}
	};

})(jQuery);
//
// [/Checkbox插件]
//