/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Date 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Date 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {
	
	$.exmayLoader.load(Exmay.path.framework + "/date/WdatePicker.js");
	
	function bindExmayDateGobalEvents(target){
		var $target = $(target);
		var opts = $target.data("exmayDate").options;
		var dateFmt  = opts.dateFmt;
		
		if(opts.dateType == "dateTime") {
			dateFmt = "yyyy-MM-dd HH:mm:ss";
		}
		
		$target.addClass("Wdate");
		$target.bind("focus",function(){
			if(opts.minDate!=undefined){	
				WdatePicker({skin:'exmay',dateFmt:dateFmt,minDate:opts.minDate});
			}
			if(opts.maxDate!=undefined){	
				WdatePicker({skin:'exmay',dateFmt:dateFmt,maxDate:opts.maxDate});
			}
		});		
		if(opts.init){
			$target.val(new Date().format("yyyy-MM-dd hh:mm:ss"));
		}
		
	}	
	$.fn.exmayDate = function(options, data) {
		if (typeof options == "string") {
			return $.fn.exmayDate.methods[options](this, data);
		}

		this.each(function() {
			var $this = $(this);
			var opts = null;
			var cache = $this.data("exmayDate");
			if (cache) {
				opts = $.extend(cache.options, options);
				cache.options = opts;
			} else {
				opts = $.extend( {}, $.fn.exmayDate.defaults,
						$.fn.exmayDate.parseOptions($this), options);
				$this.data("exmayDate", {
					options : opts
				});
				bindExmayDateGobalEvents(this);
			}
		});
	};

	// 插件方法
	$.fn.exmayDate.methods = {};

	// 解析插件属性
	$.fn.exmayDate.parseOptions = function(target) {
		var $target = $(target);
		return {
			dateFmt : $target.attr("dateFmt"),
			dateType : $target.attr("dateType"),
			maxDate:$target.attr("maxDate"),
			minDate:$target.attr("minDate"),
			init : ($target.attr("init") ? $target.attr("init") == "true" : undefined)
		};
	};

	$.fn.exmayDate.defaults = {
		dateFmt:"yyyy-MM-dd",
		dateType : "date",
		maxDate:"",
		minDate:"",
		init:true
	};

})(jQuery);